/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.util.ArrayList;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.BYOKUnwrapFactory;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.connettori.ConnettoreCheck;
import org.openspcoop2.pdd.core.jmx.JMXUtils;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.registry.CertificateCheck;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.registry.RegistroServiziReader;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.transport.http.IBYOKUnwrapFactory;
import org.slf4j.Logger;

public class AccessoRegistroServizi
extends NotificationBroadcasterSupport
implements DynamicMBean {
    public static final String REGISTRI_SERVIZI = "registriServizi";
    public static final String CHECK_CONNETTORE_BY_ID = "checkConnettoreById";
    public static final String CHECK_CONNETTORE_BY_NOME = "checkConnettoreByNome";
    public static final String CHECK_CERTIFICATI_CONNETTORE_HTTPS_BY_ID = "checkCertificatiConnettoreHttpsById";
    public static final String GET_CERTIFICATI_CONNETTORE_BY_ID = "getCertificatiConnettoreById";
    public static final String GET_CERTIFICATI_CONNETTORE_BY_NOME = "getCertificatiConnettoreByNome";
    public static final String CHECK_CERTIFICATO_SOGGETTO_BY_ID = "checkCertificatoSoggettoById";
    public static final String CHECK_CERTIFICATO_SOGGETTO_BY_NOME = "checkCertificatoSoggettoByNome";
    public static final String CHECK_CERTIFICATI_MODI_EROGAZIONE_BY_ID = "checkCertificatiModIErogazioneById";
    public static final String CHECK_CERTIFICATI_MODI_FRUIZIONE_BY_ID = "checkCertificatiModIFruizioneById";
    private boolean cacheAbilitata = false;
    private String[] registriServizi = null;
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    private Logger logConnettori = OpenSPCoop2Logger.getLoggerOpenSPCoopConnettori();
    ConfigurazionePdDManager configReader = ConfigurazionePdDManager.getInstance();
    OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals("cacheAbilitata")) {
            return this.cacheAbilitata;
        }
        if (attributeName.equals(REGISTRI_SERVIZI)) {
            return this.registriServizi;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block10: {
            if (attribute == null) {
                throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
            }
            try {
                if (attribute.getName().equals("cacheAbilitata")) {
                    boolean v = (Boolean)attribute.getValue();
                    if (v) {
                        if (!this.cacheAbilitata) {
                            this.abilitaCache();
                        }
                    } else if (this.cacheAbilitata) {
                        this.disabilitaCache();
                    }
                    break block10;
                }
                if (attribute.getName().equals(REGISTRI_SERVIZI)) {
                    this.registriServizi = (String[])attribute.getValue();
                    break block10;
                }
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
            catch (ClassCastException ce) {
                throw new InvalidAttributeValueException("il tipo " + attribute.getValue().getClass() + " dell'attributo " + attribute.getName() + " non e' valido");
            }
            catch (JMException j) {
                throw new MBeanException(j);
            }
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException jMException) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals("resetCache")) {
            return this.resetCache();
        }
        if (actionName.equals("prefillCache")) {
            return this.prefillCache();
        }
        if (actionName.equals("printStatsCache")) {
            return this.printStatCache();
        }
        if (actionName.equals("disabilitaCache")) {
            return this.disabilitaCacheConEsito();
        }
        if (actionName.equals("abilitaCache")) {
            if (params.length != 4) {
                throw new MBeanException(new Exception("[AbilitaCache] Lunghezza parametri non corretta: " + params.length));
            }
            Long param1 = null;
            if (params[0] != null && !"".equals(params[0]) && (param1 = (Long)params[0]) < 0L) {
                param1 = null;
            }
            Boolean param2 = null;
            if (params[1] != null && !"".equals(params[1])) {
                param2 = (Boolean)params[1];
            }
            Long param3 = null;
            if (params[2] != null && !"".equals(params[2]) && (param3 = (Long)params[2]) < 0L) {
                param3 = null;
            }
            Long param4 = null;
            if (params[3] != null && !"".equals(params[3]) && (param4 = (Long)params[3]) < 0L) {
                param4 = null;
            }
            return this.abilitaCache(param1, param2, param3, param4);
        }
        if (actionName.equals("listKeysCache")) {
            return this.listKeysCache();
        }
        if (actionName.equals("getObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[getObjectCache] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.getObjectCache(param1);
        }
        if (actionName.equals("removeObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[removeObjectCache] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.removeObjectCache(param1);
        }
        if (actionName.equals(CHECK_CONNETTORE_BY_ID)) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[checkConnettoreById] Lunghezza parametri non corretta: " + params.length));
            }
            Long param1 = null;
            if (params[0] != null && !"".equals(params[0]) && (param1 = params[0] instanceof Long ? (Long)params[0] : Long.valueOf(params[0].toString())) < 0L) {
                param1 = null;
            }
            if (param1 == null) {
                throw new MBeanException(new Exception("[checkConnettoreById] parametro richiesto non fornito"));
            }
            return this.checkConnettoreById(param1);
        }
        if (actionName.equals(CHECK_CONNETTORE_BY_NOME)) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[checkConnettoreByNome] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.checkConnettoreByNome(param1);
        }
        if (actionName.equals(GET_CERTIFICATI_CONNETTORE_BY_ID)) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[getCertificatiConnettoreById] Lunghezza parametri non corretta: " + params.length));
            }
            Long param1 = null;
            if (params[0] != null && !"".equals(params[0]) && (param1 = params[0] instanceof Long ? (Long)params[0] : Long.valueOf(params[0].toString())) < 0L) {
                param1 = null;
            }
            if (param1 == null) {
                throw new MBeanException(new Exception("[getCertificatiConnettoreById] parametro richiesto non fornito"));
            }
            return this.getCertificatiConnettoreById(param1);
        }
        if (actionName.equals(GET_CERTIFICATI_CONNETTORE_BY_NOME)) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[getCertificatiConnettoreByNome] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.getCertificatiConnettoreByNome(param1);
        }
        if (actionName.equals(CHECK_CERTIFICATI_CONNETTORE_HTTPS_BY_ID)) {
            if (params.length != 2) {
                throw new MBeanException(new Exception("[checkCertificatiConnettoreHttpsById] Lunghezza parametri non corretta: " + params.length));
            }
            Long param1 = null;
            if (params[0] != null && !"".equals(params[0]) && (param1 = params[0] instanceof Long ? (Long)params[0] : Long.valueOf(params[0].toString())) < 0L) {
                param1 = null;
            }
            int soglia = -1;
            soglia = params[1] instanceof Integer ? ((Integer)params[1]).intValue() : Integer.valueOf(params[1].toString()).intValue();
            if (param1 == null) {
                throw new MBeanException(new Exception("[checkCertificatiConnettoreHttpsById] parametro richiesto non fornito"));
            }
            return this.checkCertificatiConnettoreHttpsById(param1, soglia);
        }
        if (actionName.equals(CHECK_CERTIFICATO_SOGGETTO_BY_ID)) {
            if (params.length != 2) {
                throw new MBeanException(new Exception("[checkCertificatoSoggettoById] Lunghezza parametri non corretta: " + params.length));
            }
            Long param1 = null;
            if (params[0] != null && !"".equals(params[0]) && (param1 = params[0] instanceof Long ? (Long)params[0] : Long.valueOf(params[0].toString())) < 0L) {
                param1 = null;
            }
            int soglia = -1;
            soglia = params[1] instanceof Integer ? ((Integer)params[1]).intValue() : Integer.valueOf(params[1].toString()).intValue();
            if (param1 == null) {
                throw new MBeanException(new Exception("[checkCertificatoSoggettoById] parametro richiesto non fornito"));
            }
            return this.checkCertificatoSoggettoById(param1, soglia);
        }
        if (actionName.equals(CHECK_CERTIFICATO_SOGGETTO_BY_NOME)) {
            if (params.length != 2) {
                throw new MBeanException(new Exception("[checkCertificatoSoggettoByNome] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            int soglia = -1;
            soglia = params[1] instanceof Integer ? ((Integer)params[1]).intValue() : Integer.valueOf(params[1].toString()).intValue();
            if (param1 == null) {
                throw new MBeanException(new Exception("[checkCertificatoSoggettoByNome] parametro richiesto non fornito"));
            }
            return this.checkCertificatoSoggettoByNome(param1, soglia);
        }
        if (actionName.equals(CHECK_CERTIFICATI_MODI_EROGAZIONE_BY_ID)) {
            if (params.length != 2) {
                throw new MBeanException(new Exception("[checkCertificatiModIErogazioneById] Lunghezza parametri non corretta: " + params.length));
            }
            Long param1 = null;
            if (params[0] != null && !"".equals(params[0]) && (param1 = params[0] instanceof Long ? (Long)params[0] : Long.valueOf(params[0].toString())) < 0L) {
                param1 = null;
            }
            int soglia = -1;
            soglia = params[1] instanceof Integer ? ((Integer)params[1]).intValue() : Integer.valueOf(params[1].toString()).intValue();
            if (param1 == null) {
                throw new MBeanException(new Exception("[checkCertificatiModIErogazioneById] parametro richiesto non fornito"));
            }
            return this.checkCertificatiModIErogazioneById(param1, soglia);
        }
        if (actionName.equals(CHECK_CERTIFICATI_MODI_FRUIZIONE_BY_ID)) {
            if (params.length != 2) {
                throw new MBeanException(new Exception("[checkCertificatiModIFruizioneById] Lunghezza parametri non corretta: " + params.length));
            }
            Long param1 = null;
            if (params[0] != null && !"".equals(params[0]) && (param1 = params[0] instanceof Long ? (Long)params[0] : Long.valueOf(params[0].toString())) < 0L) {
                param1 = null;
            }
            int soglia = -1;
            soglia = params[1] instanceof Integer ? ((Integer)params[1]).intValue() : Integer.valueOf(params[1].toString()).intValue();
            if (param1 == null) {
                throw new MBeanException(new Exception("[checkCertificatiModIFruizioneById] parametro richiesto non fornito"));
            }
            return this.checkCertificatiModIFruizioneById(param1, soglia);
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        String className = this.getClass().getName();
        String description = "Risorsa per la configurazione dell'accesso al registri dei servizi (" + OpenSPCoop2Properties.getInstance().getVersione() + ")";
        MBeanAttributeInfo cacheAbilitataVAR = JMXUtils.MBEAN_ATTRIBUTE_INFO_CACHE_ABILITATA;
        MBeanAttributeInfo registriServiziVAR = new MBeanAttributeInfo(REGISTRI_SERVIZI, String[].class.getName(), "Elenco dei registri dei servizi utilizzati a RunTime da GovWay", true, false, false);
        MBeanOperationInfo resetCacheOP = JMXUtils.MBEAN_OPERATION_RESET_CACHE;
        MBeanOperationInfo prefillCacheOP = JMXUtils.MBEAN_OPERATION_PREFILL_CACHE;
        MBeanOperationInfo printStatCacheOP = JMXUtils.MBEAN_OPERATION_PRINT_STATS_CACHE;
        MBeanOperationInfo disabilitaCacheOP = JMXUtils.MBEAN_OPERATION_DISABILITA_CACHE;
        MBeanOperationInfo abilitaCacheParametriOP = JMXUtils.MBEAN_OPERATION_ABILITA_CACHE_CON_PARAMETRI;
        MBeanOperationInfo listKeysCacheOP = JMXUtils.MBEAN_OPERATION_LIST_KEYS_CACHE;
        MBeanOperationInfo getObjectCacheOP = JMXUtils.MBEAN_OPERATION_GET_OBJECT_CACHE;
        MBeanOperationInfo removeObjectCacheOP = JMXUtils.MBEAN_OPERATION_REMOVE_OBJECT_CACHE;
        MBeanOperationInfo checkConnettoreById = new MBeanOperationInfo(CHECK_CONNETTORE_BY_ID, "Verifica la raggiungibilit\u00e0 del connettore con id fornito come parametro", new MBeanParameterInfo[]{new MBeanParameterInfo("idConnettore", Long.TYPE.getName(), "Identificativo del connettore")}, String.class.getName(), 1);
        MBeanOperationInfo checkConnettoreByNome = new MBeanOperationInfo(CHECK_CONNETTORE_BY_NOME, "Verifica la raggiungibilit\u00e0 del connettore con nome fornito come parametro", new MBeanParameterInfo[]{new MBeanParameterInfo("nomeConnettore", String.class.getName(), "Nome del connettore")}, String.class.getName(), 1);
        MBeanOperationInfo getCertificatiConnettoreById = new MBeanOperationInfo(GET_CERTIFICATI_CONNETTORE_BY_ID, "Recupera i certificati server del connettore con id fornito come parametro", new MBeanParameterInfo[]{new MBeanParameterInfo("idConnettore", Long.TYPE.getName(), "Identificativo del connettore")}, String.class.getName(), 1);
        MBeanOperationInfo getCertificatiConnettoreByNome = new MBeanOperationInfo(GET_CERTIFICATI_CONNETTORE_BY_NOME, "Recupera i certificati server del connettore con nome fornito come parametro", new MBeanParameterInfo[]{new MBeanParameterInfo("nomeConnettore", String.class.getName(), "Nome del connettore")}, String.class.getName(), 1);
        MBeanOperationInfo checkCertificatiConnettoreHttpsById = new MBeanOperationInfo(CHECK_CERTIFICATI_CONNETTORE_HTTPS_BY_ID, "Verifica i certificati presenti nei keystore e truststore del connettore https che possiede l'id fornito come parametro", new MBeanParameterInfo[]{new MBeanParameterInfo("idConnettore", Long.TYPE.getName(), "Identificativo del connettore"), new MBeanParameterInfo("warningThreshold", Integer.TYPE.getName(), "Soglia di warning (giorni)")}, String.class.getName(), 1);
        MBeanOperationInfo checkCertificatoSoggettoById = new MBeanOperationInfo(CHECK_CERTIFICATO_SOGGETTO_BY_ID, "Verifica i certificati client associati al soggetto che possiede l'id fornito come parametro", new MBeanParameterInfo[]{new MBeanParameterInfo("idSoggetto", Long.TYPE.getName(), "Identificativo del soggetto"), new MBeanParameterInfo("warningThreshold", Integer.TYPE.getName(), "Soglia di warning (giorni)")}, String.class.getName(), 1);
        MBeanOperationInfo checkCertificatoSoggettoByNome = new MBeanOperationInfo(CHECK_CERTIFICATO_SOGGETTO_BY_NOME, "Verifica i certificati client associati al soggetto che possiede l'id fornito come parametro (formato: tipoSoggetto/nomeSoggetto)", new MBeanParameterInfo[]{new MBeanParameterInfo("idSoggetto", String.class.getName(), "Identificativo del soggetto"), new MBeanParameterInfo("warningThreshold", Integer.TYPE.getName(), "Soglia di warning (giorni)")}, String.class.getName(), 1);
        MBeanOperationInfo checkCertificatiModIErogazioneById = new MBeanOperationInfo(CHECK_CERTIFICATI_MODI_EROGAZIONE_BY_ID, "Verifica i certificati presenti nei keystore e truststore dell'erogazione che possiede l'id fornito come parametro", new MBeanParameterInfo[]{new MBeanParameterInfo("idErogazione", Long.TYPE.getName(), "Identificativo dell'erogazione"), new MBeanParameterInfo("warningThreshold", Integer.TYPE.getName(), "Soglia di warning (giorni)")}, String.class.getName(), 1);
        MBeanOperationInfo checkCertificatiModIFruizioneById = new MBeanOperationInfo(CHECK_CERTIFICATI_MODI_FRUIZIONE_BY_ID, "Verifica i certificati presenti nei keystore e truststore della fruizione che possiede l'id fornito come parametro", new MBeanParameterInfo[]{new MBeanParameterInfo("idFruizione", Long.TYPE.getName(), "Identificativo della fruizione"), new MBeanParameterInfo("warningThreshold", Integer.TYPE.getName(), "Soglia di warning (giorni)")}, String.class.getName(), 1);
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{cacheAbilitataVAR, registriServiziVAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        ArrayList<MBeanOperationInfo> listOperation = new ArrayList<MBeanOperationInfo>();
        listOperation.add(resetCacheOP);
        if (this.openspcoopProperties.isConfigurazioneCache_RegistryPrefill()) {
            listOperation.add(prefillCacheOP);
        }
        listOperation.add(printStatCacheOP);
        listOperation.add(disabilitaCacheOP);
        listOperation.add(abilitaCacheParametriOP);
        listOperation.add(listKeysCacheOP);
        listOperation.add(getObjectCacheOP);
        listOperation.add(removeObjectCacheOP);
        listOperation.add(checkConnettoreById);
        listOperation.add(checkConnettoreByNome);
        listOperation.add(getCertificatiConnettoreById);
        listOperation.add(getCertificatiConnettoreByNome);
        listOperation.add(checkCertificatiConnettoreHttpsById);
        listOperation.add(checkCertificatoSoggettoById);
        listOperation.add(checkCertificatoSoggettoByNome);
        listOperation.add(checkCertificatiModIErogazioneById);
        listOperation.add(checkCertificatiModIFruizioneById);
        MBeanOperationInfo[] operations = listOperation.toArray(new MBeanOperationInfo[1]);
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public AccessoRegistroServizi() {
        boolean bl = this.cacheAbilitata = this.configReader.getAccessoRegistroServizi().getCache() != null;
        if (this.configReader.getAccessoRegistroServizi().sizeRegistroList() > 0) {
            this.registriServizi = new String[this.configReader.getAccessoRegistroServizi().sizeRegistroList()];
            for (int i = 0; i < this.configReader.getAccessoRegistroServizi().sizeRegistroList(); ++i) {
                AccessoRegistroRegistro registro = this.configReader.getAccessoRegistroServizi().getRegistro(i);
                Object autenticazione = "";
                if (registro.getUser() != null || registro.getPassword() != null) {
                    autenticazione = " (user:" + registro.getUser() + " password:" + registro.getPassword() + ")";
                }
                this.registriServizi[i] = "Registro " + registro.getNome() + " di tipo " + registro.getTipo() + "," + (String)autenticazione + " location:" + registro.getLocation();
            }
        }
    }

    public boolean isCacheAbilitata() {
        return this.cacheAbilitata;
    }

    public String resetCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            RegistroServiziReader.resetCache();
            return "Operazione di reset effettuata con successo";
        }
        catch (Exception e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String prefillCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            RegistroServiziReader.prefillCache((CryptConfig)this.openspcoopProperties.getCryptConfigAutenticazioneSoggetti());
            return "Operazione pre-fill cache effettuata con successo";
        }
        catch (Exception e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String printStatCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            return RegistroServiziReader.printStatsCache((String)"\n");
        }
        catch (Exception e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void abilitaCache() {
        try {
            RegistroServiziReader.abilitaCache();
            this.cacheAbilitata = true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) {
        try {
            RegistroServiziReader.abilitaCache((Long)dimensioneCache, (Boolean)algoritmoCacheLRU, (Long)itemIdleTime, (Long)itemLifeSecond, (CryptConfig)this.openspcoopProperties.getCryptConfigAutenticazioneSoggetti());
            this.cacheAbilitata = true;
            return "Abilitazione cache effettuata con successo";
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void disabilitaCache() throws JMException {
        try {
            RegistroServiziReader.disabilitaCache();
            this.cacheAbilitata = false;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new JMException(e.getMessage());
        }
    }

    public String disabilitaCacheConEsito() {
        try {
            this.disabilitaCache();
            return "Disabilitazione cache effettuata con successo";
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String listKeysCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            return RegistroServiziReader.listKeysCache((String)"\n");
        }
        catch (Exception e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getObjectCache(String key) {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            return RegistroServiziReader.getObjectCache((String)key);
        }
        catch (Exception e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String removeObjectCache(String key) {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            RegistroServiziReader.removeObjectCache((String)key);
            return "Rimozione elemento dalla cache effettuata con successo";
        }
        catch (Exception e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String checkConnettoreById(long idConnettore) {
        try {
            ConnettoreCheck.check(idConnettore, true, this.logConnettori);
            return "Operazione effettuata con successo";
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String checkConnettoreByNome(String nomeConnettore) {
        try {
            ConnettoreCheck.check(nomeConnettore, true, this.logConnettori);
            return "Operazione effettuata con successo";
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getCertificatiConnettoreById(long idConnettore) {
        try {
            return ConnettoreCheck.getCertificati(idConnettore, true);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getCertificatiConnettoreByNome(String nomeConnettore) {
        try {
            return ConnettoreCheck.getCertificati(nomeConnettore, true);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String checkCertificatiConnettoreHttpsById(long idConnettore, int sogliaWarningGiorni) {
        try {
            boolean addCertificateDetails = true;
            String separator = ": ";
            String newLine = "\n";
            CertificateCheck statoCheck = RegistroServiziManager.getInstance().checkCertificatiConnettoreHttpsByIdWithoutCache(idConnettore, sogliaWarningGiorni, (IBYOKUnwrapFactory)new BYOKUnwrapFactory(), addCertificateDetails, separator, newLine);
            return statoCheck.toString(newLine);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String checkCertificatoSoggettoById(long idSoggetto, int sogliaWarningGiorni) {
        try {
            boolean addCertificateDetails = true;
            String separator = ": ";
            String newLine = "\n";
            CertificateCheck statoCheck = RegistroServiziManager.getInstance().checkCertificatoSoggettoWithoutCache(idSoggetto, sogliaWarningGiorni, addCertificateDetails, separator, newLine);
            return statoCheck.toString(newLine);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String checkCertificatoSoggettoByNome(String idSoggetto, int sogliaWarningGiorni) {
        try {
            if (!idSoggetto.contains("/")) {
                throw new CoreException("Formato non valido (tipoSoggetto/nomeSoggetto)");
            }
            String[] tmp = idSoggetto.split("/");
            if (tmp == null || tmp.length != 2 || tmp[0] == null || tmp[1] == null) {
                throw new CoreException("Formato non valido (tipoSoggetto/nomeSoggetto)");
            }
            String tipoSoggetto = tmp[0];
            String nomeSoggetto = tmp[1];
            IDSoggetto idSog = new IDSoggetto(tipoSoggetto, nomeSoggetto);
            boolean addCertificateDetails = true;
            String separator = ": ";
            String newLine = "\n";
            CertificateCheck statoCheck = RegistroServiziManager.getInstance().checkCertificatoSoggettoWithoutCache(idSog, sogliaWarningGiorni, addCertificateDetails, separator, newLine);
            return statoCheck.toString(newLine);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String checkCertificatiModIErogazioneById(long idErogazione, int sogliaWarningGiorni) {
        try {
            boolean addCertificateDetails = true;
            String separator = ": ";
            String newLine = "\n";
            CertificateCheck statoCheck = RegistroServiziManager.getInstance().checkCertificatiModIErogazioneByIdWithoutCache(idErogazione, sogliaWarningGiorni, (IBYOKUnwrapFactory)new BYOKUnwrapFactory(), addCertificateDetails, separator, newLine);
            return statoCheck.toString(newLine);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String checkCertificatiModIFruizioneById(long idFruizione, int sogliaWarningGiorni) {
        try {
            boolean addCertificateDetails = true;
            String separator = ": ";
            String newLine = "\n";
            CertificateCheck statoCheck = RegistroServiziManager.getInstance().checkCertificatiModIFruizioneByIdWithoutCache(idFruizione, sogliaWarningGiorni, (IBYOKUnwrapFactory)new BYOKUnwrapFactory(), addCertificateDetails, separator, newLine);
            return statoCheck.toString(newLine);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }
}

