/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.id.IDConnettore;
import org.openspcoop2.pdd.config.ConfigurazionePdD;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.GestoreLoadBalancerCaching;
import org.openspcoop2.pdd.core.jmx.JMXUtils;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.slf4j.Logger;

public class GestoreConsegnaApplicativi
extends NotificationBroadcasterSupport
implements DynamicMBean {
    public static final String MAX_LIFE_PRESA_IN_CONSEGNA = "maxlifePresaInConsegna";
    public static final String THREAD_POOL_STATUS = "getThreadPoolStatus";
    public static final String QUEUE_CONFIG = "getQueueConfig";
    public static final String GET_APPLICATIVI_PRIORITARI = "getApplicativiPrioritari";
    public static final String GET_CONNETTORI_PRIORITARI = "getConnettoriPrioritari";
    public static final String UPDATE_CONNETTORI_PRIORITARI = "updateConnettoriPrioritari";
    public static final String RESET_CONNETTORI_PRIORITARI = "resetConnettoriPrioritari";
    private boolean cacheAbilitata = false;
    private int maxLifePresaInConsegna = -1;
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals("cacheAbilitata")) {
            return this.cacheAbilitata;
        }
        if (attributeName.equals(MAX_LIFE_PRESA_IN_CONSEGNA)) {
            return this.maxLifePresaInConsegna;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
        }
        try {
            if (attribute.getName().equals("cacheAbilitata")) {
                boolean v = (Boolean)attribute.getValue();
                if (v) {
                    if (!this.cacheAbilitata) {
                        this.abilitaCache();
                    }
                } else if (this.cacheAbilitata) {
                    this.disabilitaCache();
                }
            }
            throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
        }
        catch (ClassCastException ce) {
            throw new InvalidAttributeValueException("il tipo " + attribute.getValue().getClass() + " dell'attributo " + attribute.getName() + " non e' valido");
        }
        catch (JMException j) {
            throw new MBeanException(j);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException jMException) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals("resetCache")) {
            return this.resetCache();
        }
        if (actionName.equals("printStatsCache")) {
            return this.printStatCache();
        }
        if (actionName.equals("disabilitaCache")) {
            return this.disabilitaCacheConEsito();
        }
        if (actionName.equals("abilitaCache")) {
            if (params.length != 4) {
                throw new MBeanException(new Exception("[abilitaCache] Lunghezza parametri non corretta: " + params.length));
            }
            Long param1 = null;
            if (params[0] != null && !"".equals(params[0]) && (param1 = (Long)params[0]) < 0L) {
                param1 = null;
            }
            Boolean param2 = null;
            if (params[1] != null && !"".equals(params[1])) {
                param2 = (Boolean)params[1];
            }
            Long param3 = null;
            if (params[2] != null && !"".equals(params[2]) && (param3 = (Long)params[2]) < 0L) {
                param3 = null;
            }
            Long param4 = null;
            if (params[3] != null && !"".equals(params[3]) && (param4 = (Long)params[3]) < 0L) {
                param4 = null;
            }
            return this.abilitaCache(param1, param2, param3, param4);
        }
        if (actionName.equals("listKeysCache")) {
            return this.listKeysCache();
        }
        if (actionName.equals("getObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[getObjectCache] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.getObjectCache(param1);
        }
        if (actionName.equals("removeObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[removeObjectCache] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.removeObjectCache(param1);
        }
        if (actionName.equals(THREAD_POOL_STATUS)) {
            if (params.length > 1) {
                throw new MBeanException(new Exception("[getThreadPoolStatus] Lunghezza parametri non corretta: " + params.length));
            }
            if (params.length > 0) {
                String param1 = null;
                if (params[0] != null && !"".equals(params[0])) {
                    param1 = (String)params[0];
                }
                return this.getThreadPoolStatus(param1);
            }
            return this.getThreadPoolStatus("DEFAULT");
        }
        if (actionName.equals(QUEUE_CONFIG)) {
            if (params.length > 1) {
                throw new MBeanException(new Exception("[getQueueConfig] Lunghezza parametri non corretta: " + params.length));
            }
            if (params.length > 0) {
                String param1 = null;
                if (params[0] != null && !"".equals(params[0])) {
                    param1 = (String)params[0];
                }
                return this.getQueueConfig(param1);
            }
            return this.getQueueConfig("DEFAULT");
        }
        if (actionName.equals(GET_APPLICATIVI_PRIORITARI)) {
            if (params.length > 1) {
                throw new MBeanException(new Exception("[getQueueConfig] Lunghezza parametri non corretta: " + params.length));
            }
            if (params.length > 0) {
                String param1 = null;
                if (params[0] != null && !"".equals(params[0])) {
                    param1 = (String)params[0];
                }
                return this.getApplicativiPrioritari(param1);
            }
            return this.getApplicativiPrioritari("DEFAULT");
        }
        if (actionName.equals(GET_CONNETTORI_PRIORITARI)) {
            if (params.length > 1) {
                throw new MBeanException(new Exception("[getQueueConfig] Lunghezza parametri non corretta: " + params.length));
            }
            if (params.length > 0) {
                String param1 = null;
                if (params[0] != null && !"".equals(params[0])) {
                    param1 = (String)params[0];
                }
                return this.getConnettoriPrioritari(param1);
            }
            return this.getConnettoriPrioritari("DEFAULT");
        }
        if (actionName.equals(UPDATE_CONNETTORI_PRIORITARI)) {
            if (params.length > 1) {
                throw new MBeanException(new Exception("[getQueueConfig] Lunghezza parametri non corretta: " + params.length));
            }
            if (params.length > 0) {
                String param1 = null;
                if (params[0] != null && !"".equals(params[0])) {
                    param1 = (String)params[0];
                }
                return this.updateConnettoriPrioritari(param1);
            }
            return this.updateConnettoriPrioritari("DEFAULT");
        }
        if (actionName.equals(RESET_CONNETTORI_PRIORITARI)) {
            if (params.length > 1) {
                throw new MBeanException(new Exception("[getQueueConfig] Lunghezza parametri non corretta: " + params.length));
            }
            if (params.length > 0) {
                String param1 = null;
                if (params[0] != null && !"".equals(params[0])) {
                    param1 = (String)params[0];
                }
                return this.resetConnettoriPrioritari(param1);
            }
            return this.resetConnettoriPrioritari("DEFAULT");
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        String className = this.getClass().getName();
        String description = "Risorsa per la configurazione (" + this.openspcoopProperties.getVersione() + ")";
        MBeanAttributeInfo cacheAbilitataVAR = JMXUtils.MBEAN_ATTRIBUTE_INFO_CACHE_ABILITATA;
        MBeanAttributeInfo maxLife = new MBeanAttributeInfo(MAX_LIFE_PRESA_IN_CONSEGNA, String.class.getName(), "Tempo massimo (in secondi) che un messaggio pu\u00f2 essere tenuto in consegna da parte del gestore", true, false, false);
        MBeanOperationInfo resetCacheOP = JMXUtils.MBEAN_OPERATION_RESET_CACHE;
        MBeanOperationInfo printStatCacheOP = JMXUtils.MBEAN_OPERATION_PRINT_STATS_CACHE;
        MBeanOperationInfo disabilitaCacheOP = JMXUtils.MBEAN_OPERATION_DISABILITA_CACHE;
        MBeanOperationInfo abilitaCacheParametriOP = JMXUtils.MBEAN_OPERATION_ABILITA_CACHE_CON_PARAMETRI;
        MBeanOperationInfo listKeysCacheOP = JMXUtils.MBEAN_OPERATION_LIST_KEYS_CACHE;
        MBeanOperationInfo getObjectCacheOP = JMXUtils.MBEAN_OPERATION_GET_OBJECT_CACHE;
        MBeanOperationInfo removeObjectCacheOP = JMXUtils.MBEAN_OPERATION_REMOVE_OBJECT_CACHE;
        MBeanOperationInfo threadPoolStatusDefault = new MBeanOperationInfo(THREAD_POOL_STATUS, "Stato dei thread utilizzati per la consegna dei messaggi nella coda di default", null, String.class.getName(), 1);
        MBeanOperationInfo threadPoolStatus = new MBeanOperationInfo(THREAD_POOL_STATUS, "Stato dei thread utilizzati per la consegna dei messaggi nella coda indicata", new MBeanParameterInfo[]{new MBeanParameterInfo("coda", String.class.getName(), "Nome della coda")}, String.class.getName(), 1);
        MBeanOperationInfo queueConfigDefault = new MBeanOperationInfo(QUEUE_CONFIG, "Configurazione della coda di default", null, String.class.getName(), 1);
        MBeanOperationInfo queueConfig = new MBeanOperationInfo(QUEUE_CONFIG, "Configurazione della coda indicata", new MBeanParameterInfo[]{new MBeanParameterInfo("coda", String.class.getName(), "Nome della coda")}, String.class.getName(), 1);
        MBeanOperationInfo getApplicativiPrioritariDefault = new MBeanOperationInfo(GET_APPLICATIVI_PRIORITARI, "Applicativi configurati come prioritari nella coda di default", null, String.class.getName(), 1);
        MBeanOperationInfo getApplicativiPrioritari = new MBeanOperationInfo(GET_APPLICATIVI_PRIORITARI, "Applicativi configurati come prioritari nella coda indicata", new MBeanParameterInfo[]{new MBeanParameterInfo("coda", String.class.getName(), "Nome della coda")}, String.class.getName(), 1);
        MBeanOperationInfo getConnettoriPrioritariDefault = new MBeanOperationInfo(GET_CONNETTORI_PRIORITARI, "Connettori configurati come prioritari nella coda di default", null, String.class.getName(), 1);
        MBeanOperationInfo getConnettoriPrioritari = new MBeanOperationInfo(GET_CONNETTORI_PRIORITARI, "Connettori configurati come prioritari nella coda indicata", new MBeanParameterInfo[]{new MBeanParameterInfo("coda", String.class.getName(), "Nome della coda")}, String.class.getName(), 1);
        MBeanOperationInfo updateConnettoriPrioritariDefault = new MBeanOperationInfo(UPDATE_CONNETTORI_PRIORITARI, "Aggiorna la configurazione dei connettori configurati come prioritari nella coda di default", null, String.class.getName(), 1);
        MBeanOperationInfo updateConnettoriPrioritari = new MBeanOperationInfo(UPDATE_CONNETTORI_PRIORITARI, "Aggiorna la configurazione dei connettori configurati come prioritari nella coda indicata", new MBeanParameterInfo[]{new MBeanParameterInfo("coda", String.class.getName(), "Nome della coda")}, String.class.getName(), 1);
        MBeanOperationInfo resetConnettoriPrioritariDefault = new MBeanOperationInfo(RESET_CONNETTORI_PRIORITARI, "Rimuove i connettori configurati come prioritari nella coda di default", null, String.class.getName(), 1);
        MBeanOperationInfo resetConnettoriPrioritari = new MBeanOperationInfo(RESET_CONNETTORI_PRIORITARI, "Rimuove i connettori configurati come prioritari nella coda indicata", new MBeanParameterInfo[]{new MBeanParameterInfo("coda", String.class.getName(), "Nome della coda")}, String.class.getName(), 1);
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{cacheAbilitataVAR, maxLife};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        ArrayList<MBeanOperationInfo> listOperation = new ArrayList<MBeanOperationInfo>();
        listOperation.add(resetCacheOP);
        listOperation.add(printStatCacheOP);
        listOperation.add(disabilitaCacheOP);
        listOperation.add(abilitaCacheParametriOP);
        listOperation.add(listKeysCacheOP);
        listOperation.add(getObjectCacheOP);
        listOperation.add(removeObjectCacheOP);
        listOperation.add(threadPoolStatusDefault);
        listOperation.add(threadPoolStatus);
        listOperation.add(queueConfigDefault);
        listOperation.add(queueConfig);
        listOperation.add(getApplicativiPrioritariDefault);
        listOperation.add(getApplicativiPrioritari);
        listOperation.add(getConnettoriPrioritariDefault);
        listOperation.add(getConnettoriPrioritari);
        listOperation.add(updateConnettoriPrioritariDefault);
        listOperation.add(updateConnettoriPrioritari);
        listOperation.add(resetConnettoriPrioritariDefault);
        listOperation.add(resetConnettoriPrioritari);
        MBeanOperationInfo[] operations = listOperation.toArray(new MBeanOperationInfo[1]);
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public GestoreConsegnaApplicativi() {
        try {
            this.cacheAbilitata = GestoreLoadBalancerCaching.isCacheAbilitata();
        }
        catch (Exception e) {
            this.log.error("Errore durante l'identificazione dello stato della cache");
        }
        this.maxLifePresaInConsegna = this.openspcoopProperties.getTimerConsegnaContenutiApplicativiPresaInConsegnaMaxLife();
    }

    public boolean isCacheAbilitata() {
        return this.cacheAbilitata;
    }

    public String resetCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            GestoreLoadBalancerCaching.resetCache();
            return "Operazione di reset effettuata con successo";
        }
        catch (Exception e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String printStatCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            return GestoreLoadBalancerCaching.printStatsCache("\n");
        }
        catch (Exception e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void abilitaCache() {
        try {
            GestoreLoadBalancerCaching.abilitaCache();
            this.cacheAbilitata = true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) {
        try {
            GestoreLoadBalancerCaching.abilitaCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond, OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
            this.cacheAbilitata = true;
            return "Abilitazione cache effettuata con successo";
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void disabilitaCache() throws JMException {
        try {
            GestoreLoadBalancerCaching.disabilitaCache();
            this.cacheAbilitata = false;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new JMException(e.getMessage());
        }
    }

    public String disabilitaCacheConEsito() {
        try {
            this.disabilitaCache();
            return "Disabilitazione cache effettuata con successo";
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String listKeysCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            return GestoreLoadBalancerCaching.listKeysCache("\n");
        }
        catch (Exception e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getObjectCache(String key) {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            return GestoreLoadBalancerCaching.getObjectCache(key);
        }
        catch (Exception e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String removeObjectCache(String key) {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            GestoreLoadBalancerCaching.removeObjectCache(key);
            return "Rimozione elemento dalla cache effettuata con successo";
        }
        catch (Exception e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getThreadPoolStatus(String queue) {
        try {
            if (OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap == null || !OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap.containsKey(queue)) {
                throw new CoreException("Coda '" + queue + "' non esistente");
            }
            return OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap.get(queue).getThreadsImage();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getQueueConfig(String queue) {
        try {
            if (OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap == null || !OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap.containsKey(queue)) {
                throw new CoreException("Coda '" + queue + "' non esistente");
            }
            return OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap.get(queue).getQueueConfig();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getApplicativiPrioritari(String queue) {
        try {
            if (OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap == null || !OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap.containsKey(queue)) {
                throw new CoreException("Coda '" + queue + "' non esistente");
            }
            List<IDConnettore> list = ConfigurazionePdDManager.getInstance().getConnettoriConsegnaNotifichePrioritarie(queue);
            if (list == null || list.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (IDConnettore idConnettore : list) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(idConnettore.getNome()).append("@").append(idConnettore.getIdSoggettoProprietario().toString());
            }
            return sb.toString();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getConnettoriPrioritari(String queue) {
        try {
            if (OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap == null || !OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap.containsKey(queue)) {
                throw new CoreException("Coda '" + queue + "' non esistente");
            }
            List<IDConnettore> list = ConfigurazionePdDManager.getInstance().getConnettoriConsegnaNotifichePrioritarie(queue);
            if (list == null || list.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (IDConnettore idConnettore : list) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(idConnettore.getNomeConnettore());
            }
            return sb.toString();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String updateConnettoriPrioritari(String queue) {
        try {
            if (OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap == null || !OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap.containsKey(queue)) {
                throw new CoreException("Coda '" + queue + "' non esistente");
            }
            ConfigurazionePdDReader.removeObjectCache(ConfigurazionePdD.getKey_getConnettoriConsegnaNotifichePrioritarie(queue));
            return "Operazione effettuata con successo";
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String resetConnettoriPrioritari(String queue) {
        try {
            if (OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap == null || !OpenSPCoop2Startup.threadConsegnaContenutiApplicativiRefMap.containsKey(queue)) {
                throw new CoreException("Coda '" + queue + "' non esistente");
            }
            ConfigurazionePdDManager.getInstance().resetConnettoriConsegnaNotifichePrioritarie(queue);
            ConfigurazionePdDReader.removeObjectCache(ConfigurazionePdD.getKey_getConnettoriConsegnaNotifichePrioritarie(queue));
            return "Operazione effettuata con successo";
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }
}

