/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.sql.Connection;
import java.util.concurrent.Callable;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.utils.jdbc.JDBCUtilities;

class InformazioniDatabaseChecker
implements Callable<String> {
    private OpenSPCoop2Properties openspcoopProperties;

    public InformazioniDatabaseChecker(OpenSPCoop2Properties openspcoopProperties) {
        this.openspcoopProperties = openspcoopProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() throws Exception {
        if (!DBManager.isInitialized()) {
            throw new CoreException("Inizializzazione DBManager non effettuata");
        }
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        if (this.openspcoopProperties == null) {
            throw new CoreException("Inizializzazione OpenSPCoop2Properties non effettuata");
        }
        IDSoggetto dominio = this.openspcoopProperties.getIdentitaPortaDefaultWithoutProtocol();
        String modulo = this.getClass().getName();
        StringBuilder bf = new StringBuilder();
        if (this.openspcoopProperties.getDatabaseType() == null) {
            throw new CoreException("Tipo di Database non disponibile");
        }
        bf.append("TipoDatabase: " + this.openspcoopProperties.getDatabaseType());
        try {
            resource = dbManager.getResource(dominio, modulo, null);
            Connection c = (Connection)resource.getResource();
            JDBCUtilities.addInformazioniDatabaseFromMetaData((Connection)c, (StringBuilder)bf);
            if (bf.length() <= 0) {
                throw new CoreException("Non sono disponibili informazioni sul database");
            }
            String string = bf.toString();
            return string;
        }
        finally {
            try {
                dbManager.releaseResource(dominio, modulo, resource);
            }
            catch (Exception exception) {}
        }
    }
}

