/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.openspcoop2.pdd.config.DBConsegneMessageBoxManager;
import org.openspcoop2.pdd.config.DBConsegnePreseInCaricoManager;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.DBStatisticheManager;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.QueueManager;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.monitor.StatoPdd;
import org.openspcoop2.pdd.monitor.driver.DriverMonitoraggio;
import org.openspcoop2.pdd.monitor.driver.FilterSearch;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerThresholdThread;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class MonitoraggioRisorse
extends NotificationBroadcasterSupport
implements DynamicMBean {
    public static final String NUMERO_MSG_IN_CONSEGNA = "numMsgInConsegna";
    public static final String TEMPO_MEDIO_ATTESA_IN_CONSEGNA = "tempoMedioAttesaInConsegna";
    public static final String TEMPO_MAX_ATTESA_IN_CONSEGNA = "tempoMaxAttesaInConsegna";
    public static final String NUMERO_MSG_IN_SPEDIZIONE = "numMsgInSpedizione";
    public static final String TEMPO_MEDIO_ATTESA_IN_SPEDIZIONE = "tempoMedioAttesaInSpedizione";
    public static final String TEMPO_MAX_ATTESA_IN_SPEDIZIONE = "tempoMaxAttesaInSpedizione";
    public static final String NUMERO_MSG_IN_PROCESSAMENTO = "numMsgInProcessamento";
    public static final String TEMPO_MEDIO_ATTESA_IN_PROCESSAMENTO = "tempoMedioAttesaInProcessamento";
    public static final String TEMPO_MAX_ATTESA_IN_PROCESSAMENTO = "tempoMaxAttesaInProcessamento";
    public static final String NUMERO_MSG_TOTALI = "totMessaggi";
    public static final String TEMPO_MEDIO_ATTESA_MSG_TOTALI = "tempoMedioAttesa";
    public static final String TEMPO_MAX_ATTESA_MSG_TOTALI = "tempoMaxAttesa";
    public static final String TOT_MSG_DUPLICATI = "totMessaggiDuplicati";
    public static final String STATO_DATI_MONITORAGGIO = "statoDatiMonitoraggioPdD";
    public static final String RISORSE_DI_SISTEMA = "risorseDiSistema";
    public static final String GET_STATO_RISORSE_DI_SISTEMA = "getStatoRisorseSistema";
    public static final String GET_STATO_RISORSE_DI_SISTEMA_METHOD2 = "listStatoRisorseSistema";
    public static final String GET_STATO_CACHES = "getStatoCache";
    public static final String GET_STATO_CACHES_METHOD2 = "listStatoCache";
    public static final String CONNESSIONI_ALLOCATE_DB_MANAGER = "getUsedDBConnections";
    public static final String CONNESSIONI_ALLOCATE_DB_MANAGER_METHOD2 = "listUsedDBConnections";
    public static final String CONNESSIONI_ALLOCATE_QUEUE_MANAGER = "getUsedQueueConnections";
    public static final String CONNESSIONI_ALLOCATE_QUEUE_MANAGER_METHOD2 = "listUsedQueueConnections";
    public static final String TRANSAZIONI_ATTIVE_ID = "getActiveTransactions";
    public static final String TRANSAZIONI_ATTIVE_ID_METHOD2 = "listActiveTransactions";
    public static final String TRANSAZIONI_ATTIVE_ID_PROTOCOLLO = "getActiveProtocolIds";
    public static final String TRANSAZIONI_ATTIVE_ID_PROTOCOLLO_METHOD2 = "listActiveProtocolIds";
    public static final String GET_DETTAGLIO_TRANSAZIONE_ATTIVA = "getActiveTransactionDetails";
    public static final String CONNESSIONI_ALLOCATE_CONNETTORI_PD = "getActivePDConnections";
    public static final String CONNESSIONI_ALLOCATE_CONNETTORI_PD_METHOD2 = "listActivePDConnections";
    public static final String CONNESSIONI_ALLOCATE_CONNETTORI_PA = "getActivePAConnections";
    public static final String CONNESSIONI_ALLOCATE_CONNETTORI_PA_METHOD2 = "listActivePAConnections";
    private long numMsgInConsegna = 0L;
    private String tempoMedioAttesaInConsegna = "";
    private String tempoMaxAttesaInConsegna = "";
    private long numMsgInSpedizione = 0L;
    private String tempoMedioAttesaInSpedizione = "";
    private String tempoMaxAttesaInSpedizione = "";
    private long numMsgInProcessamento = 0L;
    private String tempoMedioAttesaInProcessamento = "";
    private String tempoMaxAttesaInProcessamento = "";
    private long totMessaggi = 0L;
    private String tempoMedioAttesa = "";
    private String tempoMaxAttesa = "";
    private long totMessaggiDuplicati = 0L;
    private String risorseDiSistema = "Lettura dati non effettuata         ";
    private String datiMonitoraggioPdD = "Non disponibili";
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    public static final String MESSAGGIO_RISORSE_ADEGUATE = "GovWay possiede le adeguate risorse di sistema";
    public static final String MSG_NESSUNA_CONNESSIONE_ALLOCATA = "Nessuna connessione allocata";
    public static final String MSG_CONNESSIONI_ALLOCATE = " risorse allocate: ";
    public static final String MSG_CONNESSIONI_ALLOCATE_TRANSAZIONI = " risorse allocate per la gestione delle transazioni: ";
    public static final String MSG_CONNESSIONI_ALLOCATE_STATISTICHE = " risorse allocate per la generazione delle statistiche: ";
    public static final String MSG_CONNESSIONI_ALLOCATE_CONSEGNE_PRESE_IN_CARICO_SMISTATORE = " risorse allocate per lo smistatore dei messaggi presi in carico: ";
    public static final String MSG_CONNESSIONI_ALLOCATE_CONSEGNE_PRESE_IN_CARICO_RUNTIME = " risorse allocate per il gestore runtime dei messaggi presi in carico: ";
    public static final String MSG_CONNESSIONI_ALLOCATE_CONSEGNE_PRESE_IN_CARICO_TRANSAZIONI = " risorse allocate per il gestore delle tracce relative ai messaggi presi in carico: ";
    public static final String MSG_CONNESSIONI_ALLOCATE_CONSEGNE_MESSAGE_BOX_RUNTIME = " risorse allocate per il gestore runtime del servizio MessageBox: ";
    public static final String MSG_CONNESSIONI_ALLOCATE_CONSEGNE_MESSAGE_BOX_TRANSAZIONI = " risorse allocate per il gestore delle tracce del servizio MessageBox: ";
    public static final String MSG_CONNESSIONI_HTTP_ALLOCATE = " connessioni allocate: ";
    public static final String MSG_NESSUNA_TRANSAZIONE_ATTIVA = "Nessuna transazione attiva";
    public static final String MSG_TRANSAZIONI_ATTIVE = " transazioni attive: ";
    public static final String MSG_TRANSAZIONI_ATTIVE_ID_PROTOCOLLO = " id di protocollo attivi: ";

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals(NUMERO_MSG_IN_CONSEGNA)) {
            return this.numMsgInConsegna;
        }
        if (attributeName.equals(TEMPO_MEDIO_ATTESA_IN_CONSEGNA)) {
            return this.tempoMedioAttesaInConsegna;
        }
        if (attributeName.equals(TEMPO_MAX_ATTESA_IN_CONSEGNA)) {
            return this.tempoMaxAttesaInConsegna;
        }
        if (attributeName.equals(NUMERO_MSG_IN_SPEDIZIONE)) {
            return this.numMsgInSpedizione;
        }
        if (attributeName.equals(TEMPO_MEDIO_ATTESA_IN_SPEDIZIONE)) {
            return this.tempoMedioAttesaInSpedizione;
        }
        if (attributeName.equals(TEMPO_MAX_ATTESA_IN_SPEDIZIONE)) {
            return this.tempoMaxAttesaInSpedizione;
        }
        if (attributeName.equals(NUMERO_MSG_IN_PROCESSAMENTO)) {
            return this.numMsgInProcessamento;
        }
        if (attributeName.equals(TEMPO_MEDIO_ATTESA_IN_PROCESSAMENTO)) {
            return this.tempoMedioAttesaInProcessamento;
        }
        if (attributeName.equals(TEMPO_MAX_ATTESA_IN_PROCESSAMENTO)) {
            return this.tempoMaxAttesaInProcessamento;
        }
        if (attributeName.equals(NUMERO_MSG_TOTALI)) {
            return this.totMessaggi;
        }
        if (attributeName.equals(TEMPO_MEDIO_ATTESA_MSG_TOTALI)) {
            return this.tempoMedioAttesa;
        }
        if (attributeName.equals(TEMPO_MAX_ATTESA_MSG_TOTALI)) {
            return this.tempoMaxAttesa;
        }
        if (attributeName.equals(TOT_MSG_DUPLICATI)) {
            return this.totMessaggiDuplicati;
        }
        if (attributeName.equals(RISORSE_DI_SISTEMA)) {
            return this.risorseDiSistema;
        }
        if (attributeName.equals(STATO_DATI_MONITORAGGIO)) {
            return this.datiMonitoraggioPdD;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block19: {
            if (attribute == null) {
                throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
            }
            try {
                if (attribute.getName().equals(NUMERO_MSG_IN_CONSEGNA)) {
                    this.numMsgInConsegna = (Long)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MEDIO_ATTESA_IN_CONSEGNA)) {
                    this.tempoMedioAttesaInConsegna = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MAX_ATTESA_IN_CONSEGNA)) {
                    this.tempoMaxAttesaInConsegna = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(NUMERO_MSG_IN_SPEDIZIONE)) {
                    this.numMsgInSpedizione = (Long)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MEDIO_ATTESA_IN_SPEDIZIONE)) {
                    this.tempoMedioAttesaInSpedizione = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MAX_ATTESA_IN_SPEDIZIONE)) {
                    this.tempoMaxAttesaInSpedizione = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(NUMERO_MSG_IN_PROCESSAMENTO)) {
                    this.numMsgInProcessamento = (Long)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MEDIO_ATTESA_IN_PROCESSAMENTO)) {
                    this.tempoMedioAttesaInProcessamento = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MAX_ATTESA_IN_PROCESSAMENTO)) {
                    this.tempoMaxAttesaInProcessamento = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(NUMERO_MSG_TOTALI)) {
                    this.totMessaggi = (Long)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MEDIO_ATTESA_MSG_TOTALI)) {
                    this.tempoMedioAttesa = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TEMPO_MAX_ATTESA_MSG_TOTALI)) {
                    this.tempoMaxAttesa = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(TOT_MSG_DUPLICATI)) {
                    this.totMessaggiDuplicati = (Long)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(RISORSE_DI_SISTEMA)) {
                    this.risorseDiSistema = (String)attribute.getValue();
                    break block19;
                }
                if (attribute.getName().equals(STATO_DATI_MONITORAGGIO)) {
                    this.refreshDatiMonitoraggioPdD();
                    break block19;
                }
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
            catch (ClassCastException ce) {
                throw new InvalidAttributeValueException("il tipo " + attribute.getValue().getClass() + " dell'attributo " + attribute.getName() + " non e' valido");
            }
            catch (JMException j) {
                throw new MBeanException(j);
            }
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException jMException) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals(CONNESSIONI_ALLOCATE_DB_MANAGER) || actionName.equals(CONNESSIONI_ALLOCATE_DB_MANAGER_METHOD2)) {
            return this.getUsedDBConnections();
        }
        if (actionName.equals(CONNESSIONI_ALLOCATE_QUEUE_MANAGER) || actionName.equals(CONNESSIONI_ALLOCATE_QUEUE_MANAGER_METHOD2)) {
            return this.getUsedQueueConnections();
        }
        if (actionName.equals(TRANSAZIONI_ATTIVE_ID) || actionName.equals(TRANSAZIONI_ATTIVE_ID_METHOD2)) {
            return this.getTransazioniAttiveId();
        }
        if (actionName.equals(GET_DETTAGLIO_TRANSAZIONE_ATTIVA)) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[getActiveTransactionDetails] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.getDettaglioTransazioneAttivaId(param1);
        }
        if (actionName.equals(TRANSAZIONI_ATTIVE_ID_PROTOCOLLO) || actionName.equals(TRANSAZIONI_ATTIVE_ID_PROTOCOLLO_METHOD2)) {
            return this.getTransazioniAttiveIdProtocollo();
        }
        if (actionName.equals(CONNESSIONI_ALLOCATE_CONNETTORI_PD) || actionName.equals(CONNESSIONI_ALLOCATE_CONNETTORI_PD_METHOD2)) {
            return this.getActivePDConnections();
        }
        if (actionName.equals(CONNESSIONI_ALLOCATE_CONNETTORI_PA) || actionName.equals(CONNESSIONI_ALLOCATE_CONNETTORI_PA_METHOD2)) {
            return this.getActivePAConnections();
        }
        if (actionName.equals(GET_STATO_RISORSE_DI_SISTEMA) || actionName.equals(GET_STATO_RISORSE_DI_SISTEMA_METHOD2)) {
            this.refreshDatiMonitoraggioPdD();
            return this.risorseDiSistema;
        }
        if (actionName.equals(GET_STATO_CACHES) || actionName.equals(GET_STATO_CACHES_METHOD2)) {
            return this.getStatoCaches();
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        boolean READABLE = true;
        boolean WRITABLE = true;
        boolean IS_GETTER = true;
        String className = this.getClass().getName();
        String description = "Monitoraggio delle risorse utilizzate (" + OpenSPCoop2Properties.getInstance().getVersione() + "), premi pulsante (apply changes) per aggiornare i dati";
        MBeanAttributeInfo numMsgInConsegnaVAR = new MBeanAttributeInfo(NUMERO_MSG_IN_CONSEGNA, Long.TYPE.getName(), "Numero di Messaggi in gestione nel modulo 'ConsegnaContenutiApplicativi'", true, false, false);
        MBeanAttributeInfo tempoMedioAttesaInConsegnaVAR = new MBeanAttributeInfo(TEMPO_MEDIO_ATTESA_IN_CONSEGNA, String.class.getName(), "Tempo medio di attesa dei Messaggi prima di essere stati consegnati ai servizi applicativi dal modulo 'ConsegnaContenutiApplicativi'", true, false, false);
        MBeanAttributeInfo tempoMaxAttesaInConsegnaVAR = new MBeanAttributeInfo(TEMPO_MAX_ATTESA_IN_CONSEGNA, String.class.getName(), "Tempo massimo di attesa dei Messaggi prima di essere stati consegnati ai servizi applicativi dal modulo 'ConsegnaContenutiApplicativi'", true, false, false);
        MBeanAttributeInfo numMsgInSpedizioneVAR = new MBeanAttributeInfo(NUMERO_MSG_IN_SPEDIZIONE, Long.TYPE.getName(), "Numero di Messaggi in gestione nei moduli 'InoltroBuste'", true, false, false);
        MBeanAttributeInfo tempoMedioAttesaInSpedizioneVAR = new MBeanAttributeInfo(TEMPO_MEDIO_ATTESA_IN_SPEDIZIONE, String.class.getName(), "Tempo medio di attesa dei Messaggi prima di essere stati inoltrate alle porte di dominio destinatarie dai moduli 'InoltroBuste'", true, false, false);
        MBeanAttributeInfo tempoMaxAttesaInSpedizioneVAR = new MBeanAttributeInfo(TEMPO_MAX_ATTESA_IN_SPEDIZIONE, String.class.getName(), "Tempo massimo di attesa dei Messaggi prima di essere stati inoltrate alle porte di dominio destinatarie dai moduli 'InoltroBuste'", true, false, false);
        MBeanAttributeInfo numMsgInProcessamentoVAR = new MBeanAttributeInfo(NUMERO_MSG_IN_PROCESSAMENTO, Long.TYPE.getName(), "Numero di Messaggi in gestione nei moduli interni all'infrastruttura della porta di dominio", true, false, false);
        MBeanAttributeInfo tempoMedioAttesaInProcessamentoVAR = new MBeanAttributeInfo(TEMPO_MEDIO_ATTESA_IN_PROCESSAMENTO, String.class.getName(), "Tempo medio di attesa in gestione nei moduli interni all'infrastruttura della porta di dominio", true, false, false);
        MBeanAttributeInfo tempoMaxAttesaInProcessamentoVAR = new MBeanAttributeInfo(TEMPO_MAX_ATTESA_IN_PROCESSAMENTO, String.class.getName(), "Tempo massimo di attesa in gestione nei moduli interni all'infrastruttura della porta di dominio", true, false, false);
        MBeanAttributeInfo totMessaggiVAR = new MBeanAttributeInfo(NUMERO_MSG_TOTALI, Long.TYPE.getName(), "Numero di Messaggi totali in gestione nella porta di dominio", true, false, false);
        MBeanAttributeInfo tempoMedioAttesaVAR = new MBeanAttributeInfo(TEMPO_MEDIO_ATTESA_MSG_TOTALI, String.class.getName(), "Tempo medio di attesa dei Messaggi gestiti nella porta di dominio", true, false, false);
        MBeanAttributeInfo tempoMaxAttesaVAR = new MBeanAttributeInfo(TEMPO_MAX_ATTESA_MSG_TOTALI, String.class.getName(), "Tempo massimo di attesa dei Messaggi gestiti nella porta di dominio", true, false, false);
        MBeanAttributeInfo totMessaggiDuplicatiVAR = new MBeanAttributeInfo(TOT_MSG_DUPLICATI, Long.TYPE.getName(), "Numero di Messaggi duplicati gestiti nella porta di dominio", true, false, false);
        MBeanAttributeInfo risorseDisponibiliVAR = new MBeanAttributeInfo(RISORSE_DI_SISTEMA, String.class.getName(), "Indicazione sullo stato delle risorse disponibili per la porta di dominio", true, false, false);
        MBeanAttributeInfo monitoraggioPdDVAR = new MBeanAttributeInfo(STATO_DATI_MONITORAGGIO, String.class.getName(), "Monitoraggio della porta di dominio, premi pulsante (apply changes) per aggiornare i dati", true, true, false);
        MBeanOperationInfo getConnessioneAllocateDBManagerOP = new MBeanOperationInfo(CONNESSIONI_ALLOCATE_DB_MANAGER, "Moduli funzionali che dispongono di una connessione verso il database dei messaggi", null, String.class.getName(), 1);
        MBeanOperationInfo getConnessioneAllocateDBManagerOP_method2 = new MBeanOperationInfo(CONNESSIONI_ALLOCATE_DB_MANAGER_METHOD2, "Moduli funzionali che dispongono di una connessione verso il database dei messaggi", null, String.class.getName(), 1);
        MBeanOperationInfo getConnessioneAllocateQueueManagerOP = new MBeanOperationInfo(CONNESSIONI_ALLOCATE_QUEUE_MANAGER, "Moduli funzionali che dispongono di una connessione verso il Broker JMS", null, String.class.getName(), 1);
        MBeanOperationInfo getConnessioneAllocateQueueManagerOP_method2 = new MBeanOperationInfo(CONNESSIONI_ALLOCATE_QUEUE_MANAGER_METHOD2, "Moduli funzionali che dispongono di una connessione verso il Broker JMS", null, String.class.getName(), 1);
        MBeanOperationInfo getTransazioniAttiveOP = new MBeanOperationInfo(TRANSAZIONI_ATTIVE_ID, "Transazioni attive", null, String.class.getName(), 1);
        MBeanOperationInfo getTransazioniAttiveOP_method2 = new MBeanOperationInfo(TRANSAZIONI_ATTIVE_ID_METHOD2, "Transazioni attive", null, String.class.getName(), 1);
        MBeanOperationInfo getDettaglioTransazioneAttiva = new MBeanOperationInfo(GET_DETTAGLIO_TRANSAZIONE_ATTIVA, "Recupera i dettagli della transazione con id fornito come parametro", new MBeanParameterInfo[]{new MBeanParameterInfo("idTransazione", String.class.getName(), "Identificativo della transazione")}, String.class.getName(), 1);
        MBeanOperationInfo getTransazioniIdProtocolloAttiviOP = new MBeanOperationInfo(TRANSAZIONI_ATTIVE_ID_PROTOCOLLO, "Identificativi di Protocollo attivi sulla Porta", null, String.class.getName(), 1);
        MBeanOperationInfo getTransazioniIdProtocolloAttiviOP_method2 = new MBeanOperationInfo(TRANSAZIONI_ATTIVE_ID_PROTOCOLLO_METHOD2, "Identificativi di Protocollo attivi sulla Porta", null, String.class.getName(), 1);
        MBeanOperationInfo getActiveConnectionsPD_OP = new MBeanOperationInfo(CONNESSIONI_ALLOCATE_CONNETTORI_PD, "Connessioni attive su cui e' in corso un inoltro di busta (PortaDelegata)", null, String.class.getName(), 1);
        MBeanOperationInfo getActiveConnectionsPD_OP_method2 = new MBeanOperationInfo(CONNESSIONI_ALLOCATE_CONNETTORI_PD_METHOD2, "Connessioni attive su cui e' in corso un inoltro di busta (PortaDelegata)", null, String.class.getName(), 1);
        MBeanOperationInfo getActiveConnectionsPA_OP = new MBeanOperationInfo(CONNESSIONI_ALLOCATE_CONNETTORI_PA, "Connessioni attive su cui e' in corso una consegna di contenuti applicativi (PortaApplicativa)", null, String.class.getName(), 1);
        MBeanOperationInfo getActiveConnectionsPA_OP_method2 = new MBeanOperationInfo(CONNESSIONI_ALLOCATE_CONNETTORI_PA_METHOD2, "Connessioni attive su cui e' in corso una consegna di contenuti applicativi (PortaApplicativa)", null, String.class.getName(), 1);
        MBeanOperationInfo getRisorseSistema_OP = new MBeanOperationInfo(GET_STATO_RISORSE_DI_SISTEMA, "Ritorna lo stato delle risorse di sistema", null, String.class.getName(), 1);
        MBeanOperationInfo getRisorseSistema_OP_method2 = new MBeanOperationInfo(GET_STATO_RISORSE_DI_SISTEMA_METHOD2, "Ritorna lo stato delle risorse di sistema", null, String.class.getName(), 1);
        MBeanOperationInfo getRisorseCache_OP = new MBeanOperationInfo(GET_STATO_CACHES, "Ritorna lo stato delle cache utilizzate dalla Porta", null, String.class.getName(), 1);
        MBeanOperationInfo getRisorseCache_OP_method2 = new MBeanOperationInfo(GET_STATO_CACHES_METHOD2, "Ritorna lo stato delle cache utilizzate dalla Porta", null, String.class.getName(), 1);
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{monitoraggioPdDVAR, risorseDisponibiliVAR, numMsgInConsegnaVAR, tempoMedioAttesaInConsegnaVAR, tempoMaxAttesaInConsegnaVAR, numMsgInSpedizioneVAR, tempoMedioAttesaInSpedizioneVAR, tempoMaxAttesaInSpedizioneVAR, numMsgInProcessamentoVAR, tempoMedioAttesaInProcessamentoVAR, tempoMaxAttesaInProcessamentoVAR, totMessaggiVAR, tempoMedioAttesaVAR, tempoMaxAttesaVAR, totMessaggiDuplicatiVAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{getRisorseSistema_OP, getRisorseSistema_OP_method2, getRisorseCache_OP, getRisorseCache_OP_method2, getConnessioneAllocateDBManagerOP, getConnessioneAllocateDBManagerOP_method2, getConnessioneAllocateQueueManagerOP, getConnessioneAllocateQueueManagerOP_method2, getTransazioniAttiveOP, getTransazioniAttiveOP_method2, getDettaglioTransazioneAttiva, getTransazioniIdProtocolloAttiviOP, getTransazioniIdProtocolloAttiviOP_method2, getActiveConnectionsPD_OP, getActiveConnectionsPD_OP_method2, getActiveConnectionsPA_OP, getActiveConnectionsPA_OP_method2};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public void refreshDatiMonitoraggioPdD() {
        StringBuilder bf = new StringBuilder();
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            bf.append("Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage());
        }
        if (!TimerThresholdThread.freeSpace) {
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append("[ThresholdCheck] Non sono disponibili abbastanza risorse per la gestione delle richieste");
        }
        if (!Tracciamento.tracciamentoDisponibile) {
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append("Tracciamento non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage());
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append("Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage());
        }
        if (!Dump.isSistemaDumpDisponibile()) {
            if (bf.length() > 0) {
                bf.append("\n");
            }
            bf.append("Sistema di dump dei contenuti applicativi non disponibile: " + Dump.getMotivoMalfunzionamentoDump().getMessage());
        }
        if (bf.length() == 0) {
            bf.append(MESSAGGIO_RISORSE_ADEGUATE);
        }
        this.risorseDiSistema = bf.toString();
        try {
            OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
            if (properties.getDatabaseType() != null) {
                DriverMonitoraggio driver = new DriverMonitoraggio(properties.getJNDIName_DataSource(), properties.getDatabaseType(), properties.getJNDIContext_DataSource(), this.log);
                StatoPdd stato = driver.getStatoRichiestePendenti(new FilterSearch());
                this.numMsgInConsegna = stato.getNumMsgInConsegna();
                this.numMsgInSpedizione = stato.getNumMsgInSpedizione();
                this.numMsgInProcessamento = stato.getNumMsgInProcessamento();
                this.totMessaggi = stato.getTotMessaggi();
                this.totMessaggiDuplicati = stato.getTotMessaggiDuplicati();
                if (stato.getTempoMaxAttesa() > 0L) {
                    this.tempoMaxAttesa = Utilities.convertSystemTimeIntoStringMillisecondi((long)(stato.getTempoMaxAttesa() * 1000L), (boolean)false);
                }
                if (stato.getTempoMaxAttesaInConsegna() > 0L) {
                    this.tempoMaxAttesaInConsegna = Utilities.convertSystemTimeIntoStringMillisecondi((long)(stato.getTempoMaxAttesaInConsegna() * 1000L), (boolean)false);
                }
                if (stato.getTempoMaxAttesaInSpedizione() > 0L) {
                    this.tempoMaxAttesaInSpedizione = Utilities.convertSystemTimeIntoStringMillisecondi((long)(stato.getTempoMaxAttesaInSpedizione() * 1000L), (boolean)false);
                }
                if (stato.getTempoMaxAttesaInProcessamento() > 0L) {
                    this.tempoMaxAttesaInProcessamento = Utilities.convertSystemTimeIntoStringMillisecondi((long)(stato.getTempoMaxAttesaInProcessamento() * 1000L), (boolean)false);
                }
                if (stato.getTempoMedioAttesa() > 0L) {
                    this.tempoMedioAttesa = Utilities.convertSystemTimeIntoStringMillisecondi((long)(stato.getTempoMedioAttesa() * 1000L), (boolean)false);
                }
                if (stato.getTempoMedioAttesaInConsegna() > 0L) {
                    this.tempoMedioAttesaInConsegna = Utilities.convertSystemTimeIntoStringMillisecondi((long)(stato.getTempoMedioAttesaInConsegna() * 1000L), (boolean)false);
                }
                if (stato.getTempoMedioAttesaInSpedizione() > 0L) {
                    this.tempoMedioAttesaInSpedizione = Utilities.convertSystemTimeIntoStringMillisecondi((long)(stato.getTempoMedioAttesaInSpedizione() * 1000L), (boolean)false);
                }
                if (stato.getTempoMedioAttesaInProcessamento() > 0L) {
                    this.tempoMedioAttesaInProcessamento = Utilities.convertSystemTimeIntoStringMillisecondi((long)(stato.getTempoMedioAttesaInProcessamento() * 1000L), (boolean)false);
                }
            } else {
                this.datiMonitoraggioPdD = "Non disponibili: e' necessario indicare il tipo di database in govway.properties";
                throw new Exception("Per il monitoraggio della porta di dominio e' necessario indicare il tipo di database in govway.properties");
            }
            this.datiMonitoraggioPdD = "Aggiornati al " + DateManager.getDate().toString();
        }
        catch (Throwable e) {
            this.log.error("DriverMonitoraggio non inizializzato", e);
            this.datiMonitoraggioPdD = "Non disponibili: " + e.getMessage();
        }
    }

    public String getStatoCaches() {
        try {
            return Cache.printStatistics((String)"\n", (String)"\n-----------------------------------------------------\n");
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getUsedDBConnections() {
        String[] risorse = null;
        String[] risorseTransaction = null;
        String[] risorseStatistiche = null;
        String[] risorseConsegnePreseInCaricoSmistatore = null;
        String[] risorseConsegnePreseInCaricoRuntime = null;
        String[] risorseConsegnePreseInCaricoTransazioni = null;
        String[] risorseConsegneMessageBoxRuntime = null;
        String[] risorseConsegneMessageBoxTransazioni = null;
        try {
            boolean useDefaultManager;
            risorse = DBManager.getStatoRisorse();
            OpenSPCoop2Properties prop = OpenSPCoop2Properties.getInstance();
            boolean useRuntimePdDTransazioni = DBTransazioniManager.getInstance().useRuntimePdD();
            if (!useRuntimePdDTransazioni && !prop.isTransazioniDatasourceUseDBUtils()) {
                risorseTransaction = DBTransazioniManager.getStatoRisorse();
            }
            if (prop.isStatisticheGenerazioneEnabled()) {
                boolean useRuntimePdDStatistiche = DBStatisticheManager.getInstance().useRuntimePdD();
                boolean useTransazioniStatistiche = DBStatisticheManager.getInstance().useTransazioni();
                if (!(useRuntimePdDStatistiche || useTransazioniStatistiche || prop.isStatisticheDatasourceUseDBUtils())) {
                    risorseStatistiche = DBStatisticheManager.getStatoRisorse();
                }
            }
            if (prop.isServerJ2EE() != null && !prop.isServerJ2EE().booleanValue() && prop.isTimerConsegnaContenutiApplicativiAbilitato()) {
                useDefaultManager = DBConsegnePreseInCaricoManager.getInstanceSmistatore().useDefaultManager();
                if (!useDefaultManager && !prop.isTimerConsegnaContenutiApplicativi_smistatore_runtime_dataSource_useDBUtils()) {
                    risorseConsegnePreseInCaricoSmistatore = DBConsegnePreseInCaricoManager.getStatoRisorseSmistatore();
                }
                if (!(useDefaultManager = DBConsegnePreseInCaricoManager.getInstanceRuntime().useDefaultManager()) && !prop.isTimerConsegnaContenutiApplicativi_runtime_dataSource_useDBUtils()) {
                    risorseConsegnePreseInCaricoRuntime = DBConsegnePreseInCaricoManager.getStatoRisorseRuntime();
                }
                if (!(useDefaultManager = DBConsegnePreseInCaricoManager.getInstanceTransazioni().useDefaultManager()) && !prop.isTimerConsegnaContenutiApplicativi_transazioni_dataSource_useDBUtils()) {
                    risorseConsegnePreseInCaricoTransazioni = DBConsegnePreseInCaricoManager.getStatoRisorseTransazioni();
                }
            }
            if (prop.isIntegrationManagerEnabled()) {
                boolean bl = useDefaultManager = DBConsegneMessageBoxManager.getInstanceRuntime().useDefaultManager() || DBConsegneMessageBoxManager.getInstanceRuntime().useConsegnePreseInCaricoManager();
                if (!useDefaultManager && !prop.isIntegrationManager_runtime_dataSource_useDBUtils()) {
                    risorseConsegneMessageBoxRuntime = DBConsegneMessageBoxManager.getStatoRisorse_runtime();
                }
                boolean bl2 = useDefaultManager = DBConsegneMessageBoxManager.getInstanceTransazioni().useDefaultManager() || DBConsegneMessageBoxManager.getInstanceTransazioni().useConsegnePreseInCaricoManager();
                if (!useDefaultManager && !prop.isIntegrationManager_transazioni_dataSource_useDBUtils()) {
                    risorseConsegneMessageBoxTransazioni = DBConsegneMessageBoxManager.getStatoRisorse_transazioni();
                }
            }
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
        return MonitoraggioRisorse.getResultUsedDBConnections(risorse, risorseTransaction, risorseStatistiche, risorseConsegnePreseInCaricoSmistatore, risorseConsegnePreseInCaricoRuntime, risorseConsegnePreseInCaricoTransazioni, risorseConsegneMessageBoxRuntime, risorseConsegneMessageBoxTransazioni);
    }

    public static String getResultUsedDBConnections(String[] risorse, String[] risorseTransaction, String[] risorseStatistiche, String[] risorseConsegnePreseInCaricoSmistatore, String[] risorseConsegnePreseInCaricoRuntime, String[] risorseConsegnePreseInCaricoTransazioni, String[] risorseConsegneMessageBoxRuntime, String[] risorseConsegneMessageBoxTransazioni) {
        int i;
        if (!(risorse != null && risorse.length > 0 || risorseTransaction != null && risorseTransaction.length > 0 || risorseStatistiche != null && risorseStatistiche.length > 0)) {
            return MSG_NESSUNA_CONNESSIONE_ALLOCATA;
        }
        StringBuilder bf = new StringBuilder();
        if (risorse != null && risorse.length > 0) {
            bf.append(risorse.length + " risorse allocate: \n");
            for (i = 0; i < risorse.length; ++i) {
                bf.append(risorse[i] + "\n");
            }
        }
        if (risorseTransaction != null && risorseTransaction.length > 0) {
            bf.append(risorseTransaction.length + " risorse allocate per la gestione delle transazioni: \n");
            for (i = 0; i < risorseTransaction.length; ++i) {
                bf.append(risorseTransaction[i] + "\n");
            }
        }
        if (risorseStatistiche != null && risorseStatistiche.length > 0) {
            bf.append(risorseStatistiche.length + " risorse allocate per la generazione delle statistiche: \n");
            for (i = 0; i < risorseStatistiche.length; ++i) {
                bf.append(risorseStatistiche[i] + "\n");
            }
        }
        if (risorseConsegnePreseInCaricoSmistatore != null && risorseConsegnePreseInCaricoSmistatore.length > 0) {
            bf.append(risorseConsegnePreseInCaricoSmistatore.length + " risorse allocate per lo smistatore dei messaggi presi in carico: \n");
            for (i = 0; i < risorseConsegnePreseInCaricoSmistatore.length; ++i) {
                bf.append(risorseConsegnePreseInCaricoSmistatore[i] + "\n");
            }
        }
        if (risorseConsegnePreseInCaricoRuntime != null && risorseConsegnePreseInCaricoRuntime.length > 0) {
            bf.append(risorseConsegnePreseInCaricoRuntime.length + " risorse allocate per il gestore runtime dei messaggi presi in carico: \n");
            for (i = 0; i < risorseConsegnePreseInCaricoRuntime.length; ++i) {
                bf.append(risorseConsegnePreseInCaricoRuntime[i] + "\n");
            }
        }
        if (risorseConsegnePreseInCaricoTransazioni != null && risorseConsegnePreseInCaricoTransazioni.length > 0) {
            bf.append(risorseConsegnePreseInCaricoTransazioni.length + " risorse allocate per il gestore delle tracce relative ai messaggi presi in carico: \n");
            for (i = 0; i < risorseConsegnePreseInCaricoTransazioni.length; ++i) {
                bf.append(risorseConsegnePreseInCaricoTransazioni[i] + "\n");
            }
        }
        if (risorseConsegneMessageBoxRuntime != null && risorseConsegneMessageBoxRuntime.length > 0) {
            bf.append(risorseConsegneMessageBoxRuntime.length + " risorse allocate per il gestore runtime del servizio MessageBox: \n");
            for (i = 0; i < risorseConsegneMessageBoxRuntime.length; ++i) {
                bf.append(risorseConsegneMessageBoxRuntime[i] + "\n");
            }
        }
        if (risorseConsegneMessageBoxTransazioni != null && risorseConsegneMessageBoxTransazioni.length > 0) {
            bf.append(risorseConsegneMessageBoxTransazioni.length + " risorse allocate per il gestore delle tracce del servizio MessageBox: \n");
            for (i = 0; i < risorseConsegneMessageBoxTransazioni.length; ++i) {
                bf.append(risorseConsegneMessageBoxTransazioni[i] + "\n");
            }
        }
        return bf.toString();
    }

    public String getUsedQueueConnections() {
        String[] risorse = null;
        try {
            risorse = QueueManager.getStatoRisorse();
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
        return MonitoraggioRisorse.getResultUsedQueueConnections(risorse);
    }

    public static String getResultUsedQueueConnections(String[] risorse) {
        if (risorse == null || risorse.length <= 0) {
            return MSG_NESSUNA_CONNESSIONE_ALLOCATA;
        }
        StringBuilder bf = new StringBuilder();
        bf.append(risorse.length + " risorse allocate: \n");
        for (int i = 0; i < risorse.length; ++i) {
            bf.append(risorse[i] + "\n");
        }
        return bf.toString();
    }

    public String getTransazioniAttiveId() {
        List<String> risorse = null;
        try {
            risorse = TransactionContext.getTransactionKeys();
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
        return MonitoraggioRisorse.getResultTransazioniAttiveId(risorse);
    }

    public static String getResultTransazioniAttiveId(List<String> risorse) {
        if (risorse == null || risorse.size() <= 0) {
            return MSG_NESSUNA_TRANSAZIONE_ATTIVA;
        }
        StringBuilder bf = new StringBuilder();
        bf.append(risorse.size() + " transazioni attive: \n");
        for (int i = 0; i < risorse.size(); ++i) {
            bf.append(risorse.get(i) + "\n");
        }
        return bf.toString();
    }

    public String getDettaglioTransazioneAttivaId(String idTransazione) {
        try {
            Transaction tr = TransactionContext.getTransaction(idTransazione);
            if (tr != null) {
                return tr.toString();
            }
            throw new TransactionNotExistsException();
        }
        catch (TransactionNotExistsException notFound) {
            return "Transazione non esistente";
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getTransazioniAttiveIdProtocollo() {
        List<String> risorse = null;
        try {
            risorse = TransactionContext.getIdBustaKeys();
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
        return MonitoraggioRisorse.getResultTransazioniAttiveIdProtocollo(risorse);
    }

    public static String getResultTransazioniAttiveIdProtocollo(List<String> risorse) {
        if (risorse == null || risorse.size() <= 0) {
            return MSG_NESSUNA_TRANSAZIONE_ATTIVA;
        }
        StringBuilder bf = new StringBuilder();
        bf.append(risorse.size() + " id di protocollo attivi: \n");
        for (int i = 0; i < risorse.size(); ++i) {
            bf.append(risorse.get(i) + "\n");
        }
        return bf.toString();
    }

    public String getActivePDConnections() {
        Map<String, IConnettore> connettori_pd = RepositoryConnettori.getConnettori_pd();
        return this.getActiveConnections(connettori_pd);
    }

    public String getActivePAConnections() {
        Map<String, IConnettore> connettori_pa = RepositoryConnettori.getConnettori_pa();
        return this.getActiveConnections(connettori_pa);
    }

    private String getActiveConnections(Map<String, IConnettore> connettoriParam) {
        ArrayList<String> cConnettori = new ArrayList<String>();
        for (String id : connettoriParam.keySet()) {
            IConnettore c = connettoriParam.get(id);
            Object location = null;
            try {
                location = c.getLocation();
            }
            catch (Exception e) {
                location = "ERRORE: " + e.getMessage();
            }
            cConnettori.add(id + " -> [" + (String)location + "]");
        }
        return MonitoraggioRisorse.getResultActiveConnections(cConnettori);
    }

    public static String getResultActiveConnections(List<String> cConnettori) {
        if (cConnettori == null || cConnettori.size() == 0) {
            return MSG_NESSUNA_CONNESSIONE_ALLOCATA;
        }
        StringBuilder bf = new StringBuilder();
        bf.append(cConnettori.size() + " connessioni allocate: \n");
        for (int i = 0; i < cConnettori.size(); ++i) {
            bf.append(cConnettori.get(i) + "\n");
        }
        return bf.toString();
    }
}

