/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.keystore;

import java.io.ByteArrayOutputStream;
import java.security.PublicKey;
import java.util.Date;
import java.util.HashMap;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.eventi.Evento;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.PDNDConfigUtilities;
import org.openspcoop2.pdd.core.eventi.GestoreEventi;
import org.openspcoop2.pdd.core.keystore.KeystoreException;
import org.openspcoop2.pdd.core.keystore.KeystoreNotFoundException;
import org.openspcoop2.pdd.core.keystore.RemoteStoreClientDetails;
import org.openspcoop2.pdd.core.keystore.RemoteStoreKey;
import org.openspcoop2.pdd.core.keystore.RemoteStoreProviderDriverUtils;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.pdnd.TimerGestoreChiaviPDNDLib;
import org.openspcoop2.security.keystore.cache.RemoteStoreClientInfoCache;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.JWK;
import org.openspcoop2.utils.certificate.KeyUtils;
import org.openspcoop2.utils.certificate.remote.IRemoteStoreProvider;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreClientInfo;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.certificate.remote.RemoteStoreUtils;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.slf4j.Logger;

public class RemoteStoreProviderDriver
implements IRemoteStoreProvider {
    private static volatile int keyMaxLifeMinutes = -1;
    private static final java.util.Map<String, RemoteStoreProviderDriver> _providerStore = new HashMap<String, RemoteStoreProviderDriver>();
    private static final java.util.Map<String, Semaphore> _lockStore = new HashMap<String, Semaphore>();
    private DriverConfigurazioneDB driverConfigurazioneDB = null;
    private Logger log;
    private RemoteStoreConfig remoteStoreConfig;
    private String keyAlgorithm;
    private long remoteStoreId;
    private static volatile boolean createEntryIfNotExists = true;

    public static int getKeyMaxLifeMinutes() {
        return keyMaxLifeMinutes;
    }

    public static void setKeyMaxLifeMinutes(int keyMaxLifeMinutes) {
        RemoteStoreProviderDriver.keyMaxLifeMinutes = keyMaxLifeMinutes;
    }

    public static synchronized void initialize(Logger log, RemoteStoreConfig remoteStoreConfig) throws KeystoreException {
        String storeConfigName = RemoteStoreProviderDriver.getRemoteStoreConfigName(remoteStoreConfig);
        RemoteStoreProviderDriver s = new RemoteStoreProviderDriver(log, remoteStoreConfig);
        _providerStore.put(storeConfigName, s);
    }

    static RemoteStoreProviderDriver getProviderStore(String storeConfigName) throws KeystoreException {
        RemoteStoreProviderDriver s = _providerStore.get(storeConfigName);
        if (s == null) {
            throw new KeystoreException("ProviderStore '" + storeConfigName + "' not exists");
        }
        return s;
    }

    private static synchronized Semaphore initLockStore(String nomeRemoteStore) {
        Semaphore s = _lockStore.get(nomeRemoteStore);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getGestioneTokenValidazioneJWTLockPermits();
            s = permits != null && permits > 1 ? new Semaphore("GestoreTokenValidazioneJWT_" + nomeRemoteStore, permits.intValue()) : new Semaphore("GestoreTokenValidazioneJWT_" + nomeRemoteStore);
            _lockStore.put(nomeRemoteStore, s);
        }
        return s;
    }

    private static Semaphore getLockStore(String nomeRemoteStore) {
        Semaphore s = _lockStore.get(nomeRemoteStore);
        if (s == null) {
            s = RemoteStoreProviderDriver.initLockStore(nomeRemoteStore);
        }
        return s;
    }

    static String getRemoteStoreConfigName(RemoteStoreConfig remoteStoreConfig) throws KeystoreException {
        if (remoteStoreConfig == null) {
            throw new KeystoreException("RemoteStoreConfig undefined");
        }
        String remoteStoreName = remoteStoreConfig.getStoreName();
        if (remoteStoreName == null) {
            throw new KeystoreException("RemoteStoreConfig name undefined");
        }
        return remoteStoreName;
    }

    private RemoteStoreProviderDriver(Logger log, RemoteStoreConfig remoteStoreConfig) throws KeystoreException {
        IDriverConfigurazioneGet oConfig;
        this.log = log;
        RemoteStoreProviderDriver.getRemoteStoreConfigName(remoteStoreConfig);
        this.remoteStoreConfig = remoteStoreConfig;
        this.keyAlgorithm = remoteStoreConfig.getKeyAlgorithm();
        if (this.keyAlgorithm == null) {
            this.keyAlgorithm = "RSA";
        }
        if (!((oConfig = ConfigurazionePdDReader.getDriverConfigurazionePdD()) instanceof DriverConfigurazioneDB)) {
            throw new KeystoreException("RemoteStoreProvider utilizzabile solamente con una configurazione su database");
        }
        this.driverConfigurazioneDB = (DriverConfigurazioneDB)oConfig;
        this.remoteStoreId = RemoteStoreProviderDriverUtils.registerIfNotExistsRemoteStore(this.driverConfigurazioneDB, this.remoteStoreConfig);
    }

    private String getPrefixKid(String keyId) {
        return "Chiave con kid '" + keyId + "'";
    }

    private Object readKey(RemoteKeyType remoteStoreKeyType, String keyId, ByteArrayOutputStream bout, RemoteStoreConfig remoteConfig) throws KeystoreException {
        RemoteStoreKey key = null;
        try {
            key = RemoteStoreProviderDriverUtils.getRemoteStoreKey(this.driverConfigurazioneDB, this.remoteStoreId, keyId);
        }
        catch (KeystoreNotFoundException notFound) {
            String msg = this.getPrefixKid(keyId) + " non presente su database";
            this.log.debug(msg);
        }
        boolean updateRequired = this.isUpdateRequired(key, keyId);
        if (!updateRequired && key != null && key.getKey() != null) {
            try {
                switch (remoteStoreKeyType) {
                    case JWK: {
                        return new JWK(new String(key.getKey()));
                    }
                    case PUBLIC_KEY: {
                        return KeyUtils.getInstance((String)this.keyAlgorithm).getPublicKey(key.getKey());
                    }
                    case X509: {
                        return ArchiveLoader.load((byte[])key.getKey());
                    }
                }
            }
            catch (Exception e) {
                throw new KeystoreException(e.getMessage(), e);
            }
        }
        Semaphore semaphore = RemoteStoreProviderDriver.getLockStore(this.remoteStoreConfig.getStoreName());
        SemaphoreLock lock = null;
        try {
            lock = semaphore.acquire("readKey");
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        try {
            Object object;
            ByteArrayOutputStream boutInternal = new ByteArrayOutputStream();
            try {
                ByteArrayOutputStream b = bout != null ? bout : boutInternal;
                RemoteStoreConfig remoteConfigUse = remoteConfig != null && remoteConfig.isMultitenant() ? remoteConfig : this.remoteStoreConfig;
                Object objectKey = null;
                switch (remoteStoreKeyType) {
                    case JWK: {
                        objectKey = RemoteStoreUtils.readJWK((String)keyId, (RemoteStoreConfig)remoteConfigUse, (ByteArrayOutputStream)b);
                        break;
                    }
                    case PUBLIC_KEY: {
                        objectKey = RemoteStoreUtils.readPublicKey((String)keyId, (RemoteStoreConfig)remoteConfigUse, (ByteArrayOutputStream)b);
                        break;
                    }
                    case X509: {
                        objectKey = RemoteStoreUtils.readX509((String)keyId, (RemoteStoreConfig)remoteConfigUse, (ByteArrayOutputStream)b);
                    }
                }
                this.saveKey(updateRequired, keyId, b);
                object = objectKey;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        boutInternal.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new KeystoreException(e.getMessage(), e);
                }
            }
            boutInternal.close();
            return object;
        }
        finally {
            semaphore.release(lock, "readKey");
        }
    }

    private void saveKey(boolean updateRequired, String keyId, ByteArrayOutputStream b) throws KeystoreException, TimerException {
        if (updateRequired) {
            String msg = this.getPrefixKid(keyId) + " ottenuta da remote store config, aggiornamento entry sul db ...";
            this.log.debug(msg);
            int rows = RemoteStoreProviderDriverUtils.updateRemoteStoreKey(this.driverConfigurazioneDB, this.remoteStoreId, keyId, b.toByteArray());
            msg = this.getPrefixKid(keyId) + " ottenuta da remote store config, aggiornata entry sul db (updateRows:" + rows + ")";
            this.log.debug(msg);
        } else {
            String msg = this.getPrefixKid(keyId) + " ottenuta da remote store config, registrazione sul db ...";
            this.log.debug(msg);
            int rows = RemoteStoreProviderDriverUtils.addRemoteStoreKey(this.driverConfigurazioneDB, this.remoteStoreId, keyId, b.toByteArray());
            msg = this.getPrefixKid(keyId) + " ottenuta da remote store config, registrata entry sul db (updateRows:" + rows + ")";
            this.log.debug(msg);
            if (OpenSPCoop2Properties.getInstance().isGestoreChiaviPDNDEventiAdd()) {
                String eventType = "Add";
                Evento evento = TimerGestoreChiaviPDNDLib.buildEvento(eventType, keyId, "La chiave \u00e8 stata aggiunta al repository locale");
                this.registerEvent(evento, keyId, eventType);
            }
        }
    }

    private void registerEvent(Evento evento, String keyId, String eventType) {
        try {
            GestoreEventi.getInstance().log(evento);
        }
        catch (Exception e) {
            String msgError = "Registrazione evento per kid '" + keyId + "' (eventType:" + eventType + ") non riuscita: " + e.getMessage();
            this.log.error(msgError, (Throwable)e);
        }
    }

    private boolean isUpdateRequired(RemoteStoreKey key, String keyId) {
        if (key != null && key.isInvalid()) {
            String msg = this.getPrefixKid(keyId) + " non \u00e8 valida";
            this.log.debug(msg);
            return true;
        }
        if (key != null && keyMaxLifeMinutes > 0 && key.getDataAggiornamento() != null) {
            long maxLifeSeconds = (long)keyMaxLifeMinutes * 60L;
            long maxLifeMs = maxLifeSeconds * 1000L;
            Date tooOld = new Date(DateManager.getTimeMillis() - maxLifeMs);
            if (key.getDataAggiornamento().before(tooOld)) {
                String msg = this.getPrefixKid(keyId) + " \u00e8 pi\u00f9 vecchia di " + keyMaxLifeMinutes + " minuti (data aggiornamento: " + DateUtils.getSimpleDateFormatMs().format(key.getDataAggiornamento()) + ")";
                this.log.debug(msg);
                return true;
            }
        }
        return false;
    }

    public JWK readJWK(String keyId, RemoteStoreConfig remoteConfig) throws UtilsException {
        try {
            return (JWK)this.readKey(RemoteKeyType.JWK, keyId, null, remoteConfig);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public JWK readJWK(String keyId, RemoteStoreConfig remoteConfig, ByteArrayOutputStream bout) throws UtilsException {
        try {
            return (JWK)this.readKey(RemoteKeyType.JWK, keyId, bout, remoteConfig);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public Certificate readX509(String keyId, RemoteStoreConfig remoteConfig) throws UtilsException {
        try {
            return (Certificate)this.readKey(RemoteKeyType.X509, keyId, null, remoteConfig);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public Certificate readX509(String keyId, RemoteStoreConfig remoteConfig, ByteArrayOutputStream bout) throws UtilsException {
        try {
            return (Certificate)this.readKey(RemoteKeyType.X509, keyId, bout, remoteConfig);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public PublicKey readPublicKey(String keyId, RemoteStoreConfig remoteConfig) throws UtilsException {
        try {
            return (PublicKey)this.readKey(RemoteKeyType.PUBLIC_KEY, keyId, null, remoteConfig);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public PublicKey readPublicKey(String keyId, RemoteStoreConfig remoteConfig, ByteArrayOutputStream bout) throws UtilsException {
        try {
            return (PublicKey)this.readKey(RemoteKeyType.PUBLIC_KEY, keyId, bout, remoteConfig);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public RemoteStoreClientInfo readClientInfo(String keyId, String clientId, RemoteStoreConfig remoteConfig, Map<Object> context) throws UtilsException {
        try {
            return this.readClientInfoEngine(keyId, clientId, remoteConfig, context);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public static void setCreateEntryIfNotExists(boolean createEntryIfNotExists) {
        RemoteStoreProviderDriver.createEntryIfNotExists = createEntryIfNotExists;
    }

    private RemoteStoreClientInfo readClientInfoEngine(String keyId, String clientId, RemoteStoreConfig remoteConfig, Map<Object> context) throws KeystoreException {
        RemoteStoreClientDetails clientDetails = null;
        try {
            clientDetails = RemoteStoreProviderDriverUtils.getRemoteStoreClientDetails(this.driverConfigurazioneDB, this.remoteStoreId, keyId, this.log, createEntryIfNotExists, remoteConfig);
            if (clientDetails == null) {
                throw new KeystoreNotFoundException("Client details not found");
            }
        }
        catch (KeystoreNotFoundException notFound) {
            String msg = this.getPrefixKidClientDetails(keyId) + " non presente su database";
            this.log.error(msg);
            return null;
        }
        boolean updateRequired = this.isUpdateRequired(clientDetails, keyId, clientId);
        if (!updateRequired) {
            return clientDetails.getClientInfo();
        }
        Semaphore semaphore = RemoteStoreProviderDriver.getLockStore(this.remoteStoreConfig.getStoreName());
        SemaphoreLock lock = null;
        try {
            lock = semaphore.acquire("readClientDetails");
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        try {
            OpenSPCoop2Properties propertiesReader = OpenSPCoop2Properties.getInstance();
            RemoteStoreConfig remoteConfigUse = remoteConfig != null && remoteConfig.isMultitenant() ? remoteConfig : this.remoteStoreConfig;
            String clientJson = PDNDConfigUtilities.readClientDetails(remoteConfigUse, propertiesReader, context, clientId, this.log);
            String organizationId = null;
            String organizationJson = null;
            if (clientJson != null && (organizationId = PDNDConfigUtilities.readOrganizationId(remoteConfigUse, propertiesReader, context, clientJson, this.log)) != null) {
                organizationJson = PDNDConfigUtilities.readOrganizationDetails(remoteConfigUse, propertiesReader, context, organizationId, this.log);
            }
            clientDetails.setDataAggiornamento(DateManager.getDate());
            if (clientDetails.getClientInfo() == null) {
                clientDetails.setClientInfo(new RemoteStoreClientInfo());
            }
            clientDetails.getClientInfo().setClientId(clientId);
            clientDetails.getClientInfo().setClientDetails(clientJson);
            clientDetails.getClientInfo().setOrganizationId(organizationId);
            clientDetails.getClientInfo().setOrganizationDetails(organizationJson);
            String msg = this.getPrefixKidClientDetails(keyId) + " ottenuta da remote store config, aggiornamento entry sul db ...";
            this.log.debug(msg);
            int rows = RemoteStoreProviderDriverUtils.updateRemoteStoreClientDetails(this.driverConfigurazioneDB, this.remoteStoreId, keyId, clientDetails);
            msg = this.getPrefixKidClientDetails(keyId) + " ottenuta da remote store config, aggiornata entry sul db (updateRows:" + rows + ")";
            this.log.debug(msg);
            RemoteStoreClientInfo remoteStoreClientInfo = clientDetails.getClientInfo();
            return remoteStoreClientInfo;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        finally {
            semaphore.release(lock, "readClientDetails");
        }
    }

    private String getPrefixKidClientDetails(String keyId) {
        return "ClientDetails con kid '" + keyId + "'";
    }

    private boolean isUpdateRequired(RemoteStoreClientDetails clientDetails, String keyId, String clientId) {
        if (clientDetails != null && clientDetails.isInvalid()) {
            String msg = this.getPrefixKidClientDetails(keyId) + " non \u00e8 valida";
            this.log.debug(msg);
            return true;
        }
        if (clientDetails != null && clientDetails.getClientInfo() == null) {
            String msg = this.getPrefixKidClientDetails(keyId) + " client info non presente";
            this.log.debug(msg);
            return true;
        }
        if (clientDetails != null && clientDetails.getClientInfo().getClientId() == null) {
            String msg = this.getPrefixKidClientDetails(keyId) + " client id non presente";
            this.log.debug(msg);
            return true;
        }
        if (clientDetails != null && !clientDetails.getClientInfo().getClientId().equals(clientId)) {
            String msg = this.getPrefixKidClientDetails(keyId) + " client id differente da quello presente su database";
            this.log.debug(msg);
            return true;
        }
        return this.isUpdateRequiredByMaxLife(clientDetails, keyId);
    }

    private boolean isUpdateRequiredByMaxLife(RemoteStoreClientDetails clientDetails, String keyId) {
        if (clientDetails != null) {
            int maxLife;
            int n = maxLife = clientDetails.isInfoComplete() ? RemoteStoreClientInfoCache.getClientDetailsMaxLifeMinutes() : RemoteStoreClientInfoCache.getClientDetailsCacheFallbackMaxLifeMinutes();
            if (maxLife > 0 && clientDetails.getDataAggiornamento() != null) {
                long maxLifeSeconds = (long)maxLife * 60L;
                long maxLifeMs = maxLifeSeconds * 1000L;
                Date tooOld = new Date(DateManager.getTimeMillis() - maxLifeMs);
                if (clientDetails.getDataAggiornamento().before(tooOld)) {
                    String msg = this.getPrefixKidClientDetails(keyId) + " \u00e8 pi\u00f9 vecchia di " + maxLife + " minuti (data aggiornamento: " + DateUtils.getSimpleDateFormatMs().format(clientDetails.getDataAggiornamento()) + ")(info-complete:" + clientDetails.isInfoComplete() + ")";
                    this.log.debug(msg);
                    return true;
                }
            }
        }
        return false;
    }
}

