/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.node;

import java.sql.Connection;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.INodeReceiver;
import org.openspcoop2.pdd.core.node.NodeException;
import org.openspcoop2.pdd.core.node.NodeTimeoutException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.mdb.GenericMessage;
import org.openspcoop2.pdd.services.core.RicezioneBusteMessage;
import org.openspcoop2.pdd.services.core.RicezioneContenutiApplicativiMessage;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Utilities;

public class NodeReceiverDB
extends AbstractCore
implements INodeReceiver {
    private static OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();

    @Override
    public Object receive(MsgDiagnostico msgDiag, IDSoggetto codicePorta, String idModulo, String idMessaggio, long timeout, long checkInterval) throws NodeException, NodeTimeoutException {
        GenericMessage objReturn = null;
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        Connection connectionDB = null;
        String tipoMessaggio = null;
        if (idModulo.startsWith("RicezioneContenutiApplicativi")) {
            tipoMessaggio = "INBOX";
        } else if (idModulo.startsWith("RicezioneBuste")) {
            tipoMessaggio = "OUTBOX";
        }
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        openspcoopstate.setStatoRichiesta((IState)new StatefulMessage(null, null));
        openspcoopstate.setStatoRisposta((IState)new StatefulMessage(null, null));
        GestoreMessaggi gestoreMessaggioRichiesta = new GestoreMessaggi(openspcoopstate, false, idMessaggio, tipoMessaggio, msgDiag, null);
        try {
            String idRisposta = null;
            GestoreMessaggi gestoreMessaggioRisposta = null;
            boolean messaggioPresente = false;
            int refreshOnlyCacheCount = 0;
            for (long attesa = 0L; attesa < timeout; attesa += checkInterval) {
                msgDiag.highDebug("Analisi richiesta con ID [" + idMessaggio + "] tipo [" + tipoMessaggio + "] contatoreRif[" + ++refreshOnlyCacheCount + "]");
                int nodeDBRefresh = openspcoopProperties.getNodeReceiverCheckDBInterval();
                int nodeRiferimentoMsgRefresh = openspcoopProperties.getNodeReceiverCheckDBInterval();
                try {
                    if (nodeRiferimentoMsgRefresh > 2) {
                        nodeRiferimentoMsgRefresh = nodeDBRefresh / 2;
                    }
                }
                catch (Exception e) {
                    msgDiag.highDebug("CheckDBInterval (proprieta' 'org.openspcoop.pdd.nodeReceiver.checkDB') non corretto: " + e.getMessage());
                }
                msgDiag.highDebug("Proprieta' nodeDBRefresh[" + nodeDBRefresh + "] nodeRiferimentoMsgRefresh[" + nodeRiferimentoMsgRefresh + "]");
                boolean checkOnlyCache = openspcoopProperties.isAbilitataCacheGestoreMessaggi();
                if (refreshOnlyCacheCount == nodeDBRefresh + 1) {
                    msgDiag.highDebug("Re-inizializzo contatore refreshOnlyCacheCount");
                    refreshOnlyCacheCount = 1;
                    checkOnlyCache = false;
                }
                if (refreshOnlyCacheCount % nodeRiferimentoMsgRefresh == 0) {
                    msgDiag.highDebug("Re-inizializzo idRisposta e gestoreMessaggioRisposta");
                    idRisposta = null;
                    gestoreMessaggioRisposta = null;
                }
                boolean needConnection = false;
                if (!openspcoopProperties.singleConnectionTransactionManager()) {
                    needConnection = true;
                } else if (resource == null) {
                    needConnection = true;
                }
                if (!checkOnlyCache && needConnection) {
                    msgDiag.highDebug("Prendo Connessione per NodeReceiver");
                    try {
                        resource = dbManager.getResource(codicePorta, idModulo, PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, this.getPddContext()));
                    }
                    catch (Exception e) {
                        throw new NodeException("Impossibile ottenere una Risorsa dal DBManager", e);
                    }
                    if (resource == null) {
                        throw new NodeException("Risorsa is null");
                    }
                    if (resource.getResource() == null) {
                        throw new NodeException("Connessione is null");
                    }
                    connectionDB = (Connection)resource.getResource();
                    ((StateMessage)openspcoopstate.getStatoRichiesta()).setConnectionDB(connectionDB);
                    ((StateMessage)openspcoopstate.getStatoRisposta()).setConnectionDB(connectionDB);
                }
                if (idRisposta == null) {
                    msgDiag.highDebug("Analisi richiesta con ID [" + idMessaggio + "] tipo [" + tipoMessaggio + "]: lettura ID Risposta");
                    idRisposta = gestoreMessaggioRichiesta.mapRiferimentoIntoIDBusta(checkOnlyCache);
                }
                if (idRisposta != null) {
                    if (gestoreMessaggioRisposta == null) {
                        msgDiag.highDebug("Analisi richiesta con ID [" + idMessaggio + "] tipo [" + tipoMessaggio + "]: Costruisco GestoreRisposta per ID[" + idRisposta + "]");
                        gestoreMessaggioRisposta = new GestoreMessaggi(openspcoopstate, false, idRisposta, tipoMessaggio, msgDiag, null);
                        msgDiag.highDebug("Analisi risposta con ID [" + idRisposta + "] tipo [" + tipoMessaggio + "]: existsMessage(" + checkOnlyCache + ")");
                        messaggioPresente = checkOnlyCache ? gestoreMessaggioRisposta.existsMessage_onlyCache() : gestoreMessaggioRisposta.existsMessage();
                    } else if (!messaggioPresente) {
                        msgDiag.highDebug("Analisi risposta con ID [" + idRisposta + "] tipo [" + tipoMessaggio + "]: existsMessage(" + checkOnlyCache + ")");
                        messaggioPresente = checkOnlyCache ? gestoreMessaggioRisposta.existsMessage_onlyCache() : gestoreMessaggioRisposta.existsMessage();
                    }
                }
                msgDiag.highDebug("Analisi risposta con ID [" + idRisposta + "] tipo [" + tipoMessaggio + "]: existsMessage=" + messaggioPresente);
                if (messaggioPresente) {
                    msgDiag.highDebug("getProprietario(" + checkOnlyCache + ")");
                    String proprietario = gestoreMessaggioRisposta.getProprietario(idModulo, checkOnlyCache);
                    msgDiag.highDebug("getProprietario(" + checkOnlyCache + ") proprietario=" + proprietario);
                    if (idModulo.startsWith("RicezioneContenutiApplicativi")) {
                        messaggioPresente = idModulo.equals(proprietario);
                    } else if (idModulo.startsWith("RicezioneBuste")) {
                        messaggioPresente = idModulo.equals(proprietario);
                    }
                    msgDiag.highDebug("Analisi risposta con ID [" + idRisposta + "] tipo [" + tipoMessaggio + "] proprietario[" + proprietario + " existsMessage=" + messaggioPresente);
                }
                if (!messaggioPresente) {
                    if (!openspcoopProperties.singleConnectionNodeReceiver() && !checkOnlyCache) {
                        msgDiag.highDebug("Rilascio connessione per NodeReceiver");
                        dbManager.releaseResource(codicePorta, idModulo, resource);
                    }
                    msgDiag.highDebug("Sleep...");
                    Utilities.sleep((long)checkInterval);
                    continue;
                }
                if (needConnection && checkOnlyCache) {
                    msgDiag.highDebug("Prendo Connessione per NodeReceiver");
                    try {
                        resource = dbManager.getResource(codicePorta, idModulo, PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, this.getPddContext()));
                    }
                    catch (Exception e) {
                        throw new NodeException("Impossibile ottenere una Risorsa dal DBManager", e);
                    }
                    if (resource == null) {
                        throw new NodeException("Risorsa is null");
                    }
                    if (resource.getResource() == null) {
                        throw new NodeException("Connessione is null");
                    }
                    connectionDB = (Connection)resource.getResource();
                }
                StatefulMessage state = new StatefulMessage(connectionDB, null);
                if (idModulo.startsWith("RicezioneContenutiApplicativi")) {
                    msgDiag.highDebug("Lettura risposta per RicezioneContenutiApplicativi...");
                    objReturn = new RicezioneContenutiApplicativiMessage();
                    ((RicezioneContenutiApplicativiMessage)objReturn).setIdBustaRisposta(idRisposta);
                    RepositoryBuste repositoryBuste = new RepositoryBuste((IState)state, false, null);
                    ((RicezioneContenutiApplicativiMessage)objReturn).setIdCollaborazione(repositoryBuste.getCollaborazioneFromInBox(idRisposta));
                    ((RicezioneContenutiApplicativiMessage)objReturn).setProfiloCollaborazione(repositoryBuste.getProfiloCollaborazioneFromInBox(idRisposta), repositoryBuste.getProfiloCollaborazioneValueFromInBox(idRisposta));
                    try {
                        ((RicezioneContenutiApplicativiMessage)objReturn).setPddContext(gestoreMessaggioRisposta.getPdDContext());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    msgDiag.highDebug("Lettura risposta per RicezioneContenutiApplicativi effettuata");
                } else if (idModulo.startsWith("RicezioneBuste")) {
                    msgDiag.highDebug("Lettura risposta per RicezioneBuste...");
                    objReturn = new RicezioneBusteMessage();
                    RepositoryBuste repositoryBuste = new RepositoryBuste((IState)state, false, null);
                    if (repositoryBuste.isRegistrataIntoOutBox(idRisposta)) {
                        ((RicezioneBusteMessage)objReturn).setBustaRisposta(repositoryBuste.getBustaFromOutBox(idRisposta));
                    } else {
                        ((RicezioneBusteMessage)objReturn).setIdMessaggioSblocco(idRisposta);
                    }
                    try {
                        ((RicezioneBusteMessage)objReturn).setPddContext(gestoreMessaggioRisposta.getPdDContext());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    msgDiag.highDebug("Lettura risposta per RicezioneBuste effettuata");
                }
                if (!openspcoopProperties.singleConnectionNodeReceiver() && !checkOnlyCache) {
                    msgDiag.highDebug("Rilascio connessione per NodeReceiver");
                    dbManager.releaseResource(codicePorta, idModulo, resource);
                }
                msgDiag.highDebug("Fine Lettura");
                break;
            }
        }
        catch (Exception e) {
            throw new NodeException("Riscontrato errore nella ricezione del messaggio di risposta per la gestione della richiesta:" + e.getMessage(), e);
        }
        finally {
            msgDiag.highDebug("Rilascio connessione per NodeReceiver");
            dbManager.releaseResource(codicePorta, idModulo, resource);
        }
        if (objReturn == null) {
            throw new NodeTimeoutException("Riscontrato errore durante ricezione del messaggio: Messaggio non ricevuto");
        }
        return objReturn;
    }
}

