/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.response_caching.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.soap.SOAPElement;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneHashGenerator;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.AttachmentsProcessingMode;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.pdd.core.response_caching.HashGenerator;
import org.openspcoop2.pdd.core.response_caching.ResponseCached;
import org.openspcoop2.protocol.engine.URLProtocolContextImpl;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class ResponseCachingTest {
    private static final String SOAP_ENVELOPE_RISPOSTA = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Header></soapenv:Header>";
    private static final String SOAP_ENVELOPE_RISPOSTA_END = "<soapenv:Body><prova>test</prova></soapenv:Body></soapenv:Envelope>";

    public static void main(String[] args) throws Exception {
        ResponseCachingTest.test();
    }

    public static void test() throws Exception {
        Logger log = LoggerWrapperFactory.getLogger(ResponseCachingTest.class);
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.setIdServizio(IDServizioFactory.getInstance().getIDServizioFromValues("gw", "serv", "gw", "RegioneToscana", 1));
        requestInfo.getIdServizio().setAzione("az");
        URLProtocolContextImpl protocolContext = new URLProtocolContextImpl(log);
        requestInfo.setProtocolContext((URLProtocolContext)protocolContext);
        protocolContext.setInterfaceName("nomePortaDelegataXXXX");
        protocolContext.setFunction("PD");
        protocolContext.setRequestURI("http://govway/in/GW_serv/RGT");
        protocolContext.setParameters(new HashMap());
        TransportUtils.addParameter((java.util.Map)protocolContext.getParameters(), (String)"p1", (String)"v1");
        TransportUtils.addParameter((java.util.Map)protocolContext.getParameters(), (String)"p2", (String)"v2a");
        TransportUtils.addParameter((java.util.Map)protocolContext.getParameters(), (String)"p2", (String)"v2b");
        protocolContext.setHeaders(new HashMap());
        TransportUtils.addHeader((java.util.Map)protocolContext.getHeaders(), (String)"h1", (String)"v1");
        TransportUtils.addHeader((java.util.Map)protocolContext.getHeaders(), (String)"h2", (String)"v2a");
        TransportUtils.addHeader((java.util.Map)protocolContext.getHeaders(), (String)"h2", (String)"v2b");
        TransportUtils.addHeader((java.util.Map)protocolContext.getHeaders(), (String)"h3", (String)"v3");
        TransportUtils.addHeader((java.util.Map)protocolContext.getHeaders(), (String)"Content-Type", (String)"text/xml");
        String messaggio = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Header></soapenv:Header><soapenv:Body><prova>test</prova></soapenv:Body></soapenv:Envelope>";
        byte[] messaggioArray = messaggio.getBytes();
        ByteArrayInputStream bin = new ByteArrayInputStream(messaggioArray);
        OpenSPCoop2MessageFactory messageFactory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        OpenSPCoop2MessageParseResult pr = messageFactory.createMessage(MessageType.SOAP_11, (TransportRequestContext)protocolContext, (InputStream)bin, null);
        OpenSPCoop2Message msg = pr.getMessage_throwParseException();
        MapKey CONT1 = Map.newMapKey((String)"CONT1");
        MapKey CONT2 = Map.newMapKey((String)"CONT2");
        msg.addContextProperty(CONT1, (Object)"V1");
        msg.addContextProperty(CONT2, (Object)"V2");
        HashGenerator generator = new HashGenerator("MD5");
        ResponseCachingConfigurazione responseCachingConfig = new ResponseCachingConfigurazione();
        responseCachingConfig.setHashGenerator(new ResponseCachingConfigurazioneHashGenerator());
        ArrayList headers = new ArrayList();
        headers.addAll(protocolContext.getHeaders().keySet());
        responseCachingConfig.getHashGenerator().setHeaders(StatoFunzionalita.ABILITATO);
        responseCachingConfig.getHashGenerator().setHeaderList(headers);
        System.out.println("TEST1: " + generator.buildKeyCache(msg, requestInfo, responseCachingConfig));
        System.out.println("TEST2: " + generator.buildKeyCache(msg, requestInfo, responseCachingConfig));
        protocolContext.getParameters().remove("p1");
        System.out.println("TEST3 ko: " + generator.buildKeyCache(msg, requestInfo, responseCachingConfig));
        TransportUtils.addParameter((java.util.Map)protocolContext.getParameters(), (String)"p1", (String)"v1");
        System.out.println("TEST3 ok: " + generator.buildKeyCache(msg, requestInfo, responseCachingConfig));
        protocolContext.getHeaders().remove("h1");
        System.out.println("TEST4 ko: " + generator.buildKeyCache(msg, requestInfo, responseCachingConfig));
        TransportUtils.addHeader((java.util.Map)protocolContext.getHeaders(), (String)"h1", (String)"v1");
        System.out.println("TEST4 ok: " + generator.buildKeyCache(msg, requestInfo, responseCachingConfig));
        SOAPElement n = msg.castAsSoap().getSOAPBody().addChildElement("empty");
        System.out.println("TEST5 ko: " + generator.buildKeyCache(msg, requestInfo, responseCachingConfig));
        msg.castAsSoap().getSOAPBody().removeChild((Node)n);
        System.out.println("TEST5 ok: " + generator.buildKeyCache(msg, requestInfo, responseCachingConfig));
        requestInfo.getIdServizio().setAzione("BOBO");
        System.out.println("TEST6 ko: " + generator.buildKeyCache(msg, requestInfo, responseCachingConfig));
        requestInfo.getIdServizio().setAzione("az");
        System.out.println("TEST6 ok: " + generator.buildKeyCache(msg, requestInfo, responseCachingConfig));
        int seconds = 300;
        ResponseCached rCached = ResponseCached.toResponseCached(msg, seconds);
        AttachmentsProcessingMode attachmentProcessingMode = AttachmentsProcessingMode.getMemoryCacheProcessingMode();
        OpenSPCoop2Message msgRebuild = rCached.toOpenSPCoop2Message(messageFactory, attachmentProcessingMode, "GovWay-CacheKey");
        System.out.println("TESTRebuild ok: " + generator.buildKeyCache(msgRebuild, requestInfo, responseCachingConfig));
        System.out.println("TEST print: " + rCached.print());
    }
}

