/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.threshold;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.threshold.IThreshold;
import org.openspcoop2.pdd.core.threshold.ThresholdException;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.slf4j.Logger;

public class PostgreSQLThreshold
implements IThreshold {
    private static OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
    public static final String ID_MODULO = "PostgreSQLThreshold";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean check(Properties parametri) throws ThresholdException {
        String query;
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        long threshold = -1L;
        long size = 0L;
        long factor = 1L;
        boolean result = false;
        Statement s = null;
        ResultSet rs = null;
        String debugS = parametri.getProperty("debug");
        boolean debug = false;
        if (debugS != null) {
            debug = Boolean.valueOf(debugS);
        }
        if ((query = parametri.getProperty("query")) == null) {
            throw new ThresholdException("Parametro 'query' non presente");
        }
        String valoreSoglia = parametri.getProperty("valore");
        if (valoreSoglia == null) {
            throw new ThresholdException("Parametro 'valore' non presente");
        }
        valoreSoglia = valoreSoglia.trim();
        String datasource = parametri.getProperty("datasource");
        if (datasource != null) {
            datasource = datasource.trim();
        }
        String soglia = valoreSoglia.toLowerCase();
        StringBuilder valore = new StringBuilder();
        int ch = soglia.charAt(0);
        int i = 1;
        while (Character.isDigit((char)ch)) {
            valore.append((char)ch);
            if (i < soglia.length()) {
                ch = soglia.charAt(i++);
                continue;
            }
            ch = 102;
        }
        if (soglia.endsWith("kb") || soglia.endsWith("k")) {
            factor = 1024L;
        } else if (soglia.endsWith("mb") || soglia.endsWith("m")) {
            factor = 0x100000L;
        } else if (soglia.endsWith("gb") || soglia.endsWith("g")) {
            factor = 0x40000000L;
        }
        MsgDiagnostico msgDiag = MsgDiagnostico.newInstance(ID_MODULO);
        Connection connection = null;
        try {
            if (datasource == null) {
                resource = this.getConnection(dbManager);
                connection = (Connection)resource.getResource();
            } else {
                connection = this.getConnection(datasource);
            }
            threshold = Long.parseLong(valore.toString()) * factor;
            if (threshold < 0L) {
                throw new CoreException("Valore di soglia negativo");
            }
            s = connection.createStatement();
            if (!s.execute(query)) {
                throw new CoreException("Impossibile verficare lo spazio occupato");
            }
            rs = s.getResultSet();
            if (rs == null) {
                throw new CoreException("Nessun risultato disponibile per la verifica di soglia");
            }
            if (!rs.next()) {
                throw new CoreException("Nessun risultato disponibile per la verifica di soglia");
            }
            size = rs.getLong(1);
            if (size == 0L) {
                throw new CoreException("La quantita' di spazio occupata dai DB e' NULL");
            }
            result = size < threshold;
        }
        catch (Exception e) {
            try {
                throw new ThresholdException("PostgreSQLThreshold error: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, s);
                rs = null;
                s = null;
                try {
                    if (datasource == null) {
                        dbManager.releaseResource(properties.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, resource);
                        throw throwable;
                    }
                    if (connection == null) throw throwable;
                    if (connection.isClosed()) throw throwable;
                    JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connection, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (Statement)s);
        rs = null;
        s = null;
        try {
            if (datasource == null) {
                dbManager.releaseResource(properties.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, resource);
            } else if (connection != null && !connection.isClosed()) {
                JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connection, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
            }
        }
        catch (SQLException sQLException) {}
        Object prefix = "";
        if (datasource != null) {
            prefix = "[" + datasource + "] ";
        }
        String msg = (String)prefix + "Spazio occupato: " + size + "; soglia: " + result + "; risultato:" + (result ? "ok" : "ko");
        if (debug) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopResources().info(msg);
        }
        msgDiag.highDebug(msg);
        return result;
    }

    private Resource getConnection(DBManager dbManager) throws CoreException {
        Resource resource = null;
        try {
            resource = dbManager.getResource(properties.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, null);
        }
        catch (Exception e) {
            throw new CoreException("Impossibile ottenere una Risorsa dal DBManager", (Throwable)e);
        }
        if (resource == null) {
            throw new CoreException("Risorsa is null");
        }
        if (resource.getResource() == null) {
            throw new CoreException("Connessione is null");
        }
        return resource;
    }

    private Connection getConnection(String datasource) throws NamingException, SQLException {
        InitialContext c = new InitialContext();
        DataSource ds = (DataSource)c.lookup(datasource);
        c.close();
        return ds.getConnection();
    }
}

