/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.ForwardProxy;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.ConnettoreHTTP;
import org.openspcoop2.pdd.core.connettori.ConnettoreHTTPS;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.controllo_traffico.PolicyTimeoutConfig;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.dynamic.ErrorHandler;
import org.openspcoop2.pdd.core.dynamic.MessageContent;
import org.openspcoop2.pdd.core.dynamic.Template;
import org.openspcoop2.pdd.core.token.GestoreToken;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.TokenKeystoreInjectUtilities;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.AbstractDatiInvocazione;
import org.openspcoop2.pdd.core.token.attribute_authority.AttributeAuthorityDynamicParameters;
import org.openspcoop2.pdd.core.token.attribute_authority.BasicRetrieveAttributeAuthorityResponseParser;
import org.openspcoop2.pdd.core.token.attribute_authority.EsitoRecuperoAttributi;
import org.openspcoop2.pdd.core.token.attribute_authority.IRetrieveAttributeAuthorityResponseParser;
import org.openspcoop2.pdd.core.token.attribute_authority.InformazioniAttributi;
import org.openspcoop2.pdd.core.token.attribute_authority.PolicyAttributeAuthority;
import org.openspcoop2.pdd.core.token.attribute_authority.RequiredAttributes;
import org.openspcoop2.pdd.core.token.attribute_authority.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.token.attribute_authority.pa.EsitoRecuperoAttributiPortaApplicativa;
import org.openspcoop2.pdd.core.token.attribute_authority.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.token.attribute_authority.pd.EsitoRecuperoAttributiPortaDelegata;
import org.openspcoop2.pdd.services.connector.FormUrlEncodedHttpServletRequest;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.RestMessageSecurityToken;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.CRLCertstore;
import org.openspcoop2.security.keystore.JWKSetStore;
import org.openspcoop2.security.keystore.KeyPairStore;
import org.openspcoop2.security.keystore.MerlinKeystore;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.security.keystore.cache.GestoreOCSPResource;
import org.openspcoop2.security.keystore.cache.GestoreOCSPValidator;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.utils.SecurityUtils;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.utils.security.CertificateValidityCheck;
import org.openspcoop2.utils.security.JOSESerialization;
import org.openspcoop2.utils.security.JWSOptions;
import org.openspcoop2.utils.security.JWTOptions;
import org.openspcoop2.utils.security.JsonSignature;
import org.openspcoop2.utils.security.JsonVerifySignature;
import org.openspcoop2.utils.security.JwtHeaders;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpServletTransportRequestContext;
import org.openspcoop2.utils.transport.http.IOCSPValidator;
import org.slf4j.Logger;

public class GestoreTokenAttributeAuthorityUtilities {
    private GestoreTokenAttributeAuthorityUtilities() {
    }

    static EsitoRecuperoAttributi readAttributes(Logger log, PolicyAttributeAuthority policyAttributeAuthority, IProtocolFactory<?> protocolFactory, AttributeAuthorityDynamicParameters dynamicParameters, String request, boolean portaDelegata, Context context, Busta busta, String idModulo, PortaApplicativa pa, PortaDelegata pd, IState state, IDSoggetto idDominio, IDServizio idServizio, RequestInfo requestInfo) {
        EsitoRecuperoAttributi esitoRecuperoAttributi = null;
        esitoRecuperoAttributi = portaDelegata ? new EsitoRecuperoAttributiPortaDelegata() : new EsitoRecuperoAttributiPortaApplicativa();
        esitoRecuperoAttributi.setTokenInternalError();
        try {
            Object detailsError = null;
            InformazioniAttributi informazioniAttributi = null;
            Exception eProcess = null;
            IRetrieveAttributeAuthorityResponseParser tokenParser = policyAttributeAuthority.getRetrieveAttributeAuthorityResponseParser(log);
            HttpResponse httpResponse = null;
            Integer httpResponseCode = null;
            byte[] risposta = null;
            try {
                httpResponse = GestoreTokenAttributeAuthorityUtilities.http(log, policyAttributeAuthority, protocolFactory, dynamicParameters, request, state, portaDelegata, idModulo, pa, pd, idDominio, idServizio, busta, requestInfo);
                risposta = httpResponse.getContent();
                httpResponseCode = httpResponse.getResultHTTPOperation();
            }
            catch (Exception e) {
                detailsError = "(Errore di Connessione) " + e.getMessage();
                eProcess = e;
            }
            if (detailsError == null) {
                String decodedPayload = null;
                byte[] decodedPayloadAsBytes = null;
                if (policyAttributeAuthority.isResponseJws()) {
                    JsonVerifySignature jsonCompactVerify = null;
                    try {
                        String rispostaAsString = new String(risposta);
                        RestMessageSecurityToken check = new RestMessageSecurityToken();
                        check.setToken((Serializable)((Object)rispostaAsString));
                        String signatureAlgorithm = policyAttributeAuthority.getResponseJwsSignatureAlgorithm(check);
                        JWTOptions options = new JWTOptions(JOSESerialization.COMPACT);
                        Properties p = policyAttributeAuthority.getProperties().get("signatureVerifyPropRefId");
                        SecurityUtils.dynamicUpdateKeyPairAlgorithm((Properties)p, (String)signatureAlgorithm);
                        TokenUtilities.injectJOSEConfig(p, policyAttributeAuthority, null, busta, idDominio, idServizio, context, log, requestInfo, state, portaDelegata);
                        TokenKeystoreInjectUtilities inject = new TokenKeystoreInjectUtilities(log, requestInfo, protocolFactory, context, state, busta);
                        inject.initAttributeAuthorityValidazioneRispostaJwt(policyAttributeAuthority.getName(), portaDelegata, pd, pa, p);
                        inject.inject(p);
                        String aliasMode = p.getProperty("rs.security.keystore.alias.mode");
                        if (aliasMode != null && (aliasMode.equals("x5c") || aliasMode.equals("x5t#256") || aliasMode.equals("x5c_x5t#256") || aliasMode.equals("kid") || aliasMode.equals("x5u"))) {
                            Object oKeystore;
                            options.setPermitUseHeaderX5C(aliasMode.equals("x5c") || aliasMode.equals("x5c_x5t#256"));
                            options.setPermitUseHeaderX5T_256(aliasMode.equals("x5t#256") || aliasMode.equals("x5c_x5t#256"));
                            options.setPermitUseHeaderKID(aliasMode.equals("kid"));
                            options.setPermitUseHeaderX5U(aliasMode.equals("x5u"));
                            if (p.containsKey("rs.security.keystore")) {
                                Object oKeystore2 = p.get("rs.security.keystore");
                                if (oKeystore2 instanceof java.security.KeyStore) {
                                    java.security.KeyStore keystore = (java.security.KeyStore)oKeystore2;
                                    jsonCompactVerify = new JsonVerifySignature(keystore, options);
                                    CertificateValidityCheck validityCheck = OpenSPCoop2Properties.getInstance().getGestioneAttributeAuthorityValidityCheck();
                                    List proprieta = null;
                                    if (pa != null) {
                                        proprieta = pa.getProprietaList();
                                    } else if (pd != null) {
                                        proprieta = pd.getProprietaList();
                                    }
                                    validityCheck = CostantiProprieta.getAttributeAuthorityCertificateValidityCheck(proprieta, validityCheck);
                                    jsonCompactVerify.setValidityCheck(validityCheck);
                                    String signatureOCSP = policyAttributeAuthority.getResponseJwsOcspPolicy();
                                    String signatureCRL = policyAttributeAuthority.getResponseJwsCrl();
                                    boolean crlByOcsp = false;
                                    if (keystore != null && signatureOCSP != null && !"".equals(signatureOCSP)) {
                                        LoggerBuffer lb = new LoggerBuffer();
                                        lb.setLogDebug(log);
                                        lb.setLogError(log);
                                        GestoreOCSPResource ocspResourceReader = new GestoreOCSPResource(requestInfo);
                                        GestoreOCSPValidator ocspValidator = null;
                                        try {
                                            KeyStore trustStore = new KeyStore(keystore);
                                            ocspValidator = new GestoreOCSPValidator(requestInfo, lb, trustStore, signatureCRL, signatureOCSP, (IOCSPResourceReader)ocspResourceReader);
                                        }
                                        catch (Exception e) {
                                            throw new TokenException("ocsp initialization (policy:'" + signatureOCSP + "') failed: " + e.getMessage(), e);
                                        }
                                        if (ocspValidator != null) {
                                            jsonCompactVerify.setOcspValidatorX509((IOCSPValidator)ocspValidator);
                                            GestoreOCSPValidator gOcspValidator = ocspValidator;
                                            if (gOcspValidator.getOcspConfig() != null) {
                                                crlByOcsp = gOcspValidator.getOcspConfig().isCrl();
                                            }
                                        }
                                    }
                                    if (signatureCRL != null && !"".equals(signatureCRL) && !crlByOcsp) {
                                        CRLCertstore crlCertstore = GestoreKeystoreCache.getCRLCertstore((RequestInfo)requestInfo, (String)signatureCRL);
                                        if (crlCertstore == null) {
                                            throw new TokenException("Process CRL '" + signatureCRL + "' failed");
                                        }
                                        jsonCompactVerify.setCrlX509(crlCertstore.getCertStore());
                                    }
                                }
                            } else if (p.containsKey("rs.security.keystore.jwkset") && (oKeystore = p.get("rs.security.keystore.jwkset")) instanceof String) {
                                String keystore = (String)oKeystore;
                                JsonWebKeys jwksKeystore = new JWKSet(keystore).getJsonWebKeys();
                                jsonCompactVerify = new JsonVerifySignature(jwksKeystore, options);
                            }
                        }
                        if (jsonCompactVerify == null) {
                            jsonCompactVerify = new JsonVerifySignature(p, signatureAlgorithm, options);
                        } else {
                            jsonCompactVerify.setSignatureAlgorithm(signatureAlgorithm);
                        }
                        jsonCompactVerify.setJksPasswordRequired(DBUtils.isTruststoreJksPasswordRequired());
                        jsonCompactVerify.setPkcs12PasswordRequired(DBUtils.isTruststorePkcs12PasswordRequired());
                        if (jsonCompactVerify.verify(rispostaAsString)) {
                            if (tokenParser instanceof BasicRetrieveAttributeAuthorityResponseParser) {
                                decodedPayload = jsonCompactVerify.getDecodedPayload();
                            } else {
                                decodedPayloadAsBytes = jsonCompactVerify.getDecodedPayloadAsByte();
                            }
                        } else {
                            detailsError = "Risposta non valida";
                        }
                    }
                    catch (Exception e) {
                        detailsError = "Risposta non valida: " + e.getMessage();
                        eProcess = e;
                    }
                }
                if (detailsError == null) {
                    try {
                        informazioniAttributi = tokenParser instanceof BasicRetrieveAttributeAuthorityResponseParser ? new InformazioniAttributi(httpResponseCode, policyAttributeAuthority.getName(), decodedPayload != null ? decodedPayload : new String(risposta), tokenParser) : new InformazioniAttributi(httpResponseCode, policyAttributeAuthority.getName(), decodedPayloadAsBytes != null ? decodedPayloadAsBytes : risposta, tokenParser);
                    }
                    catch (Exception e) {
                        detailsError = "Risposta del servizio di negoziazione token non valida: " + e.getMessage();
                        eProcess = e;
                    }
                }
            }
            if (informazioniAttributi != null && informazioniAttributi.isValid()) {
                esitoRecuperoAttributi.setTokenValido();
                esitoRecuperoAttributi.setInformazioniAttributi(informazioniAttributi);
                esitoRecuperoAttributi.setNoCache(false);
            } else {
                esitoRecuperoAttributi.setTokenValidazioneFallita();
                esitoRecuperoAttributi.setNoCache(!policyAttributeAuthority.isSaveErrorInCache());
                esitoRecuperoAttributi.setEccezioneProcessamento(eProcess);
                if (detailsError != null) {
                    esitoRecuperoAttributi.setDetails((String)detailsError);
                } else {
                    esitoRecuperoAttributi.setDetails("Attributi non recuperabili");
                }
            }
        }
        catch (Exception e) {
            esitoRecuperoAttributi.setTokenInternalError();
            esitoRecuperoAttributi.setDetails(e.getMessage());
            esitoRecuperoAttributi.setEccezioneProcessamento(e);
        }
        return esitoRecuperoAttributi;
    }

    static String buildCacheKeyRecuperoAttributiPrefix(String nomePolicy, String funzione) {
        StringBuilder bf = new StringBuilder("AttributeAuthority_" + funzione);
        bf.append("_");
        bf.append(nomePolicy);
        bf.append("_");
        return bf.toString();
    }

    static String buildCacheKeyRecuperoAttributi(String nomePolicy, String funzione, boolean portaDelegata, AttributeAuthorityDynamicParameters dynamicParameters, String request) {
        StringBuilder bf = new StringBuilder();
        bf.append(GestoreTokenAttributeAuthorityUtilities.buildCacheKeyRecuperoAttributiPrefix(nomePolicy, funzione));
        if (portaDelegata) {
            bf.append("PD");
        } else {
            bf.append("PA");
        }
        bf.append("_");
        String dynamicParametersKeyCache = dynamicParameters.toString("_", true);
        bf.append(dynamicParametersKeyCache);
        bf.append("_");
        bf.append(Base64Utilities.encodeAsString((byte[])request.getBytes()));
        return bf.toString();
    }

    static Map<String, Object> buildDynamicAAMap(OpenSPCoop2Message message, Busta busta, RequestInfo requestInfo, PdDContext pddContext, Logger log, String nomeAttributeAuthority, AbstractDatiInvocazione datiInvocazione) throws TokenException {
        DatiInvocazionePortaDelegata datiPD;
        HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
        Map pTrasporto = null;
        String urlInvocazione = null;
        Map pQuery = null;
        Map<String, List<String>> pForm = null;
        if (requestInfo != null && requestInfo.getProtocolContext() != null) {
            FormUrlEncodedHttpServletRequest formServlet;
            URLProtocolContext httpServletContext;
            HttpServletRequest httpServletRequest;
            pTrasporto = requestInfo.getProtocolContext().getHeaders();
            urlInvocazione = requestInfo.getProtocolContext().getUrlInvocazione_formBased();
            pQuery = requestInfo.getProtocolContext().getParameters();
            if (requestInfo.getProtocolContext() instanceof HttpServletTransportRequestContext && (httpServletRequest = (httpServletContext = requestInfo.getProtocolContext()).getHttpServletRequest()) instanceof FormUrlEncodedHttpServletRequest && (formServlet = (FormUrlEncodedHttpServletRequest)httpServletRequest).getFormUrlEncodedParametersValues() != null && !formServlet.getFormUrlEncodedParametersValues().isEmpty()) {
                pForm = formServlet.getFormUrlEncodedParametersValues();
            }
        }
        MessageContent messageContent = null;
        try {
            boolean bufferMessageReadOnly = OpenSPCoop2Properties.getInstance().isReadByPathBufferEnabled();
            if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                messageContent = new MessageContent(message.castAsSoap(), bufferMessageReadOnly, (Context)pddContext);
            } else if (MessageType.XML.equals((Object)message.getMessageType())) {
                messageContent = new MessageContent(message.castAsRestXml(), bufferMessageReadOnly, (Context)pddContext);
            } else if (MessageType.JSON.equals((Object)message.getMessageType())) {
                messageContent = new MessageContent(message.castAsRestJson(), bufferMessageReadOnly, (Context)pddContext);
            }
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage(), e);
        }
        ErrorHandler errorHandler = new ErrorHandler();
        DynamicUtils.fillDynamicMapRequest(log, dynamicMap, pddContext, urlInvocazione, message, messageContent, busta, pTrasporto, pQuery, pForm, errorHandler);
        List<String> listAttributi = null;
        if (datiInvocazione instanceof DatiInvocazionePortaApplicativa) {
            DatiInvocazionePortaApplicativa datiPA = (DatiInvocazionePortaApplicativa)datiInvocazione;
            if (datiPA.getPa() != null && datiPA.getPa().sizeAttributeAuthorityList() > 0) {
                for (AttributeAuthority aa : datiPA.getPa().getAttributeAuthorityList()) {
                    if (!nomeAttributeAuthority.equals(aa.getNome())) continue;
                    listAttributi = aa.getAttributoList();
                    break;
                }
            } else if (datiPA.getPd() != null && datiPA.getPd().sizeAttributeAuthorityList() > 0) {
                for (AttributeAuthority aa : datiPA.getPd().getAttributeAuthorityList()) {
                    if (!nomeAttributeAuthority.equals(aa.getNome())) continue;
                    listAttributi = aa.getAttributoList();
                    break;
                }
            }
        } else if (datiInvocazione instanceof DatiInvocazionePortaDelegata && (datiPD = (DatiInvocazionePortaDelegata)datiInvocazione).getPd() != null && datiPD.getPd().sizeAttributeAuthorityList() > 0) {
            for (AttributeAuthority aa : datiPD.getPd().getAttributeAuthorityList()) {
                if (!nomeAttributeAuthority.equals(aa.getNome())) continue;
                listAttributi = aa.getAttributoList();
                break;
            }
        }
        if (listAttributi == null) {
            listAttributi = new ArrayList<String>();
        }
        RequiredAttributes reqAttrs = new RequiredAttributes(listAttributi);
        dynamicMap.put("requiredAttributes", reqAttrs);
        dynamicMap.put("requiredAttributes".toLowerCase(), reqAttrs);
        return dynamicMap;
    }

    static String buildDynamicAARequest(ConfigurazionePdDManager configurazionePdDManager, IProtocolFactory<?> protocolFactory, RequestInfo requestInfo, PolicyAttributeAuthority policyAttributeAuthority, AttributeAuthorityDynamicParameters dynamicParameters, boolean addIdAndDate) throws TokenException, UtilsException {
        String dynamicContent = policyAttributeAuthority.getRequestDynamicPayload();
        String request = null;
        if (policyAttributeAuthority.isRequestDynamicPayloadTemplate() || policyAttributeAuthority.isRequestDynamicPayloadJwt()) {
            request = policyAttributeAuthority.isRequestDynamicPayloadTemplate() ? dynamicParameters.getRequestDynamicPayloadTemplate() : GestoreTokenAttributeAuthorityUtilities.buildAAJwt(policyAttributeAuthority, dynamicParameters, protocolFactory, requestInfo, addIdAndDate);
        } else if (policyAttributeAuthority.isRequestDynamicPayloadFreemarkerTemplate()) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                Template template = configurazionePdDManager.getTemplateAttributeAuthorityRequest(policyAttributeAuthority.getName(), dynamicContent.getBytes(), requestInfo);
                DynamicUtils.convertFreeMarkerTemplate(template, dynamicParameters.getDynamicMap(), bout);
                bout.flush();
                bout.close();
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
            request = bout.toString();
            if (policyAttributeAuthority.isRequestJws()) {
                request = GestoreTokenAttributeAuthorityUtilities.normalizeJwtPayload(request);
            }
        } else if (policyAttributeAuthority.isRequestDynamicPayloadVelocityTemplate()) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                Template template = configurazionePdDManager.getTemplateAttributeAuthorityRequest(policyAttributeAuthority.getName(), dynamicContent.getBytes(), requestInfo);
                DynamicUtils.convertVelocityTemplate(template, dynamicParameters.getDynamicMap(), bout);
                bout.flush();
                bout.close();
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
            request = bout.toString();
            if (policyAttributeAuthority.isRequestJws()) {
                request = GestoreTokenAttributeAuthorityUtilities.normalizeJwtPayload(request);
            }
        }
        if (request == null || "".equals(request)) {
            throw new TokenException("Request undefined");
        }
        return request;
    }

    private static String normalizeJwtPayload(String payload) throws UtilsException {
        JSONUtils jsonUtils = JSONUtils.getInstance((boolean)false);
        JsonNode jwtPayload = jsonUtils.getAsNode(payload);
        return jsonUtils.toString(jwtPayload);
    }

    private static String buildAAJwt(PolicyAttributeAuthority policyAttributeAuthority, AttributeAuthorityDynamicParameters dynamicParameters, IProtocolFactory<?> protocolFactory, RequestInfo requestInfo, boolean addIdAndDate) throws TokenException, UtilsException {
        Properties convertTextToProperties;
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        JSONUtils jsonUtils = JSONUtils.getInstance((boolean)false);
        ObjectNode jwtPayload = jsonUtils.newObjectNode();
        long nowMs = DateManager.getTimeMillis();
        long nowSeconds = nowMs / 1000L;
        String issuer = dynamicParameters.getIssuer();
        if (issuer == null || "".equals(issuer)) {
            issuer = op2Properties.getIdentitaPortaDefault(protocolFactory != null ? protocolFactory.getProtocol() : null, requestInfo).getNome();
        }
        jwtPayload.put("iss", issuer);
        String subject = dynamicParameters.getSubject();
        if (subject == null) {
            throw new TokenException("JWT-Subject undefined");
        }
        jwtPayload.put("sub", subject);
        String audience = dynamicParameters.getAudience();
        if (audience == null) {
            throw new TokenException("JWT-Audience undefined");
        }
        jwtPayload.put("aud", audience);
        String claims = dynamicParameters.getClaims();
        if (claims != null && !"".equals(claims) && (convertTextToProperties = PropertiesUtilities.convertTextToProperties((String)claims)) != null && !convertTextToProperties.isEmpty()) {
            Enumeration<Object> keys = convertTextToProperties.keys();
            while (keys.hasMoreElements()) {
                String valore;
                String nome = (String)keys.nextElement();
                if (nome == null || "".equals(nome) || (valore = convertTextToProperties.getProperty(nome)) == null) continue;
                jsonUtils.putValue(jwtPayload, nome, valore);
            }
        }
        if (addIdAndDate) {
            jwtPayload.put("iat", nowSeconds);
            jwtPayload.put("nbf", nowSeconds);
            int ttl = -1;
            try {
                ttl = policyAttributeAuthority.getJwtTtlSeconds();
            }
            catch (Exception e) {
                throw new TokenException("Invalid JWT-TimeToLive value: " + e.getMessage(), e);
            }
            long expired = nowSeconds + (long)ttl;
            jwtPayload.put("exp", expired);
            String uuid = null;
            try {
                uuid = UniqueIdentifierManager.newUniqueIdentifier().toString();
            }
            catch (Exception e) {
                throw new TokenException("Invalid JWT-TimeToLive value: " + e.getMessage(), e);
            }
            jwtPayload.put("jti", uuid);
        }
        return jsonUtils.toString((JsonNode)jwtPayload);
    }

    static void validazioneInformazioniAttributiRecuperati(EsitoRecuperoAttributi esitoRecuperoAttributi, PolicyAttributeAuthority policyAttributeAuthority, boolean saveErrorInCache, AttributeAuthorityDynamicParameters dynamicParameters, PortaApplicativa pa, PortaDelegata pd) throws TokenException {
        String audience;
        Date now = DateManager.getDate();
        if (esitoRecuperoAttributi.isValido()) {
            esitoRecuperoAttributi.setDateValide(true);
        }
        if (esitoRecuperoAttributi.isValido() && esitoRecuperoAttributi.getInformazioniAttributi().getExp() != null && !now.before(esitoRecuperoAttributi.getInformazioniAttributi().getExp())) {
            esitoRecuperoAttributi.setTokenScaduto();
            esitoRecuperoAttributi.setDateValide(false);
            esitoRecuperoAttributi.setDetails("Response attributes expired");
        }
        if (esitoRecuperoAttributi.isValido() && esitoRecuperoAttributi.getInformazioniAttributi().getNbf() != null && !esitoRecuperoAttributi.getInformazioniAttributi().getNbf().before(now)) {
            esitoRecuperoAttributi.setTokenNotUsableBefore();
            esitoRecuperoAttributi.setDateValide(false);
            DateTimeFormatterWrapper sdf = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS");
            esitoRecuperoAttributi.setDetails("Response attributes not usable before " + sdf.format(esitoRecuperoAttributi.getInformazioniAttributi().getNbf()));
        }
        if (esitoRecuperoAttributi.isValido() && esitoRecuperoAttributi.getInformazioniAttributi().getIat() != null) {
            Long old = null;
            try {
                old = OpenSPCoop2Properties.getInstance().getGestioneTokenIatTimeCheckMilliseconds();
                List proprieta = null;
                if (pa != null) {
                    proprieta = pa.getProprietaList();
                } else if (pd != null) {
                    proprieta = pd.getProprietaList();
                }
                old = CostantiProprieta.getAttributeAuthorityIatMaxAgeMilliseconds(proprieta, old);
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
            if (old != null) {
                Date oldMax = new Date(DateManager.getTimeMillis() - old);
                if (esitoRecuperoAttributi.getInformazioniAttributi().getIat().before(oldMax)) {
                    esitoRecuperoAttributi.setTokenScaduto();
                    esitoRecuperoAttributi.setDateValide(false);
                    DateTimeFormatterWrapper sdf = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS");
                    esitoRecuperoAttributi.setDetails("Response attributes expired; iat time '" + sdf.format(esitoRecuperoAttributi.getInformazioniAttributi().getIat()) + "' too old");
                }
            }
            Long future = null;
            try {
                future = OpenSPCoop2Properties.getInstance().getGestioneTokenIatTimeCheckFutureToleranceMilliseconds();
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
            if (future != null) {
                Date futureMax = new Date(DateManager.getTimeMillis() + future);
                if (esitoRecuperoAttributi.getInformazioniAttributi().getIat().after(futureMax)) {
                    esitoRecuperoAttributi.setTokenInTheFuture();
                    esitoRecuperoAttributi.setDateValide(false);
                    DateTimeFormatterWrapper sdf = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS");
                    esitoRecuperoAttributi.setDetails("Response attributes valid in the future; iat time '" + sdf.format(esitoRecuperoAttributi.getInformazioniAttributi().getIat()) + "' is in the future");
                }
            }
        }
        if (!(!esitoRecuperoAttributi.isValido() || (audience = dynamicParameters.getResponseAudience()) == null || "".equals(audience) || esitoRecuperoAttributi.getInformazioniAttributi().getAud() != null && esitoRecuperoAttributi.getInformazioniAttributi().getAud().contains(audience))) {
            esitoRecuperoAttributi.setTokenValidazioneFallita();
            esitoRecuperoAttributi.setNoCache(!policyAttributeAuthority.isSaveErrorInCache());
            esitoRecuperoAttributi.setDetails("Invalid audience");
        }
        if (esitoRecuperoAttributi.isValido() && (esitoRecuperoAttributi.getInformazioniAttributi().getAttributes() == null || esitoRecuperoAttributi.getInformazioniAttributi().getAttributes().isEmpty())) {
            esitoRecuperoAttributi.setNoCache(!policyAttributeAuthority.isSaveErrorInCache());
            esitoRecuperoAttributi.setDetails("No attributes retrieved");
        }
        if (!esitoRecuperoAttributi.isValido()) {
            esitoRecuperoAttributi.setNoCache(!saveErrorInCache);
        }
    }

    private static HttpResponse http(Logger log, PolicyAttributeAuthority policyAttributeAuthority, IProtocolFactory<?> protocolFactory, AttributeAuthorityDynamicParameters dynamicParameters, String request, IState state, boolean delegata, String idModulo, PortaApplicativa pa, PortaDelegata pd, IDSoggetto idDominio, IDServizio idServizio, Busta busta, RequestInfo requestInfo) throws Exception {
        boolean send;
        String contentType;
        String endpoint = dynamicParameters.getEndpoint();
        HttpRequestMethod httpMethod = policyAttributeAuthority.getRequestHttpMethod();
        Properties endpointConfig = policyAttributeAuthority.getProperties().get("endpointConfig");
        boolean https = policyAttributeAuthority.isEndpointHttps();
        boolean httpsClient = false;
        Properties sslConfig = null;
        Properties sslClientConfig = null;
        if (https) {
            sslConfig = policyAttributeAuthority.getProperties().get("sslConfig");
            httpsClient = policyAttributeAuthority.isHttpsAuthentication();
            if (httpsClient) {
                sslClientConfig = policyAttributeAuthority.getProperties().get("sslClientConfig");
                TokenUtilities.injectSameKeystoreForHttpsClient(sslConfig, sslClientConfig);
            }
        }
        boolean basic = policyAttributeAuthority.isBasicAuthentication();
        String username = null;
        String password = null;
        if (basic) {
            username = dynamicParameters.getBasicUsername();
            password = dynamicParameters.getBasicPassword();
        }
        boolean bearer = policyAttributeAuthority.isBearerAuthentication();
        String bearerToken = null;
        if (bearer) {
            bearerToken = dynamicParameters.getBearerToken();
        }
        ConnettoreMsg connettoreMsg = new ConnettoreMsg();
        ConnettoreHTTP connettore = null;
        if (https) {
            connettoreMsg.setTipoConnettore(TipiConnettore.HTTPS.getNome());
            connettore = new ConnettoreHTTPS();
        } else {
            connettoreMsg.setTipoConnettore(TipiConnettore.HTTP.getNome());
            connettore = new ConnettoreHTTP();
        }
        connettoreMsg.setIdModulo(idModulo);
        connettoreMsg.setState(state);
        PolicyTimeoutConfig policyConfig = new PolicyTimeoutConfig();
        policyConfig.setAttributeAuthority(policyAttributeAuthority.getName());
        connettoreMsg.setPolicyTimeoutConfig(policyConfig);
        ForwardProxy forwardProxy = null;
        ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(state);
        if (configurazionePdDManager.isForwardProxyEnabled(requestInfo)) {
            try {
                IDGenericProperties policy = new IDGenericProperties();
                policy.setTipologia("attributeAuthority");
                policy.setNome(policyAttributeAuthority.getName());
                forwardProxy = delegata ? configurazionePdDManager.getForwardProxyConfigFruizione(idDominio, idServizio, policy, requestInfo) : configurazionePdDManager.getForwardProxyConfigErogazione(idDominio, idServizio, policy, requestInfo);
            }
            catch (Exception e) {
                throw new TokenException(GestoreToken.getMessageErroreGovWayProxy(e), e);
            }
        }
        if (forwardProxy != null && forwardProxy.isEnabled() && forwardProxy.getConfigToken() != null && forwardProxy.getConfigToken().isAttributeAuthorityEnabled()) {
            connettoreMsg.setForwardProxy(forwardProxy);
        }
        connettore.setForceDisable_proxyPassReverse(true);
        connettore.init(dynamicParameters.getPddContext(), protocolFactory, new Object[0]);
        connettore.setRegisterSendIntoContext(false);
        if (basic) {
            InvocazioneCredenziali credenziali = new InvocazioneCredenziali();
            credenziali.setUser(username);
            credenziali.setPassword(password);
            connettoreMsg.setCredenziali(credenziali);
        }
        connettoreMsg.setConnectorProperties(new HashMap<String, String>());
        connettoreMsg.getConnectorProperties().put("location", endpoint);
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        boolean debug = properties.isGestioneAttributeAuthorityDebug();
        if (debug) {
            connettoreMsg.getConnectorProperties().put("debug", "true");
        }
        connettoreMsg.getConnectorProperties().put("dataTransferMode", TransferLengthModes.CONTENT_LENGTH.getNome());
        GestoreToken.addProperties(connettoreMsg, endpointConfig);
        if (https) {
            GestoreToken.addProperties(connettoreMsg, sslConfig);
            if (httpsClient) {
                GestoreToken.addProperties(connettoreMsg, sslClientConfig);
            }
        }
        byte[] content = null;
        TransportRequestContext transportRequestContext = new TransportRequestContext(log);
        transportRequestContext.setRequestType(httpMethod.name());
        transportRequestContext.setHeaders(new HashMap());
        if (bearer) {
            String authorizationHeader = "Bearer " + bearerToken;
            TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)"Authorization", (String)authorizationHeader);
        }
        if ((contentType = policyAttributeAuthority.getRequestContentType()) != null && !"".equals(contentType)) {
            transportRequestContext.removeHeader("Content-Type");
            TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)"Content-Type", (String)contentType);
        }
        String requestPayload = request;
        if (policyAttributeAuthority.isRequestJws()) {
            requestPayload = GestoreTokenAttributeAuthorityUtilities.signAAJwt(policyAttributeAuthority, request, contentType, dynamicParameters, busta, requestInfo, log);
        }
        if (policyAttributeAuthority.isRequestPositionBearer()) {
            if (transportRequestContext.getHeaders() == null) {
                transportRequestContext.setHeaders(new HashMap());
            }
            String authorizationHeader = "Bearer " + requestPayload;
            TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)"Authorization", (String)authorizationHeader);
        } else if (policyAttributeAuthority.isRequestPositionHeader()) {
            if (transportRequestContext.getHeaders() == null) {
                transportRequestContext.setHeaders(new HashMap());
            }
            String headerName = policyAttributeAuthority.getRequestPositionHeaderName();
            TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)headerName, (String)requestPayload);
        } else if (policyAttributeAuthority.isRequestPositionQuery()) {
            if (transportRequestContext.getParameters() == null) {
                transportRequestContext.setParameters(new HashMap());
            }
            String queryParameterName = policyAttributeAuthority.getRequestPositionQueryParameterName();
            TransportUtils.setParameter((Map)transportRequestContext.getParameters(), (String)queryParameterName, (String)requestPayload);
        } else if (policyAttributeAuthority.isRequestPositionPayload()) {
            content = requestPayload.getBytes();
        }
        OpenSPCoop2MessageParseResult pr = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createMessage(MessageType.BINARY, transportRequestContext, content);
        OpenSPCoop2Message msg = pr.getMessage_throwParseException();
        connettoreMsg.setRequestMessage(msg);
        connettoreMsg.setGenerateErrorWithConnectorPrefix(false);
        connettore.setHttpMethod(msg);
        connettore.setPa(pa);
        connettore.setPd(pd);
        ResponseCachingConfigurazione responseCachingConfigurazione = new ResponseCachingConfigurazione();
        responseCachingConfigurazione.setStato(StatoFunzionalita.DISABILITATO);
        String prefixConnettore = "[EndpointAttributeAuthority: " + endpoint + "] ";
        if (endpointConfig.containsKey("proxyHostname")) {
            String hostProxy = endpointConfig.getProperty("proxyHostname");
            String portProxy = endpointConfig.getProperty("proxyPort");
            prefixConnettore = prefixConnettore + GestoreToken.getMessageViaProxy(hostProxy, portProxy);
        }
        if (!(send = connettore.send(responseCachingConfigurazione, connettoreMsg))) {
            if (connettore.getEccezioneProcessamento() != null) {
                throw new TokenException(prefixConnettore + connettore.getErrore(), connettore.getEccezioneProcessamento());
            }
            throw new TokenException(prefixConnettore + connettore.getErrore());
        }
        OpenSPCoop2Message msgResponse = connettore.getResponse();
        ByteArrayOutputStream bout = null;
        if (msgResponse != null) {
            bout = new ByteArrayOutputStream();
            if (msgResponse != null) {
                msgResponse.writeTo((OutputStream)bout, true);
            }
            bout.flush();
            bout.close();
        }
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setResultHTTPOperation(connettore.getCodiceTrasporto());
        if (connettore.getCodiceTrasporto() >= 200 && connettore.getCodiceTrasporto() < 299) {
            String msgSuccess = prefixConnettore + GestoreToken.getMessageConnettoreConnessioneSuccesso(connettore);
            if (bout != null && bout.size() > 0) {
                log.debug(msgSuccess);
                httpResponse.setContent(bout.toByteArray());
                return httpResponse;
            }
            throw new TokenException(msgSuccess + "; non \u00e8 pervenuta alcuna risposta");
        }
        String msgError = prefixConnettore + GestoreToken.getMessageConnettoreConnessioneErrore(connettore);
        if (bout != null && bout.size() > 0) {
            String e = msgError + ": " + bout.toString();
            log.debug(e);
            httpResponse.setContent(bout.toByteArray());
            return httpResponse;
        }
        log.error(msgError);
        throw new TokenException(msgError);
    }

    private static String signAAJwt(PolicyAttributeAuthority policyAttributeAuthority, String payload, String contentType, AttributeAuthorityDynamicParameters dynamicParameters, Busta busta, RequestInfo requestInfo, Logger log) throws TokenException, SecurityException, UtilsException {
        Certificate cert;
        String type;
        String url;
        String keyAlias;
        String keystorePassword;
        String signAlgo = policyAttributeAuthority.getRequestJwtSignAlgorithm();
        if (signAlgo == null) {
            throw new TokenException("SignAlgorithm undefined");
        }
        JWSOptions options = new JWSOptions(JOSESerialization.COMPACT);
        String keystoreType = policyAttributeAuthority.getRequestJwtSignKeystoreType();
        if (keystoreType == null) {
            throw new TokenException("JWT Signature keystore type undefined");
        }
        String keystoreFile = null;
        String keystoreFilePublicKey = null;
        String keyPairAlgorithm = null;
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            keystoreFile = policyAttributeAuthority.getRequestJwtSignKeystoreFile();
            if (keystoreFile == null) {
                throw new TokenException("JWT Signature private key file undefined");
            }
            keystoreFilePublicKey = policyAttributeAuthority.getRequestJwtSignKeystoreFilePublicKey();
            if (keystoreFilePublicKey == null) {
                throw new TokenException("JWT Signature public key file undefined");
            }
            keyPairAlgorithm = policyAttributeAuthority.getRequestJwtSignKeystoreFileAlgorithm();
            if (keyPairAlgorithm == null) {
                throw new TokenException("JWT Signature key pair algorithm undefined");
            }
        } else {
            keystoreFile = policyAttributeAuthority.getRequestJwtSignKeystoreFile();
            if (keystoreFile == null) {
                throw new TokenException("JWT Signature keystore file undefined");
            }
        }
        if ((keystorePassword = policyAttributeAuthority.getRequestJwtSignKeystorePassword()) == null && !SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            boolean required = true;
            if (KeystoreType.JKS.isType(keystoreType)) {
                required = DBUtils.isKeystoreJksPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(keystoreType)) {
                required = DBUtils.isKeystorePkcs12PasswordRequired();
            }
            if (required) {
                throw new TokenException("JWT Signature keystore password undefined");
            }
        }
        if ((keyAlias = policyAttributeAuthority.getRequestJwtSignKeyAlias()) == null && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            throw new TokenException("JWT Signature key alias undefined");
        }
        String keyPassword = policyAttributeAuthority.getRequestJwtSignKeyPassword();
        if (keyPassword == null && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) && !SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType)) {
            boolean required = true;
            if (KeystoreType.JKS.isType(keystoreType)) {
                required = DBUtils.isKeystoreJksKeyPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(keystoreType)) {
                required = DBUtils.isKeystorePkcs12KeyPasswordRequired();
            }
            if (required) {
                throw new TokenException("JWT Signature key password undefined");
            }
        }
        String keystoreByokPolicy = policyAttributeAuthority.getRequestJwtSignKeystoreByokPolicy();
        BYOKRequestParams byokParams = null;
        if (BYOKProvider.isPolicyDefined((String)keystoreByokPolicy)) {
            Map<String, Object> dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(busta, requestInfo, dynamicParameters.getPddContext(), log);
            byokParams = BYOKProvider.getBYOKRequestParamsByUnwrapBYOKPolicy((String)keystoreByokPolicy, dynamicMap);
        }
        KeyStore ks = null;
        KeyPairStore keyPairStore = null;
        JWKSetStore jwtStore = null;
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            keyPairStore = GestoreKeystoreCache.getKeyPairStore((RequestInfo)requestInfo, (String)keystoreFile, (String)keystoreFilePublicKey, (String)keyPassword, (String)keyPairAlgorithm, (BYOKRequestParams)byokParams);
        } else if (SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType)) {
            jwtStore = GestoreKeystoreCache.getJwkSetStore((RequestInfo)requestInfo, (String)keystoreFile, (BYOKRequestParams)byokParams);
        } else {
            MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (String)keystoreFile, (String)keystoreType, (String)keystorePassword, (BYOKRequestParams)byokParams);
            if (merlinKs == null) {
                throw new TokenException("Accesso al keystore '" + keystoreFile + "' non riuscito");
            }
            ks = merlinKs.getKeyStore();
        }
        JwtHeaders jwtHeaders = new JwtHeaders();
        if (policyAttributeAuthority.isRequestJwtSignIncludeKeyIdWithKeyAlias()) {
            jwtHeaders.setKid(keyAlias);
        } else if (policyAttributeAuthority.isRequestJwtSignIncludeKeyIdCustom()) {
            jwtHeaders.setKid(policyAttributeAuthority.getRequestJwtSignIncludeKeyIdCustom());
        }
        if (policyAttributeAuthority.isRequestJwtSignIncludeX509Cert()) {
            jwtHeaders.setAddX5C(true);
        }
        if ((url = policyAttributeAuthority.getRequestJwtSignIncludeX509URL()) != null && !"".equals(url)) {
            try {
                jwtHeaders.setX509Url(new URI(url));
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
        if (policyAttributeAuthority.isRequestJwtSignIncludeX509CertSha1()) {
            jwtHeaders.setX509IncludeCertSha1(true);
        }
        if (policyAttributeAuthority.isRequestJwtSignIncludeX509CertSha256()) {
            jwtHeaders.setX509IncludeCertSha256(true);
        }
        if (policyAttributeAuthority.isRequestJwtSignJoseContentType() && contentType != null && !"".equals(contentType)) {
            jwtHeaders.setContentType(contentType);
        }
        if ((type = policyAttributeAuthority.getRequestJwtSignJoseType()) != null && !"".equals(type) && !"${undefined}".equals(type)) {
            jwtHeaders.setType(type);
        }
        if (ks != null && (cert = ks.getCertificate(keyAlias)) instanceof X509Certificate) {
            jwtHeaders.addX509cert((X509Certificate)cert);
        }
        JsonSignature jsonSignature = null;
        if (keyPairStore != null || jwtStore != null) {
            JsonWebKeys jwk = null;
            if (keyPairStore != null) {
                jwk = keyPairStore.getJwkSet().getJsonWebKeys();
                keyAlias = keyPairStore.getJwkSetKid();
            } else {
                jwk = jwtStore.getJwkSet().getJsonWebKeys();
            }
            jsonSignature = new JsonSignature(jwk, false, keyAlias, signAlgo, jwtHeaders, options);
        } else {
            jsonSignature = new JsonSignature(ks, false, keyAlias, keyPassword, signAlgo, jwtHeaders, options);
        }
        return jsonSignature.sign(payload);
    }
}

