/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.constants.RuoloContesto;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.rest.BinaryContent;
import org.openspcoop2.message.rest.OpenSPCoop2Message_binary_impl;
import org.openspcoop2.message.utils.WWWAuthenticateErrorCode;
import org.openspcoop2.message.utils.WWWAuthenticateGenerator;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.ForwardProxy;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.PDNDResolver;
import org.openspcoop2.pdd.config.UrlInvocazioneAPI;
import org.openspcoop2.pdd.config.UrlInvocazioneAPIUtils;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.ConnettoreHTTP;
import org.openspcoop2.pdd.core.connettori.ConnettoreHTTPS;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.controllo_traffico.PolicyTimeoutConfig;
import org.openspcoop2.pdd.core.dynamic.DynamicException;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.token.AbstractDatiInvocazione;
import org.openspcoop2.pdd.core.token.DynamicDiscovery;
import org.openspcoop2.pdd.core.token.EsitoDynamicDiscovery;
import org.openspcoop2.pdd.core.token.EsitoGestioneToken;
import org.openspcoop2.pdd.core.token.EsitoPresenzaToken;
import org.openspcoop2.pdd.core.token.GestoreToken;
import org.openspcoop2.pdd.core.token.GestoreTokenNegoziazioneUtilities;
import org.openspcoop2.pdd.core.token.HTTP_TYPE;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.PolicyGestioneToken;
import org.openspcoop2.pdd.core.token.SorgenteInformazioniToken;
import org.openspcoop2.pdd.core.token.TipoTokenRequest;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.TokenForward;
import org.openspcoop2.pdd.core.token.TokenKeystoreInjectUtilities;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.dpop.DPoP;
import org.openspcoop2.pdd.core.token.dpop.EsitoPresenzaDPoP;
import org.openspcoop2.pdd.core.token.dpop.EsitoValidazioneDPoP;
import org.openspcoop2.pdd.core.token.dpop.jti.IJtiValidator;
import org.openspcoop2.pdd.core.token.dpop.jti.JtiValidatorFactory;
import org.openspcoop2.pdd.core.token.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.token.pa.EsitoDynamicDiscoveryPortaApplicativa;
import org.openspcoop2.pdd.core.token.pa.EsitoGestioneTokenPortaApplicativa;
import org.openspcoop2.pdd.core.token.pa.EsitoValidazioneDPoPPortaApplicativa;
import org.openspcoop2.pdd.core.token.parser.IDPoPParser;
import org.openspcoop2.pdd.core.token.parser.IDynamicDiscoveryParser;
import org.openspcoop2.pdd.core.token.parser.ITokenParser;
import org.openspcoop2.pdd.core.token.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.token.pd.EsitoDynamicDiscoveryPortaDelegata;
import org.openspcoop2.pdd.core.token.pd.EsitoGestioneTokenPortaDelegata;
import org.openspcoop2.pdd.core.token.pd.EsitoValidazioneDPoPPortaDelegata;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.PDNDTokenInfo;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.RestMessageSecurityToken;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.protocol.utils.PorteNamingUtils;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.CRLCertstore;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.security.keystore.cache.GestoreOCSPResource;
import org.openspcoop2.security.keystore.cache.GestoreOCSPValidator;
import org.openspcoop2.security.message.utils.SecurityUtils;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.security.CertificateValidityCheck;
import org.openspcoop2.utils.security.JOSESerialization;
import org.openspcoop2.utils.security.JWEOptions;
import org.openspcoop2.utils.security.JWSOptions;
import org.openspcoop2.utils.security.JWTOptions;
import org.openspcoop2.utils.security.JsonDecrypt;
import org.openspcoop2.utils.security.JsonEncrypt;
import org.openspcoop2.utils.security.JsonSignature;
import org.openspcoop2.utils.security.JsonVerifySignature;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.IOCSPValidator;
import org.slf4j.Logger;

public class GestoreTokenValidazioneUtilities {
    private static final String PREFIX_ERROR_CONNESSIONE = "(Errore di Connessione) ";
    private static List<String> policyGestioneTokenPDND = null;

    private GestoreTokenValidazioneUtilities() {
    }

    static EsitoDynamicDiscovery dynamicDiscoveryEngine(Logger log, AbstractDatiInvocazione datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, String token, boolean portaDelegata, Busta busta, IDSoggetto idDominio, IDServizio idServizio) {
        EsitoDynamicDiscovery esitoGestioneToken = null;
        esitoGestioneToken = portaDelegata ? new EsitoDynamicDiscoveryPortaDelegata() : new EsitoDynamicDiscoveryPortaApplicativa();
        esitoGestioneToken.setTokenInternalError();
        esitoGestioneToken.setToken(token);
        try {
            PolicyGestioneToken policyGestioneToken = datiInvocazione.getPolicyGestioneToken();
            String detailsError = null;
            DynamicDiscovery dd = null;
            Exception eProcess = null;
            IDynamicDiscoveryParser ddParser = policyGestioneToken.getDynamicDiscoveryParser();
            PortaApplicativa pa = null;
            PortaDelegata pd = null;
            if (datiInvocazione instanceof DatiInvocazionePortaApplicativa) {
                pa = ((DatiInvocazionePortaApplicativa)datiInvocazione).getPa();
            } else if (datiInvocazione instanceof DatiInvocazionePortaDelegata) {
                pd = ((DatiInvocazionePortaDelegata)datiInvocazione).getPd();
            }
            HttpResponse httpResponse = null;
            Integer httpResponseCode = null;
            byte[] risposta = null;
            try {
                httpResponse = GestoreTokenValidazioneUtilities.http(log, policyGestioneToken, HTTP_TYPE.DYNAMIC_DISCOVERY, null, token, pddContext, protocolFactory, datiInvocazione.getState(), portaDelegata, datiInvocazione.getIdModulo(), pa, pd, idDominio, idServizio, busta, datiInvocazione.getRequestInfo());
                risposta = httpResponse.getContent();
                httpResponseCode = httpResponse.getResultHTTPOperation();
            }
            catch (Exception e) {
                detailsError = PREFIX_ERROR_CONNESSIONE + e.getMessage();
                eProcess = e;
            }
            if (detailsError == null) {
                try {
                    dd = new DynamicDiscovery(httpResponseCode, policyGestioneToken.getDynamicDiscoveryType(), new String(risposta), ddParser);
                }
                catch (Exception e) {
                    detailsError = "Risposta del servizio 'Dynamic Discovery' non valida: " + e.getMessage();
                    eProcess = e;
                }
            }
            if (dd != null && dd.isValid()) {
                esitoGestioneToken.setTokenValido();
                esitoGestioneToken.setDynamicDiscovery(dd);
                esitoGestioneToken.setNoCache(false);
            } else {
                esitoGestioneToken.setTokenValidazioneFallita();
                esitoGestioneToken.setNoCache(!policyGestioneToken.isIntrospectionSaveErrorInCache());
                esitoGestioneToken.setEccezioneProcessamento(eProcess);
                if (detailsError != null) {
                    esitoGestioneToken.setDetails(detailsError);
                } else {
                    esitoGestioneToken.setDetails("Token non valido");
                }
                if (OpenSPCoop2Properties.getInstance().isGestioneTokenSaveSourceTokenInfo() && httpResponseCode != null) {
                    dd = new DynamicDiscovery(esitoGestioneToken.getDetails(), httpResponseCode, risposta, policyGestioneToken.getDynamicDiscoveryType());
                    esitoGestioneToken.setDynamicDiscovery(dd);
                }
                if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                    esitoGestioneToken.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                } else {
                    esitoGestioneToken.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                }
            }
        }
        catch (Exception e) {
            esitoGestioneToken.setTokenInternalError();
            esitoGestioneToken.setDetails(e.getMessage());
            esitoGestioneToken.setEccezioneProcessamento(e);
        }
        return esitoGestioneToken;
    }

    static EsitoGestioneToken validazioneJWTTokenEngine(Logger log, AbstractDatiInvocazione datiInvocazione, EsitoPresenzaToken esitoPresenzaToken, DynamicDiscovery dynamicDiscovery, String token, boolean portaDelegata, PdDContext pddContext, Busta busta, IDSoggetto idDominio, IDServizio idServizio) {
        EsitoGestioneToken esitoGestioneToken = null;
        esitoGestioneToken = portaDelegata ? new EsitoGestioneTokenPortaDelegata() : new EsitoGestioneTokenPortaApplicativa();
        esitoGestioneToken.setTokenInternalError();
        esitoGestioneToken.setToken(token);
        try {
            RestMessageSecurityToken restSecurityToken;
            Exception eProcess;
            InformazioniToken informazioniToken;
            String detailsError;
            PolicyGestioneToken policyGestioneToken;
            block30: {
                policyGestioneToken = datiInvocazione.getPolicyGestioneToken();
                String tokenType = policyGestioneToken.getTipoToken();
                detailsError = null;
                informazioniToken = null;
                eProcess = null;
                restSecurityToken = null;
                ITokenParser tokenParser = policyGestioneToken.getValidazioneJWTTokenParser();
                if ("jws".equals(tokenType)) {
                    JsonVerifySignature jsonCompactVerify = null;
                    try {
                        RestMessageSecurityToken check = new RestMessageSecurityToken();
                        check.setToken((Serializable)((Object)token));
                        jsonCompactVerify = GestoreTokenValidazioneUtilities.getJsonVerifySignatureJWS(log, pddContext, datiInvocazione, policyGestioneToken, dynamicDiscovery, busta, idDominio, idServizio, portaDelegata, check);
                        if (jsonCompactVerify.verify(token)) {
                            informazioniToken = new InformazioniToken(SorgenteInformazioniToken.JWT, jsonCompactVerify.getDecodedPayload(), tokenParser);
                            if (pddContext != null) {
                                restSecurityToken = check;
                                if (jsonCompactVerify.getX509Certificate() != null) {
                                    restSecurityToken.setCertificate(new CertificateInfo(jsonCompactVerify.getX509Certificate(), "access_token"));
                                }
                                if (jsonCompactVerify.getJsonWebKey() != null) {
                                    restSecurityToken.setJsonWebKey(jsonCompactVerify.getJsonWebKey());
                                }
                                if (jsonCompactVerify.getRsaPublicKey() != null) {
                                    restSecurityToken.setPublicKey(jsonCompactVerify.getRsaPublicKey());
                                }
                                if (jsonCompactVerify.getKid() != null) {
                                    restSecurityToken.setKid(jsonCompactVerify.getKid());
                                }
                                if (esitoPresenzaToken != null) {
                                    restSecurityToken.setHttpHeaderName(esitoPresenzaToken.getHeaderHttp());
                                    restSecurityToken.setQueryParameterName(esitoPresenzaToken.getPropertyUrl());
                                    restSecurityToken.setFormParameterName(esitoPresenzaToken.getPropertyFormBased());
                                }
                            }
                            try {
                                GestoreTokenValidazioneUtilities.validazioneInformazioniTokenHeader(jsonCompactVerify.getDecodedHeader(), policyGestioneToken);
                            }
                            catch (Exception e) {
                                informazioniToken.setValid(false);
                                log.debug(GestoreToken.getMessageTokenNonValido(e), (Throwable)e);
                                detailsError = GestoreToken.getMessageTokenNonValido(e);
                                eProcess = e;
                            }
                            break block30;
                        }
                        detailsError = "Token non valido";
                    }
                    catch (Exception e) {
                        log.debug(GestoreToken.getMessageTokenNonValido(e), (Throwable)e);
                        detailsError = GestoreToken.getMessageTokenNonValido(e);
                        eProcess = e;
                    }
                } else {
                    JsonDecrypt jsonDecrypt = null;
                    try {
                        jsonDecrypt = GestoreTokenValidazioneUtilities.getJsonDecrypt(log, pddContext, datiInvocazione, policyGestioneToken, dynamicDiscovery, busta, idDominio, idServizio, portaDelegata);
                        jsonDecrypt.decrypt(token);
                        informazioniToken = new InformazioniToken(SorgenteInformazioniToken.JWT, jsonDecrypt.getDecodedPayload(), tokenParser);
                        if (pddContext != null) {
                            restSecurityToken = new RestMessageSecurityToken();
                            if (jsonDecrypt.getX509Certificate() != null) {
                                restSecurityToken.setCertificate(new CertificateInfo(jsonDecrypt.getX509Certificate(), "access_token"));
                            }
                            if (jsonDecrypt.getJsonWebKey() != null) {
                                restSecurityToken.setJsonWebKey(jsonDecrypt.getJsonWebKey());
                            }
                            if (jsonDecrypt.getPublicKey() != null) {
                                restSecurityToken.setPublicKey(jsonDecrypt.getPublicKey());
                            }
                            if (jsonDecrypt.getKid() != null) {
                                restSecurityToken.setKid(jsonDecrypt.getKid());
                            }
                            restSecurityToken.setJweDecodedPayload(jsonDecrypt.getDecodedPayload());
                            restSecurityToken.setToken((Serializable)((Object)token));
                            if (esitoPresenzaToken != null) {
                                restSecurityToken.setHttpHeaderName(esitoPresenzaToken.getHeaderHttp());
                                restSecurityToken.setQueryParameterName(esitoPresenzaToken.getPropertyUrl());
                                restSecurityToken.setFormParameterName(esitoPresenzaToken.getPropertyFormBased());
                            }
                        }
                    }
                    catch (Exception e) {
                        log.debug(GestoreToken.getMessageTokenNonValido(e), (Throwable)e);
                        detailsError = GestoreToken.getMessageTokenNonValido(e);
                        eProcess = e;
                    }
                }
            }
            if (informazioniToken != null && informazioniToken.isValid()) {
                esitoGestioneToken.setTokenValido();
                esitoGestioneToken.setInformazioniToken(informazioniToken);
                esitoGestioneToken.setNoCache(false);
                esitoGestioneToken.setRestSecurityToken(restSecurityToken);
            } else {
                esitoGestioneToken.setTokenValidazioneFallita();
                esitoGestioneToken.setNoCache(!policyGestioneToken.isValidazioneJWTSaveErrorInCache());
                esitoGestioneToken.setEccezioneProcessamento(eProcess);
                if (detailsError != null) {
                    esitoGestioneToken.setDetails(detailsError);
                } else {
                    esitoGestioneToken.setDetails("Token non valido");
                }
                if (OpenSPCoop2Properties.getInstance().isGestioneTokenSaveTokenInfoValidationFailed()) {
                    informazioniToken = new InformazioniToken(esitoGestioneToken.getDetails(), SorgenteInformazioniToken.JWT, token);
                    esitoGestioneToken.setInformazioniToken(informazioniToken);
                }
                if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                    esitoGestioneToken.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                } else {
                    esitoGestioneToken.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                }
            }
        }
        catch (Exception e) {
            esitoGestioneToken.setTokenInternalError();
            esitoGestioneToken.setDetails(e.getMessage());
            esitoGestioneToken.setEccezioneProcessamento(e);
        }
        return esitoGestioneToken;
    }

    private static JsonVerifySignature getJsonVerifySignatureJWS(Logger log, Context context, AbstractDatiInvocazione datiInvocazione, PolicyGestioneToken policyGestioneToken, DynamicDiscovery dynamicDiscovery, Busta busta, IDSoggetto idDominio, IDServizio idServizio, boolean portaDelegata, RestMessageSecurityToken token) throws TokenException, UtilsException, SecurityException {
        Object oKeystore;
        String alias;
        AbstractDatiInvocazione dati;
        JsonVerifySignature jsonCompactVerify = null;
        String signatureAlgorithm = policyGestioneToken.getValidazioneJWTSignatureAlgorithm(token);
        JWTOptions options = new JWTOptions(JOSESerialization.COMPACT);
        Properties p = policyGestioneToken.getProperties().get("signatureVerificationPropRefId");
        SecurityUtils.dynamicUpdateKeyPairAlgorithm((Properties)p, (String)signatureAlgorithm);
        TokenUtilities.injectJOSEConfig(p, policyGestioneToken, dynamicDiscovery, busta, idDominio, idServizio, context, log, datiInvocazione.getRequestInfo(), datiInvocazione.getState(), portaDelegata);
        TokenKeystoreInjectUtilities inject = new TokenKeystoreInjectUtilities(log, datiInvocazione.getRequestInfo(), datiInvocazione.getRequestInfo() != null ? datiInvocazione.getRequestInfo().getProtocolFactory() : null, context, datiInvocazione.getState(), busta);
        if (datiInvocazione instanceof DatiInvocazionePortaApplicativa) {
            dati = (DatiInvocazionePortaApplicativa)datiInvocazione;
            inject.initTokenPolicyValidazioneJwt(policyGestioneToken.getName(), portaDelegata, ((DatiInvocazionePortaApplicativa)dati).getPd(), ((DatiInvocazionePortaApplicativa)dati).getPa(), p);
        } else {
            dati = (DatiInvocazionePortaDelegata)datiInvocazione;
            inject.initTokenPolicyValidazioneJwt(policyGestioneToken.getName(), portaDelegata, ((DatiInvocazionePortaDelegata)dati).getPd(), null, p);
        }
        inject.inject(p);
        String aliasMode = p.getProperty("rs.security.keystore.alias.mode");
        if (aliasMode != null && (aliasMode.equals("x5c") || aliasMode.equals("x5t#256") || aliasMode.equals("x5c_x5t#256") || aliasMode.equals("kid") || aliasMode.equals("x5u"))) {
            Object keystore;
            Object oKeystore2;
            options.setPermitUseHeaderX5C(aliasMode.equals("x5c") || aliasMode.equals("x5c_x5t#256"));
            options.setPermitUseHeaderX5T_256(aliasMode.equals("x5t#256") || aliasMode.equals("x5c_x5t#256"));
            options.setPermitUseHeaderKID(aliasMode.equals("kid"));
            options.setPermitUseHeaderX5U(aliasMode.equals("x5u"));
            if (p.containsKey("rs.security.keystore")) {
                oKeystore2 = p.get("rs.security.keystore");
                if (oKeystore2 instanceof java.security.KeyStore) {
                    AbstractDatiInvocazione dati2;
                    keystore = (java.security.KeyStore)oKeystore2;
                    jsonCompactVerify = new JsonVerifySignature((java.security.KeyStore)keystore, options);
                    CertificateValidityCheck validityCheck = OpenSPCoop2Properties.getInstance().getGestioneTokenValidityCheck();
                    List proprieta = null;
                    if (datiInvocazione instanceof DatiInvocazionePortaApplicativa) {
                        dati2 = (DatiInvocazionePortaApplicativa)datiInvocazione;
                        if (((DatiInvocazionePortaApplicativa)dati2).getPa() != null) {
                            proprieta = ((DatiInvocazionePortaApplicativa)dati2).getPa().getProprietaList();
                        } else if (((DatiInvocazionePortaApplicativa)dati2).getPd() != null) {
                            proprieta = ((DatiInvocazionePortaApplicativa)dati2).getPd().getProprietaList();
                        }
                    } else if (datiInvocazione instanceof DatiInvocazionePortaDelegata && ((DatiInvocazionePortaDelegata)(dati2 = (DatiInvocazionePortaDelegata)datiInvocazione)).getPd() != null) {
                        proprieta = ((DatiInvocazionePortaDelegata)dati2).getPd().getProprietaList();
                    }
                    validityCheck = CostantiProprieta.getTokenValidationCertificateValidityCheck(proprieta, validityCheck);
                    jsonCompactVerify.setValidityCheck(validityCheck);
                    String signatureOCSP = policyGestioneToken.getValidazioneJWTOcspPolicy();
                    String signatureCRL = policyGestioneToken.getValidazioneJWTCrl();
                    boolean crlByOcsp = false;
                    if (signatureOCSP != null && !"".equals(signatureOCSP)) {
                        LoggerBuffer lb = new LoggerBuffer();
                        lb.setLogDebug(log);
                        lb.setLogError(log);
                        GestoreOCSPResource ocspResourceReader = new GestoreOCSPResource(datiInvocazione.getRequestInfo());
                        GestoreOCSPValidator ocspValidator = null;
                        try {
                            KeyStore trustStore = new KeyStore((java.security.KeyStore)keystore);
                            ocspValidator = new GestoreOCSPValidator(datiInvocazione.getRequestInfo(), lb, trustStore, signatureCRL, signatureOCSP, (IOCSPResourceReader)ocspResourceReader);
                        }
                        catch (Exception e) {
                            throw new TokenException("ocsp initialization (policy:'" + signatureOCSP + "') failed: " + e.getMessage(), e);
                        }
                        jsonCompactVerify.setOcspValidatorX509((IOCSPValidator)ocspValidator);
                        GestoreOCSPValidator gOcspValidator = ocspValidator;
                        if (gOcspValidator.getOcspConfig() != null) {
                            crlByOcsp = gOcspValidator.getOcspConfig().isCrl();
                        }
                    }
                    if (signatureCRL != null && !"".equals(signatureCRL) && !crlByOcsp) {
                        CRLCertstore crlCertstore = GestoreKeystoreCache.getCRLCertstore((RequestInfo)datiInvocazione.getRequestInfo(), (String)signatureCRL);
                        if (crlCertstore == null) {
                            throw new TokenException("Process CRL '" + signatureCRL + "' failed");
                        }
                        jsonCompactVerify.setCrlX509(crlCertstore.getCertStore());
                    }
                }
            } else if (p.containsKey("rs.security.keystore.jwkset") && (oKeystore2 = p.get("rs.security.keystore.jwkset")) instanceof String) {
                keystore = (String)oKeystore2;
                JsonWebKeys jwksKeystore = new JWKSet((String)keystore).getJsonWebKeys();
                jsonCompactVerify = new JsonVerifySignature(jwksKeystore, options);
            }
        }
        if (jsonCompactVerify == null && p.containsKey("rs.security.keystore.alias") && (alias = p.getProperty("rs.security.keystore.alias")) != null && (alias.equals("##useX5C##") || alias.equals("##useX5T##") || alias.equals("##useX5C-X5T##")) && p.containsKey("rs.security.keystore") && (oKeystore = p.get("rs.security.keystore")) instanceof java.security.KeyStore) {
            java.security.KeyStore keystore = (java.security.KeyStore)oKeystore;
            options.setPermitUseHeaderX5C(alias.equals("##useX5C##") || alias.equals("##useX5C-X5T##"));
            options.setPermitUseHeaderX5T(alias.equals("##useX5T##") || alias.equals("##useX5C-X5T##"));
            options.setPermitUseHeaderX5T_256(alias.equals("##useX5T##") || alias.equals("##useX5C-X5T##"));
            jsonCompactVerify = new JsonVerifySignature(keystore, options);
        }
        if (jsonCompactVerify == null) {
            jsonCompactVerify = new JsonVerifySignature(p, signatureAlgorithm, options);
        } else {
            jsonCompactVerify.setSignatureAlgorithm(signatureAlgorithm);
        }
        jsonCompactVerify.setJksPasswordRequired(DBUtils.isTruststoreJksPasswordRequired());
        jsonCompactVerify.setPkcs12PasswordRequired(DBUtils.isTruststorePkcs12PasswordRequired());
        return jsonCompactVerify;
    }

    private static JsonDecrypt getJsonDecrypt(Logger log, Context context, AbstractDatiInvocazione datiInvocazione, PolicyGestioneToken policyGestioneToken, DynamicDiscovery dynamicDiscovery, Busta busta, IDSoggetto idDominio, IDServizio idServizio, boolean portaDelegata) throws TokenException, UtilsException, SecurityException {
        JsonDecrypt jsonDecrypt = null;
        JWTOptions options = new JWTOptions(JOSESerialization.COMPACT);
        Properties p = policyGestioneToken.getProperties().get("decryptionPropRefId");
        TokenUtilities.injectJOSEConfig(p, policyGestioneToken, dynamicDiscovery, busta, idDominio, idServizio, context, log, datiInvocazione.getRequestInfo(), datiInvocazione.getState(), portaDelegata);
        TokenKeystoreInjectUtilities inject = new TokenKeystoreInjectUtilities(log, datiInvocazione.getRequestInfo(), datiInvocazione.getRequestInfo() != null ? datiInvocazione.getRequestInfo().getProtocolFactory() : null, context, datiInvocazione.getState(), busta);
        if (datiInvocazione instanceof DatiInvocazionePortaApplicativa) {
            DatiInvocazionePortaApplicativa dati = (DatiInvocazionePortaApplicativa)datiInvocazione;
            inject.initTokenPolicyValidazioneJwt(policyGestioneToken.getName(), portaDelegata, dati.getPd(), dati.getPa(), p);
        } else {
            DatiInvocazionePortaDelegata dati = (DatiInvocazionePortaDelegata)datiInvocazione;
            inject.initTokenPolicyValidazioneJwt(policyGestioneToken.getName(), portaDelegata, dati.getPd(), null, p);
        }
        inject.inject(p);
        jsonDecrypt = new JsonDecrypt(p, options, DBUtils.isKeystoreJksPasswordRequired(), DBUtils.isKeystorePkcs12PasswordRequired());
        return jsonDecrypt;
    }

    static EsitoGestioneToken introspectionTokenEngine(Logger log, AbstractDatiInvocazione datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, DynamicDiscovery dynamicDiscovery, String token, boolean portaDelegata, Busta busta, IDSoggetto idDominio, IDServizio idServizio) {
        EsitoGestioneToken esitoGestioneToken = null;
        esitoGestioneToken = portaDelegata ? new EsitoGestioneTokenPortaDelegata() : new EsitoGestioneTokenPortaApplicativa();
        esitoGestioneToken.setTokenInternalError();
        esitoGestioneToken.setToken(token);
        try {
            PolicyGestioneToken policyGestioneToken = datiInvocazione.getPolicyGestioneToken();
            String detailsError = null;
            InformazioniToken informazioniToken = null;
            Exception eProcess = null;
            ITokenParser tokenParser = policyGestioneToken.getIntrospectionTokenParser();
            PortaApplicativa pa = null;
            PortaDelegata pd = null;
            if (datiInvocazione instanceof DatiInvocazionePortaApplicativa) {
                pa = ((DatiInvocazionePortaApplicativa)datiInvocazione).getPa();
            } else if (datiInvocazione instanceof DatiInvocazionePortaDelegata) {
                pd = ((DatiInvocazionePortaDelegata)datiInvocazione).getPd();
            }
            HttpResponse httpResponse = null;
            Integer httpResponseCode = null;
            byte[] risposta = null;
            try {
                httpResponse = GestoreTokenValidazioneUtilities.http(log, policyGestioneToken, HTTP_TYPE.INTROSPECTION, dynamicDiscovery, token, pddContext, protocolFactory, datiInvocazione.getState(), portaDelegata, datiInvocazione.getIdModulo(), pa, pd, idDominio, idServizio, busta, datiInvocazione.getRequestInfo());
                risposta = httpResponse.getContent();
                httpResponseCode = httpResponse.getResultHTTPOperation();
            }
            catch (Exception e) {
                detailsError = PREFIX_ERROR_CONNESSIONE + e.getMessage();
                eProcess = e;
            }
            if (detailsError == null) {
                try {
                    informazioniToken = new InformazioniToken(httpResponseCode, SorgenteInformazioniToken.INTROSPECTION, new String(risposta), tokenParser);
                }
                catch (Exception e) {
                    detailsError = "Risposta del servizio di Introspection non valida: " + e.getMessage();
                    eProcess = e;
                }
            }
            if (informazioniToken != null && informazioniToken.isValid()) {
                esitoGestioneToken.setTokenValido();
                esitoGestioneToken.setInformazioniToken(informazioniToken);
                esitoGestioneToken.setNoCache(false);
            } else {
                esitoGestioneToken.setTokenValidazioneFallita();
                esitoGestioneToken.setNoCache(!policyGestioneToken.isIntrospectionSaveErrorInCache());
                esitoGestioneToken.setEccezioneProcessamento(eProcess);
                if (detailsError != null) {
                    esitoGestioneToken.setDetails(detailsError);
                } else {
                    esitoGestioneToken.setDetails("Token non valido");
                }
                if (OpenSPCoop2Properties.getInstance().isGestioneTokenSaveSourceTokenInfo() && httpResponseCode != null) {
                    informazioniToken = new InformazioniToken(esitoGestioneToken.getDetails(), httpResponseCode, risposta, SorgenteInformazioniToken.INTROSPECTION, token);
                    esitoGestioneToken.setInformazioniToken(informazioniToken);
                }
                if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                    esitoGestioneToken.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                } else {
                    esitoGestioneToken.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                }
            }
        }
        catch (Exception e) {
            esitoGestioneToken.setTokenInternalError();
            esitoGestioneToken.setDetails(e.getMessage());
            esitoGestioneToken.setEccezioneProcessamento(e);
        }
        return esitoGestioneToken;
    }

    static EsitoGestioneToken userInfoTokenEngine(Logger log, AbstractDatiInvocazione datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, DynamicDiscovery dynamicDiscovery, String token, boolean portaDelegata, Busta busta, IDSoggetto idDominio, IDServizio idServizio) {
        EsitoGestioneToken esitoGestioneToken = null;
        esitoGestioneToken = portaDelegata ? new EsitoGestioneTokenPortaDelegata() : new EsitoGestioneTokenPortaApplicativa();
        esitoGestioneToken.setTokenInternalError();
        esitoGestioneToken.setToken(token);
        try {
            PolicyGestioneToken policyGestioneToken = datiInvocazione.getPolicyGestioneToken();
            String detailsError = null;
            InformazioniToken informazioniToken = null;
            Exception eProcess = null;
            ITokenParser tokenParser = policyGestioneToken.getUserInfoTokenParser();
            PortaApplicativa pa = null;
            PortaDelegata pd = null;
            if (datiInvocazione instanceof DatiInvocazionePortaApplicativa) {
                pa = ((DatiInvocazionePortaApplicativa)datiInvocazione).getPa();
            } else if (datiInvocazione instanceof DatiInvocazionePortaDelegata) {
                pd = ((DatiInvocazionePortaDelegata)datiInvocazione).getPd();
            }
            HttpResponse httpResponse = null;
            Integer httpResponseCode = null;
            byte[] risposta = null;
            try {
                httpResponse = GestoreTokenValidazioneUtilities.http(log, policyGestioneToken, HTTP_TYPE.USER_INFO, dynamicDiscovery, token, pddContext, protocolFactory, datiInvocazione.getState(), portaDelegata, datiInvocazione.getIdModulo(), pa, pd, idDominio, idServizio, busta, datiInvocazione.getRequestInfo());
                risposta = httpResponse.getContent();
                httpResponseCode = httpResponse.getResultHTTPOperation();
            }
            catch (Exception e) {
                detailsError = PREFIX_ERROR_CONNESSIONE + e.getMessage();
                eProcess = e;
            }
            if (detailsError == null) {
                try {
                    informazioniToken = new InformazioniToken(httpResponseCode, SorgenteInformazioniToken.USER_INFO, new String(risposta), tokenParser);
                }
                catch (Exception e) {
                    detailsError = "Risposta del servizio di UserInfo non valida: " + e.getMessage();
                    eProcess = e;
                }
            }
            if (informazioniToken != null && informazioniToken.isValid()) {
                esitoGestioneToken.setTokenValido();
                esitoGestioneToken.setInformazioniToken(informazioniToken);
                esitoGestioneToken.setNoCache(false);
            } else {
                esitoGestioneToken.setTokenValidazioneFallita();
                esitoGestioneToken.setNoCache(!policyGestioneToken.isUserInfoSaveErrorInCache());
                esitoGestioneToken.setEccezioneProcessamento(eProcess);
                if (detailsError != null) {
                    esitoGestioneToken.setDetails(detailsError);
                } else {
                    esitoGestioneToken.setDetails("Token non valido");
                }
                if (OpenSPCoop2Properties.getInstance().isGestioneTokenSaveSourceTokenInfo() && httpResponseCode != null) {
                    informazioniToken = new InformazioniToken(esitoGestioneToken.getDetails(), httpResponseCode, risposta, SorgenteInformazioniToken.USER_INFO, token);
                    esitoGestioneToken.setInformazioniToken(informazioniToken);
                }
                if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                    esitoGestioneToken.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                } else {
                    esitoGestioneToken.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                }
            }
        }
        catch (Exception e) {
            esitoGestioneToken.setTokenInternalError();
            esitoGestioneToken.setDetails(e.getMessage());
            esitoGestioneToken.setEccezioneProcessamento(e);
        }
        return esitoGestioneToken;
    }

    static EsitoValidazioneDPoP validazioneDPoPEngine(Logger log, AbstractDatiInvocazione datiInvocazione, EsitoPresenzaDPoP esitoPresenzaDPoP, EsitoGestioneToken esitoGestioneToken, IProtocolFactory<?> protocolFactory, String accessToken, boolean portaDelegata, PdDContext pddContext, Busta busta, IDSoggetto idDominio, IDServizio idServizio) {
        if (pddContext == null || idDominio == null || idServizio == null || busta != null) {
            // empty if block
        }
        String dpopToken = esitoPresenzaDPoP != null ? esitoPresenzaDPoP.getToken() : null;
        EsitoValidazioneDPoP esitoValidazioneDPoP = null;
        esitoValidazioneDPoP = portaDelegata ? new EsitoValidazioneDPoPPortaDelegata() : new EsitoValidazioneDPoPPortaApplicativa();
        esitoValidazioneDPoP.setTokenInternalError();
        esitoValidazioneDPoP.setToken(dpopToken);
        try {
            RestMessageSecurityToken restSecurityToken;
            Exception eProcess;
            DPoP informazioniDPoP;
            String detailsError;
            PolicyGestioneToken policyGestioneToken;
            block14: {
                policyGestioneToken = datiInvocazione.getPolicyGestioneToken();
                detailsError = null;
                informazioniDPoP = null;
                eProcess = null;
                restSecurityToken = null;
                try {
                    IDPoPParser dpopParser = GestoreTokenValidazioneUtilities.parseDPoPToken(dpopToken, policyGestioneToken);
                    DPoP dpop = new DPoP();
                    GestoreTokenValidazioneUtilities.validazioneDPoPHeader(dpop, dpopParser, policyGestioneToken);
                    GestoreTokenValidazioneUtilities.validazioneDPoPPayload(dpop, dpopParser, policyGestioneToken, datiInvocazione, protocolFactory, pddContext, accessToken, log);
                    GestoreTokenValidazioneUtilities.validazioneDPoPCnfJkt(dpop, dpopParser, esitoGestioneToken, log);
                    informazioniDPoP = dpop;
                    if (pddContext != null) {
                        restSecurityToken = new RestMessageSecurityToken();
                        JsonWebKey jsonWebKey = dpopParser.getJsonWebKey();
                        if (jsonWebKey != null) {
                            restSecurityToken.setJsonWebKey(jsonWebKey);
                        }
                        restSecurityToken.setToken((Serializable)((Object)dpopToken));
                        if (esitoPresenzaDPoP != null) {
                            restSecurityToken.setHttpHeaderName(esitoPresenzaDPoP.getHeaderHttp());
                            restSecurityToken.setQueryParameterName(esitoPresenzaDPoP.getPropertyUrl());
                        }
                    }
                }
                catch (Exception e) {
                    log.debug(GestoreToken.getMessageTokenNonValido(e), (Throwable)e);
                    detailsError = GestoreToken.getMessageTokenNonValido(e);
                    if (e instanceof TokenException) break block14;
                    eProcess = e;
                }
            }
            if (informazioniDPoP != null) {
                esitoValidazioneDPoP.setTokenValido();
                esitoValidazioneDPoP.setInformazioniDPoP(informazioniDPoP);
                esitoValidazioneDPoP.setNoCache(false);
                esitoValidazioneDPoP.setRestSecurityToken(restSecurityToken);
            } else {
                esitoValidazioneDPoP.setTokenValidazioneFallita();
                esitoValidazioneDPoP.setNoCache(true);
                esitoValidazioneDPoP.setEccezioneProcessamento(eProcess);
                if (detailsError != null) {
                    esitoValidazioneDPoP.setDetails(detailsError);
                } else {
                    esitoValidazioneDPoP.setDetails("Invalid DPoP ");
                }
                if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                    esitoValidazioneDPoP.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((String)"DPoP ", (WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_dpop_proof, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoValidazioneDPoP.getDetails(), (String[])new String[0]));
                } else {
                    esitoValidazioneDPoP.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((String)"DPoP ", (WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_dpop_proof, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoValidazioneDPoP.getDetails(), (String[])new String[0]));
                }
            }
        }
        catch (Exception e) {
            esitoValidazioneDPoP.setTokenInternalError();
            esitoValidazioneDPoP.setDetails(e.getMessage());
            esitoValidazioneDPoP.setEccezioneProcessamento(e);
        }
        return esitoValidazioneDPoP;
    }

    private static IDPoPParser parseDPoPToken(String dpopToken, PolicyGestioneToken policyGestioneToken) throws TokenException {
        if (dpopToken == null) {
            throw new TokenException("DPoP token not found");
        }
        String[] parts = dpopToken.split("\\.");
        if (parts.length != 3) {
            throw new TokenException("Invalid DPoP token format: expected JWS Compact (3 parts), found " + parts.length + " parts");
        }
        IDPoPParser dpopParser = null;
        try {
            dpopParser = policyGestioneToken.getValidazioneDPoPParser();
            dpopParser.init(dpopToken);
        }
        catch (Exception e) {
            throw new TokenException("Invalid DPoP token: " + e.getMessage(), e);
        }
        JsonWebKey jsonWebKey = null;
        try {
            jsonWebKey = dpopParser.getJsonWebKey();
        }
        catch (Exception e) {
            throw new TokenException("Invalid DPoP token: header 'jwk' invalid: " + e.getMessage(), e);
        }
        if (jsonWebKey == null) {
            throw new TokenException("Invalid DPoP token: header 'jwk' not present or invalid");
        }
        String algorithm = dpopParser.getAlgorithm();
        if (algorithm == null || algorithm.trim().isEmpty()) {
            throw new TokenException("Invalid DPoP token: header 'alg' not present or invalid");
        }
        if (SignatureAlgorithm.NONE.name().equalsIgnoreCase(algorithm)) {
            throw new TokenException("Invalid DPoP token: header 'alg=none' is not allowed");
        }
        JWTOptions options = new JWTOptions(JOSESerialization.COMPACT);
        try {
            JsonVerifySignature jsonVerifySignature = new JsonVerifySignature(jsonWebKey, false, algorithm, options);
            if (!jsonVerifySignature.verify(dpopToken)) {
                throw new TokenException("Invalid DPoP token: signature verification failed");
            }
        }
        catch (Exception e) {
            throw new TokenException("Invalid DPoP token: signature verification failed: " + e.getMessage(), e);
        }
        return dpopParser;
    }

    private static void validazioneDPoPHeader(DPoP dpop, IDPoPParser dpopParser, PolicyGestioneToken policyGestioneToken) throws TokenException {
        String typ = dpopParser.getType();
        List<String> expectedTyp = policyGestioneToken.getValidazioneDPoPHeaderTyp();
        GestoreTokenValidazioneUtilities.validazioneDPoPInformazioniTokenHeader(typ, expectedTyp, "typ");
        dpop.setTyp(typ);
        String alg = dpopParser.getAlgorithm();
        List<String> expectedAlg = policyGestioneToken.getValidazioneDPoPHeaderAlg();
        GestoreTokenValidazioneUtilities.validazioneDPoPInformazioniTokenHeader(alg, expectedAlg, "alg");
        dpop.setAlg(alg);
    }

    private static void validazioneDPoPInformazioniTokenHeader(String v, List<String> expectedValues, String claim) throws TokenException {
        if (expectedValues != null && !expectedValues.isEmpty()) {
            if (v == null || StringUtils.isEmpty((String)v)) {
                throw new TokenException("Expected claim '" + claim + "' not found");
            }
            boolean find = false;
            for (String vCheck : expectedValues) {
                if (!v.equalsIgnoreCase(vCheck)) continue;
                find = true;
                break;
            }
            if (!find) {
                throw new TokenException("Claim '" + claim + "' with invalid value '" + v + "'");
            }
        }
    }

    private static void validazioneDPoPPayload(DPoP dpop, IDPoPParser dpopParser, PolicyGestioneToken policyGestioneToken, AbstractDatiInvocazione datiInvocazione, IProtocolFactory<?> protocolFactory, PdDContext pddContext, String accessToken, Logger log) throws TokenException, UtilsException {
        GestoreTokenValidazioneUtilities.validazioneDPoPHtm(dpop, dpopParser, datiInvocazione);
        GestoreTokenValidazioneUtilities.validazioneDPoPHtu(dpop, dpopParser, datiInvocazione, protocolFactory, pddContext, log);
        GestoreTokenValidazioneUtilities.validazioneDPoPAth(dpop, dpopParser, accessToken);
        GestoreTokenValidazioneUtilities.validazioneDPoPIat(dpop, dpopParser, policyGestioneToken);
        GestoreTokenValidazioneUtilities.validazioneDPoPJti(dpop, dpopParser, policyGestioneToken, datiInvocazione, pddContext, log);
    }

    private static void validazioneDPoPHtm(DPoP dpop, IDPoPParser dpopParser, AbstractDatiInvocazione datiInvocazione) throws TokenException {
        String htm = dpopParser.getHttpMethod();
        if (htm == null || htm.trim().isEmpty()) {
            throw new TokenException("Invalid DPoP token: claim 'htm' is missing");
        }
        dpop.setHtm(htm);
        URLProtocolContext transportRequestContext = datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext();
        String actualMethod = transportRequestContext.getRequestType();
        if (!htm.equalsIgnoreCase(actualMethod)) {
            throw new TokenException("Invalid DPoP token: claim 'htm' (" + htm + ") does not match HTTP method of the request (" + actualMethod + ")");
        }
    }

    private static void validazioneDPoPHtu(DPoP dpop, IDPoPParser dpopParser, AbstractDatiInvocazione datiInvocazione, IProtocolFactory<?> protocolFactory, PdDContext pddContext, Logger log) throws TokenException, UtilsException {
        StringBuilder interfaceName = new StringBuilder();
        UrlInvocazioneAPI configUrl = GestoreTokenValidazioneUtilities.getBaseUrlInvocazione(datiInvocazione, protocolFactory, pddContext, interfaceName);
        String htu = dpopParser.getHttpUri();
        if (htu == null || htu.trim().isEmpty()) {
            throw new TokenException("Invalid DPoP token: claim 'htu' is missing");
        }
        dpop.setHtu(htu);
        List<String> prefixAggiuntivi = null;
        List<String> baseUrlAggiuntive = null;
        try {
            List<Proprieta> listProprieta = GestoreTokenValidazioneUtilities.readProprieta(datiInvocazione);
            if (listProprieta != null && !listProprieta.isEmpty()) {
                prefixAggiuntivi = CostantiProprieta.getDPoPValidationHtuPrefixUrls(listProprieta);
                baseUrlAggiuntive = CostantiProprieta.getDPoPValidationHtuBaseUrls(listProprieta);
            }
        }
        catch (Exception e) {
            throw new UtilsException("Error reading DPoP HTU validation properties from API configuration: " + e.getMessage(), (Throwable)e);
        }
        StringBuilder sbNormalizedActualUri = new StringBuilder();
        if (!GestoreTokenValidazioneUtilities.matchUrlInvocata(log, datiInvocazione, configUrl, prefixAggiuntivi, baseUrlAggiuntive, htu, interfaceName.length() > 0 ? interfaceName.toString() : null, sbNormalizedActualUri)) {
            throw new TokenException("Invalid DPoP token: claim 'htu' (" + htu + ") does not match request URI (" + sbNormalizedActualUri + ")");
        }
    }

    private static UrlInvocazioneAPI getBaseUrlInvocazione(AbstractDatiInvocazione datiInvocazione, IProtocolFactory<?> protocolFactory, PdDContext pddContext, StringBuilder interfaceName) throws TokenException {
        boolean soap = datiInvocazione != null && datiInvocazione.getMessage() != null && ServiceBinding.SOAP.equals((Object)datiInvocazione.getMessage().getServiceBinding());
        AccordoServizioParteComune aspc = null;
        RuoloContesto ruoloContesto = null;
        String nomePorta = null;
        IDSoggetto proprietarioPorta = null;
        if (datiInvocazione == null) {
            return null;
        }
        if (pddContext != null && pddContext.containsKey(CostantiPdD.NOME_PORTA_INVOCATA)) {
            nomePorta = (String)pddContext.getObject(CostantiPdD.NOME_PORTA_INVOCATA);
        } else if (datiInvocazione.getRequestInfo() != null && datiInvocazione.getRequestInfo().getProtocolContext() != null) {
            nomePorta = datiInvocazione.getRequestInfo().getProtocolContext().getInterfaceName();
        }
        try {
            RegistroServiziManager regManager;
            AccordoServizioParteSpecifica asps;
            AbstractDatiInvocazione d;
            IDServizio idServizio = null;
            if (datiInvocazione instanceof DatiInvocazionePortaDelegata) {
                d = (DatiInvocazionePortaDelegata)datiInvocazione;
                ruoloContesto = RuoloContesto.PORTA_DELEGATA;
                PortaDelegata pd = ((DatiInvocazionePortaDelegata)d).getPd();
                if (pd == null && ((DatiInvocazionePortaDelegata)d).getIdPD() != null) {
                    ConfigurazionePdDManager configManager = ConfigurazionePdDManager.getInstance(datiInvocazione.getState());
                    pd = configManager.getPortaDelegataSafeMethod(((DatiInvocazionePortaDelegata)d).getIdPD(), datiInvocazione.getRequestInfo());
                }
                if (pd != null) {
                    if (nomePorta == null) {
                        nomePorta = pd.getNome();
                    }
                    proprietarioPorta = new IDSoggetto(pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario());
                    if (pd.getServizio() != null && pd.getSoggettoErogatore() != null) {
                        idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pd.getServizio().getTipo(), pd.getServizio().getNome(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome(), pd.getServizio().getVersione().intValue());
                    }
                    if (nomePorta != null && interfaceName != null) {
                        PorteNamingUtils namingUtils = new PorteNamingUtils(protocolFactory);
                        interfaceName.append(namingUtils.normalizePD(nomePorta));
                    }
                }
            } else if (datiInvocazione instanceof DatiInvocazionePortaApplicativa) {
                d = (DatiInvocazionePortaApplicativa)datiInvocazione;
                ruoloContesto = RuoloContesto.PORTA_APPLICATIVA;
                PortaApplicativa pa = ((DatiInvocazionePortaApplicativa)d).getPa();
                if (pa == null && ((DatiInvocazionePortaApplicativa)d).getIdPA() != null) {
                    ConfigurazionePdDManager configManager = ConfigurazionePdDManager.getInstance(datiInvocazione.getState());
                    pa = configManager.getPortaApplicativaSafeMethod(((DatiInvocazionePortaApplicativa)d).getIdPA(), datiInvocazione.getRequestInfo());
                }
                if (pa != null) {
                    if (nomePorta == null) {
                        nomePorta = pa.getNome();
                    }
                    proprietarioPorta = new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario());
                    if (pa.getServizio() != null) {
                        idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pa.getServizio().getTipo(), pa.getServizio().getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario(), pa.getServizio().getVersione().intValue());
                    }
                    if (nomePorta != null && interfaceName != null) {
                        PorteNamingUtils namingUtils = new PorteNamingUtils(protocolFactory);
                        interfaceName.append(namingUtils.normalizePA(nomePorta));
                    }
                }
            }
            if (idServizio != null && (asps = (regManager = RegistroServiziManager.getInstance((IState)datiInvocazione.getState())).getAccordoServizioParteSpecifica(idServizio, null, Boolean.valueOf(false), datiInvocazione.getRequestInfo())) != null) {
                aspc = regManager.getAccordoServizioParteComune(IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune()), null, Boolean.valueOf(false), Boolean.valueOf(false), datiInvocazione.getRequestInfo());
            }
            return UrlInvocazioneAPIUtils.getUrlInvocazioneObject(protocolFactory, datiInvocazione.getState(), datiInvocazione.getRequestInfo(), !soap, aspc, ruoloContesto, nomePorta, proprietarioPorta);
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage(), e);
        }
    }

    private static String nomrmalizeSlashUrl(String u) {
        String s = u;
        if (s.startsWith("/") && s.length() > 1) {
            s = s.substring(1);
        }
        if (s.endsWith("/") && s.length() > 1) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.length() == 1 && "".equals(s)) {
            return null;
        }
        return s;
    }

    private static boolean matchUrlInvocata(Logger log, AbstractDatiInvocazione datiInvocazione, UrlInvocazioneAPI urlInvocazione, List<String> prefixAggiuntivi, List<String> baseUrlAggiuntive, String htu, String interfaceName, StringBuilder sbNormalizedActualUri) {
        String prefix = urlInvocazione.getBaseUrl();
        String protocolContext = null;
        if (urlInvocazione.getContext() != null && interfaceName != null && urlInvocazione.getContext().contains(interfaceName)) {
            String c = GestoreTokenValidazioneUtilities.nomrmalizeSlashUrl(urlInvocazione.getContext());
            String i = GestoreTokenValidazioneUtilities.nomrmalizeSlashUrl(interfaceName);
            if (c != null && i != null && c.endsWith(i) && c.length() > i.length()) {
                protocolContext = c.replace(i, "");
            }
        }
        String functionParameters = datiInvocazione.getRequestInfo().getProtocolContext().getFunctionParameters();
        String protocolWebContext = datiInvocazione.getRequestInfo().getProtocolContext().getProtocolWebContext();
        String function = datiInvocazione.getRequestInfo().getProtocolContext().getFunction();
        if (functionParameters.startsWith("/")) {
            functionParameters = functionParameters.substring(1);
        }
        String urlDefault = null;
        if (protocolContext == null) {
            urlDefault = Utilities.buildUrl((String)prefix, (String)functionParameters);
        } else {
            urlDefault = Utilities.buildUrl((String)prefix, protocolContext);
            urlDefault = Utilities.buildUrl((String)urlDefault, (String)functionParameters);
        }
        try {
            String normalizedActualUri = TokenUtilities.normalizeHtu(urlDefault);
            sbNormalizedActualUri.append(normalizedActualUri);
            if (htu.equals(normalizedActualUri)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("normalizeHtu [" + urlDefault + "] operation failed: " + e.getMessage(), (Throwable)e);
        }
        if (prefixAggiuntivi != null && !prefixAggiuntivi.isEmpty()) {
            if (GestoreTokenValidazioneUtilities.matchUrlInvocataPrefix(prefixAggiuntivi, null, functionParameters, htu, sbNormalizedActualUri, log)) {
                return true;
            }
            if (GestoreTokenValidazioneUtilities.matchUrlInvocataPrefix(prefixAggiuntivi, protocolContext, functionParameters, htu, sbNormalizedActualUri, log)) {
                return true;
            }
        }
        if (baseUrlAggiuntive == null || baseUrlAggiuntive.isEmpty()) {
            return false;
        }
        if (urlDefault != null && !urlDefault.isEmpty()) {
            String contestoInvocato = "";
            String nomeContesto = urlInvocazione.getContext();
            if (nomeContesto.startsWith("/")) {
                nomeContesto = nomeContesto.substring(1);
            }
            if (functionParameters.startsWith(nomeContesto) && functionParameters.length() > nomeContesto.length()) {
                contestoInvocato = functionParameters.substring(nomeContesto.length());
            } else {
                StringBuilder checkUrl = new StringBuilder();
                if (protocolWebContext != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)protocolWebContext)) {
                    checkUrl.append(protocolWebContext);
                    if (!protocolWebContext.endsWith("/")) {
                        checkUrl.append("/");
                    }
                }
                if (function != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)function)) {
                    checkUrl.append(function);
                    if (!function.endsWith("/")) {
                        checkUrl.append("/");
                    }
                }
                if (checkUrl.length() > 0) {
                    checkUrl.append(functionParameters);
                    String newFunctionParameters = checkUrl.toString();
                    if (newFunctionParameters.startsWith(nomeContesto) && newFunctionParameters.length() > nomeContesto.length()) {
                        contestoInvocato = newFunctionParameters.substring(nomeContesto.length());
                    }
                }
            }
            for (String baseUrlNew : baseUrlAggiuntive) {
                String newUrl = Utilities.buildUrl((String)baseUrlNew, (String)contestoInvocato);
                try {
                    String normalizedNewUrl = TokenUtilities.normalizeHtu(newUrl);
                    if (sbNormalizedActualUri.length() > 0) {
                        sbNormalizedActualUri.append(",");
                    }
                    sbNormalizedActualUri.append(normalizedNewUrl);
                    if (!htu.equals(normalizedNewUrl)) continue;
                    return true;
                }
                catch (Exception e) {
                    log.error("normalizeHtu newUrl [" + newUrl + "] failed: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    private static boolean matchUrlInvocataPrefix(List<String> prefixAggiuntivi, String protocolContext, String functionParameters, String htu, StringBuilder sbNormalizedActualUri, Logger log) {
        for (String prefixNew : prefixAggiuntivi) {
            String urlPrefixNew = null;
            if (protocolContext == null) {
                urlPrefixNew = Utilities.buildUrl((String)prefixNew, (String)functionParameters);
            } else {
                urlPrefixNew = Utilities.buildUrl((String)prefixNew, (String)protocolContext);
                urlPrefixNew = Utilities.buildUrl((String)urlPrefixNew, (String)functionParameters);
            }
            try {
                String normalizedActualUri = TokenUtilities.normalizeHtu(urlPrefixNew);
                if (sbNormalizedActualUri.length() > 0) {
                    sbNormalizedActualUri.append(",");
                }
                sbNormalizedActualUri.append(normalizedActualUri);
                if (!htu.equals(normalizedActualUri)) continue;
                return true;
            }
            catch (Exception e) {
                log.error("normalizeHtu (prefix) [" + urlPrefixNew + "] failed: " + e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private static void validazioneDPoPAth(DPoP dpop, IDPoPParser dpopParser, String accessToken) throws TokenException {
        String ath = dpopParser.getAccessTokenHash();
        if (ath == null || ath.trim().isEmpty()) {
            throw new TokenException("Invalid DPoP token: claim 'ath' is missing");
        }
        dpop.setAth(ath);
        String computedAth = GestoreTokenNegoziazioneUtilities.computeAccessTokenHash(accessToken);
        if (!ath.equals(computedAth)) {
            throw new TokenException("Invalid DPoP token: claim 'ath' does not match SHA-256 hash of the access token");
        }
    }

    private static void validazioneDPoPIat(DPoP dpop, IDPoPParser dpopParser, PolicyGestioneToken policyGestioneToken) throws TokenException {
        Date iat = dpopParser.getIssuedAt();
        if (iat == null) {
            throw new TokenException("Invalid DPoP token: claim 'iat' is missing");
        }
        dpop.setIat(iat);
        Date now = DateManager.getDate();
        long iatTime = iat.getTime();
        long nowTime = now.getTime();
        long futureToleranceMs = OpenSPCoop2Properties.getInstance().getGestioneTokenDPoPIatFutureToleranceMilliseconds();
        if (iatTime > nowTime + futureToleranceMs) {
            throw new TokenException("Invalid DPoP token: claim 'iat' is in the future (" + DateUtils.getSimpleDateFormatMs().format(iat) + ", future tolerance: " + futureToleranceMs + "ms)");
        }
        Integer ttlSeconds = policyGestioneToken.getValidazioneDPoPPayloadTtl();
        if (ttlSeconds != null && ttlSeconds > 0) {
            long toleranceMs = OpenSPCoop2Properties.getInstance().getGestioneTokenDPoPIatToleranceMilliseconds();
            long expirationTime = iatTime + (long)ttlSeconds.intValue() * 1000L + toleranceMs;
            if (nowTime > expirationTime) {
                throw new TokenException("Expired DPoP token (iat:" + DateUtils.getSimpleDateFormatMs().format(iat) + "), TTL:" + ttlSeconds + "s, tolerance:" + toleranceMs + "ms)");
            }
        }
    }

    private static void validazioneDPoPJti(DPoP dpop, IDPoPParser dpopParser, PolicyGestioneToken policyGestioneToken, AbstractDatiInvocazione datiInvocazione, PdDContext pddContext, Logger log) throws TokenException, UtilsException {
        String jti = dpopParser.getJWTIdentifier();
        if (jti == null || jti.trim().isEmpty()) {
            throw new TokenException("Invalid DPoP token: claim 'jti' is missing");
        }
        dpop.setJti(jti);
        IJtiValidator validator = null;
        try {
            validator = JtiValidatorFactory.createValidator(policyGestioneToken);
        }
        catch (Exception e) {
            throw new TokenException("DPoP JTI validation failed: " + e.getMessage(), e);
        }
        if (!validator.isAvailable()) {
            log.error("JTI validator not available for policy [{}]", (Object)policyGestioneToken.getName());
            throw new UtilsException("DPoP JTI validation failed: validator not available");
        }
        Integer ttlSeconds = policyGestioneToken.getValidazioneDPoPPayloadTtl();
        long toleranceMs = OpenSPCoop2Properties.getInstance().getGestioneTokenDPoPIatToleranceMilliseconds();
        long toleranceTotal = (ttlSeconds != null ? (long)ttlSeconds.intValue() * 1000L : 0L) + toleranceMs;
        String jtiForValidation = GestoreTokenValidazioneUtilities.getJtiForValidation(jti, datiInvocazione, pddContext);
        try {
            validator.validateAndStore(policyGestioneToken.getName(), jtiForValidation, dpopParser, toleranceTotal);
            log.debug("DPoP JTI [{}] validated successfully for policy [{}]", (Object)jti, (Object)policyGestioneToken.getName());
        }
        catch (TokenException e) {
            throw new TokenException("DPoP JTI validation failed: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new UtilsException("DPoP JTI validation error: " + e.getMessage(), (Throwable)e);
        }
    }

    private static String getJtiForValidation(String jti, AbstractDatiInvocazione datiInvocazione, PdDContext pddContext) throws UtilsException {
        try {
            String idTransazione;
            List<Proprieta> listProprieta = GestoreTokenValidazioneUtilities.readProprieta(datiInvocazione);
            if (listProprieta != null && !listProprieta.isEmpty() && CostantiProprieta.isFiltroDuplicatiDpopTestEnabled(listProprieta, false) && (idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, pddContext)) != null && !idTransazione.isEmpty()) {
                return idTransazione;
            }
        }
        catch (Exception e) {
            throw new UtilsException("Error reading DPoP JTI test properties from API configuration: " + e.getMessage(), (Throwable)e);
        }
        return jti;
    }

    private static void validazioneDPoPCnfJkt(DPoP dpop, IDPoPParser dpopParser, EsitoGestioneToken esitoGestioneToken, Logger log) throws TokenException {
        InformazioniToken informazioniToken = esitoGestioneToken.getInformazioniToken();
        if (informazioniToken == null || informazioniToken.getClaims() == null) {
            throw new TokenException("Invalid DPoP token: cannot verify 'cnf.jkt', access token does not contain claims");
        }
        Serializable cnfObj = informazioniToken.getClaims().get("cnf.jkt");
        String jktFromAccessToken = null;
        if (!(cnfObj instanceof String)) {
            throw new TokenException("Invalid DPoP token: access token does not contain claim 'cnf'");
        }
        jktFromAccessToken = (String)((Object)cnfObj);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)jktFromAccessToken)) {
            throw new TokenException("Invalid DPoP token: access token claim 'cnf' does not contain 'jkt'");
        }
        JsonWebKey dpopJwk = null;
        try {
            dpopJwk = dpopParser.getJsonWebKey();
        }
        catch (Exception e) {
            throw new TokenException("Invalid DPoP token: cannot compute thumbprint, jwk invalid: " + e.getMessage(), e);
        }
        if (dpopJwk == null) {
            throw new TokenException("Invalid DPoP token: cannot compute thumbprint, jwk not present");
        }
        String computedThumbprint = TokenUtilities.computeJwkThumbprint(dpopJwk);
        dpop.setJwkThumbprint(computedThumbprint);
        if (!jktFromAccessToken.equals(computedThumbprint)) {
            throw new TokenException("Invalid DPoP token: thumbprint 'jkt' from access token (" + jktFromAccessToken + ") does not match computed thumbprint of DPoP jwk (" + computedThumbprint + ")");
        }
        String msg = "Validation cnf.jkt completed successfully (thumbprint: " + computedThumbprint + ")";
        log.debug(msg);
    }

    static boolean deleteTokenReceived(AbstractDatiInvocazione datiInvocazione, EsitoPresenzaToken esitoPresenzaToken, boolean trasparente, String forwardTrasparenteModeHeader, String forwardTrasparenteModeUrl) throws TokenException {
        PolicyGestioneToken policyGestioneToken = datiInvocazione.getPolicyGestioneToken();
        boolean remove = false;
        if (esitoPresenzaToken.getHeaderHttp() != null) {
            if (!(policyGestioneToken.isForwardToken() && trasparente && esitoPresenzaToken.getHeaderHttp().equalsIgnoreCase(forwardTrasparenteModeHeader))) {
                remove = true;
            }
            if (remove) {
                datiInvocazione.getMessage().getTransportRequestContext().removeHeader(esitoPresenzaToken.getHeaderHttp());
            }
        } else if (esitoPresenzaToken.getPropertyUrl() != null) {
            if (!(policyGestioneToken.isForwardToken() && trasparente && esitoPresenzaToken.getPropertyUrl().equals(forwardTrasparenteModeUrl))) {
                remove = true;
            }
            if (remove) {
                datiInvocazione.getMessage().getTransportRequestContext().removeParameter(esitoPresenzaToken.getPropertyUrl());
            }
        } else if (esitoPresenzaToken.getPropertyFormBased() != null) {
            if (!policyGestioneToken.isForwardToken() || !trasparente) {
                remove = true;
            }
            if (remove) {
                try {
                    byte[] contenuto = ((BinaryContent)datiInvocazione.getMessage().castAsRestBinary().getContent()).getContent();
                    String contenutoAsString = new String(contenuto);
                    String[] split = contenutoAsString.split("&");
                    StringBuilder bf = new StringBuilder();
                    for (int i = 0; i < split.length; ++i) {
                        String nameValue = split[i];
                        if (nameValue.contains("=")) {
                            String[] tmp = nameValue.split("=");
                            String name = tmp[0];
                            String value = tmp[1];
                            if (esitoPresenzaToken.getPropertyFormBased().equals(name)) continue;
                            bf.append(name).append("=").append(value);
                            continue;
                        }
                        if (bf.length() > 0) {
                            bf.append("&");
                        }
                        bf.append(nameValue);
                    }
                    if (bf.length() > 0) {
                        byte[] newContenuto = bf.toString().getBytes();
                        ((OpenSPCoop2Message_binary_impl)datiInvocazione.getMessage().castAsRestBinary()).updateContent(newContenuto);
                    } else {
                        datiInvocazione.getMessage().castAsRestBinary().updateContent(null);
                    }
                }
                catch (Exception e) {
                    throw new TokenException(e.getMessage(), e);
                }
            }
        }
        return remove;
    }

    static void forwardTokenTrasparenteEngine(String token, EsitoPresenzaToken esitoPresenzaToken, TokenForward tokenForward, String forwardTrasparenteMode, String forwardTrasparenteModeHeader, String forwardTrasparenteModeUrl) throws TokenException {
        if ("asReceived".equals(forwardTrasparenteMode)) {
            if (esitoPresenzaToken.getHeaderHttp() != null) {
                if ("Authorization".equals(esitoPresenzaToken.getHeaderHttp())) {
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)"Authorization", (String)("Bearer " + token));
                } else {
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)esitoPresenzaToken.getHeaderHttp(), (String)token);
                }
            } else if (esitoPresenzaToken.getPropertyUrl() != null) {
                TransportUtils.setParameter(tokenForward.getUrl(), (String)esitoPresenzaToken.getPropertyUrl(), (String)token);
            } else if (esitoPresenzaToken.getPropertyFormBased() != null) {
                throw new TokenException("Configurazione non supportata");
            }
        } else if ("RFC6750_header".equals(forwardTrasparenteMode)) {
            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)"Authorization", (String)("Bearer " + token));
        } else if ("RFC6750_url".equals(forwardTrasparenteMode)) {
            TransportUtils.setParameter(tokenForward.getUrl(), (String)"access_token", (String)token);
        } else if ("CUSTOM_header".equals(forwardTrasparenteMode)) {
            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)forwardTrasparenteModeHeader, (String)token);
        } else if ("CUSTOM_url".equals(forwardTrasparenteMode)) {
            TransportUtils.setParameter(tokenForward.getUrl(), (String)forwardTrasparenteModeUrl, (String)token);
        }
    }

    static boolean deleteDPoPReceived(AbstractDatiInvocazione datiInvocazione, EsitoPresenzaDPoP esitoPresenzaDPoP, boolean forwardDPoP, String forwardDPoPModeHeader, String forwardDPoPModeUrl) throws TokenException {
        PolicyGestioneToken policyGestioneToken = datiInvocazione.getPolicyGestioneToken();
        boolean remove = false;
        if (esitoPresenzaDPoP.getHeaderHttp() != null) {
            if (!(policyGestioneToken.isForwardToken() && forwardDPoP && esitoPresenzaDPoP.getHeaderHttp().equalsIgnoreCase(forwardDPoPModeHeader))) {
                remove = true;
            }
            if (remove) {
                datiInvocazione.getMessage().getTransportRequestContext().removeHeader(esitoPresenzaDPoP.getHeaderHttp());
            }
        } else if (esitoPresenzaDPoP.getPropertyUrl() != null) {
            if (!(policyGestioneToken.isForwardToken() && forwardDPoP && esitoPresenzaDPoP.getPropertyUrl().equals(forwardDPoPModeUrl))) {
                remove = true;
            }
            if (remove) {
                datiInvocazione.getMessage().getTransportRequestContext().removeParameter(esitoPresenzaDPoP.getPropertyUrl());
            }
        }
        return remove;
    }

    static void forwardDPoPTrasparenteEngine(String dpopToken, EsitoPresenzaDPoP esitoPresenzaDPoP, TokenForward tokenForward, String forwardDPoPMode, String forwardDPoPModeHeader, String forwardDPoPModeUrl) throws TokenException {
        if ("asReceived".equals(forwardDPoPMode)) {
            if (esitoPresenzaDPoP.getHeaderHttp() != null) {
                TransportUtils.setHeader(tokenForward.getTrasporto(), (String)esitoPresenzaDPoP.getHeaderHttp(), (String)dpopToken);
            } else if (esitoPresenzaDPoP.getPropertyUrl() != null) {
                TransportUtils.setParameter(tokenForward.getUrl(), (String)esitoPresenzaDPoP.getPropertyUrl(), (String)dpopToken);
            }
        } else if ("RFC9449_header".equals(forwardDPoPMode)) {
            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)"DPoP", (String)dpopToken);
        } else if ("CUSTOM_header".equals(forwardDPoPMode)) {
            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)forwardDPoPModeHeader, (String)dpopToken);
        } else if ("CUSTOM_url".equals(forwardDPoPMode)) {
            TransportUtils.setParameter(tokenForward.getUrl(), (String)forwardDPoPModeUrl, (String)dpopToken);
        }
    }

    static void forwardInfomazioniRaccolteEngine(boolean portaDelegata, String idTransazione, TokenForward tokenForward, EsitoGestioneToken esitoValidazioneJWT, EsitoGestioneToken esitoIntrospection, EsitoGestioneToken esitoUserInfo, InformazioniToken informazioniTokenNormalizzate, String forwardInforRaccolteMode, Properties jwtSecurity, boolean encodeBase64, boolean forwardValidazioneJWT, String forwardValidazioneJWTMode, String forwardValidazioneJWTName, boolean forwardIntrospection, String forwardIntrospectionMode, String forwardIntrospectionName, boolean forwardUserInfo, String forwardUserInfoMode, String forwardUserInfoName) throws CoreException, UtilsException {
        if (informazioniTokenNormalizzate == null) {
            return;
        }
        if ("op2header".equals(forwardInforRaccolteMode) || "op2json".equals(forwardInforRaccolteMode) || "op2jws".equals(forwardInforRaccolteMode)) {
            List<String> listCustomClaims;
            Object value;
            StringBuilder bf;
            ArrayNode array;
            OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
            Map<String, String> headerNames = null;
            Map<String, Boolean> set = null;
            JSONUtils jsonUtils = null;
            ObjectNode jsonNode = null;
            boolean op2headers = "op2header".equals(forwardInforRaccolteMode);
            DateTimeFormatterWrapper sdf = null;
            if (op2headers) {
                headerNames = properties.getKeyValueGestioneTokenHeaderIntegrazioneTrasporto();
                set = portaDelegata ? properties.getKeyPDSetEnabledGestioneTokenHeaderIntegrazioneTrasporto() : properties.getKeyPASetEnabledGestioneTokenHeaderIntegrazioneTrasporto();
                String pattern = properties.getGestioneTokenFormatDate();
                if (pattern != null && !"".equals(pattern)) {
                    sdf = DateUtils.getDefaultDateTimeFormatter((String)pattern);
                }
            } else {
                set = portaDelegata ? properties.getKeyPDSetEnabledGestioneTokenHeaderIntegrazioneJson() : properties.getKeyPASetEnabledGestioneTokenHeaderIntegrazioneJson();
                jsonUtils = JSONUtils.getInstance();
                jsonNode = jsonUtils.newObjectNode();
                jsonNode.put("id", idTransazione);
            }
            if (informazioniTokenNormalizzate.getIss() != null && set.get("issuer").booleanValue()) {
                if (op2headers) {
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("issuer"), (String)informazioniTokenNormalizzate.getIss());
                } else {
                    jsonNode.put("issuer", informazioniTokenNormalizzate.getIss());
                }
            }
            if (informazioniTokenNormalizzate.getSub() != null && set.get("subject").booleanValue()) {
                if (op2headers) {
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("subject"), (String)informazioniTokenNormalizzate.getSub());
                } else {
                    jsonNode.put("subject", informazioniTokenNormalizzate.getSub());
                }
            }
            if (informazioniTokenNormalizzate.getUsername() != null && set.get("username").booleanValue()) {
                if (op2headers) {
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("username"), (String)informazioniTokenNormalizzate.getUsername());
                } else {
                    jsonNode.put("username", informazioniTokenNormalizzate.getUsername());
                }
            }
            if (informazioniTokenNormalizzate.getAud() != null && set.get("audience").booleanValue()) {
                array = null;
                bf = new StringBuilder();
                if (!op2headers) {
                    array = jsonUtils.newArrayNode();
                }
                for (String role : informazioniTokenNormalizzate.getAud()) {
                    if (op2headers) {
                        if (bf.length() > 0) {
                            bf.append(properties.getGestioneTokenHeaderIntegrazioneTrasportoAudienceSeparator());
                        }
                        bf.append(role);
                        continue;
                    }
                    array.add(role);
                }
                if (op2headers) {
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("audience"), (String)bf.toString());
                } else {
                    jsonNode.set("audience", (JsonNode)array);
                }
            }
            if (informazioniTokenNormalizzate.getClientId() != null && set.get("clientId").booleanValue()) {
                if (op2headers) {
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("clientId"), (String)informazioniTokenNormalizzate.getClientId());
                } else {
                    jsonNode.put("clientId", informazioniTokenNormalizzate.getClientId());
                }
            }
            if (informazioniTokenNormalizzate.getIat() != null && set.get("issuedAt").booleanValue()) {
                if (op2headers) {
                    value = null;
                    value = sdf != null ? sdf.format(informazioniTokenNormalizzate.getIat()) : "" + informazioniTokenNormalizzate.getIat().getTime() / 1000L;
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("issuedAt"), (String)value);
                } else {
                    jsonNode.put("iat", jsonUtils.getDateFormat().format(informazioniTokenNormalizzate.getIat()));
                }
            }
            if (informazioniTokenNormalizzate.getExp() != null && set.get("expired").booleanValue()) {
                if (op2headers) {
                    value = null;
                    value = sdf != null ? sdf.format(informazioniTokenNormalizzate.getExp()) : "" + informazioniTokenNormalizzate.getExp().getTime() / 1000L;
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("expired"), (String)value);
                } else {
                    jsonNode.put("expire", jsonUtils.getDateFormat().format(informazioniTokenNormalizzate.getExp()));
                }
            }
            if (informazioniTokenNormalizzate.getNbf() != null && set.get("nbf").booleanValue()) {
                if (op2headers) {
                    value = null;
                    value = sdf != null ? sdf.format(informazioniTokenNormalizzate.getNbf()) : "" + informazioniTokenNormalizzate.getNbf().getTime() / 1000L;
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("nbf"), (String)value);
                } else {
                    jsonNode.put("nbf", jsonUtils.getDateFormat().format(informazioniTokenNormalizzate.getNbf()));
                }
            }
            if (informazioniTokenNormalizzate.getRoles() != null && !informazioniTokenNormalizzate.getRoles().isEmpty() && set.get("roles").booleanValue()) {
                array = null;
                bf = new StringBuilder();
                if (!op2headers) {
                    array = jsonUtils.newArrayNode();
                }
                for (String role : informazioniTokenNormalizzate.getRoles()) {
                    if (op2headers) {
                        if (bf.length() > 0) {
                            bf.append(properties.getGestioneTokenHeaderIntegrazioneTrasportoRoleSeparator());
                        }
                        bf.append(role);
                        continue;
                    }
                    array.add(role);
                }
                if (op2headers) {
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("roles"), (String)bf.toString());
                } else {
                    jsonNode.set("roles", (JsonNode)array);
                }
            }
            if (informazioniTokenNormalizzate.getScopes() != null && !informazioniTokenNormalizzate.getScopes().isEmpty() && set.get("scopes").booleanValue()) {
                array = null;
                bf = new StringBuilder();
                if (!op2headers) {
                    array = jsonUtils.newArrayNode();
                }
                for (String scope : informazioniTokenNormalizzate.getScopes()) {
                    if (op2headers) {
                        if (bf.length() > 0) {
                            bf.append(properties.getGestioneTokenHeaderIntegrazioneTrasportoScopeSeparator());
                        }
                        bf.append(scope);
                        continue;
                    }
                    array.add(scope);
                }
                if (op2headers) {
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("scopes"), (String)bf.toString());
                } else {
                    jsonNode.set("scopes", (JsonNode)array);
                }
            }
            if (informazioniTokenNormalizzate.getUserInfo() != null) {
                ObjectNode userInfoNode = null;
                if (!op2headers) {
                    userInfoNode = jsonUtils.newObjectNode();
                }
                boolean add = false;
                if (informazioniTokenNormalizzate.getUserInfo().getFullName() != null && set.get("fullName").booleanValue()) {
                    if (op2headers) {
                        TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("fullName"), (String)informazioniTokenNormalizzate.getUserInfo().getFullName());
                    } else {
                        userInfoNode.put("fullName", informazioniTokenNormalizzate.getUserInfo().getFullName());
                        add = true;
                    }
                }
                if (informazioniTokenNormalizzate.getUserInfo().getFirstName() != null && set.get("firstName").booleanValue()) {
                    if (op2headers) {
                        TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("firstName"), (String)informazioniTokenNormalizzate.getUserInfo().getFirstName());
                    } else {
                        userInfoNode.put("firstName", informazioniTokenNormalizzate.getUserInfo().getFirstName());
                        add = true;
                    }
                }
                if (informazioniTokenNormalizzate.getUserInfo().getMiddleName() != null && set.get("middleName").booleanValue()) {
                    if (op2headers) {
                        TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("middleName"), (String)informazioniTokenNormalizzate.getUserInfo().getMiddleName());
                    } else {
                        userInfoNode.put("middleName", informazioniTokenNormalizzate.getUserInfo().getMiddleName());
                        add = true;
                    }
                }
                if (informazioniTokenNormalizzate.getUserInfo().getFamilyName() != null && set.get("familyName").booleanValue()) {
                    if (op2headers) {
                        TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("familyName"), (String)informazioniTokenNormalizzate.getUserInfo().getFamilyName());
                    } else {
                        userInfoNode.put("familyName", informazioniTokenNormalizzate.getUserInfo().getFamilyName());
                        add = true;
                    }
                }
                if (informazioniTokenNormalizzate.getUserInfo().getEMail() != null && set.get("email").booleanValue()) {
                    if (op2headers) {
                        TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("email"), (String)informazioniTokenNormalizzate.getUserInfo().getEMail());
                    } else {
                        userInfoNode.put("eMail", informazioniTokenNormalizzate.getUserInfo().getEMail());
                        add = true;
                    }
                }
                if (!op2headers && add) {
                    jsonNode.set("userInfo", (JsonNode)userInfoNode);
                }
            }
            if (informazioniTokenNormalizzate.getClaims() != null && !informazioniTokenNormalizzate.getClaims().isEmpty()) {
                Serializable oPid;
                if (informazioniTokenNormalizzate.getClaims().containsKey("jti") && (oPid = informazioniTokenNormalizzate.getClaims().get("jti")) instanceof String) {
                    String pId = (String)((Object)oPid);
                    if (set.get("jti").booleanValue()) {
                        if (op2headers) {
                            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("jti"), (String)pId);
                        } else {
                            jsonNode.put("jti", pId);
                        }
                    }
                }
                if (informazioniTokenNormalizzate.getClaims().containsKey("purposeId") && (oPid = informazioniTokenNormalizzate.getClaims().get("purposeId")) instanceof String) {
                    String pId = (String)((Object)oPid);
                    if (set.get("purposeId").booleanValue()) {
                        if (op2headers) {
                            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("purposeId"), (String)pId);
                        } else {
                            jsonNode.put("purposeId", pId);
                        }
                    }
                }
                if (informazioniTokenNormalizzate.getClaims().containsKey("consumerId") && (oPid = informazioniTokenNormalizzate.getClaims().get("consumerId")) instanceof String) {
                    String pId = (String)((Object)oPid);
                    if (set.get("consumerId").booleanValue()) {
                        if (op2headers) {
                            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("consumerId"), (String)pId);
                        } else {
                            jsonNode.put("consumerId", pId);
                        }
                    }
                }
                if (informazioniTokenNormalizzate.getClaims().containsKey("producerId") && (oPid = informazioniTokenNormalizzate.getClaims().get("producerId")) instanceof String) {
                    String pId = (String)((Object)oPid);
                    if (set.get("producerId").booleanValue()) {
                        if (op2headers) {
                            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("producerId"), (String)pId);
                        } else {
                            jsonNode.put("producerId", pId);
                        }
                    }
                }
                if (informazioniTokenNormalizzate.getClaims().containsKey("eserviceId") && (oPid = informazioniTokenNormalizzate.getClaims().get("eserviceId")) instanceof String) {
                    String pId = (String)((Object)oPid);
                    if (set.get("eserviceId").booleanValue()) {
                        if (op2headers) {
                            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("eserviceId"), (String)pId);
                        } else {
                            jsonNode.put("eserviceId", pId);
                        }
                    }
                }
                if (informazioniTokenNormalizzate.getClaims().containsKey("descriptorId") && (oPid = informazioniTokenNormalizzate.getClaims().get("descriptorId")) instanceof String) {
                    String pId = (String)((Object)oPid);
                    if (set.get("descriptorId").booleanValue()) {
                        if (op2headers) {
                            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("descriptorId"), (String)pId);
                        } else {
                            jsonNode.put("descriptorId", pId);
                        }
                    }
                }
                if (informazioniTokenNormalizzate.getPdnd() != null && !informazioniTokenNormalizzate.getPdnd().isEmpty()) {
                    String clientDescription;
                    String organizationExternal;
                    String organizationSubUnit;
                    String organizationCategory;
                    ObjectNode pdndNode = null;
                    ObjectNode organizationNode = null;
                    ObjectNode clientNode = null;
                    if (!op2headers) {
                        pdndNode = jsonUtils.newObjectNode();
                        organizationNode = jsonUtils.newObjectNode();
                        clientNode = jsonUtils.newObjectNode();
                    }
                    boolean addOrganization = false;
                    String organizationName = PDNDTokenInfo.readOrganizationNameFromPDNDMap(informazioniTokenNormalizzate.getPdnd());
                    if (organizationName != null && StringUtils.isNotEmpty((String)organizationName) && set.get("pdndOrganizationName").booleanValue()) {
                        if (op2headers) {
                            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("pdndOrganizationName"), (String)organizationName);
                        } else {
                            organizationNode.put("name", organizationName);
                            addOrganization = true;
                        }
                    }
                    if ((organizationCategory = PDNDTokenInfo.readOrganizationCategoryFromPDNDMap(informazioniTokenNormalizzate.getPdnd())) != null && StringUtils.isNotEmpty((String)organizationCategory) && set.get("pdndOrganizationCategory").booleanValue()) {
                        if (op2headers) {
                            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("pdndOrganizationCategory"), (String)organizationCategory);
                        } else {
                            organizationNode.put("category", organizationCategory);
                            addOrganization = true;
                        }
                    }
                    if ((organizationSubUnit = PDNDTokenInfo.readOrganizationSubUnitFromPDNDMap(informazioniTokenNormalizzate.getPdnd())) != null && StringUtils.isNotEmpty((String)organizationSubUnit) && set.get("pdndOrganizationSubUnit").booleanValue()) {
                        if (op2headers) {
                            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("pdndOrganizationSubUnit"), (String)organizationSubUnit);
                        } else {
                            organizationNode.put("subUnit", organizationSubUnit);
                            addOrganization = true;
                        }
                    }
                    String organizationExternalOrigin = PDNDTokenInfo.readOrganizationExternalOriginFromPDNDMap(informazioniTokenNormalizzate.getPdnd());
                    String organizationExternalId = PDNDTokenInfo.readOrganizationExternalIdFromPDNDMap(informazioniTokenNormalizzate.getPdnd());
                    StringBuilder sbOrganizationExternal = new StringBuilder();
                    if (organizationExternalOrigin != null && StringUtils.isNotEmpty((String)organizationExternalOrigin)) {
                        sbOrganizationExternal.append(organizationExternalOrigin);
                        if (set.get("pdndOrganizationExternalOrigin").booleanValue()) {
                            if (op2headers) {
                                TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("pdndOrganizationExternalOrigin"), (String)organizationExternalOrigin);
                            } else {
                                organizationNode.put("externalOrigin", organizationExternalOrigin);
                                addOrganization = true;
                            }
                        }
                    }
                    if (organizationExternalId != null && StringUtils.isNotEmpty((String)organizationExternalId)) {
                        if (sbOrganizationExternal.length() > 0) {
                            sbOrganizationExternal.append(" ");
                        }
                        sbOrganizationExternal.append(organizationExternalId);
                        if (set.get("pdndOrganizationExternalId").booleanValue()) {
                            if (op2headers) {
                                TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("pdndOrganizationExternalId"), (String)organizationExternalId);
                            } else {
                                organizationNode.put("externalId", organizationExternalId);
                                addOrganization = true;
                            }
                        }
                    }
                    if ((organizationExternal = sbOrganizationExternal.toString()) != null && StringUtils.isNotEmpty((String)organizationExternal) && set.get("pdndOrganizationExternal").booleanValue()) {
                        if (op2headers) {
                            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("pdndOrganizationExternal"), (String)organizationExternal);
                        } else {
                            organizationNode.put("external", organizationExternal);
                            addOrganization = true;
                        }
                    }
                    boolean addClient = false;
                    String clientName = PDNDTokenInfo.readClientNameFromPDNDMap(informazioniTokenNormalizzate.getPdnd());
                    if (clientName != null && StringUtils.isNotEmpty((String)clientName) && set.get("pdndClientName").booleanValue()) {
                        if (op2headers) {
                            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("pdndClientName"), (String)clientName);
                        } else {
                            clientNode.put("name", clientName);
                            addClient = true;
                        }
                    }
                    if ((clientDescription = PDNDTokenInfo.readClientDescriptionFromPDNDMap(informazioniTokenNormalizzate.getPdnd())) != null && StringUtils.isNotEmpty((String)clientDescription) && set.get("pdndClientDescription").booleanValue()) {
                        if (op2headers) {
                            TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("pdndClientDescription"), (String)clientDescription);
                        } else {
                            clientNode.put("description", clientDescription);
                            addClient = true;
                        }
                    }
                    if (!op2headers && (addOrganization || addClient)) {
                        if (addOrganization) {
                            pdndNode.set("organization", (JsonNode)organizationNode);
                        }
                        if (addClient) {
                            pdndNode.set("client", (JsonNode)clientNode);
                        }
                        jsonNode.set("pdnd", (JsonNode)pdndNode);
                    }
                }
            }
            if ((listCustomClaims = properties.getCustomClaimsKeysGestioneTokenForward()) != null && !listCustomClaims.isEmpty()) {
                ArrayNode customClaimsNode = null;
                if (!op2headers) {
                    customClaimsNode = jsonUtils.newArrayNode();
                }
                boolean add = false;
                for (String claimKey : listCustomClaims) {
                    String claimName = properties.getCustomClaimsNameGestioneTokenHeaderIntegrazione(claimKey);
                    if (informazioniTokenNormalizzate.getClaims() == null || !informazioniTokenNormalizzate.getClaims().containsKey(claimName)) continue;
                    Serializable claimValueObject = informazioniTokenNormalizzate.getClaims().get(claimName);
                    List<String> claimValues = null;
                    if (claimValueObject != null) {
                        claimValues = TokenUtilities.getClaimValues(claimValueObject);
                    }
                    String headerName = null;
                    if (claimValues == null || claimValues.isEmpty()) continue;
                    boolean setCustomClaims = false;
                    if (op2headers) {
                        headerName = properties.getCustomClaimsHeaderNameGestioneTokenHeaderIntegrazioneTrasporto(claimKey);
                        setCustomClaims = portaDelegata ? properties.getCustomClaimsKeyPDSetEnabledGestioneTokenHeaderIntegrazioneTrasporto(claimKey).booleanValue() : properties.getCustomClaimsKeyPASetEnabledGestioneTokenHeaderIntegrazioneTrasporto(claimKey).booleanValue();
                    } else {
                        headerName = properties.getCustomClaimsJsonPropertyNameGestioneTokenHeaderIntegrazioneJson(claimKey);
                        setCustomClaims = portaDelegata ? properties.getCustomClaimsKeyPDSetEnabledGestioneTokenHeaderIntegrazioneJson(claimKey).booleanValue() : properties.getCustomClaimsKeyPASetEnabledGestioneTokenHeaderIntegrazioneJson(claimKey).booleanValue();
                    }
                    if (!setCustomClaims) continue;
                    String claimValue = TokenUtilities.getClaimValuesAsString(claimValues);
                    if (op2headers) {
                        TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerName, (String)claimValue);
                        continue;
                    }
                    ObjectNode propertyNode = jsonUtils.newObjectNode();
                    propertyNode.put("name", headerName);
                    propertyNode.put("value", claimValue);
                    customClaimsNode.add((JsonNode)propertyNode);
                    add = true;
                }
                if (!op2headers && add) {
                    jsonNode.set("claims", (JsonNode)customClaimsNode);
                }
            }
            Date processTime = DateManager.getDate();
            if (set.get("processTime").booleanValue()) {
                if (op2headers) {
                    Object value2 = null;
                    value2 = sdf != null ? sdf.format(processTime) : "" + processTime.getTime() / 1000L;
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerNames.get("processTime"), (String)value2);
                } else {
                    jsonNode.put("processTime", jsonUtils.getDateFormat().format(processTime));
                }
            }
            if (!op2headers) {
                String json = jsonUtils.toString((JsonNode)jsonNode);
                if ("op2json".equals(forwardInforRaccolteMode)) {
                    String headerName = properties.getGestioneTokenHeaderTrasportoJSON();
                    if (encodeBase64) {
                        TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerName, (String)Base64Utilities.encodeAsString((byte[])json.getBytes()));
                    } else {
                        TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerName, (String)json);
                    }
                } else {
                    JWSOptions jwsOptions = new JWSOptions(JOSESerialization.COMPACT);
                    JsonSignature jsonCompactSignature = new JsonSignature(jwtSecurity, jwsOptions);
                    String compact = jsonCompactSignature.sign(json);
                    String headerName = properties.getGestioneTokenHeaderTrasportoJWT();
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)headerName, (String)compact);
                }
            }
        } else {
            JsonEncrypt jsonCompactEncrypt;
            JWEOptions jweOptions;
            JsonSignature jsonCompactSignature;
            JWSOptions jwsOptions;
            String value;
            if (forwardValidazioneJWT && esitoValidazioneJWT != null && esitoValidazioneJWT.isValido() && esitoValidazioneJWT.getInformazioniToken() != null && esitoValidazioneJWT.getInformazioniToken().getRawResponse() != null) {
                value = esitoValidazioneJWT.getInformazioniToken().getRawResponse();
                if ("jws".equals(forwardInforRaccolteMode)) {
                    jwsOptions = new JWSOptions(JOSESerialization.COMPACT);
                    jsonCompactSignature = new JsonSignature(jwtSecurity, jwsOptions);
                    value = jsonCompactSignature.sign(value);
                } else if ("jwe".equals(forwardInforRaccolteMode)) {
                    jweOptions = new JWEOptions(JOSESerialization.COMPACT);
                    jsonCompactEncrypt = new JsonEncrypt(jwtSecurity, jweOptions);
                    value = jsonCompactEncrypt.encrypt(value);
                } else if (encodeBase64) {
                    value = Base64Utilities.encodeAsString((byte[])value.getBytes());
                }
                if ("CUSTOM_header".equals(forwardValidazioneJWTMode)) {
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)forwardValidazioneJWTName, (String)value);
                } else {
                    TransportUtils.setParameter(tokenForward.getUrl(), (String)forwardValidazioneJWTName, (String)value);
                }
            }
            if (forwardIntrospection && esitoIntrospection != null && esitoIntrospection.isValido() && esitoIntrospection.getInformazioniToken() != null && esitoIntrospection.getInformazioniToken().getRawResponse() != null) {
                value = esitoIntrospection.getInformazioniToken().getRawResponse();
                if ("jws".equals(forwardInforRaccolteMode)) {
                    jwsOptions = new JWSOptions(JOSESerialization.COMPACT);
                    jsonCompactSignature = new JsonSignature(jwtSecurity, jwsOptions);
                    value = jsonCompactSignature.sign(value);
                } else if ("jwe".equals(forwardInforRaccolteMode)) {
                    jweOptions = new JWEOptions(JOSESerialization.COMPACT);
                    jsonCompactEncrypt = new JsonEncrypt(jwtSecurity, jweOptions);
                    value = jsonCompactEncrypt.encrypt(value);
                } else if (encodeBase64) {
                    value = Base64Utilities.encodeAsString((byte[])value.getBytes());
                }
                if ("CUSTOM_header".equals(forwardIntrospectionMode)) {
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)forwardIntrospectionName, (String)value);
                } else {
                    TransportUtils.setParameter(tokenForward.getUrl(), (String)forwardIntrospectionName, (String)value);
                }
            }
            if (forwardUserInfo && esitoUserInfo != null && esitoUserInfo.isValido() && esitoUserInfo.getInformazioniToken() != null && esitoUserInfo.getInformazioniToken().getRawResponse() != null) {
                value = esitoUserInfo.getInformazioniToken().getRawResponse();
                if ("jws".equals(forwardInforRaccolteMode)) {
                    jwsOptions = new JWSOptions(JOSESerialization.COMPACT);
                    jsonCompactSignature = new JsonSignature(jwtSecurity, jwsOptions);
                    value = jsonCompactSignature.sign(value);
                } else if ("jwe".equals(forwardInforRaccolteMode)) {
                    jweOptions = new JWEOptions(JOSESerialization.COMPACT);
                    jsonCompactEncrypt = new JsonEncrypt(jwtSecurity, jweOptions);
                    value = jsonCompactEncrypt.encrypt(value);
                } else if (encodeBase64) {
                    value = Base64Utilities.encodeAsString((byte[])value.getBytes());
                }
                if ("CUSTOM_header".equals(forwardUserInfoMode)) {
                    TransportUtils.setHeader(tokenForward.getTrasporto(), (String)forwardUserInfoName, (String)value);
                } else {
                    TransportUtils.setParameter(tokenForward.getUrl(), (String)forwardUserInfoName, (String)value);
                }
            }
        }
    }

    public static boolean isExpired(Date now, Date exp) throws TokenException {
        Date checkNow = now;
        Long tolerance = null;
        try {
            tolerance = OpenSPCoop2Properties.getInstance().getGestioneTokenExpTimeCheckToleranceMilliseconds();
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage(), e);
        }
        if (tolerance != null && tolerance > 0L) {
            checkNow = new Date(now.getTime() - tolerance);
        }
        return !checkNow.before(exp);
    }

    public static boolean isFuture(Date now, Date nbf) throws TokenException {
        Date checkNow = now;
        Long tolerance = null;
        try {
            tolerance = OpenSPCoop2Properties.getInstance().getGestioneTokenNbfTimeCheckToleranceMilliseconds();
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage(), e);
        }
        if (tolerance != null && tolerance > 0L) {
            checkNow = new Date(now.getTime() + tolerance);
        }
        return !nbf.before(checkNow);
    }

    public static boolean isProfiloModIPAEnabled() {
        try {
            Enumeration en = ProtocolFactoryManager.getInstance().getProtocolNames();
            while (en.hasMoreElements()) {
                String protocollo = (String)en.nextElement();
                if (!protocollo.equals("modipa")) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static synchronized void initPolicyGestioneTokenPDND(Logger log) {
        if (policyGestioneTokenPDND == null) {
            try {
                policyGestioneTokenPDND = new ArrayList<String>();
                if (GestoreTokenValidazioneUtilities.isProfiloModIPAEnabled()) {
                    GestoreTokenValidazioneUtilities.initPolicyGestioneTokenPDND();
                }
            }
            catch (Exception e) {
                log.error("Errore di inizializzazione policy 'PDND': " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static synchronized void initPolicyGestioneTokenPDND() throws ProtocolException {
        List listRSC = ModIUtils.getRemoteStoreConfig();
        if (listRSC != null && !listRSC.isEmpty()) {
            for (RemoteStoreConfig r : listRSC) {
                if (policyGestioneTokenPDND.contains(r.getTokenPolicy())) continue;
                policyGestioneTokenPDND.add(r.getTokenPolicy());
            }
        }
    }

    protected static boolean isPdndTokenPolicy(Logger log, String tokenPolicy) {
        if (policyGestioneTokenPDND == null) {
            GestoreTokenValidazioneUtilities.initPolicyGestioneTokenPDND(log);
        }
        return policyGestioneTokenPDND.contains(tokenPolicy);
    }

    private static List<Proprieta> readProprieta(AbstractDatiInvocazione datiInvocazione) throws CoreException {
        try {
            ArrayList<Proprieta> l = new ArrayList<Proprieta>();
            if (datiInvocazione instanceof DatiInvocazionePortaDelegata) {
                DatiInvocazionePortaDelegata d = (DatiInvocazionePortaDelegata)datiInvocazione;
                PortaDelegata pd = d.getPd();
                if (pd == null && d.getIdPD() != null) {
                    ConfigurazionePdDManager configManager = ConfigurazionePdDManager.getInstance(datiInvocazione.getState());
                    pd = configManager.getPortaDelegataSafeMethod(d.getIdPD(), datiInvocazione.getRequestInfo());
                }
                if (pd != null) {
                    return pd.getProprieta();
                }
            } else {
                DatiInvocazionePortaApplicativa d = (DatiInvocazionePortaApplicativa)datiInvocazione;
                PortaApplicativa pa = d.getPa();
                if (pa == null && d.getIdPA() != null) {
                    ConfigurazionePdDManager configManager = ConfigurazionePdDManager.getInstance(datiInvocazione.getState());
                    pa = configManager.getPortaApplicativaSafeMethod(d.getIdPA(), datiInvocazione.getRequestInfo());
                }
                if (pa != null) {
                    return pa.getProprieta();
                }
            }
            return l;
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    static Long getIatTimeCheckMilliseconds(Logger log, OpenSPCoop2Properties op2Properties, List<Proprieta> props) throws CoreException {
        Long defaultValue = op2Properties.getGestioneTokenIatTimeCheckMilliseconds();
        try {
            return CostantiProprieta.getTokenValidationIatMaxAgeMilliseconds(props, defaultValue);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    static boolean isIatRequired(Logger log, PolicyGestioneToken policyGestioneToken, AbstractDatiInvocazione datiInvocazione, IProtocolFactory<?> protocollo, OpenSPCoop2Properties op2Properties, List<Proprieta> props) throws CoreException {
        String p = protocollo != null ? protocollo.getProtocol() : "";
        boolean delegata = datiInvocazione instanceof DatiInvocazionePortaDelegata;
        boolean required = op2Properties.isGestioneTokenIatRequired();
        BooleanNullable bn = op2Properties.isGestioneTokenIatRequired(delegata, p);
        if (bn != null && bn.getValue() != null) {
            required = bn.getValue();
        }
        if (!delegata && GestoreTokenValidazioneUtilities.isPdndTokenPolicy(log, policyGestioneToken.getName()) && (bn = op2Properties.isGestioneTokenIatPdndRequired()) != null && bn.getValue() != null) {
            required = bn.getValue();
        }
        try {
            return CostantiProprieta.isTokenValidationClaimsIatRequired(props, required);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    static boolean isExpRequired(Logger log, PolicyGestioneToken policyGestioneToken, AbstractDatiInvocazione datiInvocazione, IProtocolFactory<?> protocollo, OpenSPCoop2Properties op2Properties, List<Proprieta> props) throws CoreException {
        String p = protocollo != null ? protocollo.getProtocol() : "";
        boolean delegata = datiInvocazione instanceof DatiInvocazionePortaDelegata;
        boolean required = op2Properties.isGestioneTokenExpRequired();
        BooleanNullable bn = op2Properties.isGestioneTokenExpRequired(delegata, p);
        if (bn != null && bn.getValue() != null) {
            required = bn.getValue();
        }
        if (!delegata && GestoreTokenValidazioneUtilities.isPdndTokenPolicy(log, policyGestioneToken.getName()) && (bn = op2Properties.isGestioneTokenExpPdndRequired()) != null && bn.getValue() != null) {
            required = bn.getValue();
        }
        try {
            return CostantiProprieta.isTokenValidationClaimsExpRequired(props, required);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    static boolean isNbfRequired(Logger log, PolicyGestioneToken policyGestioneToken, AbstractDatiInvocazione datiInvocazione, IProtocolFactory<?> protocollo, OpenSPCoop2Properties op2Properties, List<Proprieta> props) throws CoreException {
        String p = protocollo != null ? protocollo.getProtocol() : "";
        boolean delegata = datiInvocazione instanceof DatiInvocazionePortaDelegata;
        boolean required = op2Properties.isGestioneTokenNbfRequired();
        BooleanNullable bn = op2Properties.isGestioneTokenNbfRequired(delegata, p);
        if (bn != null && bn.getValue() != null) {
            required = bn.getValue();
        }
        if (!delegata && GestoreTokenValidazioneUtilities.isPdndTokenPolicy(log, policyGestioneToken.getName()) && (bn = op2Properties.isGestioneTokenNbfPdndRequired()) != null && bn.getValue() != null) {
            required = bn.getValue();
        }
        try {
            return CostantiProprieta.isTokenValidationClaimsNbfRequired(props, required);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    static void validazioneInformazioniToken(boolean checkRequired, Logger log, AbstractDatiInvocazione datiInvocazione, IProtocolFactory<?> protocolFactory, EsitoGestioneToken esitoGestioneToken, PolicyGestioneToken policyGestioneToken, boolean saveErrorInCache) throws TokenException, CoreException {
        boolean future;
        boolean expired;
        boolean enabled;
        boolean check;
        Date now = DateManager.getDate();
        if (esitoGestioneToken.isValido()) {
            esitoGestioneToken.setDateValide(true);
        }
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        List<Proprieta> props = null;
        if (esitoGestioneToken.isValido() && checkRequired && (check = GestoreTokenValidazioneUtilities.isExpRequired(log, policyGestioneToken, datiInvocazione, protocolFactory, op2Properties, props = GestoreTokenValidazioneUtilities.readProprieta(datiInvocazione))) && esitoGestioneToken.getInformazioniToken().getExp() == null) {
            esitoGestioneToken.setTokenValidazioneFallita();
            esitoGestioneToken.setDateValide(false);
            esitoGestioneToken.setDetails("Token rejected; the 'exp' (expiration time) claim is required but missing.");
            if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                esitoGestioneToken.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
            } else {
                esitoGestioneToken.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
            }
        }
        if (esitoGestioneToken.isValido() && (enabled = op2Properties.isGestioneTokenExpTimeCheck()) && esitoGestioneToken.getInformazioniToken().getExp() != null && (expired = GestoreTokenValidazioneUtilities.isExpired(now, esitoGestioneToken.getInformazioniToken().getExp()))) {
            esitoGestioneToken.setTokenScaduto();
            esitoGestioneToken.setDateValide(false);
            esitoGestioneToken.setDetails("Token expired");
            if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                esitoGestioneToken.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
            } else {
                esitoGestioneToken.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
            }
        }
        if (esitoGestioneToken.isValido() && checkRequired) {
            if (props == null) {
                props = GestoreTokenValidazioneUtilities.readProprieta(datiInvocazione);
            }
            if ((check = GestoreTokenValidazioneUtilities.isNbfRequired(log, policyGestioneToken, datiInvocazione, protocolFactory, op2Properties, props)) && esitoGestioneToken.getInformazioniToken().getNbf() == null) {
                esitoGestioneToken.setTokenValidazioneFallita();
                esitoGestioneToken.setDateValide(false);
                esitoGestioneToken.setDetails("Token rejected; the 'nbf' (not before) claim is required but missing.");
                if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                    esitoGestioneToken.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                } else {
                    esitoGestioneToken.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                }
            }
        }
        if (esitoGestioneToken.isValido() && esitoGestioneToken.getInformazioniToken().getNbf() != null && (future = GestoreTokenValidazioneUtilities.isFuture(now, esitoGestioneToken.getInformazioniToken().getNbf()))) {
            esitoGestioneToken.setTokenNotUsableBefore();
            esitoGestioneToken.setDateValide(false);
            DateTimeFormatterWrapper sdf = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS");
            esitoGestioneToken.setDetails("Token not usable before " + sdf.format(esitoGestioneToken.getInformazioniToken().getNbf()));
            if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                esitoGestioneToken.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
            } else {
                esitoGestioneToken.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
            }
        }
        if (esitoGestioneToken.isValido() && checkRequired) {
            if (props == null) {
                props = GestoreTokenValidazioneUtilities.readProprieta(datiInvocazione);
            }
            if ((check = GestoreTokenValidazioneUtilities.isIatRequired(log, policyGestioneToken, datiInvocazione, protocolFactory, op2Properties, props)) && esitoGestioneToken.getInformazioniToken().getIat() == null) {
                esitoGestioneToken.setTokenValidazioneFallita();
                esitoGestioneToken.setDateValide(false);
                esitoGestioneToken.setDetails("Token rejected; the 'iat' (issued at) claim is required but missing.");
                if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                    esitoGestioneToken.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                } else {
                    esitoGestioneToken.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                }
            }
        }
        if (esitoGestioneToken.isValido() && esitoGestioneToken.getInformazioniToken().getIat() != null) {
            Long future2;
            Long old;
            if (props == null) {
                props = GestoreTokenValidazioneUtilities.readProprieta(datiInvocazione);
            }
            if ((old = GestoreTokenValidazioneUtilities.getIatTimeCheckMilliseconds(log, op2Properties, props)) != null) {
                Date oldMax = new Date(DateManager.getTimeMillis() - old);
                if (esitoGestioneToken.getInformazioniToken().getIat().before(oldMax)) {
                    esitoGestioneToken.setTokenScaduto();
                    esitoGestioneToken.setDateValide(false);
                    DateTimeFormatterWrapper sdf = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS");
                    esitoGestioneToken.setDetails("Token expired; iat time '" + sdf.format(esitoGestioneToken.getInformazioniToken().getIat()) + "' too old");
                    if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                        esitoGestioneToken.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                    } else {
                        esitoGestioneToken.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                    }
                }
            }
            if ((future2 = op2Properties.getGestioneTokenIatTimeCheckFutureToleranceMilliseconds()) != null && future2 > 0L) {
                Date futureMax = new Date(DateManager.getTimeMillis() + future2);
                if (esitoGestioneToken.getInformazioniToken().getIat().after(futureMax)) {
                    esitoGestioneToken.setTokenInTheFuture();
                    esitoGestioneToken.setDateValide(false);
                    DateTimeFormatterWrapper sdf = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS");
                    esitoGestioneToken.setDetails("Token valid in the future; iat time '" + sdf.format(esitoGestioneToken.getInformazioniToken().getIat()) + "' is in the future");
                    if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                        esitoGestioneToken.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                    } else {
                        esitoGestioneToken.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_token, (String)policyGestioneToken.getRealm(), (boolean)false, (String)esitoGestioneToken.getDetails(), (String[])new String[0]));
                    }
                }
            }
        }
        if (!esitoGestioneToken.isValido()) {
            esitoGestioneToken.setNoCache(!saveErrorInCache);
        }
    }

    static void validazioneInformazioniTokenEnrichPDNDClientInfo(EsitoGestioneToken esitoGestioneToken, PolicyGestioneToken policyGestioneToken, PdDContext pddContext, IProtocolFactory<?> protocolFactory, AbstractDatiInvocazione datiInvocazione, SecurityToken securityTokenForContext) throws CoreException, ProtocolException {
        OpenSPCoop2Properties op2Properties;
        if (policyGestioneToken != null && policyGestioneToken.getName() != null && esitoGestioneToken != null && esitoGestioneToken.getInformazioniToken() != null && esitoGestioneToken.getInformazioniToken().getClientId() != null && datiInvocazione instanceof DatiInvocazionePortaApplicativa && "modipa".equals(protocolFactory.getProtocol()) && (op2Properties = OpenSPCoop2Properties.getInstance()).isGestoreChiaviPDNDretrieveClientInfoAfterVoucherPDNDValidation()) {
            IDSoggetto idSoggetto = null;
            DatiInvocazionePortaApplicativa datiPA = (DatiInvocazionePortaApplicativa)datiInvocazione;
            if (datiPA.getPa() != null && datiPA.getPa().getTipoSoggettoProprietario() != null && datiPA.getPa().getNomeSoggettoProprietario() != null) {
                idSoggetto = new IDSoggetto(datiPA.getPa().getTipoSoggettoProprietario(), datiPA.getPa().getNomeSoggettoProprietario());
            } else if (datiPA.getRequestInfo() != null && datiPA.getRequestInfo().getIdentitaPdD() != null) {
                idSoggetto = datiPA.getRequestInfo().getIdentitaPdD();
            }
            PDNDResolver pdndResolver = new PDNDResolver(pddContext, ModIUtils.getRemoteStoreConfig());
            pdndResolver.enrichTokenInfo(datiInvocazione.getRequestInfo(), idSoggetto, esitoGestioneToken.getInformazioniToken(), securityTokenForContext);
        }
    }

    static void validazioneInformazioniTokenHeader(String jsonHeader, PolicyGestioneToken policyGestioneToken) throws TokenException {
        if (policyGestioneToken.isValidazioneJWTHeader()) {
            try {
                JSONUtils jsonUtils = JSONUtils.getInstance();
                if (jsonUtils.isJson(jsonHeader)) {
                    JsonNode root = jsonUtils.getAsNode(jsonHeader);
                    Map readClaims = jsonUtils.convertToSimpleMap(root);
                    GestoreTokenValidazioneUtilities.validazioneInformazioniTokenHeader(readClaims, policyGestioneToken.getValidazioneJWTHeaderTyp(), "typ");
                    GestoreTokenValidazioneUtilities.validazioneInformazioniTokenHeader(readClaims, policyGestioneToken.getValidazioneJWTHeaderCty(), "cty");
                    GestoreTokenValidazioneUtilities.validazioneInformazioniTokenHeader(readClaims, policyGestioneToken.getValidazioneJWTHeaderAlg(), "alg");
                }
            }
            catch (Exception e) {
                throw new TokenException("JWT header validation failed; " + e.getMessage(), e);
            }
        }
    }

    private static void validazioneInformazioniTokenHeader(Map<String, Serializable> readClaims, List<String> expectedValues, String claim) throws TokenException {
        if (expectedValues != null && !expectedValues.isEmpty()) {
            String v = null;
            if (readClaims != null && !readClaims.isEmpty()) {
                v = TokenUtilities.getClaimAsString(readClaims, claim);
            }
            if (v == null || StringUtils.isEmpty(v)) {
                throw new TokenException("Expected claim '" + claim + "' not found");
            }
            boolean find = false;
            for (String vCheck : expectedValues) {
                if (!v.equalsIgnoreCase(vCheck)) continue;
                find = true;
                break;
            }
            if (!find) {
                throw new TokenException("Claim '" + claim + "' with invalid value '" + v + "'");
            }
        }
    }

    static String buildPrefixCacheKeyValidazione(String policy, String funzione) {
        StringBuilder bf = new StringBuilder(funzione);
        bf.append("_");
        bf.append(policy);
        bf.append("_");
        return bf.toString();
    }

    static String buildCacheKeyValidazione(String policy, String funzione, boolean portaDelegata, String token) {
        StringBuilder bf = new StringBuilder();
        bf.append(GestoreTokenValidazioneUtilities.buildPrefixCacheKeyValidazione(policy, funzione));
        if (portaDelegata) {
            bf.append("PD");
        } else {
            bf.append("PA");
        }
        bf.append("_");
        bf.append(token);
        return bf.toString();
    }

    static HttpResponse http(Logger log, PolicyGestioneToken policyGestioneToken, HTTP_TYPE httpType, DynamicDiscovery dynamicDiscovery, String token, PdDContext pddContext, IProtocolFactory<?> protocolFactory, IState state, boolean delegata, String idModulo, PortaApplicativa pa, PortaDelegata pd, IDSoggetto idDominio, IDServizio idServizio, Busta busta, RequestInfo requestInfo) throws Exception {
        String authorizationHeader;
        boolean https;
        Map<String, Object> dynamicMap = TokenUtilities.buildDynamicMap(busta, requestInfo, pddContext, log);
        String endpoint = null;
        String prefixConnettore = null;
        boolean introspectionService = false;
        boolean userInfoService = false;
        switch (httpType) {
            case DYNAMIC_DISCOVERY: {
                endpoint = policyGestioneToken.getDynamicDiscoveryEndpoint();
                if (endpoint != null && !"".equals(endpoint)) {
                    endpoint = DynamicUtils.convertDynamicPropertyValue("endpoint.gwt", endpoint, dynamicMap, pddContext);
                }
                prefixConnettore = "[EndpointDynamicDiscovery: " + endpoint + "] ";
                break;
            }
            case INTROSPECTION: {
                if (policyGestioneToken.isDynamicDiscovery()) {
                    GestoreTokenValidazioneUtilities.check(dynamicDiscovery);
                    endpoint = dynamicDiscovery.getIntrospectionEndpoint();
                    if (endpoint != null && !"".equals(endpoint)) {
                        endpoint = DynamicUtils.convertDynamicPropertyValue("endpoint.gwt", endpoint, dynamicMap, pddContext);
                    }
                    if (endpoint == null || StringUtils.isEmpty((String)endpoint)) {
                        throw new TokenException("DynamicDiscovery.introspectionEndpoint undefined");
                    }
                } else {
                    endpoint = policyGestioneToken.getIntrospectionEndpoint();
                }
                prefixConnettore = "[EndpointIntrospection: " + endpoint + "] ";
                introspectionService = true;
                break;
            }
            case USER_INFO: {
                if (policyGestioneToken.isDynamicDiscovery()) {
                    GestoreTokenValidazioneUtilities.check(dynamicDiscovery);
                    endpoint = dynamicDiscovery.getUserinfoEndpoint();
                    if (endpoint != null && !"".equals(endpoint)) {
                        endpoint = DynamicUtils.convertDynamicPropertyValue("endpoint.gwt", endpoint, dynamicMap, pddContext);
                    }
                    if (endpoint == null || StringUtils.isEmpty((String)endpoint)) {
                        throw new TokenException("DynamicDiscovery.userinfoEndpoint undefined");
                    }
                } else {
                    endpoint = policyGestioneToken.getUserInfoEndpoint();
                }
                prefixConnettore = "[EndpointUserInfo: " + endpoint + "] ";
                userInfoService = true;
            }
        }
        TipoTokenRequest tipoTokenRequest = null;
        String positionTokenName = null;
        if (introspectionService) {
            tipoTokenRequest = policyGestioneToken.getIntrospectionTipoTokenRequest();
        } else if (userInfoService) {
            tipoTokenRequest = policyGestioneToken.getUserInfoTipoTokenRequest();
        }
        if (tipoTokenRequest != null) {
            switch (tipoTokenRequest) {
                case authorization: {
                    break;
                }
                case header: {
                    if (introspectionService) {
                        positionTokenName = policyGestioneToken.getIntrospectionTipoTokenRequestHeaderName();
                        break;
                    }
                    positionTokenName = policyGestioneToken.getUserInfoTipoTokenRequestHeaderName();
                    break;
                }
                case url: {
                    if (introspectionService) {
                        positionTokenName = policyGestioneToken.getIntrospectionTipoTokenRequestUrlPropertyName();
                        break;
                    }
                    positionTokenName = policyGestioneToken.getUserInfoTipoTokenRequestUrlPropertyName();
                    break;
                }
                case form: {
                    positionTokenName = introspectionService ? policyGestioneToken.getIntrospectionTipoTokenRequestFormPropertyName() : policyGestioneToken.getUserInfoTipoTokenRequestFormPropertyName();
                }
            }
        }
        if (positionTokenName != null && !"".equals(positionTokenName)) {
            positionTokenName = DynamicUtils.convertDynamicPropertyValue("positionTokenName.gwt", positionTokenName, dynamicMap, pddContext);
        }
        String contentType = null;
        if (introspectionService || userInfoService) {
            contentType = introspectionService ? policyGestioneToken.getIntrospectionContentType() : policyGestioneToken.getUserInfoContentType();
        }
        if (contentType != null && !"".equals(contentType)) {
            contentType = DynamicUtils.convertDynamicPropertyValue("contentType.gwt", contentType, dynamicMap, pddContext);
        }
        HttpRequestMethod httpMethod = null;
        switch (httpType) {
            case DYNAMIC_DISCOVERY: {
                httpMethod = HttpRequestMethod.GET;
                break;
            }
            case INTROSPECTION: {
                httpMethod = policyGestioneToken.getIntrospectionHttpMethod();
                break;
            }
            case USER_INFO: {
                httpMethod = policyGestioneToken.getUserInfoHttpMethod();
            }
        }
        Properties endpointConfig = policyGestioneToken.getProperties().get("endpointConfig");
        GestoreTokenValidazioneUtilities.resolveDynamicProperyValues(endpointConfig, dynamicMap, pddContext);
        if (endpointConfig.containsKey("proxyHostname")) {
            String hostProxy = endpointConfig.getProperty("proxyHostname");
            String portProxy = endpointConfig.getProperty("proxyPort");
            prefixConnettore = prefixConnettore + GestoreToken.getMessageViaProxy(hostProxy, portProxy);
        }
        if (!(https = false)) {
            switch (httpType) {
                case DYNAMIC_DISCOVERY: {
                    https = policyGestioneToken.isEndpointHttps(false, false);
                    break;
                }
                case INTROSPECTION: {
                    https = policyGestioneToken.isEndpointHttps(true, false);
                    break;
                }
                case USER_INFO: {
                    https = policyGestioneToken.isEndpointHttps(false, true);
                }
            }
        }
        boolean httpsClient = false;
        Properties sslConfig = null;
        Properties sslClientConfig = null;
        if (https) {
            sslConfig = policyGestioneToken.getProperties().get("sslConfig");
            GestoreTokenValidazioneUtilities.resolveDynamicProperyValues(sslConfig, dynamicMap, pddContext);
            if (introspectionService || userInfoService) {
                httpsClient = introspectionService ? policyGestioneToken.isIntrospectionHttpsAuthentication() : policyGestioneToken.isUserInfoHttpsAuthentication();
            }
            if (httpsClient) {
                sslClientConfig = policyGestioneToken.getProperties().get("sslClientConfig");
                TokenUtilities.injectSameKeystoreForHttpsClient(sslConfig, sslClientConfig);
                GestoreTokenValidazioneUtilities.resolveDynamicProperyValues(sslClientConfig, dynamicMap, pddContext);
            }
        }
        boolean basic = false;
        String username = null;
        String password = null;
        if (introspectionService || userInfoService) {
            basic = introspectionService ? policyGestioneToken.isIntrospectionBasicAuthentication() : policyGestioneToken.isUserInfoBasicAuthentication();
        }
        if (basic) {
            if (introspectionService) {
                username = policyGestioneToken.getIntrospectionBasicAuthenticationUsername();
                password = policyGestioneToken.getIntrospectionBasicAuthenticationPassword();
            } else {
                username = policyGestioneToken.getUserInfoBasicAuthenticationUsername();
                password = policyGestioneToken.getUserInfoBasicAuthenticationPassword();
            }
            if (username != null && !"".equals(username)) {
                username = DynamicUtils.convertDynamicPropertyValue("username.gwt", username, dynamicMap, pddContext);
            }
            if (password != null && !"".equals(password)) {
                password = DynamicUtils.convertDynamicPropertyValue("password.gwt", password, dynamicMap, pddContext);
            }
        }
        boolean bearer = false;
        String bearerToken = null;
        if (introspectionService || userInfoService) {
            bearer = introspectionService ? policyGestioneToken.isIntrospectionBearerAuthentication() : policyGestioneToken.isUserInfoBearerAuthentication();
        }
        if (bearer && (bearerToken = introspectionService ? policyGestioneToken.getIntrospectionBeareAuthenticationToken() : policyGestioneToken.getUserInfoBeareAuthenticationToken()) != null && !"".equals(bearerToken)) {
            bearerToken = DynamicUtils.convertDynamicPropertyValue("bearerToken.gwt", bearerToken, dynamicMap, pddContext);
        }
        ConnettoreMsg connettoreMsg = new ConnettoreMsg();
        ConnettoreHTTP connettore = null;
        if (https) {
            connettoreMsg.setTipoConnettore(TipiConnettore.HTTPS.getNome());
            connettore = new ConnettoreHTTPS();
        } else {
            connettoreMsg.setTipoConnettore(TipiConnettore.HTTP.getNome());
            connettore = new ConnettoreHTTP();
        }
        connettoreMsg.setIdModulo(idModulo);
        connettoreMsg.setState(state);
        PolicyTimeoutConfig policyConfig = new PolicyTimeoutConfig();
        switch (httpType) {
            case DYNAMIC_DISCOVERY: {
                policyConfig.setPolicyValidazioneDynamicDiscovery(policyGestioneToken.getName());
                break;
            }
            case INTROSPECTION: {
                policyConfig.setPolicyValidazioneIntrospection(policyGestioneToken.getName());
                break;
            }
            case USER_INFO: {
                policyConfig.setPolicyValidazioneUserInfo(policyGestioneToken.getName());
            }
        }
        connettoreMsg.setPolicyTimeoutConfig(policyConfig);
        ForwardProxy forwardProxy = TokenUtilities.getForwardProxy(policyGestioneToken, requestInfo, state, delegata, idDominio, idServizio);
        if (forwardProxy != null && forwardProxy.isEnabled() && forwardProxy.getConfigToken() != null) {
            boolean enabled = false;
            switch (httpType) {
                case DYNAMIC_DISCOVERY: {
                    enabled = forwardProxy.getConfigToken().isTokenDynamicDiscoveryEnabled();
                    break;
                }
                case INTROSPECTION: {
                    enabled = forwardProxy.getConfigToken().isTokenIntrospectionEnabled();
                    break;
                }
                case USER_INFO: {
                    enabled = forwardProxy.getConfigToken().isTokenUserInfoEnabled();
                }
            }
            if (enabled) {
                connettoreMsg.setForwardProxy(forwardProxy);
            }
        }
        connettore.setForceDisable_proxyPassReverse(true);
        connettore.init(pddContext, protocolFactory, new Object[0]);
        connettore.setRegisterSendIntoContext(false);
        if (basic) {
            InvocazioneCredenziali credenziali = new InvocazioneCredenziali();
            credenziali.setUser(username);
            credenziali.setPassword(password);
            connettoreMsg.setCredenziali(credenziali);
        }
        connettoreMsg.setConnectorProperties(new HashMap<String, String>());
        connettoreMsg.getConnectorProperties().put("location", endpoint);
        boolean debug = false;
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        switch (httpType) {
            case DYNAMIC_DISCOVERY: {
                debug = properties.isGestioneTokenDynamicDiscoveryDebug();
                break;
            }
            case INTROSPECTION: {
                debug = properties.isGestioneTokenIntrospectionDebug();
                break;
            }
            case USER_INFO: {
                debug = properties.isGestioneTokenUserInfoDebug();
            }
        }
        if (debug) {
            connettoreMsg.getConnectorProperties().put("debug", "true");
        }
        connettoreMsg.getConnectorProperties().put("dataTransferMode", TransferLengthModes.CONTENT_LENGTH.getNome());
        GestoreToken.addProperties(connettoreMsg, endpointConfig);
        if (https) {
            GestoreToken.addProperties(connettoreMsg, sslConfig);
            if (httpsClient) {
                GestoreToken.addProperties(connettoreMsg, sslClientConfig);
            }
        }
        byte[] content = null;
        TransportRequestContext transportRequestContext = new TransportRequestContext(log);
        if (httpMethod != null) {
            transportRequestContext.setRequestType(httpMethod.name());
        }
        transportRequestContext.setHeaders(new HashMap());
        if (bearer) {
            authorizationHeader = "Bearer " + bearerToken;
            TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)"Authorization", (String)authorizationHeader);
        }
        if (contentType != null) {
            TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)"Content-Type", (String)contentType);
        }
        if (tipoTokenRequest != null) {
            switch (tipoTokenRequest) {
                case authorization: {
                    transportRequestContext.removeHeader("Authorization");
                    authorizationHeader = "Bearer " + token;
                    TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)"Authorization", (String)authorizationHeader);
                    break;
                }
                case header: {
                    TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)positionTokenName, (String)token);
                    break;
                }
                case url: {
                    transportRequestContext.setParameters(new HashMap());
                    TransportUtils.setParameter((Map)transportRequestContext.getParameters(), (String)positionTokenName, (String)token);
                    break;
                }
                case form: {
                    transportRequestContext.removeHeader("Content-Type");
                    TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)"Content-Type", (String)"application/x-www-form-urlencoded");
                    content = (positionTokenName + "=" + token).getBytes();
                }
            }
        }
        OpenSPCoop2MessageParseResult pr = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createMessage(MessageType.BINARY, transportRequestContext, content);
        OpenSPCoop2Message msg = pr.getMessage_throwParseException();
        connettoreMsg.setRequestMessage(msg);
        connettoreMsg.setGenerateErrorWithConnectorPrefix(false);
        connettore.setHttpMethod(msg);
        connettore.setPa(pa);
        connettore.setPd(pd);
        ResponseCachingConfigurazione responseCachingConfigurazione = new ResponseCachingConfigurazione();
        responseCachingConfigurazione.setStato(StatoFunzionalita.DISABILITATO);
        boolean send = connettore.send(responseCachingConfigurazione, connettoreMsg);
        if (!send) {
            if (connettore.getEccezioneProcessamento() != null) {
                throw new TokenException(prefixConnettore + connettore.getErrore(), connettore.getEccezioneProcessamento());
            }
            throw new TokenException(prefixConnettore + connettore.getErrore());
        }
        OpenSPCoop2Message msgResponse = connettore.getResponse();
        ByteArrayOutputStream bout = null;
        if (msgResponse != null) {
            bout = new ByteArrayOutputStream();
            if (msgResponse != null) {
                msgResponse.writeTo((OutputStream)bout, true);
            }
            bout.flush();
            bout.close();
        }
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setResultHTTPOperation(connettore.getCodiceTrasporto());
        if (connettore.getCodiceTrasporto() >= 200 && connettore.getCodiceTrasporto() < 299) {
            String msgSuccess = prefixConnettore + GestoreToken.getMessageConnettoreConnessioneSuccesso(connettore);
            if (bout != null && bout.size() > 0) {
                log.debug(msgSuccess);
                httpResponse.setContent(bout.toByteArray());
                return httpResponse;
            }
            throw new TokenException(msgSuccess + "; non \u00e8 pervenuta alcuna risposta");
        }
        String msgError = prefixConnettore + GestoreToken.getMessageConnettoreConnessioneErrore(connettore);
        if (bout != null && bout.size() > 0) {
            String e = msgError + ": " + bout.toString();
            log.debug(e);
            httpResponse.setContent(bout.toByteArray());
            return httpResponse;
        }
        log.error(msgError);
        throw new TokenException(msgError);
    }

    private static void resolveDynamicProperyValues(Properties p, Map<String, Object> dynamicMap, Context context) throws DynamicException {
        if (p != null && !p.isEmpty()) {
            Enumeration<Object> oKey = p.keys();
            while (oKey.hasMoreElements()) {
                String key;
                String value;
                Object object = oKey.nextElement();
                if (!(object instanceof String) || (value = p.getProperty(key = (String)object)) == null || "".equals(value) || !value.contains("{") || !value.contains("}")) continue;
                value = DynamicUtils.convertDynamicPropertyValue(key + ".gwt", value, dynamicMap, context);
                p.put(key, value);
            }
        }
    }

    static void check(DynamicDiscovery dynamicDiscovery) throws TokenException {
        if (dynamicDiscovery == null) {
            throw new TokenException("DynamicDiscovery information not found");
        }
        if (!dynamicDiscovery.isValid()) {
            throw new TokenException("DynamicDiscovery failed");
        }
    }
}

