/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.byok.BYOKUnwrapPolicyUtilities;
import org.openspcoop2.pdd.core.dynamic.DynamicException;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.dynamic.Template;
import org.openspcoop2.pdd.core.token.AbstractDynamicParameters;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.NegoziazioneTokenDynamicParametersModIUtils;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.ModIKeystoreUtils;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.JWKSetStore;
import org.openspcoop2.security.keystore.KeyPairStore;
import org.openspcoop2.security.keystore.MerlinKeystore;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.security.utils.SignatureAlgorithmUtilities;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.digest.DigestEncoding;
import org.openspcoop2.utils.digest.DigestType;
import org.openspcoop2.utils.digest.DigestUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public class NegoziazioneTokenDynamicParameters
extends AbstractDynamicParameters {
    private PolicyNegoziazioneToken policyNegoziazioneToken;
    private String endpoint;
    private String basicUsername;
    private String basicPassword;
    private String bearerToken;
    private String usernamePasswordGrantUsername;
    private String usernamePasswordGrantPassword;
    private String signedJwtIssuer;
    private String signedJwtClientId;
    private String signedJwtSubject;
    private String signedJwtAudience;
    private String signedJwtJti;
    private String signedJwtPurposeId;
    private String signedJwtSessionInfo;
    private String signedJwtClaims;
    private String signedJwtAuditDigest;
    private String signedJwtAuditDigestAlgo;
    private String signedJwtCustomId;
    private String signedJwtX509Url;
    private String scope;
    private String audience;
    private String formClientId;
    private String formResource;
    private String parameters;
    private HttpRequestMethod httpMethod;
    private String httpContentType;
    private String httpHeaders;
    private String httpPayloadTemplateType;
    private String httpPayload;
    private IDServizioApplicativo idApplicativoRichiedente;
    private ServizioApplicativo applicativoRichiedente;
    private String kidApplicativoModI;
    private ModIKeystoreUtils keystoreApplicativoModI;
    private ModIKeystoreUtils keystoreDPoPApplicativoModI;
    private IDFruizione idFruizione;
    private String kidFruizioneModI;
    private ModIKeystoreUtils keystoreFruizioneModI;
    private ModIKeystoreUtils keystoreDPoPFruizioneModI;
    private static boolean signedJwtIssuerCacheKey;
    private static boolean signedJwtClientIdCacheKey;
    private static boolean signedJwtSubjectCacheKey;
    private static boolean signedJwtAudienceCacheKey;
    private static boolean signedJwtJtiCacheKey;
    private static boolean signedJwtPurposeIdCacheKey;
    private static boolean signedJwtSessionInfoCacheKey;
    private static boolean signedJwtClaimsCacheKey;
    private static boolean signedJwtAuditDigestCacheKey;
    private static boolean signedJwtCustomIdCacheKey;
    private static boolean signedJwtX509UrlCacheKey;
    private static boolean scopeCacheKey;
    private static boolean audienceCacheKey;
    private static boolean formClientIdCacheKey;
    private static boolean formResourceCacheKey;
    private static boolean parametersCacheKey;
    private static boolean httpMethodCacheKey;
    private static boolean httpContentTypeCacheKey;
    private static boolean httpHeadersCacheKey;
    private static boolean httpPayloadTemplateTypeCacheKey;
    private static boolean httpPayloadCacheKey;
    private static boolean applicativoRichiedenteCacheKey;
    private static boolean dpopKeystoreApplicativoCacheKey;
    private static boolean fruizioneCacheKey;
    private static boolean dpopKeystoreFruizioneCacheKey;
    private static Boolean initCacheKey;
    private static final String ERRORE_RICHIEDE_IDENTIFICAZIONE_DATI_FRUIZIONE = "richiede l'identificazione dei dati di una fruizione";
    private static final String ERRORE_NON_UTILIZZABILE_APPLICATIVO_IDENTIFICATO = "non \u00e8 utilizzabile con l'applicativo identificato";
    private static final String ERRORE_CONFIGURAZIONE_APPLICATIVO_NON_COMPLETA = "nella configurazione dell'applicativo non \u00e8 stato definito un";
    private static final String ERRORE_SEZIONE = "nella sezione";
    private static final String ERRORE_NON_UTILIZZABILE_FRUIZIONE = "non \u00e8 utilizzabile con la fruizione";
    private static final String ERRORE_CONFIGURAZIONE_MODI_NON_COMPLETA = "nella configurazione 'ModI' non \u00e8 stato definito un";
    private static final String ERRORE_RICHIEDE_AUTENTICAZIONE_IDENTIFICAZIONE_APPLICATIVO = "richiede l'autenticazione e l'identificazione di un applicativo fruitore";

    private static synchronized void initCacheKey() {
        if (initCacheKey == null) {
            OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
            signedJwtIssuerCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("issuer");
            signedJwtClientIdCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("clientId");
            signedJwtSubjectCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("subject");
            signedJwtAudienceCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("audience");
            signedJwtJtiCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("identifier");
            signedJwtPurposeIdCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("purposeId");
            signedJwtSessionInfoCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("sessionInfo");
            signedJwtClaimsCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("claims");
            signedJwtAuditDigestCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("auditDigest");
            signedJwtCustomIdCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("kid");
            signedJwtX509UrlCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("x509Url");
            scopeCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("form.scope");
            audienceCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("form.audience");
            formClientIdCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("form.clientId");
            formResourceCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("form.resource");
            parametersCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("form.parameters");
            httpMethodCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("http.method");
            httpContentTypeCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("http.contentType");
            httpHeadersCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("http.headers");
            httpPayloadTemplateTypeCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("http.payload.templateType");
            httpPayloadCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("http.payload");
            applicativoRichiedenteCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("applicativeRequester");
            dpopKeystoreApplicativoCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("dpopKeystoreApplicativeRequester");
            fruizioneCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("outboundInterface");
            dpopKeystoreFruizioneCacheKey = op2Properties.isGestioneRetrieveTokenCacheKey("dpopKeystoreOutboundInterface");
            initCacheKey = true;
        }
    }

    private static void checkInitCacheKey() {
        if (initCacheKey == null) {
            NegoziazioneTokenDynamicParameters.initCacheKey();
        }
    }

    public NegoziazioneTokenDynamicParameters(Map<String, Object> dynamicMap, PdDContext pddContext, RequestInfo requestInfo, Busta busta, IState state, IProtocolFactory<?> protocolFactory, PolicyNegoziazioneToken policyNegoziazioneToken) throws TokenException, DynamicException, ProtocolException {
        super(dynamicMap, pddContext, requestInfo);
        String httpPayloadDynamic;
        String sHttpMethod;
        boolean bearer;
        boolean basic;
        this.policyNegoziazioneToken = policyNegoziazioneToken;
        this.endpoint = policyNegoziazioneToken.getEndpoint();
        if (this.endpoint != null && !"".equals(this.endpoint)) {
            this.endpoint = DynamicUtils.convertDynamicPropertyValue("endpoint.gwt", this.endpoint, dynamicMap, pddContext);
        }
        if (basic = policyNegoziazioneToken.isBasicAuthentication()) {
            this.basicUsername = policyNegoziazioneToken.getBasicAuthenticationUsername();
            if (this.basicUsername != null && !"".equals(this.basicUsername)) {
                this.basicUsername = DynamicUtils.convertDynamicPropertyValue("username.gwt", this.basicUsername, dynamicMap, pddContext);
            }
            this.basicPassword = policyNegoziazioneToken.getBasicAuthenticationPassword();
            if (this.basicPassword != null && !"".equals(this.basicPassword)) {
                this.basicPassword = DynamicUtils.convertDynamicPropertyValue("password.gwt", this.basicPassword, dynamicMap, pddContext);
            }
        }
        if (bearer = policyNegoziazioneToken.isBearerAuthentication()) {
            this.bearerToken = policyNegoziazioneToken.getBeareAuthenticationToken();
            if (this.bearerToken != null && !"".equals(this.bearerToken)) {
                this.bearerToken = DynamicUtils.convertDynamicPropertyValue("bearerToken.gwt", this.bearerToken, dynamicMap, pddContext);
            }
        }
        if (policyNegoziazioneToken.isUsernamePasswordGrant()) {
            this.usernamePasswordGrantUsername = policyNegoziazioneToken.getUsernamePasswordGrantUsername();
            if (this.usernamePasswordGrantUsername != null && !"".equals(this.usernamePasswordGrantUsername)) {
                this.usernamePasswordGrantUsername = DynamicUtils.convertDynamicPropertyValue("usernamePasswordGrant_username.gwt", this.usernamePasswordGrantUsername, dynamicMap, pddContext);
            }
            this.usernamePasswordGrantPassword = policyNegoziazioneToken.getUsernamePasswordGrantPassword();
            if (this.usernamePasswordGrantPassword != null && !"".equals(this.usernamePasswordGrantPassword)) {
                this.usernamePasswordGrantPassword = DynamicUtils.convertDynamicPropertyValue("usernamePasswordGrant_password.gwt", this.usernamePasswordGrantPassword, dynamicMap, pddContext);
            }
        }
        String clientIdApplicativoModI = null;
        String idApp = null;
        String clientIdFruizioneModI = null;
        String idFruizioneLabel = null;
        List listProtocolPropertiesFruizione = null;
        if (policyNegoziazioneToken.isRfc7523x509Grant() || policyNegoziazioneToken.isRfc7523ClientSecretGrant()) {
            if (policyNegoziazioneToken.isRfc7523x509Grant()) {
                String prefixError;
                boolean usaApplicativoKeystore = policyNegoziazioneToken.isJwtSignKeystoreApplicativoModI();
                boolean usaApplicativoDPoPKeystore = policyNegoziazioneToken.isDpop() && policyNegoziazioneToken.isDpopSignKeystoreApplicativoModI();
                boolean usaFruizioneKeystore = false;
                boolean usaFruizioneDPoPKeystore = false;
                if (!usaApplicativoKeystore && !usaApplicativoDPoPKeystore) {
                    usaFruizioneKeystore = policyNegoziazioneToken.isJwtSignKeystoreFruizioneModI();
                    boolean bl = usaFruizioneDPoPKeystore = policyNegoziazioneToken.isDpop() && policyNegoziazioneToken.isDpopSignKeystoreFruizioneModI();
                }
                if (usaApplicativoKeystore || usaApplicativoDPoPKeystore) {
                    prefixError = "Il tipo di keystore indicato nella token policy '" + policyNegoziazioneToken.getName() + "' ";
                    if (busta.getServizioApplicativoFruitore() == null) {
                        throw new TokenException(prefixError + ERRORE_RICHIEDE_AUTENTICAZIONE_IDENTIFICAZIONE_APPLICATIVO);
                    }
                    if (busta.getTipoMittente() == null || busta.getMittente() == null) {
                        throw new TokenException(prefixError + "richiede l'autenticazione e l'identificazione di un applicativo fruitore: dominio non identificato");
                    }
                    ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(state);
                    TokenException te = null;
                    this.idApplicativoRichiedente = new IDServizioApplicativo();
                    this.idApplicativoRichiedente.setNome(busta.getServizioApplicativoFruitore());
                    this.idApplicativoRichiedente.setIdSoggettoProprietario(new IDSoggetto(busta.getTipoMittente(), busta.getMittente()));
                    try {
                        this.applicativoRichiedente = configurazionePdDManager.getServizioApplicativo(this.idApplicativoRichiedente, this.getRequestInfo());
                    }
                    catch (Exception t) {
                        te = new TokenException(prefixError + "richiede l'autenticazione e l'identificazione di un applicativo fruitore: " + t.getMessage(), t);
                    }
                    TokenException teToken = null;
                    if (this.applicativoRichiedente == null) {
                        IDServizioApplicativo idServizioApplicativoToken = null;
                        if (pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_APPLICATIVO_TOKEN)) {
                            idServizioApplicativoToken = (IDServizioApplicativo)pddContext.getObject(org.openspcoop2.core.constants.Costanti.ID_APPLICATIVO_TOKEN);
                        }
                        if (idServizioApplicativoToken != null) {
                            try {
                                this.idApplicativoRichiedente = idServizioApplicativoToken;
                                this.applicativoRichiedente = configurazionePdDManager.getServizioApplicativo(this.idApplicativoRichiedente, this.getRequestInfo());
                            }
                            catch (Exception t) {
                                teToken = new TokenException(prefixError + "richiede l'autenticazione e l'identificazione di un applicativo fruitore: " + t.getMessage(), t);
                            }
                        }
                    }
                    if (this.applicativoRichiedente == null) {
                        if (te != null) {
                            throw te;
                        }
                        if (teToken != null) {
                            throw teToken;
                        }
                        throw new TokenException(prefixError + ERRORE_RICHIEDE_AUTENTICAZIONE_IDENTIFICAZIONE_APPLICATIVO);
                    }
                    if (!"modipa".equals(protocolFactory.getProtocol())) {
                        throw new TokenException(prefixError + "\u00e8 utilizzabile solamente con il profilo di interoperabilit\u00e0 'ModI'");
                    }
                    idApp = this.idApplicativoRichiedente.getNome() + " (Soggetto: " + this.idApplicativoRichiedente.getIdSoggettoProprietario().getNome() + ")";
                    if (usaApplicativoDPoPKeystore && ModIKeystoreUtils.isKeystoreConfigEnabled((ServizioApplicativo)this.applicativoRichiedente, (ModIKeystoreUtils.ModIKeystoreConfigType)ModIKeystoreUtils.ModIKeystoreConfigType.DPOP)) {
                        try {
                            this.keystoreDPoPApplicativoModI = new ModIKeystoreUtils(this.applicativoRichiedente, ModIKeystoreUtils.ModIKeystoreConfigType.DPOP);
                        }
                        catch (Exception t) {
                            throw new TokenException(prefixError + "(DPoP) non \u00e8 utilizzabile: " + t.getMessage(), t);
                        }
                    }
                    if (usaApplicativoKeystore || usaApplicativoDPoPKeystore && this.keystoreDPoPApplicativoModI == null) {
                        try {
                            String tipo = "Signed JWT";
                            if (!usaApplicativoKeystore) {
                                tipo = "DPoP";
                            }
                            this.keystoreApplicativoModI = new ModIKeystoreUtils(this.applicativoRichiedente, "Token Policy Negoziazione - " + tipo);
                        }
                        catch (Exception t) {
                            throw new TokenException(prefixError + "non \u00e8 utilizzabile: " + t.getMessage(), t);
                        }
                    }
                } else if (usaFruizioneKeystore || usaFruizioneDPoPKeystore) {
                    prefixError = "Il tipo di keystore indicato nella token policy '" + policyNegoziazioneToken.getName() + "' ";
                    if (busta.getTipoMittente() == null || busta.getMittente() == null) {
                        throw new TokenException(prefixError + "non \u00e8 utilizzabile: soggetto fruitore non identificato");
                    }
                    if (busta.getTipoDestinatario() == null || busta.getDestinatario() == null) {
                        throw new TokenException(prefixError + "non \u00e8 utilizzabile: soggetto erogatore non identificato");
                    }
                    if (busta.getTipoServizio() == null || busta.getServizio() == null || busta.getVersioneServizio() == null) {
                        throw new TokenException(prefixError + "non \u00e8 utilizzabile: dati servizio non identificati");
                    }
                    RegistroServiziManager registroServiziManager = RegistroServiziManager.getInstance((IState)state);
                    IDSoggetto idFruitore = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                    IDServizio idServizio = null;
                    try {
                        idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), busta.getTipoDestinatario(), busta.getDestinatario(), busta.getVersioneServizio().intValue());
                    }
                    catch (Exception e) {
                        throw new TokenException(e.getMessage(), e);
                    }
                    this.idFruizione = new IDFruizione();
                    this.idFruizione.setIdFruitore(idFruitore);
                    this.idFruizione.setIdServizio(idServizio);
                    if (!"modipa".equals(protocolFactory.getProtocol())) {
                        throw new TokenException(prefixError + "\u00e8 utilizzabile solamente con il profilo di interoperabilit\u00e0 'ModI'");
                    }
                    AccordoServizioParteSpecifica asps = null;
                    try {
                        asps = registroServiziManager.getAccordoServizioParteSpecifica(this.idFruizione.getIdServizio(), null, Boolean.valueOf(false), this.getRequestInfo());
                    }
                    catch (Exception t) {
                        throw new TokenException(prefixError + "richiede l'identificazione di servizio: " + t.getMessage(), t);
                    }
                    idFruizioneLabel = this.idFruizione.getIdFruitore().getNome() + " -> " + this.idFruizione.getIdServizio().getNome() + " (Soggetto: " + this.idFruizione.getIdServizio().getSoggettoErogatore().getNome() + ")";
                    if (usaFruizioneDPoPKeystore) {
                        if (ModIKeystoreUtils.isKeystoreConfigRidefinito((IDSoggetto)this.idFruizione.getIdFruitore(), (AccordoServizioParteSpecifica)asps, (ModIKeystoreUtils.ModIKeystoreConfigType)ModIKeystoreUtils.ModIKeystoreConfigType.DPOP)) {
                            try {
                                this.keystoreDPoPFruizioneModI = new ModIKeystoreUtils(this.idFruizione.getIdFruitore(), asps, ModIKeystoreUtils.ModIKeystoreConfigType.DPOP);
                            }
                            catch (Exception t) {
                                throw new TokenException(prefixError + "(DPoP) non \u00e8 utilizzabile: " + t.getMessage(), t);
                            }
                        }
                        if (ModIKeystoreUtils.isKeystoreConfigDefault((IDSoggetto)this.idFruizione.getIdFruitore(), (AccordoServizioParteSpecifica)asps, (ModIKeystoreUtils.ModIKeystoreConfigType)ModIKeystoreUtils.ModIKeystoreConfigType.DPOP)) {
                            try {
                                this.keystoreDPoPFruizioneModI = new ModIKeystoreUtils(this.idFruizione.getIdFruitore(), asps, ModIKeystoreUtils.ModIKeystoreConfigType.DPOP, NegoziazioneTokenDynamicParametersModIUtils.getSicurezzaMessaggioCertificatiKeyStoreTipo(), NegoziazioneTokenDynamicParametersModIUtils.getSicurezzaMessaggioCertificatiKeyStorePath(), NegoziazioneTokenDynamicParametersModIUtils.getSicurezzaMessaggioCertificatiKeyStorePassword(), NegoziazioneTokenDynamicParametersModIUtils.getSicurezzaMessaggioCertificatiKeyAlias(), NegoziazioneTokenDynamicParametersModIUtils.getSicurezzaMessaggioCertificatiKeyPassword());
                            }
                            catch (Exception t) {
                                throw new TokenException(prefixError + "(DPoP default) non \u00e8 utilizzabile: " + t.getMessage(), t);
                            }
                        }
                    }
                    if (usaFruizioneKeystore || usaFruizioneDPoPKeystore && this.keystoreDPoPFruizioneModI == null) {
                        try {
                            String tipo = "Signed JWT";
                            if (!usaFruizioneKeystore) {
                                tipo = "DPoP";
                            }
                            this.keystoreFruizioneModI = new ModIKeystoreUtils(true, this.idFruizione.getIdFruitore(), asps, "Token Policy Negoziazione - " + tipo, NegoziazioneTokenDynamicParametersModIUtils.getSicurezzaMessaggioCertificatiKeyStoreTipo(), NegoziazioneTokenDynamicParametersModIUtils.getSicurezzaMessaggioCertificatiKeyStorePath(), NegoziazioneTokenDynamicParametersModIUtils.getSicurezzaMessaggioCertificatiKeyStorePassword(), NegoziazioneTokenDynamicParametersModIUtils.getSicurezzaMessaggioCertificatiKeyAlias(), NegoziazioneTokenDynamicParametersModIUtils.getSicurezzaMessaggioCertificatiKeyPassword());
                        }
                        catch (Exception t) {
                            throw new TokenException(prefixError + "non \u00e8 utilizzabile: " + t.getMessage(), t);
                        }
                    }
                    listProtocolPropertiesFruizione = ProtocolPropertiesUtils.getProtocolProperties((boolean)true, (IDSoggetto)this.idFruizione.getIdFruitore(), (AccordoServizioParteSpecifica)asps);
                }
            }
            if (policyNegoziazioneToken.isJwtSignIncludeKeyIdApplicativoModI()) {
                String prefixError = "La modalit\u00e0 di generazione del Key Id (kid), indicata nella token policy '" + policyNegoziazioneToken.getName() + "', ";
                if (this.applicativoRichiedente == null) {
                    throw new TokenException(prefixError + ERRORE_RICHIEDE_AUTENTICAZIONE_IDENTIFICAZIONE_APPLICATIVO);
                }
                String kidApplicativoModIConfig = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)this.applicativoRichiedente.getProtocolPropertyList(), (String)"modipaSecurityTokenKID");
                if (kidApplicativoModIConfig == null || StringUtils.isEmpty((String)kidApplicativoModIConfig)) {
                    throw new TokenException(prefixError + "non \u00e8 utilizzabile con l'applicativo identificato '" + idApp + "': nella configurazione dell'applicativo non \u00e8 stato definito un 'Key Id (kid) del Certificato' nella sezione 'Authorization OAuth'");
                }
                this.kidApplicativoModI = kidApplicativoModIConfig;
                if (this.kidApplicativoModI != null && !"".equals(this.kidApplicativoModI) && !"${undefined}".equals(this.kidApplicativoModI)) {
                    this.kidApplicativoModI = DynamicUtils.convertDynamicPropertyValue("kid.gwt", this.kidApplicativoModI, dynamicMap, pddContext);
                }
            } else if (policyNegoziazioneToken.isJwtSignIncludeKeyIdFruizioneModI()) {
                String prefixError = "La modalit\u00e0 di generazione del Key Id (kid), indicata nella token policy '" + policyNegoziazioneToken.getName() + "', ";
                if (this.idFruizione == null) {
                    throw new TokenException(prefixError + ERRORE_RICHIEDE_IDENTIFICAZIONE_DATI_FRUIZIONE);
                }
                String kidFruizioneModIConfig = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolPropertiesFruizione, (String)"modipaSecurityOauthKid");
                if (kidFruizioneModIConfig == null || StringUtils.isEmpty((String)kidFruizioneModIConfig)) {
                    throw new TokenException(prefixError + "non \u00e8 utilizzabile con la fruizione '" + idFruizioneLabel + "': nella configurazione 'ModI' non \u00e8 stato definito un 'Key Id (kid) del Certificato'");
                }
                this.kidFruizioneModI = kidFruizioneModIConfig;
                if (this.kidFruizioneModI != null && !"".equals(this.kidFruizioneModI) && !"${undefined}".equals(this.kidFruizioneModI)) {
                    this.kidFruizioneModI = DynamicUtils.convertDynamicPropertyValue("kid.gwt", this.kidFruizioneModI, dynamicMap, pddContext);
                }
            }
            if (policyNegoziazioneToken.isJwtIssuerApplicativoModI()) {
                String prefixError = "La modalit\u00e0 di generazione dell'Issuer, indicata nella token policy '" + policyNegoziazioneToken.getName() + "', ";
                if (this.applicativoRichiedente == null) {
                    throw new TokenException(prefixError + ERRORE_RICHIEDE_AUTENTICAZIONE_IDENTIFICAZIONE_APPLICATIVO);
                }
                clientIdApplicativoModI = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)this.applicativoRichiedente.getProtocolPropertyList(), (String)"modipaSecurityTokenClientId");
                if (clientIdApplicativoModI == null || StringUtils.isEmpty((String)clientIdApplicativoModI)) {
                    throw new TokenException(prefixError + "non \u00e8 utilizzabile con l'applicativo identificato '" + idApp + "': nella configurazione dell'applicativo non \u00e8 stato definito un 'Identificativo' nella sezione 'Authorization OAuth'");
                }
                this.signedJwtIssuer = clientIdApplicativoModI;
            } else if (policyNegoziazioneToken.isJwtIssuerFruizioneModI()) {
                String prefixError = "La modalit\u00e0 di generazione dell'Issuer, indicata nella token policy '" + policyNegoziazioneToken.getName() + "', ";
                if (this.idFruizione == null) {
                    throw new TokenException(prefixError + ERRORE_RICHIEDE_IDENTIFICAZIONE_DATI_FRUIZIONE);
                }
                clientIdFruizioneModI = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolPropertiesFruizione, (String)"modipaSecurityOauthId");
                if (clientIdFruizioneModI == null || StringUtils.isEmpty((String)clientIdFruizioneModI)) {
                    throw new TokenException(prefixError + "non \u00e8 utilizzabile con la fruizione '" + idFruizioneLabel + "': nella configurazione 'ModI' non \u00e8 stato definito un 'Identificativo Token ClientId'");
                }
                this.signedJwtIssuer = clientIdFruizioneModI;
            } else {
                this.signedJwtIssuer = policyNegoziazioneToken.getJwtIssuer();
            }
            if (this.signedJwtIssuer != null && !"".equals(this.signedJwtIssuer) && !"${undefined}".equals(this.signedJwtIssuer)) {
                this.signedJwtIssuer = DynamicUtils.convertDynamicPropertyValue("issuer.gwt", this.signedJwtIssuer, dynamicMap, pddContext);
            }
            if (policyNegoziazioneToken.isJwtClientIdApplicativoModI()) {
                if (clientIdApplicativoModI == null) {
                    String prefixError = "La modalit\u00e0 di generazione del Client ID, indicata nella token policy '" + policyNegoziazioneToken.getName() + "', ";
                    if (this.applicativoRichiedente == null) {
                        throw new TokenException(prefixError + ERRORE_RICHIEDE_AUTENTICAZIONE_IDENTIFICAZIONE_APPLICATIVO);
                    }
                    String clientId = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)this.applicativoRichiedente.getProtocolPropertyList(), (String)"modipaSecurityTokenClientId");
                    if (clientId == null || StringUtils.isEmpty((String)clientId)) {
                        throw new TokenException(prefixError + "non \u00e8 utilizzabile con l'applicativo identificato '" + idApp + "': nella configurazione dell'applicativo non \u00e8 stato definito un 'Identificativo' nella sezione 'Authorization OAuth'");
                    }
                    clientIdApplicativoModI = clientId;
                }
                this.signedJwtClientId = clientIdApplicativoModI;
            } else if (policyNegoziazioneToken.isJwtClientIdFruizioneModI()) {
                if (clientIdFruizioneModI == null) {
                    String prefixError = "La modalit\u00e0 di generazione del Client ID, indicata nella token policy '" + policyNegoziazioneToken.getName() + "', ";
                    if (this.idFruizione == null) {
                        throw new TokenException(prefixError + ERRORE_RICHIEDE_IDENTIFICAZIONE_DATI_FRUIZIONE);
                    }
                    String clientId = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolPropertiesFruizione, (String)"modipaSecurityOauthId");
                    if (clientId == null || StringUtils.isEmpty((String)clientId)) {
                        throw new TokenException(prefixError + "non \u00e8 utilizzabile con la fruizione '" + idFruizioneLabel + "': nella configurazione 'ModI' non \u00e8 stato definito un 'Identificativo Token ClientId'");
                    }
                    clientIdFruizioneModI = clientId;
                }
                this.signedJwtClientId = clientIdFruizioneModI;
            } else {
                this.signedJwtClientId = policyNegoziazioneToken.getJwtClientId();
            }
            if (this.signedJwtClientId != null && !"".equals(this.signedJwtClientId) && !"${undefined}".equals(this.signedJwtClientId)) {
                this.signedJwtClientId = DynamicUtils.convertDynamicPropertyValue("clientId.gwt", this.signedJwtClientId, dynamicMap, pddContext);
            }
            if (policyNegoziazioneToken.isJwtSubjectApplicativoModI()) {
                if (clientIdApplicativoModI == null) {
                    String prefixError = "La modalit\u00e0 di generazione del Subject, indicata nella token policy '" + policyNegoziazioneToken.getName() + "', ";
                    if (this.applicativoRichiedente == null) {
                        throw new TokenException(prefixError + ERRORE_RICHIEDE_AUTENTICAZIONE_IDENTIFICAZIONE_APPLICATIVO);
                    }
                    String clientId = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)this.applicativoRichiedente.getProtocolPropertyList(), (String)"modipaSecurityTokenClientId");
                    if (clientId == null || StringUtils.isEmpty((String)clientId)) {
                        throw new TokenException(prefixError + "non \u00e8 utilizzabile con l'applicativo identificato '" + idApp + "': nella configurazione dell'applicativo non \u00e8 stato definito un 'Identificativo' nella sezione 'Authorization OAuth'");
                    }
                    clientIdApplicativoModI = clientId;
                }
                this.signedJwtSubject = clientIdApplicativoModI;
            } else if (policyNegoziazioneToken.isJwtSubjectFruizioneModI()) {
                if (clientIdFruizioneModI == null) {
                    String prefixError = "La modalit\u00e0 di generazione del Subject, indicata nella token policy '" + policyNegoziazioneToken.getName() + "', ";
                    if (this.idFruizione == null) {
                        throw new TokenException(prefixError + ERRORE_RICHIEDE_IDENTIFICAZIONE_DATI_FRUIZIONE);
                    }
                    String clientId = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolPropertiesFruizione, (String)"modipaSecurityOauthId");
                    if (clientId == null || StringUtils.isEmpty((String)clientId)) {
                        throw new TokenException(prefixError + "non \u00e8 utilizzabile con la fruizione '" + idFruizioneLabel + "': nella configurazione 'ModI' non \u00e8 stato definito un 'Identificativo Token ClientId'");
                    }
                    clientIdFruizioneModI = clientId;
                }
                this.signedJwtSubject = clientIdFruizioneModI;
            } else {
                this.signedJwtSubject = policyNegoziazioneToken.getJwtSubject();
            }
            if (this.signedJwtSubject != null && !"".equals(this.signedJwtSubject) && !"${undefined}".equals(this.signedJwtSubject)) {
                this.signedJwtSubject = DynamicUtils.convertDynamicPropertyValue("subject.gwt", this.signedJwtSubject, dynamicMap, pddContext);
            }
            this.signedJwtAudience = policyNegoziazioneToken.getJwtAudience();
            if (this.signedJwtAudience != null && !"".equals(this.signedJwtAudience) && !"${undefined}".equals(this.signedJwtAudience)) {
                this.signedJwtAudience = DynamicUtils.convertDynamicPropertyValue("jwtAudience.gwt", this.signedJwtAudience, dynamicMap, pddContext);
            }
            this.signedJwtJti = policyNegoziazioneToken.getJwtIdentifier();
            if (this.signedJwtJti != null && !"".equals(this.signedJwtJti) && !"${undefined}".equals(this.signedJwtJti)) {
                this.signedJwtJti = DynamicUtils.convertDynamicPropertyValue("jti.gwt", this.signedJwtJti, dynamicMap, pddContext);
            }
            if (policyNegoziazioneToken.isPDND()) {
                this.signedJwtPurposeId = policyNegoziazioneToken.getJwtPurposeId();
                if (this.signedJwtPurposeId != null && !"".equals(this.signedJwtPurposeId) && !"${undefined}".equals(this.signedJwtPurposeId)) {
                    this.signedJwtPurposeId = DynamicUtils.convertDynamicPropertyValue("jwtPurposeId.gwt", this.signedJwtPurposeId, dynamicMap, pddContext);
                }
                this.signedJwtSessionInfo = policyNegoziazioneToken.getJwtSessionInfo();
                if (this.signedJwtSessionInfo != null && !"".equals(this.signedJwtSessionInfo)) {
                    this.signedJwtSessionInfo = DynamicUtils.convertDynamicPropertyValue("sessionInfo.gwt", this.signedJwtSessionInfo, dynamicMap, pddContext);
                }
            }
            this.signedJwtClaims = policyNegoziazioneToken.getJwtClaims();
            if (this.signedJwtClaims != null && !"".equals(this.signedJwtClaims)) {
                this.signedJwtClaims = DynamicUtils.convertDynamicPropertyValue("claims.gwt", this.signedJwtClaims, dynamicMap, pddContext);
            }
            if (this.getPddContext() != null && this.getPddContext().containsKey(Costanti.MODIPA_CONTEXT_AUDIT_DIGEST)) {
                this.signedJwtAuditDigest = (String)this.getPddContext().get(Costanti.MODIPA_CONTEXT_AUDIT_DIGEST);
            }
            if (this.getPddContext() != null && this.getPddContext().containsKey(Costanti.MODIPA_CONTEXT_AUDIT_DIGEST_ALGO)) {
                this.signedJwtAuditDigestAlgo = (String)this.getPddContext().get(Costanti.MODIPA_CONTEXT_AUDIT_DIGEST_ALGO);
            }
            this.signedJwtCustomId = policyNegoziazioneToken.getJwtSignIncludeKeyIdCustom();
            if (this.signedJwtCustomId != null && !"".equals(this.signedJwtCustomId)) {
                this.signedJwtCustomId = DynamicUtils.convertDynamicPropertyValue("kid.customId.gwt", this.signedJwtCustomId, dynamicMap, pddContext);
            }
            this.signedJwtX509Url = policyNegoziazioneToken.getJwtSignIncludeX509URL();
            if (this.signedJwtX509Url != null && !"".equals(this.signedJwtX509Url)) {
                this.signedJwtX509Url = DynamicUtils.convertDynamicPropertyValue("url-x5u.gwt", this.signedJwtX509Url, dynamicMap, pddContext);
            }
        }
        this.scope = policyNegoziazioneToken.getScopeString();
        if (this.scope != null && !"".equals(this.scope)) {
            this.scope = DynamicUtils.convertDynamicPropertyValue("scopes.gwt", this.scope, dynamicMap, pddContext);
        }
        this.audience = policyNegoziazioneToken.getAudience();
        if (this.audience != null && !"".equals(this.audience)) {
            this.audience = DynamicUtils.convertDynamicPropertyValue("aud.gwt", this.audience, dynamicMap, pddContext);
        }
        if (policyNegoziazioneToken.isPDND()) {
            if (policyNegoziazioneToken.isFormClientIdApplicativoModI()) {
                if (clientIdApplicativoModI == null) {
                    String prefixError = "La modalit\u00e0 di generazione del Client ID nei dati della richiesta, indicata nella token policy '" + policyNegoziazioneToken.getName() + "', ";
                    if (this.applicativoRichiedente == null) {
                        throw new TokenException(prefixError + ERRORE_RICHIEDE_AUTENTICAZIONE_IDENTIFICAZIONE_APPLICATIVO);
                    }
                    String clientId = ProtocolPropertiesUtils.getOptionalStringValuePropertyConfig((List)this.applicativoRichiedente.getProtocolPropertyList(), (String)"modipaSecurityTokenClientId");
                    if (clientId == null || StringUtils.isEmpty((String)clientId)) {
                        throw new TokenException(prefixError + "non \u00e8 utilizzabile con l'applicativo identificato '" + idApp + "': nella configurazione dell'applicativo non \u00e8 stato definito un 'Identificativo' nella sezione 'Authorization OAuth'");
                    }
                    clientIdApplicativoModI = clientId;
                }
                this.formClientId = clientIdApplicativoModI;
            } else if (policyNegoziazioneToken.isFormClientIdFruizioneModI()) {
                if (clientIdFruizioneModI == null) {
                    String prefixError = "La modalit\u00e0 di generazione del Client ID nei dati della richiesta, indicata nella token policy '" + policyNegoziazioneToken.getName() + "', ";
                    if (this.idFruizione == null) {
                        throw new TokenException(prefixError + ERRORE_RICHIEDE_IDENTIFICAZIONE_DATI_FRUIZIONE);
                    }
                    String clientId = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolPropertiesFruizione, (String)"modipaSecurityOauthId");
                    if (clientId == null || StringUtils.isEmpty((String)clientId)) {
                        throw new TokenException(prefixError + "non \u00e8 utilizzabile con la fruizione '" + idFruizioneLabel + "': nella configurazione 'ModI' non \u00e8 stato definito un 'Identificativo Token ClientId'");
                    }
                    clientIdFruizioneModI = clientId;
                }
                this.formClientId = clientIdFruizioneModI;
            } else {
                this.formClientId = policyNegoziazioneToken.getFormClientId();
                if (this.formClientId == null || "".equals(this.formClientId)) {
                    this.formClientId = policyNegoziazioneToken.getJwtClientId();
                }
            }
            if (this.formClientId != null && !"".equals(this.formClientId) && !"${undefined}".equals(this.formClientId)) {
                this.formClientId = DynamicUtils.convertDynamicPropertyValue("formClientId.gwt", this.formClientId, dynamicMap, pddContext);
            }
            this.formResource = policyNegoziazioneToken.getFormResource();
            if (this.formResource != null && !"".equals(this.formResource) && !"${undefined}".equals(this.formResource)) {
                this.formResource = DynamicUtils.convertDynamicPropertyValue("formResource.gwt", this.formResource, dynamicMap, pddContext);
            }
        }
        this.parameters = policyNegoziazioneToken.getFormParameters();
        if (this.parameters != null && !"".equals(this.parameters)) {
            this.parameters = DynamicUtils.convertDynamicPropertyValue("parameters.gwt", this.parameters, dynamicMap, pddContext);
        }
        if ((sHttpMethod = policyNegoziazioneToken.getHttpMethod()) != null && !"".equals(sHttpMethod)) {
            this.httpMethod = HttpRequestMethod.valueOf((String)sHttpMethod);
        }
        this.httpContentType = policyNegoziazioneToken.getHttpContentType();
        if (this.httpContentType != null && !"".equals(this.httpContentType)) {
            this.httpContentType = DynamicUtils.convertDynamicPropertyValue("httpContentType.gwt", this.httpContentType, dynamicMap, pddContext);
        }
        this.httpHeaders = policyNegoziazioneToken.getHttpHeaders();
        if (this.httpHeaders != null && !"".equals(this.httpHeaders)) {
            this.httpHeaders = DynamicUtils.convertDynamicPropertyValue("httpHeaders.gwt", this.httpHeaders, dynamicMap, pddContext);
        }
        this.httpPayloadTemplateType = policyNegoziazioneToken.getDynamicPayloadType();
        if (this.httpPayloadTemplateType != null && !"".equals(this.httpPayloadTemplateType) && (httpPayloadDynamic = policyNegoziazioneToken.getDynamicPayload()) != null && !"".equals(httpPayloadDynamic)) {
            Template template;
            if (policyNegoziazioneToken.isDynamicPayloadTemplate()) {
                this.httpPayload = DynamicUtils.convertDynamicPropertyValue("httpPayload.gwt", httpPayloadDynamic, dynamicMap, pddContext);
            } else if (policyNegoziazioneToken.isDynamicPayloadFreemarkerTemplate()) {
                ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(state);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    template = configurazionePdDManager.getTemplatePolicyNegoziazioneRequest(policyNegoziazioneToken.getName(), httpPayloadDynamic.getBytes(), requestInfo);
                    DynamicUtils.convertFreeMarkerTemplate(template, dynamicMap, bout);
                    bout.flush();
                    bout.close();
                }
                catch (Exception e) {
                    throw new TokenException(e.getMessage(), e);
                }
                this.httpPayload = bout.toString();
            } else if (policyNegoziazioneToken.isDynamicPayloadVelocityTemplate()) {
                ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(state);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    template = configurazionePdDManager.getTemplatePolicyNegoziazioneRequest(policyNegoziazioneToken.getName(), httpPayloadDynamic.getBytes(), requestInfo);
                    DynamicUtils.convertVelocityTemplate(template, dynamicMap, bout);
                    bout.flush();
                    bout.close();
                }
                catch (Exception e) {
                    throw new TokenException(e.getMessage(), e);
                }
                this.httpPayload = bout.toString();
            }
        }
    }

    @Override
    protected String toStringRepresentation() {
        return null;
    }

    @Override
    public String toString() {
        return this.toString("\n", false);
    }

    public String toString(String separator, boolean cacheKey) {
        StringBuilder sb = new StringBuilder();
        String superS = super.toString();
        if (StringUtils.isNotEmpty((String)superS)) {
            sb.append(superS);
        }
        if (cacheKey) {
            NegoziazioneTokenDynamicParameters.checkInitCacheKey();
        }
        if (StringUtils.isNotEmpty((String)this.endpoint)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("endpoint:").append(this.endpoint);
        }
        if (StringUtils.isNotEmpty((String)this.basicUsername)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("user:").append(this.basicUsername);
        }
        if (StringUtils.isNotEmpty((String)this.basicPassword) && !cacheKey) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("password:").append(this.basicPassword);
        }
        if (StringUtils.isNotEmpty((String)this.bearerToken)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("token:").append(this.bearerToken);
        }
        if (StringUtils.isNotEmpty((String)this.usernamePasswordGrantUsername)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("usernamePasswordGrant_username:").append(this.usernamePasswordGrantUsername);
        }
        if (StringUtils.isNotEmpty((String)this.usernamePasswordGrantPassword) && !cacheKey) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("usernamePasswordGrant_password:").append(this.usernamePasswordGrantPassword);
        }
        if (StringUtils.isNotEmpty((String)this.signedJwtIssuer) && (!cacheKey || signedJwtIssuerCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("iss:").append(this.signedJwtIssuer);
        }
        if (StringUtils.isNotEmpty((String)this.signedJwtClientId) && (!cacheKey || signedJwtClientIdCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("clientId:").append(this.signedJwtClientId);
        }
        if (StringUtils.isNotEmpty((String)this.signedJwtSubject) && (!cacheKey || signedJwtSubjectCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("sub:").append(this.signedJwtSubject);
        }
        if (StringUtils.isNotEmpty((String)this.signedJwtAudience) && (!cacheKey || signedJwtAudienceCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("aud:").append(this.signedJwtAudience);
        }
        if (StringUtils.isNotEmpty((String)this.signedJwtJti) && (!cacheKey || signedJwtJtiCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("jti:").append(this.signedJwtJti);
        }
        if (StringUtils.isNotEmpty((String)this.signedJwtPurposeId) && (!cacheKey || signedJwtPurposeIdCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("purposeId:").append(this.signedJwtPurposeId);
        }
        if (StringUtils.isNotEmpty((String)this.signedJwtSessionInfo) && (!cacheKey || signedJwtSessionInfoCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("sInfo:").append(this.signedJwtSessionInfo);
        }
        if (StringUtils.isNotEmpty((String)this.signedJwtClaims) && (!cacheKey || signedJwtClaimsCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("claims:").append(this.signedJwtClaims);
        }
        if (StringUtils.isNotEmpty((String)this.signedJwtAuditDigest) && (!cacheKey || signedJwtAuditDigestCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("auditDigest:").append(this.signedJwtAuditDigest);
        }
        if (StringUtils.isNotEmpty((String)this.signedJwtAuditDigestAlgo) && (!cacheKey || signedJwtAuditDigestCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("auditDigestAlgo:").append(this.signedJwtAuditDigestAlgo);
        }
        if (StringUtils.isNotEmpty((String)this.signedJwtCustomId) && (!cacheKey || signedJwtCustomIdCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("kid:").append(this.signedJwtCustomId);
        }
        if (StringUtils.isNotEmpty((String)this.signedJwtX509Url) && (!cacheKey || signedJwtX509UrlCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("x5u:").append(this.signedJwtX509Url);
        }
        if (StringUtils.isNotEmpty((String)this.scope) && (!cacheKey || scopeCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("scope:").append(this.scope);
        }
        if (StringUtils.isNotEmpty((String)this.audience) && (!cacheKey || audienceCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("formAudience:").append(this.audience);
        }
        if (StringUtils.isNotEmpty((String)this.formClientId) && (!cacheKey || formClientIdCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("formClientId:").append(this.formClientId);
        }
        if (StringUtils.isNotEmpty((String)this.formResource) && (!cacheKey || formResourceCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("formResource:").append(this.formResource);
        }
        if (StringUtils.isNotEmpty((String)this.parameters) && (!cacheKey || parametersCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("parameters:").append(this.parameters);
        }
        if (this.httpMethod != null && (!cacheKey || httpMethodCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("httpMethod:").append(this.httpMethod.name());
        }
        if (StringUtils.isNotEmpty((String)this.httpContentType) && (!cacheKey || httpContentTypeCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("httpContentType:").append(this.httpContentType);
        }
        if (StringUtils.isNotEmpty((String)this.httpHeaders) && (!cacheKey || httpHeadersCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("httpHeaders:").append(this.httpHeaders);
        }
        if (StringUtils.isNotEmpty((String)this.httpPayloadTemplateType) && (!cacheKey || httpPayloadTemplateTypeCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("httpPayloadTemplateType:").append(this.httpPayloadTemplateType);
        }
        if (StringUtils.isNotEmpty((String)this.httpPayload) && (!cacheKey || httpPayloadCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("httpPayload:").append(this.httpPayload);
        }
        if (this.idApplicativoRichiedente != null && (!cacheKey || applicativoRichiedenteCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("applicativeRequester:").append(this.idApplicativoRichiedente.toFormatString());
        }
        if (this.keystoreDPoPApplicativoModI != null && (!cacheKey || dpopKeystoreApplicativoCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("dpopKeystoreApplicativeRequester:").append(NegoziazioneTokenDynamicParameters.getDPoPKeystoreCacheKeyValue(this.keystoreDPoPApplicativoModI));
        }
        if (this.idFruizione != null && (!cacheKey || fruizioneCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("outbound:").append(this.idFruizione.toFormatString());
        }
        if (this.keystoreDPoPFruizioneModI != null && (!cacheKey || dpopKeystoreFruizioneCacheKey)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append("dpopKeystoreOutboundInterface:").append(NegoziazioneTokenDynamicParameters.getDPoPKeystoreCacheKeyValue(this.keystoreDPoPFruizioneModI));
        }
        return sb.toString();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getBasicUsername() {
        return this.basicUsername;
    }

    public String getBasicPassword() {
        return this.basicPassword;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public String getUsernamePasswordGrantUsername() {
        return this.usernamePasswordGrantUsername;
    }

    public String getUsernamePasswordGrantPassword() {
        return this.usernamePasswordGrantPassword;
    }

    public String getSignedJwtIssuer() {
        return this.signedJwtIssuer;
    }

    public String getSignedJwtClientId() {
        return this.signedJwtClientId;
    }

    public String getSignedJwtSubject() {
        return this.signedJwtSubject;
    }

    public String getSignedJwtAudience() {
        return this.signedJwtAudience;
    }

    public String getSignedJwtJti() {
        return this.signedJwtJti;
    }

    public String getSignedJwtPurposeId() {
        return this.signedJwtPurposeId;
    }

    public String getSignedJwtSessionInfo() {
        return this.signedJwtSessionInfo;
    }

    public String getSignedJwtClaims() {
        return this.signedJwtClaims;
    }

    public String getSignedJwtAuditDigest() {
        return this.signedJwtAuditDigest;
    }

    public String getSignedJwtAuditDigestAlgo() {
        return this.signedJwtAuditDigestAlgo;
    }

    public String getSignedJwtCustomId() {
        return this.signedJwtCustomId;
    }

    public String getSignedJwtX509Url() {
        return this.signedJwtX509Url;
    }

    public String getScope() {
        return this.scope;
    }

    public String getAudience() {
        return this.audience;
    }

    public String getFormClientId() {
        return this.formClientId;
    }

    public String getFormResource() {
        return this.formResource;
    }

    public String getParameters() {
        return this.parameters;
    }

    public HttpRequestMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getHttpContentType() {
        return this.httpContentType;
    }

    public String getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getHttpPayloadTemplateType() {
        return this.httpPayloadTemplateType;
    }

    public String getHttpPayload() {
        return this.httpPayload;
    }

    public IDServizioApplicativo getIdApplicativoRichiedente() {
        return this.idApplicativoRichiedente;
    }

    public ServizioApplicativo getApplicativoRichiedente() {
        return this.applicativoRichiedente;
    }

    public String getKidApplicativoModI() {
        return this.kidApplicativoModI;
    }

    public String getTipoKeystoreApplicativoModI() {
        return this.keystoreApplicativoModI.getSecurityMessageKeystoreType();
    }

    public boolean isByokPolicyDefinedApplicativoModI() {
        return BYOKProvider.isPolicyDefined((String)this.keystoreApplicativoModI.getSecurityMessageKeystoreByokPolicy());
    }

    public KeyPairStore getKeyPairStoreApplicativoModI(Map<String, Object> dynamicMap) throws TokenException, SecurityException {
        String keystoreFile = this.keystoreApplicativoModI.getSecurityMessageKeystorePath();
        if (keystoreFile == null) {
            throw new TokenException("JWT Signature private key file undefined");
        }
        String keystoreFilePublicKey = this.keystoreApplicativoModI.getSecurityMessageKeystorePathPublicKey();
        if (keystoreFilePublicKey == null) {
            throw new TokenException("JWT Signature public key file undefined");
        }
        String keyPairAlgorithm = null;
        String signAlgo = null;
        if (this.policyNegoziazioneToken.isJwtSignKeystoreApplicativoModI()) {
            signAlgo = this.policyNegoziazioneToken.getJwtSignAlgorithm();
        } else if (this.policyNegoziazioneToken.isDpopSignKeystoreApplicativoModI()) {
            signAlgo = this.policyNegoziazioneToken.getDpopSignAlgorithm();
        }
        if (signAlgo != null) {
            keyPairAlgorithm = SignatureAlgorithmUtilities.covertToKeyPairAlgorithm((String)signAlgo);
        }
        if (keyPairAlgorithm == null) {
            keyPairAlgorithm = this.keystoreApplicativoModI.getSecurityMessageKeystoreKeyAlgorithm();
        }
        if (keyPairAlgorithm == null) {
            throw new TokenException("JWT Signature key pair algorithm undefined");
        }
        String keyPassword = this.keystoreApplicativoModI.getSecurityMessageKeyPassword();
        String keystoreByokPolicy = this.keystoreApplicativoModI.getSecurityMessageKeystoreByokPolicy();
        BYOKRequestParams byokParams = this.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
        return GestoreKeystoreCache.getKeyPairStore((RequestInfo)this.getRequestInfo(), (String)keystoreFile, (String)keystoreFilePublicKey, (String)keyPassword, (String)keyPairAlgorithm, (BYOKRequestParams)byokParams);
    }

    public JWKSetStore getJWKSetStoreApplicativoModI(Map<String, Object> dynamicMap) throws TokenException, SecurityException {
        String keystoreFile = this.keystoreApplicativoModI.getSecurityMessageKeystorePath();
        if (keystoreFile == null) {
            throw new TokenException("JWT Signature keystore file undefined");
        }
        String keystoreByokPolicy = this.keystoreApplicativoModI.getSecurityMessageKeystoreByokPolicy();
        BYOKRequestParams byokParams = this.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
        return GestoreKeystoreCache.getJwkSetStore((RequestInfo)this.getRequestInfo(), (String)keystoreFile, (BYOKRequestParams)byokParams);
    }

    public KeyStore getKeystoreApplicativoModI(Map<String, Object> dynamicMap) throws TokenException, SecurityException {
        if (this.keystoreApplicativoModI.getSecurityMessageKeystorePath() != null || this.keystoreApplicativoModI.isSecurityMessageKeystoreHSM()) {
            MerlinKeystore merlinKs;
            String keystoreByokPolicy = this.keystoreApplicativoModI.getSecurityMessageKeystoreByokPolicy();
            BYOKRequestParams byokParams = null;
            if (this.keystoreApplicativoModI.getSecurityMessageKeystorePath() != null) {
                byokParams = this.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
            }
            if ((merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)this.getRequestInfo(), (String)this.keystoreApplicativoModI.getSecurityMessageKeystorePath(), (String)this.keystoreApplicativoModI.getSecurityMessageKeystoreType(), (String)this.keystoreApplicativoModI.getSecurityMessageKeystorePassword(), (BYOKRequestParams)byokParams)) == null) {
                throw new TokenException("Accesso al keystore '" + this.keystoreApplicativoModI.getSecurityMessageKeystorePath() + "' non riuscito");
            }
            return merlinKs.getKeyStore();
        }
        MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)this.getRequestInfo(), (byte[])this.keystoreApplicativoModI.getSecurityMessageKeystoreArchive(), (String)this.keystoreApplicativoModI.getSecurityMessageKeystoreType(), (String)this.keystoreApplicativoModI.getSecurityMessageKeystorePassword());
        if (merlinKs == null) {
            throw new TokenException("Accesso al keystore non riuscito");
        }
        return merlinKs.getKeyStore();
    }

    public String getKeyAliasApplicativoModI() {
        return this.keystoreApplicativoModI.getSecurityMessageKeyAlias();
    }

    public String getKeyPasswordApplicativoModI() {
        return this.keystoreApplicativoModI.getSecurityMessageKeyPassword();
    }

    public boolean hasKeystoreDPoPApplicativoModI() {
        return this.keystoreDPoPApplicativoModI != null;
    }

    public String getTipoKeystoreDPoPApplicativoModI() {
        return this.keystoreDPoPApplicativoModI.getSecurityMessageKeystoreType();
    }

    public boolean isByokPolicyDefinedDPoPApplicativoModI() {
        return BYOKProvider.isPolicyDefined((String)this.keystoreDPoPApplicativoModI.getSecurityMessageKeystoreByokPolicy());
    }

    public KeyPairStore getKeyPairStoreDPoPApplicativoModI(Map<String, Object> dynamicMap) throws TokenException, SecurityException {
        String keystoreFile = this.keystoreDPoPApplicativoModI.getSecurityMessageKeystorePath();
        if (keystoreFile == null) {
            throw new TokenException("DPoP Signature private key file undefined");
        }
        String keystoreFilePublicKey = this.keystoreDPoPApplicativoModI.getSecurityMessageKeystorePathPublicKey();
        if (keystoreFilePublicKey == null) {
            throw new TokenException("DPoP Signature public key file undefined");
        }
        String keyPairAlgorithm = null;
        String signAlgo = null;
        if (this.policyNegoziazioneToken.isDpopSignKeystoreApplicativoModI()) {
            signAlgo = this.policyNegoziazioneToken.getDpopSignAlgorithm();
        }
        if (signAlgo != null) {
            keyPairAlgorithm = SignatureAlgorithmUtilities.covertToKeyPairAlgorithm((String)signAlgo);
        }
        if (keyPairAlgorithm == null) {
            keyPairAlgorithm = this.keystoreDPoPApplicativoModI.getSecurityMessageKeystoreKeyAlgorithm();
        }
        if (keyPairAlgorithm == null) {
            throw new TokenException("DPoP Signature key pair algorithm undefined");
        }
        String keyPassword = this.keystoreDPoPApplicativoModI.getSecurityMessageKeyPassword();
        String keystoreByokPolicy = this.keystoreDPoPApplicativoModI.getSecurityMessageKeystoreByokPolicy();
        BYOKRequestParams byokParams = this.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
        return GestoreKeystoreCache.getKeyPairStore((RequestInfo)this.getRequestInfo(), (String)keystoreFile, (String)keystoreFilePublicKey, (String)keyPassword, (String)keyPairAlgorithm, (BYOKRequestParams)byokParams);
    }

    public JWKSetStore getJWKSetStoreDPoPApplicativoModI(Map<String, Object> dynamicMap) throws TokenException, SecurityException {
        String keystoreFile = this.keystoreDPoPApplicativoModI.getSecurityMessageKeystorePath();
        if (keystoreFile == null) {
            throw new TokenException("DPoP Signature keystore file undefined");
        }
        String keystoreByokPolicy = this.keystoreDPoPApplicativoModI.getSecurityMessageKeystoreByokPolicy();
        BYOKRequestParams byokParams = this.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
        return GestoreKeystoreCache.getJwkSetStore((RequestInfo)this.getRequestInfo(), (String)keystoreFile, (BYOKRequestParams)byokParams);
    }

    public KeyStore getKeystoreDPoPApplicativoModI(Map<String, Object> dynamicMap) throws TokenException, SecurityException {
        if (this.keystoreDPoPApplicativoModI.getSecurityMessageKeystorePath() != null || this.keystoreDPoPApplicativoModI.isSecurityMessageKeystoreHSM()) {
            MerlinKeystore merlinKs;
            String keystoreByokPolicy = this.keystoreDPoPApplicativoModI.getSecurityMessageKeystoreByokPolicy();
            BYOKRequestParams byokParams = null;
            if (this.keystoreDPoPApplicativoModI.getSecurityMessageKeystorePath() != null) {
                byokParams = this.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
            }
            if ((merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)this.getRequestInfo(), (String)this.keystoreDPoPApplicativoModI.getSecurityMessageKeystorePath(), (String)this.keystoreDPoPApplicativoModI.getSecurityMessageKeystoreType(), (String)this.keystoreDPoPApplicativoModI.getSecurityMessageKeystorePassword(), (BYOKRequestParams)byokParams)) == null) {
                throw new TokenException("Accesso al keystore DPoP '" + this.keystoreDPoPApplicativoModI.getSecurityMessageKeystorePath() + "' non riuscito");
            }
            return merlinKs.getKeyStore();
        }
        MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)this.getRequestInfo(), (byte[])this.keystoreDPoPApplicativoModI.getSecurityMessageKeystoreArchive(), (String)this.keystoreDPoPApplicativoModI.getSecurityMessageKeystoreType(), (String)this.keystoreDPoPApplicativoModI.getSecurityMessageKeystorePassword());
        if (merlinKs == null) {
            throw new TokenException("Accesso al keystore DPoP non riuscito");
        }
        return merlinKs.getKeyStore();
    }

    public String getKeyAliasDPoPApplicativoModI() {
        return this.keystoreDPoPApplicativoModI.getSecurityMessageKeyAlias();
    }

    public String getKeyPasswordDPoPApplicativoModI() {
        return this.keystoreDPoPApplicativoModI.getSecurityMessageKeyPassword();
    }

    public IDFruizione getIdFruizione() {
        return this.idFruizione;
    }

    public String getKidFruizioneModI() {
        return this.kidFruizioneModI;
    }

    public String getTipoKeystoreFruizioneModI() {
        return this.keystoreFruizioneModI.getSecurityMessageKeystoreType();
    }

    public boolean isByokPolicyDefinedFruizioneModI() {
        return BYOKProvider.isPolicyDefined((String)this.keystoreFruizioneModI.getSecurityMessageKeystoreByokPolicy());
    }

    public KeyPairStore getKeyPairStoreFruizioneModI(Map<String, Object> dynamicMap) throws TokenException, SecurityException {
        String keystoreFile = this.keystoreFruizioneModI.getSecurityMessageKeystorePath();
        if (keystoreFile == null) {
            throw new TokenException("JWT Signature private key file undefined");
        }
        String keystoreFilePublicKey = this.keystoreFruizioneModI.getSecurityMessageKeystorePathPublicKey();
        if (keystoreFilePublicKey == null) {
            throw new TokenException("JWT Signature public key file undefined");
        }
        String keyPairAlgorithm = null;
        String signAlgo = null;
        if (this.policyNegoziazioneToken.isJwtSignKeystoreFruizioneModI()) {
            signAlgo = this.policyNegoziazioneToken.getJwtSignAlgorithm();
        } else if (this.policyNegoziazioneToken.isDpopSignKeystoreFruizioneModI()) {
            signAlgo = this.policyNegoziazioneToken.getDpopSignAlgorithm();
        }
        if (signAlgo != null) {
            keyPairAlgorithm = SignatureAlgorithmUtilities.covertToKeyPairAlgorithm((String)signAlgo);
        }
        if (keyPairAlgorithm == null) {
            keyPairAlgorithm = this.keystoreFruizioneModI.getSecurityMessageKeystoreKeyAlgorithm();
        }
        if (keyPairAlgorithm == null) {
            throw new TokenException("JWT Signature key pair algorithm undefined");
        }
        String keyPassword = this.keystoreFruizioneModI.getSecurityMessageKeyPassword();
        String keystoreByokPolicy = this.keystoreFruizioneModI.getSecurityMessageKeystoreByokPolicy();
        BYOKRequestParams byokParams = this.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
        return GestoreKeystoreCache.getKeyPairStore((RequestInfo)this.getRequestInfo(), (String)keystoreFile, (String)keystoreFilePublicKey, (String)keyPassword, (String)keyPairAlgorithm, (BYOKRequestParams)byokParams);
    }

    public JWKSetStore getJWKSetStoreFruizioneModI(Map<String, Object> dynamicMap) throws TokenException, SecurityException {
        String keystoreFile = this.keystoreFruizioneModI.getSecurityMessageKeystorePath();
        if (keystoreFile == null) {
            throw new TokenException("JWT Signature keystore file undefined");
        }
        String keystoreByokPolicy = this.keystoreFruizioneModI.getSecurityMessageKeystoreByokPolicy();
        BYOKRequestParams byokParams = this.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
        return GestoreKeystoreCache.getJwkSetStore((RequestInfo)this.getRequestInfo(), (String)keystoreFile, (BYOKRequestParams)byokParams);
    }

    public KeyStore getKeystoreFruizioneModI(Map<String, Object> dynamicMap) throws TokenException, SecurityException {
        if (this.keystoreFruizioneModI.getSecurityMessageKeystorePath() != null || this.keystoreFruizioneModI.isSecurityMessageKeystoreHSM()) {
            MerlinKeystore merlinKs;
            String keystoreByokPolicy = this.keystoreFruizioneModI.getSecurityMessageKeystoreByokPolicy();
            BYOKRequestParams byokParams = null;
            if (this.keystoreFruizioneModI.getSecurityMessageKeystorePath() != null) {
                byokParams = this.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
            }
            if ((merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)this.getRequestInfo(), (String)this.keystoreFruizioneModI.getSecurityMessageKeystorePath(), (String)this.keystoreFruizioneModI.getSecurityMessageKeystoreType(), (String)this.keystoreFruizioneModI.getSecurityMessageKeystorePassword(), (BYOKRequestParams)byokParams)) == null) {
                throw new TokenException("Accesso al keystore '" + this.keystoreFruizioneModI.getSecurityMessageKeystorePath() + "' non riuscito");
            }
            return merlinKs.getKeyStore();
        }
        MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)this.getRequestInfo(), (byte[])this.keystoreFruizioneModI.getSecurityMessageKeystoreArchive(), (String)this.keystoreFruizioneModI.getSecurityMessageKeystoreType(), (String)this.keystoreFruizioneModI.getSecurityMessageKeystorePassword());
        if (merlinKs == null) {
            throw new TokenException("Accesso al keystore non riuscito");
        }
        return merlinKs.getKeyStore();
    }

    public String getKeyAliasFruizioneModI() {
        return this.keystoreFruizioneModI.getSecurityMessageKeyAlias();
    }

    public String getKeyPasswordFruizioneModI() {
        return this.keystoreFruizioneModI.getSecurityMessageKeyPassword();
    }

    public boolean hasKeystoreDPoPFruizioneModI() {
        return this.keystoreDPoPFruizioneModI != null;
    }

    public String getTipoKeystoreDPoPFruizioneModI() {
        return this.keystoreDPoPFruizioneModI.getSecurityMessageKeystoreType();
    }

    public boolean isByokPolicyDefinedDPoPFruizioneModI() {
        return BYOKProvider.isPolicyDefined((String)this.keystoreDPoPFruizioneModI.getSecurityMessageKeystoreByokPolicy());
    }

    public KeyPairStore getKeyPairStoreDPoPFruizioneModI(Map<String, Object> dynamicMap) throws TokenException, SecurityException {
        String keystoreFile = this.keystoreDPoPFruizioneModI.getSecurityMessageKeystorePath();
        if (keystoreFile == null) {
            throw new TokenException("DPoP Signature private key file undefined");
        }
        String keystoreFilePublicKey = this.keystoreDPoPFruizioneModI.getSecurityMessageKeystorePathPublicKey();
        if (keystoreFilePublicKey == null) {
            throw new TokenException("DPoP Signature public key file undefined");
        }
        String keyPairAlgorithm = null;
        String signAlgo = null;
        if (this.policyNegoziazioneToken.isJwtSignKeystoreFruizioneModI()) {
            signAlgo = this.policyNegoziazioneToken.getJwtSignAlgorithm();
        } else if (this.policyNegoziazioneToken.isDpopSignKeystoreFruizioneModI()) {
            signAlgo = this.policyNegoziazioneToken.getDpopSignAlgorithm();
        }
        if (signAlgo != null) {
            keyPairAlgorithm = SignatureAlgorithmUtilities.covertToKeyPairAlgorithm((String)signAlgo);
        }
        if (keyPairAlgorithm == null) {
            keyPairAlgorithm = this.keystoreDPoPFruizioneModI.getSecurityMessageKeystoreKeyAlgorithm();
        }
        if (keyPairAlgorithm == null) {
            throw new TokenException("DPoP Signature key pair algorithm undefined");
        }
        String keyPassword = this.keystoreDPoPFruizioneModI.getSecurityMessageKeyPassword();
        String keystoreByokPolicy = this.keystoreDPoPFruizioneModI.getSecurityMessageKeystoreByokPolicy();
        BYOKRequestParams byokParams = this.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
        return GestoreKeystoreCache.getKeyPairStore((RequestInfo)this.getRequestInfo(), (String)keystoreFile, (String)keystoreFilePublicKey, (String)keyPassword, (String)keyPairAlgorithm, (BYOKRequestParams)byokParams);
    }

    public JWKSetStore getJWKSetStoreDPoPFruizioneModI(Map<String, Object> dynamicMap) throws TokenException, SecurityException {
        String keystoreFile = this.keystoreDPoPFruizioneModI.getSecurityMessageKeystorePath();
        if (keystoreFile == null) {
            throw new TokenException("DPoP Signature keystore file undefined");
        }
        String keystoreByokPolicy = this.keystoreDPoPFruizioneModI.getSecurityMessageKeystoreByokPolicy();
        BYOKRequestParams byokParams = this.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
        return GestoreKeystoreCache.getJwkSetStore((RequestInfo)this.getRequestInfo(), (String)keystoreFile, (BYOKRequestParams)byokParams);
    }

    public KeyStore getKeystoreDPoPFruizioneModI(Map<String, Object> dynamicMap) throws TokenException, SecurityException {
        if (this.keystoreDPoPFruizioneModI.getSecurityMessageKeystorePath() != null || this.keystoreDPoPFruizioneModI.isSecurityMessageKeystoreHSM()) {
            MerlinKeystore merlinKs;
            String keystoreByokPolicy = this.keystoreDPoPFruizioneModI.getSecurityMessageKeystoreByokPolicy();
            BYOKRequestParams byokParams = null;
            if (this.keystoreDPoPFruizioneModI.getSecurityMessageKeystorePath() != null) {
                byokParams = this.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
            }
            if ((merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)this.getRequestInfo(), (String)this.keystoreDPoPFruizioneModI.getSecurityMessageKeystorePath(), (String)this.keystoreDPoPFruizioneModI.getSecurityMessageKeystoreType(), (String)this.keystoreDPoPFruizioneModI.getSecurityMessageKeystorePassword(), (BYOKRequestParams)byokParams)) == null) {
                throw new TokenException("Accesso al keystore DPoP '" + this.keystoreDPoPFruizioneModI.getSecurityMessageKeystorePath() + "' non riuscito");
            }
            return merlinKs.getKeyStore();
        }
        MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)this.getRequestInfo(), (byte[])this.keystoreDPoPFruizioneModI.getSecurityMessageKeystoreArchive(), (String)this.keystoreDPoPFruizioneModI.getSecurityMessageKeystoreType(), (String)this.keystoreDPoPFruizioneModI.getSecurityMessageKeystorePassword());
        if (merlinKs == null) {
            throw new TokenException("Accesso al keystore DPoP non riuscito");
        }
        return merlinKs.getKeyStore();
    }

    public String getKeyAliasDPoPFruizioneModI() {
        return this.keystoreDPoPFruizioneModI.getSecurityMessageKeyAlias();
    }

    public String getKeyPasswordDPoPFruizioneModI() {
        return this.keystoreDPoPFruizioneModI.getSecurityMessageKeyPassword();
    }

    private static String getDPoPKeystoreCacheKeyValue(ModIKeystoreUtils keystoreUtils) {
        if (keystoreUtils.getSecurityMessageKeystorePath() != null) {
            return keystoreUtils.getSecurityMessageKeystorePath();
        }
        if (keystoreUtils.getSecurityMessageKeystoreArchive() != null) {
            try {
                return "archive-sha256:" + DigestUtils.getDigestValue((byte[])keystoreUtils.getSecurityMessageKeystoreArchive(), (String)DigestType.SHA256.getAlgorithmName(), (DigestEncoding)DigestEncoding.HEX);
            }
            catch (Exception e) {
                return "archive-length:" + keystoreUtils.getSecurityMessageKeystoreArchive().length;
            }
        }
        return "unknown";
    }

    private BYOKRequestParams getBYOKRequestParams(String keystoreByokPolicy, Map<String, Object> dynamicMap) throws SecurityException {
        return BYOKUnwrapPolicyUtilities.getBYOKRequestParams(keystoreByokPolicy, dynamicMap);
    }

    static {
        initCacheKey = null;
    }
}

