/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.mvc.properties.Item;
import org.openspcoop2.core.mvc.properties.constants.ItemType;
import org.openspcoop2.core.mvc.properties.provider.ExternalResources;
import org.openspcoop2.core.mvc.properties.provider.IProvider;
import org.openspcoop2.core.mvc.properties.provider.InputValidationUtils;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderInfo;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.TipoTokenRequest;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.parser.IDPoPParser;
import org.openspcoop2.pdd.core.token.parser.IDynamicDiscoveryParser;
import org.openspcoop2.pdd.core.token.parser.ITokenParser;
import org.openspcoop2.pdd.core.token.parser.TipologiaClaims;
import org.openspcoop2.pdd.core.token.parser.TipologiaClaimsDPoP;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.jose.SecurityProvider;
import org.openspcoop2.security.message.utils.AbstractSecurityProvider;
import org.openspcoop2.security.utils.SignatureAlgorithmUtilities;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.certificate.ocsp.OCSPProvider;
import org.openspcoop2.utils.regexp.RegExpUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.SSLUtilities;

public class TokenProvider
implements IProvider {
    private OCSPProvider ocspProvider = new OCSPProvider();
    private BYOKProvider byokProvider;
    private static final String SCONOSCIUTO = "Sconosciuto";
    private static final String NON_SUPPORTATA = "non \u00e8 supportata";
    private static final String NESSUN_TIPO_CONSEGNA = "Nessuna tipo di consegna (header/url), delle informazioni raccolte, indicata";

    public TokenProvider() {
        try {
            this.byokProvider = BYOKProvider.getUnwrapInstance();
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private static final String getPrefixParserType(String parserType) {
        return "\u00c8 stato indicato un parser '" + parserType + "'";
    }

    private static final String getPrefixTipo(String tipo) {
        return "\u00c8 stato indicato un tipo '" + tipo + "'";
    }

    public void validate(Map<String, Properties> mapProperties) throws ProviderException, ProviderValidationException {
        boolean endpointSSL;
        Properties pDefault = TokenUtilities.getDefaultProperties(mapProperties);
        this.validateTokenSource(pDefault);
        String tokenType = this.validateTokenType(pDefault);
        boolean validazione = TokenUtilities.isValidazioneEnabled(pDefault);
        boolean introspection = TokenUtilities.isIntrospectionEnabled(pDefault);
        boolean userInfo = TokenUtilities.isUserInfoEnabled(pDefault);
        boolean dpopValidation = TokenUtilities.isDPoPValidationEnabled(pDefault);
        boolean forward = TokenUtilities.isTokenForwardEnabled(pDefault);
        if (!(validazione || introspection || userInfo || forward)) {
            throw new ProviderValidationException("Almeno una modalit\u00e0 di elaborazione del token deve essere selezionata");
        }
        boolean dynamicDiscovery = TokenUtilities.isDynamicDiscoveryEnabled(pDefault);
        if (dynamicDiscovery) {
            this.validateDynamicDiscovery(mapProperties, pDefault, validazione, introspection, userInfo);
        }
        if (validazione) {
            this.validateValidazioneJWT(mapProperties, pDefault, tokenType, dynamicDiscovery);
        }
        if (dpopValidation) {
            this.validateValidazioneDPoP(pDefault);
        }
        if (endpointSSL = TokenUtilities.isEnabled(pDefault, "policy.endpoint.https.stato")) {
            this.validateEndpointSsl(mapProperties);
        }
        if (introspection) {
            this.validateIntrospection(mapProperties, pDefault, dynamicDiscovery);
        }
        if (userInfo) {
            this.validateUserInfo(mapProperties, pDefault, dynamicDiscovery);
        }
        if (forward) {
            this.validateInformazioniRaccolte(mapProperties, pDefault);
        }
    }

    private void validateTokenSource(Properties pDefault) throws ProviderValidationException {
        String position = pDefault.getProperty("policy.token.source");
        if (position == null) {
            throw new ProviderValidationException("Non \u00e8 stata indicata la posizione del token");
        }
        if (!("RFC6750".equals(position) || "RFC6750_header".equals(position) || "RFC6750_form".equals(position) || "RFC6750_url".equals(position) || "CUSTOM_header".equals(position) || "CUSTOM_url".equals(position))) {
            throw new ProviderValidationException("La posizione del token indicata '" + position + "' non \u00e8 supportata");
        }
        if ("CUSTOM_header".equals(position)) {
            String headerName = pDefault.getProperty("policy.token.source.header");
            if (headerName == null || "".equals(headerName)) {
                throw new ProviderValidationException("Non \u00e8 stato indicato il nome dell'header http che deve contenere il token");
            }
            if (headerName.contains(" ")) {
                throw new ProviderValidationException("Il nome fornito per l'header http che deve contenere il token non deve possedere spazi");
            }
        } else if ("CUSTOM_url".equals(position)) {
            String pName = pDefault.getProperty("policy.token.source.queryParameter");
            if (pName == null) {
                throw new ProviderValidationException("Non \u00e8 stato indicato il nome della propriet\u00e0 della URL che deve contenere il token");
            }
            if (pName.contains(" ")) {
                throw new ProviderValidationException("Il nome fornito per la propriet\u00e0 della URL che deve contenere il token non deve possedere spazi");
            }
        }
    }

    private String validateTokenType(Properties pDefault) throws ProviderValidationException {
        String tokenType = pDefault.getProperty("policy.token.type");
        if (tokenType == null) {
            throw new ProviderValidationException("Non \u00e8 stata indicato il tipo del token");
        }
        if (!("opaque".equals(tokenType) || "jws".equals(tokenType) || "jwe".equals(tokenType))) {
            throw new ProviderValidationException("Il tipo di token indicato '" + tokenType + "' non \u00e8 supportato");
        }
        return tokenType;
    }

    private void validateDynamicDiscovery(Map<String, Properties> mapProperties, Properties pDefault, boolean validazione, boolean introspection, boolean userInfo) throws ProviderValidationException {
        String url = pDefault.getProperty("policy.discovery.endpoint.url");
        InputValidationUtils.validateTextAreaInput((String)url, (String)"Discovery Document - URL");
        try {
            RegExpUtilities.validateUrl((String)url);
        }
        catch (Exception e) {
            throw new ProviderValidationException("La URL fornita per il servizio 'Discovery Document' non \u00e8 valida: " + e.getMessage());
        }
        String dType = pDefault.getProperty("policy.discovery.claimsParser");
        if (dType == null) {
            throw new ProviderValidationException("Discovery Document URL- non \u00e8 stata indicato il tipo");
        }
        TipologiaClaims tc = null;
        try {
            tc = TipologiaClaims.valueOf(dType);
        }
        catch (Exception e) {
            throw new ProviderValidationException("Discovery Document URL- tipo non valido");
        }
        if (TipologiaClaims.MAPPING.equals((Object)tc)) {
            String custom;
            Properties p = mapProperties.get("dynamicDiscoveryParserPropRefId");
            if (p == null || p.size() <= 0) {
                throw new ProviderValidationException("Non \u00e8 stata fornita una configurazione per effettuare il parser personalizzato per il servizio di discovery document");
            }
            if (validazione) {
                custom = p.getProperty("policy.discovery.jwk");
                InputValidationUtils.validateTextAreaInput((String)custom, (String)"Discovery Document URL - JWK Set");
            }
            if (introspection) {
                custom = p.getProperty("policy.discovery.introspection");
                InputValidationUtils.validateTextAreaInput((String)custom, (String)"Discovery Document URL - Introspection");
            }
            if (userInfo) {
                custom = p.getProperty("policy.discovery.userInfo");
                InputValidationUtils.validateTextAreaInput((String)custom, (String)"Discovery Document URL - UserInfo");
            }
        }
    }

    private void validateValidazioneJWT(Map<String, Properties> mapProperties, Properties pDefault, String tokenType, boolean dynamicDiscovery) throws ProviderValidationException {
        if (!"jws".equals(tokenType) && !"jwe".equals(tokenType)) {
            throw new ProviderValidationException("Il tipo di token indicato '" + tokenType + "' non \u00e8 utilizzabile con una validazione JWT");
        }
        if ("jws".equals(tokenType)) {
            this.validateValidazioneJws(mapProperties, pDefault, dynamicDiscovery);
        } else {
            this.validateValidazioneJwe(mapProperties, dynamicDiscovery);
        }
        String parserType = pDefault.getProperty("policy.validazioneJWT.claimsParser");
        if (parserType == null) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il parser per i claims da utilizzare dopo la validazione JWT");
        }
        TipologiaClaims tipologiaClaims = null;
        try {
            tipologiaClaims = TipologiaClaims.valueOf(parserType);
            if (tipologiaClaims == null) {
                throw new ProviderValidationException(SCONOSCIUTO);
            }
        }
        catch (Exception e) {
            throw new ProviderValidationException(TokenProvider.getPrefixParserType(parserType) + ", per i claims da utilizzare dopo la validazione JWT, sconosciuto");
        }
        if (TipologiaClaims.CUSTOM.name().equals(parserType)) {
            this.validateValidazioneJwtCustomParser(pDefault);
        }
    }

    private void validateValidazioneJws(Map<String, Properties> mapProperties, Properties pDefault, boolean dynamicDiscovery) throws ProviderValidationException {
        Properties p = mapProperties.get("signatureVerificationPropRefId");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("Non \u00e8 stata fornita una configurazione per effettuare la validazione JWS");
        }
        if (!p.containsKey("rs.security.keystore") && !p.containsKey("rs.security.keystore.jwkset")) {
            String crl;
            if (!dynamicDiscovery) {
                String file = p.getProperty("rs.security.keystore.file");
                InputValidationUtils.validateTextAreaInput((String)file, (String)"Validazione JWT - TrustStore - Location");
            }
            if ((crl = pDefault.getProperty("signatureCRL")) != null && StringUtils.isNotEmpty((String)crl)) {
                InputValidationUtils.validateTextAreaInput((String)crl, (String)"Validazione JWT - TrustStore - CRL File(s)");
            }
        }
    }

    private void validateValidazioneJwe(Map<String, Properties> mapProperties, boolean dynamicDiscovery) throws ProviderValidationException {
        Properties p = mapProperties.get("decryptionPropRefId");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("Non \u00e8 stata fornita una configurazione per effettuare la validazione JWE");
        }
        if (!(p.containsKey("rs.security.keystore") || p.containsKey("rs.security.keystore.jwkset") || dynamicDiscovery)) {
            String file = p.getProperty("rs.security.keystore.file");
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Validazione JWT - KeyStore - Location");
        }
    }

    private void validateValidazioneJwtCustomParser(Properties pDefault) throws ProviderValidationException {
        String pluginType = pDefault.getProperty("policy.validazioneJWT.claimsParser.pluginType");
        if (pluginType != null && StringUtils.isNotEmpty((String)pluginType) && "-".equals(pluginType)) {
            String className = pDefault.getProperty("policy.validazioneJWT.claimsParser.className");
            if ("-".equals(className)) {
                throw new ProviderValidationException("Deve essere selezionato un plugin per il parser dei claims del token JWT");
            }
            if (className == null || "".equals(className)) {
                throw new ProviderValidationException("Non \u00e8 stata fornita la classe del parser dei claims da utilizzare dopo la validazione JWT");
            }
            if (className.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nella classe del parser dei claims da utilizzare dopo la validazione JWT");
            }
        }
    }

    private void validateValidazioneDPoP(Properties pDefault) throws ProviderValidationException {
        String dpopSource = pDefault.getProperty("policy.dpop.source");
        if (dpopSource == null || "".equals(dpopSource)) {
            throw new ProviderValidationException("Non \u00e8 stata indicata la posizione del DPoP token");
        }
        if ("CUSTOM_header".equals(dpopSource)) {
            String headerName = pDefault.getProperty("policy.dpop.source.header");
            if (headerName == null || "".equals(headerName)) {
                throw new ProviderValidationException("Non \u00e8 stato indicato il nome dell'header HTTP che contiene il DPoP token");
            }
            InputValidationUtils.validateTextAreaInput((String)headerName, (String)"Validazione DPoP - Header HTTP");
        } else if ("CUSTOM_url".equals(dpopSource)) {
            String parameterName = pDefault.getProperty("policy.dpop.source.queryParameter");
            if (parameterName == null || "".equals(parameterName)) {
                throw new ProviderValidationException("Non \u00e8 stato indicato il nome del parametro della URL che contiene il DPoP token");
            }
            InputValidationUtils.validateTextAreaInput((String)parameterName, (String)"Validazione DPoP - Parametro URL");
        }
        String parserType = pDefault.getProperty("policy.validazioneDPoP.claimsParser");
        if (parserType == null || "".equals(parserType)) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il formato del DPoP token");
        }
        try {
            TipologiaClaimsDPoP tipo = TipologiaClaimsDPoP.valueOf(parserType);
            if (tipo == null) {
                throw new ProviderValidationException(SCONOSCIUTO);
            }
        }
        catch (Exception e) {
            throw new ProviderValidationException(TokenProvider.getPrefixParserType(parserType) + ", per i claims da utilizzare dopo la validazione DPoP, sconosciuto");
        }
        if (TipologiaClaimsDPoP.CUSTOM.name().equals(parserType)) {
            this.validateValidazioneDPoPCustomParser(pDefault);
        }
    }

    private void validateValidazioneDPoPCustomParser(Properties pDefault) throws ProviderValidationException {
        String pluginType = pDefault.getProperty("policy.validazioneDPoP.claimsParser.pluginType");
        if (pluginType != null && StringUtils.isNotEmpty((String)pluginType) && "-".equals(pluginType)) {
            String className = pDefault.getProperty("policy.validazioneDPoP.claimsParser.className");
            if ("-".equals(className)) {
                throw new ProviderValidationException("Deve essere selezionato un plugin per il parser dei claims del DPoP token");
            }
            if (className == null || "".equals(className)) {
                throw new ProviderValidationException("Non \u00e8 stata fornita la classe del parser dei claims da utilizzare dopo la validazione DPoP");
            }
            if (className.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nella classe del parser dei claims da utilizzare dopo la validazione DPoP");
            }
        }
    }

    private void validateEndpointSsl(Map<String, Properties> mapProperties) throws ProviderValidationException {
        Properties p = mapProperties.get("sslConfig");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("Nonostante sia stato indicato un endpoint 'https', non \u00e8 stata fornita una configurazione dei parametri ssl da utilizzare");
        }
        String trustAllCerts = p.getProperty("trustAllCerts");
        boolean trustAll = false;
        if (trustAllCerts != null && StringUtils.isNotEmpty((String)trustAllCerts)) {
            trustAll = Boolean.valueOf(trustAllCerts);
        }
        if (!trustAll) {
            String location = p.getProperty("trustStoreLocation");
            InputValidationUtils.validateTextAreaInput((String)location, (String)"Https - Autenticazione Server - Path (TrustStore per l'autenticazione server)");
            String algo = p.getProperty("trustManagementAlgorithm");
            if (algo == null || "".equals(algo)) {
                throw new ProviderValidationException("Indicare un algoritmo per l'autenticazione server");
            }
            if (algo.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nell'algoritmo per l'autenticazione server");
            }
            String locationCRL = p.getProperty("trustStoreCRLs");
            if (locationCRL != null && !"".equals(locationCRL)) {
                InputValidationUtils.validateTextAreaInput((String)locationCRL, (String)"Https - Autenticazione Server - CRL File(s)");
            }
        }
    }

    private void validateIntrospection(Map<String, Properties> mapProperties, Properties pDefault, boolean dynamicDiscovery) throws ProviderValidationException {
        boolean ssl;
        boolean bearer;
        if (!dynamicDiscovery) {
            String url = pDefault.getProperty("policy.introspection.endpoint.url");
            InputValidationUtils.validateTextAreaInput((String)url, (String)"Token Introspection - URL");
            try {
                RegExpUtilities.validateUrl((String)url);
            }
            catch (Exception e) {
                throw new ProviderValidationException("La URL fornita per il servizio 'Introspection' non \u00e8 valida: " + e.getMessage());
            }
        }
        TipoTokenRequest tipoTokenRequestEnum = this.validateIntrospectionTipoToken(pDefault);
        HttpRequestMethod httpRequestMethodEnum = this.validateIntrospectionHttpRequestMethod(pDefault);
        this.validateIntrospectionContentType(pDefault, tipoTokenRequestEnum, httpRequestMethodEnum);
        this.validateIntrospectionParser(pDefault);
        boolean basic = TokenUtilities.isEnabled(pDefault, "policy.introspection.endpoint.basic.stato");
        if (basic) {
            this.validateIntrospectionBasicCredentials(pDefault);
        }
        if (bearer = TokenUtilities.isEnabled(pDefault, "policy.introspection.endpoint.bearer.stato")) {
            String token = pDefault.getProperty("policy.introspection.endpoint.bearer.token");
            InputValidationUtils.validateTextAreaInput((String)token, (String)"Token Introspection - Autenticazione Bearer - Token");
        }
        if (ssl = TokenUtilities.isEnabled(pDefault, "policy.introspection.endpoint.https.stato")) {
            this.validateIntrospectionSslCredentials(mapProperties);
        }
    }

    private TipoTokenRequest validateIntrospectionTipoToken(Properties pDefault) throws ProviderValidationException {
        String tipoTokenRequest = pDefault.getProperty("policy.introspection.requestTokenPosition");
        if (tipoTokenRequest == null) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il tipo di spedizione del token da inoltrare al servizio di Introspection");
        }
        TipoTokenRequest tipoTokenRequestEnum = null;
        try {
            tipoTokenRequestEnum = TipoTokenRequest.valueOf(tipoTokenRequest);
            if (tipoTokenRequestEnum == null) {
                throw new ProviderValidationException(SCONOSCIUTO);
            }
        }
        catch (Exception e) {
            throw new ProviderValidationException(TokenProvider.getPrefixTipo(tipoTokenRequest) + " di spedizione del token da inoltrare al servizio di Introspection sconosciuto");
        }
        this.validateIntrospectionTipoToken(tipoTokenRequestEnum, pDefault);
        return tipoTokenRequestEnum;
    }

    private void validateIntrospectionTipoToken(TipoTokenRequest tipoTokenRequestEnum, Properties pDefault) throws ProviderValidationException {
        switch (tipoTokenRequestEnum) {
            case authorization: {
                break;
            }
            case header: {
                this.validateIntrospectionTipoTokenHeader(pDefault);
                break;
            }
            case url: {
                this.validateIntrospectionTipoTokenUrl(pDefault);
                break;
            }
            case form: {
                this.validateIntrospectionTipoTokenForm(pDefault);
            }
        }
    }

    private void validateIntrospectionTipoTokenHeader(Properties pDefault) throws ProviderValidationException {
        String tmp = pDefault.getProperty("policy.introspection.requestTokenPosition.header");
        if (tmp == null || "".equals(tmp)) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il nome dell'header http su cui inoltrare il token al servizio di Introspection");
        }
        if (tmp.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel nome dell'header http su cui inoltrare il token al servizio di Introspection");
        }
    }

    private void validateIntrospectionTipoTokenUrl(Properties pDefault) throws ProviderValidationException {
        String tmp = pDefault.getProperty("policy.introspection.requestTokenPosition.queryParameter");
        if (tmp == null || "".equals(tmp)) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il nome della propriet\u00e0 della URL su cui inoltrare il token al servizio di Introspection");
        }
        if (tmp.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel nome della propriet\u00e0 della URL su cui inoltrare il token al servizio di Introspection");
        }
    }

    private void validateIntrospectionTipoTokenForm(Properties pDefault) throws ProviderValidationException {
        String tmp = pDefault.getProperty("policy.introspection.requestTokenPosition.formParameter");
        if (tmp == null || "".equals(tmp)) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il nome della propriet\u00e0 della FORM su cui inoltrare il token al servizio di Introspection");
        }
        if (tmp.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel nome della propriet\u00e0 della FORM su cui inoltrare il token al servizio di Introspection");
        }
    }

    private HttpRequestMethod validateIntrospectionHttpRequestMethod(Properties pDefault) throws ProviderValidationException {
        String httpRequestMethod = pDefault.getProperty("policy.introspection.httpMethod");
        if (httpRequestMethod == null) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il tipo di richiesta HTTP da utilizzare per inoltrare il token al servizio di Introspection");
        }
        HttpRequestMethod httpRequestMethodEnum = null;
        try {
            httpRequestMethodEnum = HttpRequestMethod.valueOf((String)httpRequestMethod);
            if (httpRequestMethodEnum == null) {
                throw new ProviderValidationException(SCONOSCIUTO);
            }
        }
        catch (Exception e) {
            throw new ProviderValidationException(TokenProvider.getPrefixTipo(httpRequestMethod) + " di richiesta HTTP da utilizzare per inoltrare il token al servizio di Introspection sconosciuto");
        }
        return httpRequestMethodEnum;
    }

    private void validateIntrospectionContentType(Properties pDefault, TipoTokenRequest tipoTokenRequestEnum, HttpRequestMethod httpRequestMethodEnum) throws ProviderValidationException {
        String contentType = pDefault.getProperty("policy.introspection.contentType");
        if (!TipoTokenRequest.form.equals((Object)tipoTokenRequestEnum) && (HttpRequestMethod.POST.equals((Object)httpRequestMethodEnum) || HttpRequestMethod.PUT.equals((Object)httpRequestMethodEnum) || HttpRequestMethod.PATCH.equals((Object)httpRequestMethodEnum) || HttpRequestMethod.LINK.equals((Object)httpRequestMethodEnum) || HttpRequestMethod.UNLINK.equals((Object)httpRequestMethodEnum)) && (contentType == null || "".equals(contentType))) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il ContentType da utilizzare nella richiesta HTTP prodotta per inoltrare il token al servizio di Introspection");
        }
    }

    private void validateIntrospectionParser(Properties pDefault) throws ProviderValidationException {
        String parserType = pDefault.getProperty("policy.introspection.claimsParser");
        if (parserType == null) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il parser per i claims da utilizzare dopo la validazione tramite il servizio di Introspection");
        }
        TipologiaClaims tipologiaClaims = null;
        try {
            tipologiaClaims = TipologiaClaims.valueOf(parserType);
            if (tipologiaClaims == null) {
                throw new ProviderValidationException(SCONOSCIUTO);
            }
        }
        catch (Exception e) {
            throw new ProviderValidationException(TokenProvider.getPrefixParserType(parserType) + ", per i claims da utilizzare dopo la validazione del servizio di Introspection, sconosciuto");
        }
        if (TipologiaClaims.CUSTOM.name().equals(parserType)) {
            this.validateIntrospectionCustomParser(pDefault);
        }
    }

    private void validateIntrospectionCustomParser(Properties pDefault) throws ProviderValidationException {
        String pluginType = pDefault.getProperty("policy.introspection.claimsParser.pluginType");
        if (pluginType != null && StringUtils.isNotEmpty((String)pluginType) && "-".equals(pluginType)) {
            String className = pDefault.getProperty("policy.introspection.claimsParser.className");
            if ("-".equals(className)) {
                throw new ProviderValidationException("Deve essere selezionato un plugin per il parser dei claims della risposta del servizio Introspection");
            }
            if (className == null || "".equals(className)) {
                throw new ProviderValidationException("Non \u00e8 stata fornita la classe del parser dei claims da utilizzare dopo la validazione del servizio di Introspection");
            }
            if (className.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nella classe del parser dei claims da utilizzare dopo la validazione del servizio di Introspection");
            }
        }
    }

    private void validateIntrospectionBasicCredentials(Properties pDefault) throws ProviderValidationException {
        String username = pDefault.getProperty("policy.introspection.endpoint.basic.username");
        if (username == null || "".equals(username)) {
            throw new ProviderValidationException("Nonostante sia richiesta una autenticazione 'HttpBasic', non \u00e8 stato fornito un username da utilizzare durante la connessione verso il servizio di Introspection");
        }
        if (username.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nell'username da utilizzare durante la connessione verso il servizio di Introspection");
        }
        String password = pDefault.getProperty("policy.introspection.endpoint.basic.password");
        if (password == null || "".equals(password)) {
            throw new ProviderValidationException("Nonostante sia richiesta una autenticazione 'HttpBasic', non \u00e8 stato fornita una password da utilizzare durante la connessione verso il servizio di Introspection");
        }
        if (password.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nella password da utilizzare durante la connessione verso il servizio di Introspection");
        }
    }

    private void validateIntrospectionSslCredentials(Map<String, Properties> mapProperties) throws ProviderValidationException {
        String algo;
        Properties p = mapProperties.get("sslClientConfig");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("Nonostante sia richiesta una autenticazione 'Https', non sono stati forniti i parametri di connessione ssl client da utilizzare verso il servizio di Introspection");
        }
        String location = p.getProperty("keyStoreLocation");
        if (location != null && !"".equals(location)) {
            InputValidationUtils.validateTextAreaInput((String)location, (String)"Https - Autenticazione Client - Path (KeyStore per l'autenticazione client)");
        }
        if ((algo = p.getProperty("keyManagementAlgorithm")) == null || "".equals(algo)) {
            throw new ProviderValidationException("Indicare un algoritmo per l'autenticazione client");
        }
        if (algo.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nell'algoritmo per l'autenticazione client");
        }
    }

    private void validateUserInfo(Map<String, Properties> mapProperties, Properties pDefault, boolean dynamicDiscovery) throws ProviderValidationException {
        boolean ssl;
        boolean bearer;
        if (!dynamicDiscovery) {
            String url = pDefault.getProperty("policy.userInfo.endpoint.url");
            InputValidationUtils.validateTextAreaInput((String)url, (String)"OIDC - UserInfo - URL");
            try {
                RegExpUtilities.validateUrl((String)pDefault.getProperty("policy.userInfo.endpoint.url"));
            }
            catch (Exception e) {
                throw new ProviderValidationException("La URL fornita per il servizio 'OIDC UserInfo' non \u00e8 valida: " + e.getMessage());
            }
        }
        TipoTokenRequest tipoTokenRequestEnum = this.validateUserInfoTipoToken(pDefault);
        HttpRequestMethod httpRequestMethodEnum = this.validateUserInfoHttpRequestMethod(pDefault);
        this.validateUserInfoContentType(pDefault, tipoTokenRequestEnum, httpRequestMethodEnum);
        this.validateUserInfoParser(pDefault);
        boolean basic = TokenUtilities.isEnabled(pDefault, "policy.userInfo.endpoint.basic.stato");
        if (basic) {
            this.validateUserInfoBasicCredentials(pDefault);
        }
        if (bearer = TokenUtilities.isEnabled(pDefault, "policy.userInfo.endpoint.bearer.stato")) {
            String token = pDefault.getProperty("policy.userInfo.endpoint.bearer.token");
            InputValidationUtils.validateTextAreaInput((String)token, (String)"OIDC - UserInfo - Autenticazione Bearer - Token");
        }
        if (ssl = TokenUtilities.isEnabled(pDefault, "policy.userInfo.endpoint.https.stato")) {
            this.validateUserInfoSslCredentials(mapProperties);
        }
    }

    private TipoTokenRequest validateUserInfoTipoToken(Properties pDefault) throws ProviderValidationException {
        String tipoTokenRequest = pDefault.getProperty("policy.userInfo.requestTokenPosition");
        if (tipoTokenRequest == null) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il tipo di spedizione del token da inoltrare al servizio di UserInfo");
        }
        TipoTokenRequest tipoTokenRequestEnum = null;
        try {
            tipoTokenRequestEnum = TipoTokenRequest.valueOf(tipoTokenRequest);
            if (tipoTokenRequestEnum == null) {
                throw new ProviderValidationException(SCONOSCIUTO);
            }
        }
        catch (Exception e) {
            throw new ProviderValidationException(TokenProvider.getPrefixTipo(tipoTokenRequest) + " di spedizione del token da inoltrare al servizio di UserInfo sconosciuto");
        }
        this.validateUserInfoTipoToken(tipoTokenRequestEnum, pDefault);
        return tipoTokenRequestEnum;
    }

    private void validateUserInfoTipoToken(TipoTokenRequest tipoTokenRequestEnum, Properties pDefault) throws ProviderValidationException {
        switch (tipoTokenRequestEnum) {
            case authorization: {
                break;
            }
            case header: {
                this.validateUserInfoTipoTokenHeader(pDefault);
                break;
            }
            case url: {
                this.validateUserInfoTipoTokenUrl(pDefault);
                break;
            }
            case form: {
                this.validateUserInfoTipoTokenFrom(pDefault);
            }
        }
    }

    private void validateUserInfoTipoTokenHeader(Properties pDefault) throws ProviderValidationException {
        String tmp = pDefault.getProperty("policy.userInfo.requestTokenPosition.header");
        if (tmp == null || "".equals(tmp)) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il nome dell'header http su cui inoltrare il token al servizio di UserInfo");
        }
        if (tmp.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel nome dell'header http su cui inoltrare il token al servizio di UserInfo");
        }
    }

    private void validateUserInfoTipoTokenUrl(Properties pDefault) throws ProviderValidationException {
        String tmp = pDefault.getProperty("policy.userInfo.requestTokenPosition.queryParameter");
        if (tmp == null || "".equals(tmp)) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il nome della propriet\u00e0 della URL su cui inoltrare il token al servizio di UserInfo");
        }
        if (tmp.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel nome della propriet\u00e0 della URL su cui inoltrare il token al servizio di UserInfo");
        }
    }

    private void validateUserInfoTipoTokenFrom(Properties pDefault) throws ProviderValidationException {
        String tmp = pDefault.getProperty("policy.userInfo.requestTokenPosition.formParameter");
        if (tmp == null || "".equals(tmp)) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il nome della propriet\u00e0 della FORM su cui inoltrare il token al servizio di UserInfo");
        }
        if (tmp.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel nome della propriet\u00e0 della FORM su cui inoltrare il token al servizio di UserInfo");
        }
    }

    private HttpRequestMethod validateUserInfoHttpRequestMethod(Properties pDefault) throws ProviderValidationException {
        String httpRequestMethod = pDefault.getProperty("policy.userInfo.httpMethod");
        if (httpRequestMethod == null) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il tipo di richiesta HTTP da utilizzare per inoltrare il token al servizio di UserInfo");
        }
        HttpRequestMethod httpRequestMethodEnum = null;
        try {
            httpRequestMethodEnum = HttpRequestMethod.valueOf((String)httpRequestMethod);
            if (httpRequestMethodEnum == null) {
                throw new ProviderValidationException(SCONOSCIUTO);
            }
        }
        catch (Exception e) {
            throw new ProviderValidationException(TokenProvider.getPrefixTipo(httpRequestMethod) + " di richiesta HTTP da utilizzare per inoltrare il token al servizio di UserInfo sconosciuto");
        }
        return httpRequestMethodEnum;
    }

    private void validateUserInfoContentType(Properties pDefault, TipoTokenRequest tipoTokenRequestEnum, HttpRequestMethod httpRequestMethodEnum) throws ProviderValidationException {
        String contentType = pDefault.getProperty("policy.userInfo.contentType");
        if (!TipoTokenRequest.form.equals((Object)tipoTokenRequestEnum) && (HttpRequestMethod.POST.equals((Object)httpRequestMethodEnum) || HttpRequestMethod.PUT.equals((Object)httpRequestMethodEnum) || HttpRequestMethod.PATCH.equals((Object)httpRequestMethodEnum) || HttpRequestMethod.LINK.equals((Object)httpRequestMethodEnum) || HttpRequestMethod.UNLINK.equals((Object)httpRequestMethodEnum)) && (contentType == null || "".equals(contentType))) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il ContentType da utilizzare nella richiesta HTTP prodotta per inoltrare il token al servizio di UserInfo");
        }
    }

    private void validateUserInfoParser(Properties pDefault) throws ProviderValidationException {
        String parserType = pDefault.getProperty("policy.userInfo.claimsParser");
        if (parserType == null) {
            throw new ProviderValidationException("Non \u00e8 stato indicato il parser per i claims da utilizzare dopo la validazione tramite il servizio di UserInfo");
        }
        TipologiaClaims tipologiaClaims = null;
        try {
            tipologiaClaims = TipologiaClaims.valueOf(parserType);
            if (tipologiaClaims == null) {
                throw new ProviderValidationException(SCONOSCIUTO);
            }
        }
        catch (Exception e) {
            throw new ProviderValidationException(TokenProvider.getPrefixParserType(parserType) + ", per i claims da utilizzare dopo la validazione del servizio di UserInfo, sconosciuto");
        }
        if (TipologiaClaims.CUSTOM.name().equals(parserType)) {
            this.validateUserInfoCustomParser(pDefault);
        }
    }

    private void validateUserInfoCustomParser(Properties pDefault) throws ProviderValidationException {
        String pluginType = pDefault.getProperty("policy.userInfo.claimsParser.pluginType");
        if (pluginType != null && StringUtils.isNotEmpty((String)pluginType) && "-".equals(pluginType)) {
            String className = pDefault.getProperty("policy.userInfo.claimsParser.className");
            if ("-".equals(className)) {
                throw new ProviderValidationException("Deve essere selezionato un plugin per il parser dei claims della risposta del servizio UserInfo");
            }
            if (className == null || "".equals(className)) {
                throw new ProviderValidationException("Non \u00e8 stata fornita la classe del parser dei claims da utilizzare dopo la validazione del servizio di UserInfo");
            }
            if (className.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nella classe del parser dei claims da utilizzare dopo la validazione del servizio di UserInfo");
            }
        }
    }

    private void validateUserInfoBasicCredentials(Properties pDefault) throws ProviderValidationException {
        String username = pDefault.getProperty("policy.userInfo.endpoint.basic.username");
        if (username == null || "".equals(username)) {
            throw new ProviderValidationException("Nonostante sia richiesta una autenticazione 'HttpBasic', non \u00e8 stato fornito un username da utilizzare durante la connessione verso il servizio di UserInfo");
        }
        if (username.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nell'username da utilizzare durante la connessione verso il servizio di UserInfo");
        }
        String password = pDefault.getProperty("policy.userInfo.endpoint.basic.password");
        if (password == null || "".equals(password)) {
            throw new ProviderValidationException("Nonostante sia richiesta una autenticazione 'HttpBasic', non \u00e8 stato fornita una password da utilizzare durante la connessione verso il servizio di UserInfo");
        }
        if (password.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nella password da utilizzare durante la connessione verso il servizio di UserInfo");
        }
    }

    private void validateUserInfoSslCredentials(Map<String, Properties> mapProperties) throws ProviderValidationException {
        String algo;
        Properties p = mapProperties.get("sslClientConfig");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("Nonostante sia richiesta una autenticazione 'Https', non sono stati forniti i parametri di connessione ssl client da utilizzare verso il servizio di UserInfo");
        }
        String location = p.getProperty("keyStoreLocation");
        if (location != null && !"".equals(location)) {
            InputValidationUtils.validateTextAreaInput((String)location, (String)"Https - Autenticazione Client - Path (KeyStore per l'autenticazione client)");
        }
        if ((algo = p.getProperty("keyManagementAlgorithm")) == null || "".equals(algo)) {
            throw new ProviderValidationException("Indicare un algoritmo per l'autenticazione client");
        }
        if (algo.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nell'algoritmo per l'autenticazione client");
        }
    }

    private void validateInformazioniRaccolte(Map<String, Properties> mapProperties, Properties pDefault) throws ProviderValidationException {
        boolean forwardTrasparente = TokenUtilities.isEnabled(pDefault, "policy.tokenForward.trasparente.stato");
        boolean forwardInformazioniRaccolte = TokenUtilities.isEnabled(pDefault, "policy.tokenForward.infoRaccolte.stato");
        boolean forwardDPoP = TokenUtilities.isEnabled(pDefault, "policy.tokenForward.dpop.stato");
        if (!(forwardTrasparente || forwardInformazioniRaccolte || forwardDPoP)) {
            throw new ProviderValidationException("Almeno una modalit\u00e0 di forward del token deve essere selezionata");
        }
        if (forwardTrasparente) {
            this.validateInformazioniRaccolteForwardTrasparente(pDefault);
        }
        if (forwardDPoP) {
            this.validateForwardDPoP(pDefault);
        }
        if (forwardInformazioniRaccolte) {
            this.validateInformazioniRaccolteForward(mapProperties, pDefault);
        }
    }

    private void validateForwardDPoP(Properties pDefault) throws ProviderValidationException {
        String mode = pDefault.getProperty("policy.tokenForward.dpop.mode");
        if (mode == null) {
            throw new ProviderValidationException("Nessuna modalit\u00e0 di forward DPoP indicata");
        }
        if (!("asReceived".equals(mode) || "RFC9449_header".equals(mode) || "CUSTOM_header".equals(mode) || "CUSTOM_url".equals(mode))) {
            throw new ProviderValidationException("La modalit\u00e0 di forward DPoP indicata '" + mode + "' non \u00e8 supportata");
        }
        if ("CUSTOM_header".equals(mode)) {
            String hdr = pDefault.getProperty("policy.tokenForward.dpop.mode.header");
            if (hdr == null || "".equals(hdr)) {
                throw new ProviderValidationException("La modalit\u00e0 di forward DPoP indicata prevede l'indicazione del nome di un header http");
            }
            if (hdr.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel nome dell'header HTTP indicato per la modalit\u00e0 di forward DPoP");
            }
        } else if ("CUSTOM_url".equals(mode)) {
            String url = pDefault.getProperty("policy.tokenForward.dpop.mode.queryParameter");
            if (url == null || "".equals(url)) {
                throw new ProviderValidationException("La modalit\u00e0 di forward DPoP indicata prevede l'indicazione del nome di una propriet\u00e0 della url");
            }
            if (url.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel nome della propriet\u00e0 della url indicata per la modalit\u00e0 di forward DPoP");
            }
        }
    }

    private void validateInformazioniRaccolteForwardTrasparente(Properties pDefault) throws ProviderValidationException {
        String mode = pDefault.getProperty("policy.tokenForward.trasparente.mode");
        if (mode == null) {
            throw new ProviderValidationException("Nessuna modalit\u00e0 di forward trasparente indicata");
        }
        if (!("asReceived".equals(mode) || "RFC6750_header".equals(mode) || "RFC6750_url".equals(mode) || "CUSTOM_header".equals(mode) || "CUSTOM_url".equals(mode))) {
            throw new ProviderValidationException("La modalit\u00e0 di forward trasparente indicata '" + mode + "' non \u00e8 supportata");
        }
        if ("CUSTOM_header".equals(mode)) {
            String hdr = pDefault.getProperty("policy.tokenForward.trasparente.mode.header");
            if (hdr == null || "".equals(hdr)) {
                throw new ProviderValidationException("La modalit\u00e0 di forward trasparente indicata prevede l'indicazione del nome di un header http");
            }
            if (hdr.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel nome dell'header HTTP indicato per la modalit\u00e0 di forward trasparente");
            }
        } else if ("CUSTOM_url".equals(mode)) {
            String url = pDefault.getProperty("policy.tokenForward.trasparente.mode.queryParameter");
            if (url == null || "".equals(url)) {
                throw new ProviderValidationException("La modalit\u00e0 di forward trasparente indicata prevede l'indicazione del nome di una propriet\u00e0 della url");
            }
            if (url.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel nome della propriet\u00e0 della url indicata per la modalit\u00e0 di forward trasparente");
            }
        }
    }

    private void validateInformazioniRaccolteForward(Map<String, Properties> mapProperties, Properties pDefault) throws ProviderValidationException {
        String base64;
        String mode = pDefault.getProperty("policy.tokenForward.infoRaccolte.mode");
        if (mode == null) {
            throw new ProviderValidationException("Nessuna modalit\u00e0 di forward, delle informazioni raccolte, indicata");
        }
        if (!("op2header".equals(mode) || "op2json".equals(mode) || "op2jws".equals(mode) || "jws".equals(mode) || "jwe".equals(mode) || "json".equals(mode))) {
            throw new ProviderValidationException("La modalit\u00e0 di forward, delle informazioni raccolte, indicata '" + mode + "' non \u00e8 supportata");
        }
        if (("op2json".equals(mode) || "json".equals(mode)) && (base64 = pDefault.getProperty("policy.tokenForward.infoRaccolte.base64")) == null) {
            throw new ProviderValidationException("Nessuna indicazione sull'encoding 'Base64' fornito; Tale indicazione \u00e8 richiesta dalla modalit\u00e0 di forward, delle informazioni raccolte, indicata: " + mode);
        }
        if ("jws".equals(mode) || "jwe".equals(mode) || "json".equals(mode)) {
            this.validateInformazioniRaccolteForwardJson(pDefault, mode);
        }
        if ("op2jws".equals(mode) || "jws".equals(mode)) {
            this.validateInformazioniRaccolteForwardJws(mapProperties);
        }
        if ("jwe".equals(mode)) {
            this.validateInformazioniRaccolteForwardJwe(mapProperties);
        }
    }

    private void validateInformazioniRaccolteForwardJson(Properties pDefault, String mode) throws ProviderValidationException {
        boolean forwardValidazioneJWT = TokenUtilities.isEnabled(pDefault, "policy.tokenForward.infoRaccolte.validazioneJWT");
        boolean forwardIntrospection = TokenUtilities.isEnabled(pDefault, "policy.tokenForward.infoRaccolte.introspection");
        boolean forwardUserInfo = TokenUtilities.isEnabled(pDefault, "policy.tokenForward.infoRaccolte.userInfo");
        if (!(forwardValidazioneJWT || forwardIntrospection || forwardUserInfo)) {
            throw new ProviderValidationException("Almeno una scelta tra 'Validazione JWT', 'Introspection' o 'OIDC UserInfo' deve essere selezionata per inoltrare le informazioni raccolte all'applicativo erogatore tramite la modalit\u00e0 scelta: " + mode);
        }
        String indicataModalitaSconosciuta = ", indicata per le informazioni raccolte, sconosciuta";
        if (forwardValidazioneJWT) {
            this.validateInformazioniRaccolteForwardJsonValidazioneJWT(pDefault, indicataModalitaSconosciuta);
        }
        if (forwardIntrospection) {
            this.validateInformazioniRaccolteForwardJsonIntrospection(pDefault, indicataModalitaSconosciuta);
        }
        if (forwardUserInfo) {
            this.validateInformazioniRaccolteForwardJsonUserInfo(pDefault, indicataModalitaSconosciuta);
        }
    }

    private void validateInformazioniRaccolteForwardJsonValidazioneJWT(Properties pDefault, String indicataModalitaSconosciuta) throws ProviderValidationException {
        String modeForward = pDefault.getProperty("policy.tokenForward.infoRaccolte.validazioneJWT.mode");
        if (modeForward == null) {
            throw new ProviderValidationException(NESSUN_TIPO_CONSEGNA);
        }
        if (!"CUSTOM_header".equals(modeForward) && !"CUSTOM_url".equals(modeForward)) {
            throw new ProviderValidationException("(Validazione JWT) Tipo di consegna '" + modeForward + "'" + indicataModalitaSconosciuta);
        }
        if ("CUSTOM_header".equals(modeForward)) {
            String name = pDefault.getProperty("policy.tokenForward.infoRaccolte.validazioneJWT.mode.header");
            if (name == null || "".equals(name)) {
                throw new ProviderValidationException("(Validazione JWT) Il tipo di consegna (header), delle informazioni raccolte, richiede la definizione di un nome di un header http");
            }
            if (name.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel nome dell'header http (Forward ValidazioneJWT-Header)");
            }
        } else {
            String name = pDefault.getProperty("policy.tokenForward.infoRaccolte.validazioneJWT.mode.queryParameter");
            if (name == null || "".equals(name)) {
                throw new ProviderValidationException("(Validazione JWT) Il tipo di consegna (url), delle informazioni raccolte, richiede la definizione di un nome di un parametro della URL");
            }
            if (name.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel nome del parametro della url (Forward ValidazioneJWT-ParametroURL)");
            }
        }
    }

    private void validateInformazioniRaccolteForwardJsonIntrospection(Properties pDefault, String indicataModalitaSconosciuta) throws ProviderValidationException {
        String modeForward = pDefault.getProperty("policy.tokenForward.infoRaccolte.introspection.mode");
        if (modeForward == null) {
            throw new ProviderValidationException(NESSUN_TIPO_CONSEGNA);
        }
        if (!"CUSTOM_header".equals(modeForward) && !"CUSTOM_url".equals(modeForward)) {
            throw new ProviderValidationException("(Introspection) Tipo di consegna '" + modeForward + "'" + indicataModalitaSconosciuta);
        }
        if ("CUSTOM_header".equals(modeForward)) {
            String name = pDefault.getProperty("policy.tokenForward.infoRaccolte.introspection.mode.header");
            if (name == null || "".equals(name)) {
                throw new ProviderValidationException("(Introspection) Il tipo di consegna (header), delle informazioni raccolte, richiede la definizione di un nome di un header http");
            }
            if (name.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel nome dell'header http (Forward Introspection-Header)");
            }
        } else {
            String name = pDefault.getProperty("policy.tokenForward.infoRaccolte.introspection.mode.queryParameter");
            if (name == null || "".equals(name)) {
                throw new ProviderValidationException("(Introspection) Il tipo di consegna (url), delle informazioni raccolte, richiede la definizione di un nome di un parametro della URL");
            }
            if (name.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel nome del parametro della url (Forward Introspection-ParametroURL)");
            }
        }
    }

    private void validateInformazioniRaccolteForwardJsonUserInfo(Properties pDefault, String indicataModalitaSconosciuta) throws ProviderValidationException {
        String modeForward = pDefault.getProperty("policy.tokenForward.infoRaccolte.userInfo.mode");
        if (modeForward == null) {
            throw new ProviderValidationException(NESSUN_TIPO_CONSEGNA);
        }
        if (!"CUSTOM_header".equals(modeForward) && !"CUSTOM_url".equals(modeForward)) {
            throw new ProviderValidationException("(UserInfo) Tipo di consegna '" + modeForward + "'" + indicataModalitaSconosciuta);
        }
        if ("CUSTOM_header".equals(modeForward)) {
            String name = pDefault.getProperty("policy.tokenForward.infoRaccolte.userInfo.mode.header");
            if (name == null || "".equals(name)) {
                throw new ProviderValidationException("(UserInfo) Il tipo di consegna (header), delle informazioni raccolte, richiede la definizione di un nome di un header http");
            }
            if (name.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel nome dell'header http (Forward UserInfo-Header)");
            }
        } else {
            String name = pDefault.getProperty("policy.tokenForward.infoRaccolte.userInfo.mode.queryParameter");
            if (name == null || "".equals(name)) {
                throw new ProviderValidationException("(UserInfo) Il tipo di consegna (url), delle informazioni raccolte, richiede la definizione di un nome di un parametro della URL");
            }
            if (name.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel nome del parametro della url (Forward UserInfo-ParametroURL)");
            }
        }
    }

    private void validateInformazioniRaccolteForwardJws(Map<String, Properties> mapProperties) throws ProviderValidationException {
        Properties p = mapProperties.get("signaturePropRefId");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("La modalit\u00e0 di forward, delle informazioni raccolte, selezionata richiede una configurazione per poter attuare la firma JWS; configurazione non riscontrata");
        }
        if (!p.containsKey("rs.security.keystore") && !p.containsKey("rs.security.keystore.jwkset")) {
            String file = p.getProperty("rs.security.keystore.file");
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Token Forward - JWS KeyStore - Path");
            String fileChiavePubblica = p.getProperty("rs.security.keystore.file.public");
            if (fileChiavePubblica != null && StringUtils.isNotEmpty((String)fileChiavePubblica)) {
                InputValidationUtils.validateTextAreaInput((String)file, (String)"Token Forward - JWS KeyStore - Chiave Pubblica");
            }
        }
    }

    private void validateInformazioniRaccolteForwardJwe(Map<String, Properties> mapProperties) throws ProviderValidationException {
        Properties p = mapProperties.get("encryptionPropRefId");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("La modalit\u00e0 di forward, delle informazioni raccolte, selezionata richiede una configurazione per poter attuare la cifratura JWE; configurazione non riscontrata");
        }
        if (!p.containsKey("rs.security.keystore") && !p.containsKey("rs.security.keystore.jwkset")) {
            String file = p.getProperty("rs.security.keystore.file");
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Token Forward - JWE KeyStore - Path");
        }
    }

    public List<String> getValues(String id) throws ProviderException {
        return this.getValues(id, null);
    }

    public List<String> getValues(String id, ExternalResources externalResources) throws ProviderException {
        if ("introspectionHttpMethod".equals(id) || "userInfoHttpMethod".equals(id)) {
            return this.getHttpRequestMethodValues();
        }
        if ("endpointHttpsTipologia".equals(id)) {
            return this.getTipologiaHttpsValues();
        }
        if ("encryptionKeyAlgorithm".equals(id) || "encryptionContentAlgorithm".equals(id) || "tokenForwardInfoRaccolteModeJWSSignature".equals(id) || "tokenForwardInfoRaccolteModeJWEKeyAlgorithm".equals(id) || "tokenForwardInfoRaccolteModeJWEContentAlgorithm".equals(id)) {
            return this.getSecProviderValues(id);
        }
        if ("validazioneJwtTruststoreType".equals(id) || "validazioneJwtKeystoreType".equals(id) || "endpointHttpsTruststoreType".equals(id) || "endpointHttpsClientKeystoreType".equals(id) || "tokenForwardInfoRaccolteModeJWSKeystoreType".equals(id) || "tokenForwardInfoRaccolteModeJWEContentKeystoreType".equals(id)) {
            return this.getStoreType(id, true);
        }
        if ("validazioneJwtTruststoreTypeSelectCertificate".equals(id)) {
            return Costanti.getIdValidazioneJwtTruststoreTypeSelectCertificateValues();
        }
        if ("validazioneJwtTruststoreTypeSelectJWKPublicKey".equals(id)) {
            return Costanti.getIdValidazioneJwtTruststoreTypeSelectJwkPublicKeyValues();
        }
        if ("validazioneJwtTruststoreOcspPolicy".equals(id) || "endpointHttpsTrustStoreOcspPolicy".equals(id)) {
            return this.ocspProvider.getValues();
        }
        if ("tokenForwardInfoRaccolteModeJWSKeystoreByokPolicy".equals(id) || "tokenForwardInfoRaccolteModeJWEContentKeystoreByokPolicy".equals(id) || "endpointHttpsByokPolicy".equals(id) || "validazioneJwtKeystoreByokPolicy".equals(id)) {
            return this.byokProvider.getValues();
        }
        if ("validazioneJWTAsymmetricSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithmUtilities.getValuesSignatureAlgorithm((boolean)false, (boolean)true);
        }
        return this.getValuesContinue1(id, externalResources);
    }

    private List<String> getValuesContinue1(String id, ExternalResources externalResources) throws ProviderException {
        List<String> l = null;
        if ("discoveryParserCustomPluginChoice".equals(id)) {
            return TokenUtilities.getTokenPluginValues(externalResources, TipoPlugin.TOKEN_DYNAMIC_DISCOVERY);
        }
        if ("validazioneJwtParserCustomPluginChoice".equals(id) || "introspectionParserCustomPluginChoice".equals(id) || "userInfoParserCustomPluginChoice".equals(id)) {
            return TokenUtilities.getTokenPluginValues(externalResources, TipoPlugin.TOKEN_VALIDAZIONE);
        }
        if ("validazioneDPoPParserCustomPluginChoice".equals(id)) {
            return TokenUtilities.getTokenPluginValues(externalResources, TipoPlugin.DPOP_VALIDAZIONE);
        }
        return l;
    }

    private List<String> getHttpRequestMethodValues() {
        ArrayList<String> methodsList = new ArrayList<String>();
        HttpRequestMethod[] methods = HttpRequestMethod.values();
        for (int i = 0; i < methods.length; ++i) {
            methodsList.add(methods[i].name());
        }
        return methodsList;
    }

    private List<String> getTipologiaHttpsValues() {
        List tipologie = null;
        try {
            tipologie = SSLUtilities.getSSLSupportedProtocols();
        }
        catch (Exception e) {
            tipologie = SSLUtilities.getAllSslProtocol();
        }
        return tipologie;
    }

    private List<String> getSecProviderValues(String id) throws ProviderException {
        SecurityProvider secProvider = new SecurityProvider();
        if ("tokenForwardInfoRaccolteModeJWSSignature".equals(id)) {
            return secProvider.getValues("signatureAlgorithm");
        }
        if ("tokenForwardInfoRaccolteModeJWEKeyAlgorithm".equals(id) || "encryptionKeyAlgorithm".equals(id)) {
            return secProvider.getValues("encryptionKeyAlgorithm");
        }
        return secProvider.getValues("encryptionContentAlgorithm");
    }

    public List<String> getLabels(String id) throws ProviderException {
        return this.getLabels(id, null);
    }

    public List<String> getLabels(String id, ExternalResources externalResources) throws ProviderException {
        if ("encryptionKeyAlgorithm".equals(id) || "encryptionContentAlgorithm".equals(id) || "tokenForwardInfoRaccolteModeJWSSignature".equals(id) || "tokenForwardInfoRaccolteModeJWEKeyAlgorithm".equals(id) || "tokenForwardInfoRaccolteModeJWEContentAlgorithm".equals(id)) {
            return this.getLabelsEncryption(id);
        }
        if ("validazioneJwtTruststoreType".equals(id) || "validazioneJwtKeystoreType".equals(id) || "endpointHttpsTruststoreType".equals(id) || "endpointHttpsClientKeystoreType".equals(id) || "tokenForwardInfoRaccolteModeJWSKeystoreType".equals(id) || "tokenForwardInfoRaccolteModeJWEContentKeystoreType".equals(id)) {
            return this.getStoreType(id, false);
        }
        if ("validazioneJwtTruststoreTypeSelectCertificate".equals(id)) {
            return Costanti.getIdValidazioneJwtTruststoreTypeSelectCertificateLabels();
        }
        if ("validazioneJwtTruststoreTypeSelectJWKPublicKey".equals(id)) {
            return Costanti.getIdValidazioneJwtTruststoreTypeSelectJwkPublicKeyLabels();
        }
        if ("validazioneJwtTruststoreOcspPolicy".equals(id) || "endpointHttpsTrustStoreOcspPolicy".equals(id)) {
            return this.ocspProvider.getLabels();
        }
        if ("tokenForwardInfoRaccolteModeJWSKeystoreByokPolicy".equals(id) || "tokenForwardInfoRaccolteModeJWEContentKeystoreByokPolicy".equals(id) || "endpointHttpsByokPolicy".equals(id) || "validazioneJwtKeystoreByokPolicy".equals(id)) {
            return this.byokProvider.getLabels();
        }
        if ("validazioneJWTAsymmetricSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithmUtilities.getLabelsSignatureAlgorithm((boolean)false, (boolean)true);
        }
        return this.getLabelsContinue1(id, externalResources);
    }

    private List<String> getLabelsEncryption(String id) throws ProviderException {
        SecurityProvider secProvider = new SecurityProvider();
        if ("tokenForwardInfoRaccolteModeJWSSignature".equals(id)) {
            return secProvider.getLabels("signatureAlgorithm");
        }
        if ("tokenForwardInfoRaccolteModeJWEKeyAlgorithm".equals(id) || "encryptionKeyAlgorithm".equals(id)) {
            return secProvider.getLabels("encryptionKeyAlgorithm");
        }
        return secProvider.getLabels("encryptionContentAlgorithm");
    }

    private List<String> getLabelsContinue1(String id, ExternalResources externalResources) throws ProviderException {
        if ("discoveryParserCustomPluginChoice".equals(id)) {
            return TokenUtilities.getTokenPluginLabels(externalResources, TipoPlugin.TOKEN_DYNAMIC_DISCOVERY);
        }
        if ("validazioneJwtParserCustomPluginChoice".equals(id) || "introspectionParserCustomPluginChoice".equals(id) || "userInfoParserCustomPluginChoice".equals(id)) {
            return TokenUtilities.getTokenPluginLabels(externalResources, TipoPlugin.TOKEN_VALIDAZIONE);
        }
        if ("validazioneDPoPParserCustomPluginChoice".equals(id)) {
            return TokenUtilities.getTokenPluginLabels(externalResources, TipoPlugin.DPOP_VALIDAZIONE);
        }
        return this.getValues(id);
    }

    private List<String> getStoreType(String id, boolean value) {
        boolean trustStore = true;
        boolean secret = false;
        ArrayList<String> l = new ArrayList<String>();
        l.add(value ? SecurityConstants.KEYSTORE_TYPE_JKS_VALUE : SecurityConstants.KEYSTORE_TYPE_JKS_LABEL);
        l.add(value ? SecurityConstants.KEYSTORE_TYPE_PKCS12_VALUE : SecurityConstants.KEYSTORE_TYPE_PKCS12_LABEL);
        this.addStoreTypeJWK(id, l, value);
        this.addStoreTypePrivatePubliKey(id, l, value);
        if ("validazioneJwtKeystoreType".equals(id) || "tokenForwardInfoRaccolteModeJWEContentKeystoreType".equals(id)) {
            l.add(value ? "jceks" : "JCEKS");
            secret = true;
        }
        if ("validazioneJwtKeystoreType".equals(id) || "endpointHttpsClientKeystoreType".equals(id) || "tokenForwardInfoRaccolteModeJWSKeystoreType".equals(id) || "tokenForwardInfoRaccolteModeJWEContentKeystoreType".equals(id)) {
            trustStore = false;
        }
        HSMUtils.fillTipologieKeystore((boolean)trustStore, (boolean)false, l);
        if (secret) {
            this.addStoreTypeSecret(l);
        }
        return l;
    }

    private void addStoreTypeJWK(String id, List<String> l, boolean value) {
        if ("validazioneJwtTruststoreType".equals(id) || "validazioneJwtKeystoreType".equals(id) || "tokenForwardInfoRaccolteModeJWSKeystoreType".equals(id) || "tokenForwardInfoRaccolteModeJWEContentKeystoreType".equals(id)) {
            l.add(value ? SecurityConstants.KEYSTORE_TYPE_JWK_VALUE : SecurityConstants.KEYSTORE_TYPE_JWK_LABEL);
        }
    }

    private void addStoreTypePrivatePubliKey(String id, List<String> l, boolean value) {
        if ("validazioneJwtTruststoreType".equals(id)) {
            l.add(value ? SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE : SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_LABEL);
        }
        if ("tokenForwardInfoRaccolteModeJWSKeystoreType".equals(id)) {
            l.add(value ? SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE : SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_LABEL);
        }
    }

    private void addStoreTypeSecret(List<String> l) {
        ArrayList lSecret = new ArrayList();
        HSMUtils.fillTipologieKeystore((boolean)false, (boolean)true, lSecret);
        if (!lSecret.isEmpty()) {
            for (String type : lSecret) {
                if (l.contains(type)) continue;
                l.add(type);
            }
        }
    }

    public String getNote(String id, String actualValue) throws ProviderException {
        if ("validazioneJwtTruststoreTypeSelectCertificate".equals(id)) {
            if ("alias".equals(actualValue)) {
                return "Per la validazione viene utilizzato il certificato nel truststore corrispondente all'alias indicato";
            }
            if ("x5c".equals(actualValue)) {
                return "Per la validazione viene utilizzato il certificato presente nel token, dopo averlo validato rispetto al truststore";
            }
            if ("x5t#256".equals(actualValue)) {
                return "Per la validazione viene utilizzato il certificato nel truststore corrispondente al thumbprint presente nel token";
            }
            if ("x5c_x5t#256".equals(actualValue)) {
                return "Per la validazione viene utilizzato il certificato presente nel token o recuperato dal truststore rispetto al thumbprint";
            }
            if ("kid".equals(actualValue)) {
                return "Per la validazione viene utilizzato il certificato nel truststore con alias corrispondente al 'kid' presente nel token";
            }
            if ("x5u".equals(actualValue)) {
                return "Per la validazione viene recuperato il certificato riferito dalla URL presente nel token e validato rispetto al truststore";
            }
        } else if ("validazioneJwtTruststoreTypeSelectJWKPublicKey".equals(id)) {
            if ("alias".equals(actualValue)) {
                return "Per la validazione viene utilizzata la chiave pubblica nel truststore JWKs corrispondente al kid indicato";
            }
            if ("kid".equals(actualValue)) {
                return "Per la validazione viene utilizzata la chiave pubblica nel truststore JWKs corrispondente al 'kid' presente nel token";
            }
        }
        return null;
    }

    public String getDefault(String id) throws ProviderException {
        return this.getDefault(id, null);
    }

    public String getDefault(String id, ExternalResources externalResources) throws ProviderException {
        if ("introspectionHttpMethod".equals(id) || "userInfoHttpMethod".equals(id)) {
            return HttpRequestMethod.GET.name();
        }
        if ("endpointHttpsTipologia".equals(id)) {
            return SSLUtilities.getSafeDefaultProtocol();
        }
        if ("encryptionKeyAlgorithm".equals(id) || "encryptionContentAlgorithm".equals(id) || "tokenForwardInfoRaccolteModeJWSSignature".equals(id) || "tokenForwardInfoRaccolteModeJWEKeyAlgorithm".equals(id) || "tokenForwardInfoRaccolteModeJWEContentAlgorithm".equals(id)) {
            SecurityProvider secProvider = new SecurityProvider();
            if ("tokenForwardInfoRaccolteModeJWSSignature".equals(id)) {
                return secProvider.getDefault("signatureAlgorithm");
            }
            if ("tokenForwardInfoRaccolteModeJWEKeyAlgorithm".equals(id) || "encryptionKeyAlgorithm".equals(id)) {
                return secProvider.getDefault("encryptionKeyAlgorithm");
            }
            return secProvider.getDefault("encryptionContentAlgorithm");
        }
        return null;
    }

    public String dynamicUpdate(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        return this.dynamicUpdate(items, mapNameValue, item, actualValue, null);
    }

    public String dynamicUpdate(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue, ExternalResources externalResources) {
        if ("validazioneJwtTruststoreFile".equals(item.getName()) || "validazioneJwtKeystoreFile".equals(item.getName()) || "endpointHttpsTruststoreFile".equals(item.getName()) || "endpointHttpsClientKeystoreFile".equals(item.getName()) || "tokenForwardInfoRaccolteModeJWSKeystoreFile".equals(item.getName()) || "tokenForwardInfoRaccolteModeJWEContentKeystoreFile".equals(item.getName())) {
            return this.dynamicUpdateFile(items, mapNameValue, item, actualValue);
        }
        if ("validazioneJwtTruststorePassword".equals(item.getName()) || "validazioneJwtKeystorePassword".equals(item.getName()) || "endpointHttpsTruststorePassword".equals(item.getName()) || "endpointHttpsClientKeystorePassword".equals(item.getName()) || "tokenForwardInfoRaccolteModeJWSKeystorePassword".equals(item.getName()) || "tokenForwardInfoRaccolteModeJWEContentKeystorePassword".equals(item.getName())) {
            return this.dynamicUpdateStorePassword(items, mapNameValue, item, actualValue);
        }
        if ("validazioneJwtKeystorePrivateKeyPassword".equals(item.getName()) || "endpointHttpsClientPasswordChiavePrivata".equals(item.getName()) || "tokenForwardInfoRaccolteModeJWSKeystorePrivateKeyPassword".equals(item.getName()) || "tokenForwardInfoRaccolteModeJWEContentKeystorePrivateKeyPassword".equals(item.getName())) {
            return this.dynamicUpdateStoreKeyPassword(items, mapNameValue, item, actualValue);
        }
        if ("validazioneJwtTruststoreOcspPolicy".equals(item.getName()) || "endpointHttpsTrustStoreOcspPolicy".equals(item.getName())) {
            if (!this.ocspProvider.isOcspEnabled()) {
                item.setValue("");
                item.setType(ItemType.HIDDEN);
            }
            return actualValue;
        }
        if ("tokenForwardInfoRaccolteModeJWSKeystoreByokPolicy".equals(item.getName()) || "tokenForwardInfoRaccolteModeJWEContentKeystoreByokPolicy".equals(item.getName()) || "endpointHttpsByokPolicy".equals(item.getName()) || "validazioneJwtKeystoreByokPolicy".equals(item.getName())) {
            return this.dynamicUpdateByok(items, mapNameValue, item, actualValue);
        }
        if ("tokenForwardInfoRaccolteModeJWSKeystoreKeyPairAlgorithm".equals(item.getName())) {
            return this.dynamicUpdateKeyPairAlgorithm(items, mapNameValue, item, actualValue);
        }
        return this.dynamicUpdateContinue1(items, mapNameValue, item, actualValue, externalResources);
    }

    public String dynamicUpdateContinue1(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue, ExternalResources externalResources) {
        if ("discoveryParserCustomPluginChoice".equals(item.getName())) {
            return TokenUtilities.dynamicUpdateTokenPluginChoice(externalResources, TipoPlugin.TOKEN_DYNAMIC_DISCOVERY, item, actualValue);
        }
        if ("validazioneJwtParserCustomPluginChoice".equals(item.getName()) || "introspectionParserCustomPluginChoice".equals(item.getName()) || "userInfoParserCustomPluginChoice".equals(item.getName())) {
            return TokenUtilities.dynamicUpdateTokenPluginChoice(externalResources, TipoPlugin.TOKEN_VALIDAZIONE, item, actualValue);
        }
        if ("validazioneDPoPParserCustomPluginChoice".equals(item.getName())) {
            return TokenUtilities.dynamicUpdateTokenPluginChoice(externalResources, TipoPlugin.DPOP_VALIDAZIONE, item, actualValue);
        }
        if ("discoveryParserCustom".equals(item.getName())) {
            return this.dynamicUpdateTokenDynamicDiscoveryPluginClassName(items, mapNameValue, item, actualValue, externalResources);
        }
        if ("validazioneJwtParserCustom".equals(item.getName()) || "introspectionParserCustom".equals(item.getName()) || "userInfoParserCustom".equals(item.getName())) {
            return this.dynamicUpdateTokenPluginClassName(items, mapNameValue, item, actualValue, externalResources);
        }
        if ("validazioneDPoPParserCustom".equals(item.getName())) {
            return this.dynamicUpdateDPoPValidazionePluginClassName(items, mapNameValue, item, actualValue, externalResources);
        }
        return actualValue;
    }

    private String dynamicUpdateFile(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String type = "validazioneJwtTruststoreType";
        if ("validazioneJwtKeystoreFile".equals(item.getName())) {
            type = "validazioneJwtKeystoreType";
        } else if ("endpointHttpsTruststoreFile".equals(item.getName())) {
            type = "endpointHttpsTruststoreType";
        } else if ("endpointHttpsClientKeystoreFile".equals(item.getName())) {
            type = "endpointHttpsClientKeystoreType";
        } else if ("tokenForwardInfoRaccolteModeJWSKeystoreFile".equals(item.getName())) {
            type = "tokenForwardInfoRaccolteModeJWSKeystoreType";
        } else if ("tokenForwardInfoRaccolteModeJWEContentKeystoreFile".equals(item.getName())) {
            type = "tokenForwardInfoRaccolteModeJWEContentKeystoreType";
        }
        return AbstractSecurityProvider.processStoreFile((String)type, items, mapNameValue, (Item)item, (String)actualValue);
    }

    private String dynamicUpdateStorePassword(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String type = "validazioneJwtTruststoreType";
        boolean keystore = true;
        if ("validazioneJwtKeystorePassword".equals(item.getName())) {
            type = "validazioneJwtKeystoreType";
        } else if ("endpointHttpsTruststorePassword".equals(item.getName())) {
            type = "endpointHttpsTruststoreType";
            keystore = false;
        } else if ("endpointHttpsClientKeystorePassword".equals(item.getName())) {
            type = "endpointHttpsClientKeystoreType";
        } else if ("tokenForwardInfoRaccolteModeJWSKeystorePassword".equals(item.getName())) {
            type = "tokenForwardInfoRaccolteModeJWSKeystoreType";
        } else if ("tokenForwardInfoRaccolteModeJWEContentKeystorePassword".equals(item.getName())) {
            type = "tokenForwardInfoRaccolteModeJWEContentKeystoreType";
        }
        return AbstractSecurityProvider.processStorePassword((boolean)keystore, (String)type, items, mapNameValue, (Item)item, (String)actualValue);
    }

    private String dynamicUpdateStoreKeyPassword(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String type = "validazioneJwtKeystoreType";
        if ("endpointHttpsClientPasswordChiavePrivata".equals(item.getName())) {
            type = "endpointHttpsClientKeystoreType";
        } else if ("tokenForwardInfoRaccolteModeJWSKeystorePrivateKeyPassword".equals(item.getName())) {
            type = "tokenForwardInfoRaccolteModeJWSKeystoreType";
        } else if ("tokenForwardInfoRaccolteModeJWEContentKeystorePrivateKeyPassword".equals(item.getName())) {
            type = "tokenForwardInfoRaccolteModeJWEContentKeystoreType";
        }
        return AbstractSecurityProvider.processStoreKeyPassword((String)type, items, mapNameValue, (Item)item, (String)actualValue);
    }

    private String dynamicUpdateByok(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        if (!this.byokProvider.isByokEnabled()) {
            item.setValue("");
            item.setType(ItemType.HIDDEN);
            return actualValue;
        }
        return this.dynamicUpdateByokPolicy(items, mapNameValue, item, actualValue);
    }

    private String dynamicUpdateByokPolicy(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String type = null;
        if ("tokenForwardInfoRaccolteModeJWSKeystoreByokPolicy".equals(item.getName())) {
            type = "tokenForwardInfoRaccolteModeJWSKeystoreType";
        } else if ("tokenForwardInfoRaccolteModeJWEContentKeystoreByokPolicy".equals(item.getName())) {
            type = "tokenForwardInfoRaccolteModeJWEContentKeystoreType";
        } else if ("endpointHttpsByokPolicy".equals(item.getName())) {
            type = "endpointHttpsClientKeystoreType";
        } else if ("validazioneJwtKeystoreByokPolicy".equals(item.getName())) {
            type = "validazioneJwtKeystoreType";
        }
        return AbstractSecurityProvider.processStoreByokPolicy((String)type, items, mapNameValue, (Item)item, (String)actualValue);
    }

    private String dynamicUpdateKeyPairAlgorithm(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String keystoreType = AbstractSecurityProvider.readValue((String)"tokenForwardInfoRaccolteModeJWSKeystoreType", items, mapNameValue);
        if (keystoreType == null || !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            return actualValue;
        }
        String signatureAlgorithm = AbstractSecurityProvider.readValue((String)"tokenForwardInfoRaccolteModeJWSSignature", items, mapNameValue);
        String keyPairAlgorithm = SignatureAlgorithmUtilities.covertToKeyPairAlgorithm((String)signatureAlgorithm);
        if (keyPairAlgorithm == null) {
            keyPairAlgorithm = "RSA";
        }
        item.setValue(keyPairAlgorithm);
        return keyPairAlgorithm;
    }

    private String dynamicUpdateTokenDynamicDiscoveryPluginClassName(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue, ExternalResources externalResources) {
        String idChoice = "discoveryParserCustomPluginChoice";
        return TokenUtilities.dynamicUpdateTokenPluginClassName(externalResources, TipoPlugin.TOKEN_DYNAMIC_DISCOVERY, items, mapNameValue, item, idChoice, actualValue);
    }

    private String dynamicUpdateTokenPluginClassName(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue, ExternalResources externalResources) {
        String idChoice = null;
        idChoice = "validazioneJwtParserCustom".equals(item.getName()) ? "validazioneJwtParserCustomPluginChoice" : ("introspectionParserCustom".equals(item.getName()) ? "introspectionParserCustomPluginChoice" : "userInfoParserCustomPluginChoice");
        return TokenUtilities.dynamicUpdateTokenPluginClassName(externalResources, TipoPlugin.TOKEN_VALIDAZIONE, items, mapNameValue, item, idChoice, actualValue);
    }

    private String dynamicUpdateDPoPValidazionePluginClassName(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue, ExternalResources externalResources) {
        String idChoice = "validazioneDPoPParserCustomPluginChoice";
        return TokenUtilities.dynamicUpdateTokenPluginClassName(externalResources, TipoPlugin.DPOP_VALIDAZIONE, items, mapNameValue, item, idChoice, actualValue);
    }

    public ProviderInfo getProviderInfo(String id) throws ProviderException {
        if ("validazioneJwtParserCustom".equals(id) || "introspectionParserCustom".equals(id) || "userInfoParserCustom".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody("Il plugin deve implementare l'interfaccia: ");
            pInfo.setListBody(new ArrayList());
            pInfo.getListBody().add(ITokenParser.class.getName());
            return pInfo;
        }
        if ("validazioneDPoPParserCustom".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody("Il plugin deve implementare l'interfaccia: ");
            pInfo.setListBody(new ArrayList());
            pInfo.getListBody().add(IDPoPParser.class.getName());
            return pInfo;
        }
        if ("discoveryParserCustom".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody("Il plugin deve implementare l'interfaccia: ");
            pInfo.setListBody(new ArrayList());
            pInfo.getListBody().add(IDynamicDiscoveryParser.class.getName());
            return pInfo;
        }
        return null;
    }
}

