/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.Search;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mvc.properties.Item;
import org.openspcoop2.core.mvc.properties.constants.ItemType;
import org.openspcoop2.core.mvc.properties.provider.ExternalResources;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.core.mvc.properties.utils.DBPropertiesUtils;
import org.openspcoop2.core.mvc.properties.utils.MultiPropertiesUtilities;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.plugins.utils.PluginsDriverUtils;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.ForwardProxy;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.token.AbstractPolicyToken;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.DynamicDiscovery;
import org.openspcoop2.pdd.core.token.GestoreToken;
import org.openspcoop2.pdd.core.token.GestoreTokenValidazioneUtilities;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.PolicyGestioneToken;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.attribute_authority.PolicyAttributeAuthority;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.utils.AbstractSecurityProvider;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.slf4j.Logger;

public class TokenUtilities {
    public static String SIGNATURE_SUFFIX = "__SIGNATURE__";
    private static final String EXTERNAL_RESOURCE_UNDEFINED = "External resource undefined";
    private static final String RECUPERO_PLUGIN_REGISTRATI_FALLITO_PREFIX = "Recupero plugin registrati fallito: ";

    private TokenUtilities() {
    }

    public static Properties getDefaultProperties(Map<String, Properties> mapProperties) {
        return MultiPropertiesUtilities.getDefaultProperties(mapProperties);
    }

    public static Properties getDynamicDiscoveryClaimsMappingProperties(Map<String, Properties> mapProperties) {
        return mapProperties.get("dynamicDiscoveryParserPropRefId");
    }

    public static Properties getValidazioneJwtClaimsMappingProperties(Map<String, Properties> mapProperties) {
        return mapProperties.get("validazioneJwtTokenParserPropRefId");
    }

    public static Properties getValidazioneDPoPClaimsMappingProperties(Map<String, Properties> mapProperties) {
        return mapProperties.get("validazioneDPoPTokenParserPropRefId");
    }

    public static Properties getIntrospectionClaimsMappingProperties(Map<String, Properties> mapProperties) {
        return mapProperties.get("introspectionTokenParserPropRefId");
    }

    public static Properties getUserInfoClaimsMappingProperties(Map<String, Properties> mapProperties) {
        return mapProperties.get("userInfoTokenParserPropRefId");
    }

    public static Properties getRetrieveResponseClaimsMappingProperties(Map<String, Properties> mapProperties) {
        return mapProperties.get("retrieveTokenParserPropRefId");
    }

    public static List<String> getClaims(Properties p, String name) {
        String v = p.getProperty(name);
        ArrayList<String> l = new ArrayList<String>();
        if (v != null) {
            if (v.contains(",")) {
                String[] tmp;
                for (String s : tmp = v.split(",")) {
                    if (!StringUtils.isNotEmpty((String)s.trim())) continue;
                    l.add(s.trim());
                }
            } else {
                l.add(v.trim());
            }
        }
        return l;
    }

    public static Map<String, Properties> getMultiProperties(GenericProperties gp) throws ProviderException {
        Map multiProperties = null;
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (Property pConfig : gp.getPropertyList()) {
                properties.put(pConfig.getNome(), pConfig.getValore());
            }
            multiProperties = DBPropertiesUtils.toMultiMap(properties);
        }
        catch (Exception e) {
            throw new ProviderException(e.getMessage(), (Throwable)e);
        }
        return multiProperties;
    }

    public static boolean isDynamicDiscoveryEnabled(Map<String, Properties> mapProperties) {
        return TokenUtilities.isDynamicDiscoveryEnabled(TokenUtilities.getDefaultProperties(mapProperties));
    }

    public static boolean isDynamicDiscoveryEnabled(Properties pDefault) {
        return TokenUtilities.isEnabled(pDefault, "policy.token.discovery");
    }

    public static boolean isDynamicDiscoveryEnabled(GenericProperties gp) throws ProviderException {
        Map<String, Properties> multiProperties = TokenUtilities.getMultiProperties(gp);
        return TokenUtilities.isDynamicDiscoveryEnabled(multiProperties);
    }

    public static boolean isValidazioneEnabled(Map<String, Properties> mapProperties) {
        return TokenUtilities.isValidazioneEnabled(TokenUtilities.getDefaultProperties(mapProperties));
    }

    public static boolean isValidazioneEnabled(Properties pDefault) {
        return TokenUtilities.isEnabled(pDefault, "policy.validazioneJWT.stato");
    }

    public static boolean isValidazioneEnabled(GenericProperties gp) throws ProviderException {
        Map<String, Properties> multiProperties = TokenUtilities.getMultiProperties(gp);
        return TokenUtilities.isValidazioneEnabled(multiProperties);
    }

    public static boolean isIntrospectionEnabled(Map<String, Properties> mapProperties) {
        return TokenUtilities.isIntrospectionEnabled(TokenUtilities.getDefaultProperties(mapProperties));
    }

    public static boolean isIntrospectionEnabled(Properties pDefault) {
        return TokenUtilities.isEnabled(pDefault, "policy.introspection.stato");
    }

    public static boolean isIntrospectionEnabled(GenericProperties gp) throws ProviderException {
        Map<String, Properties> multiProperties = TokenUtilities.getMultiProperties(gp);
        return TokenUtilities.isIntrospectionEnabled(multiProperties);
    }

    public static boolean isUserInfoEnabled(Map<String, Properties> mapProperties) {
        return TokenUtilities.isUserInfoEnabled(TokenUtilities.getDefaultProperties(mapProperties));
    }

    public static boolean isUserInfoEnabled(Properties pDefault) {
        return TokenUtilities.isEnabled(pDefault, "policy.userInfo.stato");
    }

    public static boolean isUserInfoEnabled(GenericProperties gp) throws ProviderException {
        Map<String, Properties> multiProperties = TokenUtilities.getMultiProperties(gp);
        return TokenUtilities.isUserInfoEnabled(multiProperties);
    }

    public static boolean isDPoPValidationEnabled(Map<String, Properties> mapProperties) {
        return TokenUtilities.isDPoPValidationEnabled(TokenUtilities.getDefaultProperties(mapProperties));
    }

    public static boolean isDPoPValidationEnabled(Properties pDefault) {
        return TokenUtilities.isEnabled(pDefault, "policy.dpop.validation");
    }

    public static boolean isDPoPValidationEnabled(GenericProperties gp) throws ProviderException {
        Map<String, Properties> multiProperties = TokenUtilities.getMultiProperties(gp);
        return TokenUtilities.isDPoPValidationEnabled(multiProperties);
    }

    public static boolean isTokenForwardEnabled(Map<String, Properties> mapProperties) {
        return TokenUtilities.isTokenForwardEnabled(TokenUtilities.getDefaultProperties(mapProperties));
    }

    public static boolean isTokenForwardEnabled(Properties pDefault) {
        return TokenUtilities.isEnabled(pDefault, "policy.tokenForward.stato");
    }

    public static boolean isTokenForwardEnabled(GenericProperties gp) throws ProviderException {
        Map<String, Properties> multiProperties = TokenUtilities.getMultiProperties(gp);
        return TokenUtilities.isTokenForwardEnabled(multiProperties);
    }

    public static boolean isEnabled(Properties p, String propertyName) {
        return MultiPropertiesUtilities.isEnabled((Properties)p, (String)propertyName);
    }

    private static String getPrefixPolicy(GenericProperties gp) {
        return "La configurazione nella policy " + gp.getNome();
    }

    public static KeystoreParams getValidazioneJwtKeystoreParams(GenericProperties gp) throws TokenException, ProviderException, ProviderValidationException {
        PolicyGestioneToken policy = TokenUtilities.convertTo(gp, new GestioneToken());
        if (!TokenUtilities.isValidazioneEnabled(gp)) {
            throw new TokenException(TokenUtilities.getPrefixPolicy(gp) + " non utilizza la funzionalit\u00e0 di validazione JWT");
        }
        return TokenUtilities.getValidazioneJwtKeystoreParams(policy);
    }

    public static KeystoreParams getValidazioneJwtKeystoreParams(PolicyGestioneToken policy) throws TokenException {
        String tokenType = policy.getTipoToken();
        Properties p = null;
        if ("jws".equals(tokenType)) {
            p = policy.getProperties().get("signatureVerificationPropRefId");
        } else if ("jwe".equals(tokenType)) {
            p = policy.getProperties().get("decryptionPropRefId");
        }
        if (p != null && p.containsKey("rs.security.keystore.file")) {
            KeystoreParams keystoreParams = new KeystoreParams();
            keystoreParams.setPath(p.getProperty("rs.security.keystore.file"));
            String type = p.getProperty("rs.security.keystore.type");
            if (type == null) {
                type = KeystoreType.JKS.getNome();
            }
            keystoreParams.setType(type);
            keystoreParams.setPassword(p.getProperty("rs.security.keystore.password"));
            keystoreParams.setKeyAlias(p.getProperty("rs.security.keystore.alias"));
            keystoreParams.setKeyPassword(p.getProperty("rs.security.key.password"));
            TokenUtilities.fillKeyPairParamters(keystoreParams, type, p);
            return keystoreParams;
        }
        return null;
    }

    private static void fillKeyPairParamters(KeystoreParams keystoreParams, String type, Properties p) throws TokenException {
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(type)) {
            String keystorePublicKeyFile = p.getProperty("rs.security.keystore.file.public");
            if (keystorePublicKeyFile == null) {
                throw new TokenException("Public key file undefined");
            }
            keystoreParams.setKeyPairPublicKeyPath(keystorePublicKeyFile);
        }
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(type) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(type)) {
            String keyPairAlgorithm = p.getProperty("rs.security.keystore.file.algorithm");
            if (keyPairAlgorithm == null) {
                throw new TokenException("Key pair algorithm undefined");
            }
            keystoreParams.setKeyPairAlgorithm(keyPairAlgorithm);
        }
    }

    public static KeystoreParams getForwardToJwtKeystoreParams(GenericProperties gp) throws TokenException, ProviderException, ProviderValidationException {
        PolicyGestioneToken policy = TokenUtilities.convertTo(gp, new GestioneToken());
        if (!TokenUtilities.isTokenForwardEnabled(gp) || !policy.isForwardTokenInformazioniRaccolte()) {
            throw new TokenException(TokenUtilities.getPrefixPolicy(gp) + " non utilizza la funzionalit\u00e0 di forward delle informazioni raccolte del token");
        }
        return TokenUtilities.getForwardToJwtKeystoreParams(policy);
    }

    public static KeystoreParams getForwardToJwtKeystoreParams(PolicyGestioneToken policy) throws TokenException {
        String forwardInformazioniRaccolteMode = policy.getForwardTokenInformazioniRaccolteMode();
        Properties p = null;
        if ("op2jws".equals(forwardInformazioniRaccolteMode) || "jws".equals(forwardInformazioniRaccolteMode)) {
            p = policy.getProperties().get("signaturePropRefId");
        } else if ("jwe".equals(forwardInformazioniRaccolteMode)) {
            p = policy.getProperties().get("encryptionPropRefId");
        }
        if (p != null && p.containsKey("rs.security.keystore.file")) {
            KeystoreParams keystoreParams = new KeystoreParams();
            keystoreParams.setPath(p.getProperty("rs.security.keystore.file"));
            String type = p.getProperty("rs.security.keystore.type");
            if (type == null) {
                type = KeystoreType.JKS.getNome();
            }
            keystoreParams.setType(type);
            keystoreParams.setPassword(p.getProperty("rs.security.keystore.password"));
            keystoreParams.setKeyAlias(p.getProperty("rs.security.keystore.alias"));
            keystoreParams.setKeyPassword(p.getProperty("rs.security.key.password"));
            keystoreParams.setByokPolicy(p.getProperty("rs.security.keystore.file.byok"));
            TokenUtilities.fillKeyPairParamters(keystoreParams, type, p);
            return keystoreParams;
        }
        return null;
    }

    public static PolicyGestioneToken convertTo(GenericProperties gp, GestioneToken gestioneToken) throws ProviderException, ProviderValidationException {
        PolicyGestioneToken policy = new PolicyGestioneToken();
        policy.setName(gp.getNome());
        policy.setDescrizione(gp.getDescrizione());
        Map<String, Properties> multiProperties = TokenUtilities.getMultiProperties(gp);
        policy.setProperties(multiProperties);
        policy.setTokenOpzionale(false);
        policy.setDPoPValidation(false);
        policy.setDynamicDiscovery(false);
        policy.setValidazioneJWT(false);
        policy.setValidazioneJWTWarningOnly(false);
        policy.setIntrospection(false);
        policy.setIntrospectionWarningOnly(false);
        policy.setUserInfo(false);
        policy.setUserInfoWarningOnly(false);
        policy.setForwardToken(false);
        if (gestioneToken != null) {
            TokenUtilities.fill(policy, gestioneToken, multiProperties);
        }
        return policy;
    }

    private static void fill(PolicyGestioneToken policy, GestioneToken gestioneToken, Map<String, Properties> multiProperties) {
        boolean forwardEnabledDaPolicy;
        boolean userInfoEnabledDaPolicy;
        boolean introspectionEnabledDaPolicy;
        if (gestioneToken.getTokenOpzionale() != null) {
            policy.setTokenOpzionale(StatoFunzionalita.ABILITATO.equals((Object)gestioneToken.getTokenOpzionale()));
        }
        boolean dpopyEnabledDaPolicy = TokenUtilities.isDPoPValidationEnabled(multiProperties);
        policy.setDPoPValidation(dpopyEnabledDaPolicy);
        boolean dynamicDiscoveryEnabledDaPolicy = TokenUtilities.isDynamicDiscoveryEnabled(multiProperties);
        policy.setDynamicDiscovery(dynamicDiscoveryEnabledDaPolicy);
        boolean validazioneEnabledDaPolicy = TokenUtilities.isValidazioneEnabled(multiProperties);
        if (validazioneEnabledDaPolicy && gestioneToken.getValidazione() != null) {
            switch (gestioneToken.getValidazione()) {
                case ABILITATO: {
                    policy.setValidazioneJWT(true);
                    policy.setValidazioneJWTWarningOnly(false);
                    break;
                }
                case WARNING_ONLY: {
                    policy.setValidazioneJWT(true);
                    policy.setValidazioneJWTWarningOnly(true);
                    break;
                }
                case DISABILITATO: {
                    policy.setValidazioneJWT(false);
                    policy.setValidazioneJWTWarningOnly(false);
                }
            }
        }
        if ((introspectionEnabledDaPolicy = TokenUtilities.isIntrospectionEnabled(multiProperties)) && gestioneToken.getIntrospection() != null) {
            switch (gestioneToken.getIntrospection()) {
                case ABILITATO: {
                    policy.setIntrospection(true);
                    policy.setIntrospectionWarningOnly(false);
                    break;
                }
                case WARNING_ONLY: {
                    policy.setIntrospection(true);
                    policy.setIntrospectionWarningOnly(true);
                    break;
                }
                case DISABILITATO: {
                    policy.setIntrospection(false);
                    policy.setIntrospectionWarningOnly(false);
                }
            }
        }
        if ((userInfoEnabledDaPolicy = TokenUtilities.isUserInfoEnabled(multiProperties)) && gestioneToken.getUserInfo() != null) {
            switch (gestioneToken.getUserInfo()) {
                case ABILITATO: {
                    policy.setUserInfo(true);
                    policy.setUserInfoWarningOnly(false);
                    break;
                }
                case WARNING_ONLY: {
                    policy.setUserInfo(true);
                    policy.setUserInfoWarningOnly(true);
                    break;
                }
                case DISABILITATO: {
                    policy.setUserInfo(false);
                    policy.setUserInfoWarningOnly(false);
                }
            }
        }
        if ((forwardEnabledDaPolicy = TokenUtilities.isTokenForwardEnabled(multiProperties)) && gestioneToken.getForward() != null) {
            policy.setForwardToken(StatoFunzionalita.ABILITATO.equals((Object)gestioneToken.getForward()));
        }
    }

    public static List<String> getClaimValues(Object value) {
        List<String> lRet = null;
        if (value != null) {
            if (value instanceof List) {
                List l = (List)value;
                return TokenUtilities.getClaimValues(l);
            }
            String sValue = value.toString();
            ArrayList<String> l = new ArrayList<String>();
            l.add(sValue);
            return l;
        }
        return lRet;
    }

    private static List<String> getClaimValues(List<?> l) {
        List<String> lRet = null;
        if (!l.isEmpty()) {
            ArrayList<String> lString = new ArrayList<String>();
            for (Object o : l) {
                if (o == null) continue;
                lString.add(o.toString());
            }
            if (!lString.isEmpty()) {
                return lString;
            }
        }
        return lRet;
    }

    public static String getClaimValuesAsString(List<String> claimValues) {
        StringBuilder claimValueSB = new StringBuilder();
        if (claimValues == null || claimValues.isEmpty()) {
            return null;
        }
        if (claimValues.size() > 1) {
            for (String c : claimValues) {
                if (claimValueSB.length() > 0) {
                    claimValueSB.append(",");
                }
                claimValueSB.append(c);
            }
        } else {
            claimValueSB.append(claimValues.get(0));
        }
        return claimValueSB.length() > 0 ? claimValueSB.toString() : null;
    }

    public static String getClaimAsString(Map<String, Serializable> claims, String claim) {
        List<String> l = TokenUtilities.getClaimAsList(claims, claim);
        if (l == null || l.isEmpty()) {
            return null;
        }
        return TokenUtilities.getClaimValuesAsString(l);
    }

    public static List<String> getClaimAsList(Map<String, Serializable> claims, String claim) {
        List<String> l = null;
        Serializable o = claims.get(claim);
        if (o == null) {
            return l;
        }
        l = TokenUtilities.getClaimValues(o);
        List<String> lRet = null;
        if (l != null && l.isEmpty()) {
            return lRet;
        }
        return l;
    }

    public static String getFirstClaimAsString(Map<String, Serializable> claims, List<String> names) {
        for (String name : names) {
            String claim = TokenUtilities.getClaimAsString(claims, name);
            if (claim == null) continue;
            return claim;
        }
        return null;
    }

    public static List<String> getFirstClaimAsList(Map<String, Serializable> claims, List<String> names) {
        List<String> lRet = null;
        for (String name : names) {
            List<String> l = TokenUtilities.getClaimAsList(claims, name);
            if (l == null || l.isEmpty()) continue;
            return l;
        }
        return lRet;
    }

    public static KeystoreParams getSignedJwtKeystoreParams(GenericProperties gp) throws Exception {
        PolicyNegoziazioneToken policy = TokenUtilities.convertTo(gp);
        return TokenUtilities.getSignedJwtKeystoreParams(policy);
    }

    public static KeystoreParams getSignedJwtKeystoreParams(PolicyNegoziazioneToken policy) throws TokenException {
        String keyAlias;
        if (!policy.isRfc7523x509Grant()) {
            throw new TokenException("La configurazione nella policy " + policy.getName() + " non utilizza la funzionalit\u00e0 SignedJWT (RFC 7523)");
        }
        String keystoreType = policy.getJwtSignKeystoreType();
        if (keystoreType == null) {
            throw new TokenException("JWT Signature keystore type undefined");
        }
        String keystoreFile = policy.getJwtSignKeystoreFile();
        if (keystoreFile == null) {
            throw new TokenException("JWT Signature keystore file undefined");
        }
        String keystorePassword = policy.getJwtSignKeystorePassword();
        if (!(keystorePassword != null || SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType))) {
            boolean required = true;
            if (KeystoreType.JKS.isType(keystoreType)) {
                required = DBUtils.isKeystoreJksPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(keystoreType)) {
                required = DBUtils.isKeystorePkcs12PasswordRequired();
            }
            if (required) {
                throw new TokenException("JWT Signature keystore password undefined");
            }
        }
        if ((keyAlias = policy.getJwtSignKeyAlias()) == null && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) && !SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType)) {
            throw new TokenException("JWT Signature key alias undefined");
        }
        String keyPassword = policy.getJwtSignKeyPassword();
        if (!(keyPassword != null || SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType))) {
            boolean required = true;
            if (KeystoreType.JKS.isType(keystoreType)) {
                required = DBUtils.isKeystoreJksKeyPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(keystoreType)) {
                required = DBUtils.isKeystorePkcs12KeyPasswordRequired();
            }
            if (required) {
                throw new TokenException("JWT Signature key password undefined");
            }
        }
        String keystoreByokPolicy = policy.getJwtSignKeystoreByokPolicy();
        KeystoreParams keystoreParams = new KeystoreParams();
        keystoreParams.setPath(keystoreFile);
        keystoreParams.setType(keystoreType);
        keystoreParams.setPassword(keystorePassword);
        keystoreParams.setKeyAlias(keyAlias);
        keystoreParams.setKeyPassword(keyPassword);
        keystoreParams.setByokPolicy(keystoreByokPolicy);
        TokenUtilities.fillKeyPairParamters(keystoreParams, keystoreType, policy);
        return keystoreParams;
    }

    private static void fillKeyPairParamters(KeystoreParams keystoreParams, String keystoreType, PolicyNegoziazioneToken policy) throws TokenException {
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            String keystorePublicKeyFile = policy.getJwtSignKeystoreFilePublicKey();
            if (keystorePublicKeyFile == null) {
                throw new TokenException("JWT Signature public key file undefined");
            }
            keystoreParams.setKeyPairPublicKeyPath(keystorePublicKeyFile);
        }
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType)) {
            String keyPairAlgorithm = policy.getJwtSignKeyPairAlgorithm();
            if (keyPairAlgorithm == null) {
                throw new TokenException("JWT Signature key pair algorithm undefined");
            }
            keystoreParams.setKeyPairAlgorithm(keyPairAlgorithm);
        }
    }

    public static KeystoreParams getDpopKeystoreParams(GenericProperties gp) throws Exception {
        PolicyNegoziazioneToken policy = TokenUtilities.convertTo(gp);
        return TokenUtilities.getDpopKeystoreParams(policy);
    }

    public static KeystoreParams getDpopKeystoreParams(PolicyNegoziazioneToken policy) throws TokenException {
        String keyAlias;
        if (!policy.isDpop()) {
            throw new TokenException("La configurazione nella policy " + policy.getName() + " non utilizza la funzionalit\u00e0 DPoP");
        }
        String keystoreType = policy.getDpopSignKeystoreType();
        if (keystoreType == null) {
            throw new TokenException("DPoP Signature keystore type undefined");
        }
        String keystoreFile = policy.getDpopSignKeystoreFile();
        if (keystoreFile == null) {
            throw new TokenException("DPoP Signature keystore file undefined");
        }
        String keystorePassword = policy.getDpopSignKeystorePassword();
        if (keystorePassword == null && !SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            boolean required = true;
            if (KeystoreType.JKS.isType(keystoreType)) {
                required = DBUtils.isKeystoreJksPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(keystoreType)) {
                required = DBUtils.isKeystorePkcs12PasswordRequired();
            }
            if (required) {
                throw new TokenException("DPoP Signature keystore password undefined");
            }
        }
        if ((keyAlias = policy.getDpopSignKeyAlias()) == null && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            throw new TokenException("DPoP Signature key alias undefined");
        }
        String keyPassword = policy.getDpopSignKeyPassword();
        if (keyPassword == null && !SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            boolean required = true;
            if (KeystoreType.JKS.isType(keystoreType)) {
                required = DBUtils.isKeystoreJksKeyPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(keystoreType)) {
                required = DBUtils.isKeystorePkcs12KeyPasswordRequired();
            }
            if (required) {
                throw new TokenException("DPoP Signature key password undefined");
            }
        }
        String keystoreByokPolicy = policy.getDpopSignKeystoreByokPolicy();
        KeystoreParams keystoreParams = new KeystoreParams();
        keystoreParams.setPath(keystoreFile);
        keystoreParams.setType(keystoreType);
        keystoreParams.setPassword(keystorePassword);
        keystoreParams.setKeyAlias(keyAlias);
        keystoreParams.setKeyPassword(keyPassword);
        keystoreParams.setByokPolicy(keystoreByokPolicy);
        TokenUtilities.fillDpopKeyPairParameters(keystoreParams, keystoreType, policy);
        return keystoreParams;
    }

    private static void fillDpopKeyPairParameters(KeystoreParams keystoreParams, String keystoreType, PolicyNegoziazioneToken policy) throws TokenException {
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            String keystorePublicKeyFile = policy.getDpopSignKeystoreFilePublicKey();
            if (keystorePublicKeyFile == null) {
                throw new TokenException("DPoP Signature public key file undefined");
            }
            keystoreParams.setKeyPairPublicKeyPath(keystorePublicKeyFile);
        }
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            String keyPairAlgorithm = policy.getDpopSignKeyPairAlgorithm();
            if (keyPairAlgorithm == null) {
                throw new TokenException("DPoP Signature key pair algorithm undefined");
            }
            keystoreParams.setKeyPairAlgorithm(keyPairAlgorithm);
        }
    }

    public static PolicyNegoziazioneToken convertTo(GenericProperties gp) throws Exception {
        PolicyNegoziazioneToken policy = new PolicyNegoziazioneToken();
        policy.setName(gp.getNome());
        policy.setDescrizione(gp.getDescrizione());
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Property pConfig : gp.getPropertyList()) {
            properties.put(pConfig.getNome(), pConfig.getValore());
        }
        Map multiProperties = DBPropertiesUtils.toMultiMap(properties);
        policy.setProperties(multiProperties);
        return policy;
    }

    public static void checkClaims(String oggetto, Properties claims, String elemento, List<String> denyClaims, boolean checkSpazi) throws ProviderValidationException {
        if (claims != null && !claims.isEmpty()) {
            for (Object oClaim : claims.keySet()) {
                if (!(oClaim instanceof String)) continue;
                String claim = (String)oClaim;
                String value = claims.getProperty(claim);
                TokenUtilities.validateClaims(oggetto, elemento, denyClaims, checkSpazi, claim, value);
            }
        }
    }

    private static void validateClaims(String oggetto, String elemento, List<String> denyClaims, boolean checkSpazi, String claim, String value) throws ProviderValidationException {
        String indicato = "indicato nel campo '" + elemento + "'";
        if (denyClaims.contains(claim) || denyClaims.contains(claim.toLowerCase())) {
            throw new ProviderValidationException(oggetto + " '" + claim + "', " + indicato + ", non pu\u00f2 essere configurato");
        }
        if (value == null || StringUtils.isEmpty((String)value)) {
            throw new ProviderValidationException(oggetto + " '" + claim + "', " + indicato + ", non \u00e8 valorizzato");
        }
        if (checkSpazi) {
            if (value.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel " + oggetto + " '" + claim + "', " + indicato);
            }
        } else {
            if (value.startsWith(" ")) {
                throw new ProviderValidationException("Il valore del " + oggetto + " '" + claim + "', " + indicato + ", non deve iniziare con uno spazio");
            }
            if (value.endsWith(" ")) {
                throw new ProviderValidationException("Il valore del " + oggetto + " '" + claim + "', " + indicato + ", non deve terminare con uno spazio");
            }
        }
    }

    public static String deleteSignature(String token) {
        String[] tmp;
        if (token.contains(".") && (tmp = token.split("\\.")) != null && tmp.length == 3 && tmp[2] != null) {
            if (tmp[0] != null && tmp[1] != null) {
                return tmp[0] + "." + tmp[1] + "." + SIGNATURE_SUFFIX;
            }
            if (tmp[0] == null && tmp[1] != null) {
                return "." + tmp[1] + "." + SIGNATURE_SUFFIX;
            }
            if (tmp[0] != null && tmp[1] == null) {
                return tmp[0] + ".." + SIGNATURE_SUFFIX;
            }
            return ".." + SIGNATURE_SUFFIX;
        }
        return token;
    }

    public static Map<String, Serializable> replaceTokenInMapByValue(Map<String, Serializable> claims, String valueOriginale, String newValue) {
        HashMap<String, Serializable> newMap = new HashMap<String, Serializable>();
        if (claims != null && !claims.isEmpty()) {
            for (Map.Entry<String, Serializable> entry : claims.entrySet()) {
                String key = entry.getKey();
                Serializable o = claims.get(key);
                if (o instanceof String && valueOriginale.equals(o)) {
                    newMap.put(key, (Serializable)((Object)newValue));
                    continue;
                }
                newMap.put(key, o);
            }
        }
        return newMap;
    }

    public static List<String> getTokenPluginValues(ExternalResources externalResources, TipoPlugin tipoPlugin) throws ProviderException {
        return TokenUtilities.getTokenPluginList(externalResources, tipoPlugin, true);
    }

    public static List<String> getTokenPluginLabels(ExternalResources externalResources, TipoPlugin tipoPlugin) throws ProviderException {
        return TokenUtilities.getTokenPluginList(externalResources, tipoPlugin, false);
    }

    private static List<String> getTokenPluginList(ExternalResources externalResources, TipoPlugin tipoPlugin, boolean value) throws ProviderException {
        if (externalResources == null) {
            throw new ProviderException(EXTERNAL_RESOURCE_UNDEFINED);
        }
        Search ricerca = new Search(true);
        ricerca.addFilter(Liste.CONFIGURAZIONE_PLUGINS_CLASSI, "filtroTipoPluginClassi", tipoPlugin.toString());
        List list = null;
        try {
            list = PluginsDriverUtils.pluginsClassiList((ISearch)ricerca, (Connection)externalResources.getConnection(), (Logger)externalResources.getLog(), (String)externalResources.getTipoDB());
        }
        catch (Exception t) {
            throw new ProviderException(RECUPERO_PLUGIN_REGISTRATI_FALLITO_PREFIX + t.getMessage(), (Throwable)t);
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add("-");
        if (list != null && !list.isEmpty()) {
            for (Plugin plugin : list) {
                if (!plugin.isStato()) continue;
                if (value) {
                    values.add(plugin.getTipo());
                    continue;
                }
                values.add(plugin.getLabel());
            }
        }
        return values;
    }

    public static String dynamicUpdateTokenPluginChoice(ExternalResources externalResources, TipoPlugin tipoPlugin, Item item, String actualValue) {
        try {
            if (externalResources == null) {
                throw new ProviderException(EXTERNAL_RESOURCE_UNDEFINED);
            }
            Search ricerca = new Search(true);
            ricerca.addFilter(Liste.CONFIGURAZIONE_PLUGINS_CLASSI, "filtroTipoPluginClassi", tipoPlugin.toString());
            List<Plugin> listTmp = TokenUtilities.pluginsClassiList((ISearch)ricerca, externalResources);
            ArrayList<Plugin> list = null;
            if (listTmp != null && !listTmp.isEmpty()) {
                list = new ArrayList<Plugin>();
                for (Plugin p : listTmp) {
                    if (!p.isStato()) continue;
                    list.add(p);
                }
            }
            if (list == null || list.isEmpty()) {
                item.setType(ItemType.HIDDEN);
                item.setValue("-");
                return "-";
            }
            item.setType(ItemType.SELECT);
            item.setValue(actualValue);
            return actualValue;
        }
        catch (Exception t) {
            return actualValue;
        }
    }

    private static List<Plugin> pluginsClassiList(ISearch ricerca, ExternalResources externalResources) throws ProviderException {
        try {
            return PluginsDriverUtils.pluginsClassiList((ISearch)ricerca, (Connection)externalResources.getConnection(), (Logger)externalResources.getLog(), (String)externalResources.getTipoDB());
        }
        catch (Exception t) {
            throw new ProviderException(RECUPERO_PLUGIN_REGISTRATI_FALLITO_PREFIX + t.getMessage(), (Throwable)t);
        }
    }

    public static String dynamicUpdateTokenPluginClassName(ExternalResources externalResources, TipoPlugin tipoPlugin, List<?> items, Map<String, String> mapNameValue, Item item, String idChoice, String actualValue) {
        try {
            if (externalResources == null) {
                throw new ProviderException(EXTERNAL_RESOURCE_UNDEFINED);
            }
            List<Plugin> list = TokenUtilities.fillListTipoPlugin(externalResources, tipoPlugin);
            return TokenUtilities.dynamicUpdateTokenPluginClassName(list, items, mapNameValue, item, idChoice, actualValue);
        }
        catch (Exception exception) {
            return actualValue;
        }
    }

    private static List<Plugin> fillListTipoPlugin(ExternalResources externalResources, TipoPlugin tipoPlugin) throws ProviderException {
        Search ricerca = new Search(true);
        ricerca.addFilter(Liste.CONFIGURAZIONE_PLUGINS_CLASSI, "filtroTipoPluginClassi", tipoPlugin.toString());
        List<Plugin> listTmp = TokenUtilities.pluginsClassiList((ISearch)ricerca, externalResources);
        ArrayList<Plugin> list = null;
        if (listTmp != null && !listTmp.isEmpty()) {
            list = new ArrayList<Plugin>();
            for (Plugin p : listTmp) {
                if (!p.isStato()) continue;
                list.add(p);
            }
        }
        return list;
    }

    private static String dynamicUpdateTokenPluginClassName(List<Plugin> list, List<?> items, Map<String, String> mapNameValue, Item item, String idChoice, String actualValue) {
        if (list != null && !list.isEmpty()) {
            item.setRequired(false);
            if (actualValue == null) {
                item.setType(ItemType.HIDDEN);
                item.setValue("-");
                return "-";
            }
            String pluginSelected = AbstractSecurityProvider.readValue((String)idChoice, items, mapNameValue);
            if (pluginSelected != null && !StringUtils.isEmpty((String)pluginSelected) && !"-".equals(pluginSelected)) {
                item.setType(ItemType.HIDDEN);
                item.setValue("-");
                return "-";
            }
            if (StringUtils.isNotEmpty((String)actualValue) && !"-".equals(actualValue)) {
                item.setType(ItemType.TEXT);
            }
        } else {
            item.setType(ItemType.TEXT);
            item.setRequired(true);
        }
        return actualValue;
    }

    public static HashMap<String, Serializable> toHashMapSerializable(Map<String, Serializable> map) {
        HashMap<String, Serializable> mapNull = null;
        if (map instanceof HashMap) {
            return (HashMap)map;
        }
        if (map != null) {
            HashMap<String, Serializable> sMap = new HashMap<String, Serializable>();
            for (Map.Entry<String, Serializable> entry : map.entrySet()) {
                sMap.put(entry.getKey(), entry.getValue());
            }
        }
        return mapNull;
    }

    public static String readJtiFromInformazioniToken(Context context) {
        Object oInformazioniTokenNormalizzate = null;
        if (context != null) {
            oInformazioniTokenNormalizzate = context.getObject(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
        }
        InformazioniToken informazioniTokenNormalizzate = null;
        String jtiClaimReceived = null;
        if (oInformazioniTokenNormalizzate != null) {
            informazioniTokenNormalizzate = (InformazioniToken)oInformazioniTokenNormalizzate;
            jtiClaimReceived = informazioniTokenNormalizzate.getJti();
        }
        return jtiClaimReceived;
    }

    public static Map<String, Object> buildDynamicMap(Busta busta, RequestInfo requestInfo, Context pddContext, Logger log) {
        return DynamicMapBuilderUtils.buildDynamicMap(busta, requestInfo, pddContext, log);
    }

    public static String convertDynamicPropertyValue(String v, String nome, Map<String, Object> dynamicMap, Context context) throws TokenException {
        return DynamicMapBuilderUtils.convertDynamicPropertyValue(v, nome, dynamicMap, context);
    }

    public static void injectJOSEConfig(Properties p, AbstractPolicyToken policyToken, DynamicDiscovery dynamicDiscovery, Busta busta, IDSoggetto idDominio, IDServizio idServizio, Context context, Logger log, RequestInfo requestInfo, IState state, boolean delegata) throws TokenException {
        Map<String, Object> dynamicMap = TokenUtilities.buildDynamicMap(busta, requestInfo, context, log);
        if (policyToken instanceof PolicyGestioneToken) {
            TokenUtilities.injectJOSEConfigDynamicDiscovery(p, (PolicyGestioneToken)policyToken, dynamicDiscovery, dynamicMap, context);
        }
        TokenUtilities.injectJOSEConfigKeystore(p, dynamicMap, context);
        TokenUtilities.injectJOSEConfigSsl(p, policyToken, dynamicMap, context);
        TokenUtilities.injectJOSEConfigTimeout(p, policyToken, dynamicMap, context);
        TokenUtilities.injectJOSEConfigProxy(p, policyToken, dynamicMap, context);
        TokenUtilities.injectJOSEConfigForwardProxy(p, policyToken, idDominio, idServizio, requestInfo, state, delegata);
    }

    private static void injectJOSEConfigDynamicDiscovery(Properties p, PolicyGestioneToken policyGestioneToken, DynamicDiscovery dynamicDiscovery, Map<String, Object> dynamicMap, Context context) throws TokenException {
        if (policyGestioneToken.isDynamicDiscovery()) {
            GestoreTokenValidazioneUtilities.check(dynamicDiscovery);
            String endpoint = dynamicDiscovery.getJwksUri();
            endpoint = TokenUtilities.convertDynamicPropertyValue(endpoint, "endpoint", dynamicMap, context);
            if (endpoint == null || StringUtils.isEmpty((String)endpoint)) {
                throw new TokenException("DynamicDiscovery.jwkUri undefined");
            }
            p.put("rs.security.keystore.file", endpoint);
        }
    }

    private static void injectJOSEConfigKeystore(Properties p, Map<String, Object> dynamicMap, Context context) throws TokenException {
        String type;
        String pwd;
        String alias;
        String file = p.getProperty("rs.security.keystore.file");
        if (file != null && !"".equals(file)) {
            file = TokenUtilities.convertDynamicPropertyValue(file, "file", dynamicMap, context);
            p.put("rs.security.keystore.file", file);
        }
        if ((alias = p.getProperty("rs.security.keystore.alias")) != null && !"".equals(alias)) {
            alias = TokenUtilities.convertDynamicPropertyValue(alias, "alias", dynamicMap, context);
            p.put("rs.security.keystore.alias", alias);
        }
        if ((pwd = p.getProperty("rs.security.keystore.password")) != null && !"".equals(pwd)) {
            pwd = TokenUtilities.convertDynamicPropertyValue(pwd, "pwd", dynamicMap, context);
            p.put("rs.security.keystore.password", pwd);
        }
        if ((type = p.getProperty("rs.security.keystore.type")) != null && !"".equals(type)) {
            type = TokenUtilities.convertDynamicPropertyValue(type, "type", dynamicMap, context);
            p.put("rs.security.keystore.type", type);
        }
    }

    public static void injectJOSEConfigSsl(Properties p, AbstractPolicyToken policyToken, Map<String, Object> dynamicMap, Context context) throws TokenException {
        Properties sslConfig;
        boolean https = false;
        if (policyToken instanceof PolicyGestioneToken) {
            https = ((PolicyGestioneToken)policyToken).isEndpointHttps();
        } else if (policyToken instanceof PolicyAttributeAuthority) {
            try {
                https = ((PolicyAttributeAuthority)policyToken).isEndpointHttps();
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
        if (https && (sslConfig = policyToken.getProperties().get("sslConfig")) != null) {
            TokenUtilities.injectJOSEConfigSsl(p, sslConfig, dynamicMap, context);
        }
    }

    private static void injectJOSEConfigSsl(Properties p, Properties sslConfig, Map<String, Object> dynamicMap, Context context) throws TokenException {
        String trustAll = sslConfig.getProperty("trustAllCerts");
        if (trustAll != null && StringUtils.isNotEmpty((String)trustAll) && "true".equalsIgnoreCase(trustAll)) {
            p.put("rs.security.keystore.trustAll.ssl", trustAll);
        } else {
            TokenUtilities.injectJOSEConfigSslTrustStore(p, sslConfig, dynamicMap, context);
        }
        String hostnameVerifier = sslConfig.getProperty("hostnameVerifier");
        if (hostnameVerifier != null && StringUtils.isNotEmpty((String)hostnameVerifier)) {
            p.put("rs.security.keystore.ssl.hostNameVerifier", hostnameVerifier);
        }
    }

    private static void injectJOSEConfigSslTrustStore(Properties p, Properties sslConfig, Map<String, Object> dynamicMap, Context context) throws TokenException {
        String trustLocation = sslConfig.getProperty("trustStoreLocation");
        if (trustLocation != null && StringUtils.isNotEmpty((String)trustLocation)) {
            String trustCrl;
            String trustPassword;
            trustLocation = TokenUtilities.convertDynamicPropertyValue(trustLocation, "trustLocation", dynamicMap, context);
            p.put("rs.security.keystore.file.ssl", trustLocation);
            String trustType = sslConfig.getProperty("trustStoreType");
            if (trustType != null && StringUtils.isNotEmpty((String)trustType)) {
                trustType = TokenUtilities.convertDynamicPropertyValue(trustType, "trustType", dynamicMap, context);
                p.put("rs.security.keystore.type.ssl", trustType);
            }
            if ((trustPassword = sslConfig.getProperty("trustStorePassword")) != null && StringUtils.isNotEmpty((String)trustPassword)) {
                trustPassword = TokenUtilities.convertDynamicPropertyValue(trustPassword, "trustPassword", dynamicMap, context);
                p.put("rs.security.keystore.password.ssl", trustPassword);
            }
            if ((trustCrl = sslConfig.getProperty("trustStoreCRLs")) != null && StringUtils.isNotEmpty((String)trustCrl)) {
                trustCrl = TokenUtilities.convertDynamicPropertyValue(trustCrl, "trustCrl", dynamicMap, context);
                p.put("rs.security.keystore.ssl.crl", trustCrl);
            }
        }
    }

    private static void injectJOSEConfigTimeout(Properties p, AbstractPolicyToken policyToken, Map<String, Object> dynamicMap, Context context) throws TokenException {
        Properties endpointConfig = policyToken.getProperties().get("endpointConfig");
        if (endpointConfig != null && endpointConfig.containsKey("connectionTimeout")) {
            String readTimeout;
            String connectionTimeout = endpointConfig.getProperty("connectionTimeout");
            if (connectionTimeout != null && StringUtils.isNotEmpty((String)connectionTimeout)) {
                connectionTimeout = TokenUtilities.convertDynamicPropertyValue(connectionTimeout, "connectionTimeout", dynamicMap, context);
            }
            if ((readTimeout = endpointConfig.getProperty("readConnectionTimeout")) != null && StringUtils.isNotEmpty((String)readTimeout)) {
                readTimeout = TokenUtilities.convertDynamicPropertyValue(readTimeout, "readTimeout", dynamicMap, context);
            }
            if (connectionTimeout != null) {
                p.put("rs.security.keystore.ssl.connectionTimeout", connectionTimeout);
            }
            if (readTimeout != null) {
                p.put("rs.security.keystore.ssl.readTimeout", readTimeout);
            }
        }
    }

    private static void injectJOSEConfigProxy(Properties p, AbstractPolicyToken policyToken, Map<String, Object> dynamicMap, Context context) throws TokenException {
        Properties endpointConfig = policyToken.getProperties().get("endpointConfig");
        if (endpointConfig != null && endpointConfig.containsKey("proxyHostname")) {
            String portProxy;
            String hostProxy = endpointConfig.getProperty("proxyHostname");
            if (hostProxy != null && StringUtils.isNotEmpty((String)hostProxy)) {
                hostProxy = TokenUtilities.convertDynamicPropertyValue(hostProxy, "hostProxy", dynamicMap, context);
            }
            if ((portProxy = endpointConfig.getProperty("proxyPort")) != null && StringUtils.isNotEmpty((String)portProxy)) {
                portProxy = TokenUtilities.convertDynamicPropertyValue(portProxy, "portProxy", dynamicMap, context);
            }
            if (hostProxy != null) {
                p.put("rs.security.proxy.hostname", hostProxy);
            }
            if (portProxy != null) {
                p.put("rs.security.proxy.port", portProxy);
            }
            TokenUtilities.injectJOSEConfigProxyCredentials(p, endpointConfig, dynamicMap, context);
        }
    }

    private static void injectJOSEConfigProxyCredentials(Properties p, Properties endpointConfig, Map<String, Object> dynamicMap, Context context) throws TokenException {
        String usernameProxy = endpointConfig.getProperty("proxyUsername");
        String passwordProxy = endpointConfig.getProperty("proxyPassword");
        if (usernameProxy != null && StringUtils.isNotEmpty((String)usernameProxy)) {
            usernameProxy = TokenUtilities.convertDynamicPropertyValue(usernameProxy, "usernameProxy", dynamicMap, context);
            p.put("rs.security.proxy.username", usernameProxy);
            if (passwordProxy != null && StringUtils.isNotEmpty((String)passwordProxy)) {
                passwordProxy = TokenUtilities.convertDynamicPropertyValue(passwordProxy, "passwordProxy", dynamicMap, context);
            }
            if (passwordProxy != null) {
                p.put("rs.security.proxy.password", passwordProxy);
            }
        }
    }

    private static void injectJOSEConfigForwardProxy(Properties p, AbstractPolicyToken policyToken, IDSoggetto idDominio, IDServizio idServizio, RequestInfo requestInfo, IState state, boolean delegata) throws TokenException {
        ForwardProxy forwardProxy = TokenUtilities.getForwardProxy(policyToken, requestInfo, state, delegata, idDominio, idServizio);
        if (forwardProxy != null && forwardProxy.isEnabled() && forwardProxy.getConfigToken() != null) {
            boolean enabled = false;
            if (policyToken instanceof PolicyGestioneToken) {
                enabled = forwardProxy.getConfigToken().isTokenJwtValidationEnabled();
            } else if (policyToken instanceof PolicyAttributeAuthority) {
                enabled = forwardProxy.getConfigToken().isAttributeAuthorityResponseJwtValidationEnabled();
            }
            if (enabled) {
                p.put("rs.security.forwardProxy.endpoint", forwardProxy.getUrl());
                if (forwardProxy.getConfig() != null) {
                    if (forwardProxy.getConfig().getHeader() != null) {
                        p.put("rs.security.forwardProxy.header", forwardProxy.getConfig().getHeader());
                        p.put("rs.security.forwardProxy.header.base64", "" + forwardProxy.getConfig().isHeaderBase64());
                    } else if (forwardProxy.getConfig().getQuery() != null) {
                        p.put("rs.security.forwardProxy.query", forwardProxy.getConfig().getQuery());
                        p.put("rs.security.forwardProxy.query.base64", "" + forwardProxy.getConfig().isQueryBase64());
                    }
                }
            }
        }
    }

    public static ForwardProxy getForwardProxy(AbstractPolicyToken policyToken, RequestInfo requestInfo, IState state, boolean delegata, IDSoggetto idDominio, IDServizio idServizio) throws TokenException {
        ForwardProxy forwardProxy = null;
        ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(state);
        if (configurazionePdDManager.isForwardProxyEnabled(requestInfo)) {
            try {
                IDGenericProperties policy = new IDGenericProperties();
                policy.setTipologia("gestionePolicyToken");
                policy.setNome(policyToken.getName());
                forwardProxy = delegata ? configurazionePdDManager.getForwardProxyConfigFruizione(idDominio, idServizio, policy, requestInfo) : configurazionePdDManager.getForwardProxyConfigErogazione(idDominio, idServizio, policy, requestInfo);
            }
            catch (Exception e) {
                throw new TokenException(GestoreToken.getMessageErroreGovWayProxy(e), e);
            }
        }
        return forwardProxy;
    }

    public static void injectSameKeystoreForHttpsClient(Properties sslConfig, Properties sslClientConfig) {
        if (!sslClientConfig.containsKey("keyStoreLocation") && !sslClientConfig.containsKey("keyStorePassword")) {
            String trustStoreLocation = sslConfig.getProperty("trustStoreLocation");
            String trustStorePassword = sslConfig.getProperty("trustStorePassword");
            if (trustStoreLocation != null) {
                sslClientConfig.put("keyStoreLocation", trustStoreLocation);
                if (trustStorePassword != null) {
                    sslClientConfig.put("trustStorePassword", trustStorePassword);
                }
            }
        }
    }

    public static String normalizeHtu(String url) throws TokenException {
        try {
            URI uri = new URI(url);
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null).toString();
        }
        catch (Exception e) {
            throw new TokenException("Invalid URL for htu: " + e.getMessage(), e);
        }
    }

    public static String computeJwkThumbprint(JsonWebKey jwk) throws TokenException {
        try {
            return JwkUtils.getThumbprint((JsonWebKey)jwk);
        }
        catch (Exception e) {
            throw new TokenException("Error computing JWK thumbprint: " + e.getMessage(), e);
        }
    }
}

