/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.attribute_authority.pa;

import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.token.GestoreToken;
import org.openspcoop2.pdd.core.token.attribute_authority.AttributeAuthorityException;
import org.openspcoop2.pdd.core.token.attribute_authority.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.token.attribute_authority.pa.EsitoRecuperoAttributiPortaApplicativa;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.slf4j.Logger;

public class GestioneAttributeAuthority {
    private Logger log;
    private String idTransazione;
    private PdDContext pddContext;
    private IProtocolFactory<?> protocolFactory;

    public GestioneAttributeAuthority(Logger log, String idTransazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory) {
        this.log = log;
        this.idTransazione = idTransazione;
        this.pddContext = pddContext;
        this.protocolFactory = protocolFactory;
    }

    public EsitoRecuperoAttributiPortaApplicativa readAttributes(DatiInvocazionePortaApplicativa datiInvocazione) throws AttributeAuthorityException {
        try {
            EsitoRecuperoAttributiPortaApplicativa esito = (EsitoRecuperoAttributiPortaApplicativa)GestoreToken.readAttributes(this.log, datiInvocazione, this.pddContext, this.protocolFactory, false, this.getDominio(datiInvocazione), this.getServizio(datiInvocazione));
            return esito;
        }
        catch (Throwable e) {
            throw new AttributeAuthorityException(e.getMessage(), e);
        }
    }

    private IDSoggetto getDominio(DatiInvocazionePortaApplicativa datiInvocazione) {
        IDSoggetto soggetto = null;
        if (datiInvocazione.getPa() != null) {
            soggetto = new IDSoggetto(datiInvocazione.getPa().getTipoSoggettoProprietario(), datiInvocazione.getPa().getNomeSoggettoProprietario());
        } else if (datiInvocazione.getPd() != null) {
            soggetto = new IDSoggetto(datiInvocazione.getPd().getTipoSoggettoProprietario(), datiInvocazione.getPd().getNomeSoggettoProprietario());
        }
        return soggetto;
    }

    private IDServizio getServizio(DatiInvocazionePortaApplicativa datiInvocazione) throws DriverRegistroServiziException {
        IDServizio servizio = null;
        if (datiInvocazione.getPa() != null) {
            servizio = IDServizioFactory.getInstance().getIDServizioFromValues(datiInvocazione.getPa().getServizio().getTipo(), datiInvocazione.getPa().getServizio().getNome(), datiInvocazione.getPa().getTipoSoggettoProprietario(), datiInvocazione.getPa().getNomeSoggettoProprietario(), datiInvocazione.getPa().getServizio().getVersione().intValue());
        } else if (datiInvocazione.getPd() != null) {
            servizio = IDServizioFactory.getInstance().getIDServizioFromValues(datiInvocazione.getPd().getServizio().getTipo(), datiInvocazione.getPd().getServizio().getNome(), datiInvocazione.getPd().getSoggettoErogatore().getTipo(), datiInvocazione.getPd().getSoggettoErogatore().getNome(), datiInvocazione.getPd().getServizio().getVersione().intValue());
        }
        return servizio;
    }
}

