/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.dpop.jti;

import org.openspcoop2.pdd.core.token.PolicyGestioneToken;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.dpop.jti.IJtiValidator;
import org.openspcoop2.pdd.core.token.dpop.jti.TipoValidazioneJtiDPoP;
import org.openspcoop2.pdd.core.token.dpop.jti.impl.DisabledJtiValidator;
import org.openspcoop2.pdd.core.token.dpop.jti.impl.DistributedJtiValidator;
import org.openspcoop2.pdd.core.token.dpop.jti.impl.LocalJtiValidator;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.slf4j.Logger;

public class JtiValidatorFactory {
    private static final Logger logger = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    private JtiValidatorFactory() {
    }

    public static IJtiValidator createValidator(PolicyGestioneToken policy) throws TokenException {
        TipoValidazioneJtiDPoP tipo;
        if (policy == null) {
            throw new TokenException("PolicyGestioneToken is null - cannot create JTI validator");
        }
        String jtiValidationType = policy.getValidazioneDPoPJtiValidation();
        if (jtiValidationType == null || jtiValidationType.trim().isEmpty()) {
            logger.debug("JTI validation type not configured - defaulting to DISABLED");
            jtiValidationType = TipoValidazioneJtiDPoP.DISABLED.name();
        }
        try {
            tipo = TipoValidazioneJtiDPoP.valueOf(jtiValidationType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new TokenException("Invalid JTI validation type: [" + jtiValidationType + "]. Valid values: DISABLED, LOCAL_REJECT, LOCAL_EVICT, DISTRIBUTED", e);
        }
        switch (tipo) {
            case DISABLED: {
                logger.info("Creating DisabledJtiValidator for policy [{}]", (Object)policy.getName());
                return new DisabledJtiValidator();
            }
            case LOCAL_REJECT: {
                return JtiValidatorFactory.createLocalValidator(policy, true);
            }
            case LOCAL_EVICT: {
                return JtiValidatorFactory.createLocalValidator(policy, false);
            }
            case DISTRIBUTED: {
                logger.info("Creating DistributedJtiValidator for policy [{}]", (Object)policy.getName());
                return new DistributedJtiValidator();
            }
        }
        throw new TokenException("Unsupported JTI validation type: " + tipo);
    }

    private static LocalJtiValidator createLocalValidator(PolicyGestioneToken policy, boolean failOnFull) throws TokenException {
        Long maxSize = policy.getValidazioneDPoPJtiMaxSize();
        if (maxSize == null || maxSize <= 0L) {
            throw new TokenException("validazioneDPoPJtiMaxSize must be configured and > 0 for local JTI validation (policy: " + policy.getName() + ")");
        }
        String policyType = failOnFull ? "Reject Policy" : "LRU Policy";
        logger.info("Creating LocalJtiValidator ({}) for policy [{}] with per-entry TTL, maxSize={}", new Object[]{policyType, policy.getName(), maxSize});
        return new LocalJtiValidator(maxSize, failOnFull);
    }
}

