/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.dpop.jti;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.token.dpop.jti.JtiEntry;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class LocalJtiCacheManager {
    private static final Logger logger = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    private static final Map<String, Cache<String, JtiEntry>> cacheRegistry = new ConcurrentHashMap<String, Cache<String, JtiEntry>>();
    private static ScheduledExecutorService cleanupScheduler = null;
    private static final AtomicBoolean schedulerInitialized = new AtomicBoolean(false);
    private static final Object schedulerLock = new Object();
    private static final long ESTIMATED_BYTES_PER_JTI_ENTRY = 200L;

    private LocalJtiCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initCleanupSchedulerIfNeeded() {
        if (!schedulerInitialized.get()) {
            Object object = schedulerLock;
            synchronized (object) {
                if (schedulerInitialized.compareAndSet(false, true)) {
                    LocalJtiCacheManager.initCleanupScheduler();
                }
            }
        }
    }

    private static void initCleanupScheduler() {
        try {
            int intervalSeconds = OpenSPCoop2Properties.getInstance().getGestioneTokenDPoPJtiLocalCacheCleanupIntervalSeconds();
            if (intervalSeconds > 0) {
                cleanupScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
                    Thread t = new Thread(r, "JTI-Cache-Cleanup");
                    t.setDaemon(true);
                    return t;
                });
                cleanupScheduler.scheduleAtFixedRate(() -> {
                    try {
                        if (!cacheRegistry.isEmpty()) {
                            cacheRegistry.values().forEach(Cache::cleanUp);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error during JTI cache cleanup: {}", (Object)e.getMessage(), (Object)e);
                    }
                }, intervalSeconds, intervalSeconds, TimeUnit.SECONDS);
                logger.info("JTI cache cleanup scheduler started with interval {} seconds", (Object)intervalSeconds);
            } else {
                logger.info("JTI cache cleanup scheduler disabled (interval=0)");
            }
        }
        catch (Exception e) {
            logger.error("Failed to initialize JTI cache cleanup scheduler: {}", (Object)e.getMessage(), (Object)e);
            schedulerInitialized.set(false);
        }
    }

    public static Cache<String, JtiEntry> getOrCreateCache(String policyName, long maxSize) {
        LocalJtiCacheManager.initCleanupSchedulerIfNeeded();
        return cacheRegistry.computeIfAbsent(policyName, key -> {
            logger.info("Creating Caffeine JTI cache for policy [{}] with per-entry TTL, maxSize={}", (Object)policyName, (Object)maxSize);
            return Caffeine.newBuilder().expireAfter((Expiry)new Expiry<String, JtiEntry>(){

                public long expireAfterCreate(String jti, JtiEntry entry, long currentTime) {
                    long expirationMillis = entry.getExpirationMillis();
                    long currentMillis = DateManager.getTimeMillis();
                    long remainingMillis = expirationMillis - currentMillis;
                    return TimeUnit.MILLISECONDS.toNanos(Math.max(0L, remainingMillis));
                }

                public long expireAfterUpdate(String jti, JtiEntry entry, long currentTime, long currentDuration) {
                    return currentDuration;
                }

                public long expireAfterRead(String jti, JtiEntry entry, long currentTime, long currentDuration) {
                    return currentDuration;
                }
            }).maximumSize(maxSize).recordStats().build();
        });
    }

    public static void removeCache(String policyName) {
        Cache<String, JtiEntry> removed = cacheRegistry.remove(policyName);
        if (removed != null) {
            removed.invalidateAll();
            removed.cleanUp();
            logger.info("Removed and cleaned up JTI cache for policy [{}]", (Object)policyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAll() {
        logger.info("Shutting down all JTI caches ({} policies)", (Object)cacheRegistry.size());
        Object object = schedulerLock;
        synchronized (object) {
            if (cleanupScheduler != null) {
                cleanupScheduler.shutdownNow();
                cleanupScheduler = null;
                schedulerInitialized.set(false);
            }
        }
        cacheRegistry.forEach((policyName, cache) -> {
            cache.invalidateAll();
            cache.cleanUp();
        });
        cacheRegistry.clear();
    }

    public static Map<String, CacheStats> getAllStats() {
        ConcurrentHashMap<String, CacheStats> stats = new ConcurrentHashMap<String, CacheStats>();
        cacheRegistry.forEach((policyName, cache) -> stats.put((String)policyName, cache.stats()));
        return stats;
    }

    public static boolean hasCacheForPolicy(String policyName) {
        return cacheRegistry.containsKey(policyName);
    }

    public static Cache<String, JtiEntry> getCache(String policyName) {
        return cacheRegistry.get(policyName);
    }

    public static String listPolicyNames(String separator) {
        if (cacheRegistry.isEmpty()) {
            return "Nessuna cache DPoP JTI attiva";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String policyName : cacheRegistry.keySet()) {
            if (!first) {
                sb.append(separator);
            }
            sb.append(policyName);
            first = false;
        }
        return sb.toString();
    }

    public static String printStatsForPolicy(String policyName) {
        if (policyName == null || policyName.isEmpty()) {
            return "Nome policy non specificato";
        }
        Cache<String, JtiEntry> cache = cacheRegistry.get(policyName);
        if (cache == null) {
            return "Cache DPoP JTI per la policy '" + policyName + "' non trovata o non inizializzata";
        }
        return LocalJtiCacheManager.formatCacheStats(policyName, cache, false);
    }

    public static String printStatsAllPolicies() {
        if (cacheRegistry.isEmpty()) {
            return "Nessuna cache DPoP JTI attiva";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("=== Statistiche Cache DPoP JTI (anti-replay) ===\n");
        sb.append("Numero policy attive: ").append(cacheRegistry.size()).append("\n\n");
        long totalEntries = 0L;
        long totalEstimatedBytes = 0L;
        for (Map.Entry<String, Cache<String, JtiEntry>> entry : cacheRegistry.entrySet()) {
            String name = entry.getKey();
            Cache<String, JtiEntry> cache = entry.getValue();
            sb.append(LocalJtiCacheManager.formatCacheStats(name, cache, true));
            sb.append("\n");
            long size = cache.estimatedSize();
            totalEntries += size;
            totalEstimatedBytes += size * 200L;
        }
        sb.append("=== Totale Globale ===\n");
        sb.append("Entries totali: ").append(totalEntries).append("\n");
        sb.append("RAM stimata totale: ").append(LocalJtiCacheManager.formatBytes(totalEstimatedBytes)).append("\n");
        return sb.toString();
    }

    private static String formatCacheStats(String policyName, Cache<String, JtiEntry> cache, boolean appendPolicyName) {
        CacheStats stats = cache.stats();
        long estimatedSize = cache.estimatedSize();
        long estimatedBytes = estimatedSize * 200L;
        StringBuilder sb = new StringBuilder();
        if (appendPolicyName) {
            sb.append("--- Policy: ").append(policyName).append(" ---\n");
        }
        sb.append("Entries: ").append(estimatedSize).append("\n");
        sb.append("RAM stimata: ").append(LocalJtiCacheManager.formatBytes(estimatedBytes));
        sb.append(" (~").append(200L).append(" bytes/entry)\n");
        sb.append("Hit count: ").append(stats.hitCount()).append("\n");
        sb.append("Miss count: ").append(stats.missCount()).append("\n");
        sb.append("Hit rate: ").append(String.format("%.2f%%", stats.hitRate() * 100.0)).append("\n");
        sb.append("Eviction count: ").append(stats.evictionCount()).append("\n");
        sb.append("Load success count: ").append(stats.loadSuccessCount()).append("\n");
        sb.append("Load failure count: ").append(stats.loadFailureCount()).append("\n");
        return sb.toString();
    }

    private static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.2f KB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }
}

