/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.dpop.jti.impl;

import java.time.Duration;
import java.util.Date;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.RedissonManager;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.dpop.jti.IJtiValidator;
import org.openspcoop2.pdd.core.token.parser.IDPoPParser;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;

public class DistributedJtiValidator
implements IJtiValidator {
    private static final Logger logger = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    private static final String KEY_PREFIX = "dpop:jti:";

    public DistributedJtiValidator() {
        logger.debug("DistributedJtiValidator initialized (using shared RedissonManager)");
    }

    @Override
    public void validateAndStore(String policyName, String jti, IDPoPParser dpopParser, long toleranceMillis) throws TokenException, UtilsException {
        RedissonClient redisson = RedissonManager.getRedissonClient(true);
        if (redisson == null) {
            throw new UtilsException("RedissonClient not available - cannot validate JTI");
        }
        String redisKey = KEY_PREFIX + policyName + ":" + jti;
        RBucket bucket = redisson.getBucket(redisKey);
        if (bucket.isExists()) {
            logger.warn("DPoP replay attack detected for policy [{}]: JTI [{}] already used (distributed check via Redis)", (Object)policyName, (Object)jti);
            throw new TokenException("DPoP JTI [" + jti + "] has already been used (replay attack detected)");
        }
        Date iat = dpopParser.getIssuedAt();
        long ttlSeconds = this.calculateTTL(iat, toleranceMillis);
        if (ttlSeconds <= 0L) {
            logger.debug("DPoP with JTI [{}] already expired (ttl={}s) - not stored", (Object)jti, (Object)ttlSeconds);
            throw new TokenException("DPoP token expired: iat [" + iat + "] + tolerance [" + toleranceMillis + "ms] exceeded");
        }
        bucket.set((Object)Boolean.TRUE, Duration.ofSeconds(ttlSeconds));
        logger.debug("DPoP JTI [{}] stored successfully in Redis for policy [{}] with TTL={}s", new Object[]{jti, policyName, ttlSeconds});
    }

    private long calculateTTL(Date iat, long toleranceMillis) {
        if (iat == null) {
            return toleranceMillis / 1000L;
        }
        long iatMillis = iat.getTime();
        long currentMillis = DateManager.getTimeMillis();
        long expirationMillis = iatMillis + toleranceMillis;
        long remainingMillis = expirationMillis - currentMillis;
        long ttlSeconds = remainingMillis / 1000L;
        if (remainingMillis % 1000L > 0L) {
            ++ttlSeconds;
        }
        return Math.max(0L, ttlSeconds);
    }

    @Override
    public boolean isAvailable() {
        try {
            if (RedissonManager.isRedissonClientInitialized()) {
                return true;
            }
            return RedissonManager.getRedissonClient(true) != null;
        }
        catch (Exception e) {
            logger.warn("Redis not available for JTI validation: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }
}

