/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkReaderWriter;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.parser.IDPoPParser;
import org.openspcoop2.pdd.core.token.parser.TipologiaClaimsDPoP;
import org.openspcoop2.pdd.core.token.parser.TokenUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.security.JWTParser;

public class BasicDPoPParser
implements IDPoPParser {
    private TipologiaClaimsDPoP tipologiaClaims;
    private Properties parserConfig;
    private String raw;
    private Map<String, Serializable> header;
    private Map<String, Serializable> payload;
    private JsonWebKey jsonWebKeyObject = null;
    private String jsonWebKey = null;

    public BasicDPoPParser(TipologiaClaimsDPoP tipologiaClaims) {
        this(tipologiaClaims, null);
    }

    public BasicDPoPParser(TipologiaClaimsDPoP tipologiaClaims, Properties parserConfig) {
        this.tipologiaClaims = tipologiaClaims;
        this.parserConfig = parserConfig;
    }

    @Override
    public void init(String raw) throws UtilsException {
        this.raw = raw;
        JWTParser jwtParser = new JWTParser(this.raw);
        this.header = this.convert(jwtParser.getHeaderClaims());
        this.payload = this.convert(jwtParser.getPayloadClaims());
    }

    private Map<String, Serializable> convert(Map<String, String> m) {
        HashMap<String, Serializable> newM = null;
        if (m != null) {
            newM = new HashMap<String, Serializable>();
            if (!m.isEmpty()) {
                for (Map.Entry<String, String> entry : m.entrySet()) {
                    newM.put(entry.getKey(), (Serializable)((Object)entry.getValue()));
                }
            }
        }
        return newM;
    }

    @Override
    public String getRaw() throws UtilsException {
        return this.raw;
    }

    @Override
    public void checkHttpTransaction(Integer httpResponseCode) throws UtilsException {
    }

    @Override
    public boolean isValid() {
        try {
            return this.header != null && this.payload != null && this.getType() != null && this.getAlgorithm() != null && this.getJsonWebKeyAsString() != null && this.getHttpMethod() != null && this.getHttpUri() != null && this.getIssuedAt() != null && this.getAccessTokenHash() != null && this.getJWTIdentifier() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getType() {
        String tmp = null;
        switch (this.tipologiaClaims) {
            case RFC9449: {
                tmp = TokenUtilities.getClaimAsString(this.header, "typ");
                break;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "dpop.parser.typ");
                tmp = TokenUtilities.getFirstClaimAsString(this.header, claimNames);
                break;
            }
        }
        return tmp;
    }

    @Override
    public String getAlgorithm() {
        String tmp = null;
        switch (this.tipologiaClaims) {
            case RFC9449: {
                tmp = TokenUtilities.getClaimAsString(this.header, "alg");
                break;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "dpop.parser.alg");
                tmp = TokenUtilities.getFirstClaimAsString(this.header, claimNames);
                break;
            }
        }
        return tmp;
    }

    @Override
    public JsonWebKey getJsonWebKey() throws UtilsException {
        if (this.jsonWebKeyObject != null) {
            return this.jsonWebKeyObject;
        }
        String jwkJson = this.getJsonWebKeyAsString();
        JwkReaderWriter jwkReader = new JwkReaderWriter();
        this.jsonWebKeyObject = jwkReader.jsonToJwk(jwkJson);
        return this.jsonWebKeyObject;
    }

    @Override
    public String getJsonWebKeyAsString() throws UtilsException {
        if (this.jsonWebKey != null) {
            return this.jsonWebKey;
        }
        String jwkClaimName = this.getJsonWebKeyClaimName();
        if (jwkClaimName == null) {
            return null;
        }
        try {
            if (this.raw == null || this.raw.isEmpty()) {
                return null;
            }
            String[] parts = this.raw.split("\\.");
            if (parts.length < 2) {
                return null;
            }
            ObjectMapper mapper = new ObjectMapper();
            byte[] headerBytes = Base64.getUrlDecoder().decode(parts[0]);
            String headerJson = new String(headerBytes, StandardCharsets.UTF_8);
            Map headerMap = (Map)mapper.readValue(headerJson, Map.class);
            Object jwkObject = headerMap.get(jwkClaimName);
            if (jwkObject == null) {
                return null;
            }
            String jwkJson = null;
            if (jwkObject instanceof Map) {
                jwkJson = mapper.writeValueAsString(jwkObject);
            } else if (jwkObject instanceof String) {
                jwkJson = (String)jwkObject;
            } else {
                return null;
            }
            if (jwkJson == null || jwkJson.trim().isEmpty()) {
                return null;
            }
            this.jsonWebKey = jwkJson;
            return jwkJson;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private String getJsonWebKeyClaimName() {
        String jwkClaimName = null;
        switch (this.tipologiaClaims) {
            case RFC9449: {
                jwkClaimName = "jwk";
                break;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "dpop.parser.jwk");
                if (claimNames == null || claimNames.isEmpty()) break;
                jwkClaimName = claimNames.get(0);
                break;
            }
            case CUSTOM: {
                return null;
            }
        }
        return jwkClaimName;
    }

    @Override
    public String getJWTIdentifier() {
        String tmp = null;
        switch (this.tipologiaClaims) {
            case RFC9449: {
                tmp = TokenUtilities.getClaimAsString(this.payload, "jti");
                break;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "dpop.parser.jti");
                tmp = TokenUtilities.getFirstClaimAsString(this.payload, claimNames);
                break;
            }
        }
        return tmp;
    }

    @Override
    public String getHttpMethod() {
        String tmp = null;
        switch (this.tipologiaClaims) {
            case RFC9449: {
                tmp = TokenUtilities.getClaimAsString(this.payload, "htm");
                break;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "dpop.parser.htm");
                tmp = TokenUtilities.getFirstClaimAsString(this.payload, claimNames);
                break;
            }
        }
        return tmp;
    }

    @Override
    public String getHttpUri() {
        String tmp = null;
        switch (this.tipologiaClaims) {
            case RFC9449: {
                tmp = TokenUtilities.getClaimAsString(this.payload, "htu");
                break;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "dpop.parser.htu");
                tmp = TokenUtilities.getFirstClaimAsString(this.payload, claimNames);
                break;
            }
        }
        return tmp;
    }

    @Override
    public Date getIssuedAt() {
        String tmp = null;
        switch (this.tipologiaClaims) {
            case RFC9449: {
                tmp = TokenUtilities.getClaimAsString(this.payload, "iat");
                break;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "dpop.parser.iat");
                tmp = TokenUtilities.getFirstClaimAsString(this.payload, claimNames);
                break;
            }
        }
        return tmp != null ? TokenUtils.parseTimeInSecond(tmp) : null;
    }

    @Override
    public String getAccessTokenHash() {
        String tmp = null;
        switch (this.tipologiaClaims) {
            case RFC9449: {
                tmp = TokenUtilities.getClaimAsString(this.payload, "ath");
                break;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "dpop.parser.ath");
                tmp = TokenUtilities.getFirstClaimAsString(this.payload, claimNames);
                break;
            }
        }
        return tmp;
    }
}

