/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.parser.ClaimsNegoziazione;
import org.openspcoop2.pdd.core.token.parser.INegoziazioneTokenParser;
import org.openspcoop2.pdd.core.token.parser.TipologiaClaimsNegoziazione;
import org.openspcoop2.pdd.core.token.parser.TokenUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;

public class BasicNegoziazioneTokenParser
implements INegoziazioneTokenParser {
    protected Integer httpResponseCode;
    protected String raw;
    protected Map<String, Serializable> claims;
    protected TipologiaClaimsNegoziazione parser;
    protected Properties parserConfig;
    protected Date now;

    public BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione parser) {
        this(parser, null);
    }

    public BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione parser, Properties parserConfig) {
        this.parser = parser;
        this.parserConfig = parserConfig;
    }

    @Override
    public void init(String raw, Map<String, Serializable> claims) {
        this.raw = raw;
        this.claims = claims;
        this.now = DateManager.getDate();
    }

    @Override
    public void checkHttpTransaction(Integer httpResponseCode) throws UtilsException {
        this.httpResponseCode = httpResponseCode;
        switch (this.parser) {
            case OAUTH2_RFC_6749: 
            case MAPPING: 
            case RAW: 
            case CUSTOM: {
                if (this.httpResponseCode == null || this.httpResponseCode >= 200 && this.httpResponseCode <= 299) break;
                String msgError = "Connessione terminata con errore (codice trasporto: " + this.httpResponseCode + ")";
                throw new UtilsException(msgError + ": " + this.raw);
            }
        }
    }

    @Override
    public boolean isValid() {
        if (TipologiaClaimsNegoziazione.RAW.equals((Object)this.parser) ? this.raw == null || StringUtils.isEmpty((String)this.raw) : this.claims == null || this.claims.size() <= 0) {
            return false;
        }
        switch (this.parser) {
            case OAUTH2_RFC_6749: {
                String claim = TokenUtilities.getClaimAsString(this.claims, "access_token");
                return !StringUtils.isEmpty((String)claim);
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.access_token");
                if (claimNames == null || claimNames.isEmpty()) {
                    return false;
                }
                String claim = TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
                return !StringUtils.isEmpty((String)claim);
            }
            case RAW: 
            case CUSTOM: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getAccessToken() {
        switch (this.parser) {
            case OAUTH2_RFC_6749: {
                String claim = TokenUtilities.getClaimAsString(this.claims, "access_token");
                return claim;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.access_token");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case RAW: {
                return this.raw;
            }
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getRefreshToken() {
        switch (this.parser) {
            case OAUTH2_RFC_6749: {
                String claim = TokenUtilities.getClaimAsString(this.claims, "refresh_token");
                return claim;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.refresh_token");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case RAW: 
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getTokenType() {
        switch (this.parser) {
            case OAUTH2_RFC_6749: {
                String claim = TokenUtilities.getClaimAsString(this.claims, "token_type");
                return claim;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.token_type");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case RAW: 
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public Date getExpired() {
        String tmpIn = null;
        String tmpOn = null;
        switch (this.parser) {
            case OAUTH2_RFC_6749: {
                tmpIn = TokenUtilities.getClaimAsString(this.claims, "expires_in");
                if (tmpIn != null && !StringUtils.isEmpty((String)tmpIn)) break;
                tmpOn = TokenUtilities.getClaimAsString(this.claims, "expires_on");
                break;
            }
            case MAPPING: {
                tmpIn = this.parseMappingExpiresIn();
                if (tmpIn != null && !StringUtils.isEmpty((String)tmpIn)) break;
                tmpOn = this.parseMappingExpiresOn();
                break;
            }
            case RAW: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.expires_in_sec");
                if (claimNames == null || claimNames.isEmpty()) break;
                tmpIn = claimNames.get(0);
                break;
            }
            case CUSTOM: {
                return null;
            }
        }
        return this.parseDate(tmpIn, tmpOn);
    }

    private String parseMappingExpiresIn() {
        List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.expires_in");
        if (claimNames != null && !claimNames.isEmpty()) {
            return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
        }
        return null;
    }

    private String parseMappingExpiresOn() {
        List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.expires_on");
        if (claimNames != null && !claimNames.isEmpty()) {
            return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
        }
        return null;
    }

    @Override
    public Date getRefreshExpired() {
        String tmpIn = null;
        String tmpOn = null;
        switch (this.parser) {
            case OAUTH2_RFC_6749: {
                tmpIn = this.parseOauth2RFC6749RefreshExpiresIn();
                if (tmpIn != null && !StringUtils.isEmpty((String)tmpIn)) break;
                tmpOn = this.parseOauth2RFC6749RefreshExpiresOn();
                break;
            }
            case MAPPING: {
                tmpIn = this.parseMappingRefreshExpiresIn();
                if (tmpIn != null && !StringUtils.isEmpty((String)tmpIn)) break;
                tmpOn = this.parseMappingRefreshExpiresOn();
                break;
            }
            case RAW: 
            case CUSTOM: {
                return null;
            }
        }
        return this.parseDate(tmpIn, tmpOn);
    }

    private String parseOauth2RFC6749RefreshExpiresIn() {
        for (String claim : ClaimsNegoziazione.REFRESH_EXPIRE_IN_CUSTOM_CLAIMS) {
            String tmpC = TokenUtilities.getClaimAsString(this.claims, claim);
            if (tmpC == null || !StringUtils.isNotEmpty((String)tmpC)) continue;
            return tmpC;
        }
        return null;
    }

    private String parseOauth2RFC6749RefreshExpiresOn() {
        for (String claim : ClaimsNegoziazione.REFRESH_EXPIRE_ON_CUSTOM_CLAIMS) {
            String tmpC = TokenUtilities.getClaimAsString(this.claims, claim);
            if (tmpC == null || !StringUtils.isNotEmpty((String)tmpC)) continue;
            return tmpC;
        }
        return null;
    }

    private String parseMappingRefreshExpiresIn() {
        List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.refresh_expires_in");
        if (claimNames != null && !claimNames.isEmpty()) {
            return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
        }
        return null;
    }

    private String parseMappingRefreshExpiresOn() {
        List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.refresh_expires_on");
        if (claimNames != null && !claimNames.isEmpty()) {
            return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
        }
        return null;
    }

    private Date parseDate(String tmpIn, String tmpOn) {
        if (tmpIn != null) {
            return TokenUtils.convertLifeTimeInSeconds(this.now, tmpIn);
        }
        if (tmpOn != null) {
            return TokenUtils.parseTimeInSecond(tmpOn);
        }
        return null;
    }

    @Override
    public List<String> getScopes() {
        String tmpScopes = null;
        if (TipologiaClaimsNegoziazione.OAUTH2_RFC_6749.equals((Object)this.parser)) {
            tmpScopes = TokenUtilities.getClaimAsString(this.claims, "scope");
        } else if (TipologiaClaimsNegoziazione.MAPPING.equals((Object)this.parser)) {
            return this.readMappingScopes();
        }
        return this.readScope(tmpScopes);
    }

    public List<String> readMappingScopes() {
        List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.scope");
        List<String> tmpScopesList = TokenUtilities.getFirstClaimAsList(this.claims, claimNames);
        List<String> lNull = null;
        if (tmpScopesList != null && !tmpScopesList.isEmpty()) {
            return this.readMappingScopes(tmpScopesList);
        }
        return lNull;
    }

    public List<String> readMappingScopes(List<String> tmpScopesList) {
        ArrayList<String> scopes = new ArrayList<String>();
        for (String s : tmpScopesList) {
            List<String> tmp = this.readScope(s);
            if (tmp == null || tmp.isEmpty()) continue;
            for (String sTmp : tmp) {
                if (scopes.contains(sTmp)) continue;
                scopes.add(sTmp);
            }
        }
        return scopes;
    }

    private List<String> readScope(String tmpScopes) {
        String[] tmpArray;
        List<String> lNull = null;
        if (tmpScopes != null && (tmpArray = tmpScopes.split(" ")) != null && tmpArray.length > 0) {
            ArrayList<String> scopes = new ArrayList<String>();
            for (int i = 0; i < tmpArray.length; ++i) {
                scopes.add(tmpArray[i].trim());
            }
            return scopes;
        }
        return lNull;
    }
}

