/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.transazioni;

import java.lang.invoke.CallSite;
import java.security.SecureRandom;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.IDAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.config.utils.OpenSPCoopAppenderUtilities;
import org.openspcoop2.core.controllo_traffico.constants.Costanti;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.core.transazioni.dao.ITransazioneApplicativoServerService;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.core.transazioni.utils.TransactionServerUtils;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.DBConsegneMessageBoxManager;
import org.openspcoop2.pdd.config.DBConsegnePreseInCaricoManager;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.handlers.transazioni.ExceptionSerialzerFileSystem;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateDBManager;
import org.openspcoop2.pdd.core.transazioni.TransactionMultiDeliverException;
import org.openspcoop2.pdd.core.transazioni.TransazioniSAProcessTimes;
import org.openspcoop2.pdd.logger.DumpOpenSPCoopProtocolAppender;
import org.openspcoop2.pdd.logger.MsgDiagnosticoOpenSPCoopProtocolAppender;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.utils.EsitiConfigUtils;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.slf4j.Logger;

public class GestoreConsegnaMultipla {
    private static final String ID_MODULO = "GestoreConsegnaMultipla";
    private static DAOFactory daoFactory = null;
    private static DAOFactory daoFactoryDevNull = null;
    private static ServiceManagerProperties daoFactoryServiceManagerPropertiesTransazioni = null;
    private static ServiceManagerProperties daoFactoryDevNullServiceManagerPropertiesTransazioni = null;
    private static Logger daoFactoryLoggerTransazioniSql = null;
    private static Logger daoFactoryLoggerTransazioniDevNull = null;
    private static OpenSPCoop2Properties openspcoopProperties = null;
    private static GestoreConsegnaMultipla gestoreConsegnaMultipla = null;
    private static Random rndInstance = null;
    private Logger log = null;
    private Logger logSql = null;
    private String tipoDatabase = null;
    private boolean debug = false;
    private IDiagnosticProducer msgDiagnosticiOpenSPCoopAppender = null;
    private IDumpProducer dumpOpenSPCoopAppender = null;
    private boolean transazioniRegistrazioneDumpHeadersCompactEnabled = false;
    private static volatile boolean debugStaticValue = true;

    private static synchronized void init() throws TransactionMultiDeliverException {
        if (gestoreConsegnaMultipla == null) {
            String tipoDatabase = null;
            boolean debug = false;
            Logger daoFactoryLoggerTransazioni = null;
            try {
                openspcoopProperties = OpenSPCoop2Properties.getInstance();
                tipoDatabase = openspcoopProperties.getDatabaseType();
                if (tipoDatabase == null) {
                    throw new TransactionMultiDeliverException("Tipo Database non definito");
                }
                openspcoopProperties = OpenSPCoop2Properties.getInstance();
                debug = openspcoopProperties.isTransazioniDebug();
                daoFactoryLoggerTransazioni = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioni(debug);
                daoFactoryLoggerTransazioniSql = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniSql(debug);
                daoFactoryLoggerTransazioniDevNull = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniDevNull();
                daoFactory = DAOFactory.getInstance((Logger)daoFactoryLoggerTransazioniSql);
                DAOFactoryProperties daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)daoFactoryLoggerTransazioniSql);
                daoFactoryServiceManagerPropertiesTransazioni = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)ProjectInfo.getInstance());
                daoFactoryServiceManagerPropertiesTransazioni.setShowSql(debug);
                daoFactoryServiceManagerPropertiesTransazioni.setDatabaseType(DBTransazioniManager.getInstance().getTipoDatabase());
                daoFactoryDevNull = DAOFactory.getInstance((Logger)daoFactoryLoggerTransazioniDevNull);
                DAOFactoryProperties daoFactoryPropertiesDevNull = DAOFactoryProperties.getInstance((Logger)daoFactoryLoggerTransazioniDevNull);
                daoFactoryDevNullServiceManagerPropertiesTransazioni = daoFactoryPropertiesDevNull.getServiceManagerProperties((IProjectInfo)ProjectInfo.getInstance());
                daoFactoryDevNullServiceManagerPropertiesTransazioni.setShowSql(debug);
                daoFactoryDevNullServiceManagerPropertiesTransazioni.setDatabaseType(DBTransazioniManager.getInstance().getTipoDatabase());
            }
            catch (Exception e) {
                throw new TransactionMultiDeliverException("Inizializzazione risorse database non riuscita: " + e.getMessage(), e);
            }
            try {
                gestoreConsegnaMultipla = new GestoreConsegnaMultipla(daoFactoryLoggerTransazioni, daoFactoryLoggerTransazioniSql, tipoDatabase, debug);
            }
            catch (Exception e) {
                throw new TransactionMultiDeliverException("Inizializzazione GestoreConsegnaMultipla non riuscita: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GestoreConsegnaMultipla getInstance() throws TransactionMultiDeliverException {
        if (gestoreConsegnaMultipla != null) return gestoreConsegnaMultipla;
        Class<GestoreConsegnaMultipla> clazz = GestoreConsegnaMultipla.class;
        synchronized (GestoreConsegnaMultipla.class) {
            GestoreConsegnaMultipla.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return gestoreConsegnaMultipla;
        }
    }

    private static synchronized void initRandom() {
        if (rndInstance == null) {
            rndInstance = new SecureRandom();
        }
    }

    public static Random getRandom() {
        if (rndInstance == null) {
            GestoreConsegnaMultipla.initRandom();
        }
        return rndInstance;
    }

    private GestoreConsegnaMultipla(Logger log, Logger logSql, String tipoDatabase, boolean debug) throws TransactionMultiDeliverException {
        this.log = log;
        this.logSql = logSql;
        this.tipoDatabase = tipoDatabase;
        this.debug = debug;
        boolean usePdDConnection = true;
        try {
            this.msgDiagnosticiOpenSPCoopAppender = new MsgDiagnosticoOpenSPCoopProtocolAppender();
            OpenspcoopAppender diagnosticoOpenSPCoopAppender = new OpenspcoopAppender();
            diagnosticoOpenSPCoopAppender.setTipo("__gestoreConsegnaMultipla");
            ArrayList diagnosticoOpenSPCoopAppenderProperties = new ArrayList();
            OpenSPCoopAppenderUtilities.addParameters((Logger)this.logSql, diagnosticoOpenSPCoopAppenderProperties, null, null, null, null, null, (String)this.tipoDatabase, (boolean)usePdDConnection, (boolean)this.debug);
            OpenSPCoopAppenderUtilities.addCheckProperties(diagnosticoOpenSPCoopAppenderProperties, (boolean)false);
            diagnosticoOpenSPCoopAppender.setPropertyList(diagnosticoOpenSPCoopAppenderProperties);
            this.msgDiagnosticiOpenSPCoopAppender.initializeAppender(diagnosticoOpenSPCoopAppender);
            this.msgDiagnosticiOpenSPCoopAppender.isAlive();
        }
        catch (Exception e) {
            throw new TransactionMultiDeliverException("Errore durante l'inizializzazione del DiagnosticoAppender: " + e.getMessage(), e);
        }
        try {
            this.dumpOpenSPCoopAppender = new DumpOpenSPCoopProtocolAppender();
            OpenspcoopAppender dumpOpenSPCoopAppenderEngine = new OpenspcoopAppender();
            dumpOpenSPCoopAppenderEngine.setTipo("__gestoreConsegnaMultipla");
            ArrayList dumpOpenSPCoopAppenderProperties = new ArrayList();
            OpenSPCoopAppenderUtilities.addParameters((Logger)this.logSql, dumpOpenSPCoopAppenderProperties, null, null, null, null, null, (String)this.tipoDatabase, (boolean)usePdDConnection, (boolean)this.debug);
            OpenSPCoopAppenderUtilities.addCheckProperties(dumpOpenSPCoopAppenderProperties, (boolean)false);
            dumpOpenSPCoopAppenderEngine.setPropertyList(dumpOpenSPCoopAppenderProperties);
            this.dumpOpenSPCoopAppender.initializeAppender(dumpOpenSPCoopAppenderEngine);
            this.dumpOpenSPCoopAppender.isAlive();
            this.transazioniRegistrazioneDumpHeadersCompactEnabled = openspcoopProperties.isTransazioniRegistrazioneDumpHeadersCompactEnabled();
        }
        catch (Exception e) {
            throw new TransactionMultiDeliverException("Errore durante l'inizializzazione del DumpAppender: " + e.getMessage(), e);
        }
    }

    public void safeCreate(TransazioneApplicativoServer transazioneApplicativoServer, IDPortaApplicativa idPA, IOpenSPCoopState state, RequestInfo requestInfo, Context context) {
        transazioneApplicativoServer.setClusterIdPresaInCarico(openspcoopProperties.getClusterId(false));
        this.getConnectionAndSave(transazioneApplicativoServer, transazioneApplicativoServer.getProtocollo(), false, false, idPA, state, null, requestInfo, context, "create", OpenSPCoopStateDBManager.runtime);
    }

    public void safeUpdateConsegna(TransazioneApplicativoServer transazioneApplicativoServer, IDPortaApplicativa idPA, IOpenSPCoopState state, RequestInfo requestInfo, Context context) {
        transazioneApplicativoServer.setClusterIdConsegna(openspcoopProperties.getClusterId(false));
        this.getConnectionAndSave(transazioneApplicativoServer, transazioneApplicativoServer.getProtocollo(), true, true, idPA, state, null, requestInfo, context, "updateDeliveredMessage", OpenSPCoopStateDBManager.consegnePreseInCarico);
    }

    public void safeUpdatePrelievoIM(TransazioneApplicativoServer transazioneApplicativoServer, IDPortaApplicativa idPA, IOpenSPCoopState state, Context context) {
        transazioneApplicativoServer.setClusterIdPrelievoIm(openspcoopProperties.getClusterId(false));
        this.getConnectionAndSave(transazioneApplicativoServer, transazioneApplicativoServer.getProtocollo(), true, false, idPA, state, null, null, context, "updateRetrieveMessageByMessageBox", OpenSPCoopStateDBManager.messageBox);
    }

    public void safeUpdateEliminazioneIM(TransazioneApplicativoServer transazioneApplicativoServer, IDPortaApplicativa idPA, IOpenSPCoopState state, Context context) {
        transazioneApplicativoServer.setClusterIdEliminazioneIm(openspcoopProperties.getClusterId(false));
        this.getConnectionAndSave(transazioneApplicativoServer, transazioneApplicativoServer.getProtocollo(), true, false, idPA, state, null, null, context, "updateDeletedMessageByMessageBox", OpenSPCoopStateDBManager.messageBox);
    }

    public void safeUpdateMessaggioScaduto(TransazioneApplicativoServer transazioneApplicativoServer, IDPortaApplicativa idPA, IOpenSPCoopState state) {
        this.getConnectionAndSave(transazioneApplicativoServer, transazioneApplicativoServer.getProtocollo(), true, false, idPA, state, null, null, null, "updateExpiredMessage", OpenSPCoopStateDBManager.runtime);
    }

    public void safeSave(MsgDiagnostico diagnostico, IDPortaApplicativa idPA, IState state, RequestInfo requestInfo, Context context) {
        this.getConnectionAndSave(diagnostico, diagnostico.getProtocollo(), false, false, idPA, null, state, requestInfo, context, "saveDiagnostic", OpenSPCoopStateDBManager.consegnePreseInCarico);
    }

    public void safeSave(Messaggio dumpMessaggio, IDPortaApplicativa idPA, IState state, RequestInfo requestInfo, Context context) {
        this.getConnectionAndSave(dumpMessaggio, dumpMessaggio.getProtocollo(), false, false, idPA, null, state, requestInfo, context, "saveContent", OpenSPCoopStateDBManager.consegnePreseInCarico);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConnectionAndSave(Object o, String protocol, boolean update, boolean throwNotFoundIfNotExists, IDPortaApplicativa idPA, IOpenSPCoopState openspcoopState, IState state, RequestInfo requestInfo, Context context, String tipoOperazione, OpenSPCoopStateDBManager dbManagerSource) {
        TransazioniSAProcessTimes times = null;
        long timeStart = -1L;
        boolean buildDetailsSA = false;
        boolean buildDetailsUpdateTransaction = false;
        if (openspcoopProperties.isTransazioniRegistrazioneSlowLog()) {
            times = new TransazioniSAProcessTimes();
            timeStart = DateManager.getTimeMillis();
            buildDetailsSA = openspcoopProperties.isTransazioniRegistrazioneSlowLogConnettoriMultipliProcessTransactionSADetails();
            buildDetailsUpdateTransaction = openspcoopProperties.isTransazioniRegistrazioneSlowLogConnettoriMultipliUpdateTransactionDetails();
        }
        try {
            this.getConnectionAndSave(o, protocol, update, throwNotFoundIfNotExists, idPA, openspcoopState, state, requestInfo, context, tipoOperazione, times, buildDetailsSA, buildDetailsUpdateTransaction, dbManagerSource);
        }
        finally {
            long timeEnd;
            long timeProcess;
            if (times != null && (timeProcess = (timeEnd = DateManager.getTimeMillis()) - timeStart) >= (long)openspcoopProperties.getTransazioniRegistrazioneSlowLogThresholdMs()) {
                StringBuilder sb = new StringBuilder();
                sb.append(timeProcess);
                if (times.idTransazione != null) {
                    sb.append(" <").append(times.idTransazione).append(">");
                }
                if (times.servizioApplicativoErogatore != null) {
                    sb.append(" (sa:").append(times.servizioApplicativoErogatore).append(")");
                }
                sb.append(" [GestoreConsegnaMultipla." + tipoOperazione + "]");
                sb.append(" ").append(times.toString());
                String msg = sb.toString();
                OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniSlowLog().info(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void getConnectionAndSave(Object o, String protocol, boolean update, boolean throwNotFoundIfNotExists, IDPortaApplicativa idPA, IOpenSPCoopState openspcoopState, IState state, RequestInfo requestInfo, Context context, String tipoOperazione, TransazioniSAProcessTimes times, boolean buildDetailsSA, boolean buildDetailsUpdateTransaction, OpenSPCoopStateDBManager dbManagerSource) {
        block206: {
            block204: {
                block203: {
                    esitiProperties = null;
                    try {
                        if (requestInfo != null && requestInfo.getProtocolFactory() != null) {
                            esitiProperties = EsitiProperties.getInstance((Logger)this.log, (IProtocolFactory)requestInfo.getProtocolFactory());
                            if (esitiProperties == null && requestInfo.getProtocolFactory().getProtocol() != null) {
                                esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)this.log, (String)requestInfo.getProtocolFactory().getProtocol());
                            }
                        } else {
                            esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)this.log, (String)protocol);
                        }
                    }
                    catch (Throwable e) {
                        this.log.error("Errore avvenuto durante la lettura del gestore degli esiti: " + e.getMessage(), e);
                    }
                    if (esitiProperties == null) {
                        return;
                    }
                    try {
                        configPdDManager = ConfigurazionePdDManager.getInstance();
                        configTracciamento = configPdDManager.getOpenSPCoopAppenderTracciamento();
                        bf = new StringBuilder();
                        v0 = esitiConfig = configTracciamento != null ? configTracciamento.getEsiti() : null;
                        if (idPA != null && (pa = configPdDManager.getPortaApplicativaSafeMethod(idPA, requestInfo)) != null && pa.getTracciamento() != null && pa.getTracciamento().getEsiti() != null) {
                            esitiConfig = pa.getTracciamento().getEsiti();
                        }
                        esitiDaRegistrare = EsitiConfigUtils.getRegistrazioneEsiti((String)esitiConfig, (Logger)this.log, (StringBuilder)bf);
                        code = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA);
                        codeAsString = "" + code;
                        if (esitiDaRegistrare != null && !esitiDaRegistrare.isEmpty() && !esitiDaRegistrare.contains(codeAsString)) {
                            msg = "Non devo registrare l'informazione, esito '" + codeAsString + "' disabilitato nel tracciamento";
                            this.log.debug(msg);
                            return;
                        }
                    }
                    catch (Throwable e) {
                        this.log.debug("Errore avvenuto durante la lettura della configurazione delle transazioni da salvare: " + e.getMessage(), e);
                    }
                    richiedenteConnessione = null;
                    if (o != null) {
                        if (o instanceof TransazioneApplicativoServer) {
                            richiedenteConnessione = tipoOperazione + "_" + ((TransazioneApplicativoServer)o).getIdTransazione();
                            richiedenteConnessione = richiedenteConnessione + "_" + ((TransazioneApplicativoServer)o).getServizioApplicativoErogatore();
                            if (times != null) {
                                times.idTransazione = ((TransazioneApplicativoServer)o).getIdTransazione();
                                times.servizioApplicativoErogatore = ((TransazioneApplicativoServer)o).getServizioApplicativoErogatore();
                            }
                        } else if (o instanceof MsgDiagnostico) {
                            richiedenteConnessione = tipoOperazione + "_" + ((MsgDiagnostico)o).getIdTransazione();
                            if (times != null) {
                                times.idTransazione = ((MsgDiagnostico)o).getIdTransazione();
                            }
                        } else if (o instanceof Messaggio) {
                            richiedenteConnessione = tipoOperazione + "_" + ((Messaggio)o).getIdTransazione();
                            if (times != null) {
                                times.idTransazione = ((Messaggio)o).getIdTransazione();
                            }
                        }
                    }
                    dbResource = null;
                    dbManagerTransazioni = null;
                    dbConsegnePreseInCaricoManager = null;
                    dbConsegneMessageBoxManager = null;
                    if (dbManagerSource != null) {
                        switch (1.$SwitchMap$org$openspcoop2$pdd$core$state$OpenSPCoopStateDBManager[dbManagerSource.ordinal()]) {
                            case 1: {
                                dbManagerTransazioni = DBTransazioniManager.getInstance();
                                break;
                            }
                            case 2: {
                                dbConsegnePreseInCaricoManager = DBConsegnePreseInCaricoManager.getInstanceTransazioni();
                                break;
                            }
                            case 3: {
                                dbConsegnePreseInCaricoManager = DBConsegnePreseInCaricoManager.getInstanceTransazioni();
                                break;
                            }
                            case 4: {
                                dbConsegneMessageBoxManager = DBConsegneMessageBoxManager.getInstanceTransazioni();
                            }
                        }
                    } else {
                        dbManagerTransazioni = DBTransazioniManager.getInstance();
                    }
                    idDominio = GestoreConsegnaMultipla.openspcoopProperties.getIdentitaPortaDefault(protocol, requestInfo);
                    exceptionSerializerFileSystem = new ExceptionSerialzerFileSystem(this.log);
                    con = null;
                    isMessaggioConsegnato = false;
                    possibileTerminazioneSingleIntegrationManagerMessage = false;
                    consegnaInErrore = false;
                    transazioneApplicativoServer = null;
                    useConnectionRuntime = false;
                    timeStart = -1L;
                    try {
                        if (times != null) {
                            timeStart = DateManager.getTimeMillis();
                        }
                        checkPddRuntimeDatasource = false;
                        if (dbManagerTransazioni != null) {
                            checkPddRuntimeDatasource = dbManagerTransazioni.useRuntimePdD();
                        } else if (dbConsegnePreseInCaricoManager != null) {
                            checkPddRuntimeDatasource = dbConsegnePreseInCaricoManager.useRuntimePdD();
                        } else if (dbConsegneMessageBoxManager != null) {
                            checkPddRuntimeDatasource = dbConsegneMessageBoxManager.useRuntimePdD();
                        }
                        if (checkPddRuntimeDatasource) {
                            if (openspcoopState != null) {
                                if (openspcoopState instanceof OpenSPCoopState && (s = (OpenSPCoopState)openspcoopState).getConnectionDB() != null && !s.getConnectionDB().isClosed()) {
                                    con = s.getConnectionDB();
                                    useConnectionRuntime = true;
                                }
                            } else if (state instanceof StateMessage && (s = (StateMessage)state).getConnectionDB() != null && !s.getConnectionDB().isClosed()) {
                                con = s.getConnectionDB();
                                useConnectionRuntime = true;
                            }
                        }
                        if (!useConnectionRuntime) {
                            if (dbManagerTransazioni != null) {
                                dbResource = dbManagerTransazioni.getResource(idDominio, "GestoreConsegnaMultipla", richiedenteConnessione);
                            } else if (dbConsegnePreseInCaricoManager != null) {
                                dbResource = dbConsegnePreseInCaricoManager.getResource(idDominio, "GestoreConsegnaMultipla", richiedenteConnessione);
                            } else if (dbConsegneMessageBoxManager != null) {
                                dbResource = dbConsegneMessageBoxManager.getResource(idDominio, "GestoreConsegnaMultipla", richiedenteConnessione);
                            }
                            if (dbResource != null) {
                                con = (Connection)dbResource.getResource();
                            }
                        }
                    }
                    finally {
                        if (times != null) {
                            timeEnd = DateManager.getTimeMillis();
                            times.getConnection = timeProcess = timeEnd - timeStart;
                        }
                    }
                    autoCommit = false;
                    if (con != null) {
                        con.setAutoCommit(autoCommit);
                    }
                    if (o instanceof TransazioneApplicativoServer) {
                        conflict = 0;
                        iteration = 1;
                        updateEffettuato = false;
                        try {
                            if (times != null) {
                                timeStart = DateManager.getTimeMillis();
                                if (buildDetailsSA) {
                                    times.saDetails = new ArrayList<String>();
                                }
                            }
                            jdbcServiceManager = (JDBCServiceManager)GestoreConsegnaMultipla.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, autoCommit, GestoreConsegnaMultipla.daoFactoryServiceManagerPropertiesTransazioni, GestoreConsegnaMultipla.daoFactoryLoggerTransazioniDevNull);
                            jdbcServiceManager.getJdbcProperties().setShowSql(this.debug);
                            transazioneService = jdbcServiceManager.getTransazioneApplicativoServerService();
                            transazioneApplicativoServer = (TransazioneApplicativoServer)o;
                            this.setDettaglioEsito(transazioneApplicativoServer, esitiProperties, context);
                            if (transazioneApplicativoServer.isConsegnaTerminata()) {
                                isMessaggioConsegnato = true;
                            } else if (transazioneApplicativoServer.getDataEliminazioneIm() != null || transazioneApplicativoServer.getDataMessaggioScaduto() != null) {
                                isMessaggioConsegnato = true;
                                possibileTerminazioneSingleIntegrationManagerMessage = true;
                            } else if (transazioneApplicativoServer.isConsegnaTrasparente() && transazioneApplicativoServer.getDataUscitaRichiesta() != null) {
                                consegnaInErrore = true;
                            }
                            useSelectForUpdate = true;
                            oldTransactionIsolation = -1;
                            if (!useSelectForUpdate) {
                                try {
                                    oldTransactionIsolation = con.getTransactionIsolation();
                                    JDBCUtilities.setTransactionIsolationSerializable((TipiDatabase)GestoreConsegnaMultipla.daoFactoryServiceManagerPropertiesTransazioni.getDatabase(), (Connection)con);
                                }
                                catch (Exception er) {
                                    throw new CoreException("(setIsolation) " + er.getMessage(), (Throwable)er);
                                }
                            }
                            gestioneSerializableDBAttesaAttiva = GestoreConsegnaMultipla.openspcoopProperties.getGestioneSerializableDBAttesaAttiva();
                            gestioneSerializableDBCheckInterval = GestoreConsegnaMultipla.openspcoopProperties.getGestioneSerializableDBCheckInterval();
                            scadenzaWhile = DateManager.getTimeMillis() + gestioneSerializableDBAttesaAttiva;
                            lastT = null;
                            while (!updateEffettuato && DateManager.getTimeMillis() < scadenzaWhile) {
                                timeDetails = null;
                                try {
                                    if (times != null && buildDetailsSA) {
                                        timeDetails = new ArrayList<CallSite>();
                                    }
                                    transazioneAggiornata = TransactionServerUtils.save((ITransazioneApplicativoServerService)transazioneService, (TransazioneApplicativoServer)((TransazioneApplicativoServer)o), (boolean)update, (boolean)throwNotFoundIfNotExists, (boolean)false, (boolean)useSelectForUpdate, timeDetails);
                                    timeStartCommit = -1L;
                                    if (timeDetails != null) {
                                        timeStartCommit = DateManager.getTimeMillis();
                                    }
                                    if (con != null) {
                                        con.commit();
                                    }
                                    if (timeDetails != null) {
                                        timeEnd = DateManager.getTimeMillis();
                                        timeProcess = timeEnd - timeStartCommit;
                                        timeDetails.add((CallSite)("commit:" + timeProcess));
                                    }
                                    if (!transazioneAggiornata) {
                                        isMessaggioConsegnato = false;
                                    }
                                    updateEffettuato = true;
                                }
                                catch (Throwable e) {
                                    ++conflict;
                                    lastT = e;
                                    if (timeDetails != null && (errorMsg = e.getMessage()) != null) {
                                        if (errorMsg.length() > 100) {
                                            errorMsg = errorMsg.substring(0, 97) + "...";
                                        }
                                        timeDetails.add((CallSite)("error:" + (String)errorMsg));
                                    }
                                    try {
                                        if (con != null) {
                                            con.rollback();
                                        }
                                    }
                                    catch (Exception errorMsg) {
                                        // empty catch block
                                    }
                                    {
                                    }
                                }
                                finally {
                                    if (timeDetails != null && !timeDetails.isEmpty()) {
                                        for (String detail : timeDetails) {
                                            times.saDetails.add("i" + iteration + "-" + detail);
                                        }
                                    }
                                }
                                if (updateEffettuato) continue;
                                try {
                                    Utilities.sleep((long)GestoreConsegnaMultipla.getRandom().nextInt(gestioneSerializableDBCheckInterval));
                                }
                                catch (Exception var46_97) {
                                    // empty catch block
                                }
                                ++iteration;
                            }
                            if (!useSelectForUpdate) {
                                try {
                                    if (con != null) {
                                        con.setTransactionIsolation(oldTransactionIsolation);
                                    }
                                }
                                catch (Exception er) {
                                    throw new CoreException("(ripristinoIsolation) " + er.getMessage(), (Throwable)er);
                                }
                            }
                            if (lastT != null && !updateEffettuato) {
                                msgError = "[id:" + transazioneApplicativoServer.getIdTransazione() + "][sa:" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "][" + transazioneApplicativoServer.getConnettoreNome() + "] 'updateTransazioneSA' failed: " + lastT.getMessage();
                                GestoreConsegnaMultipla.daoFactoryLoggerTransazioniSql.error(msgError, lastT);
                                this.log.error(msgError, lastT);
                                throw lastT;
                            }
                            break block203;
                        }
                        finally {
                            if (times != null) {
                                timeEnd = DateManager.getTimeMillis();
                                timeProcess = timeEnd - timeStart;
                                if (update) {
                                    times.update = timeProcess;
                                } else {
                                    times.insert = timeProcess;
                                }
                                if (buildDetailsSA) {
                                    times.saDetails.add("iteration:" + iteration);
                                    times.saDetails.add("conflicts:" + conflict);
                                    times.saDetails.add("updated:" + updateEffettuato);
                                }
                            }
                        }
                    }
                    if (o instanceof MsgDiagnostico) {
                        try {
                            if (times != null) {
                                timeStart = DateManager.getTimeMillis();
                            }
                            this.msgDiagnosticiOpenSPCoopAppender.log(con, (MsgDiagnostico)o);
                            if (con == null) ** GOTO lbl263
                            con.commit();
                        }
                        finally {
                            if (times != null) {
                                timeEnd = DateManager.getTimeMillis();
                                times.insert = timeProcess = timeEnd - timeStart;
                            }
                        }
                    } else if (o instanceof Messaggio) {
                        try {
                            if (times != null) {
                                timeStart = DateManager.getTimeMillis();
                            }
                            this.dumpOpenSPCoopAppender.dump(con, (Messaggio)o, this.transazioniRegistrazioneDumpHeadersCompactEnabled);
                            if (con != null) {
                                con.commit();
                            }
                        }
                        finally {
                            if (times != null) {
                                timeEnd = DateManager.getTimeMillis();
                                times.insert = timeProcess = timeEnd - timeStart;
                            }
                        }
                    }
                }
                if (!isMessaggioConsegnato && !consegnaInErrore) break block204;
                timeStart = -1L;
                try {
                    timeDetails = null;
                    if (times != null) {
                        timeStart = DateManager.getTimeMillis();
                        if (buildDetailsUpdateTransaction) {
                            timeDetails = times.transazioneDetails = new ArrayList<String>();
                        }
                    }
                    if (transazioneAggiornata = this.safeAggiornaInformazioneConsegnaTerminata(transazioneApplicativoServer, con, esitiProperties, possibileTerminazioneSingleIntegrationManagerMessage, consegnaInErrore, timeDetails)) break block204;
                    prefix = "[id:" + transazioneApplicativoServer.getIdTransazione() + "][sa:" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "][" + transazioneApplicativoServer.getConnettoreNome() + "] 'gestisciErroreAggiornamentoInformazioneConsegnaTerminata'";
                    existsTransaction = false;
                    try {
                        existsTransaction = TransactionServerUtils.existsTransaction((String)transazioneApplicativoServer.getIdTransazione(), (Connection)con, (String)this.tipoDatabase, (Logger)this.log, (boolean)true);
                    }
                    catch (Throwable t) {
                        msgError = prefix + " compresione esistenza transazione fallita";
                        this.log.error(msgError, t);
                    }
                    serializeTransactionInfo = false;
                    try {
                        serializeTransactionInfo = true;
                        try {
                            if (transazioneApplicativoServer.getIdTransazione() != null && transazioneApplicativoServer.getServizioApplicativoErogatore() != null) {
                                transazioneApplicativoServer.setProtocollo(protocol);
                                exceptionSerializerFileSystem.registrazioneFileSystemTransazioneApplicativoServerConsegnaTerminata(transazioneApplicativoServer, transazioneApplicativoServer.getIdTransazione(), transazioneApplicativoServer.getServizioApplicativoErogatore());
                            }
                        }
                        catch (Throwable msgError) {}
                    }
                    catch (Throwable t) {
                        msgError = prefix + " compresione esistenza transazione fallita";
                        this.log.error(msgError, t);
                    }
                    msgError = prefix + " effettuata gestione dell'errore (existsTransaction=" + existsTransaction + " serializeTransactionInfo=" + serializeTransactionInfo + ")";
                    this.log.error(msgError);
                }
                finally {
                    if (times != null) {
                        timeEnd = DateManager.getTimeMillis();
                        times.updateTransazione = timeProcess = timeEnd - timeStart;
                    }
                }
            }
            try {
                if (con != null) {
                    con.setAutoCommit(true);
                }
            }
            catch (Exception timeStart) {
                // empty catch block
            }
            try {
                if (!useConnectionRuntime) {
                    if (dbManagerTransazioni != null) {
                        dbManagerTransazioni.releaseResource(idDominio, "GestoreConsegnaMultipla", dbResource);
                    } else if (dbConsegnePreseInCaricoManager != null) {
                        dbConsegnePreseInCaricoManager.releaseResource(idDominio, "GestoreConsegnaMultipla", dbResource);
                    } else if (dbConsegneMessageBoxManager != null) {
                        dbConsegneMessageBoxManager.releaseResource(idDominio, "GestoreConsegnaMultipla", dbResource);
                    }
                }
                break block206;
            }
            catch (Exception timeStart) {}
            break block206;
            catch (Throwable e) {
                block207: {
                    try {
                        try {
                            if (con != null) {
                                con.rollback();
                            }
                        }
                        catch (Exception var30_120) {
                            // empty catch block
                        }
                        if (o instanceof TransazioneApplicativoServer) {
                            isMessaggioConsegnato = false;
                            serverInfo = (TransazioneApplicativoServer)o;
                            try {
                                if (serverInfo.getIdTransazione() != null && serverInfo.getServizioApplicativoErogatore() != null) {
                                    serverInfo.setProtocollo(protocol);
                                    exceptionSerializerFileSystem.registrazioneFileSystemTransazioneApplicativoServerEmessoPdD(serverInfo, serverInfo.getIdTransazione(), serverInfo.getServizioApplicativoErogatore());
                                }
                            }
                            catch (Throwable timeEnd) {
                                // empty catch block
                            }
                            msg = "Errore durante la scrittura dell'informazione del server '" + serverInfo.getServizioApplicativoErogatore() + "' associato alla transazione sul database: " + e.getLocalizedMessage();
                            this.log.error("[" + serverInfo.getIdTransazione() + "] " + msg, e);
                        } else if (o instanceof MsgDiagnostico) {
                            msgDiag = (MsgDiagnostico)o;
                            try {
                                if (msgDiag.getIdTransazione() != null && msgDiag.getApplicativo() != null) {
                                    exceptionSerializerFileSystem.registrazioneFileSystemDiagnosticoEmessoPdD(msgDiag, msgDiag.getIdTransazione(), msgDiag.getApplicativo());
                                }
                            }
                            catch (Throwable msg) {
                                // empty catch block
                            }
                            msg = "Errore durante la scrittura del diagnostico relativo al server '" + msgDiag.getApplicativo() + "' associato alla transazione sul database: " + e.getLocalizedMessage();
                            this.log.error("[" + msgDiag.getIdTransazione() + "] " + msg, e);
                        } else if (o instanceof Messaggio) {
                            messaggio = (Messaggio)o;
                            try {
                                if (messaggio.getIdTransazione() != null && messaggio.getServizioApplicativoErogatore() != null) {
                                    exceptionSerializerFileSystem.registrazioneFileSystemDumpEmessoPdD(messaggio, messaggio.getIdTransazione(), messaggio.getServizioApplicativoErogatore(), messaggio.getDataConsegna());
                                }
                            }
                            catch (Throwable msg) {
                                // empty catch block
                            }
                            msg = "Errore durante la scrittura del messaggio relativo al server '" + messaggio.getServizioApplicativoErogatore() + "' associato alla transazione sul database: " + e.getLocalizedMessage();
                            this.log.error("[" + messaggio.getIdTransazione() + "] " + msg, e);
                        }
                        if (!isMessaggioConsegnato && !consegnaInErrore) break block207;
                        timeStart = -1L;
                    }
                    catch (Throwable var81_127) {
                        block209: {
                            if (isMessaggioConsegnato || consegnaInErrore) {
                                timeStart = -1L;
                                try {
                                    timeDetails = null;
                                    if (times != null) {
                                        timeStart = DateManager.getTimeMillis();
                                        if (buildDetailsUpdateTransaction) {
                                            timeDetails = times.transazioneDetails = new ArrayList<String>();
                                        }
                                    }
                                    if (transazioneAggiornata = this.safeAggiornaInformazioneConsegnaTerminata(transazioneApplicativoServer, con, esitiProperties, possibileTerminazioneSingleIntegrationManagerMessage, consegnaInErrore, timeDetails)) break block209;
                                    prefix = "[id:" + transazioneApplicativoServer.getIdTransazione() + "][sa:" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "][" + transazioneApplicativoServer.getConnettoreNome() + "] 'gestisciErroreAggiornamentoInformazioneConsegnaTerminata'";
                                    existsTransaction = false;
                                    try {
                                        existsTransaction = TransactionServerUtils.existsTransaction((String)transazioneApplicativoServer.getIdTransazione(), (Connection)con, (String)this.tipoDatabase, (Logger)this.log, (boolean)true);
                                    }
                                    catch (Throwable t) {
                                        msgError = prefix + " compresione esistenza transazione fallita";
                                        this.log.error(msgError, t);
                                    }
                                    serializeTransactionInfo = false;
                                    try {
                                        serializeTransactionInfo = true;
                                        try {
                                            if (transazioneApplicativoServer.getIdTransazione() != null && transazioneApplicativoServer.getServizioApplicativoErogatore() != null) {
                                                transazioneApplicativoServer.setProtocollo(protocol);
                                                exceptionSerializerFileSystem.registrazioneFileSystemTransazioneApplicativoServerConsegnaTerminata(transazioneApplicativoServer, transazioneApplicativoServer.getIdTransazione(), transazioneApplicativoServer.getServizioApplicativoErogatore());
                                            }
                                        }
                                        catch (Throwable msgError) {}
                                    }
                                    catch (Throwable t) {
                                        msgError = prefix + " compresione esistenza transazione fallita";
                                        this.log.error(msgError, t);
                                    }
                                    msgError = prefix + " effettuata gestione dell'errore (existsTransaction=" + existsTransaction + " serializeTransactionInfo=" + serializeTransactionInfo + ")";
                                    this.log.error(msgError);
                                }
                                finally {
                                    if (times != null) {
                                        timeEnd = DateManager.getTimeMillis();
                                        times.updateTransazione = timeProcess = timeEnd - timeStart;
                                    }
                                }
                            }
                        }
                        try {
                            if (con != null) {
                                con.setAutoCommit(true);
                            }
                        }
                        catch (Exception var82_129) {
                            // empty catch block
                        }
                        try {
                            if (!useConnectionRuntime) {
                                if (dbManagerTransazioni != null) {
                                    dbManagerTransazioni.releaseResource(idDominio, "GestoreConsegnaMultipla", dbResource);
                                } else if (dbConsegnePreseInCaricoManager != null) {
                                    dbConsegnePreseInCaricoManager.releaseResource(idDominio, "GestoreConsegnaMultipla", dbResource);
                                } else if (dbConsegneMessageBoxManager != null) {
                                    dbConsegneMessageBoxManager.releaseResource(idDominio, "GestoreConsegnaMultipla", dbResource);
                                }
                            }
                        }
                        catch (Exception var82_130) {
                            // empty catch block
                        }
                        throw var81_127;
                    }
                    try {
                        timeDetails = null;
                        if (times != null) {
                            timeStart = DateManager.getTimeMillis();
                            if (buildDetailsUpdateTransaction) {
                                timeDetails = times.transazioneDetails = new ArrayList<String>();
                            }
                        }
                        if (transazioneAggiornata = this.safeAggiornaInformazioneConsegnaTerminata(transazioneApplicativoServer, con, esitiProperties, possibileTerminazioneSingleIntegrationManagerMessage, consegnaInErrore, timeDetails)) break block207;
                        prefix = "[id:" + transazioneApplicativoServer.getIdTransazione() + "][sa:" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "][" + transazioneApplicativoServer.getConnettoreNome() + "] 'gestisciErroreAggiornamentoInformazioneConsegnaTerminata'";
                        existsTransaction = false;
                        try {
                            existsTransaction = TransactionServerUtils.existsTransaction((String)transazioneApplicativoServer.getIdTransazione(), (Connection)con, (String)this.tipoDatabase, (Logger)this.log, (boolean)true);
                        }
                        catch (Throwable t) {
                            msgError = prefix + " compresione esistenza transazione fallita";
                            this.log.error(msgError, t);
                        }
                        serializeTransactionInfo = false;
                        try {
                            serializeTransactionInfo = true;
                            try {
                                if (transazioneApplicativoServer.getIdTransazione() != null && transazioneApplicativoServer.getServizioApplicativoErogatore() != null) {
                                    transazioneApplicativoServer.setProtocollo(protocol);
                                    exceptionSerializerFileSystem.registrazioneFileSystemTransazioneApplicativoServerConsegnaTerminata(transazioneApplicativoServer, transazioneApplicativoServer.getIdTransazione(), transazioneApplicativoServer.getServizioApplicativoErogatore());
                                }
                            }
                            catch (Throwable msgError) {}
                        }
                        catch (Throwable t) {
                            msgError = prefix + " compresione esistenza transazione fallita";
                            this.log.error(msgError, t);
                        }
                        msgError = prefix + " effettuata gestione dell'errore (existsTransaction=" + existsTransaction + " serializeTransactionInfo=" + serializeTransactionInfo + ")";
                        this.log.error(msgError);
                    }
                    finally {
                        if (times != null) {
                            timeEnd = DateManager.getTimeMillis();
                            times.updateTransazione = timeProcess = timeEnd - timeStart;
                        }
                    }
                }
                try {
                    if (con != null) {
                        con.setAutoCommit(true);
                    }
                }
                catch (Exception var29_38) {
                    // empty catch block
                }
                try {
                    if (!useConnectionRuntime) {
                        if (dbManagerTransazioni != null) {
                            dbManagerTransazioni.releaseResource(idDominio, "GestoreConsegnaMultipla", dbResource);
                        } else if (dbConsegnePreseInCaricoManager != null) {
                            dbConsegnePreseInCaricoManager.releaseResource(idDominio, "GestoreConsegnaMultipla", dbResource);
                        } else if (dbConsegneMessageBoxManager != null) {
                            dbConsegneMessageBoxManager.releaseResource(idDominio, "GestoreConsegnaMultipla", dbResource);
                        }
                    }
                }
                catch (Exception var29_39) {}
            }
        }
    }

    private void setDettaglioEsito(TransazioneApplicativoServer transazioneApplicativoServer, EsitiProperties esitiProperties, Context context) throws ProtocolException {
        if (transazioneApplicativoServer.getDataMessaggioScaduto() != null) {
            return;
        }
        if (transazioneApplicativoServer.getDataPrelievoIm() != null) {
            return;
        }
        if (transazioneApplicativoServer.getDataEliminazioneIm() != null) {
            transazioneApplicativoServer.setDettaglioEsito(esitiProperties.convertoToCode(EsitoTransazioneName.OK).intValue());
        } else if (transazioneApplicativoServer.getDataUscitaRichiesta() != null) {
            if (transazioneApplicativoServer.getFault() != null) {
                transazioneApplicativoServer.setDettaglioEsito(esitiProperties.convertoToCode(EsitoTransazioneName.ERRORE_APPLICATIVO).intValue());
            } else if (transazioneApplicativoServer.getCodiceRisposta() != null) {
                int code = -1;
                try {
                    code = Integer.valueOf(transazioneApplicativoServer.getCodiceRisposta());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (code > 0) {
                    if (code <= 299) {
                        transazioneApplicativoServer.setDettaglioEsito(esitiProperties.convertoToCode(EsitoTransazioneName.OK).intValue());
                    } else if (transazioneApplicativoServer.isConsegnaTerminata()) {
                        if (code > 299 && code <= 399) {
                            transazioneApplicativoServer.setDettaglioEsito(esitiProperties.convertoToCode(EsitoTransazioneName.HTTP_3xx).intValue());
                        } else if (code > 399 && code <= 499) {
                            transazioneApplicativoServer.setDettaglioEsito(esitiProperties.convertoToCode(EsitoTransazioneName.HTTP_4xx).intValue());
                        } else {
                            transazioneApplicativoServer.setDettaglioEsito(esitiProperties.convertoToCode(EsitoTransazioneName.HTTP_5xx).intValue());
                        }
                    } else {
                        this.setErroreInvocazione(transazioneApplicativoServer, esitiProperties, context, code);
                    }
                } else if (transazioneApplicativoServer.isConsegnaTerminata()) {
                    transazioneApplicativoServer.setDettaglioEsito(esitiProperties.convertoToCode(EsitoTransazioneName.OK).intValue());
                } else {
                    this.setErroreInvocazione(transazioneApplicativoServer, esitiProperties, context, -1);
                }
            } else if (transazioneApplicativoServer.isConsegnaTerminata()) {
                transazioneApplicativoServer.setDettaglioEsito(esitiProperties.convertoToCode(EsitoTransazioneName.OK).intValue());
            } else {
                this.setErroreInvocazione(transazioneApplicativoServer, esitiProperties, context, -1);
            }
        }
        if (transazioneApplicativoServer.getDettaglioEsito() > 0) {
            // empty if block
        }
    }

    private void setErroreInvocazione(TransazioneApplicativoServer transazioneApplicativoServer, EsitiProperties esitiProperties, Context context, int code) throws ProtocolException {
        EsitoTransazioneName name = EsitoTransazioneName.ERRORE_INVOCAZIONE;
        if (context != null && context.containsKey(Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE)) {
            String timeoutExceededMessage = null;
            if (context.containsKey(Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE)) {
                timeoutExceededMessage = (String)context.get(Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE);
                if ("controlloTrafficoConnectionTimeout".equals(timeoutExceededMessage)) {
                    name = EsitoTransazioneName.ERRORE_CONNECTION_TIMEOUT;
                } else if ("controlloTrafficoRequestReadTimeout".equals(timeoutExceededMessage)) {
                    name = EsitoTransazioneName.ERRORE_REQUEST_TIMEOUT;
                } else if ("controlloTrafficoResponseReadTimeout".equals(timeoutExceededMessage) || "controlloTrafficoReadTimeout".equals(timeoutExceededMessage)) {
                    name = EsitoTransazioneName.ERRORE_RESPONSE_TIMEOUT;
                }
            }
        } else if (code > 299 && code <= 399) {
            name = EsitoTransazioneName.HTTP_3xx;
        } else if (code > 399 && code <= 499) {
            name = EsitoTransazioneName.HTTP_4xx;
        } else if (code > 499 && code <= 599) {
            name = EsitoTransazioneName.HTTP_5xx;
        }
        transazioneApplicativoServer.setDettaglioEsito(esitiProperties.convertoToCode(name).intValue());
    }

    public static boolean isDebug() {
        return debugStaticValue;
    }

    public static void setDebug(boolean debug) {
        debugStaticValue = debug;
    }

    private boolean safeAggiornaInformazioneConsegnaTerminata(TransazioneApplicativoServer transazioneApplicativoServer, Connection con, EsitiProperties esitiProperties, boolean possibileTerminazioneSingleIntegrationManagerMessage, boolean consegnaInErrore, List<String> timeDetails) {
        boolean debugMode = debugStaticValue;
        DAOFactory daoF = debugMode ? daoFactory : daoFactoryDevNull;
        Logger logFactory = debugMode ? daoFactoryLoggerTransazioniSql : daoFactoryLoggerTransazioniDevNull;
        ServiceManagerProperties smp = debugMode ? daoFactoryServiceManagerPropertiesTransazioni : daoFactoryDevNullServiceManagerPropertiesTransazioni;
        int esitoConsegnaMultipla = -1;
        int esitoConsegnaMultiplaInCorso = -1;
        int esitoConsegnaMultiplaFallita = -1;
        int esitoConsegnaMultiplaCompletata = -1;
        int ok = -1;
        int esitoIntegrationManagerSingolo = -1;
        boolean esitiLetti = false;
        try {
            esitoConsegnaMultipla = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA);
            esitoConsegnaMultiplaInCorso = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_IN_CORSO);
            esitoConsegnaMultiplaFallita = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_FALLITA);
            esitoConsegnaMultiplaCompletata = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_COMPLETATA);
            ok = esitiProperties.convertoToCode(EsitoTransazioneName.OK);
            esitoIntegrationManagerSingolo = esitiProperties.convertoToCode(EsitoTransazioneName.MESSAGE_BOX);
            esitiLetti = true;
        }
        catch (Exception er) {
            String msg = "Errore durante l'aggiornamento delle transazione relativamente all'informazione del server '" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "': (readEsiti) " + er.getMessage();
            this.log.error("[id:" + transazioneApplicativoServer.getIdTransazione() + "][sa:" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "][" + transazioneApplicativoServer.getConnettoreNome() + "] " + msg, (Throwable)er);
        }
        if (esitiLetti) {
            return TransactionServerUtils.safeAggiornaInformazioneConsegnaTerminata((TransazioneApplicativoServer)transazioneApplicativoServer, (Connection)con, (String)this.tipoDatabase, (Logger)this.log, (IDAOFactory)daoF, (Logger)logFactory, (ServiceManagerProperties)smp, (boolean)this.debug, (int)esitoConsegnaMultipla, (int)esitoConsegnaMultiplaInCorso, (int)esitoConsegnaMultiplaFallita, (int)esitoConsegnaMultiplaCompletata, (int)ok, (int)esitoIntegrationManagerSingolo, (boolean)possibileTerminazioneSingleIntegrationManagerMessage, (boolean)consegnaInErrore, (long)openspcoopProperties.getGestioneSerializableDBAttesaAttiva(), (int)openspcoopProperties.getGestioneSerializableDBCheckInterval(), timeDetails);
        }
        return false;
    }
}

