/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.transazioni;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionInfo;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;

public class TransactionContext {
    private static final String INDICAZIONE_GESTIONE_STATEFUL_ERRATA = "Indicazione sulla gestione stateful errata: ";
    private static Boolean gestioneStateful = null;
    private static boolean useThreadLocal = true;
    private static Map<String, TransactionInfo> setTransactionInfoThreadLocal = new ConcurrentHashMap<String, TransactionInfo>();
    private static final ThreadLocal<TransactionInfo> transactionContext_threadLocal = new ThreadLocal<TransactionInfo>(){

        @Override
        protected TransactionInfo initialValue() {
            String tName = Thread.currentThread().getName();
            TransactionInfo info = new TransactionInfo(tName);
            setTransactionInfoThreadLocal.put(tName, info);
            return info;
        }
    };
    private static Map<String, Transaction> transactionContextShared = null;
    private static Set<String> idBustaFiltroDuplicati = ConcurrentHashMap.newKeySet();
    private static Semaphore semaphoreIdentificativoProtocollo = new Semaphore("TransactionContext.idProtocollo");

    public static synchronized void initGestioneStateful() throws Exception {
        if (gestioneStateful == null) {
            gestioneStateful = OpenSPCoop2Properties.getInstance().isTransazioniStatefulEnabled();
        }
    }

    public static void removeTransactionContext_threadLocal() {
        if (transactionContext_threadLocal != null) {
            transactionContext_threadLocal.remove();
        }
    }

    public static synchronized void initResources() throws Exception {
        if (!useThreadLocal) {
            transactionContextShared = OpenSPCoop2Properties.getInstance().isConfigurazioneCache_transactionContext_accessiSynchronized() ? new Hashtable<String, Transaction>() : new ConcurrentHashMap<String, Transaction>();
        }
    }

    public static String getTransactionContextType() {
        if (useThreadLocal) {
            return "ThreadLocal";
        }
        return transactionContextShared.getClass().getName();
    }

    public static List<String> getTransactionKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        if (useThreadLocal) {
            ArrayList<String> thNames = new ArrayList<String>();
            thNames.addAll(setTransactionInfoThreadLocal.keySet());
            for (String tName : thNames) {
                TransactionInfo tInfo = setTransactionInfoThreadLocal.get(tName);
                if (tInfo == null || tInfo.transaction == null) continue;
                String id = null;
                try {
                    id = tInfo.transaction.getId();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (id == null) continue;
                keys.add(id);
            }
        } else {
            keys.addAll(transactionContextShared.keySet());
        }
        return keys;
    }

    public static void createTransaction(String id, String originator) throws TransactionNotExistsException {
        if (useThreadLocal) {
            if (TransactionContext.transactionContext_threadLocal.get().transaction == null || !id.equals(TransactionContext.transactionContext_threadLocal.get().transaction.getId())) {
                try {
                    if (gestioneStateful == null) {
                        TransactionContext.initGestioneStateful();
                    }
                }
                catch (Exception e) {
                    throw new TransactionNotExistsException(INDICAZIONE_GESTIONE_STATEFUL_ERRATA + e.getMessage(), e);
                }
                TransactionContext.transactionContext_threadLocal.get().transaction = new Transaction(id, originator, gestioneStateful);
            }
        } else if (!transactionContextShared.containsKey(id)) {
            try {
                if (gestioneStateful == null) {
                    TransactionContext.initGestioneStateful();
                }
            }
            catch (Exception e) {
                throw new TransactionNotExistsException(INDICAZIONE_GESTIONE_STATEFUL_ERRATA + e.getMessage(), e);
            }
            Transaction transaction = new Transaction(id, originator, gestioneStateful);
            transactionContextShared.put(id, transaction);
        }
    }

    public static void setTransactionThreadLocal(String id, Transaction transaction) throws TransactionNotExistsException {
        if (useThreadLocal && (TransactionContext.transactionContext_threadLocal.get().transaction == null || !id.equals(TransactionContext.transactionContext_threadLocal.get().transaction.getId()))) {
            try {
                if (gestioneStateful == null) {
                    TransactionContext.initGestioneStateful();
                }
            }
            catch (Exception e) {
                throw new TransactionNotExistsException(INDICAZIONE_GESTIONE_STATEFUL_ERRATA + e.getMessage(), e);
            }
            TransactionContext.transactionContext_threadLocal.get().transaction = transaction;
        }
    }

    public static Transaction getTransaction(String id) throws TransactionNotExistsException {
        return TransactionContext.getTransaction(id, null, false);
    }

    private static Transaction getTransaction(String id, String originator, boolean createIfNotExists) throws TransactionNotExistsException {
        if (useThreadLocal) {
            if (TransactionContext.transactionContext_threadLocal.get().transaction == null || !id.equals(TransactionContext.transactionContext_threadLocal.get().transaction.getId())) {
                if (createIfNotExists) {
                    TransactionContext.createTransaction(id, originator);
                } else {
                    throw new TransactionNotExistsException("Transaction con id [" + id + "] non esiste");
                }
            }
            return TransactionContext.transactionContext_threadLocal.get().transaction;
        }
        Transaction transaction = transactionContextShared.get(id);
        if (transaction == null) {
            if (createIfNotExists) {
                TransactionContext.createTransaction(id, originator);
            } else {
                throw new TransactionNotExistsException("Transaction con id [" + id + "] non esiste");
            }
        }
        return transaction;
    }

    public static Transaction removeTransaction(String id) {
        if (useThreadLocal) {
            Transaction t = TransactionContext.transactionContext_threadLocal.get().transaction;
            TransactionContext.transactionContext_threadLocal.get().transaction = null;
            return t;
        }
        return transactionContextShared.remove(id);
    }

    public static List<String> getIdBustaKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(idBustaFiltroDuplicati);
        return keys;
    }

    public static void registraIdentificativoProtocollo(String idBusta, String idTransazione) throws Exception {
        SemaphoreLock lock = semaphoreIdentificativoProtocollo.acquire("registraIdentificativoProtocollo_" + idBusta, idTransazione);
        try {
            if (idBustaFiltroDuplicati.contains(idBusta)) {
                throw new Exception("DUPLICATA");
            }
            idBustaFiltroDuplicati.add(idBusta);
        }
        finally {
            semaphoreIdentificativoProtocollo.release(lock, "registraIdentificativoProtocollo_" + idBusta, idTransazione);
        }
    }

    public static boolean containsIdentificativoProtocollo(String idBusta) {
        return idBustaFiltroDuplicati.contains(idBusta);
    }

    public static void removeIdentificativoProtocollo(String idBusta) {
        idBustaFiltroDuplicati.remove(idBusta);
    }
}

