/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.trasformazioni;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.generic_project.beans.IEnumeration;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.message.constants.ServiceBinding;

public enum TipoTrasformazione implements IEnumeration,
Serializable,
Cloneable
{
    EMPTY("empty-payload", "HTTP Payload vuoto", null),
    TEMPLATE("template", "Template", null),
    FREEMARKER_TEMPLATE("freemarker", "Freemarker Template", null),
    FREEMARKER_TEMPLATE_ZIP("freemarker-zip", "Freemarker Template (Archivio Zip)", null),
    VELOCITY_TEMPLATE("velocity", "Velocity Template", null),
    VELOCITY_TEMPLATE_ZIP("velocity-zip", "Velocity Template (Archivio Zip)", null),
    XSLT("xslt", "XSLT", null),
    ZIP("zip", "ZIP Compressor", null),
    TGZ("tgz", "TGZ Compressor", null),
    TAR("tar", "TAR Compressor", null),
    CONTEXT_FREEMARKER_TEMPLATE("freemarker-context", "Alimentazione Contesto (Freemarker Template)", null),
    CONTEXT_VELOCITY_TEMPLATE("velocity-context", "Alimentazione Contesto (Velocity Template)", null);

    private String value;
    private String label;
    private ServiceBinding serviceBinding;

    public String getValue() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabel(ServiceBinding serviceBinding) {
        if (this.equals(EMPTY) && ServiceBinding.SOAP.equals((Object)serviceBinding)) {
            return "SOAP Body vuoto";
        }
        return this.label;
    }

    private TipoTrasformazione(String value, String label, ServiceBinding serviceBinding) {
        this.value = value;
        this.label = label;
        this.serviceBinding = serviceBinding;
    }

    public String getExt() {
        switch (this) {
            case EMPTY: {
                return null;
            }
            case TEMPLATE: {
                return ".gwt";
            }
            case FREEMARKER_TEMPLATE: {
                return ".ftl";
            }
            case FREEMARKER_TEMPLATE_ZIP: {
                return ".ftl.zip";
            }
            case VELOCITY_TEMPLATE: {
                return ".vm";
            }
            case VELOCITY_TEMPLATE_ZIP: {
                return ".vm.zip";
            }
            case XSLT: {
                return ".xslt";
            }
            case ZIP: {
                return ".zip.gw";
            }
            case TGZ: {
                return ".tgz.gw";
            }
            case TAR: {
                return ".tar.gw";
            }
            case CONTEXT_FREEMARKER_TEMPLATE: {
                return ".ctx.ftl";
            }
            case CONTEXT_VELOCITY_TEMPLATE: {
                return ".ctx.vm";
            }
        }
        return null;
    }

    public boolean isTemplateRequired() {
        return TEMPLATE.equals(this) || FREEMARKER_TEMPLATE.equals(this) || FREEMARKER_TEMPLATE_ZIP.equals(this) || VELOCITY_TEMPLATE.equals(this) || VELOCITY_TEMPLATE_ZIP.equals(this) || XSLT.equals(this) || ZIP.equals(this) || TGZ.equals(this) || TAR.equals(this) || CONTEXT_FREEMARKER_TEMPLATE.equals(this) || CONTEXT_VELOCITY_TEMPLATE.equals(this);
    }

    public boolean isTemplateFreemarker() {
        return FREEMARKER_TEMPLATE.equals(this) || FREEMARKER_TEMPLATE_ZIP.equals(this) || CONTEXT_FREEMARKER_TEMPLATE.equals(this);
    }

    public boolean isTemplateVelocity() {
        return VELOCITY_TEMPLATE.equals(this) || VELOCITY_TEMPLATE_ZIP.equals(this) || CONTEXT_VELOCITY_TEMPLATE.equals(this);
    }

    public boolean isContextInjection() {
        return CONTEXT_FREEMARKER_TEMPLATE.equals(this) || CONTEXT_VELOCITY_TEMPLATE.equals(this);
    }

    public boolean isContentTypeEnabled() {
        return !EMPTY.equals(this);
    }

    public boolean isTrasformazioneProtocolloEnabled() {
        return !CONTEXT_FREEMARKER_TEMPLATE.equals(this) && !CONTEXT_VELOCITY_TEMPLATE.equals(this);
    }

    public boolean isBinaryMessage() {
        return ZIP.equals(this) || TGZ.equals(this) || TAR.equals(this);
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(String object) {
        if (object == null) {
            return false;
        }
        return object.equals(this.getValue());
    }

    public boolean equals(Object object, List<String> fieldsNotCheck) {
        if (!(object instanceof TipoTrasformazione)) {
            throw new RuntimeException("Wrong type: " + object.getClass().getName());
        }
        return this.equals((TipoTrasformazione)object);
    }

    public String toString(boolean reportHTML) {
        return this.toString();
    }

    public String toString(boolean reportHTML, List<String> fieldsNotIncluded) {
        return this.toString();
    }

    public String diff(Object object, StringBuilder bf, boolean reportHTML) {
        return bf.toString();
    }

    public String diff(Object object, StringBuilder bf, boolean reportHTML, List<String> fieldsNotIncluded) {
        return bf.toString();
    }

    public static String[] toArray() {
        return TipoTrasformazione.toArray(null);
    }

    public static String[] toArray(ServiceBinding serviceBinding) {
        List<String> l = TipoTrasformazione.toList(serviceBinding);
        if (l != null && l.size() > 0) {
            return l.toArray(new String[1]);
        }
        return null;
    }

    public static List<String> toList() {
        return TipoTrasformazione.toList(null);
    }

    public static List<String> toList(ServiceBinding serviceBinding) {
        ArrayList<String> res = new ArrayList<String>();
        for (TipoTrasformazione tmp : TipoTrasformazione.values()) {
            if (serviceBinding != null && tmp.serviceBinding != null && !serviceBinding.equals((Object)tmp.serviceBinding)) continue;
            res.add(tmp.getValue());
        }
        return res;
    }

    public static String[] toLabelArray(boolean excludeBinaries) {
        return TipoTrasformazione.toLabelArray(null, excludeBinaries);
    }

    public static String[] toLabelArray(ServiceBinding serviceBinding, boolean excludeBinaries) {
        List<String> l = TipoTrasformazione.toLabelList(serviceBinding, excludeBinaries);
        if (l != null && l.size() > 0) {
            return l.toArray(new String[1]);
        }
        return null;
    }

    public static List<String> toLabelList(boolean excludeBinaries) {
        return TipoTrasformazione.toLabelList(null, excludeBinaries);
    }

    public static List<String> toLabelList(ServiceBinding serviceBinding, boolean excludeBinaries) {
        ArrayList<String> res = new ArrayList<String>();
        for (TipoTrasformazione tmp : TipoTrasformazione.values()) {
            if (serviceBinding != null && tmp.serviceBinding != null && !serviceBinding.equals((Object)tmp.serviceBinding) || excludeBinaries && tmp.isBinaryMessage()) continue;
            res.add(tmp.getLabel(serviceBinding));
        }
        return res;
    }

    public static String[] toStringArray(boolean excludeBinaries) {
        return TipoTrasformazione.toStringArray(null, excludeBinaries);
    }

    public static String[] toStringArray(ServiceBinding serviceBinding, boolean excludeBinaries) {
        List<String> l = TipoTrasformazione.toStringList(serviceBinding, excludeBinaries);
        if (l != null && l.size() > 0) {
            return l.toArray(new String[1]);
        }
        return null;
    }

    public static List<String> toStringList(boolean excludeBinaries) {
        return TipoTrasformazione.toStringList(null, excludeBinaries);
    }

    public static List<String> toStringList(ServiceBinding serviceBinding, boolean excludeBinaries) {
        ArrayList<String> res = new ArrayList<String>();
        for (TipoTrasformazione tmp : TipoTrasformazione.values()) {
            if (serviceBinding != null && tmp.serviceBinding != null && !serviceBinding.equals((Object)tmp.serviceBinding) || excludeBinaries && tmp.isBinaryMessage()) continue;
            res.add(tmp.toString());
        }
        return res;
    }

    public static String[] toEnumNameArray() {
        return TipoTrasformazione.toEnumNameArray(null);
    }

    public static String[] toEnumNameArray(ServiceBinding serviceBinding) {
        List<String> l = TipoTrasformazione.toEnumNameList(serviceBinding);
        if (l != null && l.size() > 0) {
            return l.toArray(new String[1]);
        }
        return null;
    }

    public static List<String> toEnumNameList() {
        return TipoTrasformazione.toEnumNameList(null);
    }

    public static List<String> toEnumNameList(ServiceBinding serviceBinding) {
        ArrayList<String> res = new ArrayList<String>();
        for (TipoTrasformazione tmp : TipoTrasformazione.values()) {
            if (serviceBinding != null && tmp.serviceBinding != null && !serviceBinding.equals((Object)tmp.serviceBinding)) continue;
            res.add(tmp.name());
        }
        return res;
    }

    public static boolean contains(String value) {
        return TipoTrasformazione.toEnumConstant(value) != null;
    }

    public static TipoTrasformazione toEnumConstant(String value) {
        try {
            return TipoTrasformazione.toEnumConstant(value, false);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }

    public static TipoTrasformazione toEnumConstant(String value, boolean throwNotFoundException) throws NotFoundException {
        TipoTrasformazione res = null;
        for (TipoTrasformazione tmp : TipoTrasformazione.values()) {
            if (!tmp.getValue().equals(value)) continue;
            res = tmp;
            break;
        }
        if (res == null && throwNotFoundException) {
            throw new NotFoundException("Enum with value [" + value + "] not found");
        }
        return res;
    }

    public static IEnumeration toEnumConstantFromString(String value) {
        try {
            return TipoTrasformazione.toEnumConstantFromString(value, false);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }

    public static IEnumeration toEnumConstantFromString(String value, boolean throwNotFoundException) throws NotFoundException {
        TipoTrasformazione res = null;
        for (TipoTrasformazione tmp : TipoTrasformazione.values()) {
            if (!tmp.toString().equals(value)) continue;
            res = tmp;
            break;
        }
        if (res == null && throwNotFoundException) {
            throw new NotFoundException("Enum with value [" + value + "] not found");
        }
        return res;
    }
}

