/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class DiagnosticInputStream
extends FilterInputStream {
    private static final String COMPLETATA = "completata";
    private static final String FALLITA = "fallita";
    public static final MapKey<String> DIAGNOSTIC_INPUT_STREAM_REQUEST_COMPLETE_DATE = Map.newMapKey((String)"DiagnosticInputStreamRequestCompleteDate");
    public static final MapKey<String> DIAGNOSTIC_INPUT_STREAM_REQUEST_ERROR_DATE = Map.newMapKey((String)"DiagnosticInputStreamRequestErrorDate");
    public static final MapKey<String> DIAGNOSTIC_INPUT_STREAM_REQUEST_START_DATE = Map.newMapKey((String)"DiagnosticInputStreamRequestStartDate");
    public static final MapKey<String> DIAGNOSTIC_INPUT_STREAM_RESPONSE_COMPLETE_DATE = Map.newMapKey((String)"DiagnosticInputStreamResponseCompleteDate");
    public static final MapKey<String> DIAGNOSTIC_INPUT_STREAM_RESPONSE_ERROR_DATE = Map.newMapKey((String)"DiagnosticInputStreamResponseErrorDate");
    public static final MapKey<String> DIAGNOSTIC_INPUT_STREAM_RESPONSE_START_DATE = Map.newMapKey((String)"DiagnosticInputStreamResponseStartDate");
    private InputStream isWrapped = null;
    private String idModuloFunzionale;
    private String identificativo;
    private boolean request;
    private MsgDiagnostico msgDiagnostico;
    private Logger log;
    private Map<Object> ctx;
    private boolean readSomeBytes = false;
    private static boolean setDateEmptyStream = true;

    public static boolean isSetDateEmptyStream() {
        return setDateEmptyStream;
    }

    public static void setSetDateEmptyStream(boolean setDateEmptyStream) {
        DiagnosticInputStream.setDateEmptyStream = setDateEmptyStream;
    }

    public DiagnosticInputStream(InputStream inputStream, String idModuloFunzionale, String identificativo, boolean request, MsgDiagnostico msgDiagnostico, Logger log, Map<Object> ctx) {
        super(inputStream);
        this.idModuloFunzionale = idModuloFunzionale;
        this.identificativo = identificativo;
        this.request = request;
        this.msgDiagnostico = msgDiagnostico;
        this.log = log;
        this.ctx = ctx;
        this.isWrapped = inputStream;
        this.registerStartDate();
    }

    public InputStream getIsWrapped() {
        return this.isWrapped;
    }

    @Override
    public int read() throws IOException {
        try {
            int res = super.read();
            if (res == -1) {
                this.registerDate(null);
                this.emitLog(null);
                this.emitDiagnostic(null);
            } else if (!this.readSomeBytes) {
                this.readSomeBytes = true;
            }
            return res;
        }
        catch (IOException io) {
            this.registerDate(io);
            this.emitLog(io);
            this.emitDiagnostic(io);
            throw io;
        }
        catch (Throwable t) {
            this.registerDate(t);
            this.emitLog(t);
            this.emitDiagnostic(t);
            throw t;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int res = super.read(b, off, len);
            if (res == -1) {
                this.registerDate(null);
                this.emitLog(null);
                this.emitDiagnostic(null);
            } else if (!this.readSomeBytes) {
                this.readSomeBytes = true;
            }
            return res;
        }
        catch (IOException io) {
            this.registerDate(io);
            this.emitLog(io);
            this.emitDiagnostic(io);
            throw io;
        }
        catch (Throwable t) {
            this.registerDate(t);
            this.emitLog(t);
            this.emitDiagnostic(t);
            throw t;
        }
    }

    private void registerStartDate() {
        if (this.ctx != null && this.isWrapped != null) {
            Date d = DateManager.getDate();
            this.ctx.put(this.request ? DIAGNOSTIC_INPUT_STREAM_REQUEST_START_DATE : DIAGNOSTIC_INPUT_STREAM_RESPONSE_START_DATE, (Object)d);
        }
    }

    private void registerDate(Throwable t) {
        if (this.ctx != null && (this.readSomeBytes || setDateEmptyStream)) {
            Date d = DateManager.getDate();
            if (t != null) {
                this.ctx.put(this.request ? DIAGNOSTIC_INPUT_STREAM_REQUEST_ERROR_DATE : DIAGNOSTIC_INPUT_STREAM_RESPONSE_ERROR_DATE, (Object)d);
            } else {
                this.ctx.put(this.request ? DIAGNOSTIC_INPUT_STREAM_REQUEST_COMPLETE_DATE : DIAGNOSTIC_INPUT_STREAM_RESPONSE_COMPLETE_DATE, (Object)d);
            }
        }
    }

    private void emitLog(Throwable t) {
        if (this.log != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Lettura payload '").append(this.identificativo).append("' ");
            if (t != null) {
                sb.append("fallita: ").append(t.getMessage());
            } else {
                sb.append("completata con successo");
            }
            String msg = sb.toString();
            if (t != null) {
                this.log.error(msg, t);
            } else {
                this.log.debug(msg);
            }
        }
    }

    private void emitDiagnostic(Throwable t) {
        block5: {
            if (this.msgDiagnostico != null && this.idModuloFunzionale != null && StringUtils.isNotEmpty((String)this.idModuloFunzionale) && this.identificativo != null && StringUtils.isNotEmpty((String)this.identificativo)) {
                try {
                    if (t != null) {
                        String msg = Utilities.readFirstErrorValidMessageFromException((Throwable)t);
                        this.msgDiagnostico.addKeyword("@ERRORE_PROCESSAMENTO@", msg);
                        this.msgDiagnostico.logPersonalizzato(this.idModuloFunzionale, this.identificativo + ".fallita");
                    } else {
                        this.msgDiagnostico.logPersonalizzato(this.idModuloFunzionale, this.identificativo + ".completata");
                    }
                }
                catch (Throwable tLog) {
                    if (this.log == null) break block5;
                    this.log.error("Emissione diagnostico per lettura payload '" + this.identificativo + "' fallita: " + tLog.getMessage(), tLog);
                }
            }
        }
    }
}

