/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.dao.IDBCredenzialeMittenteServiceSearch;
import org.openspcoop2.core.transazioni.dao.ITransazioneServiceSearch;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.transazioni.utils.CredenzialiMittente;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.core.transazioni.utils.PropertiesSerializator;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTokenClient;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.pdd.core.transazioni.DateUtility;
import org.openspcoop2.pdd.logger.DriverTracciamento;
import org.openspcoop2.pdd.logger.record.AbstractDatoRicostruzione;
import org.openspcoop2.pdd.logger.traccia.InformazioniRecordTraccia;
import org.openspcoop2.pdd.logger.traccia.MappingRicostruzioneTraccia;
import org.openspcoop2.pdd.logger.traccia.PopolamentoTracciaUtils;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.builder.IBustaBuilder;
import org.openspcoop2.protocol.sdk.constants.EsitoElaborazioneMessaggioTracciatura;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoException;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import org.openspcoop2.protocol.sdk.tracciamento.EsitoElaborazioneMessaggioTracciato;
import org.openspcoop2.protocol.sdk.tracciamento.FiltroRicercaTracce;
import org.openspcoop2.protocol.sdk.tracciamento.FiltroRicercaTracceConPaginazione;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaDriver;
import org.openspcoop2.protocol.sdk.tracciamento.InformazioniProtocollo;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.slf4j.Logger;

public class TransactionDriverTracciamento
implements ITracciaDriver {
    private static final String TIPO_DB_NON_GESTITO = "Tipo database non gestito";
    private static final String NON_IMPLEMENTATO = "Metodo non implementato";
    DataSource datasource = null;
    Connection connection = null;
    boolean connectionOpenViaJDBCInCostructor = false;
    String tipoDatabase = null;
    DriverTracciamento driverTracciamento = null;
    DAOFactory daoFactory = null;
    private Logger log = null;
    private static final long ID_TRACCIA_RICOSTRUITA = -2L;
    private static final String ID_TRACCIA_RICOSTRUITA_AS_STRING = "-2";

    private void logDebug(String msg) {
        if (this.log != null) {
            this.log.debug(msg);
        }
    }

    public TransactionDriverTracciamento(String nomeDataSource, String tipoDatabase, Properties prop) throws DriverTracciamentoException {
        this(nomeDataSource, tipoDatabase, prop, null);
    }

    public TransactionDriverTracciamento(String nomeDataSource, String tipoDatabase, Properties prop, Logger log) throws DriverTracciamentoException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(ds jndiName) Errore durante l'inizializzazione del logger: " + e.getMessage(), (Throwable)e);
        }
        try {
            InitialContext initCtx = new InitialContext(prop);
            this.datasource = (DataSource)initCtx.lookup(nomeDataSource);
            if (this.datasource == null) {
                throw new DriverTracciamentoException("datasource is null");
            }
            initCtx.close();
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(ds jndiName) Errore durante la ricerca del datasource: " + e.getMessage(), (Throwable)e);
        }
        try {
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverTracciamentoException(TIPO_DB_NON_GESTITO);
            }
            this.tipoDatabase = tipoDatabase;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(ds jndiName) Errore durante la ricerca del SQLQueryObject: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.driverTracciamento = new DriverTracciamento(nomeDataSource, tipoDatabase, prop, log);
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(ds jndiName) Errore durante l'inizializzazione del driver delle tracce: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.daoFactory = DAOFactory.getInstance((Logger)log);
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(ds jndiName) Errore durante l'inizializzazione del dao factory: " + e.getMessage(), (Throwable)e);
        }
    }

    public TransactionDriverTracciamento(DataSource dataSourceObject, String tipoDatabase) throws DriverTracciamentoException {
        this(dataSourceObject, tipoDatabase, null);
    }

    public TransactionDriverTracciamento(DataSource dataSourceObject, String tipoDatabase, Logger log) throws DriverTracciamentoException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(ds) Errore durante l'inizializzazione del logger: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.datasource = dataSourceObject;
            if (this.datasource == null) {
                throw new DriverTracciamentoException("datasource is null");
            }
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(ds) Errore durante la ricerca del datasource: " + e.getMessage(), (Throwable)e);
        }
        try {
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverTracciamentoException(TIPO_DB_NON_GESTITO);
            }
            this.tipoDatabase = tipoDatabase;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(ds) Errore durante la ricerca del SQLQueryObject: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.driverTracciamento = new DriverTracciamento(this.datasource, tipoDatabase, log);
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(ds) Errore durante l'inizializzazione del driver delle tracce: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.daoFactory = DAOFactory.getInstance((Logger)log);
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(ds) Errore durante l'inizializzazione del dao factory: " + e.getMessage(), (Throwable)e);
        }
    }

    public TransactionDriverTracciamento(Connection connection, String tipoDatabase) throws DriverTracciamentoException {
        this(connection, tipoDatabase, null);
    }

    public TransactionDriverTracciamento(Connection connection, String tipoDatabase, Logger log) throws DriverTracciamentoException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(connection) Errore durante l'inizializzazione del logger: " + e.getMessage(), (Throwable)e);
        }
        this.connection = connection;
        try {
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverTracciamentoException(TIPO_DB_NON_GESTITO);
            }
            this.tipoDatabase = tipoDatabase;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(connection) Errore durante la ricerca del SQLQueryObject: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.driverTracciamento = new DriverTracciamento(this.connection, tipoDatabase, log);
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(connection) Errore durante l'inizializzazione del driver delle tracce: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.daoFactory = DAOFactory.getInstance((Logger)log);
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(connection) Errore durante l'inizializzazione del dao factory: " + e.getMessage(), (Throwable)e);
        }
    }

    public TransactionDriverTracciamento(String urlJDBC, String driverJDBC, String username, String password, String tipoDatabase) throws DriverTracciamentoException {
        this(urlJDBC, driverJDBC, username, password, tipoDatabase, null);
    }

    public TransactionDriverTracciamento(String urlJDBC, String driverJDBC, String username, String password, String tipoDatabase, Logger log) throws DriverTracciamentoException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(connection url) Errore durante l'inizializzazione del logger: " + e.getMessage(), (Throwable)e);
        }
        try {
            Class.forName(driverJDBC);
            this.connection = username != null ? DriverManager.getConnection(urlJDBC, username, password) : DriverManager.getConnection(urlJDBC);
            this.connectionOpenViaJDBCInCostructor = true;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(connection url) Errore durante l'inizializzazione della connessione: " + e.getMessage(), (Throwable)e);
        }
        try {
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverTracciamentoException(TIPO_DB_NON_GESTITO);
            }
            this.tipoDatabase = tipoDatabase;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(connection url) Errore durante la ricerca del SQLQueryObject: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.driverTracciamento = new DriverTracciamento(this.connection, tipoDatabase, log);
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(connection url) Errore durante l'inizializzazione del driver delle tracce: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.daoFactory = DAOFactory.getInstance((Logger)log);
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("(connection url) Errore durante l'inizializzazione del dao factory: " + e.getMessage(), (Throwable)e);
        }
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return null;
    }

    private Connection getConnection() throws SQLException {
        Connection con = null;
        con = this.connection != null ? this.connection : this.datasource.getConnection();
        return con;
    }

    private void checkConnection(Connection con) throws DriverTracciamentoException {
        if (con == null) {
            throw new DriverTracciamentoException("Connection non ottenuta");
        }
    }

    private void closeConnection(Connection con) {
        if (this.connection == null) {
            try {
                JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)con, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int countTracce(FiltroRicercaTracce filtro) throws DriverTracciamentoException {
        Connection con = null;
        JDBCServiceManager transazioniServiceManager = null;
        long transazioniTrovate = 0L;
        try {
            con = this.getConnection();
            this.checkConnection(con);
            transazioniServiceManager = (JDBCServiceManager)this.daoFactory.getServiceManager((IProjectInfo)new ProjectInfo(), con, true);
            ITransazioneServiceSearch transazioneServiceSearch = transazioniServiceManager.getTransazioneServiceSearch();
            IExpression expression = this.newExpressionEngine(transazioneServiceSearch, filtro);
            NonNegativeNumber nn = transazioneServiceSearch.count(expression);
            if (nn != null) {
                transazioniTrovate = nn.longValue();
            }
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Riscontrato errore durante la lettura (count) dei dati (Filtro:" + filtro.toString() + "): " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (transazioniServiceManager != null) {
                    transazioniServiceManager.close();
                }
            }
            catch (Exception exception) {}
            this.closeConnection(con);
        }
        int offset = 0;
        int limit = 25;
        int count = 0;
        FiltroRicercaTracceConPaginazione filtroPaginato = new FiltroRicercaTracceConPaginazione(filtro);
        filtroPaginato.setOffset(offset);
        filtroPaginato.setLimit(limit);
        List<Traccia> list = null;
        try {
            list = this.getTracceEngine(filtroPaginato);
            while ((long)offset < transazioniTrovate) {
                count += list.size();
                filtroPaginato.setOffset(offset += limit);
                list = this.getTracceEngine(filtroPaginato);
            }
        }
        catch (DriverTracciamentoNotFoundException driverTracciamentoNotFoundException) {
            // empty catch block
        }
        return count;
    }

    public List<Traccia> getTracce(FiltroRicercaTracceConPaginazione filtro) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        if (filtro.getOffset() > 0) {
            throw new DriverTracciamentoException("Metodo non implementato in questa versione (Offset >0 non \u00e8 ricostruibile)");
        }
        List<Traccia> list = this.getTracceEngine(filtro);
        if (filtro.getLimit() > 0 && list.size() > filtro.getLimit()) {
            ArrayList<Traccia> listWithFilter = new ArrayList<Traccia>();
            for (int i = 0; i < 25; ++i) {
                listWithFilter.add(list.get(i));
            }
            return listWithFilter;
        }
        return list;
    }

    private void addTracciaSafe(List<Traccia> tracce, RuoloMessaggio ruolo, Connection con, Map<String, String> propertiesRicerca, FiltroRicercaTracceConPaginazione filtro) throws DriverTracciamentoException {
        try {
            tracce.add(this.getTracciaByPropertiesEngine(con, propertiesRicerca, ruolo, filtro.getMinDate(), filtro.getMaxDate()));
        }
        catch (DriverTracciamentoNotFoundException driverTracciamentoNotFoundException) {
            // empty catch block
        }
    }

    private List<Traccia> getTracceEngine(FiltroRicercaTracceConPaginazione filtro) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        Connection con = null;
        JDBCServiceManager transazioniServiceManager = null;
        try {
            con = this.getConnection();
            this.checkConnection(con);
            transazioniServiceManager = (JDBCServiceManager)this.daoFactory.getServiceManager((IProjectInfo)new ProjectInfo(), con, true);
            ITransazioneServiceSearch transazioneServiceSearch = transazioniServiceManager.getTransazioneServiceSearch();
            IPaginatedExpression expression = this.newPaginatedExpressionEngine(transazioneServiceSearch, filtro);
            List lstTransazioni = transazioneServiceSearch.select(expression, new IField[]{Transazione.model().ID_TRANSAZIONE, Transazione.model().ID_MESSAGGIO_RICHIESTA, Transazione.model().ID_MESSAGGIO_RISPOSTA});
            ArrayList<Traccia> tracce = new ArrayList<Traccia>();
            block15: for (Map transazioneMap : lstTransazioni) {
                String idTransazione = (String)transazioneMap.get(Transazione.model().ID_TRANSAZIONE.getFieldName());
                Object oIdBustaRichiesta = transazioneMap.get(Transazione.model().ID_MESSAGGIO_RICHIESTA.getFieldName());
                String idBustaRichiesta = oIdBustaRichiesta instanceof String ? (String)oIdBustaRichiesta : null;
                Object oIdBustaRisposta = transazioneMap.get(Transazione.model().ID_MESSAGGIO_RISPOSTA.getFieldName());
                String idBustaRisposta = oIdBustaRisposta instanceof String ? (String)oIdBustaRisposta : null;
                HashMap<String, String> propertiesRicerca = new HashMap<String, String>();
                propertiesRicerca.put("id_transazione", idTransazione);
                if (filtro.getIdBusta() != null) {
                    if (filtro.getTipoTraccia() == null) {
                        if (filtro.getIdBusta().equals(idBustaRichiesta)) {
                            this.addTracciaSafe(tracce, RuoloMessaggio.RICHIESTA, con, propertiesRicerca, filtro);
                            continue;
                        }
                        if (!filtro.getIdBusta().equals(idBustaRisposta)) continue;
                        this.addTracciaSafe(tracce, RuoloMessaggio.RISPOSTA, con, propertiesRicerca, filtro);
                        continue;
                    }
                    switch (filtro.getTipoTraccia()) {
                        case RICHIESTA: {
                            this.addTracciaSafe(tracce, RuoloMessaggio.RICHIESTA, con, propertiesRicerca, filtro);
                            continue block15;
                        }
                        case RISPOSTA: {
                            this.addTracciaSafe(tracce, RuoloMessaggio.RISPOSTA, con, propertiesRicerca, filtro);
                            continue block15;
                        }
                    }
                    continue;
                }
                if (filtro.getIdBustaRichiesta() != null || filtro.getIdBustaRisposta() != null) {
                    if (filtro.getIdBustaRichiesta() != null) {
                        this.addTracciaSafe(tracce, RuoloMessaggio.RICHIESTA, con, propertiesRicerca, filtro);
                    }
                    if (filtro.getIdBustaRisposta() == null) continue;
                    this.addTracciaSafe(tracce, RuoloMessaggio.RISPOSTA, con, propertiesRicerca, filtro);
                    continue;
                }
                if (filtro.getRiferimentoMessaggio() != null) {
                    this.addTracciaSafe(tracce, RuoloMessaggio.RISPOSTA, con, propertiesRicerca, filtro);
                    continue;
                }
                this.addTracciaSafe(tracce, RuoloMessaggio.RICHIESTA, con, propertiesRicerca, filtro);
                this.addTracciaSafe(tracce, RuoloMessaggio.RISPOSTA, con, propertiesRicerca, filtro);
            }
            if (tracce.isEmpty()) {
                throw new DriverTracciamentoNotFoundException("Tracce non trovate che rispettano il filtro di ricerca (Filtro:" + filtro.toString() + ")");
            }
            ArrayList<Traccia> arrayList = tracce;
            return arrayList;
        }
        catch (DriverTracciamentoNotFoundException e) {
            throw e;
        }
        catch (NotFoundException e) {
            throw new DriverTracciamentoNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Riscontrato errore durante la lettura dei dati (Filtro:" + filtro.toString() + "): " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (transazioniServiceManager != null) {
                    transazioniServiceManager.close();
                }
            }
            catch (Exception exception) {}
            this.closeConnection(con);
        }
    }

    private IExpression newExpressionEngine(ITransazioneServiceSearch transazioneServiceSearch, FiltroRicercaTracce filtro) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException, ProtocolException {
        IExpression expressionIdBusta;
        Timestamp tIdBusta;
        IBustaBuilder protocolBustaBuilder;
        IProtocolFactory protocolFactory;
        IExpression expression = transazioneServiceSearch.newExpression();
        if (filtro.getMaxDate() != null) {
            expression.lessEquals(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)filtro.getMaxDate());
        }
        if (filtro.getMinDate() != null) {
            expression.greaterEquals(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)filtro.getMinDate());
        }
        if (filtro.getTipoPdD() != null) {
            expression.equals(Transazione.model().PDD_RUOLO, (Object)filtro.getTipoPdD().getTipo());
        }
        if (filtro.getDominio() != null) {
            if (filtro.getDominio().getCodicePorta() != null) {
                expression.equals(Transazione.model().PDD_CODICE, (Object)filtro.getDominio().getCodicePorta());
            }
            if (filtro.getDominio().getTipo() != null) {
                expression.equals(Transazione.model().PDD_TIPO_SOGGETTO, (Object)filtro.getDominio().getTipo());
            }
            if (filtro.getDominio().getNome() != null) {
                expression.equals(Transazione.model().PDD_NOME_SOGGETTO, (Object)filtro.getDominio().getNome());
            }
        }
        boolean isOttimizzazioniTransazioniIdProtocolloDateInCampiSeparati = true;
        if (filtro.getIdBusta() != null) {
            IExpression expressionIdBusta2 = transazioneServiceSearch.newExpression();
            if (isOttimizzazioniTransazioniIdProtocolloDateInCampiSeparati) {
                if (filtro.getProtocollo() == null) {
                    throw new ServiceException("Se nel filtro viene impostato l'id della busta, ed \u00e8 attiva l'opzione della comprensione delle date interne agli id, deve essere specificato nel filtro anche il protocollo");
                }
                IProtocolFactory protocolFactory2 = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(filtro.getProtocollo());
                IBustaBuilder protocolBustaBuilder2 = protocolFactory2.createBustaBuilder(null);
                Timestamp tIdBusta2 = DateUtility.getTimestampIntoIdProtocollo(this.log, protocolBustaBuilder2, filtro.getIdBusta());
                if (tIdBusta2 == null) {
                    if (filtro.getTipoTraccia() == null) {
                        expressionIdBusta2.equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)filtro.getIdBusta());
                        expressionIdBusta2.or();
                        expressionIdBusta2.equals(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)filtro.getIdBusta());
                    } else {
                        switch (filtro.getTipoTraccia()) {
                            case RICHIESTA: {
                                expressionIdBusta2.equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)filtro.getIdBusta());
                                break;
                            }
                            case RISPOSTA: {
                                expressionIdBusta2.equals(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)filtro.getIdBusta());
                                break;
                            }
                        }
                    }
                } else {
                    IExpression expressionRichiesta = transazioneServiceSearch.newExpression();
                    IExpression expressionRisposta = transazioneServiceSearch.newExpression();
                    if (filtro.getTipoTraccia() == null) {
                        expressionRichiesta.equals(Transazione.model().DATA_ID_MSG_RICHIESTA, (Object)tIdBusta2).and().equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)filtro.getIdBusta());
                        expressionRisposta.equals(Transazione.model().DATA_ID_MSG_RISPOSTA, (Object)tIdBusta2).and().equals(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)filtro.getIdBusta());
                        expressionIdBusta2.or(expressionRichiesta, expressionRisposta);
                    } else {
                        switch (filtro.getTipoTraccia()) {
                            case RICHIESTA: {
                                expressionIdBusta2.equals(Transazione.model().DATA_ID_MSG_RICHIESTA, (Object)tIdBusta2).and().equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)filtro.getIdBusta());
                                break;
                            }
                            case RISPOSTA: {
                                expressionIdBusta2.equals(Transazione.model().DATA_ID_MSG_RISPOSTA, (Object)tIdBusta2).and().equals(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)filtro.getIdBusta());
                                break;
                            }
                        }
                    }
                }
            } else if (filtro.getTipoTraccia() == null) {
                expressionIdBusta2.equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)filtro.getIdBusta()).or().equals(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)filtro.getIdBusta());
            } else {
                switch (filtro.getTipoTraccia()) {
                    case RICHIESTA: {
                        expressionIdBusta2.equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)filtro.getIdBusta());
                        break;
                    }
                    case RISPOSTA: {
                        expressionIdBusta2.equals(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)filtro.getIdBusta());
                        break;
                    }
                }
            }
            expression.and(new IExpression[]{expressionIdBusta2});
        }
        if (filtro.getIdBustaRichiesta() != null) {
            if (isOttimizzazioniTransazioniIdProtocolloDateInCampiSeparati) {
                if (filtro.getProtocollo() == null) {
                    throw new ServiceException("Se nel filtro viene impostato l'identificativo di richiesta della busta, ed \u00e8 attiva l'opzione della comprensione delle date interne agli id, deve essere specificato nel filtro anche il protocollo");
                }
                protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(filtro.getProtocollo());
                protocolBustaBuilder = protocolFactory.createBustaBuilder(null);
                tIdBusta = DateUtility.getTimestampIntoIdProtocollo(this.log, protocolBustaBuilder, filtro.getIdBustaRichiesta());
                if (tIdBusta == null) {
                    expression.equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)filtro.getIdBustaRichiesta());
                } else {
                    expressionIdBusta = transazioneServiceSearch.newExpression();
                    expressionIdBusta.equals(Transazione.model().DATA_ID_MSG_RICHIESTA, (Object)tIdBusta).and().equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)filtro.getIdBustaRichiesta());
                    expression.and(new IExpression[]{expressionIdBusta});
                }
            } else {
                expression.equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)filtro.getIdBustaRichiesta());
            }
        }
        if (filtro.getIdBustaRisposta() != null) {
            if (isOttimizzazioniTransazioniIdProtocolloDateInCampiSeparati) {
                if (filtro.getProtocollo() == null) {
                    throw new ServiceException("Se nel filtro viene impostato l'identificativo di risposta della busta, ed \u00e8 attiva l'opzione della comprensione delle date interne agli id, deve essere specificato nel filtro anche il protocollo");
                }
                protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(filtro.getProtocollo());
                protocolBustaBuilder = protocolFactory.createBustaBuilder(null);
                tIdBusta = DateUtility.getTimestampIntoIdProtocollo(this.log, protocolBustaBuilder, filtro.getIdBustaRisposta());
                if (tIdBusta == null) {
                    expression.equals(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)filtro.getIdBustaRisposta());
                } else {
                    expressionIdBusta = transazioneServiceSearch.newExpression();
                    expressionIdBusta.equals(Transazione.model().DATA_ID_MSG_RISPOSTA, (Object)tIdBusta).and().equals(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)filtro.getIdBustaRisposta());
                    expression.and(new IExpression[]{expressionIdBusta});
                }
            } else {
                expression.equals(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)filtro.getIdBustaRisposta());
            }
        }
        if (filtro.getRiferimentoMessaggio() != null) {
            if (isOttimizzazioniTransazioniIdProtocolloDateInCampiSeparati) {
                if (filtro.getProtocollo() == null) {
                    throw new ServiceException("Se nel filtro viene impostato il riferimento messaggio della busta, ed \u00e8 attiva l'opzione della comprensione delle date interne agli id, deve essere specificato nel filtro anche il protocollo");
                }
                protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(filtro.getProtocollo());
                protocolBustaBuilder = protocolFactory.createBustaBuilder(null);
                Timestamp tRifMessaggio = DateUtility.getTimestampIntoIdProtocollo(this.log, protocolBustaBuilder, filtro.getRiferimentoMessaggio());
                if (tRifMessaggio == null) {
                    expression.equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)filtro.getRiferimentoMessaggio());
                } else {
                    IExpression expressionRiferimento = transazioneServiceSearch.newExpression();
                    expressionRiferimento.equals(Transazione.model().DATA_ID_MSG_RICHIESTA, (Object)tRifMessaggio).and().equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)filtro.getRiferimentoMessaggio());
                    expression.and(new IExpression[]{expressionRiferimento});
                }
            } else {
                expression.equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)filtro.getRiferimentoMessaggio());
            }
        }
        if (filtro.getInformazioniProtocollo() != null) {
            InformazioniProtocollo info = filtro.getInformazioniProtocollo();
            if (info.getMittente() != null) {
                if (info.getMittente().getTipo() != null) {
                    expression.equals(Transazione.model().TIPO_SOGGETTO_FRUITORE, (Object)info.getMittente().getTipo());
                }
                if (info.getMittente().getNome() != null) {
                    expression.equals(Transazione.model().NOME_SOGGETTO_FRUITORE, (Object)info.getMittente().getNome());
                }
                if (info.getMittente().getCodicePorta() != null) {
                    expression.equals(Transazione.model().IDPORTA_SOGGETTO_FRUITORE, (Object)info.getMittente().getCodicePorta());
                }
            }
            if (info.getDestinatario() != null) {
                if (info.getDestinatario().getTipo() != null) {
                    expression.equals(Transazione.model().TIPO_SOGGETTO_EROGATORE, (Object)info.getDestinatario().getTipo());
                }
                if (info.getDestinatario().getNome() != null) {
                    expression.equals(Transazione.model().NOME_SOGGETTO_EROGATORE, (Object)info.getDestinatario().getNome());
                }
                if (info.getDestinatario().getCodicePorta() != null) {
                    expression.equals(Transazione.model().IDPORTA_SOGGETTO_EROGATORE, (Object)info.getDestinatario().getCodicePorta());
                }
            }
            if (info.getTipoServizio() != null) {
                expression.equals(Transazione.model().TIPO_SERVIZIO, (Object)info.getTipoServizio());
            }
            if (info.getServizio() != null) {
                expression.equals(Transazione.model().NOME_SERVIZIO, (Object)info.getServizio());
            }
            if (info.getAzione() != null) {
                expression.equals(Transazione.model().AZIONE, (Object)info.getAzione());
            }
            if (info.getProfiloCollaborazioneEngine() != null) {
                expression.equals(Transazione.model().PROFILO_COLLABORAZIONE_OP_2, (Object)info.getProfiloCollaborazioneEngine().getEngineValue());
            }
            if (info.getProfiloCollaborazioneProtocollo() != null) {
                expression.equals(Transazione.model().PROFILO_COLLABORAZIONE_PROT, (Object)info.getProfiloCollaborazioneProtocollo());
            }
        }
        if (filtro.getIdCorrelazioneApplicativa() != null && filtro.getIdCorrelazioneApplicativaRisposta() != null) {
            IExpression correlazioneExpression = transazioneServiceSearch.newExpression();
            correlazioneExpression.equals(Transazione.model().ID_CORRELAZIONE_APPLICATIVA, (Object)filtro.getIdCorrelazioneApplicativa());
            if (filtro.isIdCorrelazioneApplicativaOrMatch()) {
                correlazioneExpression.or();
            } else {
                correlazioneExpression.and();
            }
            correlazioneExpression.equals(Transazione.model().ID_CORRELAZIONE_APPLICATIVA_RISPOSTA, (Object)filtro.getIdCorrelazioneApplicativaRisposta());
            expression.and(new IExpression[]{correlazioneExpression});
        } else if (filtro.getIdCorrelazioneApplicativa() != null) {
            expression.equals(Transazione.model().ID_CORRELAZIONE_APPLICATIVA, (Object)filtro.getIdCorrelazioneApplicativa());
        } else if (filtro.getIdCorrelazioneApplicativaRisposta() != null) {
            expression.equals(Transazione.model().ID_CORRELAZIONE_APPLICATIVA_RISPOSTA, (Object)filtro.getIdCorrelazioneApplicativaRisposta());
        }
        if (filtro.getServizioApplicativoFruitore() != null) {
            expression.equals(Transazione.model().SERVIZIO_APPLICATIVO_FRUITORE, (Object)filtro.getServizioApplicativoFruitore());
        }
        if (filtro.getServizioApplicativoErogatore() != null) {
            expression.equals(Transazione.model().SERVIZIO_APPLICATIVO_EROGATORE, (Object)filtro.getServizioApplicativoErogatore());
        }
        if (filtro.getProtocollo() != null) {
            expression.equals(Transazione.model().PROTOCOLLO, (Object)filtro.getProtocollo());
        }
        return expression;
    }

    private IPaginatedExpression newPaginatedExpressionEngine(ITransazioneServiceSearch transazioneServiceSearch, FiltroRicercaTracceConPaginazione filtro) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException, ProtocolException {
        IPaginatedExpression expression = transazioneServiceSearch.toPaginatedExpression(this.newExpressionEngine(transazioneServiceSearch, (FiltroRicercaTracce)filtro));
        expression.sortOrder(filtro.isAsc() ? SortOrder.ASC : SortOrder.DESC);
        expression.addOrder(Transazione.model().DATA_INGRESSO_RICHIESTA);
        expression.offset(filtro.getOffset());
        if (filtro.getLimit() > 0) {
            expression.limit(filtro.getLimit());
        }
        return expression;
    }

    public int deleteTracce(FiltroRicercaTracce filter) throws DriverTracciamentoException {
        throw new DriverTracciamentoException(NON_IMPLEMENTATO);
    }

    public Traccia getTraccia(String idBusta, IDSoggetto codicePorta) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        throw new DriverTracciamentoException(NON_IMPLEMENTATO);
    }

    public Traccia getTraccia(String idBusta, IDSoggetto codicePorta, boolean ricercaIdBustaComeRiferimentoMessaggio) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        throw new DriverTracciamentoException(NON_IMPLEMENTATO);
    }

    public Traccia getTraccia(RuoloMessaggio tipoTraccia, Map<String, String> propertiesRicerca) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        try {
            Traccia tr = this.getTracciaByPropertiesEngine(null, propertiesRicerca, tipoTraccia, null, null);
            if (tr == null) {
                throw new DriverTracciamentoNotFoundException("NotFound");
            }
            return tr;
        }
        catch (DriverTracciamentoNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException(e.getMessage(), (Throwable)e);
        }
    }

    public Traccia getTraccia(String idTransazione, RuoloMessaggio tipoTraccia) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        HashMap<String, String> propertiesRicerca = new HashMap<String, String>();
        propertiesRicerca.put("id_transazione", idTransazione);
        return this.getTraccia(tipoTraccia, propertiesRicerca);
    }

    public void close() throws DriverTracciamentoException {
        try {
            if (this.driverTracciamento != null) {
                this.driverTracciamento.close();
            }
        }
        finally {
            block10: {
                try {
                    if (this.connectionOpenViaJDBCInCostructor && this.connection != null && !this.connection.isClosed()) {
                        JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)this.connection, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                    }
                }
                catch (Exception e) {
                    if (this.log == null) break block10;
                    this.log.error("Close connection failure: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private Connection close(Connection con) {
        try {
            if (con != null) {
                JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)con, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                con = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return con;
    }

    private JDBCServiceManager close(JDBCServiceManager transazioniServiceManager) {
        try {
            if (transazioniServiceManager != null) {
                transazioniServiceManager.close();
                transazioniServiceManager = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return transazioniServiceManager;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Traccia getTracciaByPropertiesEngine(Connection conDB, Map<String, String> propertiesRicerca, RuoloMessaggio tipoTraccia, Date minDate, Date maxDate) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        Traccia traccia;
        InformazioniRecordTraccia informazioniSalvataggioTraccia;
        CredenzialiMittente credentialsFiller;
        JDBCServiceManager transazioniServiceManager;
        boolean closeConnection;
        Connection con;
        boolean removeIdTraccia;
        String idTraccia;
        String idTransazione;
        block32: {
            block31: {
                idTransazione = propertiesRicerca.get("id_transazione");
                if (idTransazione == null) {
                    throw new DriverTracciamentoException("Identificativo di transazione non fornito");
                }
                idTraccia = propertiesRicerca.get("@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@");
                removeIdTraccia = false;
                if (idTraccia != null && ID_TRACCIA_RICOSTRUITA_AS_STRING.equals(idTraccia)) {
                    propertiesRicerca.remove("@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@");
                    removeIdTraccia = true;
                }
                con = null;
                closeConnection = true;
                transazioniServiceManager = null;
                if (conDB != null) {
                    con = conDB;
                    closeConnection = false;
                } else if (this.connection != null) {
                    con = this.connection;
                    closeConnection = false;
                } else {
                    con = this.datasource.getConnection();
                }
                if (con == null) {
                    throw new DriverTracciamentoException("Connection non ottenuta");
                }
                transazioniServiceManager = (JDBCServiceManager)this.daoFactory.getServiceManager((IProjectInfo)new ProjectInfo(), con, true);
                informazioniSalvataggioTraccia = this.getInformazioniSalvataggioTraccia(transazioniServiceManager, idTransazione, tipoTraccia, credentialsFiller = new CredenzialiMittente(), minDate, maxDate);
                if (informazioniSalvataggioTraccia != null) break block31;
                transazioniServiceManager = this.close(transazioniServiceManager);
                if (closeConnection) {
                    con = this.close(con);
                }
                Traccia traccia2 = this.driverTracciamento.getTraccia(tipoTraccia, propertiesRicerca);
                this.setPropertiesEngine(traccia2, propertiesRicerca, idTransazione);
                Traccia traccia3 = traccia2;
                this.close(transazioniServiceManager);
                if (closeConnection) {
                    this.close(con);
                }
                if (removeIdTraccia) {
                    propertiesRicerca.put("@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@", idTraccia);
                }
                return traccia3;
            }
            if (!informazioniSalvataggioTraccia.isPresente()) {
                throw new DriverTracciamentoNotFoundException("non presente");
            }
            if (informazioniSalvataggioTraccia.isRicostruibile()) break block32;
            transazioniServiceManager = this.close(transazioniServiceManager);
            if (closeConnection) {
                this.close(con);
            }
            Traccia traccia4 = this.driverTracciamento.getTraccia(tipoTraccia, propertiesRicerca);
            this.setPropertiesEngine(traccia4, propertiesRicerca, idTransazione);
            Traccia traccia5 = traccia4;
            this.close(transazioniServiceManager);
            if (closeConnection) {
                this.close(con);
            }
            if (removeIdTraccia) {
                propertiesRicerca.put("@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@", idTraccia);
            }
            return traccia5;
        }
        try {
            ITransazioneServiceSearch transazioneServiceSearch = transazioniServiceManager.getTransazioneServiceSearch();
            Transazione transazione = null;
            if (maxDate != null && minDate != null) {
                IPaginatedExpression exprGetIdTransazione = transazioneServiceSearch.newPaginatedExpression();
                if (maxDate != null) {
                    exprGetIdTransazione.lessEquals(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)maxDate);
                }
                if (minDate != null) {
                    exprGetIdTransazione.greaterEquals(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)minDate);
                }
                exprGetIdTransazione.equals(Transazione.model().ID_TRANSAZIONE, (Object)idTransazione);
                List transazioni = transazioneServiceSearch.findAll(exprGetIdTransazione);
                if (transazioni == null || transazioni.isEmpty()) {
                    throw new DriverTracciamentoNotFoundException("Transazione con id '" + idTransazione + "' non trovata minDate:" + minDate + " maxDate:" + maxDate);
                }
                transazione = (Transazione)transazioni.get(0);
                if (transazione == null) {
                    throw new DriverTracciamentoNotFoundException("Transazione con id '" + idTransazione + "' minDate:" + minDate + " maxDate:" + maxDate + " ritornata null?");
                }
            } else {
                transazione = (Transazione)transazioneServiceSearch.get((Object)idTransazione);
            }
            Traccia traccia6 = this.buildTraccia(tipoTraccia, transazione, credentialsFiller.getTokenClientId(), informazioniSalvataggioTraccia);
            this.setPropertiesEngine(traccia6, propertiesRicerca, idTransazione);
            traccia = traccia6;
            this.close(transazioniServiceManager);
        }
        catch (DriverTracciamentoNotFoundException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new DriverTracciamentoException("Riscontrato errore durante la lettura dei dati (Transazione:" + idTransazione + "): " + e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.close(transazioniServiceManager);
                if (closeConnection) {
                    this.close(con);
                }
                if (removeIdTraccia) {
                    propertiesRicerca.put("@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@", idTraccia);
                }
                throw throwable;
            }
        }
        if (closeConnection) {
            this.close(con);
        }
        if (removeIdTraccia) {
            propertiesRicerca.put("@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@", idTraccia);
        }
        return traccia;
    }

    private void setPropertiesEngine(Traccia traccia, Map<String, String> propertiesRicerca, String idTransazione) {
        if (traccia.getProperties() == null) {
            traccia.setProperties(new HashMap());
        }
        if (propertiesRicerca != null && propertiesRicerca.size() > 0) {
            traccia.getProperties().putAll(propertiesRicerca);
        }
        if (!traccia.getProperties().containsKey("id_transazione")) {
            traccia.getProperties().put("id_transazione", idTransazione);
        }
        if (!traccia.getProperties().containsKey("@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@")) {
            traccia.getProperties().put("@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@", ID_TRACCIA_RICOSTRUITA_AS_STRING);
        }
    }

    private Traccia buildTraccia(RuoloMessaggio tipoTraccia, Transazione transazione, CredenzialeMittente credenzialeClientId, InformazioniRecordTraccia infoSalvataggioTraccia) throws CoreException {
        Traccia traccia = new Traccia();
        Object oGdo = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_DATA_REGISTRAZIONE).getDato();
        traccia.setGdo(oGdo != null ? (Date)oGdo : null);
        IDSoggetto idSoggetto = null;
        if (transazione.getPddCodice() != null || transazione.getPddTipoSoggetto() != null || transazione.getPddNomeSoggetto() != null) {
            idSoggetto = new IDSoggetto(transazione.getPddTipoSoggetto(), transazione.getPddNomeSoggetto(), transazione.getPddCodice());
        }
        traccia.setIdSoggetto(idSoggetto);
        switch (transazione.getPddRuolo()) {
            case APPLICATIVA: {
                traccia.setTipoPdD(TipoPdD.APPLICATIVA);
                break;
            }
            case DELEGATA: {
                traccia.setTipoPdD(TipoPdD.DELEGATA);
                break;
            }
            case INTEGRATION_MANAGER: {
                traccia.setTipoPdD(TipoPdD.INTEGRATION_MANAGER);
                break;
            }
            case ROUTER: {
                traccia.setTipoPdD(TipoPdD.ROUTER);
                break;
            }
        }
        traccia.setTipoMessaggio(tipoTraccia);
        traccia.setBusta(this.buildBusta(tipoTraccia, transazione, credenzialeClientId, infoSalvataggioTraccia));
        if (tipoTraccia.equals((Object)RuoloMessaggio.RICHIESTA)) {
            traccia.setBustaAsString(transazione.getHeaderProtocolloRichiesta());
        } else {
            traccia.setBustaAsString(transazione.getHeaderProtocolloRisposta());
        }
        traccia.setCorrelazioneApplicativa(transazione.getIdCorrelazioneApplicativa());
        traccia.setCorrelazioneApplicativaRisposta(transazione.getIdCorrelazioneApplicativaRisposta());
        if (tipoTraccia.equals((Object)RuoloMessaggio.RICHIESTA)) {
            traccia.setLocation(transazione.getLocationRichiesta());
        } else {
            traccia.setLocation(transazione.getLocationRisposta());
        }
        traccia.setProtocollo(transazione.getProtocollo());
        EsitoElaborazioneMessaggioTracciato esito = new EsitoElaborazioneMessaggioTracciato();
        Object oEsito = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_ESITO_TRACCIA).getDato();
        if (oEsito != null) {
            Character esitoChar = (Character)oEsito;
            if ('I' == esitoChar.charValue()) {
                esito.setEsito(EsitoElaborazioneMessaggioTracciatura.INVIATO);
            } else if ('R' == esitoChar.charValue()) {
                esito.setEsito(EsitoElaborazioneMessaggioTracciatura.RICEVUTO);
            } else if ('E' == esitoChar.charValue()) {
                esito.setEsito(EsitoElaborazioneMessaggioTracciatura.ERRORE);
            }
        }
        if (esito.getEsito() != null && esito.getEsito().equals((Object)EsitoElaborazioneMessaggioTracciatura.ERRORE) && TipoPdD.DELEGATA.equals((Object)traccia.getTipoPdD())) {
            esito.setDettaglio(transazione.getFaultCooperazione());
        }
        traccia.setEsitoElaborazioneMessaggioTracciato(esito);
        return traccia;
    }

    private Busta buildBusta(RuoloMessaggio tipoTraccia, Transazione transazione, CredenzialeMittente credenzialeClientId, InformazioniRecordTraccia infoSalvataggioTraccia) throws CoreException {
        Object oInoltroValue;
        Object oConfermaRicezione;
        Object oTipoOraRegistrazioneValue;
        Object oOraRegistrazione;
        boolean richiesta = tipoTraccia.equals((Object)RuoloMessaggio.RICHIESTA);
        IDSoggetto mittente = PopolamentoTracciaUtils.getIdSoggettoMittente(transazione, richiesta);
        IDSoggetto destinatario = PopolamentoTracciaUtils.getIdSoggettoDestinatario(transazione, richiesta);
        Busta busta = new Busta(transazione.getProtocollo());
        busta.setMittente(mittente.getNome());
        busta.setTipoMittente(mittente.getTipo());
        busta.setIdentificativoPortaMittente(mittente.getCodicePorta());
        busta.setIndirizzoMittente(richiesta ? transazione.getIndirizzoSoggettoFruitore() : transazione.getIndirizzoSoggettoErogatore());
        busta.setDestinatario(destinatario.getNome());
        busta.setTipoDestinatario(destinatario.getTipo());
        busta.setIdentificativoPortaDestinatario(destinatario.getCodicePorta());
        busta.setIndirizzoDestinatario(richiesta ? transazione.getIndirizzoSoggettoErogatore() : transazione.getIndirizzoSoggettoFruitore());
        boolean applicativoToken = false;
        if (credenzialeClientId != null) {
            AbstractDatoRicostruzione<?> dato = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_SOGGETTO_APPLICATIVO_TOKEN);
            Object tracciaBustaSoggettoApplicativoToken = null;
            if (dato != null) {
                tracciaBustaSoggettoApplicativoToken = dato.getDato();
            }
            if (tracciaBustaSoggettoApplicativoToken != null) {
                boolean soggettoApplicativoToken;
                boolean bl = soggettoApplicativoToken = ((Character)tracciaBustaSoggettoApplicativoToken).charValue() == 'T';
                if (soggettoApplicativoToken) {
                    IDServizioApplicativo idApplicativoToken = null;
                    if (credenzialeClientId != null && credenzialeClientId.getCredenziale() != null) {
                        try {
                            idApplicativoToken = CredenzialeTokenClient.convertApplicationDBValueToOriginal((String)credenzialeClientId.getCredenziale());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (idApplicativoToken != null && idApplicativoToken.getIdSoggettoProprietario() != null) {
                        if (RuoloMessaggio.RICHIESTA.equals((Object)tipoTraccia)) {
                            busta.setMittente(idApplicativoToken.getIdSoggettoProprietario().getNome());
                            busta.setTipoMittente(idApplicativoToken.getIdSoggettoProprietario().getTipo());
                            busta.setIdentificativoPortaMittente(null);
                            busta.setIndirizzoMittente(null);
                            applicativoToken = true;
                        } else {
                            busta.setDestinatario(idApplicativoToken.getIdSoggettoProprietario().getNome());
                            busta.setTipoDestinatario(idApplicativoToken.getIdSoggettoProprietario().getTipo());
                            busta.setIdentificativoPortaDestinatario(null);
                            busta.setIndirizzoDestinatario(null);
                            applicativoToken = true;
                        }
                    }
                }
            }
        }
        busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.toProfiloDiCollaborazione((String)transazione.getProfiloCollaborazioneOp2()));
        busta.setProfiloDiCollaborazioneValue(transazione.getProfiloCollaborazioneProt());
        Object oServizioCorrelatoPresente = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_SERVIZIO_CORRELATO_PRESENTE).getDato();
        if (((Character)oServizioCorrelatoPresente).equals(Character.valueOf('T'))) {
            busta.setServizioCorrelato(transazione.getNomeServizioCorrelato());
            busta.setTipoServizioCorrelato(transazione.getTipoServizioCorrelato());
        }
        busta.setCollaborazione(transazione.getIdCollaborazione());
        busta.setServizio(transazione.getNomeServizio());
        busta.setTipoServizio(transazione.getTipoServizio());
        busta.setVersioneServizio(Integer.valueOf(transazione.getVersioneServizio()));
        busta.setAzione(transazione.getAzione());
        if (RuoloMessaggio.RICHIESTA.equals((Object)tipoTraccia)) {
            busta.setID(transazione.getIdMessaggioRichiesta());
        } else {
            busta.setID(transazione.getIdMessaggioRisposta());
        }
        Object oRiferimentoMessaggio = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_RIFERIMENTO_MESSAGGIO).getDato();
        if (oRiferimentoMessaggio != null) {
            char riferimento = ((Character)oRiferimentoMessaggio).charValue();
            String riferimentoMessaggio = '1' == riferimento ? transazione.getIdMessaggioRichiesta() : ('2' == riferimento ? transazione.getIdMessaggioRisposta() : transazione.getIdAsincrono());
            busta.setRiferimentoMessaggio(riferimentoMessaggio);
        }
        busta.setOraRegistrazione((oOraRegistrazione = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_ORA_REGISTRAZIONE).getDato()) != null ? (Date)oOraRegistrazione : null);
        Object oTipoOraRegistrazione = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_TIPO_ORA_REGISTRAZIONE_BY_OPENSPCOOP).getDato();
        TipoOraRegistrazione tipoOraRegistrazione = null;
        if (oTipoOraRegistrazione != null) {
            char tipo = ((Character)oTipoOraRegistrazione).charValue();
            if ('U' == tipo) {
                tipoOraRegistrazione = TipoOraRegistrazione.UNKNOWN;
            } else if ('S' == tipo) {
                tipoOraRegistrazione = TipoOraRegistrazione.SINCRONIZZATO;
            } else if ('L' == tipo) {
                tipoOraRegistrazione = TipoOraRegistrazione.LOCALE;
            }
        }
        busta.setTipoOraRegistrazione(tipoOraRegistrazione, (oTipoOraRegistrazioneValue = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_TIPO_ORA_REGISTRAZIONE_BY_PROTOCOLLO).getDato()) != null ? (String)oTipoOraRegistrazioneValue : null);
        Object oScadenza = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_SCADENZA).getDato();
        if (oScadenza != null) {
            busta.setScadenza((Date)oScadenza);
        }
        if ((oConfermaRicezione = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_CONFERMA_RICHIESTA).getDato()) != null) {
            busta.setConfermaRicezione(((Character)oConfermaRicezione).charValue() == 'T');
        }
        Object oInoltro = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_FILTRO_DUPLICATI_CODE).getDato();
        Inoltro inoltro = null;
        if (oInoltro != null) {
            char value = ((Character)oInoltro).charValue();
            inoltro = 'S' == value ? Inoltro.SENZA_DUPLICATI : ('D' == value ? Inoltro.CON_DUPLICATI : Inoltro.UNKNOWN);
        }
        busta.setInoltro(inoltro, (oInoltroValue = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_FILTRO_DUPLICATI).getDato()) != null ? (String)oInoltroValue : null);
        Object oSequenza = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_SEQUENZA).getDato();
        if (oSequenza != null) {
            busta.setSequenza(Long.valueOf((String)oSequenza).longValue());
        }
        busta.setServizioApplicativoFruitore(transazione.getServizioApplicativoFruitore());
        busta.setServizioApplicativoErogatore(transazione.getServizioApplicativoErogatore());
        busta.setProtocollo(transazione.getProtocollo());
        busta.setDigest(richiesta ? transazione.getDigestRichiesta() : transazione.getDigestRisposta());
        String properties = richiesta ? transazione.getProtocolloExtInfoRichiesta() : transazione.getProtocolloExtInfoRisposta();
        Map bustaProperties = PropertiesSerializator.convertoFromDBColumnValue((String)properties);
        if (bustaProperties != null && bustaProperties.size() > 0) {
            for (Map.Entry entry : bustaProperties.entrySet()) {
                String key = (String)entry.getKey();
                List values = (List)bustaProperties.get(key);
                if (values == null || values.isEmpty()) continue;
                for (String value : values) {
                    busta.addProperty(key, value);
                }
            }
        }
        Object oRiscontroOraRegistrazione = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_RISCONTRO_ORA_REGISTRAZIONE).getDato();
        Object oRiscontroTipoOraRegistrazione = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_RISCONTRO_TIPO_ORA_REGISTRAZIONE).getDato();
        Object oRiscontroTipoOraRegistrazioneCode = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_RISCONTRO_TIPO_ORA_REGISTRAZIONE_CODE).getDato();
        if (oRiscontroOraRegistrazione != null && oRiscontroTipoOraRegistrazione != null && oRiscontroTipoOraRegistrazioneCode != null) {
            Riscontro riscontro = new Riscontro();
            riscontro.setID(transazione.getIdMessaggioRichiesta());
            riscontro.setOraRegistrazione((Date)oRiscontroOraRegistrazione);
            char value = ((Character)oRiscontroTipoOraRegistrazioneCode).charValue();
            if ('L' == value) {
                riscontro.setTipoOraRegistrazione(TipoOraRegistrazione.LOCALE);
            } else if ('S' == value) {
                riscontro.setTipoOraRegistrazione(TipoOraRegistrazione.SINCRONIZZATO);
            } else {
                riscontro.setTipoOraRegistrazione(TipoOraRegistrazione.UNKNOWN);
            }
            riscontro.setTipoOraRegistrazioneValue((String)oRiscontroTipoOraRegistrazione);
            busta.addRiscontro(riscontro);
        }
        if (!applicativoToken) {
            Object oPrimaTrasmissioneOraRegistrazione = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_PRIMA_TRASMISSIONE_ORA_REGISTRAZIONE).getDato();
            Object oPrimaTrasmissioneTipoOraRegistrazione = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_PRIMA_TRASMISSIONE_TIPO_ORA_REGISTRAZIONE).getDato();
            Object oPrimaTrasmissioneTipoOraRegistrazioneCode = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_PRIMA_TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_CODE).getDato();
            if (oPrimaTrasmissioneOraRegistrazione != null && oPrimaTrasmissioneTipoOraRegistrazione != null && oPrimaTrasmissioneTipoOraRegistrazioneCode != null) {
                Trasmissione trasmissione = new Trasmissione();
                trasmissione.setOraRegistrazione((Date)oPrimaTrasmissioneOraRegistrazione);
                boolean trasmissioneNormale = true;
                char value = ((Character)oPrimaTrasmissioneTipoOraRegistrazioneCode).charValue();
                if ('L' == value) {
                    trasmissione.setTempo(TipoOraRegistrazione.LOCALE);
                } else if ('S' == value) {
                    trasmissione.setTempo(TipoOraRegistrazione.SINCRONIZZATO);
                } else if ('U' == value) {
                    trasmissione.setTempo(TipoOraRegistrazione.UNKNOWN);
                } else if ('l' == value) {
                    trasmissione.setTempo(TipoOraRegistrazione.LOCALE);
                    trasmissioneNormale = false;
                } else if ('s' == value) {
                    trasmissione.setTempo(TipoOraRegistrazione.SINCRONIZZATO);
                    trasmissioneNormale = false;
                } else if ('u' == value) {
                    trasmissione.setTempo(TipoOraRegistrazione.UNKNOWN);
                    trasmissioneNormale = false;
                } else {
                    trasmissione.setTempo(TipoOraRegistrazione.UNKNOWN);
                }
                trasmissione.setTempoValue((String)oPrimaTrasmissioneTipoOraRegistrazione);
                if (trasmissioneNormale) {
                    trasmissione.setOrigine(mittente.getNome());
                    trasmissione.setTipoOrigine(mittente.getTipo());
                    trasmissione.setIdentificativoPortaOrigine(mittente.getCodicePorta());
                    trasmissione.setIndirizzoOrigine(busta.getIndirizzoMittente());
                    trasmissione.setDestinazione(destinatario.getNome());
                    trasmissione.setTipoDestinazione(destinatario.getTipo());
                    trasmissione.setIdentificativoPortaDestinazione(destinatario.getCodicePorta());
                    trasmissione.setIndirizzoDestinazione(busta.getIndirizzoDestinatario());
                } else {
                    trasmissione.setOrigine(destinatario.getNome());
                    trasmissione.setTipoOrigine(destinatario.getTipo());
                    trasmissione.setIdentificativoPortaOrigine(destinatario.getCodicePorta());
                    trasmissione.setIndirizzoOrigine(busta.getIndirizzoDestinatario());
                    trasmissione.setDestinazione(mittente.getNome());
                    trasmissione.setTipoDestinazione(mittente.getTipo());
                    trasmissione.setIdentificativoPortaDestinazione(mittente.getCodicePorta());
                    trasmissione.setIndirizzoDestinazione(busta.getIndirizzoMittente());
                }
                busta.addTrasmissione(trasmissione);
            }
            Object oSecondaTrasmissioneOraRegistrazione = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_SECONDA_TRASMISSIONE_ORA_REGISTRAZIONE).getDato();
            Object oSecondaTrasmissioneTipoOraRegistrazione = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_SECONDA_TRASMISSIONE_TIPO_ORA_REGISTRAZIONE).getDato();
            Object oSecondaTrasmissioneTipoOraRegistrazioneCode = infoSalvataggioTraccia.getDato(MappingRicostruzioneTraccia.TRACCIA_BUSTA_SECONDA_TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_CODE).getDato();
            if (oSecondaTrasmissioneOraRegistrazione != null && oSecondaTrasmissioneTipoOraRegistrazione != null && oSecondaTrasmissioneTipoOraRegistrazioneCode != null) {
                Trasmissione trasmissione = new Trasmissione();
                trasmissione.setOraRegistrazione((Date)oSecondaTrasmissioneOraRegistrazione);
                char value = ((Character)oSecondaTrasmissioneTipoOraRegistrazioneCode).charValue();
                if ('L' == value) {
                    trasmissione.setTempo(TipoOraRegistrazione.LOCALE);
                } else if ('S' == value) {
                    trasmissione.setTempo(TipoOraRegistrazione.SINCRONIZZATO);
                } else {
                    trasmissione.setTempo(TipoOraRegistrazione.UNKNOWN);
                }
                trasmissione.setTempoValue((String)oSecondaTrasmissioneTipoOraRegistrazione);
                trasmissione.setOrigine(destinatario.getNome());
                trasmissione.setTipoOrigine(destinatario.getTipo());
                trasmissione.setIdentificativoPortaOrigine(destinatario.getCodicePorta());
                trasmissione.setIndirizzoOrigine(busta.getIndirizzoDestinatario());
                trasmissione.setDestinazione(mittente.getNome());
                trasmissione.setTipoDestinazione(mittente.getTipo());
                trasmissione.setIdentificativoPortaDestinazione(mittente.getCodicePorta());
                trasmissione.setIndirizzoDestinazione(busta.getIndirizzoMittente());
                busta.addTrasmissione(trasmissione);
            }
        }
        return busta;
    }

    private InformazioniRecordTraccia getInformazioniSalvataggioTraccia(JDBCServiceManager transazioniServiceManager, String idTransazione, RuoloMessaggio tipoTraccia, CredenzialiMittente credentialsFiller, Date minDate, Date maxDate) throws DriverTracciamentoException {
        try {
            String dbValueTokenClientId;
            ITransazioneServiceSearch transazioneServiceSearch = transazioniServiceManager.getTransazioneServiceSearch();
            IPaginatedExpression pagExpr = transazioneServiceSearch.newPaginatedExpression();
            if (maxDate != null) {
                pagExpr.lessEquals(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)maxDate);
            }
            if (minDate != null) {
                pagExpr.greaterEquals(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)minDate);
            }
            pagExpr.equals(Transazione.model().ID_TRANSAZIONE, (Object)idTransazione);
            List selectField = null;
            selectField = RuoloMessaggio.RICHIESTA.equals((Object)tipoTraccia) ? transazioneServiceSearch.select(pagExpr, new IField[]{Transazione.model().TRACCIA_RICHIESTA, Transazione.model().TOKEN_CLIENT_ID}) : transazioneServiceSearch.select(pagExpr, new IField[]{Transazione.model().TRACCIA_RISPOSTA, Transazione.model().TOKEN_CLIENT_ID});
            if (selectField == null || selectField.isEmpty()) {
                throw new DriverTracciamentoException("Recupero informazioni per ricostruire la traccia [isRichiesta:" + tipoTraccia + "] non riuscito. Transazione con ID[" + idTransazione + "] non presente?");
            }
            if (selectField.size() > 1) {
                throw new DriverTracciamentoException("Recupero informazioni per ricostruire la traccia [isRichiesta:" + tipoTraccia + "] non riuscito. Trovata piu' di una Transazione con ID[" + idTransazione + "]?");
            }
            Map dbValue = (Map)selectField.get(0);
            String dbValueTraccia = null;
            dbValueTraccia = RuoloMessaggio.RICHIESTA.equals((Object)tipoTraccia) ? this.readValue(dbValue, Transazione.model().TRACCIA_RICHIESTA, idTransazione) : this.readValue(dbValue, Transazione.model().TRACCIA_RISPOSTA, idTransazione);
            if (dbValueTraccia == null) {
                return null;
            }
            InformazioniRecordTraccia info = InformazioniRecordTraccia.convertoFromDBColumnValue(dbValueTraccia);
            this.logDebug("RECUPERO [" + info.toString() + "]");
            if (credentialsFiller != null && (dbValueTokenClientId = this.readValue(dbValue, Transazione.model().TOKEN_CLIENT_ID, idTransazione)) != null && StringUtils.isNotEmpty((String)dbValueTokenClientId)) {
                CredenzialeMittente credenzialeClientId = this.getCredenzialeMittente(transazioniServiceManager, dbValueTokenClientId, idTransazione);
                credentialsFiller.setTokenClientId(credenzialeClientId);
            }
            return info;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Riscontrato errore durante la lettura dei dati (Transazione:" + idTransazione + "): " + e.getMessage(), (Throwable)e);
        }
    }

    private CredenzialeMittente getCredenzialeMittente(JDBCServiceManager transazioniServiceManager, String dbValueTokenClientId, String idTransazione) throws ServiceException, NotImplementedException, MultipleResultException {
        CredenzialeMittente credenzialeClientId = null;
        long id = -1L;
        try {
            IDBCredenzialeMittenteServiceSearch credenzialeMittenteServiceSearch = (IDBCredenzialeMittenteServiceSearch)transazioniServiceManager.getCredenzialeMittenteServiceSearch();
            id = Long.parseLong(dbValueTokenClientId);
            credenzialeClientId = (CredenzialeMittente)credenzialeMittenteServiceSearch.get(id);
            this.logDebug("RECUPERATO CLIENT ID [" + credenzialeClientId + "] per id [" + idTransazione + "]");
        }
        catch (NotFoundException notFound) {
            credenzialeClientId = new CredenzialeMittente();
            credenzialeClientId.setId(Long.valueOf(id));
            credenzialeClientId.setCredenziale("Informazione non disponibile");
        }
        return credenzialeClientId;
    }

    private String readValue(Map<String, Object> dbValue, IField field, String idTransazione) throws DriverTracciamentoException {
        Object objectDBValue = dbValue.get(field.getFieldName());
        String dbValueAsString = null;
        if (objectDBValue instanceof ObjectUtils.Null) {
            objectDBValue = null;
        }
        if (objectDBValue != null) {
            if (!(objectDBValue instanceof String)) {
                throw new DriverTracciamentoException("Recupero informazioni per ricostruire la traccia non riuscito. Trovato campo '" + field.getFieldName() + "' di tipo [" + objectDBValue.getClass().getName() + "] differente da quello atteso [" + String.class.getName() + "] per la Transazione con ID[" + idTransazione + "]?");
            }
            dbValueAsString = (String)objectDBValue;
        }
        return dbValueAsString;
    }
}

