/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.diagnostica;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPFault;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.GestioneTokenAutenticazione;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.MTOMProcessorType;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.eccezione.details.DettaglioEccezione;
import org.openspcoop2.core.eccezione.details.utils.XMLUtils;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.core.transazioni.constants.TipoAPI;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTokenClient;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autenticazione.GestoreAutenticazione;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.pdd.core.credenziali.engine.GestoreCredenzialiEngine;
import org.openspcoop2.pdd.core.token.PolicyGestioneToken;
import org.openspcoop2.pdd.logger.MsgDiagnosticiProperties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.diagnostica.CostantiMappingDiagnostici;
import org.openspcoop2.pdd.logger.diagnostica.DynamicExtendedInfoDiagnostico;
import org.openspcoop2.pdd.logger.diagnostica.DynamicExtendedInfoDiagnosticoControlloTraffico;
import org.openspcoop2.pdd.logger.diagnostica.DynamicExtendedInfoDiagnosticoNonRicostruibileUtils;
import org.openspcoop2.pdd.logger.diagnostica.DynamicExtendedInfoDiagnosticoType;
import org.openspcoop2.pdd.logger.diagnostica.InfoDiagnostico;
import org.openspcoop2.pdd.logger.diagnostica.InformazioniRecordDiagnostici;
import org.openspcoop2.pdd.logger.diagnostica.MappingRicostruzioneDiagnostici;
import org.openspcoop2.pdd.logger.record.AbstractDatoRicostruzione;
import org.openspcoop2.pdd.logger.record.RuoloTransazione;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.MessaggiFaultErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public class ConvertitoreCodiceDiagnostici {
    protected MsgDiagnostico msgDiag;
    protected Transazione transazioneDTO = null;
    protected InformazioniRecordDiagnostici info;
    protected IProtocolFactory<?> protocolFactory;
    protected List<String> codiciModuliSimulabili = new ArrayList<String>();
    protected List<String> codiciModuliSimulabiliIntegrazione = new ArrayList<String>();
    protected List<String> codiciModuliSimulabiliCooperazione = new ArrayList<String>();
    protected OpenSPCoop2Message mFaultRicostruitoCooperazione = null;
    protected String mFaultRicostruitoCooperazioneDescrizioneWithDetails = null;
    protected String mFaultRicostruitoCooperazioneDescrizioneWithoutDetails = null;
    protected OpenSPCoop2Message mFaultRicostruitoIntegrazione = null;
    protected String mFaultRicostruitoIntegrazioneDescrizioneWithDetails = null;
    protected String mFaultRicostruitoIntegrazioneDescrizioneWithoutDetails = null;
    protected List<String> codiciModuliSimulabiliTracciamento = new ArrayList<String>();
    protected boolean esitoAutenticazioneInCache = false;
    protected boolean esitoAutorizzazioneInCache = false;
    protected boolean esitoAutorizzazioneContenutiInCache = false;
    protected boolean esitoAutenticazioneTokenInCache = false;
    protected boolean esitoModiTokenAuthorizationInCache = false;
    protected boolean esitoModiTokenIntegrityInCache = false;
    protected boolean esitoModiTokenAuditInCache = false;
    protected boolean rispostaLettaDallaCache = false;
    protected String dettaglioAutenticazioneFallita = null;
    public static final String RICEZIONE_CONTENUTI_APPLICATIVI_CODICE_MODULO = "001";
    public static final String RICEZIONE_CONTENUTI_APPLICATIVI_LOCAL_FORWARD_LOGINFO_CODICE = "001034";
    public static final String RICEZIONE_CONTENUTI_APPLICATIVI_CONSEGNA_RISPOSTA_APPLICATIVA_OK_CODICE = "001005";
    public static final String RICEZIONE_CONTENUTI_APPLICATIVI_CONSEGNA_RISPOSTA_APPLICATIVA_KO_CODICE = "001006";
    public static final String RICEZIONE_CONTENUTI_APPLICATIVI_AUTENTICAZIONE_IN_CORSO_CODICE = "001050";
    public static final String IMBUSTAMENTO_CODICE_MODULO = "002";
    public static final String INOLTRO_BUSTE_CODICE_MODULO = "003";
    public static final String INOLTRO_BUSTE_INOLTRO_CON_ERRORE_CODICE = "003008";
    public static final String INOLTRO_BUSTE_RICEZIONE_SOAP_FAULT_CODICE = "003013";
    public static final String RICEZIONE_BUSTE_CODICE_MODULO = "004";
    public static final String RICEZIONE_BUSTE_AUTORIZZAZIONE_BUSTE_EFFETTUATA_CODICE = "004004";
    public static final String RICEZIONE_BUSTE_AUTENTICAZIONE_IN_CORSO_CODICE = "004074";
    public static final String RICEZIONE_BUSTE_AUTENTICAZIONE_EFFETTUATA_CODICE = "004075";
    public static final String RICEZIONE_BUSTE_AUTENTICAZIONE_FALLITA_CODICE = "004076";
    public static final String RICEZIONE_BUSTE_AUTENTICAZIONE_FALLITA_OPZIONALE_CODICE = "004077";
    public static final String SBUSTAMENTO_CODICE_MODULO = "005";
    public static final String SBUSTAMENTO_RISPOSTE_CODICE_MODULO = "006";
    public static final String CONSEGNA_CONTENUTI_APPLICATIVI_CODICE_MODULO = "007";
    public static final String CONSEGNA_CONTENUTI_APPLICATIVI_RICEZIONE_SOAP_FAULT_CODICE = "007014";

    public ConvertitoreCodiceDiagnostici(Transazione transazioneDTO, Traccia tracciaRichiesta, Traccia tracciaRisposta, InformazioniRecordDiagnostici info, CredenzialeMittente credenzialeClientId) throws ProtocolException {
        this.init(null, tracciaRichiesta, tracciaRisposta, transazioneDTO, info, credenzialeClientId);
    }

    protected ConvertitoreCodiceDiagnostici() {
    }

    protected void init(IProtocolFactory<?> protocolFactory, Traccia tracciaRichiesta, Traccia tracciaRisposta, Transazione transazioneDTO, InformazioniRecordDiagnostici info, CredenzialeMittente credenzialeClientId) throws ProtocolException {
        AbstractDatoRicostruzione<?> oDatoModiTokenAuthorizationInCache;
        String tipoTrasformazioneRisposta;
        String tipoTrasformazioneRichiesta;
        String tokenPolicyAuthn;
        String tokenPolicyActions;
        String tipoProcessamentoMessageSecurityRisposta;
        String tipoProcessamentoMessageSecurityRichiesta;
        String tipoProcessamentoMTOMRisposta;
        String tipoProcessamentoMTOMRichiesta;
        String tipoValidazioneContenuti;
        Object o;
        String confDir;
        if (protocolFactory == null) {
            protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(transazioneDTO.getProtocollo());
        }
        if (!MsgDiagnosticiProperties.initialize(null, confDir = null)) {
            throw new ProtocolException("Inizializzazione MsgDiagnosticiProperties non riuscita");
        }
        MsgDiagnosticiProperties msgDiagProperties = MsgDiagnosticiProperties.getInstance();
        if (!msgDiagProperties.initializeMsgDiagnosticiPersonalizzati()) {
            throw new ProtocolException("Inizializzazione MsgDiagnosticiProperties (msg personalizzati) non riuscita");
        }
        this.msgDiag = MsgDiagnostico.newInstance();
        this.msgDiag.setPrefixMsgPersonalizzati("");
        this.transazioneDTO = transazioneDTO;
        this.info = info;
        this.codiciModuliSimulabili.add(RICEZIONE_CONTENUTI_APPLICATIVI_CODICE_MODULO);
        this.codiciModuliSimulabili.add(IMBUSTAMENTO_CODICE_MODULO);
        this.codiciModuliSimulabili.add(INOLTRO_BUSTE_CODICE_MODULO);
        this.codiciModuliSimulabili.add(RICEZIONE_BUSTE_CODICE_MODULO);
        this.codiciModuliSimulabili.add(SBUSTAMENTO_CODICE_MODULO);
        this.codiciModuliSimulabili.add(SBUSTAMENTO_RISPOSTE_CODICE_MODULO);
        this.codiciModuliSimulabili.add(CONSEGNA_CONTENUTI_APPLICATIVI_CODICE_MODULO);
        this.codiciModuliSimulabili.add("008");
        this.codiciModuliSimulabiliIntegrazione.add(RICEZIONE_CONTENUTI_APPLICATIVI_CODICE_MODULO);
        this.codiciModuliSimulabiliIntegrazione.add(IMBUSTAMENTO_CODICE_MODULO);
        this.codiciModuliSimulabiliIntegrazione.add(CONSEGNA_CONTENUTI_APPLICATIVI_CODICE_MODULO);
        this.codiciModuliSimulabiliCooperazione.add(INOLTRO_BUSTE_CODICE_MODULO);
        this.codiciModuliSimulabiliCooperazione.add(RICEZIONE_BUSTE_CODICE_MODULO);
        this.codiciModuliSimulabiliCooperazione.add(SBUSTAMENTO_CODICE_MODULO);
        this.codiciModuliSimulabiliCooperazione.add(SBUSTAMENTO_RISPOSTE_CODICE_MODULO);
        this.codiciModuliSimulabiliTracciamento.add("009007");
        this.codiciModuliSimulabiliTracciamento.add("009008");
        this.codiciModuliSimulabiliTracciamento.add("009009");
        this.codiciModuliSimulabiliTracciamento.add("009010");
        this.codiciModuliSimulabiliTracciamento.add("009011");
        this.codiciModuliSimulabiliTracciamento.add("009012");
        this.codiciModuliSimulabiliTracciamento.add("009013");
        this.codiciModuliSimulabiliTracciamento.add("009014");
        this.codiciModuliSimulabiliTracciamento.add("009015");
        this.codiciModuliSimulabiliTracciamento.add("009016");
        this.codiciModuliSimulabiliTracciamento.add("009017");
        this.codiciModuliSimulabiliTracciamento.add("009018");
        this.codiciModuliSimulabiliTracciamento.add("009019");
        this.codiciModuliSimulabiliTracciamento.add("009020");
        this.codiciModuliSimulabiliTracciamento.add("009021");
        this.codiciModuliSimulabiliTracciamento.add("009022");
        IDSoggetto soggettoMittente = null;
        if (transazioneDTO.getTipoSoggettoFruitore() != null && transazioneDTO.getNomeSoggettoFruitore() != null) {
            soggettoMittente = new IDSoggetto(transazioneDTO.getTipoSoggettoFruitore(), transazioneDTO.getNomeSoggettoFruitore());
        }
        IDServizio idServizio = null;
        try {
            if (transazioneDTO.getTipoServizio() != null && transazioneDTO.getNomeServizio() != null && transazioneDTO.getTipoSoggettoErogatore() != null && transazioneDTO.getNomeSoggettoErogatore() != null) {
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(transazioneDTO.getTipoServizio(), transazioneDTO.getNomeServizio(), transazioneDTO.getTipoSoggettoErogatore(), transazioneDTO.getNomeSoggettoErogatore(), transazioneDTO.getVersioneServizio());
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        if (idServizio != null) {
            idServizio.setAzione(transazioneDTO.getAzione());
        }
        this.protocolFactory = protocolFactory;
        String protocollo = protocolFactory.getProtocol();
        this.msgDiag.addKeywords(protocolFactory);
        Busta bustaRichiesta = null;
        if (tracciaRichiesta != null && tracciaRichiesta.getBusta() != null) {
            bustaRichiesta = tracciaRichiesta.getBusta();
            this.msgDiag.addKeywords(tracciaRichiesta.getBusta(), true);
        } else {
            bustaRichiesta = new Busta(protocollo);
            bustaRichiesta.setID(transazioneDTO.getIdMessaggioRichiesta());
            ProfiloDiCollaborazione profilo = null;
            if (transazioneDTO.getProfiloCollaborazioneOp2() != null) {
                profilo = ProfiloDiCollaborazione.toProfiloDiCollaborazione((String)transazioneDTO.getProfiloCollaborazioneOp2());
                bustaRichiesta.setProfiloDiCollaborazione(profilo);
            }
            bustaRichiesta.setProfiloDiCollaborazioneValue(transazioneDTO.getProfiloCollaborazioneProt());
            bustaRichiesta.setTipoMittente(transazioneDTO.getTipoSoggettoFruitore());
            bustaRichiesta.setMittente(transazioneDTO.getNomeSoggettoFruitore());
            bustaRichiesta.setIdentificativoPortaMittente(transazioneDTO.getIdportaSoggettoFruitore());
            bustaRichiesta.setIndirizzoMittente(transazioneDTO.getIndirizzoSoggettoFruitore());
            bustaRichiesta.setTipoDestinatario(transazioneDTO.getTipoSoggettoErogatore());
            bustaRichiesta.setDestinatario(transazioneDTO.getNomeSoggettoErogatore());
            bustaRichiesta.setIdentificativoPortaDestinatario(transazioneDTO.getIdportaSoggettoErogatore());
            bustaRichiesta.setIndirizzoDestinatario(transazioneDTO.getIndirizzoSoggettoErogatore());
            bustaRichiesta.setTipoServizio(transazioneDTO.getTipoServizio());
            bustaRichiesta.setServizio(transazioneDTO.getNomeServizio());
            bustaRichiesta.setVersioneServizio(Integer.valueOf(transazioneDTO.getVersioneServizio()));
            bustaRichiesta.setAzione(transazioneDTO.getAzione());
            this.msgDiag.addKeywords(bustaRichiesta, true);
        }
        if (tracciaRisposta != null && tracciaRisposta.getBusta() != null) {
            this.msgDiag.addKeywords(tracciaRisposta.getBusta(), false);
        } else {
            Busta bustaRisposta = new Busta(protocollo);
            bustaRisposta.setID(transazioneDTO.getIdMessaggioRisposta());
            ProfiloDiCollaborazione profilo = null;
            if (transazioneDTO.getProfiloCollaborazioneOp2() != null) {
                profilo = ProfiloDiCollaborazione.toProfiloDiCollaborazione((String)transazioneDTO.getProfiloCollaborazioneOp2());
                bustaRisposta.setProfiloDiCollaborazione(profilo);
            }
            bustaRisposta.setProfiloDiCollaborazioneValue(transazioneDTO.getProfiloCollaborazioneProt());
            bustaRisposta.setTipoMittente(transazioneDTO.getTipoSoggettoErogatore());
            bustaRisposta.setMittente(transazioneDTO.getNomeSoggettoErogatore());
            bustaRisposta.setIdentificativoPortaMittente(transazioneDTO.getIdportaSoggettoErogatore());
            bustaRisposta.setIndirizzoMittente(transazioneDTO.getIndirizzoSoggettoErogatore());
            bustaRisposta.setTipoDestinatario(transazioneDTO.getTipoSoggettoFruitore());
            bustaRisposta.setDestinatario(transazioneDTO.getNomeSoggettoFruitore());
            bustaRisposta.setIdentificativoPortaDestinatario(transazioneDTO.getIdportaSoggettoFruitore());
            bustaRisposta.setIndirizzoDestinatario(transazioneDTO.getIndirizzoSoggettoFruitore());
            bustaRisposta.setTipoServizio(transazioneDTO.getTipoServizio());
            bustaRisposta.setServizio(transazioneDTO.getNomeServizio());
            bustaRisposta.setVersioneServizio(Integer.valueOf(transazioneDTO.getVersioneServizio()));
            bustaRisposta.setAzione(transazioneDTO.getAzione());
            this.msgDiag.addKeywords(bustaRisposta, false);
        }
        String servizioApplicativoFruitore = transazioneDTO.getServizioApplicativoFruitore();
        if (servizioApplicativoFruitore != null && !"".equals(servizioApplicativoFruitore)) {
            this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", transazioneDTO.getServizioApplicativoFruitore());
        } else {
            this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", "Anonimo");
        }
        String servizioApplicativoErogatore = transazioneDTO.getServizioApplicativoErogatore();
        this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizioApplicativoErogatore);
        if (credenzialeClientId != null && credenzialeClientId.getCredenziale() != null) {
            String clientId = CredenzialeTokenClient.convertClientIdDBValueToOriginal((String)credenzialeClientId.getCredenziale());
            if (clientId != null) {
                this.msgDiag.addKeyword("@TOKEN_CLIENT_ID@", clientId);
            }
            try {
                IDServizioApplicativo idApplicativoToken = CredenzialeTokenClient.convertApplicationDBValueToOriginal((String)credenzialeClientId.getCredenziale());
                if (idApplicativoToken != null) {
                    this.msgDiag.addKeyword("@TOKEN_SERVIZIO_APPLICATIVO@", idApplicativoToken.getNome() + "@" + idApplicativoToken.getIdSoggettoProprietario().toString());
                }
            }
            catch (Exception e) {
                protocolFactory.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        this.msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", transazioneDTO.getIdCorrelazioneApplicativa());
        RuoloTransazione ruoloTransazione = RuoloTransazione.toEnumConstant(transazioneDTO.getRuoloTransazione());
        String idAsincrono = transazioneDTO.getIdAsincrono();
        if (ruoloTransazione != null) {
            if (RuoloTransazione.INVOCAZIONE_ONEWAY.equals(ruoloTransazione)) {
                this.msgDiag.addKeyword("@SCENARIO_COOPERAZIONE_GESTITO@", "OneWay_InvocazioneServizio");
            } else if (RuoloTransazione.INVOCAZIONE_SINCRONA.equals(ruoloTransazione)) {
                this.msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "risposta sincrona");
                this.msgDiag.addKeyword("@SCENARIO_COOPERAZIONE_GESTITO@", "Sincrono_InvocazioneServizio");
            } else if (RuoloTransazione.INVOCAZIONE_ASINCRONA_SIMMETRICA.equals(ruoloTransazione)) {
                this.msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona simmetrica");
                this.msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", "ricevuta di una richiesta asincrona simmetrica");
                this.msgDiag.addKeyword("@SCENARIO_COOPERAZIONE_GESTITO@", "AsincronoSimmetrico_InvocazioneServizio");
            } else if (RuoloTransazione.RISPOSTA_ASINCRONA_SIMMETRICA.equals(ruoloTransazione)) {
                this.msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona simmetrica");
                this.msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", "ricevuta di una risposta asincrona simmetrica");
                if (idAsincrono != null) {
                    this.msgDiag.addKeyword("@ID_CORRELAZIONE_ASINCRONA@", idAsincrono);
                }
                this.msgDiag.addKeyword("@SCENARIO_COOPERAZIONE_GESTITO@", "AsincronoSimmetrico_ConsegnaRisposta");
            } else if (RuoloTransazione.INVOCAZIONE_ASINCRONA_ASIMMETRICA.equals(ruoloTransazione)) {
                this.msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona asimmetrica");
                this.msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", "ricevuta di una richiesta asincrona asimmetrica");
                this.msgDiag.addKeyword("@SCENARIO_COOPERAZIONE_GESTITO@", "AsincronoAsimmetrico_InvocazioneServizio");
            } else if (RuoloTransazione.RICHIESTA_STATO_ASINCRONA_ASIMMETRICA.equals(ruoloTransazione)) {
                this.msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona asimmetrica");
                this.msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", "ricevuta di una risposta asincrona asimmetrica contenente l'esito della richiesta stato");
                if (idAsincrono != null) {
                    this.msgDiag.addKeyword("@ID_CORRELAZIONE_ASINCRONA@", idAsincrono);
                }
                this.msgDiag.addKeyword("@SCENARIO_COOPERAZIONE_GESTITO@", "AsincronoAsimmetrico_Polling");
            }
        }
        String tipoMessaggio = "messaggio";
        this.msgDiag.addKeyword("@TIPO_MESSAGGIO_BUSTA@", tipoMessaggio);
        this.msgDiag.addKeyword("@DESCRIZIONE_BEHAVIOUR@", "");
        this.msgDiag.addKeyword("@DESTINATARIO_TRASMISSIONE@", "");
        String credenziali = transazioneDTO.getCredenziali();
        if (credenziali != null && !"".equals(credenziali)) {
            if (GestoreCredenzialiEngine.containsPrefixGatewayCredenziali(credenziali)) {
                String identitaGateway = GestoreCredenzialiEngine.readIdentitaGatewayCredenziali(credenziali);
                credenziali = GestoreCredenzialiEngine.erasePrefixGatewayCredenziali(credenziali);
                this.msgDiag.addKeyword("@IDENTITA_GESTORE_CREDENZIALI@", identitaGateway);
                this.msgDiag.addKeyword("@NUOVE_CREDENZIALI@", this.normalizeCredenziali(credenziali, true, false));
            } else {
                this.msgDiag.addKeyword("@NUOVE_CREDENZIALI@", this.normalizeCredenziali(credenziali, true, false));
            }
            this.msgDiag.addKeyword("@CREDENZIALI@", this.normalizeCredenziali(credenziali, true, true));
            this.msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", this.normalizeCredenziali(credenziali, true, true));
        } else {
            this.msgDiag.addKeyword("@NUOVE_CREDENZIALI@", "");
            this.msgDiag.addKeyword("@CREDENZIALI@", "");
            this.msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", "");
        }
        if (transazioneDTO.getOperazioneIm() != null) {
            this.msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", transazioneDTO.getOperazioneIm());
        }
        if (transazioneDTO.getNomePorta() != null) {
            Object messaggioPerIdAsincrono = "";
            if (idAsincrono != null) {
                messaggioPerIdAsincrono = " riferimentoMessaggio[" + idAsincrono + "]";
            }
            String c = "";
            if (credenziali != null) {
                c = credenziali;
            }
            String param = "PD[" + transazioneDTO.getNomePorta() + "]" + c + (String)messaggioPerIdAsincrono;
            this.msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
        }
        if (idServizio != null) {
            if (soggettoMittente != null) {
                this.msgDiag.addKeyword("@MITTENTE_E_SERVIZIO_DA_AUTORIZZARE@", "fruitore [" + soggettoMittente.toString() + "] -> servizio [" + idServizio.toString() + "]");
            } else {
                this.msgDiag.addKeyword("@MITTENTE_E_SERVIZIO_DA_AUTORIZZARE@", "servizio [" + idServizio.toString() + "]");
            }
        }
        if (servizioApplicativoFruitore != null) {
            this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", " identitaServizioApplicativoFruitore [" + servizioApplicativoFruitore + "]");
        } else {
            this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", "");
        }
        this.msgDiag.addKeyword("@SUBJECT_MESSAGE_SECURITY_MSG@", "");
        this.msgDiag.addKeyword("@DETAILS@", "");
        if (tracciaRisposta != null && tracciaRisposta.getBusta() != null && tracciaRisposta.getBusta().sizeListaRiscontri() == 1) {
            this.msgDiag.addKeyword("@DATA_RISCONTRO@", tracciaRisposta.getBusta().getRiscontro(0).getOraRegistrazione().toString());
            this.msgDiag.addKeyword("@ID_BUSTA_RISCONTRATA@", tracciaRisposta.getBusta().getRiscontro(0).getID());
        }
        String infoResponseFromCache = (o = info.getDato(MappingRicostruzioneDiagnostici.RESPONSE_FROM_CACHE).getDato()) != null ? (String)o : null;
        this.rispostaLettaDallaCache = "T".equals(infoResponseFromCache);
        if (PddRuolo.DELEGATA.equals((Object)transazioneDTO.getPddRuolo())) {
            this.msgDiag.addKeyword("@PORTA_DELEGATA@", transazioneDTO.getNomePorta());
        } else {
            this.msgDiag.addKeyword("@PORTA_APPLICATIVA@", transazioneDTO.getNomePorta());
        }
        o = info.getDato(MappingRicostruzioneDiagnostici.TIPO_CONNETTORE).getDato();
        String tipoConnettore = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@TIPO_CONNETTORE@", tipoConnettore);
        if (transazioneDTO.getLocationConnettore() != null) {
            int indexOf;
            String locationConnettore = transazioneDTO.getLocationConnettore();
            if (this.rispostaLettaDallaCache && locationConnettore.contains("\n") && (indexOf = locationConnettore.indexOf("\n")) > 0 && locationConnettore.length() > indexOf + "\n".length()) {
                locationConnettore = locationConnettore.substring(indexOf + "\n".length());
            }
            String url = null;
            String method = null;
            try {
                url = CostantiPdD.readUrlFromConnettoreRequest(locationConnettore);
                method = CostantiPdD.readMethodFromConnettoreRequest(locationConnettore);
            }
            catch (Exception e) {
                protocolFactory.getLogger().error(e.getMessage(), (Throwable)e);
            }
            if (url == null || StringUtils.isEmpty((String)url) || method == null || StringUtils.isEmpty((String)method)) {
                url = locationConnettore;
                method = transazioneDTO.getTipoRichiesta();
            }
            boolean tipoConnettoreHttp = false;
            if (tipoConnettore != null && (TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.HTTPS.getNome().equals(tipoConnettore) || tipoConnettore.toLowerCase().startsWith("http"))) {
                tipoConnettoreHttp = true;
            }
            HttpRequestMethod httpRequestMethod = null;
            if (method != null && !StringUtils.isEmpty((String)method)) {
                httpRequestMethod = HttpRequestMethod.valueOf((String)method);
            }
            if (TipoAPI.SOAP.getValoreAsInt() == transazioneDTO.getTipoApi() || !tipoConnettoreHttp) {
                httpRequestMethod = null;
            }
            this.msgDiag.addKeyword("@LOCATION@", ConnettoreUtils.formatLocation(httpRequestMethod, url));
        }
        String maxThreadThreshold = (o = info.getDato(MappingRicostruzioneDiagnostici.MAX_THREADS_THRESHOLD).getDato()) != null ? (String)o : null;
        this.msgDiag.addKeyword("@CT_MAX_THREADS_THRESHOLD@", maxThreadThreshold);
        o = info.getDato(MappingRicostruzioneDiagnostici.CONTROLLO_TRAFFICO_THRESHOLD).getDato();
        String controlloTrafficoThreshold = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@CT_THRESHOLD@", controlloTrafficoThreshold);
        o = info.getDato(MappingRicostruzioneDiagnostici.ACTIVE_THREADS).getDato();
        String activeThreads = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@CT_ACTIVE_THREADS@", activeThreads);
        o = info.getDato(MappingRicostruzioneDiagnostici.NUMERO_POLICY_CONFIGURATE).getDato();
        String numeroPolicy = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@CT_POLICIES@", numeroPolicy);
        o = info.getDato(MappingRicostruzioneDiagnostici.NUMERO_POLICY_DISABILITATE).getDato();
        String numeroPolicyDisabilitate = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@CT_DISABLED_POLICIES@", numeroPolicyDisabilitate);
        o = info.getDato(MappingRicostruzioneDiagnostici.NUMERO_POLICY_FILTRATE).getDato();
        String numeroPolicyFiltrate = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@CT_FILTERED_POLICIES@", numeroPolicyFiltrate);
        o = info.getDato(MappingRicostruzioneDiagnostici.NUMERO_POLICY_NON_APPLICATE).getDato();
        String numeroPolicyNonApplicabili = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@CT_NOT_APPLICABLED_POLICIES@", numeroPolicyNonApplicabili);
        o = info.getDato(MappingRicostruzioneDiagnostici.NUMERO_POLICY_RISPETTATE).getDato();
        String numeroPolicyRispettate = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@CT_RESPECTED_POLICIES@", numeroPolicyRispettate);
        o = info.getDato(MappingRicostruzioneDiagnostici.NUMERO_POLICY_VIOLATE).getDato();
        String numeroPolicyViolate = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@CT_VIOLATED_POLICIES@", numeroPolicyViolate);
        o = info.getDato(MappingRicostruzioneDiagnostici.NUMERO_POLICY_VIOLATE_WARNING_ONLY).getDato();
        String numeroPolicyViolateWarningOnly = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@CT_VIOLATED_WARNING_ONLY_POLICIES@", numeroPolicyViolateWarningOnly);
        o = info.getDato(MappingRicostruzioneDiagnostici.NUMERO_POLICY_IN_ERRORE).getDato();
        String numeroPolicyInErrore = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@CT_ERROR_POLICIES@", numeroPolicyInErrore);
        this.msgDiag.addKeyword("@SCENARIO_COOPERAZIONE_GESTITO@", "");
        Object infoSearch = "";
        if (bustaRichiesta != null && bustaRichiesta.getTipoServizio() != null && bustaRichiesta.getServizio() != null && bustaRichiesta.getTipoDestinatario() != null && bustaRichiesta.getDestinatario() != null) {
            infoSearch = bustaRichiesta.getTipoServizio() + "/" + bustaRichiesta.getServizio() + " erogato dal Soggetto " + bustaRichiesta.getTipoDestinatario() + "/" + bustaRichiesta.getDestinatario();
            if (bustaRichiesta.getAzione() != null) {
                infoSearch = (String)infoSearch + " azione " + bustaRichiesta.getAzione();
            }
            infoSearch = idAsincrono != null ? "Servizio correlato " + (String)infoSearch : "Servizio " + (String)infoSearch;
            infoSearch = "Ricerca nel registro dei servizi di: " + (String)infoSearch;
            if (idAsincrono != null) {
                infoSearch = (String)infoSearch + " (idServizioCorrelato: " + idAsincrono + ")";
            }
        }
        this.msgDiag.addKeyword("@INFO_SERVIZIO_BUSTA@", (String)infoSearch);
        o = info.getDato(MappingRicostruzioneDiagnostici.TIPO_AUTENTICAZIONE).getDato();
        String tipoAutenticazione = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@TIPO_AUTENTICAZIONE@", tipoAutenticazione);
        o = info.getDato(MappingRicostruzioneDiagnostici.TIPO_AUTORIZZAZIONE).getDato();
        String tipoAutorizzazione = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@TIPO_AUTORIZZAZIONE_BUSTE@", tipoAutorizzazione);
        this.msgDiag.addKeyword("@TIPO_AUTORIZZAZIONE@", tipoAutorizzazione);
        o = info.getDato(MappingRicostruzioneDiagnostici.TIPO_AUTORIZZAZIONE_CONTENUTI).getDato();
        String tipoAutorizzazioneContenuti = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@TIPO_AUTORIZZAZIONE_CONTENUTO@", tipoAutorizzazioneContenuti);
        o = info.getDato(MappingRicostruzioneDiagnostici.TIPO_VALIDAZIONE_CONTENUTI).getDato();
        Object tipoTradottoOpenSPCoop = null;
        String string = tipoValidazioneContenuti = o != null ? (String)o : null;
        if (tipoValidazioneContenuti != null && tipoValidazioneContenuti.length() > 0) {
            char tipoValidazione = tipoValidazioneContenuti.charAt(0);
            if ('O' == tipoValidazione) {
                tipoTradottoOpenSPCoop = CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP.getValue();
            } else if ('I' == tipoValidazione) {
                tipoTradottoOpenSPCoop = CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_INTERFACE.getValue();
            } else if ('X' == tipoValidazione) {
                tipoTradottoOpenSPCoop = CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD.getValue();
            }
            if (tipoValidazioneContenuti.length() > 1) {
                char warn;
                char mtom = tipoValidazioneContenuti.charAt(1);
                if ('M' == mtom) {
                    tipoTradottoOpenSPCoop = (String)tipoTradottoOpenSPCoop + "-mtom/xop";
                }
                if (tipoValidazioneContenuti.length() > 2 && 'W' == (warn = tipoValidazioneContenuti.charAt(2))) {
                    tipoTradottoOpenSPCoop = (String)tipoTradottoOpenSPCoop + "-warningOnly";
                }
            }
        }
        this.msgDiag.addKeyword("@TIPO_VALIDAZIONE_CONTENUTI@", (String)tipoTradottoOpenSPCoop);
        this.msgDiag.addKeyword("@DETAILS_VALIDAZIONE_CONTENUTI@", "");
        o = info.getDato(MappingRicostruzioneDiagnostici.TIPO_PROCESSAMENTO_MTOM_RICHIESTA).getDato();
        tipoTradottoOpenSPCoop = null;
        String string2 = tipoProcessamentoMTOMRichiesta = o != null ? (String)o : null;
        if (tipoProcessamentoMTOMRichiesta != null && tipoProcessamentoMTOMRichiesta.length() == 1) {
            char tipoProcessamento = tipoProcessamentoMTOMRichiesta.charAt(0);
            if ('D' == tipoProcessamento) {
                tipoTradottoOpenSPCoop = MTOMProcessorType.DISABLE.getValue();
            } else if ('P' == tipoProcessamento) {
                tipoTradottoOpenSPCoop = MTOMProcessorType.PACKAGING.getValue();
            } else if ('U' == tipoProcessamento) {
                tipoTradottoOpenSPCoop = MTOMProcessorType.UNPACKAGING.getValue();
            } else if ('V' == tipoProcessamento) {
                tipoTradottoOpenSPCoop = MTOMProcessorType.VERIFY.getValue();
            }
        }
        this.msgDiag.addKeyword("@TIPO_PROCESSAMENTO_MTOM_RICHIESTA@", (String)tipoTradottoOpenSPCoop);
        o = info.getDato(MappingRicostruzioneDiagnostici.TIPO_PROCESSAMENTO_MTOM_RISPOSTA).getDato();
        tipoTradottoOpenSPCoop = null;
        String string3 = tipoProcessamentoMTOMRisposta = o != null ? (String)o : null;
        if (tipoProcessamentoMTOMRisposta != null && tipoProcessamentoMTOMRisposta.length() == 1) {
            char tipoProcessamento = tipoProcessamentoMTOMRisposta.charAt(0);
            if ('D' == tipoProcessamento) {
                tipoTradottoOpenSPCoop = MTOMProcessorType.DISABLE.getValue();
            } else if ('P' == tipoProcessamento) {
                tipoTradottoOpenSPCoop = MTOMProcessorType.PACKAGING.getValue();
            } else if ('U' == tipoProcessamento) {
                tipoTradottoOpenSPCoop = MTOMProcessorType.UNPACKAGING.getValue();
            } else if ('V' == tipoProcessamento) {
                tipoTradottoOpenSPCoop = MTOMProcessorType.VERIFY.getValue();
            }
        }
        this.msgDiag.addKeyword("@TIPO_PROCESSAMENTO_MTOM_RISPOSTA@", (String)tipoTradottoOpenSPCoop);
        o = info.getDato(MappingRicostruzioneDiagnostici.TIPO_PROCESSAMENTO_MESSAGE_SECURITY_RICHIESTA).getDato();
        tipoTradottoOpenSPCoop = null;
        String string4 = tipoProcessamentoMessageSecurityRichiesta = o != null ? (String)o : null;
        if (tipoProcessamentoMessageSecurityRichiesta != null && tipoProcessamentoMessageSecurityRichiesta.length() > 0) {
            tipoTradottoOpenSPCoop = this.buildSicurezzaMessaggio(tipoProcessamentoMessageSecurityRichiesta);
        }
        this.msgDiag.addKeyword("@TIPO_SICUREZZA_MESSAGGIO_RICHIESTA@", (String)tipoTradottoOpenSPCoop);
        o = info.getDato(MappingRicostruzioneDiagnostici.TIPO_PROCESSAMENTO_MESSAGE_SECURITY_RISPOSTA).getDato();
        tipoTradottoOpenSPCoop = null;
        String string5 = tipoProcessamentoMessageSecurityRisposta = o != null ? (String)o : null;
        if (tipoProcessamentoMessageSecurityRisposta != null && tipoProcessamentoMessageSecurityRisposta.length() > 0) {
            tipoTradottoOpenSPCoop = this.buildSicurezzaMessaggio(tipoProcessamentoMessageSecurityRisposta);
        }
        this.msgDiag.addKeyword("@TIPO_SICUREZZA_MESSAGGIO_RISPOSTA@", (String)tipoTradottoOpenSPCoop);
        o = info.getDato(MappingRicostruzioneDiagnostici.AUTENTICAZIONE_IN_CACHE).getDato();
        String infoAutenticazioneInCache = o != null ? (String)o : null;
        this.esitoAutenticazioneInCache = "T".equals(infoAutenticazioneInCache);
        o = info.getDato(MappingRicostruzioneDiagnostici.AUTORIZZAZIONE_IN_CACHE).getDato();
        String infoAutorizzazioneInCache = o != null ? (String)o : null;
        this.esitoAutorizzazioneInCache = "T".equals(infoAutorizzazioneInCache);
        o = info.getDato(MappingRicostruzioneDiagnostici.AUTORIZZAZIONE_CONTENUTI_IN_CACHE).getDato();
        String infoAutorizzazioneContenutiInCache = o != null ? (String)o : null;
        this.esitoAutorizzazioneContenutiInCache = "T".equals(infoAutorizzazioneContenutiInCache);
        o = info.getDato(MappingRicostruzioneDiagnostici.TOKEN_POLICY).getDato();
        String tokenPolicy = o != null ? (String)o : null;
        this.msgDiag.addKeyword("@TOKEN_POLICY_GESTIONE@", tokenPolicy);
        o = info.getDato(MappingRicostruzioneDiagnostici.TOKEN_POLICY_ACTIONS).getDato();
        tipoTradottoOpenSPCoop = null;
        String string6 = tokenPolicyActions = o != null ? (String)o : null;
        if (tokenPolicyActions != null && tokenPolicyActions.length() > 0) {
            tipoTradottoOpenSPCoop = this.buildTokenPolicyValidationActions(tokenPolicyActions);
        }
        this.msgDiag.addKeyword("@TOKEN_POLICY_AZIONI@", (String)tipoTradottoOpenSPCoop);
        o = info.getDato(MappingRicostruzioneDiagnostici.TOKEN_POLICY_AUTENTCAZIONE).getDato();
        tipoTradottoOpenSPCoop = null;
        String string7 = tokenPolicyAuthn = o != null ? (String)o : null;
        if (tokenPolicyAuthn != null && tokenPolicyAuthn.length() > 0) {
            tipoTradottoOpenSPCoop = this.buildTokenPolicyAuthnActions(tokenPolicyAuthn);
        }
        this.msgDiag.addKeyword("@TOKEN_AUTHN_CHECK@", (String)tipoTradottoOpenSPCoop);
        o = info.getDato(MappingRicostruzioneDiagnostici.TIPO_TRASFORMAZIONE_RICHIESTA).getDato();
        tipoTradottoOpenSPCoop = null;
        String string8 = tipoTrasformazioneRichiesta = o != null ? (String)o : null;
        if (tipoTrasformazioneRichiesta != null && tipoTrasformazioneRichiesta.length() > 0) {
            tipoTradottoOpenSPCoop = this.buildTipoTrasformazione(tipoTrasformazioneRichiesta);
        }
        this.msgDiag.addKeyword("@TIPO_TRASFORMAZIONE_RICHIESTA@", (String)tipoTradottoOpenSPCoop);
        o = info.getDato(MappingRicostruzioneDiagnostici.TIPO_TRASFORMAZIONE_RISPOSTA).getDato();
        tipoTradottoOpenSPCoop = null;
        String string9 = tipoTrasformazioneRisposta = o != null ? (String)o : null;
        if (tipoTrasformazioneRisposta != null && tipoTrasformazioneRisposta.length() > 0) {
            tipoTradottoOpenSPCoop = this.buildTipoTrasformazione(tipoTrasformazioneRisposta);
        }
        this.msgDiag.addKeyword("@TIPO_TRASFORMAZIONE_RISPOSTA@", (String)tipoTradottoOpenSPCoop);
        AbstractDatoRicostruzione<?> oDatoAutenticazioneTokenInCache = info.getDato(MappingRicostruzioneDiagnostici.AUTENTICAZIONE_TOKEN_IN_CACHE);
        if (oDatoAutenticazioneTokenInCache != null) {
            String infoAutenticazioneTokenInCache;
            o = oDatoAutenticazioneTokenInCache.getDato();
            String string10 = infoAutenticazioneTokenInCache = o != null ? (String)o : null;
            this.esitoAutenticazioneTokenInCache = "T".equals(infoAutenticazioneTokenInCache);
        } else {
            this.esitoAutenticazioneTokenInCache = false;
        }
        AbstractDatoRicostruzione<?> oDatoAutenticazioneFallitaMotivazione = info.getDato(MappingRicostruzioneDiagnostici.AUTENTICAZIONE_FALLITA_MOTIVAZIONE);
        if (oDatoAutenticazioneFallitaMotivazione != null) {
            String tipoAutenticazioneFallitaMotivazione;
            o = oDatoAutenticazioneFallitaMotivazione.getDato();
            tipoTradottoOpenSPCoop = null;
            String string11 = tipoAutenticazioneFallitaMotivazione = o != null ? (String)o : null;
            if (tipoAutenticazioneFallitaMotivazione != null && tipoAutenticazioneFallitaMotivazione.length() > 0) {
                tipoTradottoOpenSPCoop = this.buildTipoAutenticazioneFallitaMotivazione(tipoAutenticazioneFallitaMotivazione);
            }
            if (tipoTradottoOpenSPCoop != null) {
                this.dettaglioAutenticazioneFallita = tipoTradottoOpenSPCoop;
            }
        }
        if (!PddRuolo.DELEGATA.equals((Object)transazioneDTO.getPddRuolo()) && "modipa".equals(protocollo) && "token".equals(tipoAutorizzazione)) {
            this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", "");
        }
        if ((oDatoModiTokenAuthorizationInCache = info.getDato(MappingRicostruzioneDiagnostici.MODI_TOKEN_AUTHORIZATION_IN_CACHE)) != null) {
            String infoInCache;
            o = oDatoModiTokenAuthorizationInCache.getDato();
            String string12 = infoInCache = o != null ? (String)o : null;
            this.esitoModiTokenAuthorizationInCache = "T".equals(infoInCache);
        } else {
            this.esitoModiTokenAuthorizationInCache = false;
        }
        AbstractDatoRicostruzione<?> oDatoModiTokenIntegrityInCache = info.getDato(MappingRicostruzioneDiagnostici.MODI_TOKEN_INTEGRITY_IN_CACHE);
        if (oDatoModiTokenIntegrityInCache != null) {
            String infoInCache;
            o = oDatoModiTokenIntegrityInCache.getDato();
            String string13 = infoInCache = o != null ? (String)o : null;
            this.esitoModiTokenIntegrityInCache = "T".equals(infoInCache);
        } else {
            this.esitoModiTokenIntegrityInCache = false;
        }
        AbstractDatoRicostruzione<?> oDatoModiTokenAuditInCache = info.getDato(MappingRicostruzioneDiagnostici.MODI_TOKEN_AUDIT_IN_CACHE);
        if (oDatoModiTokenAuditInCache != null) {
            String infoInCache;
            o = oDatoModiTokenAuditInCache.getDato();
            String string14 = infoInCache = o != null ? (String)o : null;
            this.esitoModiTokenAuditInCache = "T".equals(infoInCache);
        } else {
            this.esitoModiTokenAuditInCache = false;
        }
        if (info.sizeMetaDati() >= 38) {
            // empty if block
        }
    }

    private String normalizeCredenziali(String credenziali, boolean addParentesi, boolean addFinalSpace) {
        Object newC = credenziali;
        try {
            if (((String)newC).endsWith(" ")) {
                newC = ((String)newC).substring(0, ((String)newC).length() - 1);
            }
            if (((String)newC).contains("SSL-Issuer ")) {
                newC = ((String)newC).substring(0, ((String)newC).indexOf("SSL-Issuer "));
                while (((String)newC).endsWith(" ") || ((String)newC).endsWith("\n")) {
                    newC = ((String)newC).substring(0, ((String)newC).length() - 1);
                }
            }
            Object c = null;
            c = addParentesi ? "( " + (String)newC + " )" : newC;
            if (addFinalSpace) {
                c = (String)c + " ";
            }
            return c;
        }
        catch (Exception e) {
            String msgError = "Interpretazione credenziali '" + credenziali + "' non riuscita: (" + (String)newC + ") " + e.getMessage();
            LoggerWrapperFactory.getLogger(ConvertitoreCodiceDiagnostici.class).error(msgError, (Throwable)e);
            return credenziali;
        }
    }

    private String buildSicurezzaMessaggio(String tmp) {
        StringBuilder tipoTradottoOpenSPCoop = new StringBuilder();
        char engine = tmp.charAt(0);
        this.addSicurezzaMessaggioEngine(engine, tipoTradottoOpenSPCoop);
        tipoTradottoOpenSPCoop.append(" ");
        block0: for (int i = 1; i < tmp.length(); ++i) {
            String actionCode = "" + tmp.charAt(i);
            for (String keySecurity : CostantiMappingDiagnostici.getMapSecurityAction().keySet()) {
                String actionSecurityCode = CostantiMappingDiagnostici.getMapSecurityAction().get(keySecurity);
                if (!actionSecurityCode.equals(actionCode)) continue;
                if (i > 1) {
                    tipoTradottoOpenSPCoop.append(",");
                }
                tipoTradottoOpenSPCoop.append(keySecurity);
                continue block0;
            }
        }
        if (tipoTradottoOpenSPCoop.length() > 0) {
            return tipoTradottoOpenSPCoop.toString();
        }
        return null;
    }

    private void addSicurezzaMessaggioEngine(char engine, StringBuilder tipoTradottoOpenSPCoop) {
        if ('W' == engine) {
            tipoTradottoOpenSPCoop.append("wss4j");
        } else if ('S' == engine) {
            tipoTradottoOpenSPCoop.append("soapbox");
        } else if ('D' == engine) {
            tipoTradottoOpenSPCoop.append("dss");
        } else if ('J' == engine) {
            tipoTradottoOpenSPCoop.append("jose");
        } else if ('X' == engine) {
            tipoTradottoOpenSPCoop.append("xml");
        }
    }

    private String buildTokenPolicyValidationActions(String tmp) {
        PolicyGestioneToken pgt = new PolicyGestioneToken();
        if (tmp.length() == 1 && "N".equals(tmp)) {
            return pgt.getLabelAzioniGestioneToken();
        }
        for (int i = 0; i < tmp.length(); ++i) {
            String actionCode = "" + tmp.charAt(i);
            if ("J".equals(actionCode)) {
                pgt.setValidazioneJWT(true);
                continue;
            }
            if ("I".equals(actionCode)) {
                pgt.setIntrospection(true);
                continue;
            }
            if (!"U".equals(actionCode)) continue;
            pgt.setUserInfo(true);
        }
        return pgt.getLabelAzioniGestioneToken();
    }

    private String buildTokenPolicyAuthnActions(String tmp) {
        GestioneTokenAutenticazione gestore = new GestioneTokenAutenticazione();
        for (int i = 0; i < tmp.length(); ++i) {
            String actionCode = "" + tmp.charAt(i);
            if ("I".equals(actionCode)) {
                gestore.setIssuer(StatoFunzionalita.ABILITATO);
                continue;
            }
            if ("S".equals(actionCode)) {
                gestore.setSubject(StatoFunzionalita.ABILITATO);
                continue;
            }
            if ("C".equals(actionCode)) {
                gestore.setClientId(StatoFunzionalita.ABILITATO);
                continue;
            }
            if ("U".equals(actionCode)) {
                gestore.setUsername(StatoFunzionalita.ABILITATO);
                continue;
            }
            if (!"E".equals(actionCode)) continue;
            gestore.setEmail(StatoFunzionalita.ABILITATO);
        }
        return GestoreAutenticazione.getLabel(gestore);
    }

    private String buildTipoTrasformazione(String tmp) {
        if ("N".equals(tmp)) {
            return "nessuna";
        }
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < tmp.length(); ++i) {
            if (i > 0) {
                bf.append(" ");
            }
            String actionCode = "" + tmp.charAt(i);
            this.addTipoTrasformazioneAction(actionCode, bf);
        }
        if (bf.length() > 0) {
            return bf.toString();
        }
        return null;
    }

    private void addTipoTrasformazioneAction(String actionCode, StringBuilder bf) {
        if ("S".equals(actionCode)) {
            bf.append("soap");
        } else if ("R".equals(actionCode)) {
            bf.append("rest");
        } else if ("M".equals(actionCode)) {
            bf.append("method");
        } else if ("P".equals(actionCode)) {
            bf.append("path");
        } else if ("H".equals(actionCode)) {
            bf.append("headers");
        } else if ("Q".equals(actionCode)) {
            bf.append("queryParameters");
        } else if ("C".equals(actionCode)) {
            bf.append("returnCode");
        } else if ("N".equals(actionCode)) {
            bf.append("nessuna");
        } else {
            for (String keySecurity : CostantiMappingDiagnostici.getMapTipiConversione().keySet()) {
                String actionSecurityCode = CostantiMappingDiagnostici.getMapTipiConversione().get(keySecurity);
                if (!actionSecurityCode.equals(actionCode)) continue;
                bf.append(keySecurity);
                break;
            }
        }
    }

    private String buildTipoAutenticazioneFallitaMotivazione(String tmp) {
        if ("N".equals(tmp)) {
            return "credenziali non fornite";
        }
        if ("E".equals(tmp)) {
            return "credenziali fornite non corrette";
        }
        return null;
    }

    private void buildFaultInfo(Logger log) throws Exception {
        this.buildFaultInfoIntegrazione(log);
        this.buildFaultInfoCooperazione(log);
    }

    private void buildFaultInfoIntegrazione(Logger log) throws Exception {
        if (this.mFaultRicostruitoIntegrazione == null && this.transazioneDTO.getFaultIntegrazione() != null && !"".equals(this.transazioneDTO.getFaultIntegrazione())) {
            if (StringUtils.isNotEmpty((String)this.transazioneDTO.getFormatoFaultIntegrazione())) {
                MessageType msgType = MessageType.valueOf((String)this.transazioneDTO.getFormatoFaultIntegrazione());
                OpenSPCoop2MessageParseResult parseResult = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createMessage(msgType, MessageRole.FAULT, MessageUtilities.getDefaultContentType((MessageType)msgType), this.transazioneDTO.getFaultIntegrazione().getBytes());
                this.mFaultRicostruitoIntegrazione = parseResult.getMessage_throwParseException();
            }
            this.buildFaultInfoIntegrazioneDetails(log);
        }
    }

    private void buildFaultInfoIntegrazioneDetails(Logger log) throws MessageException, MessageNotSupportedException {
        if (this.mFaultRicostruitoIntegrazione != null) {
            if (ServiceBinding.SOAP.equals((Object)this.mFaultRicostruitoIntegrazione.getServiceBinding())) {
                OpenSPCoop2SoapMessage soapMsg = this.mFaultRicostruitoIntegrazione.castAsSoap();
                if (soapMsg.getSOAPBody() != null && soapMsg.getSOAPBody().hasFault()) {
                    this.mFaultRicostruitoIntegrazioneDescrizioneWithDetails = SoapUtils.safe_toString((OpenSPCoop2MessageFactory)soapMsg.getFactory(), (SOAPFault)soapMsg.getSOAPBody().getFault(), (Logger)log);
                    this.mFaultRicostruitoIntegrazioneDescrizioneWithoutDetails = SoapUtils.safe_toString((OpenSPCoop2MessageFactory)soapMsg.getFactory(), (SOAPFault)soapMsg.getSOAPBody().getFault(), (boolean)false, (Logger)log);
                }
            } else {
                OpenSPCoop2RestMessage restMsg = this.mFaultRicostruitoIntegrazione.castAsRest();
                if (restMsg.isFault()) {
                    this.mFaultRicostruitoIntegrazioneDescrizioneWithDetails = restMsg.getContentAsString();
                    this.mFaultRicostruitoIntegrazioneDescrizioneWithoutDetails = restMsg.getContentAsString();
                }
            }
        }
    }

    private void buildFaultInfoCooperazione(Logger log) throws Exception {
        if (this.mFaultRicostruitoCooperazione == null && this.transazioneDTO.getFaultCooperazione() != null && !"".equals(this.transazioneDTO.getFaultCooperazione())) {
            if (StringUtils.isNotEmpty((String)this.transazioneDTO.getFormatoFaultCooperazione())) {
                MessageType msgType = MessageType.valueOf((String)this.transazioneDTO.getFormatoFaultCooperazione());
                OpenSPCoop2MessageParseResult parseResult = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createMessage(msgType, MessageRole.FAULT, MessageUtilities.getDefaultContentType((MessageType)msgType), this.transazioneDTO.getFaultCooperazione().getBytes());
                this.mFaultRicostruitoCooperazione = parseResult.getMessage_throwParseException();
            }
            this.buildFaultInfoCooperazioneDetails(log);
        }
    }

    private void buildFaultInfoCooperazioneDetails(Logger log) throws MessageException, MessageNotSupportedException {
        if (this.mFaultRicostruitoCooperazione != null) {
            if (ServiceBinding.SOAP.equals((Object)this.mFaultRicostruitoCooperazione.getServiceBinding())) {
                OpenSPCoop2SoapMessage soapMsg = this.mFaultRicostruitoCooperazione.castAsSoap();
                if (soapMsg.getSOAPBody() != null && soapMsg.getSOAPBody().hasFault()) {
                    this.mFaultRicostruitoCooperazioneDescrizioneWithDetails = SoapUtils.safe_toString((OpenSPCoop2MessageFactory)soapMsg.getFactory(), (SOAPFault)soapMsg.getSOAPBody().getFault(), (Logger)log);
                    this.mFaultRicostruitoCooperazioneDescrizioneWithoutDetails = SoapUtils.safe_toString((OpenSPCoop2MessageFactory)soapMsg.getFactory(), (SOAPFault)soapMsg.getSOAPBody().getFault(), (boolean)false, (Logger)log);
                }
            } else {
                OpenSPCoop2RestMessage restMsg = this.mFaultRicostruitoCooperazione.castAsRest();
                if (restMsg.isFault()) {
                    this.mFaultRicostruitoCooperazioneDescrizioneWithDetails = restMsg.getContentAsString();
                    this.mFaultRicostruitoCooperazioneDescrizioneWithoutDetails = restMsg.getContentAsString();
                }
            }
        }
    }

    protected void buildFault(Logger log, String codice, String codiceModulo) throws Exception {
        if (codice != null) {
            // empty if block
        }
        this.msgDiag.getKeywordLogPersonalizzati().remove("@SOAP_FAULT@");
        this.msgDiag.addKeyword("@SOAP_FAULT@", "");
        if (this.codiciModuliSimulabiliIntegrazione.contains(codiceModulo)) {
            this.buildFaultInfo(log);
            if (this.mFaultRicostruitoIntegrazioneDescrizioneWithDetails != null) {
                this.msgDiag.getKeywordLogPersonalizzati().remove("@SOAP_FAULT@");
                this.msgDiag.addKeyword("@SOAP_FAULT@", this.mFaultRicostruitoIntegrazioneDescrizioneWithDetails);
            }
        } else if (this.codiciModuliSimulabiliCooperazione.contains(codiceModulo)) {
            this.buildFaultInfo(log);
            if (this.mFaultRicostruitoCooperazioneDescrizioneWithDetails != null) {
                this.msgDiag.getKeywordLogPersonalizzati().remove("@SOAP_FAULT@");
                this.msgDiag.addKeyword("@SOAP_FAULT@", this.mFaultRicostruitoCooperazioneDescrizioneWithDetails);
            }
        }
    }

    protected void buildContextForSingleMsgDiagnostico(String codice, String codiceModulo, boolean dynamic, String dynamicType, String dynamicValue, Logger log) throws Exception {
        Object o;
        String autenticazione;
        String v;
        String descrizioneSoapFault;
        PdDContext pddContextDevNull;
        if (codice.equals("001013") || codice.equals("001056") || codice.equals("001058") || codice.equals(RICEZIONE_BUSTE_AUTENTICAZIONE_EFFETTUATA_CODICE) || codice.equals(RICEZIONE_BUSTE_AUTENTICAZIONE_FALLITA_CODICE) || codice.equals(RICEZIONE_BUSTE_AUTENTICAZIONE_FALLITA_OPZIONALE_CODICE)) {
            pddContextDevNull = new PdDContext();
            CostantiPdD.addKeywordInCache(this.msgDiag, this.esitoAutenticazioneInCache, pddContextDevNull, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_AUTENTICAZIONE);
        } else if (codice.equals("001015") || codice.equals("001045") || codice.equals(RICEZIONE_BUSTE_AUTORIZZAZIONE_BUSTE_EFFETTUATA_CODICE) || codice.equals("004005")) {
            pddContextDevNull = new PdDContext();
            CostantiPdD.addKeywordInCache(this.msgDiag, this.esitoAutorizzazioneInCache, pddContextDevNull, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_AUTORIZZAZIONE);
        } else if (codice.equals("001016") || codice.equals("001048") || codice.equals("004045") || codice.equals("004046")) {
            pddContextDevNull = new PdDContext();
            CostantiPdD.addKeywordInCache(this.msgDiag, this.esitoAutorizzazioneContenutiInCache, pddContextDevNull, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_AUTORIZZAZIONE_CONTENUTI);
        } else if (codice.equals("001126") || codice.equals("001127") || codice.equals("001128") || codice.equals("004149") || codice.equals("004150") || codice.equals("004151")) {
            pddContextDevNull = new PdDContext();
            CostantiPdD.addKeywordInCache(this.msgDiag, this.esitoAutenticazioneTokenInCache, pddContextDevNull, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_AUTENTICAZIONE_TOKEN);
        } else if (codice.equals("001133") || codice.equals("004159")) {
            pddContextDevNull = new PdDContext();
            CostantiPdD.addKeywordInCache(this.msgDiag, this.esitoModiTokenAuthorizationInCache, pddContextDevNull, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_MODI_TOKEN_AUTHORIZATION);
        } else if (codice.equals("001139") || codice.equals("004165")) {
            pddContextDevNull = new PdDContext();
            CostantiPdD.addKeywordInCache(this.msgDiag, this.esitoModiTokenIntegrityInCache, pddContextDevNull, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_MODI_TOKEN_INTEGRITY);
        } else if (codice.equals("001145")) {
            pddContextDevNull = new PdDContext();
            CostantiPdD.addKeywordInCache(this.msgDiag, this.esitoModiTokenAuditInCache, pddContextDevNull, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_MODI_TOKEN_AUDIT);
        }
        if ((codice.equals("001058") || codice.equals(RICEZIONE_BUSTE_AUTENTICAZIONE_FALLITA_OPZIONALE_CODICE)) && this.dettaglioAutenticazioneFallita != null) {
            pddContextDevNull = new PdDContext();
            CostantiPdD.addKeywordAutenticazioneFallita(this.msgDiag, this.dettaglioAutenticazioneFallita, pddContextDevNull, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_AUTENTICAZIONE_FALLITA);
        }
        if ((codice.equals("003007") || codice.equals("007012") || codice.equals("007028")) && this.rispostaLettaDallaCache) {
            this.msgDiag.addKeyword("@LOCATION@", "govway://responseCaching");
        }
        if (codice.equals(RICEZIONE_CONTENUTI_APPLICATIVI_CONSEGNA_RISPOSTA_APPLICATIVA_OK_CODICE) || codice.equals(RICEZIONE_CONTENUTI_APPLICATIVI_CONSEGNA_RISPOSTA_APPLICATIVA_KO_CODICE) || codice.equals("001008") || codice.equals("001031") || codice.equals("001033")) {
            this.buildFaultInfo(log);
            if (this.mFaultRicostruitoIntegrazioneDescrizioneWithoutDetails != null) {
                descrizioneSoapFault = " (" + this.mFaultRicostruitoIntegrazioneDescrizioneWithoutDetails + ")";
                this.msgDiag.getKeywordLogPersonalizzati().remove("@SOAP_FAULT@");
                this.msgDiag.addKeyword("@SOAP_FAULT@", descrizioneSoapFault);
            }
        }
        if (codice.equals("004011") || codice.equals("004012") || codice.equals("004014")) {
            this.buildFaultInfo(log);
            if (this.mFaultRicostruitoCooperazioneDescrizioneWithoutDetails != null) {
                descrizioneSoapFault = " (" + this.mFaultRicostruitoCooperazioneDescrizioneWithoutDetails + ")";
                this.msgDiag.getKeywordLogPersonalizzati().remove("@SOAP_FAULT@");
                this.msgDiag.addKeyword("@SOAP_FAULT@", descrizioneSoapFault);
            }
        }
        if (codice.equals("003024")) {
            this.buildFaultInfo(log);
            if (this.mFaultRicostruitoCooperazione != null) {
                this.msgDiag.addKeyword("@DETAILS_VALIDAZIONE_CONTENUTI@", " (la risposta contiene un Fault)");
            } else if (this.msgDiag.getKeywordLogPersonalizzati().containsKey("@SCENARIO_COOPERAZIONE_GESTITO@") && "OneWay_InvocazioneServizio".equals(v = this.msgDiag.getKeywordLogPersonalizzati().get("@SCENARIO_COOPERAZIONE_GESTITO@"))) {
                this.msgDiag.addKeyword("@DETAILS_VALIDAZIONE_CONTENUTI@", " (contenuto non presente nella risposta)");
            }
        }
        if (codice.equals("007024")) {
            this.buildFaultInfo(log);
            if (this.mFaultRicostruitoIntegrazione != null) {
                this.msgDiag.addKeyword("@DETAILS_VALIDAZIONE_CONTENUTI@", " (la risposta contiene un Fault)");
            } else if (this.msgDiag.getKeywordLogPersonalizzati().containsKey("@SCENARIO_COOPERAZIONE_GESTITO@") && "OneWay_InvocazioneServizio".equals(v = this.msgDiag.getKeywordLogPersonalizzati().get("@SCENARIO_COOPERAZIONE_GESTITO@"))) {
                this.msgDiag.addKeyword("@DETAILS_VALIDAZIONE_CONTENUTI@", " (contenuto non presente nella risposta)");
            }
        }
        if (codice.equals(RICEZIONE_CONTENUTI_APPLICATIVI_LOCAL_FORWARD_LOGINFO_CODICE)) {
            this.msgDiag.addKeyword("@PORTA_APPLICATIVA@", "");
        }
        String credenziali = this.msgDiag.getKeywordLogPersonalizzati().get("@CREDENZIALI@");
        if (codice.equals(RICEZIONE_BUSTE_AUTENTICAZIONE_IN_CORSO_CODICE) || codice.equals(RICEZIONE_BUSTE_AUTENTICAZIONE_EFFETTUATA_CODICE) || codice.equals(RICEZIONE_BUSTE_AUTENTICAZIONE_FALLITA_CODICE) || codice.equals(RICEZIONE_BUSTE_AUTENTICAZIONE_FALLITA_OPZIONALE_CODICE)) {
            if (credenziali != null && !"".equals(credenziali)) {
                this.msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", credenziali);
            } else {
                this.msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", "");
            }
        } else if (credenziali != null && !"".equals(credenziali)) {
            this.msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", " credenzialiMittente " + credenziali);
        } else {
            this.msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", "");
        }
        if (codice.equals(RICEZIONE_BUSTE_AUTENTICAZIONE_EFFETTUATA_CODICE)) {
            this.msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", "");
            this.msgDiag.addKeyword("@CREDENZIALI@", "");
        } else if (codice.equals("001056")) {
            this.msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", "");
        }
        if (codice.equals("001003") && (autenticazione = this.msgDiag.getKeywordLogPersonalizzati().get("@TIPO_AUTENTICAZIONE@")) != null && !"".equals(autenticazione) && !"-".equals(autenticazione) && !"none".equals(autenticazione)) {
            this.msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", "");
        }
        if (codice.equals("004001") && (autenticazione = this.msgDiag.getKeywordLogPersonalizzati().get("@TIPO_AUTENTICAZIONE@")) != null && !"".equals(autenticazione) && !"-".equals(autenticazione) && !"none".equals(autenticazione)) {
            this.msgDiag.addKeyword("@CREDENZIALI@", "");
            this.msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", "");
        }
        String codiceConsegnaRichiesta = null;
        String codiceConsegnaRisposta = null;
        if (RICEZIONE_CONTENUTI_APPLICATIVI_CODICE_MODULO.equals(codiceModulo) || RICEZIONE_BUSTE_CODICE_MODULO.equals(codiceModulo)) {
            o = this.info.getDato(MappingRicostruzioneDiagnostici.CODICE_TRASPORTO_RISPOSTA).getDato();
            codiceConsegnaRisposta = o != null ? (String)o : null;
            this.msgDiag.addKeyword("@CODICE_CONSEGNA@", codiceConsegnaRisposta);
        } else if (INOLTRO_BUSTE_CODICE_MODULO.equals(codiceModulo) || CONSEGNA_CONTENUTI_APPLICATIVI_CODICE_MODULO.equals(codiceModulo)) {
            o = this.info.getDato(MappingRicostruzioneDiagnostici.CODICE_TRASPORTO_RICHIESTA).getDato();
            codiceConsegnaRichiesta = o != null ? (String)o : null;
            this.msgDiag.addKeyword("@CODICE_CONSEGNA@", codiceConsegnaRichiesta);
            Object erroreConsegna = "errore di trasporto, codice " + codiceConsegnaRichiesta;
            if (this.mFaultRicostruitoCooperazione != null || this.mFaultRicostruitoIntegrazione != null) {
                boolean faultProtocollo = false;
                if (codice.equals(INOLTRO_BUSTE_INOLTRO_CON_ERRORE_CODICE)) {
                    try {
                        EsitoTransazioneName name = EsitoTransazioneName.convertoTo((String)EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)this.transazioneDTO.getProtocollo()).getEsitoName(Integer.valueOf(this.transazioneDTO.getEsito())));
                        if (EsitoTransazioneName.ERRORE_PROTOCOLLO.equals((Object)name)) {
                            faultProtocollo = true;
                        }
                    }
                    catch (Exception e) {
                        log.error("Errore durante la comprensione dell'esito [" + this.transazioneDTO.getEsito() + "]: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (faultProtocollo) {
                    boolean set = false;
                    OpenSPCoop2Message msg = null;
                    if (INOLTRO_BUSTE_CODICE_MODULO.equals(codiceModulo)) {
                        msg = this.mFaultRicostruitoCooperazione;
                    } else if (CONSEGNA_CONTENUTI_APPLICATIVI_CODICE_MODULO.equals(codiceModulo)) {
                        msg = this.mFaultRicostruitoIntegrazione;
                    }
                    if (msg != null && ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                        DettaglioEccezione dettaglioEccezione;
                        SOAPFault soapFault = null;
                        if (msg.castAsSoap().getSOAPBody() != null) {
                            soapFault = msg.castAsSoap().getSOAPBody().getFault();
                        }
                        if (soapFault != null && soapFault.getFaultString() != null) {
                            if (soapFault.getFaultString().equals(this.protocolFactory.createTraduttore().toString(MessaggiFaultErroreCooperazione.FAULT_STRING_VALIDAZIONE))) {
                                set = true;
                                erroreConsegna = soapFault.getFaultString();
                                this.msgDiag.addKeyword("@TIPO_ERRORE_BUSTA@", "Intestazione");
                            } else if (soapFault.getFaultString().equals(this.protocolFactory.createTraduttore().toString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO))) {
                                set = true;
                                erroreConsegna = soapFault.getFaultString();
                                this.msgDiag.addKeyword("@TIPO_ERRORE_BUSTA@", "Processamento");
                            }
                        }
                        if (set && (dettaglioEccezione = XMLUtils.getDettaglioEccezione((Logger)log, (OpenSPCoop2Message)msg)) != null) {
                            this.msgDiag.addKeyword("@OPENSPCOOP2_DETAILS@", XMLUtils.toString((DettaglioEccezione)dettaglioEccezione));
                        }
                    }
                    if (!set) {
                        if (INOLTRO_BUSTE_CODICE_MODULO.equals(codiceModulo) && this.mFaultRicostruitoCooperazioneDescrizioneWithDetails != null) {
                            erroreConsegna = (String)erroreConsegna + " (" + this.mFaultRicostruitoCooperazioneDescrizioneWithDetails + ")";
                        }
                        if (CONSEGNA_CONTENUTI_APPLICATIVI_CODICE_MODULO.equals(codiceModulo) && this.mFaultRicostruitoIntegrazioneDescrizioneWithDetails != null) {
                            erroreConsegna = (String)erroreConsegna + " (" + this.mFaultRicostruitoIntegrazioneDescrizioneWithDetails + ")";
                        }
                    }
                } else {
                    if (INOLTRO_BUSTE_CODICE_MODULO.equals(codiceModulo) && this.mFaultRicostruitoCooperazioneDescrizioneWithDetails != null) {
                        erroreConsegna = (String)erroreConsegna + " (" + this.mFaultRicostruitoCooperazioneDescrizioneWithDetails + ")";
                    }
                    if (CONSEGNA_CONTENUTI_APPLICATIVI_CODICE_MODULO.equals(codiceModulo) && this.mFaultRicostruitoIntegrazioneDescrizioneWithDetails != null) {
                        erroreConsegna = (String)erroreConsegna + " (" + this.mFaultRicostruitoIntegrazioneDescrizioneWithDetails + ")";
                    }
                }
            }
            this.msgDiag.addKeyword("@ERRORE_CONSEGNA@", (String)erroreConsegna);
        } else {
            this.msgDiag.addKeyword("@CODICE_CONSEGNA@", null);
        }
        if (dynamic) {
            DynamicExtendedInfoDiagnosticoType type = DynamicExtendedInfoDiagnosticoType.getEnum(dynamicType);
            switch (type) {
                case NON_RICOSTRUIBILE: {
                    break;
                }
                case POLICY_CONTROLLO_TRAFFICO: {
                    Map<String, String> map = DynamicExtendedInfoDiagnosticoControlloTraffico.convertToProperties(dynamicValue);
                    if (map == null || map.size() <= 0) break;
                    this.msgDiag.getKeywordLogPersonalizzati().putAll(map);
                    break;
                }
            }
        }
    }

    public List<org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico> build(Logger log) throws UtilsException {
        ArrayList<org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico> msgDiagnosticiNormali = new ArrayList<org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico>();
        if (this.info.getDiagnostici() != null && !this.info.getDiagnostici().isEmpty()) {
            for (InfoDiagnostico infoMsgDiag : this.info.getDiagnostici()) {
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico m = new org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico();
                String codice = infoMsgDiag.getCode();
                String codiceModulo = codice.substring(0, 3);
                try {
                    this.buildFault(log, codice, codiceModulo);
                    this.buildContextForSingleMsgDiagnostico(codice, codiceModulo, false, null, null, log);
                }
                catch (Throwable t) {
                    throw new UtilsException("build context error: " + t.getMessage(), t);
                }
                this.setDatiEngine(m, codice, codiceModulo, infoMsgDiag, null);
                msgDiagnosticiNormali.add(m);
            }
        }
        if (this.info.getDiagnosticiExt() != null && !this.info.getDiagnosticiExt().isEmpty()) {
            int i;
            ArrayList<org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico> msgDiagnosticiCompleted = new ArrayList<org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico>();
            ArrayList<CallSite> positions = new ArrayList<CallSite>();
            HashMap<CallSite, InfoDiagnostico> mapPositionToInfoDiagnostico = new HashMap<CallSite, InfoDiagnostico>();
            HashMap<CallSite, DynamicExtendedInfoDiagnostico> mapPositionToDynamicExtendedInfoDiagnostico = new HashMap<CallSite, DynamicExtendedInfoDiagnostico>();
            for (i = 0; i < this.info.getDiagnosticiExt().size(); ++i) {
                InfoDiagnostico infoMsgDiag = this.info.getDiagnosticiExt().get(i);
                DynamicExtendedInfoDiagnostico d = this.info.getDatiExt().get(i);
                String keyPosition = null;
                keyPosition = d.getDiagnosticPosition() < 10 ? "000" + d.getDiagnosticPosition() : (d.getDiagnosticPosition() < 100 ? "00" + d.getDiagnosticPosition() : (d.getDiagnosticPosition() < 1000 ? "0" + d.getDiagnosticPosition() : "" + d.getDiagnosticPosition()));
                positions.add((CallSite)((Object)keyPosition));
                mapPositionToInfoDiagnostico.put((CallSite)((Object)keyPosition), infoMsgDiag);
                mapPositionToDynamicExtendedInfoDiagnostico.put((CallSite)((Object)keyPosition), d);
            }
            Collections.sort(positions);
            for (i = 0; i < positions.size(); ++i) {
                String keyPosition = (String)positions.get(i);
                InfoDiagnostico infoMsgDiag = (InfoDiagnostico)mapPositionToInfoDiagnostico.remove(keyPosition);
                DynamicExtendedInfoDiagnostico d = (DynamicExtendedInfoDiagnostico)mapPositionToDynamicExtendedInfoDiagnostico.remove(keyPosition);
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico m = new org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico();
                String codice = infoMsgDiag.getCode();
                String codiceModulo = codice.substring(0, 3);
                try {
                    this.buildFault(log, codice, codiceModulo);
                    this.buildContextForSingleMsgDiagnostico(codice, codiceModulo, true, d.getType().getValue(), d.getValue(), log);
                }
                catch (Throwable t) {
                    throw new UtilsException("build context error: " + t.getMessage(), t);
                }
                this.setDatiEngine(m, codice, codiceModulo, infoMsgDiag, d);
                while (msgDiagnosticiCompleted.size() < d.getDiagnosticPosition() && !msgDiagnosticiNormali.isEmpty()) {
                    msgDiagnosticiCompleted.add((org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico)msgDiagnosticiNormali.remove(0));
                }
                msgDiagnosticiCompleted.add(m);
            }
            while (!msgDiagnosticiNormali.isEmpty()) {
                msgDiagnosticiCompleted.add((org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico)msgDiagnosticiNormali.remove(0));
            }
            return msgDiagnosticiCompleted;
        }
        return msgDiagnosticiNormali;
    }

    private void setDatiEngine(org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag, String codice, String codiceModulo, InfoDiagnostico infoMsgDiag, DynamicExtendedInfoDiagnostico d) throws UtilsException {
        PropertiesReader pr = MsgDiagnosticiProperties.getMappingCodiceToKeywordMsgDiagnosticiPersonalizzati();
        PropertiesReader prSeverita = MsgDiagnosticiProperties.getLivelliMsgDiagnosticiPersonalizzati();
        MsgDiagnosticiProperties msgDiagProp = MsgDiagnosticiProperties.getInstance();
        boolean setSeverita = true;
        if (msgDiagProp.getCodiceDiagnosticoDebugHigh().equals(codice)) {
            setSeverita = false;
            msgDiag.setSeverita(7);
        } else if (msgDiagProp.getCodiceDiagnosticoDebugMedium().equals(codice)) {
            setSeverita = false;
            msgDiag.setSeverita(6);
        }
        String nomeCompletoDiagnostico = pr.getValue(codice);
        msgDiag.setCodice(codice);
        msgDiag.setGdo(infoMsgDiag.getGdo());
        msgDiag.setIdBusta(this.transazioneDTO.getIdMessaggioRichiesta());
        msgDiag.setIdBustaRisposta(this.transazioneDTO.getIdMessaggioRisposta());
        msgDiag.setIdFunzione(this.getIdentificativoFunzione(codiceModulo));
        IDSoggetto idDominio = new IDSoggetto(this.transazioneDTO.getPddTipoSoggetto(), this.transazioneDTO.getPddNomeSoggetto(), this.transazioneDTO.getPddCodice());
        msgDiag.setIdSoggetto(idDominio);
        if (d != null && DynamicExtendedInfoDiagnosticoType.NON_RICOSTRUIBILE.equals((Object)d.getType())) {
            msgDiag.setMessaggio(DynamicExtendedInfoDiagnosticoNonRicostruibileUtils.convertToHumanMessage(d.getValue()));
        } else {
            msgDiag.setMessaggio(this.msgDiag.getMessaggio_replaceKeywords(nomeCompletoDiagnostico));
        }
        String idTransazionePresente = msgDiag.getProperty("id_transazione");
        if (idTransazionePresente == null) {
            msgDiag.addProperty("id_transazione", this.transazioneDTO.getIdTransazione());
        }
        msgDiag.setProtocollo(this.transazioneDTO.getProtocollo());
        if (setSeverita) {
            String sev = (String)prSeverita.get((Object)nomeCompletoDiagnostico);
            int sevI = 0;
            try {
                sevI = Integer.parseInt(sev);
            }
            catch (Exception e) {
                throw new UtilsException("Errore durante il parsing della severit\u00e0 [" + sev + "] per il diagnostico [" + nomeCompletoDiagnostico + "] code [" + codice + "]");
            }
            msgDiag.setSeverita(sevI / 10000);
        }
    }

    private String getIdentificativoFunzione(String codice) throws UtilsException {
        PropertiesReader pr = MsgDiagnosticiProperties.getCodiciIdentificativiFunzione();
        Enumeration keys = pr.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = pr.getValue(key);
            if (!value.equals(codice)) continue;
            return key;
        }
        return "core";
    }
}

