/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.filetrace;

import com.nimbusds.jose.jwk.KeyUse;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.logger.filetrace.FileTraceEncryptConfig;
import org.openspcoop2.pdd.logger.filetrace.FileTraceEncryptKey;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.JWKSetStore;
import org.openspcoop2.security.keystore.MerlinKeystore;
import org.openspcoop2.security.keystore.PublicKeyStore;
import org.openspcoop2.security.keystore.SecretKeyStore;
import org.openspcoop2.security.keystore.SecretPasswordKeyDerivationConfig;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.JWK;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.byok.BYOKConfig;
import org.openspcoop2.utils.certificate.byok.BYOKCostanti;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.security.Encrypt;
import org.openspcoop2.utils.security.EncryptOpenSSLPass;
import org.openspcoop2.utils.security.EncryptOpenSSLPassPBKDF2;
import org.openspcoop2.utils.security.EncryptWrapKey;
import org.openspcoop2.utils.security.JOSESerialization;
import org.openspcoop2.utils.security.JWEOptions;
import org.openspcoop2.utils.security.JsonEncrypt;
import org.openspcoop2.utils.security.JsonUtils;
import org.openspcoop2.utils.security.JwtHeaders;
import org.openspcoop2.utils.security.OpenSSLEncryptionMode;
import org.slf4j.Logger;

public class FileTraceEncrypt {
    private Logger log;
    private RequestInfo requestInfo;
    private Context context;
    private Busta busta;
    private static final String JAVA_SEPARATOR = ".";
    private static final String KEYSTORE_PREFIX = "Keystore [";

    public FileTraceEncrypt(Logger log, RequestInfo requestInfo, Context context, Busta busta) {
        this.log = log;
        this.requestInfo = requestInfo;
        this.context = context;
        this.busta = busta;
    }

    private String getKeystoreError(FileTraceEncryptConfig config) {
        return "Access to keystore [" + config.getKeystoreType().getNome() + "] '" + config.getKeystorePath() + "' failed";
    }

    private String getKeyError(FileTraceEncryptConfig config) {
        return "Access to key [" + config.getKeystoreType().getNome() + "] '" + config.getKeystorePath() + "' failed";
    }

    public String encrypt(FileTraceEncryptConfig config, String value) throws UtilsException {
        FileTraceEncryptKey fileTraceEncryptKey = new FileTraceEncryptKey();
        boolean initPasswordKeyDerivation = false;
        try {
            switch (config.getKeystoreType()) {
                case JKS: 
                case PKCS12: 
                case PKCS11: 
                case JCEKS: {
                    this.readKeystore(fileTraceEncryptKey, config);
                    break;
                }
                case JWK_SET: {
                    this.readJwk(fileTraceEncryptKey, config);
                    break;
                }
                case PUBLIC_KEY: {
                    this.readPublicKey(fileTraceEncryptKey, config);
                    break;
                }
                case SYMMETRIC_KEY: {
                    this.readSecretKey(fileTraceEncryptKey, config);
                    break;
                }
                case PASSWORD_KEY_DERIVATION: {
                    this.readPasswordKeyDerivation(fileTraceEncryptKey, config);
                    initPasswordKeyDerivation = true;
                    break;
                }
                default: {
                    throw new UtilsException(KEYSTORE_PREFIX + config.getKeystoreType().getNome() + "] unsupported");
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        if (config.isJavaEngine()) {
            if (config.isKeyWrap()) {
                if (initPasswordKeyDerivation) {
                    throw new UtilsException(KEYSTORE_PREFIX + config.getKeystoreType().getNome() + "] unusable with key wrap java mode");
                }
                return this.encJavaKeyWrap(fileTraceEncryptKey, config, value);
            }
            return this.encJava(fileTraceEncryptKey, config, value);
        }
        if (config.isJoseEngine()) {
            if (initPasswordKeyDerivation) {
                throw new UtilsException(KEYSTORE_PREFIX + config.getKeystoreType().getNome() + "] unusable with jose mode");
            }
            return this.encJose(fileTraceEncryptKey, config, value);
        }
        if (config.isOpenSSLEngine()) {
            return this.encOpenSSL(fileTraceEncryptKey, config, value);
        }
        throw new UtilsException("Encrypt mode undefined");
    }

    private BYOKRequestParams getBYOKRequestParams(FileTraceEncryptConfig config) throws UtilsException {
        BYOKRequestParams req = null;
        if (config != null && config.getKmsId() != null) {
            BYOKManager manager = BYOKManager.getInstance();
            if (manager == null) {
                throw new UtilsException("BYOKManager not initialized");
            }
            BYOKConfig bconfig = manager.getKMSConfigByType(config.getKmsId());
            if (bconfig == null) {
                throw new UtilsException("BYOK configuration for kms id '" + config.getKmsId() + "' not found");
            }
            req = new BYOKRequestParams();
            req.setConfig(bconfig);
            HashMap<String, String> inputMap = new HashMap<String, String>();
            if (config.getKmsInput() != null && !config.getKmsInput().isEmpty()) {
                inputMap.putAll(config.getKmsInput());
            }
            req.setInputMap(inputMap);
            Map<String, Object> dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(this.busta, this.requestInfo, this.context, this.log);
            req.setDynamicMap(dynamicMap);
        }
        return req;
    }

    private void readKeystore(FileTraceEncryptKey fileTraceEncryptKey, FileTraceEncryptConfig config) throws UtilsException, SecurityException {
        String type = KeystoreType.PKCS11.equals((Object)config.getKeystoreType()) ? config.getKeystoreHsmType() : config.getKeystoreType().getNome();
        MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)this.requestInfo, (String)config.getKeystorePath(), (String)type, (String)config.getKeystorePassword(), (BYOKRequestParams)this.getBYOKRequestParams(config));
        if (merlinKs == null || merlinKs.getKeyStore() == null) {
            throw new UtilsException(this.getKeystoreError(config));
        }
        fileTraceEncryptKey.ks = merlinKs.getKeyStore();
        if (KeystoreType.JCEKS.equals((Object)config.getKeystoreType())) {
            fileTraceEncryptKey.key = fileTraceEncryptKey.ks.getSecretKey(config.getKeyAlias(), config.getKeyPassword());
            fileTraceEncryptKey.secret = true;
        } else {
            fileTraceEncryptKey.key = merlinKs.getKeyStore().getPublicKey(config.getKeyAlias());
        }
    }

    private void readJwk(FileTraceEncryptKey fileTraceEncryptKey, FileTraceEncryptConfig config) throws UtilsException, SecurityException {
        JWKSetStore jwtStore = GestoreKeystoreCache.getJwkSetStore((RequestInfo)this.requestInfo, (String)config.getKeystorePath(), (BYOKRequestParams)this.getBYOKRequestParams(config));
        if (jwtStore == null || jwtStore.getJwkSet() == null) {
            throw new UtilsException(this.getKeystoreError(config));
        }
        fileTraceEncryptKey.jsonWebKeys = jwtStore.getJwkSet().getJsonWebKeys();
        JsonWebKey jwk = JsonUtils.readKey((JsonWebKeys)fileTraceEncryptKey.jsonWebKeys, (String)config.getKeyAlias());
        if (jwk == null) {
            throw new UtilsException("Accesso al keystore [" + config.getKeystoreType().getNome() + "] '" + config.getKeystorePath() + "' non riuscito per l'alias '" + config.getKeyAlias() + "'");
        }
        if (jwk.getAlgorithm() == null) {
            jwk.setAlgorithm(config.isJavaEngine() ? "A256GCM" : config.getContentAlgorithm());
        }
        if (config.getKeyAlgorithm().contains("RSA")) {
            fileTraceEncryptKey.key = JwkUtils.toRSAPublicKey((JsonWebKey)jwk);
        } else if (config.getKeyAlgorithm().contains("EC")) {
            fileTraceEncryptKey.key = JwkUtils.toECPublicKey((JsonWebKey)jwk);
        } else {
            fileTraceEncryptKey.key = JwkUtils.toSecretKey((JsonWebKey)jwk);
            fileTraceEncryptKey.secret = true;
        }
    }

    private byte[] readKeyInline(FileTraceEncryptConfig config) throws SecurityException {
        String keyInLine = config.getKeyInline();
        byte[] key = null;
        if (config.isKeyBase64Encoding()) {
            key = Base64Utilities.decode((byte[])keyInLine.getBytes());
        } else if (config.isKeyHexEncoding()) {
            try {
                key = HexBinaryUtilities.decode((String)keyInLine);
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage());
            }
        } else {
            key = keyInLine.getBytes();
        }
        return key;
    }

    private byte[] readEncodedKeyFromPath(FileTraceEncryptConfig config) throws SecurityException {
        byte[] encodedKey = GestoreKeystoreCache.getExternalResource((RequestInfo)this.requestInfo, (String)config.getKeyPath(), null).getResource();
        byte[] key = null;
        if (config.isKeyBase64Encoding()) {
            key = Base64Utilities.decode((byte[])encodedKey);
        } else {
            try {
                key = HexBinaryUtilities.decode((String)new String(encodedKey));
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage());
            }
        }
        return key;
    }

    private String readPublicKeyAlgo(FileTraceEncryptConfig config) {
        String algo = config.getKeyAlgorithm();
        if (config.isJoseEngine() || config.isKeyWrap()) {
            algo = config.getKeyAlgorithm().contains("RSA") ? "RSA" : (config.getKeyAlgorithm().contains("DSA") ? "DSA" : (config.getKeyAlgorithm().contains("DH") ? "DH" : (config.getKeyAlgorithm().contains("EC") ? "EC" : "RSA")));
        }
        return algo;
    }

    private void readPublicKey(FileTraceEncryptKey fileTraceEncryptKey, FileTraceEncryptConfig config) throws UtilsException, SecurityException {
        byte[] key;
        String algo = this.readPublicKeyAlgo(config);
        PublicKeyStore publicKeyStore = null;
        if (config.getKeyInline() != null && StringUtils.isNotEmpty((String)config.getKeyInline())) {
            key = this.readKeyInline(config);
            publicKeyStore = GestoreKeystoreCache.getPublicKeyStore((RequestInfo)this.requestInfo, (byte[])key, (String)algo);
        } else if (config.isKeyBase64Encoding() || config.isKeyHexEncoding()) {
            key = this.readEncodedKeyFromPath(config);
            publicKeyStore = GestoreKeystoreCache.getPublicKeyStore((RequestInfo)this.requestInfo, (byte[])key, (String)algo);
        } else {
            publicKeyStore = GestoreKeystoreCache.getPublicKeyStore((RequestInfo)this.requestInfo, (String)config.getKeyPath(), (String)algo);
        }
        if (publicKeyStore == null) {
            throw new UtilsException(this.getKeyError(config));
        }
        fileTraceEncryptKey.key = publicKeyStore.getPublicKey();
        if (config.isJoseEngine()) {
            if (config.getKeyId() != null && StringUtils.isNotEmpty((String)config.getKeyId())) {
                config.setKeyAlias(config.getKeyId());
            } else {
                config.generateKeyAlias();
            }
            JWK jwk = new JWK(publicKeyStore.getPublicKey(), config.getKeyAlias());
            JWKSet jwkSet = new JWKSet();
            jwkSet.addJwk(jwk);
            jwkSet.getJson();
            fileTraceEncryptKey.jsonWebKeys = jwkSet.getJsonWebKeys();
        }
    }

    private void readSecretKey(FileTraceEncryptKey fileTraceEncryptKey, FileTraceEncryptConfig config) throws UtilsException, SecurityException {
        String algo = config.isJoseEngine() ? "AES" : config.getKeyAlgorithm();
        SecretKeyStore secretKeyStore = null;
        if (config.getKeyInline() != null && StringUtils.isNotEmpty((String)config.getKeyInline())) {
            byte[] key = this.readKeyInline(config);
            secretKeyStore = GestoreKeystoreCache.getSecretKeyStore((RequestInfo)this.requestInfo, (byte[])key, (String)algo, (BYOKRequestParams)this.getBYOKRequestParams(config));
        } else if (config.isKeyBase64Encoding() || config.isKeyHexEncoding()) {
            byte[] key = this.readEncodedKeyFromPath(config);
            secretKeyStore = GestoreKeystoreCache.getSecretKeyStore((RequestInfo)this.requestInfo, (byte[])key, (String)algo, (BYOKRequestParams)this.getBYOKRequestParams(config));
        } else {
            secretKeyStore = GestoreKeystoreCache.getSecretKeyStore((RequestInfo)this.requestInfo, (String)config.getKeyPath(), (String)algo, (BYOKRequestParams)this.getBYOKRequestParams(config));
        }
        this.initSecretKey(secretKeyStore, fileTraceEncryptKey, config);
    }

    private void readPasswordKeyDerivation(FileTraceEncryptKey fileTraceEncryptKey, FileTraceEncryptConfig config) throws UtilsException, SecurityException {
        fileTraceEncryptKey.pwdKeyDerivationConfig = new SecretPasswordKeyDerivationConfig(config.getPassword(), config.getPasswordType(), config.getPasswordIteration());
        if (!config.isOpenSSLEngine()) {
            SecretKeyStore secretKeyStore = GestoreKeystoreCache.getSecretKeyStore((RequestInfo)this.requestInfo, (SecretPasswordKeyDerivationConfig)fileTraceEncryptKey.pwdKeyDerivationConfig, (BYOKRequestParams)this.getBYOKRequestParams(config));
            this.initSecretKey(secretKeyStore, fileTraceEncryptKey, config);
        }
    }

    private void initSecretKey(SecretKeyStore secretKeyStore, FileTraceEncryptKey fileTraceEncryptKey, FileTraceEncryptConfig config) throws UtilsException, SecurityException {
        if (secretKeyStore == null) {
            throw new UtilsException(this.getKeyError(config));
        }
        fileTraceEncryptKey.key = secretKeyStore.getSecretKey();
        fileTraceEncryptKey.iv = secretKeyStore.getIv();
        fileTraceEncryptKey.salt = secretKeyStore.getSalt();
        fileTraceEncryptKey.secret = true;
        if (config.isJoseEngine()) {
            if (config.getKeyId() != null && StringUtils.isNotEmpty((String)config.getKeyId())) {
                config.setKeyAlias(config.getKeyId());
            } else {
                config.generateKeyAlias();
            }
            JWK jwk = new JWK(secretKeyStore.getSecretKey(), config.getKeyAlias(), KeyUse.ENCRYPTION);
            JWKSet jwkSet = new JWKSet();
            jwkSet.addJwk(jwk);
            jwkSet.getJson();
            fileTraceEncryptKey.jsonWebKeys = jwkSet.getJsonWebKeys();
        }
    }

    private String encJava(FileTraceEncryptKey fileTraceEncryptKey, FileTraceEncryptConfig config, String value) throws UtilsException {
        Encrypt encrypt = null;
        encrypt = fileTraceEncryptKey.secret && fileTraceEncryptKey.iv != null ? new Encrypt(fileTraceEncryptKey.key, fileTraceEncryptKey.iv) : new Encrypt(fileTraceEncryptKey.key);
        if (fileTraceEncryptKey.secret && fileTraceEncryptKey.iv == null) {
            encrypt.initIV(config.getContentAlgorithm());
        }
        byte[] encrypted = null;
        try {
            encrypted = encrypt.encrypt(value.getBytes(), config.getContentAlgorithm());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        if (fileTraceEncryptKey.secret && fileTraceEncryptKey.salt != null) {
            encrypted = EncryptOpenSSLPass.formatOutput((byte[])fileTraceEncryptKey.salt, (byte[])encrypted);
        }
        String en = null;
        if (config.isBase64Encoding()) {
            en = Base64Utilities.encodeAsString((byte[])encrypted);
        } else if (config.isHexEncoding()) {
            en = HexBinaryUtilities.encodeAsString((byte[])encrypted);
        } else {
            throw new UtilsException("Java algorithm undefined in keystore [" + config.getKeystoreType().getNome() + "] '" + config.getKeystorePath() + "'");
        }
        if (fileTraceEncryptKey.secret) {
            if (config.isBase64Encoding()) {
                return encrypt.getIVBase64AsString() + JAVA_SEPARATOR + en;
            }
            return encrypt.getIVHexBinaryAsString() + JAVA_SEPARATOR + en;
        }
        return en;
    }

    private String encJavaKeyWrap(FileTraceEncryptKey fileTraceEncryptKey, FileTraceEncryptConfig config, String value) throws UtilsException {
        EncryptWrapKey encrypt = null;
        encrypt = fileTraceEncryptKey.ks != null ? new EncryptWrapKey(fileTraceEncryptKey.ks, config.getKeyAlias()) : new EncryptWrapKey(fileTraceEncryptKey.key);
        byte[] encrypted = null;
        try {
            encrypted = encrypt.encrypt(value.getBytes(), config.getKeyAlgorithm(), config.getContentAlgorithm());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        String en = null;
        if (config.isBase64Encoding()) {
            en = Base64Utilities.encodeAsString((byte[])encrypted);
        } else if (config.isHexEncoding()) {
            en = HexBinaryUtilities.encodeAsString((byte[])encrypted);
        } else {
            throw new UtilsException("Java algorithm undefined in keystore [" + config.getKeystoreType().getNome() + "] '" + config.getKeystorePath() + "'");
        }
        if (config.isBase64Encoding()) {
            return encrypt.getWrappedKeyBase64() + JAVA_SEPARATOR + encrypt.getIVBase64AsString() + JAVA_SEPARATOR + en;
        }
        return encrypt.getWrappedKeyHexBinary() + JAVA_SEPARATOR + encrypt.getIVHexBinaryAsString() + JAVA_SEPARATOR + en;
    }

    private String encJose(FileTraceEncryptKey fileTraceEncryptKey, FileTraceEncryptConfig config, String value) throws UtilsException {
        JsonEncrypt encrypt = null;
        JwtHeaders jwtHeaders = null;
        JWEOptions options = new JWEOptions(JOSESerialization.COMPACT);
        if (fileTraceEncryptKey.ks != null) {
            jwtHeaders = config.getJwtHeaders(fileTraceEncryptKey.ks);
            encrypt = fileTraceEncryptKey.secret ? new JsonEncrypt(fileTraceEncryptKey.ks, config.getKeyAlias(), config.getKeyPassword(), config.getKeyAlgorithm(), config.getContentAlgorithm(), jwtHeaders, options) : new JsonEncrypt(fileTraceEncryptKey.ks, config.getKeyAlias(), config.getKeyAlgorithm(), config.getContentAlgorithm(), jwtHeaders, options);
        } else {
            jwtHeaders = config.getJwtHeaders(fileTraceEncryptKey.jsonWebKeys);
            encrypt = new JsonEncrypt(fileTraceEncryptKey.jsonWebKeys, fileTraceEncryptKey.secret, config.getKeyAlias(), config.getKeyAlgorithm(), config.getContentAlgorithm(), jwtHeaders, options);
        }
        return encrypt.encrypt(value);
    }

    private String encOpenSSL(FileTraceEncryptKey fileTraceEncryptKey, FileTraceEncryptConfig config, String value) throws UtilsException {
        if (BYOKCostanti.isOpenSSLPBKDF2PasswordDerivationKeyMode((String)fileTraceEncryptKey.pwdKeyDerivationConfig.getPasswordEncryptionMode())) {
            return this.encOpenSSLPBKDF2(fileTraceEncryptKey, config, value);
        }
        return this.encOpenSSLStandard(fileTraceEncryptKey, config, value);
    }

    private String encOpenSSLStandard(FileTraceEncryptKey fileTraceEncryptKey, FileTraceEncryptConfig config, String value) throws UtilsException {
        SecretPasswordKeyDerivationConfig passwordKeyDerivationConfig = fileTraceEncryptKey.pwdKeyDerivationConfig;
        EncryptOpenSSLPass encrypt = new EncryptOpenSSLPass(passwordKeyDerivationConfig.getPassword(), OpenSSLEncryptionMode.toMode((String)passwordKeyDerivationConfig.getPasswordEncryptionMode()));
        if (config.isBase64Encoding()) {
            return encrypt.encryptBase64AsString(value.getBytes());
        }
        if (config.isHexEncoding()) {
            return encrypt.encryptHexBinaryAsString(value.getBytes());
        }
        throw new UtilsException("Encoding mode undefined");
    }

    private String encOpenSSLPBKDF2(FileTraceEncryptKey fileTraceEncryptKey, FileTraceEncryptConfig config, String value) throws UtilsException {
        SecretPasswordKeyDerivationConfig passwordKeyDerivationConfig = fileTraceEncryptKey.pwdKeyDerivationConfig;
        EncryptOpenSSLPassPBKDF2 encrypt = new EncryptOpenSSLPassPBKDF2(passwordKeyDerivationConfig.getPassword(), passwordKeyDerivationConfig.getPasswordIterator(), OpenSSLEncryptionMode.toMode((String)passwordKeyDerivationConfig.getPasswordEncryptionMode()));
        if (config.isBase64Encoding()) {
            return encrypt.encryptBase64AsString(value.getBytes());
        }
        if (config.isHexEncoding()) {
            return encrypt.encryptHexBinaryAsString(value.getBytes());
        }
        throw new UtilsException("Encoding mode undefined");
    }
}

