/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.filetrace;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.byok.BYOKCostanti;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.openspcoop2.utils.security.JwtHeaders;

public class FileTraceEncryptConfig {
    private String name;
    private String encryptionEngine;
    private KeystoreType keystoreType;
    private String keystoreHsmType;
    private String keystorePath;
    private String keystorePassword;
    private String keyInline;
    private String keyPath;
    private String keyEncoding;
    private String keyAlgorithm;
    private String keyAlias;
    private String keyPassword;
    private String keyId;
    private boolean keyWrap = false;
    private String pw;
    private String pwType;
    private Integer pwIteration;
    private String contentAlgorithm;
    private String encoding;
    private boolean joseIncludeCert;
    private boolean joseIncludePublicKey;
    private boolean joseIncludeKeyId;
    private boolean joseIncludeCertSha1;
    private boolean joseIncludeCertSha256;
    private String kmsId;
    private Map<String, String> kmsInput;
    private static final String ENCRYPTIONT_ENGINE_JAVA = "java";
    private static final String ENCRYPTIONT_ENGINE_JOSE = "jose";
    private static final String ENCRYPTIONT_ENGINE_OPENSSL = "openssl";
    private static final String ENCODING_BASE64 = "base64";
    private static final String ENCODING_HEX = "hex";
    private static final String PREFIX_ENCRYPT = "encrypt.";
    private static final String DEBUG_PREFIX = "Property 'encrypt.";
    private static final String UNDEFINED = " undefined";
    private static final String INVALID = " invalid";
    private static final String MODE = ".mode";
    private static final String KEYSTORE_TYPE = ".keystore.type";
    private static final String KEYSTORE_PATH = ".keystore.path";
    private static final String KEYSTORE_PASSWORD = ".keystore.password";
    private static final String KEY_PATH = ".key.path";
    private static final String KEY_INLINE = ".key.inline";
    private static final String KEY_ENCODING = ".key.encoding";
    private static final String KEY_ALGORITHM = ".key.algorithm";
    private static final String KEY_ALIAS = ".key.alias";
    private static final String KEY_PASSWORD = ".key.password";
    private static final String KEY_ID = ".key.id";
    private static final String KEY_WRAP = ".key.wrap";
    private static final String PW_VALUE = ".password";
    private static final String PW_TYPE = ".password.type";
    public static final String PW_TYPE_OPENSSL_AES_256_CBC = "openssl-aes-256-cbc";
    public static final String PW_TYPE_OPENSSL_PBKDF2_AES_128_CBC = "openssl-pbkdf2-aes-128-cbc";
    public static final String PW_TYPE_OPENSSL_PBKDF2_AES_192_CBC = "openssl-pbkdf2-aes-192-cbc";
    public static final String PW_TYPE_OPENSSL_PBKDF2_AES_256_CBC = "openssl-pbkdf2-aes-256-cbc";
    private static final String PW_TYPE_DEFAULT = "openssl-pbkdf2-aes-256-cbc";
    private static final String PW_ITERATION = ".password.iter";
    private static final String CONTENT_ALGORITHM = ".algorithm";
    private static final String ENCODING_OUTPUT = ".encoding";
    private static final String JOSE_INCLUDE_CERT = ".include.cert";
    private static final String JOSE_INCLUDE_PUBLIC_KEY = ".include.public.key";
    private static final String JOSE_INCLUDE_KEY_ID = ".include.key.id";
    private static final String JOSE_INCLUDE_CERT_SHA1 = ".include.cert.sha1";
    private static final String JOSE_INCLUDE_CERT_SHA256 = ".include.cert.sha256";
    private static final String KMS = ".kms";
    private static final String KMS_PARAM = ".kms.param.";
    private static final String KSM_DEPRECATED = ".ksm";
    private static final String KSM_PARAM_DEPRECATED = ".ksm.param.";

    public static List<String> getLocalPasswordTypes() {
        return BYOKCostanti.getLocalPasswordTypes();
    }

    public static boolean isOpenSSLPasswordDerivationKeyMode(String mode) {
        return BYOKCostanti.isOpenSSLPasswordDerivationKeyMode((String)mode);
    }

    public static boolean isOpenSSLPBKDF2PasswordDerivationKeyMode(String mode) {
        return BYOKCostanti.isOpenSSLPBKDF2PasswordDerivationKeyMode((String)mode);
    }

    public static Map<String, FileTraceEncryptConfig> parse(PropertiesReader reader) throws UtilsException {
        Properties propertiesMap = reader.readProperties_convertEnvProperties(PREFIX_ENCRYPT);
        HashMap<String, FileTraceEncryptConfig> result = new HashMap<String, FileTraceEncryptConfig>();
        ArrayList<String> keys = new ArrayList<String>();
        if (propertiesMap != null && !propertiesMap.isEmpty()) {
            for (Object s : propertiesMap.keySet()) {
                String key = (String)s;
                if (!key.endsWith(MODE) || key.length() <= MODE.length()) continue;
                String keyMode = key.substring(0, key.length() - MODE.length());
                if (keys.contains(keyMode)) {
                    throw new UtilsException(DEBUG_PREFIX + key + "' already defined");
                }
                keys.add(keyMode);
            }
        }
        FileTraceEncryptConfig.parse(result, propertiesMap, keys);
        return result;
    }

    private static void parse(Map<String, FileTraceEncryptConfig> result, Properties propertiesMap, List<String> keys) throws UtilsException {
        if (propertiesMap != null && !keys.isEmpty()) {
            for (String encMode : keys) {
                FileTraceEncryptConfig c = new FileTraceEncryptConfig();
                c.name = encMode;
                FileTraceEncryptConfig.parseEngine(encMode, propertiesMap, c);
                FileTraceEncryptConfig.parseKestore(encMode, propertiesMap, c);
                FileTraceEncryptConfig.parseKms(encMode, propertiesMap, c);
                result.put(encMode, c);
            }
        }
    }

    private static void parseEngine(String encMode, Properties propertiesMap, FileTraceEncryptConfig c) throws UtilsException {
        String keyWrapPName;
        String keyWrap;
        String modePName = encMode + MODE;
        c.encryptionEngine = propertiesMap.getProperty(modePName);
        if (!(ENCRYPTIONT_ENGINE_JAVA.equals(c.encryptionEngine) || ENCRYPTIONT_ENGINE_JOSE.equals(c.encryptionEngine) || ENCRYPTIONT_ENGINE_OPENSSL.equals(c.encryptionEngine))) {
            throw new UtilsException(DEBUG_PREFIX + modePName + "' with unsupported engine mode '" + c.encryptionEngine + "'");
        }
        String algoPName = encMode + CONTENT_ALGORITHM;
        String algo = propertiesMap.getProperty(algoPName);
        if (algo == null || StringUtils.isEmpty((String)algo.trim())) {
            if (!ENCRYPTIONT_ENGINE_OPENSSL.equals(c.encryptionEngine)) {
                throw new UtilsException(DEBUG_PREFIX + algoPName + "' undefined");
            }
        } else {
            c.contentAlgorithm = algo.trim();
        }
        if (ENCRYPTIONT_ENGINE_JAVA.equals(c.encryptionEngine) || ENCRYPTIONT_ENGINE_OPENSSL.equals(c.encryptionEngine)) {
            FileTraceEncryptConfig.parseEncoding(encMode, propertiesMap, c);
        }
        if (ENCRYPTIONT_ENGINE_JAVA.equals(c.encryptionEngine) && (keyWrap = propertiesMap.getProperty(keyWrapPName = encMode + KEY_WRAP)) != null && StringUtils.isNotEmpty((String)keyWrap.trim())) {
            c.keyWrap = "true".equalsIgnoreCase(keyWrap);
        }
        if (ENCRYPTIONT_ENGINE_JOSE.equals(c.encryptionEngine)) {
            FileTraceEncryptConfig.parseEngineJose(encMode, propertiesMap, c);
        }
    }

    private static void parseEncoding(String encMode, Properties propertiesMap, FileTraceEncryptConfig c) throws UtilsException {
        String encodingPName = encMode + ENCODING_OUTPUT;
        String encoding = propertiesMap.getProperty(encodingPName);
        if (encoding == null || StringUtils.isEmpty((String)encoding.trim())) {
            throw new UtilsException(DEBUG_PREFIX + encodingPName + "' undefined");
        }
        c.encoding = encoding.trim();
        if (!ENCODING_BASE64.equals(c.encoding) && !ENCODING_HEX.equals(c.encoding)) {
            throw new UtilsException(DEBUG_PREFIX + encodingPName + "' with unsupported encryption mode '" + c.encoding + "'");
        }
    }

    private static void parseEngineJose(String encMode, Properties propertiesMap, FileTraceEncryptConfig c) {
        c.joseIncludeCert = FileTraceEncryptConfig.parseEngineJoseProperty(encMode + JOSE_INCLUDE_CERT, propertiesMap);
        c.joseIncludePublicKey = FileTraceEncryptConfig.parseEngineJoseProperty(encMode + JOSE_INCLUDE_PUBLIC_KEY, propertiesMap);
        c.joseIncludeKeyId = FileTraceEncryptConfig.parseEngineJoseProperty(encMode + JOSE_INCLUDE_KEY_ID, propertiesMap);
        c.joseIncludeCertSha1 = FileTraceEncryptConfig.parseEngineJoseProperty(encMode + JOSE_INCLUDE_CERT_SHA1, propertiesMap);
        c.joseIncludeCertSha256 = FileTraceEncryptConfig.parseEngineJoseProperty(encMode + JOSE_INCLUDE_CERT_SHA256, propertiesMap);
        String keyIdPName = encMode + KEY_ID;
        String keyId = propertiesMap.getProperty(keyIdPName);
        if (keyId != null) {
            c.keyId = keyId.trim();
        }
    }

    private static boolean parseEngineJoseProperty(String pName, Properties propertiesMap) {
        String v = propertiesMap.getProperty(pName);
        return "true".equalsIgnoreCase(v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseKestore(String encMode, Properties propertiesMap, FileTraceEncryptConfig c) throws UtilsException {
        String keystoreTypePName = encMode + KEYSTORE_TYPE;
        String keystoreType = propertiesMap.getProperty(keystoreTypePName);
        if (keystoreType == null || StringUtils.isEmpty((String)keystoreType.trim())) {
            throw new UtilsException(DEBUG_PREFIX + keystoreTypePName + "' undefined");
        }
        keystoreType = keystoreType.trim();
        c.keystoreType = KeystoreType.toEnumFromName((String)keystoreType);
        if (c.keystoreType == null) {
            if (keystoreType == null) throw new UtilsException(DEBUG_PREFIX + keystoreTypePName + "' undefined");
            HSMManager hsmManager = HSMManager.getInstance();
            if (!hsmManager.existsKeystoreType(keystoreType)) throw new UtilsException(DEBUG_PREFIX + keystoreTypePName + "' with unsupported value '" + keystoreType + "'");
            c.keystoreType = KeystoreType.PKCS11;
            c.keystoreHsmType = keystoreType;
        }
        FileTraceEncryptConfig.parseKestore(encMode, propertiesMap, c, keystoreTypePName, keystoreType);
    }

    private static void parseKestore(String encMode, Properties propertiesMap, FileTraceEncryptConfig c, String keystoreTypePName, String keystoreType) throws UtilsException {
        String errorUnsupported = "' unsupported with " + encMode + MODE;
        switch (c.keystoreType) {
            case JKS: 
            case PKCS12: 
            case PKCS11: 
            case JWK_SET: 
            case JCEKS: {
                if (c.isOpenSSLEngine()) {
                    throw new UtilsException(DEBUG_PREFIX + keystoreTypePName + "' '" + keystoreType + errorUnsupported + " 'openssl'");
                }
                FileTraceEncryptConfig.parseKeystore(encMode, propertiesMap, c);
                break;
            }
            case PUBLIC_KEY: 
            case SYMMETRIC_KEY: {
                if (c.isOpenSSLEngine()) {
                    throw new UtilsException(DEBUG_PREFIX + keystoreTypePName + "' '" + keystoreType + errorUnsupported + " 'openssl'");
                }
                FileTraceEncryptConfig.parseKey(encMode, propertiesMap, c);
                break;
            }
            case PASSWORD_KEY_DERIVATION: {
                if (c.isJoseEngine()) {
                    throw new UtilsException(DEBUG_PREFIX + keystoreTypePName + "' '" + keystoreType + errorUnsupported + " 'jose'");
                }
                FileTraceEncryptConfig.parsePassword(encMode, propertiesMap, c);
                break;
            }
            default: {
                throw new UtilsException(DEBUG_PREFIX + encMode + ".keystore.type' with unsupported value '" + keystoreType + "'");
            }
        }
    }

    private static void parseKeystore(String encMode, Properties propertiesMap, FileTraceEncryptConfig c) throws UtilsException {
        if (KeystoreType.PKCS11.equals((Object)c.getKeystoreType())) {
            c.keystorePath = "-";
        } else {
            String keystorePathPName = encMode + KEYSTORE_PATH;
            String keystorePath = propertiesMap.getProperty(keystorePathPName);
            if (keystorePath == null || StringUtils.isEmpty((String)keystorePath.trim())) {
                throw new UtilsException(DEBUG_PREFIX + keystorePathPName + "' undefined");
            }
            c.keystorePath = keystorePath.trim();
        }
        if (KeystoreType.PKCS11.equals((Object)c.getKeystoreType())) {
            c.keystorePassword = "-";
        } else if (!KeystoreType.JWK_SET.equals((Object)c.getKeystoreType())) {
            String keystorePasswordPName = encMode + KEYSTORE_PASSWORD;
            String keystorePassword = propertiesMap.getProperty(keystorePasswordPName);
            if (keystorePassword == null) {
                throw new UtilsException(DEBUG_PREFIX + keystorePasswordPName + "' undefined");
            }
            c.keystorePassword = keystorePassword.trim();
        }
        FileTraceEncryptConfig.parseKeystoreKey(encMode, propertiesMap, c);
    }

    private static void parseKeystoreKey(String encMode, Properties propertiesMap, FileTraceEncryptConfig c) throws UtilsException {
        String keyAlgoPName;
        String keyAlgo;
        String keyPasswordPName;
        String keyPassword;
        String keyAliasPName = encMode + KEY_ALIAS;
        String keyAlias = propertiesMap.getProperty(keyAliasPName);
        if (keyAlias == null || StringUtils.isEmpty((String)keyAlias.trim())) {
            throw new UtilsException(DEBUG_PREFIX + keyAliasPName + "' undefined");
        }
        c.keyAlias = keyAlias.trim();
        if (KeystoreType.JCEKS.equals((Object)c.getKeystoreType()) && (keyPassword = propertiesMap.getProperty(keyPasswordPName = encMode + KEY_PASSWORD)) != null) {
            c.keyPassword = keyPassword.trim();
        }
        if ((keyAlgo = propertiesMap.getProperty(keyAlgoPName = encMode + KEY_ALGORITHM)) == null || StringUtils.isEmpty((String)keyAlgo.trim())) {
            throw new UtilsException(DEBUG_PREFIX + keyAlgoPName + "' undefined");
        }
        c.keyAlgorithm = keyAlgo.trim();
    }

    private static void parseKey(String encMode, Properties propertiesMap, FileTraceEncryptConfig c) throws UtilsException {
        String keyAlgoPName;
        String keyAlgo;
        String keyInLinePName = encMode + KEY_INLINE;
        String keyInLine = propertiesMap.getProperty(keyInLinePName);
        if (keyInLine != null && StringUtils.isNotEmpty((String)keyInLine.trim())) {
            c.keyInline = keyInLine.trim();
        } else {
            String keyPathPName = encMode + KEY_PATH;
            String keyPath = propertiesMap.getProperty(keyPathPName);
            if (keyPath == null || StringUtils.isEmpty((String)keyPath.trim())) {
                throw new UtilsException(DEBUG_PREFIX + keyPathPName + "' undefined");
            }
            c.keyPath = keyPath.trim();
        }
        String keyEncodingPName = encMode + KEY_ENCODING;
        String keyEncoding = propertiesMap.getProperty(keyEncodingPName);
        if (keyEncoding != null && StringUtils.isNotEmpty((String)keyEncoding.trim())) {
            c.keyEncoding = keyEncoding.trim();
            if (!ENCODING_BASE64.equals(c.keyEncoding) && !ENCODING_HEX.equals(c.keyEncoding)) {
                throw new UtilsException(DEBUG_PREFIX + keyEncodingPName + "' with unsupported encryption mode '" + c.keyEncoding + "'");
            }
        }
        if ((keyAlgo = propertiesMap.getProperty(keyAlgoPName = encMode + KEY_ALGORITHM)) == null || StringUtils.isEmpty((String)keyAlgo.trim())) {
            throw new UtilsException(DEBUG_PREFIX + keyAlgoPName + "' undefined");
        }
        c.keyAlgorithm = keyAlgo.trim();
    }

    private static void parsePassword(String encMode, Properties propertiesMap, FileTraceEncryptConfig c) throws UtilsException {
        String passwordPName = encMode + PW_VALUE;
        String password = propertiesMap.getProperty(passwordPName);
        if (password == null || StringUtils.isEmpty((String)password.trim())) {
            throw new UtilsException(DEBUG_PREFIX + passwordPName + "' undefined");
        }
        c.pw = password.trim();
        String passwordTypePName = encMode + PW_TYPE;
        String passwordType = propertiesMap.getProperty(passwordTypePName);
        if (passwordType == null || StringUtils.isEmpty((String)passwordType.trim())) {
            c.pwType = "openssl-pbkdf2-aes-256-cbc";
        } else {
            c.pwType = passwordType.trim();
            if (!FileTraceEncryptConfig.getLocalPasswordTypes().contains(c.pwType)) {
                throw new UtilsException(DEBUG_PREFIX + passwordTypePName + "' invalid");
            }
        }
        String passwordIterationPName = encMode + PW_ITERATION;
        String passwordIteration = propertiesMap.getProperty(passwordIterationPName);
        if (passwordIteration != null && StringUtils.isNotEmpty((String)passwordIteration.trim())) {
            try {
                c.pwIteration = Integer.valueOf(passwordIteration);
            }
            catch (Exception e) {
                throw new UtilsException(DEBUG_PREFIX + passwordIterationPName + "' invalid: " + e.getMessage());
            }
        }
    }

    private static void parseKms(String encMode, Properties propertiesMap, FileTraceEncryptConfig c) {
        String prefixKMSparams = KMS_PARAM;
        String kmsPName = encMode + KMS;
        String kms = propertiesMap.getProperty(kmsPName);
        if (kms != null && StringUtils.isNotEmpty((String)kms.trim())) {
            c.kmsId = kms.trim();
        } else {
            kmsPName = encMode + KSM_DEPRECATED;
            kms = propertiesMap.getProperty(kmsPName);
            if (kms != null && StringUtils.isNotEmpty((String)kms.trim())) {
                c.kmsId = kms.trim();
                prefixKMSparams = KSM_PARAM_DEPRECATED;
            }
        }
        ArrayList<String> inputParams = new ArrayList<String>();
        FileTraceEncryptConfig.initKmsParamsInput(encMode, propertiesMap, inputParams, prefixKMSparams);
        if (!inputParams.isEmpty()) {
            c.kmsInput = new HashMap<String, String>();
            for (String inputId : inputParams) {
                String value = propertiesMap.getProperty(encMode + prefixKMSparams + inputId);
                if (value == null) continue;
                c.kmsInput.put(inputId, value.trim());
            }
        }
    }

    private static void initKmsParamsInput(String encMode, Properties propertiesMap, List<String> idKeystore, String prefixKMSparams) {
        String kmsParam = encMode + prefixKMSparams;
        Enumeration<Object> enKeys = propertiesMap.keys();
        while (enKeys.hasMoreElements()) {
            Object object = enKeys.nextElement();
            if (!(object instanceof String)) continue;
            String key = (String)object;
            FileTraceEncryptConfig.initKmsParamsInput(key, kmsParam, idKeystore);
        }
    }

    private static void initKmsParamsInput(String key, String prefix, List<String> idKeystore) {
        String tmp;
        if (key.startsWith(prefix) && key.length() > prefix.length() && (tmp = key.substring(prefix.length())) != null && StringUtils.isNotEmpty((String)tmp) && !idKeystore.contains(tmp)) {
            idKeystore.add(tmp);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isJavaEngine() {
        return ENCRYPTIONT_ENGINE_JAVA.equals(this.encryptionEngine);
    }

    public boolean isJoseEngine() {
        return ENCRYPTIONT_ENGINE_JOSE.equals(this.encryptionEngine);
    }

    public boolean isOpenSSLEngine() {
        return ENCRYPTIONT_ENGINE_OPENSSL.equals(this.encryptionEngine);
    }

    public KeystoreType getKeystoreType() {
        return this.keystoreType;
    }

    public String getKeystoreHsmType() {
        return this.keystoreHsmType;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeyInline() {
        return this.keyInline;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public boolean isKeyBase64Encoding() {
        return ENCODING_BASE64.equals(this.keyEncoding);
    }

    public boolean isKeyHexEncoding() {
        return ENCODING_HEX.equals(this.keyEncoding);
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public void generateKeyAlias() {
        this.keyAlias = UUID.randomUUID().toString();
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public boolean isKeyWrap() {
        return this.keyWrap;
    }

    public String getPassword() {
        return this.pw;
    }

    public String getPasswordType() {
        return this.pwType;
    }

    public Integer getPasswordIteration() {
        return this.pwIteration;
    }

    public String getContentAlgorithm() {
        return this.contentAlgorithm;
    }

    public boolean isBase64Encoding() {
        return ENCODING_BASE64.equals(this.encoding);
    }

    public boolean isHexEncoding() {
        return ENCODING_HEX.equals(this.encoding);
    }

    public JwtHeaders getJwtHeaders(KeyStore ks) throws UtilsException {
        return this.getJwtHeaders(ks, null);
    }

    public JwtHeaders getJwtHeaders(JsonWebKeys jsonWebKeys) throws UtilsException {
        return this.getJwtHeaders(null, jsonWebKeys);
    }

    private JwtHeaders getJwtHeaders(KeyStore ks, JsonWebKeys jsonWebKeys) throws UtilsException {
        Certificate cert;
        JwtHeaders jwtHeaders = new JwtHeaders();
        if (this.joseIncludeKeyId) {
            jwtHeaders.setKid(this.keyAlias);
        }
        if (this.joseIncludeCert) {
            jwtHeaders.setAddX5C(true);
        }
        if (this.joseIncludeCertSha1) {
            jwtHeaders.setX509IncludeCertSha1(true);
        }
        if (this.joseIncludeCertSha256) {
            jwtHeaders.setX509IncludeCertSha256(true);
        }
        if (ks != null && (this.joseIncludeCert || this.joseIncludeCertSha1 || this.joseIncludeCertSha256) && (cert = ks.getCertificate(this.keyAlias)) instanceof X509Certificate) {
            jwtHeaders.addX509cert((X509Certificate)cert);
        }
        if (jsonWebKeys != null && this.joseIncludePublicKey) {
            jwtHeaders.setJwKey(jsonWebKeys, this.keyAlias);
        }
        return jwtHeaders;
    }

    public String getKmsId() {
        return this.kmsId;
    }

    public Map<String, String> getKmsInput() {
        return this.kmsInput;
    }
}

