/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.filetrace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.core.transazioni.utils.CredenzialiMittente;
import org.openspcoop2.monitor.sdk.transaction.FaseTracciamento;
import org.openspcoop2.pdd.core.token.InformazioniNegoziazioneToken;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.attribute_authority.InformazioniAttributi;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.logger.filetrace.FileTraceConfig;
import org.openspcoop2.pdd.logger.filetrace.FileTraceEncrypt;
import org.openspcoop2.pdd.logger.filetrace.FileTraceEncryptConfig;
import org.openspcoop2.pdd.logger.filetrace.Info;
import org.openspcoop2.pdd.logger.filetrace.InfoConfigurazione;
import org.openspcoop2.pdd.logger.filetrace.Topic;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.DynamicStringReplace;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class FileTraceManager {
    private Logger log;
    private FileTraceConfig config;
    private Map<String, Object> dynamicMap = new HashMap<String, Object>();
    private Info t;
    private Info tBase64;

    public FileTraceManager(Logger log, FileTraceConfig config) {
        this.config = config;
        this.log = log;
    }

    public void buildTransazioneInfo(IProtocolFactory<?> protocolFactory, Transazione transazioneDTO, Transaction transaction, InformazioniToken informazioniToken, InformazioniAttributi informazioniAttributi, InformazioniNegoziazioneToken informazioniNegoziazioneToken, SecurityToken securityToken, Context context, Map<String, List<String>> headerInUscita, FaseTracciamento trackingPhase) throws ProtocolException {
        Messaggio richiestaIngresso = null;
        Messaggio richiestaUscita = null;
        Messaggio rispostaIngresso = null;
        Messaggio rispostaUscita = null;
        block6: for (int i = 0; i < transaction.sizeMessaggi(); ++i) {
            Messaggio messaggio = transaction.getMessaggio(i);
            TipoMessaggio tipoMessaggio = messaggio.getTipoMessaggio();
            switch (tipoMessaggio) {
                case RICHIESTA_INGRESSO_DUMP_BINARIO: {
                    richiestaIngresso = messaggio;
                    continue block6;
                }
                case RICHIESTA_USCITA_DUMP_BINARIO: {
                    richiestaUscita = messaggio;
                    continue block6;
                }
                case RISPOSTA_INGRESSO_DUMP_BINARIO: {
                    rispostaIngresso = messaggio;
                    continue block6;
                }
                case RISPOSTA_USCITA_DUMP_BINARIO: {
                    rispostaUscita = messaggio;
                    continue block6;
                }
            }
        }
        Map<String, List<String>> headerRichiestaUscita = null;
        Map<String, List<String>> headerRispostaUscita = null;
        if (FaseTracciamento.OUT_REQUEST.equals((Object)trackingPhase)) {
            headerRichiestaUscita = headerInUscita;
        } else if (FaseTracciamento.OUT_RESPONSE.equals((Object)trackingPhase)) {
            headerRispostaUscita = headerInUscita;
        }
        CredenzialiMittente credenzialiMittente = transaction.getCredenzialiMittente();
        InfoConfigurazione infoConfigurazione = new InfoConfigurazione(transazioneDTO, context, credenzialiMittente);
        boolean base64 = true;
        this.t = new Info(this.log, protocolFactory, transazioneDTO, credenzialiMittente, informazioniToken, informazioniAttributi, informazioniNegoziazioneToken, securityToken, transaction.getTracciaRichiesta(), transaction.getTracciaRisposta(), transaction.getMsgDiagnostici(), richiestaIngresso, richiestaUscita, headerRichiestaUscita, rispostaIngresso, rispostaUscita, headerRispostaUscita, infoConfigurazione, this.config, trackingPhase, !base64);
        this.tBase64 = new Info(this.log, protocolFactory, transazioneDTO, credenzialiMittente, informazioniToken, informazioniAttributi, informazioniNegoziazioneToken, securityToken, transaction.getTracciaRichiesta(), transaction.getTracciaRisposta(), transaction.getMsgDiagnostici(), richiestaIngresso, richiestaUscita, headerRichiestaUscita, rispostaIngresso, rispostaUscita, headerRispostaUscita, infoConfigurazione, this.config, trackingPhase, base64);
        this.dynamicMap.put("log", this.t);
        this.dynamicMap.put("logBase64", this.tBase64);
    }

    public void cleanResourcesForOnlyFileTrace(Transaction transaction) {
        List<TipoMessaggio> tipiDaEliminareHeaders = transaction.getMessaggiHeadersOnlyLogFileTrace();
        List<TipoMessaggio> tipiDaEliminareBody = transaction.getMessaggiBodyOnlyLogFileTrace();
        ArrayList<TipoMessaggio> messaggiDaEliminare = new ArrayList<TipoMessaggio>();
        for (int i = 0; i < transaction.sizeMessaggi(); ++i) {
            Messaggio messaggio = transaction.getMessaggio(i);
            TipoMessaggio tipoMessaggio = messaggio.getTipoMessaggio();
            boolean onlyLogFileTraceHeaders = false;
            if (tipiDaEliminareHeaders != null && !tipiDaEliminareHeaders.isEmpty()) {
                for (int j = 0; j < tipiDaEliminareHeaders.size(); ++j) {
                    TipoMessaggio tipoMessaggioHeaders = tipiDaEliminareHeaders.get(j);
                    if (!tipoMessaggioHeaders.equals((Object)tipoMessaggio)) continue;
                    onlyLogFileTraceHeaders = true;
                    break;
                }
            }
            if (onlyLogFileTraceHeaders) {
                tipiDaEliminareHeaders.remove(tipoMessaggio);
            }
            boolean onlyLogFileTraceBody = false;
            if (tipiDaEliminareBody != null && !tipiDaEliminareBody.isEmpty()) {
                for (int j = 0; j < tipiDaEliminareBody.size(); ++j) {
                    TipoMessaggio tipoMessaggioBody = tipiDaEliminareBody.get(j);
                    if (!tipoMessaggioBody.equals((Object)tipoMessaggio)) continue;
                    onlyLogFileTraceBody = true;
                    break;
                }
            }
            if (onlyLogFileTraceBody) {
                tipiDaEliminareBody.remove(tipoMessaggio);
            }
            if (onlyLogFileTraceHeaders && onlyLogFileTraceBody) {
                messaggiDaEliminare.add(tipoMessaggio);
                continue;
            }
            if (onlyLogFileTraceHeaders) {
                messaggio.getHeaders().clear();
                continue;
            }
            if (!onlyLogFileTraceBody) continue;
            if (messaggio.getBody() != null) {
                messaggio.getBody().unlock();
                messaggio.getBody().clearResources();
                messaggio.setBody(null);
            }
            messaggio.setContentType(null);
        }
        if (messaggiDaEliminare != null) {
            block3: while (!messaggiDaEliminare.isEmpty()) {
                TipoMessaggio tipo = (TipoMessaggio)messaggiDaEliminare.remove(0);
                if (transaction.sizeMessaggi() <= 0) continue;
                for (int i = 0; i < transaction.sizeMessaggi(); ++i) {
                    if (!tipo.equals((Object)transaction.getMessaggio(i).getTipoMessaggio())) continue;
                    if (transaction.getMessaggio(i).getBody() != null) {
                        transaction.getMessaggio(i).getBody().unlock();
                        transaction.getMessaggio(i).getBody().clearResources();
                        transaction.getMessaggio(i).setBody(null);
                    }
                    transaction.removeMessaggio(i);
                    continue block3;
                }
            }
        }
    }

    public void invoke(TipoPdD tipoPdD, Context context, RequestInfo requestInfo, Busta busta, FaseTracciamento faseTracciamento) throws UtilsException {
        this.invoke(tipoPdD, context, requestInfo, busta, faseTracciamento, null);
    }

    public void invoke(TipoPdD tipoPdD, Context context, RequestInfo requestInfo, Busta busta, FaseTracciamento faseTracciamento, Map<String, String> outputMap) throws UtilsException {
        List<String> topic = null;
        Map<String, Topic> topicMap = null;
        switch (tipoPdD) {
            case DELEGATA: {
                topic = this.config.getTopicFruizioni();
                topicMap = this.config.getTopicFruizioneMap();
                break;
            }
            case APPLICATIVA: {
                topic = this.config.getTopicErogazioni();
                topicMap = this.config.getTopicErogazioniMap();
                break;
            }
        }
        if (topic != null && !topic.isEmpty()) {
            boolean requestSent = this.isRequestSent(context);
            ArrayList<Topic> topicInvoke = new ArrayList<Topic>();
            for (String topicName : topic) {
                Topic topicConfig = topicMap.get(topicName);
                if (!this.add(topicConfig, faseTracciamento, requestSent)) continue;
                topicInvoke.add(topicConfig);
            }
            this.invoke(topicInvoke, requestInfo, context, busta, outputMap);
        }
    }

    private boolean isRequestSent(Context context) {
        String s;
        Object o;
        boolean requestSent = false;
        if (context != null && context.containsKey(Costanti.RICHIESTA_INOLTRATA_BACKEND) && (o = context.getObject(Costanti.RICHIESTA_INOLTRATA_BACKEND)) instanceof String && "true".equals(s = (String)o)) {
            requestSent = true;
        }
        return requestSent;
    }

    private boolean add(Topic topicConfig, FaseTracciamento faseTracciamento, boolean requestSent) {
        boolean contentDefined;
        if (!topicConfig.isEnabled(faseTracciamento)) {
            return false;
        }
        if (topicConfig.isOnlyRequestSent() && !requestSent) {
            return false;
        }
        if (topicConfig.isOnlyInRequestContentDefined()) {
            boolean bl = contentDefined = this.t.getInRequestSize() > 0;
            if (!contentDefined) {
                return false;
            }
        }
        if (topicConfig.isOnlyOutRequestContentDefined()) {
            boolean bl = contentDefined = this.t.getOutRequestSize() > 0;
            if (!contentDefined) {
                return false;
            }
        }
        if (topicConfig.isOnlyInResponseContentDefined()) {
            boolean bl = contentDefined = this.t.getInResponseSize() > 0;
            if (!contentDefined) {
                return false;
            }
        }
        if (topicConfig.isOnlyOutResponseContentDefined()) {
            boolean bl = contentDefined = this.t.getOutResponseSize() > 0;
            if (!contentDefined) {
                return false;
            }
        }
        return true;
    }

    private void invoke(List<Topic> topicInvoke, RequestInfo requestInfo, Context context, Busta busta, Map<String, String> outputMap) throws UtilsException {
        if (topicInvoke != null && !topicInvoke.isEmpty()) {
            this.resolveProperties(requestInfo, context, busta);
            for (Topic topicConfig : topicInvoke) {
                String value = this.resolve(topicConfig.getFormat());
                if (outputMap != null) {
                    outputMap.put(topicConfig.getNome(), value);
                    continue;
                }
                switch (this.config.getLogSeverity()) {
                    case trace: {
                        topicConfig.getLog().trace(value);
                        break;
                    }
                    case debug: {
                        topicConfig.getLog().debug(value);
                        break;
                    }
                    case info: {
                        topicConfig.getLog().info(value);
                        break;
                    }
                    case warn: {
                        topicConfig.getLog().warn(value);
                        break;
                    }
                    case error: {
                        topicConfig.getLog().error(value);
                    }
                }
            }
        }
    }

    private void resolveProperties(RequestInfo requestInfo, Context context, Busta busta) throws UtilsException {
        List<String> properties;
        Map<String, String> propertiesEncryptionModes = this.config.getPropertiesEncryptionMode();
        FileTraceEncrypt encrypt = null;
        if (!propertiesEncryptionModes.isEmpty()) {
            encrypt = new FileTraceEncrypt(this.log, requestInfo, context, busta);
        }
        if ((properties = this.config.getPropertiesSortKeys()) != null && !properties.isEmpty()) {
            for (String sortKey : properties) {
                String pName = this.config.getPropertiesNames().get(sortKey);
                String pValue = this.config.getPropertiesValues().get(sortKey);
                String resolvedValue = this.resolve(pValue);
                String mode = propertiesEncryptionModes.get(sortKey);
                if (encrypt != null && mode != null && StringUtils.isNotEmpty((String)mode)) {
                    FileTraceEncryptConfig encryptionConfig = this.config.getEncryptionMode().get(mode);
                    resolvedValue = encrypt.encrypt(encryptionConfig, resolvedValue);
                }
                this.t.addProperty(pName, resolvedValue);
                this.tBase64.addProperty(pName, resolvedValue);
            }
        }
    }

    private String resolve(String format) throws UtilsException {
        boolean complexField = false;
        return DynamicStringReplace.replace((String)format, this.dynamicMap, (boolean)true, (boolean)complexField);
    }
}

