/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.info;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.pdd.logger.MsgDiagnosticiProperties;
import org.openspcoop2.pdd.logger.info.DatiEsitoTransazione;
import org.openspcoop2.pdd.logger.info.FormatUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.slf4j.Logger;

public class InfoEsitoTransazioneFormatUtils {
    public static boolean isEsitoOk(Logger log, Integer esito, String protocollo) {
        EsitiProperties esitiProperties = null;
        try {
            esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)protocollo);
        }
        catch (Exception e) {
            log.error("Errore durante l'analisi dell'esito [" + esito + "]: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return InfoEsitoTransazioneFormatUtils.isEsitoOk(log, esito, esitiProperties);
    }

    public static boolean isEsitoOk(Logger log, Integer esito, IProtocolFactory<?> protocolFactory) {
        EsitiProperties esitiProperties = null;
        try {
            esitiProperties = EsitiProperties.getInstance((Logger)log, protocolFactory);
        }
        catch (Exception e) {
            log.error("Errore durante l'analisi dell'esito [" + esito + "]: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return InfoEsitoTransazioneFormatUtils.isEsitoOk(log, esito, esitiProperties);
    }

    public static boolean isEsitoOk(Logger log, Integer esito, EsitiProperties esitiProperties) {
        try {
            List list = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
            boolean res = false;
            if (list != null && !list.isEmpty()) {
                for (Integer esitoCheck : list) {
                    if (esitoCheck.intValue() != esito.intValue()) continue;
                    res = true;
                    break;
                }
            }
            return res;
        }
        catch (Exception e) {
            log.error("Errore durante l'analisi dell'esito [" + esito + "]: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean isEsitoFaultApplicativo(Logger log, Integer esito, String protocollo) {
        EsitiProperties esitiProperties = null;
        try {
            esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)protocollo);
        }
        catch (Exception e) {
            log.error("Errore durante l'analisi dell'esito [" + esito + "]: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return InfoEsitoTransazioneFormatUtils.isEsitoFaultApplicativo(log, esito, esitiProperties);
    }

    public static boolean isEsitoFaultApplicativo(Logger log, Integer esito, IProtocolFactory<?> protocolFactory) {
        EsitiProperties esitiProperties = null;
        try {
            esitiProperties = EsitiProperties.getInstance((Logger)log, protocolFactory);
        }
        catch (Exception e) {
            log.error("Errore durante l'analisi dell'esito [" + esito + "]: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return InfoEsitoTransazioneFormatUtils.isEsitoFaultApplicativo(log, esito, esitiProperties);
    }

    public static boolean isEsitoFaultApplicativo(Logger log, Integer esito, EsitiProperties esitiProperties) {
        try {
            List list = esitiProperties.getEsitiCodeFaultApplicativo();
            boolean res = false;
            if (list != null && !list.isEmpty()) {
                for (Integer esitoCheck : list) {
                    if (esitoCheck.intValue() != esito.intValue()) continue;
                    res = true;
                    break;
                }
            }
            return res;
        }
        catch (Exception e) {
            log.error("Errore durante l'analisi dell'esito [" + esito + "]: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean isEsitoKo(Logger log, Integer esito, String protocollo) {
        EsitiProperties esitiProperties = null;
        try {
            esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)protocollo);
        }
        catch (Exception e) {
            log.error("Errore durante l'analisi dell'esito [" + esito + "]: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return InfoEsitoTransazioneFormatUtils.isEsitoKo(log, esito, esitiProperties);
    }

    public static boolean isEsitoKo(Logger log, Integer esito, IProtocolFactory<?> protocolFactory) {
        EsitiProperties esitiProperties = null;
        try {
            esitiProperties = EsitiProperties.getInstance((Logger)log, protocolFactory);
        }
        catch (Exception e) {
            log.error("Errore durante l'analisi dell'esito [" + esito + "]: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return InfoEsitoTransazioneFormatUtils.isEsitoKo(log, esito, esitiProperties);
    }

    public static boolean isEsitoKo(Logger log, Integer esito, EsitiProperties esitiProperties) {
        try {
            List list = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
            boolean res = false;
            if (list != null && !list.isEmpty()) {
                for (Integer esitoCheck : list) {
                    if (esitoCheck.intValue() != esito.intValue()) continue;
                    res = true;
                    break;
                }
            }
            return res;
        }
        catch (Exception e) {
            log.error("Errore durante l'analisi dell'esito [" + esito + "]: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean isVisualizzaFault(Logger log, String fault) {
        boolean visualizzaMessaggio = true;
        if (fault == null) {
            return false;
        }
        StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
        String errore = FormatUtils.getTestoVisualizzabile(log, fault.getBytes(), contenutoDocumentoStringBuilder, false);
        if (errore != null) {
            return false;
        }
        return visualizzaMessaggio;
    }

    public static String getFaultPretty(Logger log, String fault, String formatoFault) {
        String toRet = null;
        if (fault != null) {
            StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
            String errore = FormatUtils.getTestoVisualizzabile(log, fault.getBytes(), contenutoDocumentoStringBuilder, true);
            if (errore != null) {
                return "";
            }
            MessageType messageType = MessageType.XML;
            if (StringUtils.isNotEmpty((String)formatoFault)) {
                messageType = MessageType.valueOf((String)formatoFault);
            }
            switch (messageType) {
                case BINARY: 
                case MIME_MULTIPART: {
                    break;
                }
                case JSON: {
                    JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
                    try {
                        toRet = jsonUtils.toString(jsonUtils.getAsNode(fault));
                    }
                    catch (UtilsException utilsException) {}
                    break;
                }
                default: {
                    toRet = FormatUtils.prettifyXml(log, fault);
                }
            }
        }
        if (toRet == null) {
            toRet = fault != null ? fault : "";
        }
        return toRet;
    }

    public static String getDettaglioErrore(Logger log, DatiEsitoTransazione datiEsitoTransazione, List<MsgDiagnostico> msgsParams) {
        String erroreRilevante;
        IProtocolFactory<?> protocolFactory = null;
        try {
            protocolFactory = datiEsitoTransazione.getProtocolFactory();
        }
        catch (Exception e) {
            log.error("Errore durante il recupero del ProtocolFactory: " + e.getMessage(), (Throwable)e);
            return "";
        }
        if (InfoEsitoTransazioneFormatUtils.isEsitoFaultApplicativo(log, datiEsitoTransazione.getEsito(), protocolFactory)) {
            if (PddRuolo.APPLICATIVA.equals((Object)datiEsitoTransazione.getPddRuolo())) {
                if (InfoEsitoTransazioneFormatUtils.isVisualizzaFault(log, datiEsitoTransazione.getFaultIntegrazione())) {
                    return InfoEsitoTransazioneFormatUtils.getFaultPretty(log, datiEsitoTransazione.getFaultIntegrazione(), datiEsitoTransazione.getFormatoFaultIntegrazione());
                }
                if (InfoEsitoTransazioneFormatUtils.isVisualizzaFault(log, datiEsitoTransazione.getFaultCooperazione())) {
                    return InfoEsitoTransazioneFormatUtils.getFaultPretty(log, datiEsitoTransazione.getFaultCooperazione(), datiEsitoTransazione.getFormatoFaultCooperazione());
                }
            } else if (PddRuolo.DELEGATA.equals((Object)datiEsitoTransazione.getPddRuolo())) {
                if (InfoEsitoTransazioneFormatUtils.isVisualizzaFault(log, datiEsitoTransazione.getFaultCooperazione())) {
                    return InfoEsitoTransazioneFormatUtils.getFaultPretty(log, datiEsitoTransazione.getFaultCooperazione(), datiEsitoTransazione.getFormatoFaultCooperazione());
                }
                if (InfoEsitoTransazioneFormatUtils.isVisualizzaFault(log, datiEsitoTransazione.getFaultIntegrazione())) {
                    return InfoEsitoTransazioneFormatUtils.getFaultPretty(log, datiEsitoTransazione.getFaultIntegrazione(), datiEsitoTransazione.getFormatoFaultIntegrazione());
                }
            }
        }
        if ((erroreRilevante = InfoEsitoTransazioneFormatUtils.getMessaggioDiagnosticoErroreRilevante(log, datiEsitoTransazione.getEsito(), protocolFactory, msgsParams, false)) != null) {
            return erroreRilevante;
        }
        if (!InfoEsitoTransazioneFormatUtils.isEsitoFaultApplicativo(log, datiEsitoTransazione.getEsito(), protocolFactory)) {
            if (PddRuolo.APPLICATIVA.equals((Object)datiEsitoTransazione.getPddRuolo())) {
                if (InfoEsitoTransazioneFormatUtils.isVisualizzaFault(log, datiEsitoTransazione.getFaultIntegrazione())) {
                    return InfoEsitoTransazioneFormatUtils.getFaultPretty(log, datiEsitoTransazione.getFaultIntegrazione(), datiEsitoTransazione.getFormatoFaultIntegrazione());
                }
                if (InfoEsitoTransazioneFormatUtils.isVisualizzaFault(log, datiEsitoTransazione.getFaultCooperazione())) {
                    return InfoEsitoTransazioneFormatUtils.getFaultPretty(log, datiEsitoTransazione.getFaultCooperazione(), datiEsitoTransazione.getFormatoFaultCooperazione());
                }
            } else if (PddRuolo.DELEGATA.equals((Object)datiEsitoTransazione.getPddRuolo())) {
                if (InfoEsitoTransazioneFormatUtils.isVisualizzaFault(log, datiEsitoTransazione.getFaultCooperazione())) {
                    return InfoEsitoTransazioneFormatUtils.getFaultPretty(log, datiEsitoTransazione.getFaultCooperazione(), datiEsitoTransazione.getFormatoFaultCooperazione());
                }
                if (InfoEsitoTransazioneFormatUtils.isVisualizzaFault(log, datiEsitoTransazione.getFaultIntegrazione())) {
                    return InfoEsitoTransazioneFormatUtils.getFaultPretty(log, datiEsitoTransazione.getFaultIntegrazione(), datiEsitoTransazione.getFormatoFaultIntegrazione());
                }
            }
        }
        return null;
    }

    public static String getMessaggioDiagnosticoErroreRilevante(Logger log, Integer esito, IProtocolFactory<?> protocolFactory, List<MsgDiagnostico> msgsParams, boolean forceIgnoreWarning) {
        EsitiProperties esitiProperties = null;
        EsitoTransazioneName esitoTransactionName = null;
        try {
            esitiProperties = EsitiProperties.getInstance((Logger)log, protocolFactory);
            esitoTransactionName = esitiProperties.getEsitoTransazioneName(esito);
        }
        catch (Exception e) {
            log.error("Errore durante il recupero dell'esito della transazione: " + e.getMessage(), (Throwable)e);
            return "";
        }
        ArrayList<MsgDiagnostico> msgs = null;
        if (msgsParams != null) {
            msgs = new ArrayList<MsgDiagnostico>();
            if (!msgsParams.isEmpty()) {
                for (MsgDiagnostico msgDiagnostico : msgsParams) {
                    if (msgDiagnostico.getSeverita() > 2) continue;
                    msgs.add(msgDiagnostico);
                }
            }
        }
        try {
            StringBuilder sb = new StringBuilder();
            StringBuilder erroreConnessone = new StringBuilder();
            StringBuilder erroreSegnalaGenerazioneRispostaErrore = new StringBuilder();
            if (msgs != null && !msgs.isEmpty()) {
                for (MsgDiagnostico msgDiagnostico : msgs) {
                    String codice = msgDiagnostico.getCodice();
                    if ((InfoEsitoTransazioneFormatUtils.isEsitoKo(log, esito, protocolFactory) || forceIgnoreWarning) && MsgDiagnosticiProperties.MSG_DIAGNOSTICI_WARNING.contains(codice)) continue;
                    if (EsitoTransazioneName.isErroreRisposta((EsitoTransazioneName)esitoTransactionName) && MsgDiagnosticiProperties.MSG_DIAGNOSTICI_ERRORE_CONNETTORE.contains(codice)) {
                        if (erroreConnessone.length() > 0) {
                            erroreConnessone.append("\n");
                        }
                        erroreConnessone.append(msgDiagnostico.getMessaggio());
                        continue;
                    }
                    if (MsgDiagnosticiProperties.MSG_DIAGNOSTICI_SEGNALA_GENERATA_RISPOSTA_ERRORE.contains(codice)) {
                        if (erroreSegnalaGenerazioneRispostaErrore.length() > 0) {
                            erroreSegnalaGenerazioneRispostaErrore.append("\n");
                        }
                        erroreSegnalaGenerazioneRispostaErrore.append(msgDiagnostico.getMessaggio());
                        continue;
                    }
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(msgDiagnostico.getMessaggio());
                    break;
                }
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
            if (erroreConnessone.length() > 0) {
                return erroreConnessone.toString();
            }
            if (erroreSegnalaGenerazioneRispostaErrore.length() > 0) {
                return erroreSegnalaGenerazioneRispostaErrore.toString();
            }
        }
        catch (Exception e) {
            log.error("Errore durante il recupero dell'errore: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String getMessaggioDiagnosticoWarning(Logger log, Integer esito, IProtocolFactory<?> protocolFactory, List<MsgDiagnostico> msgsParams) {
        ArrayList<MsgDiagnostico> msgs = null;
        if (msgsParams != null) {
            msgs = new ArrayList<MsgDiagnostico>();
            if (!msgsParams.isEmpty()) {
                for (MsgDiagnostico msgDiagnostico : msgsParams) {
                    if (msgDiagnostico.getSeverita() > 2) continue;
                    msgs.add(msgDiagnostico);
                }
            }
        }
        try {
            StringBuilder sb = new StringBuilder();
            if (msgs != null && !msgs.isEmpty()) {
                for (MsgDiagnostico msgDiagnostico : msgs) {
                    String codice = msgDiagnostico.getCodice();
                    if (!MsgDiagnosticiProperties.MSG_DIAGNOSTICI_WARNING.contains(codice)) continue;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(msgDiagnostico.getMessaggio());
                }
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        catch (Exception e) {
            log.error("Errore durante il recupero dell'errore: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

