/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.info;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.pdd.logger.info.DatiMittente;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.transport.http.HttpClientAddressSanitizer;

public class InfoMittenteFormatUtils {
    private InfoMittenteFormatUtils() {
    }

    public static String getRichiedente(DatiMittente infoDatiMittente) {
        String sTokenUsername = infoDatiMittente.getTokenUsername();
        if (StringUtils.isNotEmpty((String)sTokenUsername)) {
            return sTokenUsername;
        }
        String sTokenClient = infoDatiMittente.getTokenClient();
        if (StringUtils.isNotEmpty((String)sTokenClient)) {
            return sTokenClient;
        }
        String sTokenClientPdndOrganizationName = infoDatiMittente.getPdndOrganizationName();
        if (StringUtils.isNotEmpty((String)sTokenClientPdndOrganizationName)) {
            return sTokenClientPdndOrganizationName;
        }
        String sApplicativoFruitore = infoDatiMittente.getServizioApplicativoFruitore();
        if (StringUtils.isNotEmpty((String)sApplicativoFruitore)) {
            return sApplicativoFruitore;
        }
        String sTokenClientId = infoDatiMittente.getTokenClientId();
        String sTokenSubject = infoDatiMittente.getTokenSubject();
        boolean clientCredentialsFlow = false;
        if (StringUtils.isNotEmpty((String)sTokenClientId)) {
            boolean bl = clientCredentialsFlow = sTokenSubject == null || StringUtils.isEmpty((String)sTokenSubject) || sTokenSubject.equals(sTokenClientId);
        }
        if (clientCredentialsFlow && StringUtils.isNotEmpty((String)sTokenClientId)) {
            return sTokenClientId;
        }
        if (StringUtils.isNotEmpty((String)sTokenSubject)) {
            String sTokenIssuer = infoDatiMittente.getTokenIssuer();
            if (StringUtils.isNotEmpty((String)sTokenIssuer)) {
                return sTokenSubject + "@" + sTokenIssuer;
            }
            return sTokenSubject;
        }
        if (!clientCredentialsFlow && StringUtils.isNotEmpty((String)sTokenClientId)) {
            return sTokenClientId;
        }
        String sTrasporto = InfoMittenteFormatUtils.getRichiedenteTrasporto(infoDatiMittente);
        if (sTrasporto != null) {
            return sTrasporto;
        }
        return null;
    }

    private static String getRichiedenteTrasporto(DatiMittente infoDatiMittente) {
        String sTrasportoMittente = infoDatiMittente.getTrasportoMittente();
        String sTipoTrasportoMittente = infoDatiMittente.getTipoTrasportoMittente();
        if (StringUtils.isNotEmpty((String)sTrasportoMittente) && StringUtils.isNotEmpty((String)sTipoTrasportoMittente)) {
            if (sTipoTrasportoMittente.endsWith("_" + TipoAutenticazione.SSL.getValue())) {
                return InfoMittenteFormatUtils.getRichiedenteTrasportoSSLEngine(sTrasportoMittente);
            }
            return sTrasportoMittente;
        }
        return null;
    }

    private static String getRichiedenteTrasportoSSLEngine(String sTrasportoMittente) {
        try {
            List<String> cnList;
            Map l = CertificateUtils.getPrincipalIntoMap((String)sTrasportoMittente, (PrincipalType)PrincipalType.SUBJECT);
            if (l != null && !l.isEmpty() && (cnList = InfoMittenteFormatUtils.getCNList(l)) != null && !cnList.isEmpty()) {
                StringBuilder bfList = new StringBuilder();
                for (String s : cnList) {
                    if (bfList.length() > 0) {
                        bfList.append(", ");
                    }
                    bfList.append(s);
                }
                return bfList.toString();
            }
            return sTrasportoMittente;
        }
        catch (Exception t) {
            return sTrasportoMittente;
        }
    }

    private static List<String> getCNList(Map<String, List<String>> l) {
        List<String> cnList = l.get("CN");
        if (cnList == null || cnList.isEmpty()) {
            cnList = l.get("cn");
        }
        if (cnList == null || cnList.isEmpty()) {
            cnList = l.get("Cn");
        }
        if (cnList == null || cnList.isEmpty()) {
            cnList = l.get("cN");
        }
        return cnList;
    }

    public static String getIpRichiedente(DatiMittente infoDatiMittente, boolean sanitizePort) {
        String t = infoDatiMittente.getTransportClientAddress();
        if (StringUtils.isNotEmpty((String)t)) {
            if (sanitizePort) {
                return HttpClientAddressSanitizer.sanitizeTransportAddressPort((String)t);
            }
            return t;
        }
        String s = infoDatiMittente.getSocketClientAddress();
        if (StringUtils.isNotEmpty((String)s)) {
            return s;
        }
        return null;
    }

    public static String getLabelRichiedenteConFruitore(DatiMittente infoDatiMittente) {
        String sTokenClient;
        StringBuilder bf = new StringBuilder();
        String richiedente = InfoMittenteFormatUtils.getRichiedente(infoDatiMittente);
        if (StringUtils.isNotEmpty((String)richiedente)) {
            bf.append(richiedente);
        }
        if (StringUtils.isNotEmpty((String)(sTokenClient = infoDatiMittente.getTokenClient()))) {
            InfoMittenteFormatUtils.processLabelRichiedenteConFruitoreTokenClient(infoDatiMittente, bf);
        } else {
            InfoMittenteFormatUtils.processLabelRichiedenteConFruitore(infoDatiMittente, bf, richiedente);
        }
        return bf.toString();
    }

    private static void processLabelRichiedenteConFruitoreTokenClient(DatiMittente infoDatiMittente, StringBuilder bfParam) {
        if (infoDatiMittente.getTokenClientSoggettoFruitore() != null && infoDatiMittente.getTokenClientTipoSoggettoFruitore() != null && infoDatiMittente.getTokenClientNomeSoggettoFruitore() != null) {
            boolean addFruitore = true;
            IDSoggetto idSoggettoFruitore = new IDSoggetto(infoDatiMittente.getTokenClientTipoSoggettoFruitore(), infoDatiMittente.getTokenClientNomeSoggettoFruitore());
            if (PddRuolo.DELEGATA.equals((Object)infoDatiMittente.getPddRuolo())) {
                boolean bl = addFruitore = infoDatiMittente.getSoggettoOperativo() == null || !infoDatiMittente.getSoggettoOperativo().equals(idSoggettoFruitore.toString());
            }
            if (addFruitore) {
                if (bfParam.length() > 0) {
                    bfParam.append("@");
                }
                bfParam.append(infoDatiMittente.getTokenClientSoggettoFruitore());
            }
        }
    }

    private static void processLabelRichiedenteConFruitore(DatiMittente infoDatiMittente, StringBuilder bfParam, String richiedente) {
        String sFruitore = infoDatiMittente.getSoggettoFruitore();
        if (StringUtils.isNotEmpty((String)sFruitore)) {
            boolean addFruitore = true;
            if (PddRuolo.APPLICATIVA.equals((Object)infoDatiMittente.getPddRuolo())) {
                InfoMittenteFormatUtils.processLabelRichiedenteConFruitorePortaApplicativa(infoDatiMittente, bfParam, richiedente);
            } else if (PddRuolo.DELEGATA.equals((Object)infoDatiMittente.getPddRuolo()) && infoDatiMittente.getSoggettoOperativo() != null && StringUtils.isNotEmpty((String)infoDatiMittente.getTipoSoggettoFruitore()) && StringUtils.isNotEmpty((String)infoDatiMittente.getNomeSoggettoFruitore())) {
                IDSoggetto idSoggettoFruitore = new IDSoggetto(infoDatiMittente.getTipoSoggettoFruitore(), infoDatiMittente.getNomeSoggettoFruitore());
                boolean bl = addFruitore = !infoDatiMittente.getSoggettoOperativo().equals(idSoggettoFruitore.toString());
            }
            if (addFruitore) {
                if (bfParam.length() > 0) {
                    bfParam.append("@");
                }
                bfParam.append(sFruitore);
            }
        }
    }

    private static void processLabelRichiedenteConFruitorePortaApplicativa(DatiMittente infoDatiMittente, StringBuilder bfParam, String richiedente) {
        String sTipoTrasportoMittente;
        String sTrasportoMittente = infoDatiMittente.getTrasportoMittente();
        if (richiedente != null && sTrasportoMittente != null && richiedente.equals(sTrasportoMittente) && (sTipoTrasportoMittente = infoDatiMittente.getTipoTrasportoMittente()) != null && StringUtils.isNotEmpty((String)sTipoTrasportoMittente) && sTipoTrasportoMittente.endsWith("_" + TipoAutenticazione.APIKEY.getValue()) && !sTrasportoMittente.contains("@") && bfParam.length() > 0) {
            bfParam.setLength(0);
        }
    }
}

