/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.traccia;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.joda.time.DateTime;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.transazioni.DumpAllegato;
import org.openspcoop2.core.transazioni.DumpContenuto;
import org.openspcoop2.core.transazioni.DumpHeaderAllegato;
import org.openspcoop2.core.transazioni.DumpHeaderTrasporto;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.DumpMultipartHeader;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.core.transazioni.utils.CredenzialiMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTokenClient;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.pdd.logger.traccia.TracciaException;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaSerializer;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.service.beans.Diagnostico;
import org.openspcoop2.utils.service.beans.DiagnosticoSeveritaEnum;
import org.openspcoop2.utils.service.beans.HttpMethodEnum;
import org.openspcoop2.utils.service.beans.ProfiloCollaborazioneEnum;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.Transazione;
import org.openspcoop2.utils.service.beans.TransazioneBase;
import org.openspcoop2.utils.service.beans.TransazioneContenutoMessaggio;
import org.openspcoop2.utils.service.beans.TransazioneContenutoMessaggioHeader;
import org.openspcoop2.utils.service.beans.TransazioneContestoEnum;
import org.openspcoop2.utils.service.beans.TransazioneDettaglioRichiesta;
import org.openspcoop2.utils.service.beans.TransazioneDettaglioRisposta;
import org.openspcoop2.utils.service.beans.TransazioneEsito;
import org.openspcoop2.utils.service.beans.TransazioneExt;
import org.openspcoop2.utils.service.beans.TransazioneExtContenutoMessaggio;
import org.openspcoop2.utils.service.beans.TransazioneExtContenutoMessaggioAllegato;
import org.openspcoop2.utils.service.beans.TransazioneExtContenutoMessaggioBody;
import org.openspcoop2.utils.service.beans.TransazioneExtContenutoMessaggioBodyMultipart;
import org.openspcoop2.utils.service.beans.TransazioneExtContenutoMessaggioPorzioneBody;
import org.openspcoop2.utils.service.beans.TransazioneExtDettaglioRichiesta;
import org.openspcoop2.utils.service.beans.TransazioneExtDettaglioRisposta;
import org.openspcoop2.utils.service.beans.TransazioneExtInformazioniApi;
import org.openspcoop2.utils.service.beans.TransazioneExtInformazioniMittente;
import org.openspcoop2.utils.service.beans.TransazioneExtInformazioniMittenteApplicativoToken;
import org.openspcoop2.utils.service.beans.TransazioneExtInformazioniSoggetto;
import org.openspcoop2.utils.service.beans.TransazioneExtInformazioniToken;
import org.openspcoop2.utils.service.beans.TransazioneInformazioniApi;
import org.openspcoop2.utils.service.beans.TransazioneInformazioniMittente;
import org.openspcoop2.utils.service.beans.TransazioneMessaggioFormatoEnum;
import org.openspcoop2.utils.service.beans.TransazioneRuoloEnum;
import org.slf4j.Logger;

public class Converter {
    private Logger log;
    private boolean throwInitProtocol = true;
    private boolean emittente = true;
    private boolean dataEmissione = true;
    private boolean id = true;
    private boolean idConversazione = true;
    private boolean ruolo = true;
    private boolean esito = true;
    private boolean messaggi_id = true;
    private boolean messaggi_idApplicativo = true;
    private boolean messaggi_data = true;
    private boolean messaggi_contenuti = true;
    private boolean richiesta_tipo = true;
    private boolean richiesta_urlInvocazione = true;
    private boolean risposta_esito = true;
    private boolean risposta_fault = true;
    private boolean risposta_errori = true;
    private boolean api_erogatore = true;
    private boolean api_nome = true;
    private boolean api_versione = true;
    private boolean api_operazione = true;
    private boolean mittente_fruitore = true;
    private boolean mittente_principal = true;
    private boolean mittente_utente = true;
    private boolean mittente_client = true;
    private boolean mittente_indirizzoClient = true;
    private boolean mittente_indirizzoClientInoltrato = true;
    private boolean profilo = true;
    private boolean contesto = true;
    private boolean idCluster = true;
    private boolean emittenteExtraInfo = true;
    private boolean stato = true;
    private boolean messaggi_dimensione = true;
    private boolean messaggi_dataAccettazione = true;
    private boolean messaggi_duplicati = true;
    private boolean messaggi_tracciaProtocollo = true;
    private boolean richiesta_connettore = true;
    private boolean diagnostici = true;
    private boolean api_erogatoreExtraInfo = true;
    private boolean api_tags = true;
    private boolean api_tipo = true;
    private boolean api_idAsincrono = true;
    private boolean api_profiloCollaborazione = true;
    private boolean mittente_fruitoreExtraInfo = true;
    private boolean mittente_applicativo = true;
    private boolean mittente_credenziali = true;
    private boolean mittente_token = true;
    private boolean mittente_tokenClaims = true;
    private boolean mittente_applicativoToken = true;

    public Converter(Logger log) {
        this.log = log;
    }

    public Converter(Logger log, Properties pConf) throws TracciaException {
        this.log = log;
        try {
            Field[] fields;
            for (Field field : fields = Converter.class.getDeclaredFields()) {
                String fieldName = field.getName();
                if (!pConf.containsKey(fieldName = fieldName.replace("_", "."))) continue;
                String value = pConf.getProperty(fieldName);
                String bCN = Boolean.TYPE.getName();
                if (bCN.equals(field.getType().getName())) {
                    field.set(this, "true".equalsIgnoreCase(value));
                    continue;
                }
                field.set(this, value);
            }
        }
        catch (Exception e) {
            throw new TracciaException(e.getMessage(), e);
        }
    }

    public Transazione toTransazione(org.openspcoop2.core.transazioni.Transazione transazioneDB, CredenzialiMittente credenzialiMittente, List<MsgDiagnostico> messaggiDiagnostici) throws Exception {
        return (Transazione)this._toTransazione(transazioneDB, credenzialiMittente, null, null, messaggiDiagnostici, false);
    }

    public TransazioneExt toTransazioneExt(org.openspcoop2.core.transazioni.Transazione transazioneDB, CredenzialiMittente credenzialiMittente, Traccia tracciaRichiesta, Traccia tracciaRisposta, List<MsgDiagnostico> messaggiDiagnostici) throws Exception {
        return (TransazioneExt)this._toTransazione(transazioneDB, credenzialiMittente, tracciaRichiesta, tracciaRisposta, messaggiDiagnostici, true);
    }

    private TransazioneBase _toTransazione(org.openspcoop2.core.transazioni.Transazione transazioneDB, CredenzialiMittente credenzialiMittente, Traccia tracciaRichiesta, Traccia tracciaRisposta, List<MsgDiagnostico> messaggiDiagnostici, boolean extended) throws Exception {
        String[] tmp;
        HttpMethodEnum methodEnum;
        ArrayList<String> errori = new ArrayList<String>();
        if (!(extended && this.diagnostici || messaggiDiagnostici == null || messaggiDiagnostici.size() <= 0)) {
            for (MsgDiagnostico diag : messaggiDiagnostici) {
                if (diag.getSeverita() > 2) continue;
                errori.add(diag.getMessaggio());
            }
        }
        Object transazione = null;
        transazione = extended ? new TransazioneExt() : new Transazione();
        if (this.id) {
            transazione.setIdTraccia(UUID.fromString(transazioneDB.getIdTransazione()));
        }
        if (this.dataEmissione) {
            transazione.setDataEmissione(new DateTime(DateManager.getTimeMillis()));
        }
        if (this.idConversazione) {
            transazione.setIdConversazione(transazioneDB.getIdCollaborazione());
        }
        if (this.esito) {
            TransazioneEsito esito = new TransazioneEsito();
            esito.setCodice("" + transazioneDB.getEsito());
            try {
                EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)this.log, (String)transazioneDB.getProtocollo());
                esito.setDescrizione(esitiProperties.getEsitoLabel(Integer.valueOf(transazioneDB.getEsito())));
            }
            catch (Throwable e) {
                if (this.throwInitProtocol) {
                    throw e;
                }
                esito.setDescrizione("ok");
            }
            transazione.setEsito(esito);
        }
        TransazioneRuoloEnum ruoloTraccia = null;
        ruoloTraccia = PddRuolo.DELEGATA.equals((Object)transazioneDB.getPddRuolo()) ? TransazioneRuoloEnum.FRUIZIONE : TransazioneRuoloEnum.EROGAZIONE;
        IProtocolFactory protocolFactory = null;
        ITracciaSerializer tracciaSerializer = null;
        if (extended) {
            block155: {
                block154: {
                    try {
                        protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(transazioneDB.getProtocollo());
                        if (!protocolFactory.createProtocolConfiguration().isAbilitataGenerazioneTracce()) break block154;
                        tracciaSerializer = protocolFactory.createTracciaSerializer();
                    }
                    finally {
                        if (this.ruolo) {
                        }
                        break block155;
                    }
                }
                transazione.setRuolo(ruoloTraccia);
            }
            if (this.emittente) {
                if (transazioneDB.getPddNomeSoggetto() != null) {
                    transazione.setEmittente(transazioneDB.getPddNomeSoggetto());
                } else if (PddRuolo.APPLICATIVA.equals((Object)transazioneDB.getPddRuolo()) && transazioneDB.getNomeSoggettoErogatore() != null) {
                    transazione.setEmittente(transazioneDB.getNomeSoggettoErogatore());
                } else if (PddRuolo.DELEGATA.equals((Object)transazioneDB.getPddRuolo()) && transazioneDB.getNomeSoggettoFruitore() != null) {
                    transazione.setEmittente(transazioneDB.getNomeSoggettoFruitore());
                } else {
                    transazione.setEmittente(transazioneDB.getPddCodice());
                }
            }
            if (this.profilo) {
                ProfiloEnum profilo = ProfiloEnum.APIGATEWAY;
                if (transazioneDB.getProtocollo().equals("modipa")) {
                    profilo = ProfiloEnum.MODIPA;
                } else if (transazioneDB.getProtocollo().equals("spcoop")) {
                    profilo = ProfiloEnum.SPCOOP;
                } else if (transazioneDB.getProtocollo().equals("sdi")) {
                    profilo = ProfiloEnum.FATTURAPA;
                } else if (transazioneDB.getProtocollo().equals("as4")) {
                    profilo = ProfiloEnum.EDELIVERY;
                }
                transazione.setProfilo(profilo);
            }
            if (this.contesto) {
                TransazioneContestoEnum contesto = TransazioneContestoEnum.STANDARD;
                if (transazioneDB.getEsitoContesto() != null && !TransazioneContestoEnum.STANDARD.name().equalsIgnoreCase(transazioneDB.getEsitoContesto())) {
                    contesto = TransazioneContestoEnum.SONDA;
                }
                transazione.setContesto(contesto);
            }
            if (this.idCluster) {
                transazione.setIdCluster(transazioneDB.getClusterId());
            }
            if (this.emittenteExtraInfo) {
                String tipoEmittente = transazioneDB.getPddTipoSoggetto();
                if (tipoEmittente == null) {
                    tipoEmittente = PddRuolo.APPLICATIVA.equals((Object)transazioneDB.getPddRuolo()) && transazioneDB.getTipoSoggettoErogatore() != null ? transazioneDB.getTipoSoggettoErogatore() : (PddRuolo.DELEGATA.equals((Object)transazioneDB.getPddRuolo()) && transazioneDB.getTipoSoggettoFruitore() != null ? transazioneDB.getTipoSoggettoFruitore() : protocolFactory.createProtocolConfiguration().getTipoSoggettoDefault());
                }
                transazione.setInformazioniEmittente(this._newTransazioneSoggetto(tipoEmittente, transazioneDB.getPddCodice(), null));
            }
            if (this.stato) {
                transazione.setStato(transazioneDB.getStato());
            }
        } else {
            if (this.ruolo) {
                ((Transazione)transazione).setRuolo(ruoloTraccia);
            }
            if (this.emittente) {
                ((Transazione)transazione).setEmittente(transazioneDB.getPddNomeSoggetto());
            }
        }
        Object richiesta = null;
        richiesta = extended ? new TransazioneExtDettaglioRichiesta() : new TransazioneDettaglioRichiesta();
        if (extended) {
            if (this.messaggi_dimensione) {
                richiesta.setBytesIngresso(transazioneDB.getRichiestaIngressoBytes());
                richiesta.setBytesUscita(transazioneDB.getRichiestaUscitaBytes());
            }
            if (this.messaggi_dataAccettazione && transazioneDB.getDataAccettazioneRichiesta() != null) {
                richiesta.setDataAccettazione(new DateTime(transazioneDB.getDataAccettazioneRichiesta().getTime()));
            }
        }
        if (this.messaggi_id) {
            richiesta.setId(transazioneDB.getIdMessaggioRichiesta());
        }
        if (this.messaggi_idApplicativo) {
            richiesta.setIdApplicativo(transazioneDB.getIdCorrelazioneApplicativa());
        }
        if (extended) {
            if (this.messaggi_data) {
                if (transazioneDB.getDataIngressoRichiesta() != null) {
                    richiesta.setDataRicezione(new DateTime(transazioneDB.getDataIngressoRichiesta().getTime()));
                }
                if (transazioneDB.getDataIngressoRichiestaStream() != null) {
                    richiesta.setDataRicezioneAcquisita(new DateTime(transazioneDB.getDataIngressoRichiestaStream().getTime()));
                }
                if (transazioneDB.getDataUscitaRichiesta() != null) {
                    richiesta.setDataConsegna(new DateTime(transazioneDB.getDataUscitaRichiesta().getTime()));
                }
                if (transazioneDB.getDataUscitaRichiestaStream() != null) {
                    richiesta.setDataConsegnaEffettuata(new DateTime(transazioneDB.getDataUscitaRichiestaStream().getTime()));
                }
            }
            if (this.richiesta_tipo && transazioneDB.getTipoRichiesta() != null) {
                methodEnum = HttpMethodEnum.fromValue((String)transazioneDB.getTipoRichiesta().toUpperCase());
                richiesta.setTipo(methodEnum);
            }
            if (this.richiesta_urlInvocazione) {
                richiesta.setUrlInvocazione(this.normalizeUrl(transazioneDB.getUrlInvocazione()));
            }
            if (this.richiesta_connettore) {
                richiesta.setConnettore(this.normalizeUrl(transazioneDB.getLocationConnettore()));
            }
            if (this.messaggi_duplicati) {
                richiesta.setDuplicatiMessaggio(Integer.valueOf(transazioneDB.getDuplicatiRichiesta()));
            }
            if (this.messaggi_tracciaProtocollo && tracciaSerializer != null && tracciaRichiesta != null) {
                richiesta.setTraccia(tracciaSerializer.toString(tracciaRichiesta, TipoSerializzazione.DEFAULT));
            }
            if (this.messaggi_contenuti) {
                richiesta.setContenutiIngresso((TransazioneExtContenutoMessaggio)this.newTransazioneContenutoMessaggio(transazioneDB, TipoMessaggio.RICHIESTA_INGRESSO, TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO, true));
                richiesta.setContenutiUscita((TransazioneExtContenutoMessaggio)this.newTransazioneContenutoMessaggio(transazioneDB, TipoMessaggio.RICHIESTA_USCITA, TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO, true));
            }
            transazione.setRichiesta(richiesta);
        } else {
            if (this.messaggi_data) {
                if (transazioneDB.getDataIngressoRichiesta() != null) {
                    ((TransazioneDettaglioRichiesta)richiesta).setDataRicezione(new DateTime(transazioneDB.getDataIngressoRichiesta().getTime()));
                }
                if (transazioneDB.getDataUscitaRichiesta() != null) {
                    ((TransazioneDettaglioRichiesta)richiesta).setDataConsegna(new DateTime(transazioneDB.getDataUscitaRichiesta().getTime()));
                }
            }
            if (this.richiesta_tipo && transazioneDB.getTipoRichiesta() != null) {
                methodEnum = HttpMethodEnum.fromValue((String)transazioneDB.getTipoRichiesta().toUpperCase());
                ((TransazioneDettaglioRichiesta)richiesta).setTipo(methodEnum);
            }
            if (this.richiesta_urlInvocazione) {
                if (TransazioneRuoloEnum.FRUIZIONE.equals((Object)ruoloTraccia)) {
                    ((TransazioneDettaglioRichiesta)richiesta).setUrlInvocazione(this.normalizeUrl(transazioneDB.getLocationConnettore()));
                } else {
                    ((TransazioneDettaglioRichiesta)richiesta).setUrlInvocazione(this.normalizeUrl(transazioneDB.getUrlInvocazione()));
                }
            }
            if (this.messaggi_contenuti) {
                if (TransazioneRuoloEnum.FRUIZIONE.equals((Object)ruoloTraccia)) {
                    ((TransazioneDettaglioRichiesta)richiesta).setContenuti(this.newTransazioneContenutoMessaggio(transazioneDB, TipoMessaggio.RICHIESTA_USCITA, TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO, false));
                } else {
                    ((TransazioneDettaglioRichiesta)richiesta).setContenuti(this.newTransazioneContenutoMessaggio(transazioneDB, TipoMessaggio.RICHIESTA_INGRESSO, TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO, false));
                }
            }
            ((Transazione)transazione).setRichiesta((TransazioneDettaglioRichiesta)richiesta);
        }
        Object risposta = null;
        risposta = extended ? new TransazioneExtDettaglioRisposta() : new TransazioneDettaglioRisposta();
        if (extended) {
            if (this.messaggi_dimensione) {
                risposta.setBytesIngresso(transazioneDB.getRispostaIngressoBytes());
                risposta.setBytesUscita(transazioneDB.getRispostaUscitaBytes());
            }
            if (this.messaggi_dataAccettazione && transazioneDB.getDataAccettazioneRisposta() != null) {
                risposta.setDataAccettazione(new DateTime(transazioneDB.getDataAccettazioneRisposta().getTime()));
            }
        }
        if (this.messaggi_id) {
            risposta.setId(transazioneDB.getIdMessaggioRisposta());
        }
        if (this.messaggi_idApplicativo) {
            risposta.setIdApplicativo(transazioneDB.getIdCorrelazioneApplicativaRisposta());
        }
        if (extended) {
            if (this.messaggi_data) {
                if (transazioneDB.getDataIngressoRisposta() != null) {
                    risposta.setDataRicezione(new DateTime(transazioneDB.getDataIngressoRisposta().getTime()));
                }
                if (transazioneDB.getDataIngressoRispostaStream() != null) {
                    risposta.setDataRicezioneAcquisita(new DateTime(transazioneDB.getDataIngressoRispostaStream().getTime()));
                }
                if (transazioneDB.getDataUscitaRisposta() != null) {
                    risposta.setDataConsegnaEffettuata(new DateTime(transazioneDB.getDataUscitaRisposta().getTime()));
                }
                if (transazioneDB.getDataUscitaRispostaStream() != null) {
                    risposta.setDataConsegna(new DateTime(transazioneDB.getDataUscitaRispostaStream().getTime()));
                }
            }
            if (this.risposta_esito) {
                risposta.setEsitoConsegna(transazioneDB.getCodiceRispostaUscita());
                risposta.setEsitoRicezione(transazioneDB.getCodiceRispostaIngresso());
            }
            if (this.messaggi_duplicati) {
                risposta.setDuplicatiMessaggio(Integer.valueOf(transazioneDB.getDuplicatiRisposta()));
            }
            if (this.messaggi_tracciaProtocollo && tracciaSerializer != null && tracciaRisposta != null) {
                risposta.setTraccia(tracciaSerializer.toString(tracciaRisposta, TipoSerializzazione.DEFAULT));
            }
            if (this.messaggi_contenuti) {
                risposta.setContenutiIngresso((TransazioneExtContenutoMessaggio)this.newTransazioneContenutoMessaggio(transazioneDB, TipoMessaggio.RISPOSTA_INGRESSO, TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO, true));
                risposta.setContenutiUscita((TransazioneExtContenutoMessaggio)this.newTransazioneContenutoMessaggio(transazioneDB, TipoMessaggio.RISPOSTA_USCITA, TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO, true));
            }
            if (this.risposta_fault) {
                if (TransazioneRuoloEnum.FRUIZIONE.equals((Object)ruoloTraccia)) {
                    if (transazioneDB.getFaultCooperazione() != null) {
                        risposta.setFaultRicezione(transazioneDB.getFaultCooperazione().getBytes());
                        risposta.setFaultRicezioneFormato(this._convert(transazioneDB.getFormatoFaultCooperazione()));
                    }
                    if (transazioneDB.getFaultIntegrazione() != null) {
                        risposta.setFaultConsegna(transazioneDB.getFaultIntegrazione().getBytes());
                        risposta.setFaultConsegnaFormato(this._convert(transazioneDB.getFormatoFaultIntegrazione()));
                    }
                } else {
                    if (transazioneDB.getFaultCooperazione() != null) {
                        risposta.setFaultConsegna(transazioneDB.getFaultCooperazione().getBytes());
                        risposta.setFaultConsegnaFormato(this._convert(transazioneDB.getFormatoFaultCooperazione()));
                    }
                    if (transazioneDB.getFaultIntegrazione() != null) {
                        risposta.setFaultRicezione(transazioneDB.getFaultIntegrazione().getBytes());
                        risposta.setFaultRicezioneFormato(this._convert(transazioneDB.getFormatoFaultIntegrazione()));
                    }
                }
            }
            if (this.risposta_errori && !errori.isEmpty()) {
                risposta.setDettagliErrore(new ArrayList());
                for (String errore : errori) {
                    risposta.getDettagliErrore().add(errore);
                }
            }
            transazione.setRisposta(risposta);
        } else {
            if (this.messaggi_data) {
                if (transazioneDB.getDataIngressoRisposta() != null) {
                    ((TransazioneDettaglioRisposta)risposta).setDataRicezione(new DateTime(transazioneDB.getDataIngressoRisposta().getTime()));
                }
                if (transazioneDB.getDataUscitaRisposta() != null) {
                    ((TransazioneDettaglioRisposta)risposta).setDataConsegna(new DateTime(transazioneDB.getDataUscitaRisposta().getTime()));
                }
            }
            if (this.risposta_esito) {
                ((TransazioneDettaglioRisposta)risposta).setEsitoConsegna(transazioneDB.getCodiceRispostaUscita());
                ((TransazioneDettaglioRisposta)risposta).setEsitoRicezione(transazioneDB.getCodiceRispostaIngresso());
            }
            if (this.messaggi_contenuti) {
                if (TransazioneRuoloEnum.FRUIZIONE.equals((Object)ruoloTraccia)) {
                    ((TransazioneDettaglioRisposta)risposta).setContenuti(this.newTransazioneContenutoMessaggio(transazioneDB, TipoMessaggio.RISPOSTA_INGRESSO, TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO, false));
                } else {
                    ((TransazioneDettaglioRisposta)risposta).setContenuti(this.newTransazioneContenutoMessaggio(transazioneDB, TipoMessaggio.RISPOSTA_USCITA, TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO, false));
                }
            }
            if (this.risposta_fault) {
                if (TransazioneRuoloEnum.FRUIZIONE.equals((Object)ruoloTraccia)) {
                    if (transazioneDB.getFaultCooperazione() != null) {
                        ((TransazioneDettaglioRisposta)risposta).setFaultRicezione(transazioneDB.getFaultCooperazione().getBytes());
                    }
                    if (transazioneDB.getFaultIntegrazione() != null) {
                        ((TransazioneDettaglioRisposta)risposta).setFaultConsegna(transazioneDB.getFaultIntegrazione().getBytes());
                    }
                } else {
                    if (transazioneDB.getFaultCooperazione() != null) {
                        ((TransazioneDettaglioRisposta)risposta).setFaultConsegna(transazioneDB.getFaultCooperazione().getBytes());
                    }
                    if (transazioneDB.getFaultIntegrazione() != null) {
                        ((TransazioneDettaglioRisposta)risposta).setFaultRicezione(transazioneDB.getFaultIntegrazione().getBytes());
                    }
                }
            }
            if (this.risposta_errori && !errori.isEmpty()) {
                ((TransazioneDettaglioRisposta)risposta).setDettagliErrore(new ArrayList());
                for (String errore : errori) {
                    ((TransazioneDettaglioRisposta)risposta).getDettagliErrore().add(errore);
                }
            }
            ((Transazione)transazione).setRisposta((TransazioneDettaglioRisposta)risposta);
        }
        Object api = null;
        api = extended ? new TransazioneExtInformazioniApi() : new TransazioneInformazioniApi();
        if (extended) {
            if (this.api_erogatoreExtraInfo && transazioneDB.getNomeSoggettoErogatore() != null && transazioneDB.getTipoSoggettoErogatore() != null) {
                String idPorta = transazioneDB.getIdportaSoggettoErogatore();
                if (idPorta == null || "".equals(idPorta)) {
                    idPorta = protocolFactory.createTraduttore().getIdentificativoPortaDefault(new IDSoggetto(transazioneDB.getTipoSoggettoErogatore(), transazioneDB.getNomeSoggettoErogatore()));
                }
                api.setInformazioniErogatore(this._newTransazioneSoggetto(transazioneDB.getTipoSoggettoErogatore(), idPorta, transazioneDB.getIndirizzoSoggettoErogatore()));
            }
            if (this.api_tipo) {
                api.setTipo(transazioneDB.getTipoServizio());
            }
        }
        if (this.api_erogatore) {
            api.setErogatore(transazioneDB.getNomeSoggettoErogatore());
        }
        if (this.api_tags && transazioneDB.getGruppi() != null && !"".equals(transazioneDB.getGruppi()) && (tmp = transazioneDB.getGruppi().split(",")) != null && tmp.length > 0) {
            api.setTags(new ArrayList());
            for (String tag : tmp) {
                if (tag == null || "".equals(tag.trim())) continue;
                api.addTagsItem(tag.trim());
            }
        }
        if (this.api_nome) {
            api.setNome(transazioneDB.getNomeServizio());
        }
        if (this.api_versione) {
            api.setVersione(Integer.valueOf(transazioneDB.getVersioneServizio()));
        }
        if (this.api_operazione) {
            api.setOperazione(transazioneDB.getAzione());
        }
        if (extended) {
            ProfiloDiCollaborazione prof;
            if (this.api_idAsincrono) {
                api.setIdAsincrono(transazioneDB.getIdAsincrono());
            }
            if (this.api_profiloCollaborazione && transazioneDB.getProfiloCollaborazioneOp2() != null && (prof = ProfiloDiCollaborazione.toProfiloDiCollaborazione((String)transazioneDB.getProfiloCollaborazioneOp2())) != null) {
                switch (prof) {
                    case ONEWAY: {
                        api.setProfiloCollaborazione(ProfiloCollaborazioneEnum.ONEWAY);
                        break;
                    }
                    case SINCRONO: {
                        api.setProfiloCollaborazione(ProfiloCollaborazioneEnum.SINCRONO);
                        break;
                    }
                    case ASINCRONO_SIMMETRICO: {
                        api.setProfiloCollaborazione(ProfiloCollaborazioneEnum.ASINCRONOSIMMETRICO);
                        break;
                    }
                    case ASINCRONO_ASIMMETRICO: {
                        api.setProfiloCollaborazione(ProfiloCollaborazioneEnum.ASINCRONOASIMMETRICO);
                        break;
                    }
                }
            }
            transazione.setApi(api);
        } else {
            ((Transazione)transazione).setApi((TransazioneInformazioniApi)api);
        }
        Object mittente = null;
        mittente = extended ? new TransazioneExtInformazioniMittente() : new TransazioneInformazioniMittente();
        if (extended) {
            IDServizioApplicativo idSA;
            if (this.mittente_fruitoreExtraInfo && transazioneDB.getNomeSoggettoFruitore() != null && transazioneDB.getTipoSoggettoFruitore() != null) {
                String idPorta = transazioneDB.getIdportaSoggettoFruitore();
                if (idPorta == null || "".equals(idPorta)) {
                    idPorta = protocolFactory.createTraduttore().getIdentificativoPortaDefault(new IDSoggetto(transazioneDB.getTipoSoggettoFruitore(), transazioneDB.getNomeSoggettoFruitore()));
                }
                mittente.setInformazioniFruitore(this._newTransazioneSoggetto(transazioneDB.getTipoSoggettoFruitore(), idPorta, transazioneDB.getIndirizzoSoggettoFruitore()));
            }
            if (this.mittente_applicativo) {
                mittente.setApplicativo(transazioneDB.getServizioApplicativoFruitore());
            }
            if (this.mittente_credenziali) {
                mittente.setCredenziali(transazioneDB.getCredenziali());
            }
            if (this.mittente_applicativoToken && credenzialiMittente != null && credenzialiMittente.getTokenClientId() != null && (idSA = CredenzialeTokenClient.convertApplicationDBValueToOriginal((String)credenzialiMittente.getTokenClientId().getCredenziale())) != null) {
                mittente.setApplicativoToken(new TransazioneExtInformazioniMittenteApplicativoToken());
                mittente.getApplicativoToken().setNome(idSA.getNome());
                mittente.getApplicativoToken().setSoggetto(idSA.getIdSoggettoProprietario().getNome());
                String idPorta = protocolFactory.createTraduttore().getIdentificativoPortaDefault(new IDSoggetto(idSA.getIdSoggettoProprietario().getTipo(), idSA.getIdSoggettoProprietario().getNome()));
                mittente.getApplicativoToken().setInformazioniSoggetto(this._newTransazioneSoggetto(idSA.getIdSoggettoProprietario().getTipo(), idPorta, null));
            }
        }
        if (this.mittente_principal && credenzialiMittente != null && credenzialiMittente.getTrasporto() != null) {
            mittente.setPrincipal(credenzialiMittente.getTrasporto().getCredenziale());
        }
        if (this.mittente_fruitore) {
            mittente.setFruitore(transazioneDB.getNomeSoggettoFruitore());
        }
        if (this.mittente_utente && credenzialiMittente != null && credenzialiMittente.getTokenUsername() != null) {
            mittente.setUtente(credenzialiMittente.getTokenUsername().getCredenziale());
        }
        if (this.mittente_client && credenzialiMittente != null && credenzialiMittente.getTokenClientId() != null) {
            mittente.setClient(CredenzialeTokenClient.convertClientIdDBValueToOriginal((String)credenzialiMittente.getTokenClientId().getCredenziale()));
        }
        if (this.mittente_indirizzoClient) {
            mittente.setIndirizzoClient(transazioneDB.getSocketClientAddress());
        }
        if (this.mittente_indirizzoClientInoltrato) {
            mittente.setIndirizzoClientInoltrato(transazioneDB.getTransportClientAddress());
        }
        if (extended) {
            if (this.mittente_tokenClaims && credenzialiMittente != null || this.mittente_token && transazioneDB.getTokenInfo() != null) {
                TransazioneExtInformazioniToken informazioniToken = new TransazioneExtInformazioniToken();
                boolean add = false;
                if (this.mittente_tokenClaims && credenzialiMittente != null) {
                    if (credenzialiMittente.getTokenClientId() != null) {
                        informazioniToken.setClientId(CredenzialeTokenClient.convertClientIdDBValueToOriginal((String)credenzialiMittente.getTokenClientId().getCredenziale()));
                        add = true;
                    }
                    if (credenzialiMittente.getTokenIssuer() != null) {
                        informazioniToken.setIssuer(credenzialiMittente.getTokenIssuer().getCredenziale());
                        add = true;
                    }
                    if (credenzialiMittente.getTokenSubject() != null) {
                        informazioniToken.setSubject(credenzialiMittente.getTokenSubject().getCredenziale());
                        add = true;
                    }
                    if (credenzialiMittente.getTokenUsername() != null) {
                        informazioniToken.setUsername(credenzialiMittente.getTokenUsername().getCredenziale());
                        add = true;
                    }
                    if (credenzialiMittente.getTokenEMail() != null) {
                        informazioniToken.setMail(credenzialiMittente.getTokenEMail().getCredenziale());
                        add = true;
                    }
                }
                if (transazioneDB.getTokenPurposeId() != null) {
                    informazioniToken.setPurposeId(transazioneDB.getTokenPurposeId());
                    add = true;
                }
                if (transazioneDB.getTokenId() != null) {
                    informazioniToken.setTokenId(transazioneDB.getTokenId());
                    add = true;
                }
                if (add) {
                    mittente.setInformazioniToken(informazioniToken);
                }
                if (this.mittente_token && transazioneDB.getTokenInfo() != null) {
                    mittente.setToken(transazioneDB.getTokenInfo().getBytes());
                }
            }
            transazione.setMittente(mittente);
        } else {
            ((Transazione)transazione).setMittente((TransazioneInformazioniMittente)mittente);
        }
        if (extended && messaggiDiagnostici != null && messaggiDiagnostici.size() > 0) {
            transazione.setDiagnostici(new ArrayList());
            for (MsgDiagnostico msgDiag : messaggiDiagnostici) {
                Diagnostico diag = new Diagnostico();
                diag.setCodice(msgDiag.getCodice());
                diag.setData(new DateTime(msgDiag.getGdo().getTime()));
                diag.setFunzione(msgDiag.getIdFunzione());
                diag.setMessaggio(msgDiag.getMessaggio());
                DiagnosticoSeveritaEnum severita = null;
                severita = 0 == msgDiag.getSeverita() ? DiagnosticoSeveritaEnum.FATAL : (2 == msgDiag.getSeverita() || 1 == msgDiag.getSeverita() ? DiagnosticoSeveritaEnum.ERROR : (4 == msgDiag.getSeverita() || 3 == msgDiag.getSeverita() ? DiagnosticoSeveritaEnum.INFO : (5 == msgDiag.getSeverita() || 6 == msgDiag.getSeverita() ? DiagnosticoSeveritaEnum.DEBUG : DiagnosticoSeveritaEnum.TRACE)));
                diag.setSeverita(severita);
                diag.setSeveritaCodice(msgDiag.getCodice());
                transazione.getDiagnostici().add(diag);
            }
        }
        return transazione;
    }

    private String normalizeUrl(String url) {
        if (url != null && url.startsWith("[") && url.contains("] ") && !url.endsWith("] ")) {
            return url.substring(url.indexOf("] ") + 2);
        }
        return url;
    }

    private TransazioneExtInformazioniSoggetto _newTransazioneSoggetto(String tipo, String codice, String indirizzo) {
        TransazioneExtInformazioniSoggetto soggetto = new TransazioneExtInformazioniSoggetto();
        soggetto.setTipo(tipo);
        soggetto.setCodice(codice);
        soggetto.setIndirizzo(indirizzo);
        return soggetto;
    }

    private TransazioneContenutoMessaggio newTransazioneContenutoMessaggio(org.openspcoop2.core.transazioni.Transazione transazioneDB, TipoMessaggio tipoMessaggioNormale, TipoMessaggio tipoMessaggioBinario, boolean extended) {
        DumpMessaggio dumpMessaggio = null;
        if (transazioneDB.sizeDumpMessaggioList() > 0) {
            for (Object check : transazioneDB.getDumpMessaggioList()) {
                if (!tipoMessaggioBinario.equals((Object)check.getTipoMessaggio())) continue;
                dumpMessaggio = check;
                break;
            }
            if (dumpMessaggio == null) {
                for (Object check : transazioneDB.getDumpMessaggioList()) {
                    if (!tipoMessaggioNormale.equals((Object)check.getTipoMessaggio())) continue;
                    dumpMessaggio = check;
                    break;
                }
            }
        }
        if (dumpMessaggio == null) {
            return null;
        }
        Object msg = null;
        msg = extended ? new TransazioneExtContenutoMessaggio() : new TransazioneContenutoMessaggio();
        msg.setBody(dumpMessaggio.getBody());
        if (dumpMessaggio.sizeHeaderTrasportoList() > 0) {
            msg.setHeaders(new ArrayList());
            for (DumpHeaderTrasporto dumpHeaderTrasporto : dumpMessaggio.getHeaderTrasportoList()) {
                TransazioneContenutoMessaggioHeader hdr = new TransazioneContenutoMessaggioHeader();
                hdr.setNome(dumpHeaderTrasporto.getNome());
                hdr.setValore(dumpHeaderTrasporto.getValore());
                msg.getHeaders().add(hdr);
            }
        }
        if (extended && dumpMessaggio.getContentType() != null) {
            TransazioneExtContenutoMessaggioBody body = new TransazioneExtContenutoMessaggioBody();
            body.setFormato(this._convert(dumpMessaggio.getFormatoMessaggio()));
            body.setContentType(dumpMessaggio.getContentType());
            body.setContentLength(dumpMessaggio.getContentLength());
            if (dumpMessaggio.getMultipartContentId() != null || dumpMessaggio.getMultipartContentLocation() != null || dumpMessaggio.getMultipartContentType() != null || dumpMessaggio.sizeMultipartHeaderList() > 0) {
                TransazioneExtContenutoMessaggioBodyMultipart multipart = new TransazioneExtContenutoMessaggioBodyMultipart();
                multipart.setContentId(dumpMessaggio.getMultipartContentId());
                multipart.setContentType(dumpMessaggio.getMultipartContentType());
                multipart.setContentLocation(dumpMessaggio.getMultipartContentLocation());
                if (dumpMessaggio.sizeMultipartHeaderList() > 0) {
                    multipart.setHeaders(new ArrayList());
                    for (DumpMultipartHeader dumpHeaderTrasporto : dumpMessaggio.getMultipartHeaderList()) {
                        TransazioneContenutoMessaggioHeader hdr = new TransazioneContenutoMessaggioHeader();
                        hdr.setNome(dumpHeaderTrasporto.getNome());
                        hdr.setValore(dumpHeaderTrasporto.getValore());
                        multipart.getHeaders().add(hdr);
                    }
                }
                body.setMultipart(multipart);
            }
            if (dumpMessaggio.sizeContenutoList() > 0) {
                body.setContenutiBody(new ArrayList());
                for (DumpContenuto contenuto : dumpMessaggio.getContenutoList()) {
                    TransazioneExtContenutoMessaggioPorzioneBody r = new TransazioneExtContenutoMessaggioPorzioneBody();
                    r.setNome(contenuto.getNome());
                    r.setValore(contenuto.getValore());
                    body.getContenutiBody().add(r);
                }
            }
            msg.setInformazioniBody(body);
            if (dumpMessaggio.sizeAllegatoList() > 0) {
                msg.setAttachments(new ArrayList());
                for (DumpAllegato dumpAllegato : dumpMessaggio.getAllegatoList()) {
                    TransazioneExtContenutoMessaggioAllegato attach = new TransazioneExtContenutoMessaggioAllegato();
                    attach.setContentId(dumpAllegato.getContentId());
                    attach.setContentType(dumpAllegato.getContentType());
                    attach.setContentLocation(dumpAllegato.getContentLocation());
                    attach.setContenuto(dumpAllegato.getAllegato());
                    if (dumpAllegato.sizeHeaderList() > 0) {
                        dumpAllegato.setHeaderList(new ArrayList());
                        for (DumpHeaderAllegato dumpHeaderAllegato : dumpAllegato.getHeaderList()) {
                            TransazioneContenutoMessaggioHeader hdr = new TransazioneContenutoMessaggioHeader();
                            hdr.setNome(dumpHeaderAllegato.getNome());
                            hdr.setValore(dumpHeaderAllegato.getValore());
                            attach.getHeaders().add(hdr);
                        }
                    }
                    msg.getAttachments().add(attach);
                }
            }
        }
        return msg;
    }

    private TransazioneMessaggioFormatoEnum _convert(String formato) {
        if (formato == null) {
            return null;
        }
        MessageType tipoMessaggio = null;
        try {
            tipoMessaggio = MessageType.valueOf((String)formato);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tipoMessaggio == null) {
            return null;
        }
        switch (tipoMessaggio) {
            case SOAP_11: {
                return TransazioneMessaggioFormatoEnum.SOAP11;
            }
            case SOAP_12: {
                return TransazioneMessaggioFormatoEnum.SOAP12;
            }
            case JSON: {
                return TransazioneMessaggioFormatoEnum.JSON;
            }
            case XML: {
                return TransazioneMessaggioFormatoEnum.XML;
            }
            case BINARY: {
                return TransazioneMessaggioFormatoEnum.BINARY;
            }
            case MIME_MULTIPART: {
                return TransazioneMessaggioFormatoEnum.MULTIPART;
            }
        }
        return null;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public void setThrowInitProtocol(boolean throwInitProtocol) {
        this.throwInitProtocol = throwInitProtocol;
    }

    public void setEmittente(boolean emittente) {
        this.emittente = emittente;
    }

    public void setDataEmissione(boolean dataEmissione) {
        this.dataEmissione = dataEmissione;
    }

    public void setId(boolean id) {
        this.id = id;
    }

    public void setIdConversazione(boolean idConversazione) {
        this.idConversazione = idConversazione;
    }

    public void setRuolo(boolean ruolo) {
        this.ruolo = ruolo;
    }

    public void setEsito(boolean esito) {
        this.esito = esito;
    }

    public void setMessaggi_id(boolean messaggi_id) {
        this.messaggi_id = messaggi_id;
    }

    public void setMessaggi_idApplicativo(boolean messaggi_idApplicativo) {
        this.messaggi_idApplicativo = messaggi_idApplicativo;
    }

    public void setMessaggi_data(boolean messaggi_data) {
        this.messaggi_data = messaggi_data;
    }

    public void setMessaggi_contenuti(boolean messaggi_contenuti) {
        this.messaggi_contenuti = messaggi_contenuti;
    }

    public void setRichiesta_tipo(boolean richiesta_tipo) {
        this.richiesta_tipo = richiesta_tipo;
    }

    public void setRichiesta_urlInvocazione(boolean richiesta_urlInvocazione) {
        this.richiesta_urlInvocazione = richiesta_urlInvocazione;
    }

    public void setRisposta_esito(boolean risposta_esito) {
        this.risposta_esito = risposta_esito;
    }

    public void setRisposta_fault(boolean risposta_fault) {
        this.risposta_fault = risposta_fault;
    }

    public void setRisposta_errori(boolean risposta_errori) {
        this.risposta_errori = risposta_errori;
    }

    public void setApi_erogatore(boolean api_erogatore) {
        this.api_erogatore = api_erogatore;
    }

    public void setApi_nome(boolean api_nome) {
        this.api_nome = api_nome;
    }

    public void setApi_versione(boolean api_versione) {
        this.api_versione = api_versione;
    }

    public void setApi_operazione(boolean api_operazione) {
        this.api_operazione = api_operazione;
    }

    public void setMittente_fruitore(boolean mittente_fruitore) {
        this.mittente_fruitore = mittente_fruitore;
    }

    public void setMittente_principal(boolean mittente_principal) {
        this.mittente_principal = mittente_principal;
    }

    public void setMittente_utente(boolean mittente_utente) {
        this.mittente_utente = mittente_utente;
    }

    public void setMittente_client(boolean mittente_client) {
        this.mittente_client = mittente_client;
    }

    public void setMittente_indirizzoClient(boolean mittente_indirizzoClient) {
        this.mittente_indirizzoClient = mittente_indirizzoClient;
    }

    public void setMittente_indirizzoClientInoltrato(boolean mittente_indirizzoClientInoltrato) {
        this.mittente_indirizzoClientInoltrato = mittente_indirizzoClientInoltrato;
    }

    public void setProfilo(boolean profilo) {
        this.profilo = profilo;
    }

    public void setContesto(boolean contesto) {
        this.contesto = contesto;
    }

    public void setIdCluster(boolean idCluster) {
        this.idCluster = idCluster;
    }

    public void setEmittenteExtraInfo(boolean emittenteExtraInfo) {
        this.emittenteExtraInfo = emittenteExtraInfo;
    }

    public void setStato(boolean stato) {
        this.stato = stato;
    }

    public void setMessaggi_dimensione(boolean messaggi_dimensione) {
        this.messaggi_dimensione = messaggi_dimensione;
    }

    public void setMessaggi_dataAccettazione(boolean messaggi_dataAccettazione) {
        this.messaggi_dataAccettazione = messaggi_dataAccettazione;
    }

    public void setMessaggi_duplicati(boolean messaggi_duplicati) {
        this.messaggi_duplicati = messaggi_duplicati;
    }

    public void setMessaggi_tracciaProtocollo(boolean messaggi_tracciaProtocollo) {
        this.messaggi_tracciaProtocollo = messaggi_tracciaProtocollo;
    }

    public void setRichiesta_connettore(boolean richiesta_connettore) {
        this.richiesta_connettore = richiesta_connettore;
    }

    public void setDiagnostici(boolean diagnostici) {
        this.diagnostici = diagnostici;
    }

    public void setApi_erogatoreExtraInfo(boolean api_erogatoreExtraInfo) {
        this.api_erogatoreExtraInfo = api_erogatoreExtraInfo;
    }

    public void setApi_tags(boolean api_tags) {
        this.api_tags = api_tags;
    }

    public void setApi_tipo(boolean api_tipo) {
        this.api_tipo = api_tipo;
    }

    public void setApi_idAsincrono(boolean api_idAsincrono) {
        this.api_idAsincrono = api_idAsincrono;
    }

    public void setApi_profiloCollaborazione(boolean api_profiloCollaborazione) {
        this.api_profiloCollaborazione = api_profiloCollaborazione;
    }

    public void setMittente_fruitoreExtraInfo(boolean mittente_fruitoreExtraInfo) {
        this.mittente_fruitoreExtraInfo = mittente_fruitoreExtraInfo;
    }

    public void setMittente_applicativo(boolean mittente_applicativo) {
        this.mittente_applicativo = mittente_applicativo;
    }

    public void setMittente_credenziali(boolean mittente_credenziali) {
        this.mittente_credenziali = mittente_credenziali;
    }

    public void setMittente_token(boolean mittente_token) {
        this.mittente_token = mittente_token;
    }

    public void setMittente_tokenClaims(boolean mittente_tokenClaims) {
        this.mittente_tokenClaims = mittente_tokenClaims;
    }
}

