/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.traccia;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Properties;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.pdd.logger.traccia.TracciaException;
import org.openspcoop2.utils.json.JacksonJsonUtils;
import org.openspcoop2.utils.json.JacksonXmlUtils;
import org.openspcoop2.utils.service.beans.TransazioneBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Serializer {
    private boolean prettyPrint = false;
    private String xml_namespace = "http://govway.org/traccia";
    private String xml_localName = "traccia";

    public Serializer() {
    }

    public Serializer(Properties pConf) throws TracciaException {
        try {
            Field[] fields;
            for (Field field : fields = Serializer.class.getDeclaredFields()) {
                String fieldName = field.getName();
                if (!pConf.containsKey(fieldName = fieldName.replace("_", "."))) continue;
                String value = pConf.getProperty(fieldName);
                String bCN = Boolean.TYPE.getName();
                if (bCN.equals(field.getType().getName())) {
                    field.set(this, "true".equalsIgnoreCase(value));
                    continue;
                }
                field.set(this, value);
            }
        }
        catch (Exception e) {
            throw new TracciaException(e.getMessage(), e);
        }
    }

    public byte[] toJsonByteArray(TransazioneBase transazione) throws TracciaException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.toJson(bout, transazione);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new TracciaException(e.getMessage(), e);
        }
    }

    public String toJson(TransazioneBase transazione) throws TracciaException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.toJson(bout, transazione);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new TracciaException(e.getMessage(), e);
        }
    }

    public void toJson(OutputStream os, TransazioneBase transazione) throws TracciaException {
        try {
            JacksonJsonUtils jsonUtils = JacksonJsonUtils.getInstance((boolean)this.prettyPrint);
            jsonUtils.writeTo((Object)transazione, os);
        }
        catch (Exception e) {
            throw new TracciaException(e.getMessage(), e);
        }
    }

    public byte[] toXmlByteArray(TransazioneBase transazione) throws TracciaException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.toXml(bout, transazione);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new TracciaException(e.getMessage(), e);
        }
    }

    public String toXml(TransazioneBase transazione) throws TracciaException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.toXml(bout, transazione);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new TracciaException(e.getMessage(), e);
        }
    }

    public void toXml(OutputStream os, TransazioneBase transazione) throws TracciaException {
        try {
            JacksonXmlUtils jacksonXmlUtils = JacksonXmlUtils.getInstance((boolean)this.prettyPrint);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            jacksonXmlUtils.writeTo((Object)transazione, (OutputStream)bout);
            bout.flush();
            bout.close();
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Element element = xmlUtils.newElement(bout.toByteArray());
            Document dom = xmlUtils.newDocument();
            Element elementNew = dom.createElementNS(this.xml_namespace, this.xml_localName);
            NodeList list = element.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                Node nAdopt = dom.adoptNode(n.cloneNode(true));
                elementNew.appendChild(nAdopt);
            }
            xmlUtils.writeTo(elementNew, os);
        }
        catch (Exception e) {
            throw new TracciaException(e.getMessage(), e);
        }
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setXml_namespace(String xml_namespace) {
        this.xml_namespace = xml_namespace;
    }

    public void setXml_localName(String xml_localName) {
        this.xml_localName = xml_localName;
    }
}

