/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.transazioni;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.utils.OpenSPCoopAppenderUtilities;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.dao.ITransazioneService;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.core.transazioni.utils.TransazioneDaoExt;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.UpdateField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.sdk.transaction.FaseTracciamento;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.transazioni.ISalvataggioDiagnosticiManager;
import org.openspcoop2.pdd.core.handlers.transazioni.ISalvataggioTracceManager;
import org.openspcoop2.pdd.core.token.InformazioniNegoziazioneToken;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.attribute_authority.InformazioniAttributi;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.logger.DumpOpenSPCoopProtocolAppender;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.MsgDiagnosticoOpenSPCoopProtocolAppender;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.TracciamentoOpenSPCoopProtocolAppender;
import org.openspcoop2.pdd.logger.filetrace.FileTraceConfig;
import org.openspcoop2.pdd.logger.filetrace.FileTraceManager;
import org.openspcoop2.pdd.logger.transazioni.ConfigurazioneTracciamento;
import org.openspcoop2.pdd.logger.transazioni.InformazioniTransazione;
import org.openspcoop2.pdd.logger.transazioni.TransazioneUtilities;
import org.openspcoop2.pdd.logger.transazioni.TransazioniProcessTimes;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaProducer;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.date.UnitaTemporale;
import org.slf4j.Logger;

public class TracciamentoManager {
    private boolean transazioniEnabled = true;
    private DAOFactory daoFactory = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesTransazioni = null;
    private Logger daoFactoryLoggerTransazioni = null;
    private OpenSPCoop2Properties openspcoopProperties = null;
    private ConfigurazionePdDManager configPdDManager = null;
    private boolean debug = false;
    private ITracciaProducer tracciamentoOpenSPCoopAppender = null;
    private IDiagnosticProducer msgDiagnosticiOpenSPCoopAppender = null;
    private IDumpProducer dumpOpenSPCoopAppender = null;
    private boolean transazioniRegistrazioneTracceProtocolPropertiesEnabled = false;
    private boolean transazioniRegistrazioneTracceHeaderRawEnabled = false;
    private boolean transazioniRegistrazioneTracceDigestEnabled = false;
    private ISalvataggioTracceManager salvataggioTracceManager = null;
    private ISalvataggioDiagnosticiManager salvataggioDiagnosticiManager = null;
    private boolean transazioniRegistrazioneDumpHeadersCompactEnabled = false;
    private FaseTracciamento fase;
    private boolean usePdDConnection = true;
    private String tipoDatabaseRuntime = null;
    private Logger log = null;
    private Logger logSql = null;
    private static final String TIPO_RECOVERY_FS = "__timerFileSystemRecovery";
    private static final MapKey<String> DISABLE_TRANSACTION_FILTER = org.openspcoop2.utils.Map.newMapKey((String)"DISABLE_TRANSACTION_FILTER");
    private static final MapKey<String> DISABLE_TRANSACTION_FILTER_DB = org.openspcoop2.utils.Map.newMapKey((String)"DISABLE_TRANSACTION_FILTER_DB");
    private static final MapKey<String> DISABLE_TRANSACTION_FILTER_FILETRACE = org.openspcoop2.utils.Map.newMapKey((String)"DISABLE_TRANSACTION_FILTER_FILETRACE");
    private static final MapKey<String> TRACKING_EXCEPTION = org.openspcoop2.utils.Map.newMapKey((String)"TRACKING_EXCEPTION");
    private static final MapKey<String> TRACKING_EXCEPTION_PHASE = org.openspcoop2.utils.Map.newMapKey((String)"TRACKING_EXCEPTION_PHASE");
    private static final MapKey<String> TRANSACTION_REGISTERED = org.openspcoop2.utils.Map.newMapKey((String)"TRANSACTION_REGISTERED");

    public boolean isTransazioniEnabled() {
        return this.transazioniEnabled;
    }

    public OpenSPCoop2Properties getOpenspcoopProperties() {
        return this.openspcoopProperties;
    }

    public void logDebug(String msg) {
        if (this.log != null) {
            this.log.debug(msg);
        }
    }

    public void logDebug(String msg, Exception e) {
        if (this.log != null) {
            this.log.debug(msg, (Throwable)e);
        }
    }

    public void logWarn(String msg) {
        if (this.log != null) {
            this.log.warn(msg);
        }
    }

    public void logError(String msg) {
        if (this.log != null) {
            this.log.error(msg);
        }
    }

    public void logError(String msg, Throwable e) {
        if (this.log != null) {
            this.log.error(msg, e);
        }
    }

    public void logSqlDebug(String msg) {
        if (this.logSql != null) {
            this.logSql.debug(msg);
        }
    }

    public TracciamentoManager(FaseTracciamento fase) throws CoreException {
        this.fase = fase;
        this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        this.transazioniEnabled = this.openspcoopProperties.isTransazioniEnabled();
        if (!this.transazioniEnabled) {
            return;
        }
        this.debug = this.openspcoopProperties.isTransazioniDebug();
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioni(this.debug);
        this.logSql = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniSql(this.debug);
        this.tipoDatabaseRuntime = this.openspcoopProperties.getDatabaseType();
        if (this.tipoDatabaseRuntime == null) {
            throw new CoreException("Tipo Database non definito");
        }
        this.configPdDManager = ConfigurazionePdDManager.getInstance();
        this.initTransactionResources();
        this.usePdDConnection = true;
        if (FaseTracciamento.POST_OUT_RESPONSE.equals((Object)this.fase)) {
            this.initTracciamento(this.tipoDatabaseRuntime, this.usePdDConnection);
        }
        if (FaseTracciamento.POST_OUT_RESPONSE.equals((Object)this.fase)) {
            this.initDiagnostica(this.tipoDatabaseRuntime, this.usePdDConnection);
            this.initDump(this.tipoDatabaseRuntime, this.usePdDConnection);
        }
        this.initConfigurazioneTracciamento();
    }

    private void initTransactionResources() throws CoreException {
        try {
            DAOFactoryProperties daoFactoryProperties = null;
            this.daoFactoryLoggerTransazioni = this.logSql;
            this.daoFactory = DAOFactory.getInstance((Logger)this.daoFactoryLoggerTransazioni);
            daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)this.daoFactoryLoggerTransazioni);
            this.daoFactoryServiceManagerPropertiesTransazioni = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)ProjectInfo.getInstance());
            this.daoFactoryServiceManagerPropertiesTransazioni.setShowSql(this.debug);
            this.daoFactoryServiceManagerPropertiesTransazioni.setDatabaseType(DBTransazioniManager.getInstance().getTipoDatabase());
        }
        catch (Exception e) {
            throw new CoreException("Errore durante l'inizializzazione delle risorse per l'accesso al database: " + e.getMessage(), (Throwable)e);
        }
    }

    private void initTracciamento(String tipoDatabaseRuntime, boolean usePdDConnection) throws CoreException {
        try {
            this.tracciamentoOpenSPCoopAppender = new TracciamentoOpenSPCoopProtocolAppender();
            OpenspcoopAppender tracciamentoOpenSPCoopAppenderEngine = new OpenspcoopAppender();
            tracciamentoOpenSPCoopAppenderEngine.setTipo(TIPO_RECOVERY_FS);
            ArrayList tracciamentoOpenSPCoopAppenderProperties = new ArrayList();
            OpenSPCoopAppenderUtilities.addParameters((Logger)this.daoFactoryLoggerTransazioni, tracciamentoOpenSPCoopAppenderProperties, null, null, null, null, null, (String)tipoDatabaseRuntime, (boolean)usePdDConnection, (boolean)this.debug);
            OpenSPCoopAppenderUtilities.addCheckProperties(tracciamentoOpenSPCoopAppenderProperties, (boolean)false);
            tracciamentoOpenSPCoopAppenderEngine.setPropertyList(tracciamentoOpenSPCoopAppenderProperties);
            this.tracciamentoOpenSPCoopAppender.initializeAppender(tracciamentoOpenSPCoopAppenderEngine);
            this.tracciamentoOpenSPCoopAppender.isAlive();
        }
        catch (Exception e) {
            throw new CoreException("Errore durante l'inizializzazione del TracciamentoAppender: " + e.getMessage(), (Throwable)e);
        }
    }

    private void initDiagnostica(String tipoDatabaseRuntime, boolean usePdDConnection) throws CoreException {
        try {
            this.msgDiagnosticiOpenSPCoopAppender = new MsgDiagnosticoOpenSPCoopProtocolAppender();
            OpenspcoopAppender diagnosticoOpenSPCoopAppenderEngine = new OpenspcoopAppender();
            diagnosticoOpenSPCoopAppenderEngine.setTipo(TIPO_RECOVERY_FS);
            ArrayList diagnosticoOpenSPCoopAppenderProperties = new ArrayList();
            OpenSPCoopAppenderUtilities.addParameters((Logger)this.daoFactoryLoggerTransazioni, diagnosticoOpenSPCoopAppenderProperties, null, null, null, null, null, (String)tipoDatabaseRuntime, (boolean)usePdDConnection, (boolean)this.debug);
            OpenSPCoopAppenderUtilities.addCheckProperties(diagnosticoOpenSPCoopAppenderProperties, (boolean)false);
            diagnosticoOpenSPCoopAppenderEngine.setPropertyList(diagnosticoOpenSPCoopAppenderProperties);
            this.msgDiagnosticiOpenSPCoopAppender.initializeAppender(diagnosticoOpenSPCoopAppenderEngine);
            this.msgDiagnosticiOpenSPCoopAppender.isAlive();
        }
        catch (Exception e) {
            throw new CoreException("Errore durante l'inizializzazione del DiagnosticoAppender: " + e.getMessage(), (Throwable)e);
        }
    }

    private void initDump(String tipoDatabaseRuntime, boolean usePdDConnection) throws CoreException {
        try {
            this.dumpOpenSPCoopAppender = new DumpOpenSPCoopProtocolAppender();
            OpenspcoopAppender dumpOpenSPCoopAppenderEngine = new OpenspcoopAppender();
            dumpOpenSPCoopAppenderEngine.setTipo(TIPO_RECOVERY_FS);
            ArrayList dumpOpenSPCoopAppenderProperties = new ArrayList();
            OpenSPCoopAppenderUtilities.addParameters((Logger)this.daoFactoryLoggerTransazioni, dumpOpenSPCoopAppenderProperties, null, null, null, null, null, (String)tipoDatabaseRuntime, (boolean)usePdDConnection, (boolean)this.debug);
            OpenSPCoopAppenderUtilities.addCheckProperties(dumpOpenSPCoopAppenderProperties, (boolean)false);
            dumpOpenSPCoopAppenderEngine.setPropertyList(dumpOpenSPCoopAppenderProperties);
            this.dumpOpenSPCoopAppender.initializeAppender(dumpOpenSPCoopAppenderEngine);
            this.dumpOpenSPCoopAppender.isAlive();
        }
        catch (Exception e) {
            throw new CoreException("Errore durante l'inizializzazione del DumpAppender: " + e.getMessage(), (Throwable)e);
        }
    }

    private void initConfigurazioneTracciamento() throws CoreException {
        try {
            this.transazioniRegistrazioneTracceProtocolPropertiesEnabled = this.openspcoopProperties.isTransazioniRegistrazioneTracceProtocolPropertiesEnabled();
            this.transazioniRegistrazioneTracceHeaderRawEnabled = this.openspcoopProperties.isTransazioniRegistrazioneTracceHeaderRawEnabled();
            this.transazioniRegistrazioneTracceDigestEnabled = this.openspcoopProperties.isTransazioniRegistrazioneTracceDigestEnabled();
            this.transazioniRegistrazioneDumpHeadersCompactEnabled = this.openspcoopProperties.isTransazioniRegistrazioneDumpHeadersCompactEnabled();
            this.salvataggioTracceManager = this.openspcoopProperties.getTransazioniRegistrazioneTracceManager();
            this.salvataggioDiagnosticiManager = this.openspcoopProperties.getTransazioniRegistrazioneDiagnosticiManager();
        }
        catch (Exception e) {
            throw new CoreException("Errore durante la lettura della configurazione della registrazione di tracce/diagnostici: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private boolean existsTransactionFilter(InformazioniTransazione info) {
        return info != null && info.getContext() != null && info.getContext().containsKey(DISABLE_TRANSACTION_FILTER);
    }

    private String getTransactionFilter(InformazioniTransazione info) {
        return info != null && info.getContext() != null ? (String)info.getContext().get(DISABLE_TRANSACTION_FILTER) : null;
    }

    private void disableTransactionFilter(InformazioniTransazione info) {
        if (!this.existsTransactionFilter(info) && info != null && info.getContext() != null) {
            info.getContext().put(DISABLE_TRANSACTION_FILTER, (Object)this.fase.name());
        }
    }

    private boolean existsTransactionFilterDB(InformazioniTransazione info) {
        return info != null && info.getContext() != null && info.getContext().containsKey(DISABLE_TRANSACTION_FILTER_DB);
    }

    private void disableTransactionFilterDB(InformazioniTransazione info) {
        if (!this.existsTransactionFilter(info) && info != null && info.getContext() != null) {
            info.getContext().put(DISABLE_TRANSACTION_FILTER_DB, (Object)this.fase.name());
        }
    }

    private boolean existsTransactionFilterFileTrace(InformazioniTransazione info) {
        return info != null && info.getContext() != null && info.getContext().containsKey(DISABLE_TRANSACTION_FILTER_FILETRACE);
    }

    private void disableTransactionFilterFileTrace(InformazioniTransazione info) {
        if (!this.existsTransactionFilter(info) && info != null && info.getContext() != null) {
            info.getContext().put(DISABLE_TRANSACTION_FILTER_FILETRACE, (Object)this.fase.name());
        }
    }

    public void invoke(InformazioniTransazione info, String esitoContext, Map<String, List<String>> headerInUscita, MsgDiagnostico msgdiagErrore) throws HandlerException {
        this.invokeEngine(info, null, esitoContext, headerInUscita, msgdiagErrore);
    }

    public void invoke(InformazioniTransazione info, String esitoContext, MsgDiagnostico msgdiagErrore) throws HandlerException {
        this.invokeEngine(info, null, esitoContext, null, msgdiagErrore);
    }

    public void invoke(InformazioniTransazione info, EsitoTransazione esito, Map<String, List<String>> headerInUscita, MsgDiagnostico msgdiagErrore) throws HandlerException {
        this.invokeEngine(info, esito, null, headerInUscita, msgdiagErrore);
    }

    public void invoke(InformazioniTransazione info, EsitoTransazione esito) throws HandlerException {
        this.invokeEngine(info, esito, null, null, null);
    }

    private void invokeEngine(InformazioniTransazione info, EsitoTransazione esito, String esitoContext, Map<String, List<String>> headerInUscita, MsgDiagnostico msgdiagErrore) throws HandlerException {
        if (!this.transazioniEnabled) {
            return;
        }
        TransazioniProcessTimes times = null;
        long timeStart = -1L;
        if (this.openspcoopProperties.isTransazioniRegistrazioneSlowLog()) {
            times = new TransazioniProcessTimes();
            timeStart = DateManager.getTimeMillis();
        }
        try {
            this.invoke(info, esito, esitoContext, headerInUscita, msgdiagErrore, times);
        }
        catch (HandlerException he) {
            he.setIntegrationFunctionError(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE);
            throw he;
        }
        finally {
            long timeEnd;
            long timeProcess;
            if (times != null && (timeProcess = (timeEnd = DateManager.getTimeMillis()) - timeStart) >= (long)this.openspcoopProperties.getTransazioniRegistrazioneSlowLogThresholdMs()) {
                StringBuilder sb = new StringBuilder();
                sb.append(timeProcess);
                if (times.idTransazione != null) {
                    sb.append(" <").append(times.idTransazione).append(">");
                }
                sb.append(" [" + this.fase + "]");
                sb.append(" ").append(times.toString());
                String msg = sb.toString();
                OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniSlowLog().info(msg);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void invoke(InformazioniTransazione info, EsitoTransazione esito, String esitoContext, Map<String, List<String>> headerInUscita, MsgDiagnostico msgdiagErrore, TransazioniProcessTimes times) throws HandlerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[TRYBLOCK]], but top level block is 31[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ConfigurazioneTracciamento getConfigurazioneTracciamento(String idTransazione, Context context, TipoPdD tipoPorta, Transaction transaction) {
        if (context != null) {
            // empty if block
        }
        ConfigurazioneTracciamento configurazioneTracciamento = null;
        try {
            if (transaction != null && transaction.getRequestInfo() != null && transaction.getRequestInfo().getProtocolContext() != null && transaction.getRequestInfo().getProtocolContext().getInterfaceName() != null) {
                switch (tipoPorta) {
                    case DELEGATA: {
                        IDPortaDelegata idPD = new IDPortaDelegata();
                        idPD.setNome(transaction.getRequestInfo().getProtocolContext().getInterfaceName());
                        PortaDelegata pd = this.configPdDManager.getPortaDelegataSafeMethod(idPD, transaction.getRequestInfo());
                        configurazioneTracciamento = new ConfigurazioneTracciamento(this.log, this.configPdDManager, pd);
                        break;
                    }
                    case APPLICATIVA: {
                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                        idPA.setNome(transaction.getRequestInfo().getProtocolContext().getInterfaceName());
                        PortaApplicativa pa = this.configPdDManager.getPortaApplicativaSafeMethod(idPA, transaction.getRequestInfo());
                        configurazioneTracciamento = new ConfigurazioneTracciamento(this.log, this.configPdDManager, pa);
                        break;
                    }
                }
            }
            if (configurazioneTracciamento == null) {
                configurazioneTracciamento = new ConfigurazioneTracciamento(this.log, this.configPdDManager, tipoPorta);
            }
        }
        catch (Exception e) {
            this.logDebug("[" + idTransazione + "] Errore avvenuto durante la lettura della configurazione del tracciamento: " + e.getMessage(), e);
        }
        return configurazioneTracciamento;
    }

    private void releaseResourcesEngine(Transaction transactionParam, String idTransazione, InformazioniTransazione info) {
        if (!FaseTracciamento.POST_OUT_RESPONSE.equals((Object)this.fase)) {
            return;
        }
        if (transactionParam != null) {
            // empty if block
        }
        Transaction transaction = null;
        try {
            transaction = TransactionContext.removeTransaction(idTransazione);
            if (transaction != null) {
                transaction.setDeleted();
            }
        }
        catch (Exception e) {
            this.logError("[" + idTransazione + "] Errore durante la rimozione della registrazione delle transazione", e);
        }
        if (info != null && info.getProtocollo() != null) {
            if (TipoPdD.APPLICATIVA.equals((Object)info.getTipoPorta()) && info.getProtocollo().getIdRichiesta() != null) {
                try {
                    TransactionContext.removeIdentificativoProtocollo(info.getProtocollo().getIdRichiesta());
                }
                catch (Exception e) {
                    this.logError("[" + idTransazione + "] Errore durante la rimozione della registrazione dell'identificativo di protocollo della richiesta [" + info.getProtocollo().getIdRichiesta() + "]", e);
                }
            }
            if (TipoPdD.DELEGATA.equals((Object)info.getTipoPorta()) && info.getProtocollo().getIdRisposta() != null) {
                try {
                    TransactionContext.removeIdentificativoProtocollo(info.getProtocollo().getIdRisposta());
                }
                catch (Exception e) {
                    this.logError("[" + idTransazione + "] Errore durante la rimozione della registrazione dell'identificativo di protocollo della risposta [" + info.getProtocollo().getIdRisposta() + "]", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HandlerException logWithFileTrace(File fileTraceConfig, boolean fileTraceConfigGlobal, TransazioniProcessTimes times, Transazione transazioneDTO, Transaction transaction, EsitoTransazione esito, InformazioniToken informazioniToken, InformazioniAttributi informazioniAttributi, InformazioniNegoziazioneToken informazioniNegoziazioneToken, SecurityToken securityToken, InformazioniTransazione info, Map<String, List<String>> headerInUscita, RequestInfo requestInfo, String idTransazione, boolean fileTraceEnabledBloccante, MsgDiagnostico msgdiagErrore, boolean existsAnotherFiletraceTrackingPhase) {
        FileTraceManager fileTraceManager = null;
        long timeStart = -1L;
        try {
            if (times != null) {
                timeStart = DateManager.getTimeMillis();
            }
            FileTraceConfig config = FileTraceConfig.getConfig(fileTraceConfig, fileTraceConfigGlobal);
            fileTraceManager = new FileTraceManager(this.log, config);
            fileTraceManager.buildTransazioneInfo(info.getProtocolFactory(), transazioneDTO, transaction, informazioniToken, informazioniAttributi, informazioniNegoziazioneToken, securityToken, info.getContext(), headerInUscita, this.fase);
            String hdrTest = this.openspcoopProperties.getTransazioniTestsuiteManuallyFaultHeaderFileTraceBeforeLog();
            if (hdrTest != null && requestInfo != null && requestInfo.getProtocolContext() != null && requestInfo.getProtocolContext().getHeaderFirstValue(hdrTest) != null && this.fase.name().equals(requestInfo.getProtocolContext().getHeaderFirstValue(hdrTest))) {
                throw new CoreException("Test Manually Exception generated (fileTrace) in phase '" + this.fase + "'");
            }
            fileTraceManager.invoke(info.getTipoPorta(), info.getContext(), requestInfo, TransazioneUtilities.convertToBusta(transazioneDTO), this.fase);
        }
        catch (Throwable e) {
            String error = "[" + idTransazione + "] File trace fallito: " + e.getMessage();
            this.logError(error, e);
            BooleanNullable changeEsito = BooleanNullable.NULL();
            StringBuilder errorLog = new StringBuilder();
            this.logRegistrazioneNonRiuscita(msgdiagErrore, true, e, idTransazione, transaction, changeEsito, errorLog);
            if (changeEsito.getValue() != null && changeEsito.getValue().booleanValue()) {
                esito = ServicesUtils.updateEsitoConAnomalie(esito, this.log, info.getProtocolFactory());
                transazioneDTO.setEsito(esito.getCode().intValue());
                if (transazioneDTO.getErrorLog() == null) {
                    transazioneDTO.setErrorLog(errorLog.toString());
                }
            }
            if (fileTraceEnabledBloccante) {
                HandlerException handlerException = new HandlerException(error, e);
                return handlerException;
            }
        }
        finally {
            try {
                if (!existsAnotherFiletraceTrackingPhase && fileTraceManager != null) {
                    fileTraceManager.cleanResourcesForOnlyFileTrace(transaction);
                }
            }
            catch (Exception eClean) {
                this.logError("[" + idTransazione + "] File trace 'clean' fallito: " + eClean.getMessage(), eClean);
            }
            if (times != null) {
                long timeProcess;
                long timeEnd = DateManager.getTimeMillis();
                times.fileTrace = timeProcess = timeEnd - timeStart;
            }
        }
        return null;
    }

    private void throwTrackingExceptionIfExists(InformazioniTransazione info) throws HandlerException {
        if (info != null && info.getContext() != null && info.getContext().containsKey(TRACKING_EXCEPTION)) {
            HandlerException e = (HandlerException)info.getContext().get(TRACKING_EXCEPTION);
            FaseTracciamento faseExc = (FaseTracciamento)info.getContext().get(TRACKING_EXCEPTION_PHASE);
            String label = null;
            label = FaseTracciamento.IN_REQUEST.equals((Object)faseExc) ? "Richiesta ricevuta" : (FaseTracciamento.OUT_REQUEST.equals((Object)faseExc) ? "Richiesta in consegna" : "Risposta in consegna");
            throw new HandlerException("database rilevato non disponibile nella fase '" + label + "': " + e.getMessage(), e);
        }
    }

    private void addTrackingException(InformazioniTransazione info, HandlerException e) {
        if (info != null && info.getContext() != null && !info.getContext().containsKey(TRACKING_EXCEPTION)) {
            boolean add = false;
            if (FaseTracciamento.OUT_REQUEST.equals((Object)this.fase) && this.openspcoopProperties.isTransazioniTracciamentoDBOutRequestThrowRequestException() || (FaseTracciamento.IN_REQUEST.equals((Object)this.fase) || FaseTracciamento.OUT_REQUEST.equals((Object)this.fase)) && (this.openspcoopProperties.isTransazioniTracciamentoDBOutResponseThrowRequestException() || this.openspcoopProperties.isTransazioniTracciamentoDBPostOutResponseThrowRequestException()) || FaseTracciamento.OUT_RESPONSE.equals((Object)this.fase) && this.openspcoopProperties.isTransazioniTracciamentoDBPostOutResponseThrowResponseException()) {
                add = true;
            }
            if (add) {
                info.getContext().put(TRACKING_EXCEPTION, (Object)e);
                info.getContext().put(TRACKING_EXCEPTION_PHASE, (Object)this.fase);
            }
        }
    }

    private boolean isTransactionAlreadyRegistered(InformazioniTransazione info) {
        return info != null && info.getContext() != null && info.getContext().containsKey(TRANSACTION_REGISTERED);
    }

    private void addTransactionAlreadyRegistered(InformazioniTransazione info) {
        if (info != null && info.getContext() != null) {
            info.getContext().put(TRANSACTION_REGISTERED, (Object)"true");
        }
    }

    private boolean registraTransazione(Transazione transazioneDTO, ITransazioneService transazioneService, InformazioniTransazione info, boolean autoCommit, boolean registraTracciaRichiestaInfoTransazione, boolean registraTracciaRispostaInfoTransazione) throws ServiceException, NotImplementedException, NotFoundException, ExpressionNotImplementedException, ExpressionException {
        if (FaseTracciamento.IN_REQUEST.equals((Object)this.fase) || !this.isTransactionAlreadyRegistered(info)) {
            transazioneService.create((Object)transazioneDTO);
            if (autoCommit && !FaseTracciamento.POST_OUT_RESPONSE.equals((Object)this.fase)) {
                this.addTransactionAlreadyRegistered(info);
            }
            return true;
        }
        if (FaseTracciamento.POST_OUT_RESPONSE.equals((Object)this.fase) && info.getTransazioneDaAggiornare() != null) {
            boolean isTransazioniUpdateUseDayInterval;
            ArrayList<UpdateField> list = new ArrayList<UpdateField>();
            list.add(new UpdateField(Transazione.model().ESITO, (Object)transazioneDTO.getEsito()));
            list.add(new UpdateField(Transazione.model().ESITO_SINCRONO, (Object)transazioneDTO.getEsitoSincrono()));
            list.add(new UpdateField(Transazione.model().ESITO_CONTESTO, (Object)transazioneDTO.getEsitoContesto()));
            list.add(new UpdateField(Transazione.model().CONSEGNE_MULTIPLE_IN_CORSO, (Object)transazioneDTO.getConsegneMultipleInCorso()));
            list.add(new UpdateField(Transazione.model().CODICE_RISPOSTA_USCITA, (Object)transazioneDTO.getCodiceRispostaUscita()));
            list.add(new UpdateField(Transazione.model().EVENTI_GESTIONE, (Object)transazioneDTO.getEventiGestione()));
            list.add(new UpdateField(Transazione.model().DATA_USCITA_RISPOSTA, (Object)transazioneDTO.getDataUscitaRisposta()));
            list.add(new UpdateField(Transazione.model().DATA_USCITA_RISPOSTA_STREAM, (Object)transazioneDTO.getDataUscitaRispostaStream()));
            list.add(new UpdateField(Transazione.model().RISPOSTA_INGRESSO_BYTES, (Object)transazioneDTO.getRispostaIngressoBytes()));
            list.add(new UpdateField(Transazione.model().RISPOSTA_USCITA_BYTES, (Object)transazioneDTO.getRispostaUscitaBytes()));
            list.add(new UpdateField(Transazione.model().FAULT_INTEGRAZIONE, (Object)transazioneDTO.getFaultIntegrazione()));
            list.add(new UpdateField(Transazione.model().FORMATO_FAULT_INTEGRAZIONE, (Object)transazioneDTO.getFormatoFaultIntegrazione()));
            list.add(new UpdateField(Transazione.model().FAULT_COOPERAZIONE, (Object)transazioneDTO.getFaultCooperazione()));
            list.add(new UpdateField(Transazione.model().FORMATO_FAULT_COOPERAZIONE, (Object)transazioneDTO.getFormatoFaultCooperazione()));
            list.add(new UpdateField(Transazione.model().ERROR_LOG, (Object)transazioneDTO.getErrorLog()));
            list.add(new UpdateField(Transazione.model().WARNING_LOG, (Object)transazioneDTO.getWarningLog()));
            if (this.salvataggioTracceManager != null) {
                if (registraTracciaRichiestaInfoTransazione) {
                    list.add(new UpdateField(Transazione.model().TRACCIA_RICHIESTA, (Object)transazioneDTO.getTracciaRichiesta()));
                }
                if (registraTracciaRispostaInfoTransazione) {
                    list.add(new UpdateField(Transazione.model().TRACCIA_RISPOSTA, (Object)transazioneDTO.getTracciaRisposta()));
                }
            }
            if (this.salvataggioDiagnosticiManager != null) {
                list.add(new UpdateField(Transazione.model().DIAGNOSTICI, (Object)transazioneDTO.getDiagnostici()));
                list.add(new UpdateField(Transazione.model().DIAGNOSTICI_LIST_1, (Object)transazioneDTO.getDiagnosticiList1()));
                list.add(new UpdateField(Transazione.model().DIAGNOSTICI_LIST_2, (Object)transazioneDTO.getDiagnosticiList2()));
                list.add(new UpdateField(Transazione.model().DIAGNOSTICI_LIST_EXT, (Object)transazioneDTO.getDiagnosticiListExt()));
                list.add(new UpdateField(Transazione.model().DIAGNOSTICI_EXT, (Object)transazioneDTO.getDiagnosticiExt()));
            }
            if (isTransazioniUpdateUseDayInterval = this.openspcoopProperties.isTransazioniUpdateUseDayInterval()) {
                IExpression condition = transazioneService.newExpression();
                Date left = DateUtils.convertToLeftInterval((Date)transazioneDTO.getDataIngressoRichiesta(), (UnitaTemporale)UnitaTemporale.GIORNALIERO);
                condition.greaterEquals(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)left);
                Date right = DateUtils.convertToRightInterval((Date)transazioneDTO.getDataIngressoRichiesta(), (UnitaTemporale)UnitaTemporale.GIORNALIERO);
                condition.lessEquals(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)right);
                transazioneService.updateFields((Object)transazioneDTO.getIdTransazione(), condition, list.toArray(new UpdateField[1]));
            } else {
                transazioneService.updateFields((Object)transazioneDTO.getIdTransazione(), list.toArray(new UpdateField[1]));
            }
            return false;
        }
        boolean isTransazioniUpdateUseDayInterval = this.openspcoopProperties.isTransazioniUpdateUseDayInterval();
        if (isTransazioniUpdateUseDayInterval) {
            TransazioneDaoExt ext = new TransazioneDaoExt(transazioneDTO);
            ext.setUseDayIntervalForUpdate(true);
            transazioneService.update((Object)transazioneDTO.getIdTransazione(), (Object)ext);
        } else {
            transazioneService.update((Object)transazioneDTO.getIdTransazione(), (Object)transazioneDTO);
        }
        return false;
    }

    private void logRegistrazioneNonRiuscita(MsgDiagnostico msgdiagErrore, boolean fileTrace, Throwable e, String idTransazione, Transaction transaction, BooleanNullable changeEsito, StringBuilder sbErrorLog) {
        if (fileTrace || !FaseTracciamento.POST_OUT_RESPONSE.equals((Object)this.fase)) {
            try {
                msgdiagErrore.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                msgdiagErrore.addKeyword("@TIPO_TRACCIA@", fileTrace ? "fileTrace" : "database");
                switch (this.fase) {
                    case IN_REQUEST: {
                        msgdiagErrore.addKeyword("@FASE_TRACCIAMENTO@", "Richiesta ricevuta");
                        break;
                    }
                    case OUT_REQUEST: {
                        msgdiagErrore.addKeyword("@FASE_TRACCIAMENTO@", "Richiesta in consegna");
                        break;
                    }
                    case OUT_RESPONSE: {
                        msgdiagErrore.addKeyword("@FASE_TRACCIAMENTO@", "Risposta in consegna");
                        break;
                    }
                    case POST_OUT_RESPONSE: {
                        msgdiagErrore.addKeyword("@FASE_TRACCIAMENTO@", "Risposta consegnata");
                    }
                }
                if (FaseTracciamento.POST_OUT_RESPONSE.equals((Object)this.fase) && transaction != null) {
                    msgdiagErrore.addLogPersonalizzato("tracciamento.", "registrazioneTransazioneNonRiuscita", transaction, sbErrorLog);
                    if (changeEsito != null) {
                        changeEsito.setValue(Boolean.valueOf(true));
                    }
                } else {
                    msgdiagErrore.logPersonalizzato("tracciamento.", "registrazioneTransazioneNonRiuscita");
                }
            }
            catch (Throwable t) {
                String error = "[" + idTransazione + "] Registrazione dell'anomalia avvenuta durante il tracciamento non riuscita: " + t.getMessage();
                this.log.error(error, t);
            }
        }
    }
}

