/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.transazioni;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.Transazioni;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.controllo_traffico.beans.MisurazioniTransazione;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.TransazioneExtendedInfo;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.core.transazioni.constants.RuoloTransazione;
import org.openspcoop2.core.transazioni.constants.TipoAPI;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.core.transazioni.utils.PropertiesSerializator;
import org.openspcoop2.core.transazioni.utils.TempiElaborazione;
import org.openspcoop2.core.transazioni.utils.TempiElaborazioneUtils;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractCredenzialeList;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.monitor.sdk.transaction.FaseTracciamento;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.EJBUtils;
import org.openspcoop2.pdd.core.EJBUtilsMessaggioInConsegna;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autenticazione.GestoreAutenticazione;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.ConfigurazioneMultiDeliver;
import org.openspcoop2.pdd.core.controllo_traffico.CostantiControlloTraffico;
import org.openspcoop2.pdd.core.handlers.ExtendedTransactionInfo;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.token.InformazioniNegoziazioneToken;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.InformazioniAttributi;
import org.openspcoop2.pdd.core.transazioni.DateUtility;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.logger.DiagnosticInputStream;
import org.openspcoop2.pdd.logger.DumpUtility;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.info.InfoEsitoTransazioneFormatUtils;
import org.openspcoop2.pdd.logger.transazioni.ConfigurazioneTracciamentoUtils;
import org.openspcoop2.pdd.logger.transazioni.InformazioniTransazione;
import org.openspcoop2.pdd.logger.transazioni.TransazioniProcessTimes;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.builder.IBustaBuilder;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpClientAddressSanitizer;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class TransazioneUtilities {
    private Logger logger;
    private boolean transazioniRegistrazioneTracceHeaderRawEnabled;
    private boolean transazioniRegistrazioneTracceDigestEnabled;
    private boolean transazioniRegistrazioneTracceProtocolPropertiesEnabled;
    private boolean transazioniRegistrazioneTokenInformazioniNormalizzate;
    private boolean transazioniRegistrazioneAttributiInformazioniNormalizzate;
    private boolean transazioniRegistrazioneTempiElaborazione;
    private boolean transazioniRegistrazioneRetrieveTokenSaveAsTokenInfo;
    private boolean transazioniPolicyValidazioneSavePurposeIdAlways;
    private boolean transazioniPolicyNegoziazioneSavePurposeIdAlways;
    private static final MapKey<String> CREDENZIALI_MITTENTE_GRUPPI_RESOLVED = Map.newMapKey((String)"CREDENZIALI_MITTENTE_GRUPPI_RESOLVED");
    private static final MapKey<String> CREDENZIALI_MITTENTE_URI_APC_RESOLVED = Map.newMapKey((String)"CREDENZIALI_MITTENTE_URI_APC_RESOLVED");
    private static final MapKey<String> CREDENZIALI_MITTENTE_CLIENT_ADDRESS_RESOLVED = Map.newMapKey((String)"CREDENZIALI_MITTENTE_CLIENT_ADDRESS_RESOLVED");

    public TransazioneUtilities(Logger log, OpenSPCoop2Properties openspcoopProperties, boolean transazioniRegistrazioneTracceHeaderRawEnabled, boolean transazioniRegistrazioneTracceDigestEnabled, boolean transazioniRegistrazioneTracceProtocolPropertiesEnabled, Transazioni configTransazioni) {
        this.logger = log;
        this.transazioniRegistrazioneTracceHeaderRawEnabled = transazioniRegistrazioneTracceHeaderRawEnabled;
        this.transazioniRegistrazioneTracceDigestEnabled = transazioniRegistrazioneTracceDigestEnabled;
        this.transazioniRegistrazioneTracceProtocolPropertiesEnabled = transazioniRegistrazioneTracceProtocolPropertiesEnabled;
        this.transazioniRegistrazioneTempiElaborazione = configTransazioni != null && StatoFunzionalita.ABILITATO.equals((Object)configTransazioni.getTempiElaborazione());
        this.transazioniRegistrazioneTokenInformazioniNormalizzate = configTransazioni != null && StatoFunzionalita.ABILITATO.equals((Object)configTransazioni.getToken());
        this.transazioniRegistrazioneAttributiInformazioniNormalizzate = configTransazioni != null && StatoFunzionalita.ABILITATO.equals((Object)configTransazioni.getToken()) && openspcoopProperties.isGestioneAttributeAuthorityTransazioniRegistrazioneAttributiInformazioniNormalizzate();
        this.transazioniRegistrazioneRetrieveTokenSaveAsTokenInfo = configTransazioni != null && StatoFunzionalita.ABILITATO.equals((Object)configTransazioni.getToken()) && openspcoopProperties.isGestioneRetrieveTokenSaveAsTokenInfo();
        this.transazioniPolicyValidazioneSavePurposeIdAlways = openspcoopProperties.isTransazioniPolicyValidazioneSavePurposeIdAlways();
        this.transazioniPolicyNegoziazioneSavePurposeIdAlways = openspcoopProperties.isTransazioniPolicyNegoziazioneSavePurposeIdAlways();
    }

    public static boolean isConsegnaMultipla(Context context) {
        int connettoriMultipli = TransazioneUtilities.getNumeroConnettoriMultipli(context);
        return ConfigurazioneTracciamentoUtils.isConsegnaMultipla(connettoriMultipli);
    }

    public static boolean isConsegnaMultipla(int connettoriMultipli) {
        return ConfigurazioneTracciamentoUtils.isConsegnaMultipla(connettoriMultipli);
    }

    public static int getNumeroConnettoriMultipli(Context context) {
        return ConfigurazioneTracciamentoUtils.getNumeroConnettoriMultipli(context);
    }

    public static String getConnettoriMultipli(Context context) {
        return ConfigurazioneTracciamentoUtils.getConnettoriMultipli(context);
    }

    public static MisurazioniTransazione fillMisurazioniTransazione(InformazioniTransazione info, FaseTracciamento fase, Transaction transaction, EsitoTransazione esito, Transazione transactionDTOparam) {
        Transazione transactionDTO;
        MisurazioniTransazione misurazioniTransazione = new MisurazioniTransazione();
        misurazioniTransazione.setTipoPdD(info.getTipoPorta());
        misurazioniTransazione.setProtocollo(info.getProtocolFactory().getProtocol());
        misurazioniTransazione.setEsitoTransazione(esito.getCode().intValue());
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        boolean fillTransaction = transactionDTOparam == null;
        Transazione transazione = transactionDTO = fillTransaction ? new Transazione() : transactionDTOparam;
        if (fillTransaction) {
            TransazioneUtilities.setDataIngressoRichiesta(op2Properties, transactionDTO, info, transaction);
        }
        misurazioniTransazione.setDataIngressoRichiesta(transactionDTO.getDataIngressoRichiesta());
        if (fillTransaction) {
            TransazioneUtilities.setDataUscitaRichiesta(transactionDTO, fase, transaction);
        }
        misurazioniTransazione.setDataUscitaRichiesta(transactionDTO.getDataUscitaRichiesta());
        if (fillTransaction) {
            TransazioneUtilities.setDataIngressoRisposta(op2Properties, transactionDTO, fase, transaction);
        }
        misurazioniTransazione.setDataIngressoRisposta(transactionDTO.getDataIngressoRisposta());
        if (fillTransaction) {
            TransazioneUtilities.setDataUscitaRisposta(op2Properties, transactionDTO, info, fase, transaction);
        }
        misurazioniTransazione.setDataUscitaRisposta(transactionDTO.getDataUscitaRisposta());
        if (fillTransaction) {
            TransazioneUtilities.setRichiestaIngressoBytes(transactionDTO, info, transaction, fase);
        }
        misurazioniTransazione.setRichiestaIngressoBytes(transactionDTO.getRichiestaIngressoBytes());
        if (fillTransaction) {
            TransazioneUtilities.setRichiestaUscitaBytes(transactionDTO, info, transaction, fase);
        }
        misurazioniTransazione.setRichiestaUscitaBytes(transactionDTO.getRichiestaUscitaBytes());
        if (fillTransaction) {
            TransazioneUtilities.setRispostaIngressoBytes(transactionDTO, info, transaction, fase);
        }
        misurazioniTransazione.setRispostaIngressoBytes(transactionDTO.getRispostaIngressoBytes());
        if (fillTransaction) {
            TransazioneUtilities.setRispostaUscitaBytes(transactionDTO, info, fase);
        }
        misurazioniTransazione.setRispostaUscitaBytes(transactionDTO.getRispostaUscitaBytes());
        return misurazioniTransazione;
    }

    public Transazione fillTransaction(InformazioniTransazione info, Transaction transaction, IDSoggetto idDominio, TransazioniProcessTimes times, FaseTracciamento fase, EsitoTransazione esito, String esitoContext, Transazione transazioneDaAggiornare) throws HandlerException {
        Transazione transactionDTO;
        RequestInfo requestInfo;
        IBustaBuilder protocolBustaBuilder;
        IProtocolFactory<?> protocolFactory;
        long timeStart;
        String identificativoSaveTransactionContext;
        String nomePorta;
        String idTransazione;
        MsgDiagnostico msgDiag;
        boolean consegnaMultiplaProfiloSincrono;
        boolean schedulaNotificheDopoConsegnaSincrona;
        boolean rispostaDuplicata;
        String profiloCollaborazioneValueBustaTracciaRichiesta;
        ProfiloDiCollaborazione profiloCollaborazioneBustaTracciaRichiesta;
        boolean richiestaDuplicata;
        Traccia tracciaRisposta;
        Traccia tracciaRichiesta;
        OpenSPCoop2Properties op2Properties;
        block209: {
            Object errore;
            boolean readFault;
            op2Properties = OpenSPCoop2Properties.getInstance();
            if (transaction == null) {
                throw new HandlerException("Transaction is null");
            }
            if (info == null) {
                throw new HandlerException("Informazioni sulla richiesta is null");
            }
            tracciaRichiesta = transaction.getTracciaRichiesta();
            tracciaRisposta = transaction.getTracciaRisposta();
            richiestaDuplicata = false;
            profiloCollaborazioneBustaTracciaRichiesta = null;
            profiloCollaborazioneValueBustaTracciaRichiesta = null;
            if (tracciaRichiesta != null && tracciaRichiesta.getBusta() != null) {
                richiestaDuplicata = transaction.containsIdProtocolloDuplicato(tracciaRichiesta.getBusta().getID());
                if (tracciaRichiesta.getBusta().getProfiloDiCollaborazione() != null) {
                    profiloCollaborazioneBustaTracciaRichiesta = tracciaRichiesta.getBusta().getProfiloDiCollaborazione();
                    profiloCollaborazioneValueBustaTracciaRichiesta = tracciaRichiesta.getBusta().getProfiloDiCollaborazioneValue();
                }
            }
            rispostaDuplicata = false;
            if (tracciaRisposta != null && tracciaRisposta.getBusta() != null) {
                rispostaDuplicata = transaction.containsIdProtocolloDuplicato(tracciaRisposta.getBusta().getID());
            }
            schedulaNotificheDopoConsegnaSincrona = false;
            consegnaMultiplaProfiloSincrono = false;
            msgDiag = null;
            idTransazione = null;
            nomePorta = null;
            identificativoSaveTransactionContext = null;
            timeStart = -1L;
            if (times != null) {
                times.fillTransactionDetails = new ArrayList<String>();
                timeStart = DateManager.getTimeMillis();
            }
            protocolFactory = info.getProtocolFactory();
            protocolBustaBuilder = protocolFactory.createBustaBuilder(info.getStato());
            requestInfo = null;
            if (info.getContext() != null && info.getContext().containsKey(Costanti.REQUEST_INFO)) {
                requestInfo = (RequestInfo)info.getContext().getObject(Costanti.REQUEST_INFO);
            }
            if (FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase) && info.getContext() != null && info.getContext().containsKey(CostantiPdD.SALVA_CONTESTO_IDENTIFICATIVO_MESSAGGIO_NOTIFICA)) {
                identificativoSaveTransactionContext = (String)info.getContext().getObject(CostantiPdD.SALVA_CONTESTO_IDENTIFICATIVO_MESSAGGIO_NOTIFICA);
            }
            transactionDTO = transazioneDaAggiornare != null ? transazioneDaAggiornare : new Transazione();
            EsitiProperties esitiProperties = EsitiProperties.getInstance((Logger)this.logger, protocolFactory);
            int connettoriMultipli = TransazioneUtilities.getNumeroConnettoriMultipli(info.getContext());
            boolean consegnaMultipla = TransazioneUtilities.isConsegnaMultipla(connettoriMultipli);
            ConfigurazioneMultiDeliver configurazioneConsegnaMultiplaProfiloSincrono = null;
            if (FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase) && consegnaMultipla) {
                Object oConnettoreSyncConfig;
                Object oConnettoreSync = info.getContext().getObject(Costanti.CONSEGNA_MULTIPLA_SINCRONA);
                if (oConnettoreSync instanceof Boolean) {
                    consegnaMultiplaProfiloSincrono = (Boolean)oConnettoreSync;
                } else if (oConnettoreSync instanceof String) {
                    consegnaMultiplaProfiloSincrono = Boolean.valueOf((String)oConnettoreSync);
                }
                if (consegnaMultiplaProfiloSincrono && (oConnettoreSyncConfig = info.getContext().getObject(Costanti.CONSEGNA_MULTIPLA_SINCRONA_CONFIGURAZIONE)) instanceof ConfigurazioneMultiDeliver) {
                    configurazioneConsegnaMultiplaProfiloSincrono = (ConfigurazioneMultiDeliver)oConnettoreSyncConfig;
                }
            }
            if (consegnaMultiplaProfiloSincrono) {
                if (transaction != null && transaction.getRequestInfo() != null && transaction.getRequestInfo().getProtocolContext() != null) {
                    nomePorta = transaction.getRequestInfo().getProtocolContext().getInterfaceName();
                }
                msgDiag = MsgDiagnostico.newInstance(info.getTipoPorta(), idDominio, info.getIdModulo(), nomePorta, requestInfo, info.getStato());
            }
            if (consegnaMultiplaProfiloSincrono && configurazioneConsegnaMultiplaProfiloSincrono != null && esito != null && esito.getCode() != null) {
                if (configurazioneConsegnaMultiplaProfiloSincrono.isNotificheByEsito()) {
                    int esitoSincrono = esito.getCode();
                    schedulaNotificheDopoConsegnaSincrona = this.isEsito(esitiProperties.getEsitiCodeOk_senzaFaultApplicativo(), esitoSincrono) ? configurazioneConsegnaMultiplaProfiloSincrono.isNotificheByEsito_ok() : (this.isEsito(esitiProperties.getEsitiCodeFaultApplicativo(), esitoSincrono) ? configurazioneConsegnaMultiplaProfiloSincrono.isNotificheByEsito_fault() : (this.isEsito(esitiProperties.getEsitiCodeErroriConsegna(), esitoSincrono) ? configurazioneConsegnaMultiplaProfiloSincrono.isNotificheByEsito_erroriConsegna() : configurazioneConsegnaMultiplaProfiloSincrono.isNotificheByEsito_erroriProcessamento()));
                } else {
                    schedulaNotificheDopoConsegnaSincrona = true;
                }
            }
            if (schedulaNotificheDopoConsegnaSincrona && info.getContext() != null) {
                Exception e = null;
                Object oException = info.getContext().getObject(CostantiPdD.CONNETTORE_MULTIPLO_CONSEGNA_NOTIFICA_DISABILITATA);
                if (oException instanceof Exception) {
                    e = (Exception)oException;
                }
                if (e != null) {
                    schedulaNotificheDopoConsegnaSincrona = false;
                }
            }
            if (times != null) {
                long timeEnd = DateManager.getTimeMillis();
                long timeProcess = timeEnd - timeStart;
                times.fillTransactionDetails.add("connettoreMultipli:" + timeProcess);
                timeStart = DateManager.getTimeMillis();
            }
            if (info.getContext().getObject(Costanti.ID_TRANSAZIONE) == null) {
                throw new HandlerException("ID Transazione Assente");
            }
            idTransazione = (String)info.getContext().getObject(Costanti.ID_TRANSAZIONE);
            transactionDTO.setIdTransazione(idTransazione);
            if (esito != null) {
                if (consegnaMultipla) {
                    if (consegnaMultiplaProfiloSincrono) {
                        if (schedulaNotificheDopoConsegnaSincrona) {
                            transactionDTO.setEsito(esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA).intValue());
                            if (esito.getCode() != null) {
                                transactionDTO.setEsitoSincrono(esito.getCode().intValue());
                            }
                            transactionDTO.setConsegneMultipleInCorso(connettoriMultipli);
                        } else if (esito.getCode() != null) {
                            transactionDTO.setEsito(esito.getCode().intValue());
                        }
                    } else {
                        transactionDTO.setEsito(esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA).intValue());
                        transactionDTO.setConsegneMultipleInCorso(connettoriMultipli);
                    }
                } else if (esito.getCode() != null) {
                    transactionDTO.setEsito(esito.getCode().intValue());
                }
                transactionDTO.setEsitoContesto(esito.getContextType());
            } else {
                transactionDTO.setEsitoContesto(esitoContext);
            }
            transactionDTO.setEsitoContesto(EsitoUtils.buildEsitoContext((String)transactionDTO.getEsitoContesto(), (FaseTracciamento)fase));
            if (info.getReturnCode() > 0) {
                transactionDTO.setCodiceRispostaUscita("" + info.getReturnCode());
            }
            if (FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
                this.setEventi(transactionDTO, transaction, op2Properties, requestInfo, idDominio, info, idTransazione, times, timeStart, fase);
            }
            if (times != null) {
                timeStart = DateManager.getTimeMillis();
            }
            TransazioneUtilities.setDataUscitaRisposta(op2Properties, transactionDTO, info, fase, transaction);
            TransazioneUtilities.setDataUscitaRispostaStream(op2Properties, transactionDTO, info, fase);
            TransazioneUtilities.setRispostaIngressoBytes(transactionDTO, info, transaction, fase);
            TransazioneUtilities.setRispostaUscitaBytes(transactionDTO, info, fase);
            if (FaseTracciamento.OUT_RESPONSE.equals((Object)fase) || FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
                transactionDTO.setFaultIntegrazione(transaction.getFaultIntegrazione());
                transactionDTO.setFormatoFaultIntegrazione(transaction.getFormatoFaultIntegrazione());
                transactionDTO.setFaultCooperazione(transaction.getFaultCooperazione());
                transactionDTO.setFormatoFaultCooperazione(transaction.getFormatoFaultCooperazione());
            }
            if ((readFault = true) && FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
                this.setFaultInfo(transactionDTO, op2Properties, info);
            }
            if (esito != null) {
                errore = InfoEsitoTransazioneFormatUtils.getMessaggioDiagnosticoErroreRilevante(this.logger, transactionDTO.getEsito(), protocolFactory, transaction.getMsgDiagnostici(), true);
                String warning = InfoEsitoTransazioneFormatUtils.getMessaggioDiagnosticoWarning(this.logger, transactionDTO.getEsito(), protocolFactory, transaction.getMsgDiagnostici());
                transactionDTO.setErrorLog((String)errore);
                transactionDTO.setWarningLog(warning);
            }
            if (transazioneDaAggiornare == null) break block209;
            errore = transactionDTO;
            if (consegnaMultiplaProfiloSincrono) {
                timeStart = this.consegnaMultiplaProfiloSincrono(info, idDominio, idTransazione, times, timeStart, schedulaNotificheDopoConsegnaSincrona, msgDiag, nomePorta);
            }
            if (identificativoSaveTransactionContext != null) {
                timeStart = this.saveTransactionContext(identificativoSaveTransactionContext, info, idDominio, idTransazione, times, timeStart, msgDiag);
            }
            return errore;
        }
        try {
            List<String> keys;
            long timeEnd;
            Object operazioneIM;
            String value;
            String key;
            long timeProcess;
            boolean asincrono;
            Busta busta;
            long timeProcess2;
            long timeEnd2;
            RuoloTransazione ruolo;
            if (transaction.getStato() != null) {
                transactionDTO.setStato(transaction.getStato());
            }
            if ((ruolo = RuoloTransazione.getEnumConstantFromOpenSPCoopValue((String)transaction.getScenarioCooperazione())) != null) {
                transactionDTO.setRuoloTransazione(ruolo.getValoreAsInt());
            } else {
                transactionDTO.setRuoloTransazione(-1);
            }
            transactionDTO.setProtocollo(info.getProtocolFactory().getProtocol());
            if (transaction.getRequestInfo() != null && transaction.getRequestInfo().getProtocolContext() != null && transaction.getRequestInfo().getProtocolContext().getRequestType() != null) {
                transactionDTO.setTipoRichiesta(transaction.getRequestInfo().getProtocolContext().getRequestType());
            }
            transactionDTO.setCodiceRispostaIngresso(transaction.getCodiceTrasportoRichiesta());
            TransazioneUtilities.setDataAccettazioneRichiesta(transactionDTO, info, transaction);
            TransazioneUtilities.setDataIngressoRichiesta(op2Properties, transactionDTO, info, transaction);
            TransazioneUtilities.setDataIngressoRichiestaStream(transactionDTO, info);
            TransazioneUtilities.setDataUscitaRichiesta(transactionDTO, fase, transaction);
            TransazioneUtilities.setDataAccettazioneRisposta(transactionDTO, fase, transaction);
            TransazioneUtilities.setDataIngressoRisposta(op2Properties, transactionDTO, fase, transaction);
            TransazioneUtilities.setDataIngressoRispostaStream(transactionDTO, info, fase);
            TransazioneUtilities.setRichiestaIngressoBytes(transactionDTO, info, transaction, fase);
            TransazioneUtilities.setRichiestaUscitaBytes(transactionDTO, info, transaction, fase);
            if (transactionDTO.getRispostaIngressoBytes() == null && FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
                transactionDTO.setRispostaIngressoBytes(TransazioneUtilities.readDimensioneFromDumpBinario(TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO, transaction));
            }
            if (transactionDTO.getRispostaUscitaBytes() == null && FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
                transactionDTO.setRispostaUscitaBytes(TransazioneUtilities.readDimensioneFromDumpBinario(TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO, transaction));
            }
            transactionDTO.setPddCodice(idDominio.getCodicePorta());
            transactionDTO.setPddTipoSoggetto(idDominio.getTipo());
            transactionDTO.setPddNomeSoggetto(idDominio.getNome());
            if (info.getTipoPorta() != null) {
                transactionDTO.setPddRuolo(PddRuolo.toEnumConstant((String)info.getTipoPorta().getTipo()));
            }
            if (times != null) {
                timeEnd2 = DateManager.getTimeMillis();
                timeProcess2 = timeEnd2 - timeStart;
                times.fillTransactionDetails.add("baseContext:" + timeProcess2);
                timeStart = DateManager.getTimeMillis();
            }
            if (times != null) {
                timeEnd2 = DateManager.getTimeMillis();
                timeProcess2 = timeEnd2 - timeStart;
                times.fillTransactionDetails.add("fault:" + timeProcess2);
                timeStart = DateManager.getTimeMillis();
            }
            if (info.getProtocollo() != null && info.getProtocollo().getFruitore() != null) {
                transactionDTO.setTipoSoggettoFruitore(info.getProtocollo().getFruitore().getTipo());
                transactionDTO.setNomeSoggettoFruitore(info.getProtocollo().getFruitore().getNome());
                transactionDTO.setIdportaSoggettoFruitore(info.getProtocollo().getFruitore().getCodicePorta());
                transactionDTO.setIndirizzoSoggettoFruitore(info.getProtocollo().getIndirizzoFruitore());
            } else if (transaction != null && transaction.getRequestInfo() != null && transaction.getRequestInfo().getFruitore() != null) {
                transactionDTO.setTipoSoggettoFruitore(transaction.getRequestInfo().getFruitore().getTipo());
                transactionDTO.setNomeSoggettoFruitore(transaction.getRequestInfo().getFruitore().getNome());
                transactionDTO.setIdportaSoggettoFruitore(transaction.getRequestInfo().getFruitore().getCodicePorta());
            }
            if (info.getProtocollo() != null && info.getProtocollo().getErogatore() != null) {
                transactionDTO.setTipoSoggettoErogatore(info.getProtocollo().getErogatore().getTipo());
                transactionDTO.setNomeSoggettoErogatore(info.getProtocollo().getErogatore().getNome());
                transactionDTO.setIdportaSoggettoErogatore(info.getProtocollo().getErogatore().getCodicePorta());
                transactionDTO.setIndirizzoSoggettoErogatore(info.getProtocollo().getIndirizzoErogatore());
            } else if (transaction != null && transaction.getRequestInfo() != null && transaction.getRequestInfo().getIdServizio() != null && transaction.getRequestInfo().getIdServizio().getSoggettoErogatore() != null) {
                transactionDTO.setTipoSoggettoErogatore(transaction.getRequestInfo().getIdServizio().getSoggettoErogatore().getTipo());
                transactionDTO.setNomeSoggettoErogatore(transaction.getRequestInfo().getIdServizio().getSoggettoErogatore().getNome());
                transactionDTO.setIdportaSoggettoErogatore(transaction.getRequestInfo().getIdServizio().getSoggettoErogatore().getCodicePorta());
            }
            if (info.getProtocollo() != null) {
                String idMessaggioRichiesta = info.getProtocollo().getIdRichiesta();
                if ("modipa".equals(protocolFactory.getProtocol()) && tracciaRichiesta != null && tracciaRichiesta.getBusta() != null && tracciaRichiesta.getBusta().getID() != null && !tracciaRichiesta.getBusta().getID().equals(idMessaggioRichiesta)) {
                    idMessaggioRichiesta = tracciaRichiesta.getBusta().getID();
                }
                Timestamp dateInternaIdProtocolloRichiesta = null;
                if (op2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory) && idMessaggioRichiesta != null) {
                    dateInternaIdProtocolloRichiesta = DateUtility.getTimestampIntoIdProtocollo(this.logger, protocolBustaBuilder, idMessaggioRichiesta);
                }
                String idMessaggioRisposta = null;
                Timestamp dateInternaIdProtocolloRisposta = null;
                if (tracciaRisposta != null && tracciaRisposta.getBusta() != null && tracciaRisposta.getBusta().getID() != null) {
                    idMessaggioRisposta = tracciaRisposta.getBusta().getID();
                    if (op2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory)) {
                        dateInternaIdProtocolloRisposta = DateUtility.getTimestampIntoIdProtocollo(this.logger, protocolBustaBuilder, idMessaggioRisposta);
                    }
                } else if (info.getProtocollo().getIdRisposta() != null) {
                    idMessaggioRisposta = info.getProtocollo().getIdRisposta();
                    if (op2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory)) {
                        dateInternaIdProtocolloRisposta = DateUtility.getTimestampIntoIdProtocollo(this.logger, protocolBustaBuilder, idMessaggioRisposta);
                    }
                }
                transactionDTO.setIdMessaggioRichiesta(idMessaggioRichiesta);
                transactionDTO.setIdMessaggioRisposta(idMessaggioRisposta);
                if (op2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory)) {
                    transactionDTO.setDataIdMsgRichiesta((Date)dateInternaIdProtocolloRichiesta);
                    transactionDTO.setDataIdMsgRisposta((Date)dateInternaIdProtocolloRisposta);
                }
            }
            if (info.getProtocollo() != null && info.getProtocollo().getProfiloCollaborazione() != null) {
                transactionDTO.setProfiloCollaborazioneOp2(info.getProtocollo().getProfiloCollaborazione().getEngineValue());
            } else if (profiloCollaborazioneBustaTracciaRichiesta != null) {
                transactionDTO.setProfiloCollaborazioneOp2(profiloCollaborazioneBustaTracciaRichiesta.getEngineValue());
            }
            if (info.getProtocollo() != null && info.getProtocollo().getProfiloCollaborazioneValue() != null) {
                transactionDTO.setProfiloCollaborazioneProt(info.getProtocollo().getProfiloCollaborazioneValue());
            } else if (profiloCollaborazioneValueBustaTracciaRichiesta != null) {
                transactionDTO.setProfiloCollaborazioneProt(profiloCollaborazioneValueBustaTracciaRichiesta);
            }
            IDAccordo idAccordo = null;
            if (info.getProtocollo() != null) {
                transactionDTO.setIdCollaborazione(info.getProtocollo().getCollaborazione());
                idAccordo = info.getProtocollo().getIdAccordo();
                if (idAccordo != null) {
                    transactionDTO.setUriAccordoServizio(IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordo));
                }
                transactionDTO.setTipoServizio(info.getProtocollo().getTipoServizio());
                transactionDTO.setNomeServizio(info.getProtocollo().getServizio());
                if (info.getProtocollo().getVersioneServizio() != null && info.getProtocollo().getVersioneServizio() > 0) {
                    transactionDTO.setVersioneServizio(info.getProtocollo().getVersioneServizio().intValue());
                }
                transactionDTO.setAzione(info.getProtocollo().getAzione());
            }
            if (transactionDTO.getTipoServizio() == null && transaction != null && transaction.getRequestInfo() != null && transaction.getRequestInfo().getIdServizio() != null) {
                transactionDTO.setTipoServizio(transaction.getRequestInfo().getIdServizio().getTipo());
            }
            if (transactionDTO.getNomeServizio() == null && transaction != null && transaction.getRequestInfo() != null && transaction.getRequestInfo().getIdServizio() != null) {
                transactionDTO.setNomeServizio(transaction.getRequestInfo().getIdServizio().getNome());
            }
            if ((info.getProtocollo() == null || info.getProtocollo().getVersioneServizio() == null || info.getProtocollo().getVersioneServizio() <= 0) && transaction != null && transaction.getRequestInfo() != null && transaction.getRequestInfo().getIdServizio() != null) {
                transactionDTO.setVersioneServizio(transaction.getRequestInfo().getIdServizio().getVersione().intValue());
            }
            if (transactionDTO.getAzione() == null && transaction != null && transaction.getRequestInfo() != null && transaction.getRequestInfo().getIdServizio() != null) {
                transactionDTO.setAzione(transaction.getRequestInfo().getIdServizio().getAzione());
            }
            if (times != null) {
                long timeEnd3 = DateManager.getTimeMillis();
                long timeProcess3 = timeEnd3 - timeStart;
                times.fillTransactionDetails.add("identificativi:" + timeProcess3);
                timeStart = DateManager.getTimeMillis();
            }
            RegistroServiziManager registroServiziManager = RegistroServiziManager.getInstance((IState)info.getStato());
            if (idAccordo == null && transactionDTO.getNomeServizio() != null && transactionDTO.getTipoServizio() != null && transactionDTO.getNomeSoggettoErogatore() != null && transactionDTO.getTipoSoggettoErogatore() != null) {
                idAccordo = this.getIdAccordo(transactionDTO, registroServiziManager, requestInfo);
            }
            if (times != null) {
                long timeEnd4 = DateManager.getTimeMillis();
                long timeProcess4 = timeEnd4 - timeStart;
                times.fillTransactionDetails.add("id-api:" + timeProcess4);
                timeStart = DateManager.getTimeMillis();
            }
            if (idAccordo != null) {
                this.setAccordoInfo(idAccordo, transactionDTO, op2Properties, registroServiziManager, requestInfo, idDominio, info, idTransazione, times, timeStart, fase);
                if (times != null) {
                    timeStart = DateManager.getTimeMillis();
                }
            }
            if (tracciaRichiesta != null && tracciaRichiesta.getBusta() != null && (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)tracciaRichiesta.getBusta().getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)tracciaRichiesta.getBusta().getProfiloDiCollaborazione()))) {
                Busta busta2 = tracciaRichiesta.getBusta();
                if (busta2.getRiferimentoMessaggio() != null) {
                    transactionDTO.setIdAsincrono(busta2.getRiferimentoMessaggio());
                } else {
                    transactionDTO.setIdAsincrono(busta2.getCollaborazione());
                }
            }
            if (tracciaRichiesta != null && tracciaRichiesta.getBusta() != null && ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)tracciaRichiesta.getBusta().getProfiloDiCollaborazione())) {
                Busta busta3 = tracciaRichiesta.getBusta();
                if (busta3 != null) {
                    transactionDTO.setTipoServizioCorrelato(busta3.getTipoServizioCorrelato());
                    transactionDTO.setNomeServizioCorrelato(busta3.getServizioCorrelato());
                }
            } else if (tracciaRisposta != null && tracciaRisposta.getBusta() != null && ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)tracciaRisposta.getBusta().getProfiloDiCollaborazione()) && (busta = tracciaRisposta.getBusta()) != null) {
                transactionDTO.setTipoServizioCorrelato(busta.getTipoServizioCorrelato());
                transactionDTO.setNomeServizioCorrelato(busta.getServizioCorrelato());
            }
            if (transactionDTO.getIdCollaborazione() == null) {
                if (tracciaRichiesta != null && tracciaRichiesta.getBusta() != null && tracciaRichiesta.getBusta().getCollaborazione() != null) {
                    transactionDTO.setIdCollaborazione(tracciaRichiesta.getBusta().getCollaborazione());
                } else if (tracciaRisposta != null && tracciaRisposta.getBusta() != null && tracciaRisposta.getBusta().getCollaborazione() != null) {
                    transactionDTO.setIdCollaborazione(tracciaRisposta.getBusta().getCollaborazione());
                }
            }
            boolean bl = asincrono = tracciaRichiesta != null && tracciaRichiesta.getBusta() != null && (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)tracciaRichiesta.getBusta().getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)tracciaRichiesta.getBusta().getProfiloDiCollaborazione()));
            if (!asincrono) {
                if (transactionDTO.getIdAsincrono() == null && tracciaRichiesta != null && tracciaRichiesta.getBusta() != null && tracciaRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                    transactionDTO.setIdAsincrono(tracciaRichiesta.getBusta().getRiferimentoMessaggio());
                }
                if (transactionDTO.getIdAsincrono() == null && info.getProtocollo() != null) {
                    transactionDTO.setIdAsincrono(info.getProtocollo().getRiferimentoAsincrono());
                }
            }
            if (times != null) {
                long timeEnd5 = DateManager.getTimeMillis();
                timeProcess = timeEnd5 - timeStart;
                times.fillTransactionDetails.add("async:" + timeProcess);
                timeStart = DateManager.getTimeMillis();
            }
            if (tracciaRichiesta != null) {
                if (this.transazioniRegistrazioneTracceHeaderRawEnabled) {
                    if (tracciaRichiesta.getBustaAsString() != null) {
                        transactionDTO.setHeaderProtocolloRichiesta(tracciaRichiesta.getBustaAsString());
                    } else if (tracciaRichiesta.getBustaAsByteArray() != null) {
                        transactionDTO.setHeaderProtocolloRichiesta(new String(tracciaRichiesta.getBustaAsByteArray()));
                    } else if (tracciaRichiesta.getBustaAsRawContent() != null) {
                        this.setHeaderProtocolloRichiesta(transactionDTO, tracciaRichiesta);
                    }
                }
                if (tracciaRichiesta.getBusta() != null) {
                    if (this.transazioniRegistrazioneTracceDigestEnabled) {
                        transactionDTO.setDigestRichiesta(tracciaRichiesta.getBusta().getDigest());
                    }
                    if (this.transazioniRegistrazioneTracceProtocolPropertiesEnabled && tracciaRichiesta.getBusta().sizeProperties() > 0) {
                        HashMap propertiesBusta = new HashMap();
                        String[] pNames = tracciaRichiesta.getBusta().getPropertiesNames();
                        if (pNames != null) {
                            for (int i = 0; i < pNames.length; ++i) {
                                key = pNames[i];
                                value = tracciaRichiesta.getBusta().getProperty(key);
                                if (key == null || value == null) continue;
                                TransportUtils.put(propertiesBusta, (String)key, (String)value, (boolean)false);
                            }
                        }
                        PropertiesSerializator ps = new PropertiesSerializator(propertiesBusta);
                        this.setProtocolloExtInfoRichiesta(transactionDTO, ps);
                    }
                }
                if (times != null) {
                    long timeEnd6 = DateManager.getTimeMillis();
                    timeProcess = timeEnd6 - timeStart;
                    times.fillTransactionDetails.add("traccia-richiesta:" + timeProcess);
                    timeStart = DateManager.getTimeMillis();
                }
            }
            if (tracciaRisposta != null) {
                if (this.transazioniRegistrazioneTracceHeaderRawEnabled) {
                    if (tracciaRisposta.getBustaAsString() != null) {
                        transactionDTO.setHeaderProtocolloRisposta(tracciaRisposta.getBustaAsString());
                    } else if (tracciaRisposta.getBustaAsByteArray() != null) {
                        transactionDTO.setHeaderProtocolloRisposta(new String(tracciaRisposta.getBustaAsByteArray()));
                    } else if (tracciaRisposta.getBustaAsRawContent() != null) {
                        this.setHeaderProtocolloRisposta(transactionDTO, tracciaRisposta);
                    }
                }
                if (tracciaRisposta.getBusta() != null) {
                    if (this.transazioniRegistrazioneTracceDigestEnabled) {
                        transactionDTO.setDigestRisposta(tracciaRisposta.getBusta().getDigest());
                    }
                    if (this.transazioniRegistrazioneTracceProtocolPropertiesEnabled && tracciaRisposta.getBusta().sizeProperties() > 0) {
                        HashMap propertiesBusta = new HashMap();
                        String[] pNames = tracciaRisposta.getBusta().getPropertiesNames();
                        if (pNames != null) {
                            for (int i = 0; i < pNames.length; ++i) {
                                key = pNames[i];
                                value = tracciaRisposta.getBusta().getProperty(key);
                                if (key == null || value == null) continue;
                                TransportUtils.put(propertiesBusta, (String)key, (String)value, (boolean)false);
                            }
                        }
                        PropertiesSerializator ps = new PropertiesSerializator(propertiesBusta);
                        this.setProtocolloExtInfoRisposta(transactionDTO, ps);
                    }
                }
                if (times != null) {
                    long timeEnd7 = DateManager.getTimeMillis();
                    long timeProcess5 = timeEnd7 - timeStart;
                    times.fillTransactionDetails.add("traccia-risposta:" + timeProcess5);
                    timeStart = DateManager.getTimeMillis();
                }
            }
            if (info.getIntegrazione() != null) {
                String sa;
                Object o;
                transactionDTO.setIdCorrelazioneApplicativa(info.getIntegrazione().getIdCorrelazioneApplicativa());
                transactionDTO.setIdCorrelazioneApplicativaRisposta(transaction.getCorrelazioneApplicativaRisposta());
                transactionDTO.setServizioApplicativoFruitore(info.getIntegrazione().getServizioApplicativoFruitore());
                if (info != null && info.getContext() != null && info.getContext().containsKey(CostantiPdD.CONNETTORE_MULTIPLO_SELEZIONATO) && (o = info.getContext().getObject(CostantiPdD.CONNETTORE_MULTIPLO_SELEZIONATO)) instanceof String && (sa = (String)o) != null && !"".equals(sa)) {
                    transactionDTO.setServizioApplicativoErogatore(sa);
                }
                if (transactionDTO.getServizioApplicativoErogatore() == null) {
                    if (info.getIntegrazione().sizeServiziApplicativiErogatori() > 0) {
                        StringBuilder saErogatori = new StringBuilder();
                        for (int i = 0; i < info.getIntegrazione().sizeServiziApplicativiErogatori(); ++i) {
                            if (i > 0) {
                                saErogatori.append(",");
                            }
                            saErogatori.append(info.getIntegrazione().getServizioApplicativoErogatore(i));
                        }
                        transactionDTO.setServizioApplicativoErogatore(saErogatori.toString().length() > 2000 ? saErogatori.toString().substring(0, 1999) : saErogatori.toString());
                    } else if (transaction.getServiziApplicativiErogatore() != null && !transaction.getServiziApplicativiErogatore().isEmpty()) {
                        StringBuilder saErogatori = new StringBuilder();
                        for (int i = 0; i < transaction.getServiziApplicativiErogatore().size(); ++i) {
                            if (i > 0) {
                                saErogatori.append(",");
                            }
                            saErogatori.append(transaction.getServiziApplicativiErogatore().get(i));
                        }
                        transactionDTO.setServizioApplicativoErogatore(saErogatori.toString().length() > 2000 ? saErogatori.toString().substring(0, 1999) : saErogatori.toString());
                    }
                }
            }
            if (info.getContext() != null && (operazioneIM = info.getContext().getObject(CostantiPdD.TIPO_OPERAZIONE_IM)) instanceof String) {
                String op = (String)operazioneIM;
                transactionDTO.setOperazioneIm(op);
            }
            if (transactionDTO.getServizioApplicativoFruitore() == null && tracciaRichiesta != null && tracciaRichiesta.getBusta() != null && tracciaRichiesta.getBusta().getServizioApplicativoFruitore() != null) {
                transactionDTO.setServizioApplicativoFruitore(tracciaRichiesta.getBusta().getServizioApplicativoFruitore());
            }
            if (transactionDTO.getServizioApplicativoFruitore() == null && tracciaRisposta != null && tracciaRisposta.getBusta() != null && tracciaRisposta.getBusta().getServizioApplicativoFruitore() != null) {
                transactionDTO.setServizioApplicativoFruitore(tracciaRisposta.getBusta().getServizioApplicativoFruitore());
            }
            if (transactionDTO.getServizioApplicativoFruitore() != null && "Anonimo".equals(transactionDTO.getServizioApplicativoFruitore())) {
                transactionDTO.setServizioApplicativoFruitore(null);
            }
            if (transactionDTO.getServizioApplicativoErogatore() == null && tracciaRichiesta != null && tracciaRichiesta.getBusta() != null && tracciaRichiesta.getBusta().getServizioApplicativoErogatore() != null) {
                transactionDTO.setServizioApplicativoErogatore(tracciaRichiesta.getBusta().getServizioApplicativoErogatore());
            }
            if (transactionDTO.getServizioApplicativoErogatore() == null && tracciaRisposta != null && tracciaRisposta.getBusta() != null && tracciaRisposta.getBusta().getServizioApplicativoErogatore() != null) {
                transactionDTO.setServizioApplicativoErogatore(tracciaRisposta.getBusta().getServizioApplicativoErogatore());
            }
            transactionDTO.setLocationRichiesta(tracciaRichiesta != null ? tracciaRichiesta.getLocation() : null);
            transactionDTO.setLocationRisposta(tracciaRisposta != null ? tracciaRisposta.getLocation() : null);
            if (transaction != null && transaction.getRequestInfo() != null && transaction.getRequestInfo().getProtocolContext() != null) {
                transactionDTO.setNomePorta(transaction.getRequestInfo().getProtocolContext().getInterfaceName());
            }
            if (transaction.getCredenziali() != null) {
                transactionDTO.setCredenziali(transaction.getCredenziali());
            } else {
                Object o = info.getContext().getObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_VIOLATED_CREDENZIALI);
                if (o instanceof String) {
                    transactionDTO.setCredenziali((String)o);
                } else {
                    o = info.getContext().getObject(Costanti.CREDENZIALI_INVOCAZIONE);
                    if (o instanceof String) {
                        transactionDTO.setCredenziali((String)o);
                    }
                }
            }
            transactionDTO.setLocationConnettore(transaction.getLocation());
            if (transaction.getUrlInvocazione() != null) {
                transactionDTO.setUrlInvocazione(transaction.getUrlInvocazione());
            } else {
                Object o = info.getContext().getObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_VIOLATED_URL_INVOCAZIONE);
                if (o instanceof String) {
                    transactionDTO.setUrlInvocazione((String)o);
                } else {
                    o = info.getContext().getObject(Costanti.URL_INVOCAZIONE);
                    if (o instanceof String) {
                        transactionDTO.setUrlInvocazione((String)o);
                    }
                }
            }
            transactionDTO.setClusterId(op2Properties.getClusterId(false));
            if (times != null) {
                long timeEnd8 = DateManager.getTimeMillis();
                long timeProcess6 = timeEnd8 - timeStart;
                times.fillTransactionDetails.add("integration:" + timeProcess6);
                timeStart = DateManager.getTimeMillis();
            }
            if (transaction.getCredenzialiMittente() != null) {
                if (transaction.getCredenzialiMittente().getTrasporto() != null) {
                    transactionDTO.setTrasportoMittente("" + transaction.getCredenzialiMittente().getTrasporto().getId());
                }
                if (transaction.getCredenzialiMittente().getTokenIssuer() != null) {
                    transactionDTO.setTokenIssuer("" + transaction.getCredenzialiMittente().getTokenIssuer().getId());
                }
                if (transaction.getCredenzialiMittente().getTokenClientId() != null) {
                    transactionDTO.setTokenClientId("" + transaction.getCredenzialiMittente().getTokenClientId().getId());
                }
                if (transaction.getCredenzialiMittente().getTokenSubject() != null) {
                    transactionDTO.setTokenSubject("" + transaction.getCredenzialiMittente().getTokenSubject().getId());
                }
                if (transaction.getCredenzialiMittente().getTokenUsername() != null) {
                    transactionDTO.setTokenUsername("" + transaction.getCredenzialiMittente().getTokenUsername().getId());
                }
                if (transaction.getCredenzialiMittente().getTokenEMail() != null) {
                    transactionDTO.setTokenMail("" + transaction.getCredenzialiMittente().getTokenEMail().getId());
                }
            }
            InformazioniNegoziazioneToken informazioniNegoziazioneToken = null;
            if (this.transazioniRegistrazioneRetrieveTokenSaveAsTokenInfo) {
                if (transaction.getInformazioniNegoziazioneToken() != null) {
                    informazioniNegoziazioneToken = transaction.getInformazioniNegoziazioneToken();
                    if (op2Properties.isGestioneRetrieveTokenSaveAsTokenInfoExcludeJwtSignature() && (informazioniNegoziazioneToken.getAccessToken() != null || informazioniNegoziazioneToken.getRefreshToken() != null) || op2Properties.isGestioneRetrieveTokenGrantTypeRfc7523SaveClientAssertionJWTInfoExcludeJwtSignature() && informazioniNegoziazioneToken.getRequest() != null && informazioniNegoziazioneToken.getRequest().getJwtClientAssertion() != null || op2Properties.isGestioneRetrieveTokenDpopSaveDpopInfoExcludeJwtSignature() && informazioniNegoziazioneToken.getRequest() != null && informazioniNegoziazioneToken.getRequest().getDpop() != null || op2Properties.isGestioneRetrieveTokenDpopBackendSaveDpopInfoExcludeJwtSignature() && informazioniNegoziazioneToken.getDpopBackend() != null) {
                        informazioniNegoziazioneToken = (InformazioniNegoziazioneToken)informazioniNegoziazioneToken.clone();
                    }
                }
                if (informazioniNegoziazioneToken != null) {
                    if (op2Properties.isGestioneRetrieveTokenSaveAsTokenInfoExcludeJwtSignature()) {
                        if (informazioniNegoziazioneToken.getAccessToken() != null) {
                            String originale = informazioniNegoziazioneToken.getAccessToken();
                            String senzaSignature = TokenUtilities.deleteSignature(informazioniNegoziazioneToken.getAccessToken());
                            informazioniNegoziazioneToken.setAccessToken(senzaSignature);
                            informazioniNegoziazioneToken.setClaims(TokenUtilities.replaceTokenInMapByValue(informazioniNegoziazioneToken.getClaims(), originale, senzaSignature));
                            informazioniNegoziazioneToken.replaceInRawResponse(originale, senzaSignature);
                        }
                        if (informazioniNegoziazioneToken.getRefreshToken() != null) {
                            String originale = informazioniNegoziazioneToken.getRefreshToken();
                            String senzaSignature = TokenUtilities.deleteSignature(informazioniNegoziazioneToken.getRefreshToken());
                            informazioniNegoziazioneToken.setRefreshToken(senzaSignature);
                            informazioniNegoziazioneToken.setClaims(TokenUtilities.replaceTokenInMapByValue(informazioniNegoziazioneToken.getClaims(), originale, senzaSignature));
                            informazioniNegoziazioneToken.replaceInRawResponse(originale, senzaSignature);
                        }
                    }
                    if (informazioniNegoziazioneToken.getRequest() != null && informazioniNegoziazioneToken.getRequest().getJwtClientAssertion() != null && informazioniNegoziazioneToken.getRequest().getJwtClientAssertion().getToken() != null && op2Properties.isGestioneRetrieveTokenGrantTypeRfc7523SaveClientAssertionJWTInfoExcludeJwtSignature()) {
                        informazioniNegoziazioneToken.getRequest().getJwtClientAssertion().setToken(TokenUtilities.deleteSignature(informazioniNegoziazioneToken.getRequest().getJwtClientAssertion().getToken()));
                    }
                    if (informazioniNegoziazioneToken.getRequest() != null && informazioniNegoziazioneToken.getRequest().getDpop() != null && informazioniNegoziazioneToken.getRequest().getDpop().getToken() != null && op2Properties.isGestioneRetrieveTokenDpopSaveDpopInfoExcludeJwtSignature()) {
                        informazioniNegoziazioneToken.getRequest().getDpop().setToken(TokenUtilities.deleteSignature(informazioniNegoziazioneToken.getRequest().getDpop().getToken()));
                    }
                    if (informazioniNegoziazioneToken.getDpopBackend() != null && informazioniNegoziazioneToken.getDpopBackend().getToken() != null && op2Properties.isGestioneRetrieveTokenDpopBackendSaveDpopInfoExcludeJwtSignature()) {
                        informazioniNegoziazioneToken.getDpopBackend().setToken(TokenUtilities.deleteSignature(informazioniNegoziazioneToken.getDpopBackend().getToken()));
                    }
                }
            }
            if (this.transazioniRegistrazioneTokenInformazioniNormalizzate && transaction.getInformazioniToken() != null) {
                InformazioniToken informazioniToken = transaction.getInformazioniToken();
                if (informazioniToken.getToken() != null && op2Properties.isGestioneTokenSaveTokenInfoValidationFailedExcludeJwtSignature()) {
                    informazioniToken = (InformazioniToken)informazioniToken.clone();
                }
                if (informazioniToken.getToken() != null && op2Properties.isGestioneTokenSaveTokenInfoValidationFailedExcludeJwtSignature()) {
                    informazioniToken.setToken(TokenUtilities.deleteSignature(informazioniToken.getToken()));
                }
                if (informazioniNegoziazioneToken != null) {
                    informazioniToken.setRetrievedToken(informazioniNegoziazioneToken);
                }
                InformazioniAttributi informazioniAttributi = null;
                if (!this.transazioniRegistrazioneAttributiInformazioniNormalizzate) {
                    informazioniAttributi = informazioniToken.getAa();
                    informazioniToken.setAa(null);
                }
                this.setTokenInfo(transactionDTO, informazioniToken);
                if (informazioniAttributi != null) {
                    informazioniToken.setAa(informazioniAttributi);
                }
            }
            if (TipoPdD.DELEGATA.equals((Object)info.getTipoPorta()) && transaction.getInformazioniNegoziazioneToken() != null && transaction.getInformazioniNegoziazioneToken().getAccessToken() != null && transaction.getInformazioniNegoziazioneToken().isValid()) {
                if (this.transazioniPolicyNegoziazioneSavePurposeIdAlways || CostantiPdD.isTokenNegoziazionePdnd(info.getContext())) {
                    transactionDTO.setTokenPurposeId(TransazioneUtilities.extractClaimFromJWTAccessToken(transaction.getInformazioniNegoziazioneToken().getAccessToken(), "purposeId"));
                }
                transactionDTO.setTokenId(TransazioneUtilities.extractClaimFromJWTAccessToken(transaction.getInformazioniNegoziazioneToken().getAccessToken(), "jti"));
            }
            if (TipoPdD.APPLICATIVA.equals((Object)info.getTipoPorta()) && transaction.getInformazioniToken() != null) {
                if (transaction.getInformazioniToken().getClaims() != null && transaction.getInformazioniToken().getClaims().containsKey("purposeId") && (this.transazioniPolicyValidazioneSavePurposeIdAlways || CostantiPdD.isTokenValidazionePdnd(info.getContext()))) {
                    transactionDTO.setTokenPurposeId(transaction.getInformazioniToken().getClaims().get("purposeId").toString());
                }
                if (transaction.getInformazioniToken().getJti() != null) {
                    transactionDTO.setTokenId(transaction.getInformazioniToken().getJti());
                }
            }
            if (transactionDTO.getTokenPurposeId() != null && transactionDTO.getTokenPurposeId().length() > 50) {
                String msg = "Errore durante il salvataggio del purposeId '" + transactionDTO.getTokenPurposeId() + "': attesa una dimensione<=50, riscontrata:" + transactionDTO.getTokenPurposeId().length();
                this.logger.error(msg);
                transactionDTO.setTokenPurposeId(transactionDTO.getTokenPurposeId().substring(0, 45) + "...");
            }
            if (transactionDTO.getTokenId() != null && transactionDTO.getTokenId().length() > 50) {
                String msg = "Errore durante il salvataggio del tokenId '" + transactionDTO.getTokenId() + "': attesa una dimensione<=50, riscontrata:" + transactionDTO.getTokenId().length();
                this.logger.error(msg);
                transactionDTO.setTokenId(transactionDTO.getTokenId().substring(0, 45) + "...");
            }
            if (transactionDTO.getTokenInfo() == null && this.transazioniRegistrazioneAttributiInformazioniNormalizzate && transaction.getInformazioniAttributi() != null) {
                if (informazioniNegoziazioneToken != null) {
                    this.setTokenInfo(transactionDTO, informazioniNegoziazioneToken, transaction);
                } else {
                    this.setTokenInfo(transactionDTO, transaction);
                }
            }
            if (transactionDTO.getTokenInfo() == null && informazioniNegoziazioneToken != null) {
                this.setTokenInfo(transactionDTO, informazioniNegoziazioneToken);
            }
            if (times != null) {
                timeEnd = DateManager.getTimeMillis();
                long timeProcess7 = timeEnd - timeStart;
                times.fillTransactionDetails.add("token:" + timeProcess7);
                timeStart = DateManager.getTimeMillis();
            }
            if (this.transazioniRegistrazioneTempiElaborazione && transaction.getTempiElaborazione() != null) {
                this.setTempiElaborazione(transactionDTO, transaction);
            }
            if (times != null) {
                timeEnd = DateManager.getTimeMillis();
                long timeProcess8 = timeEnd - timeStart;
                times.fillTransactionDetails.add("times:" + timeProcess8);
                timeStart = DateManager.getTimeMillis();
            }
            this.setAccordoInfoClientAddress(transactionDTO, requestInfo, idDominio, info, idTransazione, times, timeStart, fase);
            if (times != null) {
                timeStart = DateManager.getTimeMillis();
            }
            if (!FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
                this.setEventi(transactionDTO, transaction, op2Properties, requestInfo, idDominio, info, idTransazione, times, timeStart, fase);
            }
            if (times != null) {
                timeStart = DateManager.getTimeMillis();
            }
            if (richiestaDuplicata) {
                transactionDTO.setDuplicatiRichiesta(-1);
            } else {
                transactionDTO.setDuplicatiRichiesta(0);
            }
            if (rispostaDuplicata) {
                transactionDTO.setDuplicatiRisposta(-1);
            } else {
                transactionDTO.setDuplicatiRisposta(0);
            }
            ExtendedTransactionInfo transactionExtendedInfo = null;
            if (info.getContext().getObject(Costanti.EXTENDED_INFO_TRANSAZIONE) != null && (keys = (transactionExtendedInfo = (ExtendedTransactionInfo)info.getContext().getObject(Costanti.EXTENDED_INFO_TRANSAZIONE)).keys()) != null && !keys.isEmpty()) {
                for (String key2 : keys) {
                    String value2 = transactionExtendedInfo.getValue(key2);
                    TransazioneExtendedInfo transazioneExtendedInfo = new TransazioneExtendedInfo();
                    transazioneExtendedInfo.setNome(key2);
                    transazioneExtendedInfo.setValore(value2);
                    transactionDTO.addTransazioneExtendedInfo(transazioneExtendedInfo);
                }
            }
            if (times != null) {
                long timeEnd9 = DateManager.getTimeMillis();
                long timeProcess9 = timeEnd9 - timeStart;
                times.fillTransactionDetails.add("ext-info:" + timeProcess9);
                timeStart = DateManager.getTimeMillis();
            }
            Transazione transazione = transactionDTO;
            if (consegnaMultiplaProfiloSincrono) {
                timeStart = this.consegnaMultiplaProfiloSincrono(info, idDominio, idTransazione, times, timeStart, schedulaNotificheDopoConsegnaSincrona, msgDiag, nomePorta);
            }
            if (identificativoSaveTransactionContext != null) {
                timeStart = this.saveTransactionContext(identificativoSaveTransactionContext, info, idDominio, idTransazione, times, timeStart, msgDiag);
            }
            return transazione;
        }
        catch (Exception e) {
            try {
                throw new HandlerException("Errore durante il popolamento della transazione da salvare su database: " + e.getLocalizedMessage(), e);
            }
            catch (Throwable throwable) {
                if (consegnaMultiplaProfiloSincrono) {
                    timeStart = this.consegnaMultiplaProfiloSincrono(info, idDominio, idTransazione, times, timeStart, schedulaNotificheDopoConsegnaSincrona, msgDiag, nomePorta);
                }
                if (identificativoSaveTransactionContext != null) {
                    timeStart = this.saveTransactionContext(identificativoSaveTransactionContext, info, idDominio, idTransazione, times, timeStart, msgDiag);
                }
                throw throwable;
            }
        }
    }

    private static String extractClaimFromJWTAccessToken(String jwt, String claim) {
        String[] infos = jwt.split("\\.");
        JSONUtils json = JSONUtils.getInstance();
        if (infos.length <= 1) {
            return null;
        }
        try {
            JsonNode node = json.getAsNode(Base64.getDecoder().decode(infos[1]));
            JsonNode value = node.get(claim);
            if (value != null && value.isTextual()) {
                return value.asText();
            }
        }
        catch (IllegalArgumentException | UtilsException throwable) {
            // empty catch block
        }
        return null;
    }

    private static void setDataAccettazioneRichiesta(Transazione transactionDTO, InformazioniTransazione info, Transaction transaction) {
        if (transaction.getDataAccettazioneRichiesta() != null) {
            transactionDTO.setDataAccettazioneRichiesta(transaction.getDataAccettazioneRichiesta());
        } else {
            Object o = info.getContext().getObject(CostantiPdD.DATA_ACCETTAZIONE_RICHIESTA);
            if (o instanceof Date) {
                transactionDTO.setDataAccettazioneRichiesta((Date)o);
            } else {
                transactionDTO.setDataAccettazioneRichiesta(DateManager.getDate());
            }
        }
    }

    private static void setDataIngressoRichiesta(OpenSPCoop2Properties op2Properties, Transazione transactionDTO, InformazioniTransazione info, Transaction transaction) {
        boolean valorizzataDataIngressoConDataAccettazione = op2Properties.isTransazioniValorizzaDataIngressoConDataAccettazione();
        if (valorizzataDataIngressoConDataAccettazione) {
            transactionDTO.setDataIngressoRichiesta(transactionDTO.getDataAccettazioneRichiesta());
        } else if (transaction.getDataIngressoRichiesta() != null) {
            transactionDTO.setDataIngressoRichiesta(transaction.getDataIngressoRichiesta());
        } else {
            Object o = info.getContext().getObject(CostantiPdD.DATA_INGRESSO_RICHIESTA);
            if (o instanceof Date) {
                transactionDTO.setDataIngressoRichiesta((Date)o);
            } else {
                transactionDTO.setDataIngressoRichiesta(DateManager.getDate());
            }
        }
    }

    private static void setDataIngressoRichiestaStream(Transazione transactionDTO, InformazioniTransazione info) {
        if (info.getContext() != null) {
            Object o = info.getContext().get(DiagnosticInputStream.DIAGNOSTIC_INPUT_STREAM_REQUEST_COMPLETE_DATE);
            if (o == null) {
                o = info.getContext().get(DiagnosticInputStream.DIAGNOSTIC_INPUT_STREAM_REQUEST_ERROR_DATE);
            }
            if (o instanceof Date) {
                Date d = (Date)o;
                transactionDTO.setDataIngressoRichiestaStream(d);
            }
        }
    }

    private static void setDataUscitaRichiesta(Transazione transactionDTO, FaseTracciamento fase, Transaction transaction) {
        if (FaseTracciamento.OUT_REQUEST.equals((Object)fase) || FaseTracciamento.OUT_RESPONSE.equals((Object)fase) || FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
            if (transaction.getDataUscitaRichiesta() != null) {
                transactionDTO.setDataUscitaRichiesta(transaction.getDataUscitaRichiesta());
            }
            if (transaction.getDataRichiestaInoltrata() != null) {
                transactionDTO.setDataUscitaRichiestaStream(transaction.getDataRichiestaInoltrata());
            }
        }
    }

    private static void setDataAccettazioneRisposta(Transazione transactionDTO, FaseTracciamento fase, Transaction transaction) {
        if ((FaseTracciamento.OUT_RESPONSE.equals((Object)fase) || FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) && transaction.getDataAccettazioneRisposta() != null) {
            transactionDTO.setDataAccettazioneRisposta(transaction.getDataAccettazioneRisposta());
        }
    }

    private static void setDataIngressoRisposta(OpenSPCoop2Properties op2Properties, Transazione transactionDTO, FaseTracciamento fase, Transaction transaction) {
        if (FaseTracciamento.OUT_RESPONSE.equals((Object)fase) || FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
            boolean valorizzataDataIngressoConDataAccettazione = op2Properties.isTransazioniValorizzaDataIngressoConDataAccettazione();
            if (valorizzataDataIngressoConDataAccettazione && transactionDTO.getDataAccettazioneRisposta() != null) {
                transactionDTO.setDataIngressoRisposta(transactionDTO.getDataAccettazioneRisposta());
            } else if (transaction.getDataIngressoRisposta() != null) {
                transactionDTO.setDataIngressoRisposta(transaction.getDataIngressoRisposta());
            }
        }
    }

    private static void setDataIngressoRispostaStream(Transazione transactionDTO, InformazioniTransazione info, FaseTracciamento fase) {
        if ((FaseTracciamento.OUT_RESPONSE.equals((Object)fase) || FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) && info.getContext() != null) {
            Object o = info.getContext().get(DiagnosticInputStream.DIAGNOSTIC_INPUT_STREAM_RESPONSE_COMPLETE_DATE);
            if (o == null) {
                o = info.getContext().get(DiagnosticInputStream.DIAGNOSTIC_INPUT_STREAM_RESPONSE_ERROR_DATE);
            }
            if (o instanceof Date) {
                Date d = (Date)o;
                transactionDTO.setDataIngressoRispostaStream(d);
            }
        }
    }

    private static void setDataUscitaRisposta(OpenSPCoop2Properties op2Properties, Transazione transactionDTO, InformazioniTransazione info, FaseTracciamento fase, Transaction transaction) {
        if (FaseTracciamento.OUT_RESPONSE.equals((Object)fase) || FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
            boolean calcolaDataUscitaRispostaConDateAfterResponseSent = op2Properties.isTransazioniValorizzaDataUscitaRispostaUseDateAfterResponseSent();
            if (calcolaDataUscitaRispostaConDateAfterResponseSent && info.getDataRispostaSpedita() != null) {
                if (FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
                    transactionDTO.setDataUscitaRisposta(info.getDataRispostaSpedita());
                }
            } else if (!calcolaDataUscitaRispostaConDateAfterResponseSent && info.getDataPrimaSpedizioneRisposta() != null) {
                transactionDTO.setDataUscitaRisposta(info.getDataPrimaSpedizioneRisposta());
            } else if (transaction.getDataUscitaRisposta() != null) {
                transactionDTO.setDataUscitaRisposta(transaction.getDataUscitaRisposta());
            } else {
                transactionDTO.setDataUscitaRisposta(DateManager.getDate());
            }
        }
    }

    private static void setDataUscitaRispostaStream(OpenSPCoop2Properties op2Properties, Transazione transactionDTO, InformazioniTransazione info, FaseTracciamento fase) {
        if (FaseTracciamento.OUT_RESPONSE.equals((Object)fase) || FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
            boolean calcolaDataUscitaRispostaConDateAfterResponseSent = op2Properties.isTransazioniValorizzaDataUscitaRispostaUseDateAfterResponseSent();
            if (calcolaDataUscitaRispostaConDateAfterResponseSent && info.getDataPrimaSpedizioneRisposta() != null) {
                transactionDTO.setDataUscitaRispostaStream(info.getDataPrimaSpedizioneRisposta());
            } else if (!calcolaDataUscitaRispostaConDateAfterResponseSent && info.getDataRispostaSpedita() != null && FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
                transactionDTO.setDataUscitaRispostaStream(info.getDataRispostaSpedita());
            }
            if (calcolaDataUscitaRispostaConDateAfterResponseSent && transactionDTO.getDataUscitaRispostaStream() == null) {
                transactionDTO.setDataUscitaRispostaStream(transactionDTO.getDataUscitaRisposta());
            }
        }
    }

    private static void setRichiestaIngressoBytes(Transazione transactionDTO, InformazioniTransazione info, Transaction transaction, FaseTracciamento fase) {
        if (info.getInputRequestMessageSize() != null && info.getInputRequestMessageSize() > 0L) {
            transactionDTO.setRichiestaIngressoBytes(info.getInputRequestMessageSize());
        }
        if (transactionDTO.getRichiestaIngressoBytes() == null && FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
            transactionDTO.setRichiestaIngressoBytes(TransazioneUtilities.readDimensioneFromDumpBinario(TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO, transaction));
        }
    }

    private static void setRichiestaUscitaBytes(Transazione transactionDTO, InformazioniTransazione info, Transaction transaction, FaseTracciamento fase) {
        if ((FaseTracciamento.OUT_REQUEST.equals((Object)fase) || FaseTracciamento.OUT_RESPONSE.equals((Object)fase) || FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) && info.getOutputRequestMessageSize() != null && info.getOutputRequestMessageSize() > 0L && transactionDTO.getDataUscitaRichiesta() != null) {
            transactionDTO.setRichiestaUscitaBytes(info.getOutputRequestMessageSize());
        }
        if (transactionDTO.getRichiestaUscitaBytes() == null && FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) {
            transactionDTO.setRichiestaUscitaBytes(TransazioneUtilities.readDimensioneFromDumpBinario(TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO, transaction));
        }
    }

    private static void setRispostaIngressoBytes(Transazione transactionDTO, InformazioniTransazione info, Transaction transaction, FaseTracciamento fase) {
        if ((FaseTracciamento.OUT_RESPONSE.equals((Object)fase) || FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) && info.getInputResponseMessageSize() != null && info.getInputResponseMessageSize() > 0L && transaction != null && transaction.getDataIngressoRisposta() != null) {
            Object o;
            boolean add = false;
            if (info.getContext() != null && (o = info.getContext().get(DiagnosticInputStream.DIAGNOSTIC_INPUT_STREAM_RESPONSE_START_DATE)) instanceof Date) {
                add = true;
            }
            if (add) {
                transactionDTO.setRispostaIngressoBytes(info.getInputResponseMessageSize());
            }
        }
    }

    private static void setRispostaUscitaBytes(Transazione transactionDTO, InformazioniTransazione info, FaseTracciamento fase) {
        if ((FaseTracciamento.OUT_RESPONSE.equals((Object)fase) || FaseTracciamento.POST_OUT_RESPONSE.equals((Object)fase)) && info.getOutputResponseMessageSize() != null && info.getOutputResponseMessageSize() > 0L) {
            transactionDTO.setRispostaUscitaBytes(info.getOutputResponseMessageSize());
        }
    }

    private static Long readDimensioneFromDumpBinario(TipoMessaggio tipoMessaggio, Transaction transaction) {
        if (transaction != null && !transaction.getMessaggi().isEmpty()) {
            for (Messaggio msg : transaction.getMessaggi()) {
                if (!tipoMessaggio.equals((Object)msg.getTipoMessaggio()) || msg.getBody() == null) continue;
                return msg.getBody().size();
            }
        }
        return null;
    }

    private void setFaultInfo(Transazione transactionDTO, OpenSPCoop2Properties op2Properties, InformazioniTransazione info) {
        String fault = null;
        String formatoFault = null;
        try {
            if (info.getResponse() != null) {
                if (org.openspcoop2.message.constants.ServiceBinding.SOAP.equals((Object)info.getResponse().getServiceBinding())) {
                    OpenSPCoop2SoapMessage soapMsg = info.getResponse().castAsSoap();
                    if (soapMsg.hasSOAPFault()) {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        bout.write(info.getResponse().getAsByte((Node)soapMsg.getSOAPPart().getEnvelope(), false));
                        bout.flush();
                        bout.close();
                        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioni(op2Properties.isTransazioniDebug());
                        if (op2Properties.isTransazioniFaultPrettyPrint()) {
                            byte[] content = bout.toByteArray();
                            fault = DumpUtility.toString(MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)soapMsg.getFactory()).newDocument(content), log, info.getResponse());
                        } else {
                            fault = bout.toString();
                        }
                        formatoFault = soapMsg.getMessageType().name();
                    }
                } else {
                    OpenSPCoop2RestMessage restMsg = info.getResponse().castAsRest();
                    if (restMsg.isProblemDetailsForHttpApis_RFC7807() || MessageRole.FAULT.equals((Object)restMsg.getMessageRole())) {
                        switch (restMsg.getMessageType()) {
                            case XML: {
                                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                                restMsg.writeTo((OutputStream)bout, false);
                                bout.flush();
                                bout.close();
                                Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioni(op2Properties.isTransazioniDebug());
                                if (op2Properties.isTransazioniFaultPrettyPrint()) {
                                    byte[] content = bout.toByteArray();
                                    fault = DumpUtility.toString(MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)restMsg.getFactory()).newDocument(content), log, info.getResponse());
                                } else {
                                    fault = bout.toString();
                                }
                                formatoFault = restMsg.getMessageType().name();
                                break;
                            }
                            case JSON: {
                                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                                restMsg.writeTo((OutputStream)bout, false);
                                bout.flush();
                                bout.close();
                                if (op2Properties.isTransazioniFaultPrettyPrint()) {
                                    JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
                                    byte[] content = bout.toByteArray();
                                    JsonNode jsonNode = jsonUtils.getAsNode(content);
                                    fault = jsonUtils.toString(jsonNode);
                                } else {
                                    fault = bout.toString();
                                }
                                formatoFault = restMsg.getMessageType().name();
                                break;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Errore durante il dump del soap fault", (Throwable)e);
        }
        if (TipoPdD.DELEGATA.equals((Object)info.getTipoPorta())) {
            transactionDTO.setFaultIntegrazione(fault);
            transactionDTO.setFormatoFaultIntegrazione(formatoFault);
        } else {
            transactionDTO.setFaultCooperazione(fault);
            transactionDTO.setFormatoFaultCooperazione(formatoFault);
        }
    }

    private IDAccordo getIdAccordo(Transazione transactionDTO, RegistroServiziManager registroServiziManager, RequestInfo requestInfo) {
        try {
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(transactionDTO.getTipoServizio(), transactionDTO.getNomeServizio(), transactionDTO.getTipoSoggettoErogatore(), transactionDTO.getNomeSoggettoErogatore(), transactionDTO.getVersioneServizio());
            AccordoServizioParteSpecifica asps = registroServiziManager.getAccordoServizioParteSpecifica(idServizio, null, Boolean.valueOf(false), requestInfo);
            return IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
        }
        catch (Exception e) {
            this.logger.error("Errore durante l'identificazione delle caratteristiche dell'API (Accesso servizio): " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean isCredenzialiMittenteEnabled(TipoCredenzialeMittente tipo, InformazioniTransazione info, RequestInfo requestInfo) {
        boolean defaultValue = OpenSPCoop2Properties.getInstance().isTransazioniCredenzialiMittenteEnabled(tipo);
        try {
            List<Proprieta> proprietaPorta = this.getProprietaPorta(info, requestInfo);
            if (proprietaPorta != null && !proprietaPorta.isEmpty()) {
                return CostantiProprieta.isTraceIndexEnabled(proprietaPorta, tipo, defaultValue);
            }
        }
        catch (Exception e) {
            this.logger.error("isCredenzialiMittenteEnabled(" + tipo.getRawValue() + "): " + e.getMessage(), (Throwable)e);
        }
        return defaultValue;
    }

    private List<Proprieta> getProprietaPorta(InformazioniTransazione info, RequestInfo requestInfo) {
        try {
            if (requestInfo != null && requestInfo.getProtocolContext() != null && requestInfo.getProtocolContext().getInterfaceName() != null) {
                String nomePorta = requestInfo.getProtocolContext().getInterfaceName();
                ConfigurazionePdDManager config = ConfigurazionePdDManager.getInstance();
                if (TipoPdD.APPLICATIVA.equals((Object)info.getTipoPorta())) {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(nomePorta);
                    PortaApplicativa pa = config.getPortaApplicativaSafeMethod(idPA, requestInfo);
                    if (pa != null && pa.sizeProprieta() > 0) {
                        return pa.getProprieta();
                    }
                } else if (TipoPdD.DELEGATA.equals((Object)info.getTipoPorta())) {
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(nomePorta);
                    PortaDelegata pd = config.getPortaDelegataSafeMethod(idPD, requestInfo);
                    if (pd != null && pd.sizeProprieta() > 0) {
                        return pd.getProprieta();
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("getProprietaPorta: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void setAccordoInfo(IDAccordo idAccordo, Transazione transactionDTO, OpenSPCoop2Properties op2Properties, RegistroServiziManager registroServiziManager, RequestInfo requestInfo, IDSoggetto idDominio, InformazioniTransazione info, String idTransazione, TransazioniProcessTimes times, long timeStart, FaseTracciamento fase) {
        long timeProcess;
        try {
            AccordoServizioParteComune aspc = registroServiziManager.getAccordoServizioParteComune(idAccordo, null, Boolean.valueOf(false), Boolean.valueOf(false), requestInfo);
            if (ServiceBinding.REST.equals((Object)aspc.getServiceBinding())) {
                transactionDTO.setTipoApi(TipoAPI.REST.getValoreAsInt());
            } else {
                transactionDTO.setTipoApi(TipoAPI.SOAP.getValoreAsInt());
            }
            if (times != null) {
                long timeEnd = DateManager.getTimeMillis();
                timeProcess = timeEnd - timeStart;
                times.fillTransactionDetails.add("api:" + timeProcess);
                timeStart = DateManager.getTimeMillis();
            }
            String conflict = this.setAccordoInfoGruppi(aspc, transactionDTO, op2Properties, requestInfo, idDominio, info, idTransazione, times, fase);
            if (times != null) {
                long timeEnd = DateManager.getTimeMillis();
                long timeProcess2 = timeEnd - timeStart;
                times.fillTransactionDetails.add("tags:" + timeProcess2 + "/c" + conflict);
                timeStart = DateManager.getTimeMillis();
            }
        }
        catch (Exception e) {
            this.logger.error("Errore durante l'identificazione delle caratteristiche dell'API (Accesso servizio): " + e.getMessage(), (Throwable)e);
        }
        String conflict = this.setAccordoInfoUriAPC(idAccordo, transactionDTO, requestInfo, idDominio, info, idTransazione, times, fase);
        if (times != null) {
            long timeEnd = DateManager.getTimeMillis();
            timeProcess = timeEnd - timeStart;
            times.fillTransactionDetails.add("uri-api:" + timeProcess + "/c" + conflict);
        }
    }

    private String getCredenzialiMittenteGruppi(InformazioniTransazione info) {
        return info != null && info.getContext() != null ? (String)info.getContext().get(CREDENZIALI_MITTENTE_GRUPPI_RESOLVED) : null;
    }

    private void addCredenzialiMittenteGruppi(InformazioniTransazione info, String cred) {
        if (info != null && info.getContext() != null) {
            info.getContext().put(CREDENZIALI_MITTENTE_GRUPPI_RESOLVED, (Object)cred);
        }
    }

    private String setAccordoInfoGruppi(AccordoServizioParteComune aspc, Transazione transactionDTO, OpenSPCoop2Properties op2Properties, RequestInfo requestInfo, IDSoggetto idDominio, InformazioniTransazione info, String idTransazione, TransazioniProcessTimes times, FaseTracciamento fase) throws CoreException {
        String conflict = "0";
        if (!this.isCredenzialiMittenteEnabled(TipoCredenzialeMittente.GRUPPI, info, requestInfo)) {
            return conflict;
        }
        if (aspc.getGruppi() != null && aspc.getGruppi().sizeGruppoList() > 0) {
            Object cred = this.getCredenzialiMittenteGruppi(info);
            if (cred != null && StringUtils.isNotEmpty((String)cred)) {
                transactionDTO.setGruppi((String)cred);
            } else {
                ArrayList<String> gruppi = new ArrayList<String>();
                int count = 0;
                int maxLengthCredenziali = op2Properties.getTransazioniCredenzialiMittenteMaxLength() - "##".length();
                for (int i = 0; i < aspc.getGruppi().sizeGruppoList(); ++i) {
                    GruppoAccordo gruppoAccordo = aspc.getGruppi().getGruppo(i);
                    String dbValue = AbstractCredenzialeList.getDBValue((String)gruppoAccordo.getNome());
                    if (count + dbValue.length() >= maxLengthCredenziali) continue;
                    gruppi.add(gruppoAccordo.getNome());
                    count += dbValue.length();
                }
                if (!gruppi.isEmpty()) {
                    StringBuilder sbConflict = null;
                    if (times != null) {
                        sbConflict = new StringBuilder();
                    }
                    CredenzialeMittente credGruppi = null;
                    try {
                        credGruppi = GestoreAutenticazione.convertGruppiToCredenzialiMittenti(idDominio, info.getIdModulo(), idTransazione, gruppi, null, fase.name() + ".gruppi", sbConflict, requestInfo);
                    }
                    catch (Exception e) {
                        throw new CoreException(e.getMessage(), (Throwable)e);
                    }
                    if (sbConflict != null && sbConflict.length() > 0) {
                        conflict = sbConflict.toString();
                    }
                    if (credGruppi != null) {
                        cred = "" + credGruppi.getId();
                        transactionDTO.setGruppi((String)cred);
                        this.addCredenzialiMittenteGruppi(info, (String)cred);
                    }
                }
            }
        }
        return conflict;
    }

    private String getCredenzialiMittenteUriAPC(InformazioniTransazione info) {
        return info != null && info.getContext() != null ? (String)info.getContext().get(CREDENZIALI_MITTENTE_URI_APC_RESOLVED) : null;
    }

    private void addCredenzialiMittenteUriAPC(InformazioniTransazione info, String cred) {
        if (info != null && info.getContext() != null) {
            info.getContext().put(CREDENZIALI_MITTENTE_URI_APC_RESOLVED, (Object)cred);
        }
    }

    private String setAccordoInfoUriAPC(IDAccordo idAccordo, Transazione transactionDTO, RequestInfo requestInfo, IDSoggetto idDominio, InformazioniTransazione info, String idTransazione, TransazioniProcessTimes times, FaseTracciamento fase) {
        String conflict = "0";
        if (!this.isCredenzialiMittenteEnabled(TipoCredenzialeMittente.API, info, requestInfo)) {
            return conflict;
        }
        try {
            Object cred = this.getCredenzialiMittenteUriAPC(info);
            if (cred != null && StringUtils.isNotEmpty((String)cred)) {
                transactionDTO.setUriApi((String)cred);
            } else {
                if (transactionDTO.getUriAccordoServizio() == null) {
                    transactionDTO.setUriAccordoServizio(IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordo));
                }
                StringBuilder sbConflict = null;
                if (times != null) {
                    sbConflict = new StringBuilder();
                }
                CredenzialeMittente credAPI = GestoreAutenticazione.convertAPIToCredenzialiMittenti(idDominio, info.getIdModulo(), idTransazione, transactionDTO.getUriAccordoServizio(), null, fase.name() + ".api", sbConflict, requestInfo);
                if (sbConflict != null && sbConflict.length() > 0) {
                    conflict = sbConflict.toString();
                }
                if (credAPI != null) {
                    cred = "" + credAPI.getId();
                    transactionDTO.setUriApi((String)cred);
                    this.addCredenzialiMittenteUriAPC(info, (String)cred);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Errore durante l'identificazione dell'identificativo dell'API (Accesso servizio parte comune): " + e.getMessage(), (Throwable)e);
        }
        return conflict;
    }

    private void setHeaderProtocolloRichiesta(Transazione transactionDTO, Traccia tracciaRichiesta) {
        try {
            transactionDTO.setHeaderProtocolloRichiesta(tracciaRichiesta.getBustaAsRawContent().toString(TipoSerializzazione.DEFAULT));
        }
        catch (Exception e) {
            String msg = "Errore durante la conversione dell'oggetto Busta di richiesta [" + tracciaRichiesta.getBustaAsRawContent().getClass().getName() + "] in stringa";
            this.logger.error(msg);
        }
    }

    private void setProtocolloExtInfoRichiesta(Transazione transactionDTO, PropertiesSerializator ps) {
        try {
            transactionDTO.setProtocolloExtInfoRichiesta(ps.convertToDBColumnValue());
        }
        catch (Exception e) {
            this.logger.error("Errore durante la conversione delle proprieta della Busta di richiesta: " + e.getMessage(), (Throwable)e);
        }
    }

    private void setHeaderProtocolloRisposta(Transazione transactionDTO, Traccia tracciaRisposta) {
        try {
            transactionDTO.setHeaderProtocolloRisposta(tracciaRisposta.getBustaAsRawContent().toString(TipoSerializzazione.DEFAULT));
        }
        catch (Exception e) {
            String msg = "Errore durante la conversione dell'oggetto Busta di risposta [" + tracciaRisposta.getBustaAsRawContent().getClass().getName() + "] in stringa";
            this.logger.error(msg);
        }
    }

    private void setProtocolloExtInfoRisposta(Transazione transactionDTO, PropertiesSerializator ps) {
        try {
            transactionDTO.setProtocolloExtInfoRisposta(ps.convertToDBColumnValue());
        }
        catch (Exception e) {
            this.logger.error("Errore durante la conversione delle proprieta della Busta di risposta: " + e.getMessage(), (Throwable)e);
        }
    }

    private void setTokenInfo(Transazione transactionDTO, InformazioniToken informazioniToken) {
        try {
            transactionDTO.setTokenInfo(informazioniToken.toJson());
        }
        catch (Exception t) {
            this.logger.error("Serializzazione informazioni token non riuscita: " + t.getMessage(), (Throwable)t);
        }
    }

    private void setTokenInfo(Transazione transactionDTO, InformazioniNegoziazioneToken informazioniNegoziazioneToken, Transaction transaction) {
        try {
            InformazioniToken infoToken = new InformazioniToken();
            infoToken.setRetrievedToken(informazioniNegoziazioneToken);
            infoToken.setAa(transaction.getInformazioniAttributi());
            transactionDTO.setTokenInfo(infoToken.toJson());
        }
        catch (Exception t) {
            this.logger.error("Serializzazione informazioni attributi (aggregato insieme a client assertion) non riuscita: " + t.getMessage(), (Throwable)t);
        }
    }

    private void setTokenInfo(Transazione transactionDTO, Transaction transaction) {
        try {
            transactionDTO.setTokenInfo(transaction.getInformazioniAttributi().toJson());
        }
        catch (Exception t) {
            this.logger.error("Serializzazione informazioni attributi non riuscita: " + t.getMessage(), (Throwable)t);
        }
    }

    private void setTokenInfo(Transazione transactionDTO, InformazioniNegoziazioneToken informazioniNegoziazioneToken) {
        try {
            transactionDTO.setTokenInfo(informazioniNegoziazioneToken.toJson());
        }
        catch (Exception t) {
            this.logger.error("Serializzazione informazioni client assertion non riuscita: " + t.getMessage(), (Throwable)t);
        }
    }

    private void setTempiElaborazione(Transazione transactionDTO, Transaction transaction) {
        try {
            transactionDTO.setTempiElaborazione(TempiElaborazioneUtils.convertToDBValue((TempiElaborazione)transaction.getTempiElaborazione()));
        }
        catch (Exception e) {
            this.logger.error("TempiElaborazioneUtils.convertToDBValue failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private String getCredenzialiMittenteClientAddress(InformazioniTransazione info) {
        return info != null && info.getContext() != null ? (String)info.getContext().get(CREDENZIALI_MITTENTE_CLIENT_ADDRESS_RESOLVED) : null;
    }

    private void addCredenzialiMittenteClientAddress(InformazioniTransazione info, String cred) {
        if (info != null && info.getContext() != null) {
            info.getContext().put(CREDENZIALI_MITTENTE_CLIENT_ADDRESS_RESOLVED, (Object)cred);
        }
    }

    private void setAccordoInfoClientAddress(Transazione transactionDTO, RequestInfo requestInfo, IDSoggetto idDominio, InformazioniTransazione info, String idTransazione, TransazioniProcessTimes times, long timeStart, FaseTracciamento fase) {
        Object oIpAddressTransport;
        if (!this.isCredenzialiMittenteEnabled(TipoCredenzialeMittente.CLIENT_ADDRESS, info, requestInfo)) {
            return;
        }
        Object oIpAddressRemote = info.getContext().getObject(Costanti.CLIENT_IP_REMOTE_ADDRESS);
        if (oIpAddressRemote instanceof String) {
            String ipAddress = (String)oIpAddressRemote;
            if (ipAddress.length() <= 255) {
                transactionDTO.setSocketClientAddress(ipAddress);
            } else {
                transactionDTO.setSocketClientAddress(ipAddress.substring(0, 250) + "...");
            }
        }
        if ((oIpAddressTransport = info.getContext().getObject(Costanti.CLIENT_IP_TRANSPORT_ADDRESS)) instanceof String) {
            String ipAddress = (String)oIpAddressTransport;
            if (ipAddress.length() <= 255) {
                transactionDTO.setTransportClientAddress(ipAddress);
            } else {
                transactionDTO.setTransportClientAddress(ipAddress.substring(0, 250) + "...");
            }
        }
        this.setAccordoInfoClientAddressCredenzialiMittente(transactionDTO, requestInfo, idDominio, info, idTransazione, times, timeStart, fase);
    }

    private void setAccordoInfoClientAddressCredenzialiMittente(Transazione transactionDTO, RequestInfo requestInfo, IDSoggetto idDominio, InformazioniTransazione info, String idTransazione, TransazioniProcessTimes times, long timeStart, FaseTracciamento fase) {
        String conflict = "0";
        if (transactionDTO.getSocketClientAddress() != null || transactionDTO.getTransportClientAddress() != null) {
            Object cred = this.getCredenzialiMittenteClientAddress(info);
            if (cred != null && StringUtils.isNotEmpty((String)cred)) {
                transactionDTO.setClientAddress((String)cred);
            } else {
                try {
                    String transportAddressForCredential;
                    StringBuilder sbConflict = null;
                    if (times != null) {
                        sbConflict = new StringBuilder();
                    }
                    if ((transportAddressForCredential = transactionDTO.getTransportClientAddress()) != null && OpenSPCoop2Properties.getInstance().isTransazioniTracciamentoDBTransportClientAddressSanitizePort()) {
                        transportAddressForCredential = HttpClientAddressSanitizer.sanitizeTransportAddressPort((String)transportAddressForCredential);
                    }
                    CredenzialeMittente credClientAddress = GestoreAutenticazione.convertClientCredentialToCredenzialiMittenti(idDominio, info.getIdModulo(), idTransazione, transactionDTO.getSocketClientAddress(), transportAddressForCredential, null, fase.name() + ".clientAddress", sbConflict, requestInfo);
                    if (sbConflict != null && sbConflict.length() > 0) {
                        conflict = sbConflict.toString();
                    }
                    if (credClientAddress != null) {
                        cred = "" + credClientAddress.getId();
                        transactionDTO.setClientAddress((String)cred);
                        this.addCredenzialiMittenteClientAddress(info, (String)cred);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Errore durante la scrittura dell'indice per la ricerca del client address: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (times != null) {
            long timeEnd = DateManager.getTimeMillis();
            long timeProcess = timeEnd - timeStart;
            times.fillTransactionDetails.add("ip-address:" + timeProcess + "/c" + conflict);
        }
    }

    private void setEventi(Transazione transactionDTO, Transaction transaction, OpenSPCoop2Properties op2Properties, RequestInfo requestInfo, IDSoggetto idDominio, InformazioniTransazione info, String idTransazione, TransazioniProcessTimes times, long timeStart, FaseTracciamento fase) throws CoreException {
        String max;
        String dbValue;
        Object oEventoMax;
        String evento;
        String dbValue2;
        String evento2;
        String dbValue3;
        if (!this.isCredenzialiMittenteEnabled(TipoCredenzialeMittente.EVENTI, info, requestInfo)) {
            return;
        }
        ArrayList<String> eventiGestione = new ArrayList<String>();
        int count = 0;
        int maxLengthCredenziali = op2Properties.getTransazioniCredenzialiMittenteMaxLength() - "##".length();
        if (op2Properties.isTransazioniHttpStatusAsEvent_outResponseCode() && transactionDTO.getCodiceRispostaUscita() != null && !"".equals(transactionDTO.getCodiceRispostaUscita()) && count + (dbValue3 = AbstractCredenzialeList.getDBValue((String)(evento2 = "Out=" + transactionDTO.getCodiceRispostaUscita()))).length() < maxLengthCredenziali) {
            eventiGestione.add(evento2);
            count += dbValue3.length();
        }
        if (op2Properties.isTransazioniHttpStatusAsEvent_inResponseCode() && transactionDTO.getCodiceRispostaIngresso() != null && !"".equals(transactionDTO.getCodiceRispostaIngresso()) && count + (dbValue3 = AbstractCredenzialeList.getDBValue((String)(evento2 = "In=" + transactionDTO.getCodiceRispostaIngresso()))).length() < maxLengthCredenziali) {
            eventiGestione.add(evento2);
            count += dbValue3.length();
        }
        if (op2Properties.isTransazioniTipoApiAsEvent() && transactionDTO.getTipoApi() > 0 && count + (dbValue3 = AbstractCredenzialeList.getDBValue((String)(evento2 = "API=" + transactionDTO.getTipoApi()))).length() < maxLengthCredenziali) {
            eventiGestione.add(evento2);
            count += dbValue3.length();
        }
        String consegneMultipleById = TransazioneUtilities.getConnettoriMultipli(info.getContext());
        if (op2Properties.isTransazioniConnettoriMultipliAsEvent() && consegneMultipleById != null && count + (dbValue2 = AbstractCredenzialeList.getDBValue((String)(evento = "Async=" + consegneMultipleById))).length() < maxLengthCredenziali) {
            eventiGestione.add(evento);
            count += dbValue2.length();
        }
        if (transaction.getEventiGestione() != null && !transaction.getEventiGestione().isEmpty()) {
            for (int i = 0; i < transaction.getEventiGestione().size(); ++i) {
                dbValue2 = AbstractCredenzialeList.getDBValue((String)transaction.getEventiGestione().get(i));
                if (count + dbValue2.length() >= maxLengthCredenziali) continue;
                eventiGestione.add(transaction.getEventiGestione().get(i));
                count += dbValue2.length();
            }
        }
        if ((oEventoMax = info.getContext().getObject(CostantiControlloTraffico.PDD_CONTEXT_MAX_REQUEST_VIOLATED_EVENTO)) instanceof String && count + (dbValue = AbstractCredenzialeList.getDBValue((String)(max = (String)oEventoMax))).length() < maxLengthCredenziali) {
            eventiGestione.add(max);
        }
        String conflict = "0";
        if (!eventiGestione.isEmpty()) {
            try {
                StringBuilder sbConflict = null;
                if (times != null) {
                    sbConflict = new StringBuilder();
                }
                CredenzialeMittente credEventi = GestoreAutenticazione.convertEventiToCredenzialiMittenti(idDominio, info.getIdModulo(), idTransazione, eventiGestione, null, fase.name() + ".eventi", sbConflict, requestInfo);
                if (sbConflict != null && sbConflict.length() > 0) {
                    conflict = sbConflict.toString();
                }
                if (credEventi != null) {
                    transactionDTO.setEventiGestione("" + credEventi.getId());
                }
            }
            catch (Exception e) {
                this.logger.error("Errore durante la definizione dell'indice per la ricerca degli eventi: " + e.getMessage(), (Throwable)e);
            }
        }
        if (times != null) {
            long timeEnd = DateManager.getTimeMillis();
            long timeProcess = timeEnd - timeStart;
            times.fillTransactionDetails.add("eventi:" + timeProcess + "/c" + conflict);
        }
    }

    private boolean isEsito(List<Integer> esiti, int esitoCheck) {
        for (int esito : esiti) {
            if (esitoCheck != esito) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long consegnaMultiplaProfiloSincrono(InformazioniTransazione info, IDSoggetto idDominio, String idTransazione, TransazioniProcessTimes times, long timeStart, boolean schedulaNotificheDopoConsegnaSincrona, MsgDiagnostico msgDiag, String nomePorta) {
        block26: {
            IOpenSPCoopState openspcoopState;
            block25: {
                openspcoopState = null;
                OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
                EJBUtilsMessaggioInConsegna messaggiInConsegna = null;
                Object oConnettoreConfig = info.getContext().getObject(CostantiPdD.TIMER_RICONSEGNA_CONTENUTI_APPLICATIVI_MESSAGGI_SPEDIRE);
                if (oConnettoreConfig instanceof EJBUtilsMessaggioInConsegna) {
                    messaggiInConsegna = (EJBUtilsMessaggioInConsegna)oConnettoreConfig;
                }
                if (messaggiInConsegna == null) {
                    this.logger.error("Non \u00e8 stato possibile gestire lo scheduling delle notifiche (connettori multipli): configurazione non disponibile");
                    break block25;
                }
                openspcoopState = new OpenSPCoopStateful();
                openspcoopState.initResource(idDominio, info.getIdModulo(), idTransazione);
                if (times != null) {
                    long timeEnd = DateManager.getTimeMillis();
                    long timeProcess = timeEnd - timeStart;
                    times.fillTransactionDetails.add("async-send-getConnection:" + timeProcess);
                    timeStart = DateManager.getTimeMillis();
                }
                GestoreMessaggi msgRequest = new GestoreMessaggi(openspcoopState, true, messaggiInConsegna.getBusta().getID(), "INBOX", msgDiag, (PdDContext)info.getContext());
                if (schedulaNotificheDopoConsegnaSincrona) {
                    RepositoryBuste repositoryBuste = null;
                    boolean spedizioneConsegnaContenuti = false;
                    Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniSql(op2Properties.isTransazioniDebug());
                    msgRequest.releaseAttesaEsiti(op2Properties.isTransazioniDebug(), log);
                    EJBUtils.sendMessages(this.logger, msgDiag, openspcoopState, idTransazione, repositoryBuste, msgRequest, null, info.getProtocolFactory(), idDominio, nomePorta, messaggiInConsegna, spedizioneConsegnaContenuti, (PdDContext)info.getContext(), ConfigurazionePdDManager.getInstance());
                    if (times != null) {
                        long timeEnd = DateManager.getTimeMillis();
                        long timeProcess = timeEnd - timeStart;
                        times.fillTransactionDetails.add("async-send:" + timeProcess);
                        timeStart = DateManager.getTimeMillis();
                    }
                    break block25;
                }
                for (String servizioApplicativo : messaggiInConsegna.getServiziApplicativi()) {
                    msgRequest.eliminaDestinatarioMessaggio(servizioApplicativo, null, messaggiInConsegna.getOraRegistrazioneMessaggio());
                }
                if (times == null) break block25;
                long timeEnd = DateManager.getTimeMillis();
                long timeProcess = timeEnd - timeStart;
                times.fillTransactionDetails.add("async-send-del:" + timeProcess);
                timeStart = DateManager.getTimeMillis();
            }
            try {
                if (openspcoopState != null && !openspcoopState.resourceReleased()) {
                    openspcoopState.commit();
                    if (times != null) {
                        long timeEnd = DateManager.getTimeMillis();
                        long timeProcess = timeEnd - timeStart;
                        times.fillTransactionDetails.add("async-send-commit:" + timeProcess);
                        timeStart = DateManager.getTimeMillis();
                    }
                    openspcoopState.releaseResource();
                    if (times != null) {
                        long timeEnd = DateManager.getTimeMillis();
                        long timeProcess = timeEnd - timeStart;
                        times.fillTransactionDetails.add("async-send-finish:" + timeProcess);
                        timeStart = DateManager.getTimeMillis();
                    }
                }
                break block26;
            }
            catch (Exception timeEnd) {}
            break block26;
            catch (Exception e) {
                try {
                    this.logger.error("Non \u00e8 stato possibile gestire lo scheduling delle notifiche (connettori multipli): " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (openspcoopState != null && !openspcoopState.resourceReleased()) {
                            long timeProcess;
                            long timeEnd;
                            openspcoopState.commit();
                            if (times != null) {
                                timeEnd = DateManager.getTimeMillis();
                                timeProcess = timeEnd - timeStart;
                                times.fillTransactionDetails.add("async-send-commit:" + timeProcess);
                                timeStart = DateManager.getTimeMillis();
                            }
                            openspcoopState.releaseResource();
                            if (times != null) {
                                timeEnd = DateManager.getTimeMillis();
                                timeProcess = timeEnd - timeStart;
                                times.fillTransactionDetails.add("async-send-finish:" + timeProcess);
                                timeStart = DateManager.getTimeMillis();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (openspcoopState != null && !openspcoopState.resourceReleased()) {
                        long timeProcess;
                        openspcoopState.commit();
                        if (times != null) {
                            long timeEnd = DateManager.getTimeMillis();
                            timeProcess = timeEnd - timeStart;
                            times.fillTransactionDetails.add("async-send-commit:" + timeProcess);
                            timeStart = DateManager.getTimeMillis();
                        }
                        openspcoopState.releaseResource();
                        if (times != null) {
                            long timeEnd = DateManager.getTimeMillis();
                            timeProcess = timeEnd - timeStart;
                            times.fillTransactionDetails.add("async-send-finish:" + timeProcess);
                            timeStart = DateManager.getTimeMillis();
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
        return timeStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long saveTransactionContext(String identificativoSaveTransactionContext, InformazioniTransazione info, IDSoggetto idDominio, String idTransazione, TransazioniProcessTimes times, long timeStart, MsgDiagnostico msgDiag) {
        block21: {
            long timeProcess;
            OpenSPCoopStateful openspcoopState;
            block20: {
                openspcoopState = null;
                openspcoopState = new OpenSPCoopStateful();
                openspcoopState.initResource(idDominio, info.getIdModulo(), idTransazione);
                if (times != null) {
                    long timeEnd = DateManager.getTimeMillis();
                    timeProcess = timeEnd - timeStart;
                    times.fillTransactionDetails.add("async-send-saveTransactionContext:" + timeProcess);
                    timeStart = DateManager.getTimeMillis();
                }
                GestoreMessaggi msgRequest = new GestoreMessaggi(openspcoopState, true, identificativoSaveTransactionContext, "INBOX", msgDiag, (PdDContext)info.getContext());
                msgRequest.registraTransactionContext_statelessEngine(identificativoSaveTransactionContext, info.getContext());
                if (times == null) break block20;
                long timeEnd = DateManager.getTimeMillis();
                long timeProcess2 = timeEnd - timeStart;
                times.fillTransactionDetails.add("async-send-saveTransactionContext-saved:" + timeProcess2);
                timeStart = DateManager.getTimeMillis();
            }
            try {
                if (openspcoopState != null && !openspcoopState.resourceReleased()) {
                    openspcoopState.commit();
                    if (times != null) {
                        long timeEnd = DateManager.getTimeMillis();
                        timeProcess = timeEnd - timeStart;
                        times.fillTransactionDetails.add("async-send-saveTransactionContext-commit:" + timeProcess);
                        timeStart = DateManager.getTimeMillis();
                    }
                    openspcoopState.releaseResource();
                    if (times != null) {
                        long timeEnd = DateManager.getTimeMillis();
                        timeProcess = timeEnd - timeStart;
                        times.fillTransactionDetails.add("async-send-saveTransactionContext-finish:" + timeProcess);
                        timeStart = DateManager.getTimeMillis();
                    }
                }
                break block21;
            }
            catch (Exception timeEnd) {}
            break block21;
            catch (Exception e) {
                try {
                    this.logger.error("Non \u00e8 stato possibile salvare il contesto della transazione per le notifiche (connettori multipli): " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (openspcoopState != null && !openspcoopState.resourceReleased()) {
                            long timeProcess3;
                            long timeEnd;
                            openspcoopState.commit();
                            if (times != null) {
                                timeEnd = DateManager.getTimeMillis();
                                timeProcess3 = timeEnd - timeStart;
                                times.fillTransactionDetails.add("async-send-saveTransactionContext-commit:" + timeProcess3);
                                timeStart = DateManager.getTimeMillis();
                            }
                            openspcoopState.releaseResource();
                            if (times != null) {
                                timeEnd = DateManager.getTimeMillis();
                                timeProcess3 = timeEnd - timeStart;
                                times.fillTransactionDetails.add("async-send-saveTransactionContext-finish:" + timeProcess3);
                                timeStart = DateManager.getTimeMillis();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (openspcoopState != null && !openspcoopState.resourceReleased()) {
                        long timeProcess4;
                        openspcoopState.commit();
                        if (times != null) {
                            long timeEnd = DateManager.getTimeMillis();
                            timeProcess4 = timeEnd - timeStart;
                            times.fillTransactionDetails.add("async-send-saveTransactionContext-commit:" + timeProcess4);
                            timeStart = DateManager.getTimeMillis();
                        }
                        openspcoopState.releaseResource();
                        if (times != null) {
                            long timeEnd = DateManager.getTimeMillis();
                            timeProcess4 = timeEnd - timeStart;
                            times.fillTransactionDetails.add("async-send-saveTransactionContext-finish:" + timeProcess4);
                            timeStart = DateManager.getTimeMillis();
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
        return timeStart;
    }

    public static Busta convertToBusta(Transazione transazioneDTO) {
        Busta busta = new Busta(transazioneDTO.getProtocollo());
        busta.setTipoMittente(transazioneDTO.getTipoSoggettoFruitore());
        busta.setMittente(transazioneDTO.getNomeSoggettoFruitore());
        busta.setIdentificativoPortaMittente(transazioneDTO.getIdportaSoggettoFruitore());
        busta.setIndirizzoMittente(transazioneDTO.getIndirizzoSoggettoFruitore());
        busta.setTipoDestinatario(transazioneDTO.getTipoSoggettoErogatore());
        busta.setDestinatario(transazioneDTO.getNomeSoggettoErogatore());
        busta.setIdentificativoPortaDestinatario(transazioneDTO.getIdportaSoggettoErogatore());
        busta.setIndirizzoDestinatario(transazioneDTO.getIndirizzoSoggettoErogatore());
        busta.setTipoServizio(transazioneDTO.getTipoServizio());
        busta.setServizio(transazioneDTO.getNomeServizio());
        busta.setVersioneServizio(Integer.valueOf(transazioneDTO.getVersioneServizio()));
        busta.setAzione(transazioneDTO.getAzione());
        busta.setID(transazioneDTO.getIdMessaggioRichiesta());
        busta.setRiferimentoMessaggio(transazioneDTO.getIdMessaggioRisposta());
        busta.setCollaborazione(transazioneDTO.getIdCollaborazione());
        busta.setServizioApplicativoFruitore(transazioneDTO.getServizioApplicativoFruitore());
        busta.setServizioApplicativoErogatore(transazioneDTO.getServizioApplicativoErogatore());
        return busta;
    }
}

