/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.dynamic.PddPluginLoader;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.integrazione.peer.HeaderMap;
import org.openspcoop2.pdd.core.integrazione.peer.PeerHeaderDescriptor;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.transport.TransportResponseContext;
import org.slf4j.Logger;

public abstract class GenericLib {
    protected Logger log = null;
    protected OpenSPCoop2Properties propertiesReader;
    protected Loader loader;
    protected PddPluginLoader pluginLoader;
    protected String idModulo;
    protected ProtocolFactoryManager protocolFactoryManager = null;
    protected boolean inizializzazioneUltimata = false;

    public boolean getInizializzazioneUltimata() {
        return this.inizializzazioneUltimata;
    }

    protected synchronized void inizializza() throws GenericLibException {
        if (!this.inizializzazioneUltimata) {
            try {
                this.propertiesReader = OpenSPCoop2Properties.getInstance();
                this.loader = Loader.getInstance();
                this.pluginLoader = PddPluginLoader.getInstance();
                this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
                boolean error = false;
                this.inizializzazioneUltimata = !error;
            }
            catch (Exception e) {
                throw new GenericLibException(e.getMessage(), e);
            }
        }
    }

    public GenericLib(String idModulo, Logger log) {
        this.idModulo = idModulo;
        this.log = log;
    }

    protected MsgDiagnostico initMsgDiagnostico(ConfigurazionePdDManager configurazionePdDManager) throws OpenSPCoopStateException {
        try {
            return MsgDiagnostico.newInstance(this.idModulo, configurazionePdDManager);
        }
        catch (Exception e) {
            this.log.error("Riscontrato Errore durante l'inizializzazione del MsgDiagnostico", (Throwable)e);
            throw new OpenSPCoopStateException("Riscontrato Errore durante l'inizializzazione del MsgDiagnostico");
        }
    }

    public EsitoLib onMessage(IOpenSPCoopState openspcoop_state, RegistroServiziManager registroServiziManager, ConfigurazionePdDManager configurazionePdDManager) throws OpenSPCoopStateException {
        if (registroServiziManager != null && configurazionePdDManager != null) {
            return this._onMessage(openspcoop_state, registroServiziManager, configurazionePdDManager, this.initMsgDiagnostico(configurazionePdDManager));
        }
        return this.onMessage(openspcoop_state);
    }

    public EsitoLib onMessage(IOpenSPCoopState openspcoop_state, ConfigurazionePdDManager configurazionePdDManager) throws OpenSPCoopStateException {
        if (configurazionePdDManager != null && configurazionePdDManager.getRegistroServiziManager() != null) {
            return this._onMessage(openspcoop_state, configurazionePdDManager.getRegistroServiziManager(), configurazionePdDManager, this.initMsgDiagnostico(configurazionePdDManager));
        }
        return this.onMessage(openspcoop_state);
    }

    public EsitoLib onMessage(IOpenSPCoopState openspcoop_state) throws OpenSPCoopStateException {
        RegistroServiziManager registroServiziManager = null;
        ConfigurazionePdDManager configurazionePdDManager = null;
        if (openspcoop_state instanceof OpenSPCoopState) {
            OpenSPCoopState openspcoopState = (OpenSPCoopState)openspcoop_state;
            registroServiziManager = RegistroServiziManager.getInstance((IState)openspcoopState.getStatoRichiesta(), (IState)openspcoopState.getStatoRisposta());
            configurazionePdDManager = ConfigurazionePdDManager.getInstance(openspcoopState.getStatoRichiesta(), openspcoopState.getStatoRisposta());
        } else {
            registroServiziManager = RegistroServiziManager.getInstance();
            configurazionePdDManager = ConfigurazionePdDManager.getInstance();
        }
        return this._onMessage(openspcoop_state, registroServiziManager, configurazionePdDManager, this.initMsgDiagnostico(configurazionePdDManager));
    }

    public abstract EsitoLib _onMessage(IOpenSPCoopState var1, RegistroServiziManager var2, ConfigurazionePdDManager var3, MsgDiagnostico var4) throws OpenSPCoopStateException;

    protected void addHeadersPeer(PdDContext pddContext, TransportResponseContext transportResponseContext, List<Proprieta> props) {
        HeaderMap extraHeaders = Objects.requireNonNullElse((HeaderMap)pddContext.getObject(CostantiPdD.EXTRA_HEADERS_RESPONSE), new HeaderMap());
        ArrayList<PeerHeaderDescriptor> desc = new ArrayList<PeerHeaderDescriptor>();
        try {
            if (CostantiProprieta.isPeerHeaderDefaultEnabled(props)) {
                desc.addAll(OpenSPCoop2Properties.getInstance().getHeadersPeer());
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        desc.addAll(CostantiProprieta.getPeerHeaderDescriptors(props));
        HeaderMap headerPeers = HeaderMap.computeFromHeaders(desc, transportResponseContext.getHeaders());
        extraHeaders.putAll(headerPeers);
        pddContext.addObject(CostantiPdD.EXTRA_HEADERS_RESPONSE, extraHeaders);
    }
}

