/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import java.util.Date;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.EJBUtils;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.ImbustamentoMessage;
import org.openspcoop2.pdd.mdb.InoltroBusteMessage;
import org.openspcoop2.pdd.services.error.RicezioneContenutiApplicativiInternalErrorGenerator;
import org.openspcoop2.protocol.engine.driver.ConsegnaInOrdine;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.driver.Riscontri;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Servizio;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.constants.InitialIdConversationType;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.slf4j.Logger;

public class Imbustamento
extends GenericLib {
    public static final String ID_MODULO = "Imbustamento";

    public Imbustamento(Logger log) throws GenericLibException {
        super(ID_MODULO, log);
        this.inizializza();
    }

    @Override
    protected synchronized void inizializza() throws GenericLibException {
        super.inizializza();
    }

    @Override
    public EsitoLib _onMessage(IOpenSPCoopState openspcoopstate, RegistroServiziManager registroServiziManager, ConfigurazionePdDManager configurazionePdDManager, MsgDiagnostico msgDiag) throws OpenSPCoopStateException {
        EsitoLib esito = new EsitoLib();
        ImbustamentoMessage imbustamentoMsg = (ImbustamentoMessage)openspcoopstate.getMessageLib();
        PdDContext pddContext = imbustamentoMsg.getPddContext();
        String idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, pddContext);
        RequestInfo requestInfo = (RequestInfo)pddContext.getObject(Costanti.REQUEST_INFO);
        IProtocolFactory protocolFactory = null;
        IProtocolVersionManager protocolManager = null;
        ITraduttore traduttore = null;
        try {
            protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME));
            protocolManager = protocolFactory.createProtocolVersionManager(imbustamentoMsg.getRichiestaDelegata().getProfiloGestione());
            traduttore = protocolFactory.createTraduttore();
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        msgDiag.setPddContext(pddContext, protocolFactory);
        String idMessageRequest = openspcoopstate.getIDMessaggioSessione();
        String implementazionePdDDestinatario = imbustamentoMsg.getImplementazionePdDSoggettoDestinatario();
        RichiestaDelegata richiestaDelegata = imbustamentoMsg.getRichiestaDelegata();
        if (richiestaDelegata == null) {
            msgDiag.logErroreGenerico("RichiestaDelegata is null", "RichiestaDelegata.checkNull");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            return esito;
        }
        IDSoggetto identitaPdD = imbustamentoMsg.getRichiestaDelegata().getDominio();
        TipoPdD tipoPdD = TipoPdD.DELEGATA;
        msgDiag.setDominio(identitaPdD);
        msgDiag.setPrefixMsgPersonalizzati("imbustamentoBusta.");
        msgDiag.setIdMessaggioRichiesta(idMessageRequest);
        msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idMessageRequest);
        if (msgDiag.getPorta() == null && richiestaDelegata != null && richiestaDelegata.getIdPortaDelegata() != null) {
            msgDiag.updatePorta(tipoPdD, richiestaDelegata.getIdPortaDelegata().getNome(), requestInfo);
        }
        msgDiag.setFruitore(richiestaDelegata.getIdSoggettoFruitore());
        msgDiag.addKeywords(richiestaDelegata.getIdSoggettoFruitore());
        msgDiag.setServizio(richiestaDelegata.getIdServizio());
        msgDiag.addKeywords(richiestaDelegata.getIdServizio());
        msgDiag.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", richiestaDelegata.getServizioApplicativo());
        if (richiestaDelegata.getProfiloCollaborazione() != null) {
            msgDiag.addKeyword("@PROFILO_COLLABORAZIONE@", traduttore.toString(richiestaDelegata.getProfiloCollaborazione()));
        }
        msgDiag.setIdCorrelazioneApplicativa(richiestaDelegata.getIdCorrelazioneApplicativa());
        msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", richiestaDelegata.getIdCorrelazioneApplicativa());
        msgDiag.addKeyword("@FUNZIONALITA_COLLABORAZIONE@", "" + imbustamentoMsg.getInfoServizio().getCollaborazione());
        msgDiag.addKeyword("@FUNZIONALITA_CONFERMA_RICEZIONE@", "" + imbustamentoMsg.getInfoServizio().getConfermaRicezione());
        msgDiag.addKeyword("@FUNZIONALITA_FILTRO_DUPLICATI@", "" + Inoltro.SENZA_DUPLICATI.equals((Object)imbustamentoMsg.getInfoServizio().getInoltro()));
        ProprietaErroreApplicativo proprietaErroreAppl = richiestaDelegata.getFault();
        proprietaErroreAppl.setIdModulo(ID_MODULO);
        RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore = null;
        try {
            generatoreErrore = new RicezioneContenutiApplicativiInternalErrorGenerator(this.log, this.idModulo, requestInfo);
            generatoreErrore.updateInformazioniCooperazione(richiestaDelegata.getIdSoggettoFruitore(), richiestaDelegata.getIdServizio());
            generatoreErrore.updateInformazioniCooperazione(richiestaDelegata.getServizioApplicativo());
            generatoreErrore.updateProprietaErroreApplicativo(proprietaErroreAppl);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "RicezioneContenutiApplicativiGeneratoreErrore.instanziazione");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        msgDiag.mediumDebug("Inizializzo stato per la gestione della richiesta...");
        openspcoopstate.initResource(identitaPdD, ID_MODULO, idTransazione);
        registroServiziManager = registroServiziManager.refreshState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
        configurazionePdDManager = configurazionePdDManager.refreshState(registroServiziManager);
        msgDiag.updateState(configurazionePdDManager);
        msgDiag.mediumDebug("Inizializzo contesto per la gestione...");
        EJBUtils ejbUtils = null;
        try {
            ejbUtils = new EJBUtils(identitaPdD, tipoPdD, ID_MODULO, idMessageRequest, idMessageRequest, "OUTBOX", openspcoopstate, msgDiag, false, imbustamentoMsg.getImplementazionePdDSoggettoMittente(), imbustamentoMsg.getImplementazionePdDSoggettoDestinatario(), imbustamentoMsg.getRichiestaDelegata().getProfiloGestione(), pddContext);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "EJBUtils.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        boolean oneWayVersione11 = imbustamentoMsg.isOneWayVersione11();
        ejbUtils.setOneWayVersione11(oneWayVersione11);
        RepositoryBuste repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRichiesta(), true, protocolFactory);
        Riscontri gestoreRiscontri = new Riscontri(openspcoopstate.getStatoRichiesta());
        org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta(), protocolFactory);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ProfiloDiCollaborazione.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        ConsegnaInOrdine ordineConsegna = new ConsegnaInOrdine(openspcoopstate.getStatoRichiesta(), protocolFactory);
        GestoreMessaggi msgRequest = null;
        GestoreMessaggi msgOK = null;
        Servizio infoServizio = imbustamentoMsg.getInfoServizio();
        String riferimentoServizioCorrelato = imbustamentoMsg.getRiferimentoServizioCorrelato();
        boolean isServizioCorrelato = infoServizio.isCorrelato();
        IDServizio idServizio = richiestaDelegata.getIdServizio();
        IDSoggetto soggettoFruitore = richiestaDelegata.getIdSoggettoFruitore();
        PortaDelegata pd = null;
        ServizioApplicativo sa = null;
        try {
            boolean gestioneConsegnaInOrdineAbilitata;
            boolean consegnaInOrdine;
            boolean idRiferimentoMessaggioRichiesta;
            String idCollaborazioneCapostipite;
            boolean idCollaborazione;
            boolean consegnaAffidabile;
            long scadenzaBusta;
            Busta busta;
            block157: {
                msgDiag.mediumDebug("Check utilizzo consegna risposta asincrona...");
                if (!infoServizio.getProfiloDiCollaborazione().equals((Object)ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO) || riferimentoServizioCorrelato != null || isServizioCorrelato) {
                    richiestaDelegata.setUtilizzoConsegnaAsincrona(true);
                }
                Utilities.printFreeMemory((String)"Imbustamento - Costruzione busta ...");
                msgDiag.mediumDebug("Costruzione busta ...");
                busta = new Busta(protocolFactory.getProtocol());
                busta.setTipoDestinatario(idServizio.getSoggettoErogatore().getTipo());
                busta.setDestinatario(idServizio.getSoggettoErogatore().getNome());
                busta.setIdentificativoPortaDestinatario(idServizio.getSoggettoErogatore().getCodicePorta());
                busta.setIndirizzoDestinatario(imbustamentoMsg.getIndirizzoSoggettoDestinatario());
                busta.setVersioneServizio(idServizio.getVersione());
                busta.setServizio(idServizio.getNome());
                busta.setTipoServizio(idServizio.getTipo());
                busta.setAzione(idServizio.getAzione());
                busta.setTipoMittente(soggettoFruitore.getTipo());
                busta.setMittente(soggettoFruitore.getNome());
                busta.setIdentificativoPortaMittente(soggettoFruitore.getCodicePorta());
                busta.setIndirizzoMittente(imbustamentoMsg.getIndirizzoSoggettoMittente());
                busta.setServizioApplicativoFruitore(richiestaDelegata.getServizioApplicativo());
                msgDiag.highDebug("Costruzione Busta con ID = " + idMessageRequest);
                busta.setID(idMessageRequest);
                Date oraRegistrazione = DateManager.getDate();
                msgDiag.highDebug("Costruzione Busta in data : [" + oraRegistrazione + "]");
                busta.setOraRegistrazione(oraRegistrazione);
                TipoOraRegistrazione tipoOraRegistrazione = this.propertiesReader.getTipoTempoBusta(implementazionePdDDestinatario);
                busta.setTipoOraRegistrazione(tipoOraRegistrazione, protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                busta.setScadenza(infoServizio.getScadenza());
                scadenzaBusta = infoServizio.getScadenzaMinuti();
                if (scadenzaBusta <= 0L) {
                    scadenzaBusta = this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi();
                }
                switch (protocolManager.getFiltroDuplicati(infoServizio)) {
                    case ABILITATA: {
                        busta.setInoltro(Inoltro.SENZA_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                        break;
                    }
                    case DISABILITATA: {
                        busta.setInoltro(Inoltro.CON_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.CON_DUPLICATI));
                        break;
                    }
                    default: {
                        busta.setInoltro(infoServizio.getInoltro(), protocolFactory.createTraduttore().toString(infoServizio.getInoltro()));
                    }
                }
                consegnaAffidabile = false;
                switch (protocolManager.getConsegnaAffidabile(infoServizio)) {
                    case ABILITATA: {
                        consegnaAffidabile = true;
                        break;
                    }
                    case DISABILITATA: {
                        consegnaAffidabile = false;
                        break;
                    }
                    default: {
                        consegnaAffidabile = this.propertiesReader.isGestioneRiscontri(implementazionePdDDestinatario) && infoServizio.getConfermaRicezione();
                    }
                }
                idCollaborazione = false;
                switch (protocolManager.getCollaborazione(infoServizio)) {
                    case ABILITATA: {
                        idCollaborazione = true;
                        break;
                    }
                    case DISABILITATA: {
                        idCollaborazione = false;
                        break;
                    }
                    default: {
                        idCollaborazione = this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario) && infoServizio.getCollaborazione();
                    }
                }
                idCollaborazioneCapostipite = null;
                if (idCollaborazione) {
                    InitialIdConversationType initial = protocolFactory.createProtocolConfiguration().isGenerateInitialIdConversation(TipoPdD.DELEGATA, FunzionalitaProtocollo.COLLABORAZIONE);
                    if (InitialIdConversationType.ID_TRANSAZIONE.equals((Object)initial)) {
                        idCollaborazioneCapostipite = idTransazione;
                    } else if (InitialIdConversationType.ID_MESSAGGIO.equals((Object)initial)) {
                        idCollaborazioneCapostipite = idMessageRequest;
                    }
                }
                idRiferimentoMessaggioRichiesta = false;
                switch (protocolManager.getIdRiferimentoRichiesta(infoServizio)) {
                    case ABILITATA: {
                        idRiferimentoMessaggioRichiesta = true;
                        break;
                    }
                    case DISABILITATA: {
                        idRiferimentoMessaggioRichiesta = false;
                        break;
                    }
                    default: {
                        idRiferimentoMessaggioRichiesta = this.propertiesReader.isGestioneElementoIdRiferimentoRichiesta(implementazionePdDDestinatario) && infoServizio.getIdRiferimentoRichiesta();
                    }
                }
                consegnaInOrdine = false;
                switch (protocolManager.getConsegnaInOrdine(infoServizio)) {
                    case ABILITATA: {
                        consegnaInOrdine = true;
                        break;
                    }
                    case DISABILITATA: {
                        consegnaInOrdine = false;
                        break;
                    }
                    default: {
                        boolean bl = consegnaInOrdine = this.propertiesReader.isGestioneConsegnaInOrdine(implementazionePdDDestinatario) && infoServizio.getOrdineConsegna();
                    }
                }
                if (consegnaAffidabile) {
                    busta.setConfermaRicezione(true);
                } else {
                    busta.setConfermaRicezione(false);
                }
                pd = configurazionePdDManager.getPortaDelegata(richiestaDelegata.getIdPortaDelegata(), requestInfo);
                try {
                    IDServizioApplicativo idSA = new IDServizioApplicativo();
                    idSA.setNome(richiestaDelegata.getServizioApplicativo());
                    idSA.setIdSoggettoProprietario(richiestaDelegata.getIdSoggettoFruitore());
                    sa = configurazionePdDManager.getServizioApplicativo(idSA, requestInfo);
                }
                catch (DriverConfigurazioneNotFound e) {
                    if ("Anonimo".equals(richiestaDelegata.getServizioApplicativo())) break block157;
                    throw e;
                }
            }
            try {
                IProtocolConfiguration protocolConfiguration = protocolFactory.createProtocolConfiguration();
                if (!protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), infoServizio.getProfiloDiCollaborazione())) {
                    throw new Exception("Profilo di Collaborazione [" + infoServizio.getProfiloDiCollaborazione().getEngineValue() + "]");
                }
                if (busta.getInoltro() != null && Inoltro.SENZA_DUPLICATI.equals((Object)busta.getInoltro()) && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.FILTRO_DUPLICATI)) {
                    throw new Exception(FunzionalitaProtocollo.FILTRO_DUPLICATI.getEngineValue());
                }
                if (consegnaAffidabile && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.CONFERMA_RICEZIONE)) {
                    throw new Exception(FunzionalitaProtocollo.CONFERMA_RICEZIONE.getEngineValue());
                }
                if (idCollaborazione && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.COLLABORAZIONE)) {
                    throw new Exception(FunzionalitaProtocollo.COLLABORAZIONE.getEngineValue());
                }
                if (idRiferimentoMessaggioRichiesta && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.RIFERIMENTO_ID_RICHIESTA)) {
                    throw new Exception(FunzionalitaProtocollo.RIFERIMENTO_ID_RICHIESTA.getEngineValue());
                }
                if (consegnaInOrdine && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.CONSEGNA_IN_ORDINE)) {
                    throw new Exception(FunzionalitaProtocollo.CONSEGNA_IN_ORDINE.getEngineValue());
                }
                if (infoServizio.getScadenza() != null && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.SCADENZA)) {
                    throw new Exception(FunzionalitaProtocollo.SCADENZA.getEngineValue());
                }
                if (configurazionePdDManager.isGestioneManifestAttachments(pd, protocolFactory) && !protocolConfiguration.isSupportato(requestInfo.getIntegrationServiceBinding(), FunzionalitaProtocollo.MANIFEST_ATTACHMENTS)) {
                    throw new Exception(FunzionalitaProtocollo.MANIFEST_ATTACHMENTS.getEngineValue());
                }
            }
            catch (Exception e) {
                msgDiag.addKeywordErroreProcessamento(e);
                msgDiag.logPersonalizzato("protocolli.funzionalita.unsupported");
                OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL, ErroriIntegrazione.ERRORE_439_FUNZIONALITA_NOT_SUPPORTED_BY_PROTOCOL.getErrore439_FunzionalitaNotSupportedByProtocol(e.getMessage(), protocolFactory), e, null);
                ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("protocolli.funzionalita.unsupported"));
                return esito;
            }
            if (consegnaInOrdine) {
                OpenSPCoop2Message responseMessageError;
                msgDiag.mediumDebug("Check vincoli consegna in ordine...");
                if (!infoServizio.getProfiloDiCollaborazione().equals((Object)ProfiloDiCollaborazione.ONEWAY)) {
                    msgDiag.addKeyword("@PROFILO_COLLABORAZIONE@", traduttore.toString(infoServizio.getProfiloDiCollaborazione()));
                    msgDiag.logPersonalizzato("consegnaInOrdine.profiloNonOneway");
                    responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL, ErroriIntegrazione.ERRORE_414_CONSEGNA_IN_ORDINE_CON_PROFILO_NO_ONEWAY.getErroreIntegrazione(), null, null);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("consegnaInOrdine.profiloNonOneway"));
                    return esito;
                }
                if (!this.propertiesReader.isGestioneRiscontri(implementazionePdDDestinatario)) {
                    msgDiag.logPersonalizzato("consegnaInOrdine.confermaRicezioneNonRichiesta");
                    responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL, ErroriIntegrazione.ERRORE_415_CONSEGNA_IN_ORDINE_SENZA_VINCOLI_RICHIESTI.getErroreIntegrazione(), null, null);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("consegnaInOrdine.confermaRicezioneNonRichiesta"));
                    return esito;
                }
                if (!this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario)) {
                    msgDiag.logPersonalizzato("consegnaInOrdine.idCollaborazioneNonRichiesto");
                    responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL, ErroriIntegrazione.ERRORE_415_CONSEGNA_IN_ORDINE_SENZA_VINCOLI_RICHIESTI.getErroreIntegrazione(), null, null);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("consegnaInOrdine.idCollaborazioneNonRichiesto"));
                    return esito;
                }
                if (!(infoServizio.getCollaborazione() && infoServizio.getConfermaRicezione() && Inoltro.SENZA_DUPLICATI.equals((Object)infoServizio.getInoltro()))) {
                    msgDiag.logPersonalizzato("consegnaInOrdine.funzionalitaMancanti");
                    responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL, ErroriIntegrazione.ERRORE_415_CONSEGNA_IN_ORDINE_SENZA_VINCOLI_RICHIESTI.getErroreIntegrazione(), null, null);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("consegnaInOrdine.funzionalitaMancanti"));
                    return esito;
                }
            }
            boolean bl = gestioneConsegnaInOrdineAbilitata = consegnaInOrdine && this.propertiesReader.isGestioneRiscontri(implementazionePdDDestinatario) && this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario) && this.propertiesReader.isGestioneConsegnaInOrdine(implementazionePdDDestinatario);
            if ((consegnaAffidabile || gestioneConsegnaInOrdineAbilitata || ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)infoServizio.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)infoServizio.getProfiloDiCollaborazione())) && openspcoopstate.resourceReleased()) {
                ((OpenSPCoopState)openspcoopstate).setUseConnection(true);
                openspcoopstate.initResource(identitaPdD, this.idModulo, idTransazione);
                gestoreRiscontri.updateState(openspcoopstate.getStatoRichiesta());
                ordineConsegna.updateState(openspcoopstate.getStatoRichiesta());
                profiloCollaborazione.updateState(openspcoopstate.getStatoRichiesta());
                repositoryBuste.updateState(openspcoopstate.getStatoRichiesta());
            }
            Utilities.printFreeMemory((String)"Imbustamento - Gestione profilo di Collaborazione...");
            boolean generazioneMsgOK = false;
            String scenarioCooperazione = null;
            if (infoServizio.getProfiloDiCollaborazione().equals((Object)ProfiloDiCollaborazione.ONEWAY)) {
                msgDiag.mediumDebug("Gestione profilo di Collaborazione OneWay ...");
                busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY);
                scenarioCooperazione = "OneWay_InvocazioneServizio";
                if (idCollaborazione) {
                    if (imbustamentoMsg.getIdCollaborazione() != null) {
                        busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                    } else {
                        busta.setCollaborazione(idCollaborazioneCapostipite);
                    }
                }
                if (idRiferimentoMessaggioRichiesta && imbustamentoMsg.getIdRiferimentoMessaggio() != null) {
                    busta.setRiferimentoMessaggio(imbustamentoMsg.getIdRiferimentoMessaggio());
                }
                if (gestioneConsegnaInOrdineAbilitata && infoServizio.getOrdineConsegna() && (oneWayVersione11 || openspcoopstate instanceof OpenSPCoopStateful)) {
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione OneWay (consegna in ordine)...");
                    try {
                        ordineConsegna.setNextSequenza_daInviare(busta);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "ordineConsegna.setNextSequenza_daInviare");
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "ordineConsegna.setNextSequenza_daInviare");
                        return esito;
                    }
                }
                generazioneMsgOK = !configurazionePdDManager.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione());
            } else if (infoServizio.getProfiloDiCollaborazione().equals((Object)ProfiloDiCollaborazione.SINCRONO)) {
                msgDiag.mediumDebug("Gestione profilo di Collaborazione Sincrono ...");
                busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO);
                scenarioCooperazione = "Sincrono_InvocazioneServizio";
                try {
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione Sincrono (Registrazione Busta da inviare)...");
                    profiloCollaborazione.registraBustaInviata(idMessageRequest);
                }
                catch (ProtocolException e) {
                    msgDiag.logErroreGenerico(e, "profiloDiCollaborazione.registraBustaInviata");
                    OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e, null);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "profiloDiCollaborazione.registraBustaInviata");
                    return esito;
                }
                if (idCollaborazione) {
                    if (imbustamentoMsg.getIdCollaborazione() != null) {
                        busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                    } else {
                        busta.setCollaborazione(idCollaborazioneCapostipite);
                    }
                }
                if (idRiferimentoMessaggioRichiesta && imbustamentoMsg.getIdRiferimentoMessaggio() != null) {
                    busta.setRiferimentoMessaggio(imbustamentoMsg.getIdRiferimentoMessaggio());
                }
            } else if (infoServizio.getProfiloDiCollaborazione().equals((Object)ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO)) {
                msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico ...");
                busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico (check ricevuta abilitata)...");
                richiestaDelegata.setRicevutaAsincrona(configurazionePdDManager.ricevutaAsincronaSimmetricaAbilitata(pd));
                generazioneMsgOK = !configurazionePdDManager.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione()) ? !richiestaDelegata.isRicevutaAsincrona() : false;
                if (riferimentoServizioCorrelato == null && !isServizioCorrelato) {
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico richiesta...");
                    if ("Anonimo".equals(richiestaDelegata.getServizioApplicativo())) {
                        msgDiag.logPersonalizzato("profiloAsincronoSimmetrico.saAnonimo");
                        OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.AUTHENTICATION, ErroriIntegrazione.ERRORE_410_AUTENTICAZIONE_RICHIESTA.getErroreIntegrazione(), null, null);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincronoSimmetrico.saAnonimo"));
                        return esito;
                    }
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico richiesta (consegna asincrona)...");
                    boolean existsConsegnaRispostaAsincrona = false;
                    try {
                        existsConsegnaRispostaAsincrona = configurazionePdDManager.existsConsegnaRispostaAsincrona(sa);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "existsConsegnaRispostaAsincrona(" + sa + ")");
                        OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e, null);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "existsConsegnaRispostaAsincrona(" + sa + ")");
                        return esito;
                    }
                    if (!existsConsegnaRispostaAsincrona) {
                        msgDiag.logPersonalizzato("profiloAsincronoSimmetrico.saSenzaRispostaAsincrona");
                        OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_411_RICEZIONE_CONTENUTI_ASINCRONA_RICHIESTA.getErroreIntegrazione(), null, null);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincronoSimmetrico.saSenzaRispostaAsincrona"));
                        return esito;
                    }
                    scenarioCooperazione = "AsincronoSimmetrico_InvocazioneServizio";
                    if (infoServizio.getServizioCorrelato() == null || infoServizio.getTipoServizioCorrelato() == null) {
                        msgDiag.logPersonalizzato("profiloAsincronoSimmetrico.servizioCorrelatoNonEsistente");
                        OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_408_SERVIZIO_CORRELATO_NON_TROVATO.getErroreIntegrazione(), null, null);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincronoSimmetrico.servizioCorrelatoNonEsistente"));
                        return esito;
                    }
                    if (protocolManager.isGenerazioneInformazioniServizioCorrelatoAsincronoSimmetrico() && this.propertiesReader.isGenerazioneAttributiAsincroni(implementazionePdDDestinatario)) {
                        busta.setServizioCorrelato(infoServizio.getServizioCorrelato());
                        busta.setTipoServizioCorrelato(infoServizio.getTipoServizioCorrelato());
                    }
                    if (idCollaborazione) {
                        if (imbustamentoMsg.getIdCollaborazione() != null) {
                            busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                        } else {
                            busta.setCollaborazione(idCollaborazioneCapostipite);
                        }
                    }
                    try {
                        msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico richiesta (registrazione busta da inviare)...");
                        Integrazione infoIntegrazione = null;
                        if (configurazionePdDManager.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione())) {
                            infoIntegrazione = new Integrazione();
                            infoIntegrazione.setIdModuloInAttesa(this.idModulo);
                            infoIntegrazione.setNomePorta(richiestaDelegata.getIdPortaDelegata().getNome());
                            infoIntegrazione.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
                            if (busta.getScadenza() == null) {
                                busta.setScadenza(new Date(DateManager.getTimeMillis() + scadenzaBusta * 60L * 1000L));
                            }
                            if (openspcoopstate instanceof OpenSPCoopStateless) {
                                ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(busta);
                            }
                        }
                        profiloCollaborazione.asincronoSimmetrico_registraRichiestaInviata(idMessageRequest, busta.getCollaborazione(), infoServizio.getTipoServizioCorrelato(), infoServizio.getServizioCorrelato(), infoServizio.getVersioneServizioCorrelato(), richiestaDelegata.isRicevutaAsincrona(), infoIntegrazione, scadenzaBusta);
                    }
                    catch (ProtocolException e) {
                        msgDiag.logErroreGenerico(e, "profiloDiCollaborazione.asincronoSimmetrico_registraRichiestaInviata");
                        openspcoopstate.releaseResource();
                        OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e, null);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "profiloDiCollaborazione.asincronoSimmetrico_registraRichiestaInviata");
                        return esito;
                    }
                    richiestaDelegata.setUtilizzoConsegnaAsincrona(false);
                } else {
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico risposta...");
                    scenarioCooperazione = "AsincronoSimmetrico_ConsegnaRisposta";
                    msgDiag.addKeyword("@ID_CORRELAZIONE_ASINCRONA@", riferimentoServizioCorrelato);
                    msgDiag.logPersonalizzato("profiloAsincronoSimmetrico.risposta.correlazioneRichiesta");
                    if (openspcoopstate instanceof OpenSPCoopStateless) {
                        if (busta.getScadenza() == null) {
                            busta.setScadenza(new Date(DateManager.getTimeMillis() + scadenzaBusta * 60L * 1000L));
                        }
                        ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(busta);
                    }
                    try {
                        msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico risposta (lettura busta risposta)...");
                        Busta rispostaAsincrona = profiloCollaborazione.asincronoSimmetrico_getBustaRisposta(riferimentoServizioCorrelato, idMessageRequest, scadenzaBusta);
                        msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico risposta (check coerenza)...");
                        if (!busta.getTipoMittente().equals(rispostaAsincrona.getTipoDestinatario())) {
                            throw new ProtocolException("Il tipo di mittente della risposta non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getMittente().equals(rispostaAsincrona.getDestinatario())) {
                            throw new ProtocolException("Il mittente della risposta non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getTipoDestinatario().equals(rispostaAsincrona.getTipoMittente())) {
                            throw new ProtocolException("Il tipo di destinatario della risposta non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getDestinatario().equals(rispostaAsincrona.getMittente())) {
                            throw new ProtocolException("Il destinatario della risposta non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getTipoServizio().equals(rispostaAsincrona.getTipoServizioCorrelato())) {
                            throw new ProtocolException("Il tipo del servizio correlato invocato non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getServizio().equals(rispostaAsincrona.getServizioCorrelato())) {
                            throw new ProtocolException("Il servizio correlato invocato non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (protocolManager.isCorrelazioneRichiestaPresenteRispostaAsincronaSimmetrica()) {
                            busta.setRiferimentoMessaggio(riferimentoServizioCorrelato);
                        }
                    }
                    catch (ProtocolException e) {
                        ErroreIntegrazione erroreIntegrazione = null;
                        IntegrationFunctionError integrationFunctionError = null;
                        this.log.error("Busta per correlazione asincrona simmetrica (" + riferimentoServizioCorrelato + ") non trovata", (Throwable)e);
                        if (e.getMessage() != null && e.getMessage().indexOf("Busta non trovata") != -1 || e.getMessage().indexOf("Tipo/Nome servizio correlato non trovato") != -1) {
                            msgDiag.logPersonalizzato("profiloAsincronoSimmetrico.rispostaNonCorrelataRichiesta");
                            erroreIntegrazione = ErroriIntegrazione.ERRORE_409_RISPOSTA_ASINCRONA_NON_CORRELATA_ALLA_RICHIESTA.getErroreIntegrazione();
                            integrationFunctionError = IntegrationFunctionError.CORRELATION_INFORMATION_NOT_FOUND;
                        } else {
                            msgDiag.logErroreGenerico(e, "profiloDiCollaborazione.asincronoSimmetrico_getBustaRisposta");
                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO);
                            integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                        }
                        OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, integrationFunctionError, erroreIntegrazione, e, null);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "Busta per correlazione asincrona simmetrica (" + riferimentoServizioCorrelato + ") non trovata");
                        return esito;
                    }
                    if (idCollaborazione) {
                        if (imbustamentoMsg.getIdCollaborazione() != null) {
                            busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                        } else {
                            busta.setCollaborazione(riferimentoServizioCorrelato);
                        }
                    }
                }
            } else if (infoServizio.getProfiloDiCollaborazione().equals((Object)ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO)) {
                msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico ...");
                busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
                if (riferimentoServizioCorrelato == null && !isServizioCorrelato) {
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiesta...");
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiesta (ricevuta abilitata)...");
                    richiestaDelegata.setRicevutaAsincrona(configurazionePdDManager.ricevutaAsincronaAsimmetricaAbilitata(pd));
                    generazioneMsgOK = !configurazionePdDManager.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione()) ? !richiestaDelegata.isRicevutaAsincrona() : false;
                    scenarioCooperazione = "AsincronoAsimmetrico_InvocazioneServizio";
                    if (idCollaborazione) {
                        if (imbustamentoMsg.getIdCollaborazione() != null) {
                            busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                        } else {
                            busta.setCollaborazione(idCollaborazioneCapostipite);
                        }
                    }
                    try {
                        msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiesta (registrazione busta da inviare)...");
                        if (configurazionePdDManager.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione())) {
                            if (busta.getScadenza() == null) {
                                busta.setScadenza(new Date(DateManager.getTimeMillis() + scadenzaBusta * 60L * 1000L));
                            }
                            if (openspcoopstate instanceof OpenSPCoopStateless) {
                                ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(busta);
                            }
                        }
                        profiloCollaborazione.asincronoAsimmetrico_registraRichiestaInviata(idMessageRequest, busta.getCollaborazione(), richiestaDelegata.isRicevutaAsincrona(), scadenzaBusta);
                    }
                    catch (ProtocolException e) {
                        msgDiag.logErroreGenerico(e, "profiloDiCollaborazione.asincronoAsimmetrico_registraRichiestaInviata");
                        OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e, null);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "profiloDiCollaborazione.asincronoAsimmetrico_registraRichiestaInviata");
                        return esito;
                    }
                }
                msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiestaStato...");
                scenarioCooperazione = "AsincronoAsimmetrico_Polling";
                msgDiag.addKeyword("@ID_CORRELAZIONE_ASINCRONA@", riferimentoServizioCorrelato);
                msgDiag.logPersonalizzato("profiloAsincronoAsimmetrico.richiestaStato.correlazioneRichiesta");
                richiestaDelegata.setRicevutaAsincrona(true);
                if (openspcoopstate instanceof OpenSPCoopStateless) {
                    if (busta.getScadenza() == null) {
                        busta.setScadenza(new Date(DateManager.getTimeMillis() + scadenzaBusta * 60L * 1000L));
                    }
                    ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(busta);
                }
                try {
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiestaStato (lettura busta)...");
                    Busta richiestaStatoAsincrona = profiloCollaborazione.asincronoAsimmetrico_getBustaRisposta(riferimentoServizioCorrelato, idMessageRequest, scadenzaBusta);
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiestaStato (check coerenza)...");
                    if (!busta.getTipoMittente().equals(richiestaStatoAsincrona.getTipoMittente())) {
                        throw new ProtocolException("Il tipo di mittente della risposta non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getMittente().equals(richiestaStatoAsincrona.getMittente())) {
                        throw new ProtocolException("Il mittente della risposta non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getTipoDestinatario().equals(richiestaStatoAsincrona.getTipoDestinatario())) {
                        throw new ProtocolException("Il tipo di destinatario della risposta non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getDestinatario().equals(richiestaStatoAsincrona.getDestinatario())) {
                        throw new ProtocolException("Il destinatario della risposta non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getTipoServizio().equals(richiestaStatoAsincrona.getTipoServizioCorrelato())) {
                        throw new ProtocolException("Il tipo del servizio correlato invocato non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getServizio().equals(richiestaStatoAsincrona.getServizioCorrelato())) {
                        throw new ProtocolException("Il servizio correlato invocato non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (protocolManager.isCorrelazioneRichiestaPresenteRichiestaStatoAsincronaAsimmetrica()) {
                        busta.setRiferimentoMessaggio(riferimentoServizioCorrelato);
                    }
                }
                catch (ProtocolException e) {
                    ErroreIntegrazione erroreIntegrazione = null;
                    IntegrationFunctionError integrationFunctionError = null;
                    this.log.error("Busta per correlazione asincrona asimmetrica (" + riferimentoServizioCorrelato + ") non trovata", (Throwable)e);
                    if (e.getMessage() != null && e.getMessage().indexOf("Busta non trovata") != -1) {
                        msgDiag.logPersonalizzato("profiloAsincronoAsimmetrico.richiestaStatoNonCorrelataRichiesta");
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_409_RISPOSTA_ASINCRONA_NON_CORRELATA_ALLA_RICHIESTA.getErroreIntegrazione();
                        integrationFunctionError = IntegrationFunctionError.CORRELATION_INFORMATION_NOT_FOUND;
                    } else {
                        msgDiag.logErroreGenerico(e, "profiloDiCollaborazione.asincronoAsimmetrico_getBustaRisposta");
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO);
                        integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                    }
                    OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, integrationFunctionError, erroreIntegrazione, e, null);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "Busta per correlazione asincrona asimmetrica (" + riferimentoServizioCorrelato + ") non trovata");
                    return esito;
                }
                if (idCollaborazione) {
                    if (imbustamentoMsg.getIdCollaborazione() != null) {
                        busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                    } else {
                        busta.setCollaborazione(riferimentoServizioCorrelato);
                    }
                }
            } else {
                msgDiag.logErroreGenerico("Profilo di Collaborazione [" + infoServizio.getProfiloDiCollaborazione() + "] non gestito", "gestioneProfiloCollaborazione");
                OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), null, null);
                ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2, "Profilo di Collaborazione [" + infoServizio.getProfiloDiCollaborazione() + "] non gestito");
                return esito;
            }
            richiestaDelegata.setScenario(scenarioCooperazione);
            ejbUtils.setScenarioCooperazione(scenarioCooperazione);
            richiestaDelegata.setIdCollaborazione(busta.getCollaborazione());
            richiestaDelegata.setProfiloCollaborazione(busta.getProfiloDiCollaborazione(), busta.getProfiloDiCollaborazioneValue());
            boolean stateless = configurazionePdDManager.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione());
            if (!oneWayVersione11 && !stateless) {
                msgDiag.mediumDebug("Aggiornamento busta nel RepositoryBuste...");
                try {
                    repositoryBuste.aggiornaBustaIntoOutBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                    repositoryBuste.aggiornaInfoIntegrazioneIntoOutBox_Scenario(busta.getID(), scenarioCooperazione);
                }
                catch (ProtocolException e) {
                    msgDiag.logErroreGenerico(e, "repositoryBuste.aggiornaBusta/InfoIntegrazione_IntoOutBox");
                    OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e, null);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "repositoryBuste.aggiornaBusta/InfoIntegrazione_IntoOutBox");
                    return esito;
                }
            }
            if (consegnaAffidabile) {
                if (ProfiloDiCollaborazione.ONEWAY.equals((Object)infoServizio.getProfiloDiCollaborazione())) {
                    msgDiag.logPersonalizzato("consegnaAffidabile.salvataggioInformazioni");
                    try {
                        gestoreRiscontri.registraRiscontroDaRicevere(busta.getID(), DateManager.getDate());
                    }
                    catch (ProtocolException e) {
                        msgDiag.logErroreGenerico(e, "gestoreRiscontri.registraRiscontroDaRicevere");
                        OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e, null);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "gestoreRiscontri.registraRiscontroDaRicevere");
                        return esito;
                    }
                } else {
                    msgDiag.logPersonalizzato("consegnaAffidabile.profiloNonOneway");
                }
            }
            Utilities.printFreeMemory((String)"Imbustamento - Invio messaggio al modulo di InoltroBuste...");
            msgDiag.mediumDebug("Invio messaggio al modulo di InoltroBuste...");
            InoltroBusteMessage inoltroMSG = new InoltroBusteMessage();
            inoltroMSG.setRichiestaDelegata(richiestaDelegata);
            inoltroMSG.setBusta(busta);
            inoltroMSG.setOneWayVersione11(oneWayVersione11);
            inoltroMSG.setImplementazionePdDSoggettoMittente(imbustamentoMsg.getImplementazionePdDSoggettoMittente());
            inoltroMSG.setImplementazionePdDSoggettoDestinatario(imbustamentoMsg.getImplementazionePdDSoggettoDestinatario());
            inoltroMSG.setPddContext(pddContext);
            msgRequest = new GestoreMessaggi(openspcoopstate, true, idMessageRequest, "OUTBOX", msgDiag, pddContext);
            if (!stateless) {
                if (oneWayVersione11) {
                    OpenSPCoopStateless statelessSerializzabile = ((OpenSPCoopStateless)openspcoopstate).rendiSerializzabile();
                    inoltroMSG.setOpenspcoopstate(statelessSerializzabile);
                    msgRequest.setOneWayVersione11(true);
                }
                try {
                    ejbUtils.getNodeSender(this.propertiesReader, this.log).send(inoltroMSG, "InoltroBuste", msgDiag, identitaPdD, ID_MODULO, idMessageRequest, msgRequest);
                }
                catch (Exception e) {
                    this.log.error("Spedizione->InoltroBuste non riuscita", (Throwable)e);
                    msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(InoltroBuste)");
                    OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND), e, null);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(2, "Spedizione->InoltroBuste non riuscita");
                    esito.setEsitoInvocazione(true);
                    return esito;
                }
            }
            Utilities.printFreeMemory((String)"Imbustamento - Gestione Risposta");
            if (generazioneMsgOK) {
                pddContext.addObject(Costanti.DATA_PRESA_IN_CARICO, DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()));
                msgDiag.mediumDebug("Invio messaggio 'OK' al modulo di RicezioneContenutiApplicativi...");
                msgOK = protocolManager.isHttpEmptyResponseOneWay() ? ejbUtils.sendRispostaApplicativaOK(MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getIntegrationRequestMessageType(), (MessageRole)MessageRole.RESPONSE), richiestaDelegata, pd, sa) : ejbUtils.sendRispostaApplicativaOK(ejbUtils.buildOpenSPCoopOK(requestInfo.getIntegrationRequestMessageType(), idMessageRequest), richiestaDelegata, pd, sa);
            }
            msgDiag.mediumDebug("Aggiorno proprietario messaggio...");
            msgRequest.aggiornaProprietarioMessaggio("InoltroBuste");
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta...");
            openspcoopstate.commit();
            if (msgRequest != null) {
                msgRequest.addMessaggiIntoCache_readFromTable(ID_MODULO, "richiesta");
            }
            if (msgOK != null) {
                msgOK.addMessaggiIntoCache_readFromTable(ID_MODULO, "messaggio OK");
            }
            if (msgRequest != null) {
                msgRequest.addProprietariIntoCache_readFromTable(ID_MODULO, "richiesta", null, false);
            }
            if (msgOK != null) {
                msgOK.addProprietariIntoCache_readFromTable(ID_MODULO, "messaggio OK", idMessageRequest, false);
            }
            msgDiag.mediumDebug("Rilascio connessione al database...");
            openspcoopstate.releaseResource();
            msgDiag.mediumDebug("Lavoro Terminato.");
            esito.setEsitoInvocazione(true);
            esito.setStatoInvocazione(1, null);
            if (stateless) {
                ((OpenSPCoopState)openspcoopstate).setMessageLib(inoltroMSG);
            }
            return esito;
        }
        catch (Throwable e) {
            this.log.error("ErroreGenerale", e);
            msgDiag.logErroreGenerico(e, "Generale");
            OpenSPCoop2Message responseMessageError = generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, null);
            try {
                ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                esito.setStatoInvocazione(2, "ErroreGenerale");
                esito.setEsitoInvocazione(true);
            }
            catch (Exception er) {
                msgDiag.logErroreGenerico(er, "ejbUtils.sendErroreGenerale");
                ejbUtils.rollbackMessage("Spedizione Errore al Mittente durante una richiesta non riuscita", esito);
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
            }
            openspcoopstate.releaseResource();
            return esito;
        }
    }
}

