/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.TransactionManager;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.InoltroRisposte;
import org.openspcoop2.pdd.mdb.InoltroRisposteMessage;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class InoltroRisposteMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private transient MessageDrivenContext ctxMDB;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoop2Startup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (log == null) {
                LoggerWrapperFactory.getLogger(InoltroRisposteMDB.class).error("[InoltroRisposte] Logger nullo. MDB abortito");
                return;
            }
            if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
                log.error("[InoltroRisposte] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), (Throwable)TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Tracciamento.tracciamentoDisponibile) {
                log.error("[InoltroRisposte] Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage(), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                log.error("[InoltroRisposte] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Dump.isSistemaDumpDisponibile()) {
                log.error("[InoltroRisposte] Sistema di dump dei contenuti applicativi non disponibile: " + Dump.getMotivoMalfunzionamentoDump().getMessage(), Dump.getMotivoMalfunzionamentoDump());
                this.ctxMDB.setRollbackOnly();
                return;
            }
            InoltroRisposte lib = null;
            try {
                lib = new InoltroRisposte(log);
            }
            catch (Exception e) {
                log.error("InoltroRisposte.instanziazione: " + e.getMessage(), (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!lib.inizializzazioneUltimata) {
                log = LoggerWrapperFactory.getLogger(InoltroRisposteMDB.class);
                log.error("[InoltroRisposte] Inizializzazione MDB non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = MsgDiagnostico.newInstance(TipoPdD.APPLICATIVA, "InoltroRisposte");
            msgDiag.mediumDebug("Ricezione richiesta (InoltroRisposteMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            InoltroRisposteMessage inoltroRisposteMsg = null;
            try {
                inoltroRisposteMsg = (InoltroRisposteMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getObject(InoltroRisposteMessage)");
                return;
            }
            String idMessageRequest = null;
            try {
                idMessageRequest = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getStringProperty(ID)");
                return;
            }
            OpenSPCoopState stato = null;
            try {
                if (inoltroRisposteMsg.getOpenspcoopstate() != null) {
                    stato = inoltroRisposteMsg.getOpenspcoopstate();
                    stato.setUseConnection(true);
                    stato.setMessageLib(inoltroRisposteMsg);
                    ((OpenSPCoopStateless)stato).setIDMessaggioSessione(idMessageRequest);
                } else {
                    stato = new OpenSPCoopStateful();
                    ((OpenSPCoopStateful)stato).setIDMessaggioSessione(idMessageRequest);
                    ((OpenSPCoopStateful)stato).setMessageLib(inoltroRisposteMsg);
                }
            }
            catch (Exception e) {
                log.error("[InoltroRisposte] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            msgDiag.updateState(stato.getStatoRichiesta(), stato.getStatoRisposta());
            PdDContext pddContext = inoltroRisposteMsg.getPddContext();
            try {
                msgDiag.setPddContext(pddContext, ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME)));
            }
            catch (ProtocolException e) {
                msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            Busta busta = inoltroRisposteMsg.getBustaRisposta();
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "InoltroRisposte", busta.getID(), "OUTBOX", received.getJMSMessageID(), pddContext)) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessageRequest);
                    msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", "InoltroRisposte");
                    msgDiag.logPersonalizzato("all.", "transactionManager.validityCheckError");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            try {
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                log.error("[InoltroRisposte] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                log.info("[InoltroRisposte] Invocazione della libreria terminata con esito negativo, verr\u00e0 effettuato un rollback sulla coda JMS");
                this.ctxMDB.setRollbackOnly();
            } else {
                log.debug("[InoltroRisposte] Invocazione della libreria terminata correttamente");
            }
        }
    }
}

