/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.monitor.driver;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.openspcoop2.pdd.monitor.Busta;
import org.openspcoop2.pdd.monitor.BustaServizio;
import org.openspcoop2.pdd.monitor.BustaSoggetto;
import org.openspcoop2.pdd.monitor.Dettaglio;
import org.openspcoop2.pdd.monitor.Messaggio;
import org.openspcoop2.pdd.monitor.Proprieta;
import org.openspcoop2.pdd.monitor.ServizioApplicativoConsegna;
import org.openspcoop2.pdd.monitor.StatoPdd;
import org.openspcoop2.pdd.monitor.constants.StatoMessaggio;
import org.openspcoop2.pdd.monitor.driver.DriverMonitoraggioException;
import org.openspcoop2.pdd.monitor.driver.FilterSearch;
import org.openspcoop2.pdd.monitor.driver.FiltroStatoConsegnaAsincrona;
import org.openspcoop2.pdd.monitor.driver.IDriverMonitoraggio;
import org.openspcoop2.pdd.monitor.driver.StatoConsegnaAsincrona;
import org.openspcoop2.pdd.monitor.driver.StatoConsegneAsincrone;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class DriverMonitoraggio
implements IDriverMonitoraggio {
    private DataSource datasource = null;
    private Connection globalConnection = null;
    private String tipoDatabase = null;
    private Logger log = null;
    private List<String> properties;

    private void logError(String msg, Exception e) {
        if (this.log != null) {
            this.log.error(msg, (Throwable)e);
        }
    }

    private void logDebug(String msg) {
        if (this.log != null) {
            this.log.debug(msg);
        }
    }

    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    public DriverMonitoraggio(String nomeDataSource, String tipoDatabase, Properties prop) throws DriverMonitoraggioException {
        this(nomeDataSource, tipoDatabase, prop, null);
    }

    public DriverMonitoraggio(String nomeDataSource, String tipoDatabase, Properties prop, Logger log) throws DriverMonitoraggioException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_MONITORAGGIO") : log;
        }
        catch (Exception e) {
            throw new DriverMonitoraggioException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.log.info("Inizializzo DriverMonitoraggioDB...");
            InitialContext initCtx = new InitialContext(prop);
            this.datasource = (DataSource)initCtx.lookup(nomeDataSource);
            if (this.datasource == null) {
                throw new DriverMonitoraggioException("datasource is null");
            }
            initCtx.close();
            this.log.info("Inizializzo DriverMonitoraggioDB terminata.");
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del datasource...", e);
            throw new DriverMonitoraggioException("Errore durante la ricerca del datasource...", e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject ...");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverMonitoraggioException("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del SQLQueryObject...", e);
            throw new DriverMonitoraggioException("Errore durante la ricerca del SQLQueryObject(" + tipoDatabase + ")...", e);
        }
    }

    public DriverMonitoraggio(String connectionUrl, String driverJDBC, String username, String password, String tipoDatabase) throws DriverMonitoraggioException {
        this(connectionUrl, driverJDBC, username, password, tipoDatabase, null);
    }

    public DriverMonitoraggio(String connectionUrl, String driverJDBC, String username, String password, String tipoDatabase, Logger log) throws DriverMonitoraggioException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_MONITORAGGIO") : log;
        }
        catch (Exception e) {
            throw new DriverMonitoraggioException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.log.info("Inizializzo DriverMonitoraggioDB...");
            ClassLoaderUtilities.newInstance((String)driverJDBC);
            this.globalConnection = DriverMonitoraggio.initConnection(connectionUrl, username, password);
            DriverMonitoraggio.checkConnection(this.globalConnection);
            this.log.info("Inizializzo DriverMonitoraggioDB terminata.");
        }
        catch (Exception e) {
            this.logError("Errore durante l'inizializzazione della connessione...", e);
            throw new DriverMonitoraggioException("Errore durante l'inizializzazione della connessione...", e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject ...");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverMonitoraggioException("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del SQLQueryObject...", e);
            throw new DriverMonitoraggioException("Errore durante la ricerca del SQLQueryObject(" + tipoDatabase + ")...", e);
        }
    }

    private static Connection initConnection(String connectionUrl, String username, String password) throws SQLException {
        if (username != null) {
            return DriverManager.getConnection(connectionUrl, username, password);
        }
        return DriverManager.getConnection(connectionUrl);
    }

    private static void checkConnection(Connection con) throws DriverMonitoraggioException {
        if (con == null) {
            throw new DriverMonitoraggioException("Connection is null");
        }
    }

    private Connection getConnection() throws SQLException {
        if (this.datasource != null) {
            return this.datasource.getConnection();
        }
        return this.globalConnection;
    }

    private void releaseConnection(Connection con) {
        try {
            if (this.datasource != null && con != null) {
                JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)con, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public StatoPdd getStatoRichiestePendenti(FilterSearch search) throws DriverMonitoraggioException {
        StatoPdd statoPdd;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Object sqlQueryObject = null;
        try {
            int k;
            List<BustaSoggetto> filtroSoggetti;
            con = this.getConnection();
            if (con == null) {
                throw new DriverMonitoraggioException("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            StatoPdd statoPdD = new StatoPdd();
            Timestamp now = DateManager.getTimestamp();
            Timestamp dataRegistrazioneLimite = null;
            if (search.getSoglia() != -1L) {
                dataRegistrazioneLimite = new Timestamp(DateManager.getTimeMillis() - search.getSoglia() * 1000L * 60L);
            }
            long totaleMessaggi = 0L;
            long totaleMessaggiDuplicati = -1L;
            sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
            pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
            int paramIndex = 0;
            if (search.getSoglia() != -1L) {
                pstmt.setTimestamp(++paramIndex, dataRegistrazioneLimite);
            }
            if ((filtroSoggetti = search.getSoggettoList()) != null) {
                for (k = 0; k < filtroSoggetti.size(); ++k) {
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                }
            }
            if ((rs = pstmt.executeQuery()).next() && (totaleMessaggi = rs.getLong("totMessaggi")) > 0L) {
                statoPdD.setTotMessaggi(totaleMessaggi);
                statoPdD.setTempoMedioAttesa((now.getTime() - rs.getLong("ora_registrazione_media")) / 1000L);
                statoPdD.setTempoMaxAttesa((now.getTime() - rs.getLong("ora_registrazione_old")) / 1000L);
            }
            rs.close();
            pstmt.close();
            this.logDebug("query[" + (ISQLQueryObject)sqlQueryObject + "] totaleMessaggi:" + totaleMessaggi);
            this.logDebug("Soglia [" + search.getSoglia() + "] [" + dataRegistrazioneLimite + "] totaleMessaggi");
            if (totaleMessaggi > 0L) {
                if (search.getStato() == null || "".equals(search.getStato().getValue()) || StatoMessaggio.CONSEGNA.equals(search.getStato())) {
                    long tot;
                    sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
                    if (search.getStato() == null || "".equals(search.getStato().getValue())) {
                        sqlQueryObject.addWhereCondition("MESSAGGI.PROPRIETARIO='ConsegnaContenutiApplicativi'");
                    }
                    pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
                    paramIndex = 0;
                    if (search.getSoglia() != -1L) {
                        pstmt.setTimestamp(++paramIndex, dataRegistrazioneLimite);
                    }
                    if (filtroSoggetti != null) {
                        for (k = 0; k < filtroSoggetti.size(); ++k) {
                            pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                            pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                            pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                            pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                        }
                    }
                    if ((rs = pstmt.executeQuery()).next() && (tot = rs.getLong("totMessaggi")) > 0L) {
                        statoPdD.setNumMsgInConsegna(tot);
                        statoPdD.setTempoMedioAttesaInConsegna((now.getTime() - rs.getLong("ora_registrazione_media")) / 1000L);
                        statoPdD.setTempoMaxAttesaInConsegna((now.getTime() - rs.getLong("ora_registrazione_old")) / 1000L);
                    }
                    rs.close();
                    pstmt.close();
                    this.logDebug("query[" + (ISQLQueryObject)sqlQueryObject + "] totaleMessaggiInConsegna:" + statoPdD.getNumMsgInConsegna());
                    this.logDebug("Soglia [" + search.getSoglia() + "] [" + dataRegistrazioneLimite + "] totaleMessaggiInConsegna");
                }
                if (search.getStato() == null || "".equals(search.getStato().getValue()) || StatoMessaggio.SPEDIZIONE.equals(search.getStato())) {
                    long tot;
                    sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
                    if (search.getStato() == null || "".equals(search.getStato().getValue())) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"MESSAGGI.PROPRIETARIO='InoltroBuste'", "MESSAGGI.PROPRIETARIO='InoltroRisposte'"});
                    }
                    pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
                    paramIndex = 0;
                    if (search.getSoglia() != -1L) {
                        pstmt.setTimestamp(++paramIndex, dataRegistrazioneLimite);
                    }
                    if (filtroSoggetti != null) {
                        for (k = 0; k < filtroSoggetti.size(); ++k) {
                            pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                            pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                            pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                            pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                        }
                    }
                    if ((rs = pstmt.executeQuery()).next() && (tot = rs.getLong("totMessaggi")) > 0L) {
                        statoPdD.setNumMsgInSpedizione(tot);
                        statoPdD.setTempoMedioAttesaInSpedizione((now.getTime() - rs.getLong("ora_registrazione_media")) / 1000L);
                        statoPdD.setTempoMaxAttesaInSpedizione((now.getTime() - rs.getLong("ora_registrazione_old")) / 1000L);
                    }
                    rs.close();
                    pstmt.close();
                    this.logDebug("query[" + (ISQLQueryObject)sqlQueryObject + "] totaleMessaggiInSpedizione:" + statoPdD.getNumMsgInSpedizione());
                    this.logDebug("Soglia [" + search.getSoglia() + "] [" + dataRegistrazioneLimite + "] totaleMessaggiInSpedizione");
                }
                if (search.getStato() == null || "".equals(search.getStato().getValue()) || StatoMessaggio.PROCESSAMENTO.equals(search.getStato())) {
                    long tot;
                    sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
                    if (search.getStato() == null || "".equals(search.getStato().getValue())) {
                        sqlQueryObject.addWhereCondition(true, new String[]{"MESSAGGI.PROPRIETARIO<>'InoltroBuste'", "MESSAGGI.PROPRIETARIO<>'InoltroRisposte'", "MESSAGGI.PROPRIETARIO<>'ConsegnaContenutiApplicativi'"});
                    }
                    pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
                    paramIndex = 0;
                    if (search.getSoglia() != -1L) {
                        pstmt.setTimestamp(++paramIndex, dataRegistrazioneLimite);
                    }
                    if (filtroSoggetti != null) {
                        for (k = 0; k < filtroSoggetti.size(); ++k) {
                            pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                            pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                            pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                            pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                        }
                    }
                    if ((rs = pstmt.executeQuery()).next() && (tot = rs.getLong("totMessaggi")) > 0L) {
                        statoPdD.setNumMsgInProcessamento(tot);
                        statoPdD.setTempoMedioAttesaInProcessamento((now.getTime() - rs.getLong("ora_registrazione_media")) / 1000L);
                        statoPdD.setTempoMaxAttesaInProcessamento((now.getTime() - rs.getLong("ora_registrazione_old")) / 1000L);
                    }
                    rs.close();
                    pstmt.close();
                    this.logDebug("query[" + (ISQLQueryObject)sqlQueryObject + "] totaleMessaggiInProcessamento:" + statoPdD.getNumMsgInProcessamento());
                    this.logDebug("Soglia [" + search.getSoglia() + "] [" + dataRegistrazioneLimite + "] totaleMessaggiInProcessamento");
                }
            }
            this.logDebug("Calcolo numero pacchetti duplicati...");
            sqlQueryObject = this.newSQLQueryPacchettiDuplicati(search);
            pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
            if (search.getSoglia() != -1L) {
                pstmt.setTimestamp(1, dataRegistrazioneLimite);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                totaleMessaggiDuplicati = rs.getLong("numduplicati");
                statoPdD.setTotMessaggiDuplicati(totaleMessaggiDuplicati);
            }
            rs.close();
            pstmt.close();
            this.logDebug("query[" + sqlQueryObject.toString() + "] totaleMessaggiDuplicati:" + totaleMessaggiDuplicati);
            this.logDebug("Soglia [" + search.getSoglia() + "] [" + dataRegistrazioneLimite + "] totaleMessaggiDuplicati");
            statoPdd = statoPdD;
        }
        catch (Exception e) {
            try {
                if (sqlQueryObject != null) {
                    this.logError("getStatoRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]", e);
                    throw new DriverMonitoraggioException("getStatoRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]: " + e.getMessage(), e);
                }
                this.logError("getStatoRichiestePendenti error", e);
                throw new DriverMonitoraggioException("getStatoRichiestePendenti error: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, pstmt);
                this.releaseConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)pstmt);
        this.releaseConnection(con);
        return statoPdd;
    }

    public long getTotaleMessaggiInGestione() throws DriverMonitoraggioException {
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            if (con == null) {
                throw new DriverMonitoraggioException("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            long totaleMessaggi = 0L;
            String query = "SELECT count(*) as totMessaggi FROM MESSAGGI WHERE MESSAGGI.PROPRIETARIO<>'GestoreMessaggi'";
            pstmt = con.prepareStatement(query);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                totaleMessaggi = rs.getLong("totMessaggi");
            }
            rs.close();
            pstmt.close();
            this.logDebug("query[" + query + "] totaleMessaggi:" + totaleMessaggi);
            long l = totaleMessaggi;
            return l;
        }
        catch (Exception e) {
            this.logError("getTotaleMessaggiInGestione error", e);
            throw new DriverMonitoraggioException("getStatoRichiestePendenti error: " + e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(con);
        }
    }

    @Override
    public long countListaRichiestePendenti(FilterSearch search) throws DriverMonitoraggioException {
        long l;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Object sqlQueryObject = null;
        long oldLimit = search.getLimit();
        long oldOffset = search.getOffset();
        try {
            List<BustaSoggetto> filtroSoggetti;
            con = this.getConnection();
            if (con == null) {
                throw new DriverMonitoraggioException("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            Timestamp dataRegistrazioneLimite = null;
            if (search.getSoglia() != -1L) {
                dataRegistrazioneLimite = new Timestamp(DateManager.getTimeMillis() - search.getSoglia() * 1000L * 60L);
            }
            long totaleMessaggi = 0L;
            search.setLimit(-1L);
            search.setOffset(-1L);
            sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
            pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
            int paramIndex = 0;
            if (search.getSoglia() != -1L) {
                pstmt.setTimestamp(++paramIndex, dataRegistrazioneLimite);
            }
            if ((filtroSoggetti = search.getSoggettoList()) != null) {
                for (int k = 0; k < filtroSoggetti.size(); ++k) {
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                }
            }
            if ((rs = pstmt.executeQuery()).next()) {
                totaleMessaggi = rs.getLong("totMessaggi");
            }
            rs.close();
            pstmt.close();
            this.logDebug("query[" + (ISQLQueryObject)sqlQueryObject + "] totaleMessaggi:" + totaleMessaggi);
            this.logDebug("Soglia [" + search.getSoglia() + "] [" + dataRegistrazioneLimite + "] totaleMessaggi");
            l = totaleMessaggi;
            search.setLimit(oldLimit);
            search.setOffset(oldOffset);
        }
        catch (Exception e) {
            try {
                if (sqlQueryObject != null) {
                    this.logError("getListaRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]", e);
                    throw new DriverMonitoraggioException("getListaRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]: " + e.getMessage(), e);
                }
                this.logError("getListaRichiestePendenti error", e);
                throw new DriverMonitoraggioException("getListaRichiestePendenti error: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                search.setLimit(oldLimit);
                search.setOffset(oldOffset);
                JDBCUtilities.closeResources(rs, pstmt);
                this.releaseConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)pstmt);
        this.releaseConnection(con);
        return l;
    }

    @Override
    public List<Messaggio> getListaRichiestePendenti(FilterSearch search) throws DriverMonitoraggioException {
        ArrayList<Messaggio> arrayList;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Object sqlQueryObject = null;
        try {
            con = this.getConnection();
            if (con == null) {
                throw new DriverMonitoraggioException("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            Timestamp dataRegistrazioneLimite = null;
            if (search.getSoglia() != -1L) {
                dataRegistrazioneLimite = new Timestamp(DateManager.getTimeMillis() - search.getSoglia() * 1000L * 60L);
            }
            List<BustaSoggetto> filtroSoggetti = search.getSoggettoList();
            sqlQueryObject = this.newSQLQueryObjectListaRichiestePendenti(search);
            pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
            int paramIndex = 0;
            if (search.getSoglia() != -1L) {
                pstmt.setTimestamp(++paramIndex, dataRegistrazioneLimite);
            }
            if (filtroSoggetti != null) {
                for (int k = 0; k < filtroSoggetti.size(); ++k) {
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                }
            }
            rs = pstmt.executeQuery();
            ArrayList<Messaggio> msgs = new ArrayList<Messaggio>();
            this.logDebug("query[" + (ISQLQueryObject)sqlQueryObject + "] listaMessaggi");
            this.logDebug("Soglia [" + search.getSoglia() + "] [" + dataRegistrazioneLimite + "] listaMessaggi");
            while (rs.next()) {
                Messaggio m = new Messaggio();
                m.setIdMessaggio(rs.getString("id_messaggio"));
                Dettaglio dettaglio = new Dettaglio();
                dettaglio.setIdModulo(rs.getString("PROPRIETARIO"));
                dettaglio.setTipo(rs.getString("tipo"));
                dettaglio.setErroreProcessamento(rs.getString("ERRORE_PROCESSAMENTO"));
                dettaglio.setIdCorrelazioneApplicativa(rs.getString("CORRELAZIONE_APPLICATIVA"));
                if (this.properties != null) {
                    for (int i = 0; i < this.properties.size(); ++i) {
                        String key = this.properties.get(i);
                        Proprieta proprieta = new Proprieta();
                        proprieta.setNome(key);
                        proprieta.setValore(rs.getString(key));
                        dettaglio.addProprieta(proprieta);
                    }
                }
                m.setDettaglio(dettaglio);
                if (rs.getTimestamp("ORA_REGISTRAZIONE") != null) {
                    m.setOraRegistrazione(rs.getTimestamp("ORA_REGISTRAZIONE"));
                }
                m.setOraAttuale(DateManager.getDate());
                if ("ConsegnaContenutiApplicativi".equals(rs.getString("PROPRIETARIO"))) {
                    m.setStato(StatoMessaggio.CONSEGNA);
                } else if ("InoltroBuste".equals(rs.getString("PROPRIETARIO"))) {
                    m.setStato(StatoMessaggio.SPEDIZIONE);
                } else if ("InoltroRisposte".equals(rs.getString("PROPRIETARIO"))) {
                    m.setStato(StatoMessaggio.SPEDIZIONE);
                } else {
                    m.setStato(StatoMessaggio.PROCESSAMENTO);
                }
                if (search.getBusta() != null) {
                    Busta bustaInfo = new Busta();
                    BustaSoggetto mittente = new BustaSoggetto();
                    mittente.setNome(rs.getString("MITTENTE"));
                    mittente.setTipo(rs.getString("TIPO_MITTENTE"));
                    bustaInfo.setMittente(mittente);
                    BustaSoggetto destinatario = new BustaSoggetto();
                    destinatario.setNome(rs.getString("DESTINATARIO"));
                    destinatario.setTipo(rs.getString("TIPO_DESTINATARIO"));
                    bustaInfo.setDestinatario(destinatario);
                    BustaServizio servizio = new BustaServizio();
                    servizio.setTipo(rs.getString("TIPO_SERVIZIO"));
                    servizio.setNome(rs.getString("SERVIZIO"));
                    try {
                        servizio.setVersione(Integer.valueOf(rs.getString("VERSIONE_SERVIZIO")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bustaInfo.setServizio(servizio);
                    bustaInfo.setAzione(rs.getString("AZIONE"));
                    bustaInfo.setProfiloCollaborazione(rs.getString("PROFILO_DI_COLLABORAZIONE"));
                    bustaInfo.setRiferimentoMessaggio(rs.getString("RIFERIMENTO_MESSAGGIO"));
                    bustaInfo.setCollaborazione(rs.getString("COLLABORAZIONE"));
                    m.setBustaInfo(bustaInfo);
                }
                msgs.add(m);
            }
            rs.close();
            pstmt.close();
            for (int i = 0; i < msgs.size(); ++i) {
                boolean checkSA = false;
                if (msgs.get(i) != null && StatoMessaggio.CONSEGNA.equals(((Messaggio)msgs.get(i)).getStato()) && ((Messaggio)msgs.get(i)).getDettaglio() != null) {
                    checkSA = true;
                } else if (msgs.get(i) != null && ((Messaggio)msgs.get(i)).getDettaglio() != null && ((Messaggio)msgs.get(i)).getDettaglio().getIdModulo() != null && ((Messaggio)msgs.get(i)).getDettaglio().getIdModulo().startsWith("RicezioneContenutiApplicativi")) {
                    checkSA = true;
                }
                if (checkSA) {
                    this.logDebug("Raccolgo informazioni dei servizi applicativi...");
                    String sqlQuerySA = "SELECT * FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=?";
                    pstmt = con.prepareStatement(sqlQuerySA);
                    pstmt.setString(1, ((Messaggio)msgs.get(i)).getIdMessaggio());
                    rs = pstmt.executeQuery();
                    ArrayList<ServizioApplicativoConsegna> sconsegna = new ArrayList<ServizioApplicativoConsegna>();
                    while (rs.next()) {
                        ServizioApplicativoConsegna datiConsegna = new ServizioApplicativoConsegna();
                        if (rs.getInt("SBUSTAMENTO_SOAP") == 1) {
                            datiConsegna.setSbustamentoSoap(true);
                        } else {
                            datiConsegna.setSbustamentoSoap(false);
                        }
                        if (rs.getInt("SBUSTAMENTO_INFO_PROTOCOL") == 1) {
                            datiConsegna.setSbustamentoInformazioniProtocollo(true);
                        } else {
                            datiConsegna.setSbustamentoInformazioniProtocollo(false);
                        }
                        if (rs.getInt("INTEGRATION_MANAGER") == 1) {
                            datiConsegna.setAutorizzazioneIntegrationManager(true);
                        } else {
                            datiConsegna.setAutorizzazioneIntegrationManager(false);
                        }
                        datiConsegna.setNome(rs.getString("SERVIZIO_APPLICATIVO"));
                        datiConsegna.setTipoConsegna(rs.getString("TIPO_CONSEGNA"));
                        datiConsegna.setErroreProcessamento(rs.getString("ERRORE_PROCESSAMENTO"));
                        if (rs.getTimestamp("RISPEDIZIONE") != null) {
                            datiConsegna.setDataRispedizione(rs.getTimestamp("RISPEDIZIONE"));
                        }
                        datiConsegna.setNomePorta(rs.getString("NOME_PORTA"));
                        datiConsegna.setCoda(rs.getString("CODA"));
                        datiConsegna.setPriorita(rs.getString("PRIORITA"));
                        if (rs.getInt("ATTESA_ESITO") == 1) {
                            datiConsegna.setAttesaEsito(true);
                        } else {
                            datiConsegna.setAttesaEsito(false);
                        }
                        sconsegna.add(datiConsegna);
                    }
                    rs.close();
                    pstmt.close();
                    if (!sconsegna.isEmpty()) {
                        ((Messaggio)msgs.get(i)).getDettaglio().setServizioApplicativoConsegnaList(sconsegna);
                    }
                }
                if (msgs.get(i) == null || ((Messaggio)msgs.get(i)).getBustaInfo() == null || !StatoMessaggio.SPEDIZIONE.equals(((Messaggio)msgs.get(i)).getStato())) continue;
                if (search.getBusta() != null && search.getBusta().isAttesaRiscontro()) {
                    ((Messaggio)msgs.get(i)).getBustaInfo().setAttesaRiscontro(true);
                    continue;
                }
                this.logDebug("Raccolgo informazioni per attesa riscontro...");
                String sqlQueryRiscontro = "SELECT * FROM RISCONTRI_DA_RICEVERE WHERE ID_MESSAGGIO=?";
                pstmt = con.prepareStatement(sqlQueryRiscontro);
                pstmt.setString(1, ((Messaggio)msgs.get(i)).getIdMessaggio());
                rs = pstmt.executeQuery();
                ((Messaggio)msgs.get(i)).getBustaInfo().setAttesaRiscontro(rs.next());
                rs.close();
                pstmt.close();
            }
            arrayList = msgs;
        }
        catch (Exception e) {
            try {
                if (sqlQueryObject != null) {
                    this.logError("getListaRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]", e);
                    throw new DriverMonitoraggioException("getListaRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]: " + e.getMessage(), e);
                }
                this.logError("getListaRichiestePendenti error", e);
                throw new DriverMonitoraggioException("getListaRichiestePendenti error: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, pstmt);
                this.releaseConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)pstmt);
        this.releaseConnection(con);
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    private boolean deleteMessaggio(String idMessaggio, String tipo) throws DriverMonitoraggioException {
        block14: {
            con = null;
            pstmt = null;
            con = this.getConnection();
            if (con == null) {
                throw new DriverMonitoraggioException("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            tipoMessaggio = tipo;
            if (tipoMessaggio != null) ** GOTO lbl23
            this.logDebug("Ricerco tipo messaggio...");
            filtro = new FilterSearch();
            filtro.setIdMessaggio(idMessaggio);
            lista = this.getListaRichiestePendenti(filtro);
            if (lista != null && !lista.isEmpty()) break block14;
            var8_11 = false;
            JDBCUtilities.closeResources((PreparedStatement)pstmt);
            this.releaseConnection(con);
            return var8_11;
        }
        try {
            if (lista.get(0).getDettaglio() == null || lista.get(0).getDettaglio().getTipo() == null) {
                throw new DriverMonitoraggioException("Tipo messaggio non identificato per l'id: " + idMessaggio);
            }
            tipoMessaggio = lista.get(0).getDettaglio().getTipo();
lbl23:
            // 2 sources

            this.logDebug("Messaggio con id(" + idMessaggio + ") da eliminare possiede tipo: " + tipoMessaggio);
            if ("OUTBOX".equals(tipoMessaggio)) {
                sqlQuery = "DELETE FROM RISCONTRI_DA_RICEVERE WHERE ID_MESSAGGIO=?";
                pstmt = con.prepareStatement(sqlQuery);
                pstmt.setString(1, idMessaggio);
                operation = pstmt.executeUpdate();
                if (operation > 0) {
                    this.logDebug("Attesa riscontro per " + idMessaggio + " eliminato");
                } else {
                    this.logDebug("Attesa riscontro per " + idMessaggio + " non esistente");
                }
                pstmt.close();
                sqlQuery = "DELETE FROM ASINCRONO WHERE ID_MESSAGGIO=? AND TIPO=?";
                pstmt = con.prepareStatement(sqlQuery);
                pstmt.setString(1, idMessaggio);
                pstmt.setString(2, tipoMessaggio);
                operation = pstmt.executeUpdate();
                if (operation > 0) {
                    this.logDebug("ProfiloAsincrono per " + idMessaggio + " eliminato");
                } else {
                    this.logDebug("ProfiloAsincrono per " + idMessaggio + " non esistente");
                }
                pstmt.close();
            }
            sqlQuery = "UPDATE MESSAGGI SET PROPRIETARIO='GestoreMessaggi' WHERE PROPRIETARIO<>'GestoreMessaggi' AND ID_MESSAGGIO=?  AND tipo=?";
            pstmt = con.prepareStatement(sqlQuery);
            pstmt.setString(1, idMessaggio);
            pstmt.setString(2, tipoMessaggio);
            operation = pstmt.executeUpdate();
            result = false;
            if (operation > 0) {
                result = true;
                this.logDebug("Messaggio " + idMessaggio + " eliminato");
            } else {
                this.logDebug("Messaggio " + idMessaggio + " non esistente");
            }
            pstmt.close();
            var9_13 = result;
        }
        catch (Exception e) {
            try {
                this.logError("deleteMessaggio error", e);
                throw new DriverMonitoraggioException("deleteMessaggio error: " + e.getMessage());
            }
            catch (Throwable var10_14) {
                JDBCUtilities.closeResources(pstmt);
                this.releaseConnection(con);
                throw var10_14;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)pstmt);
        this.releaseConnection(con);
        return var9_13;
    }

    private boolean aggiornaDataRispedizioneMessaggio(String idMessaggio, String tipo, Timestamp data) throws DriverMonitoraggioException {
        Connection con = null;
        Statement pstmt = null;
        try {
            String sqlQuery;
            con = this.getConnection();
            if (con == null) {
                throw new DriverMonitoraggioException("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            String tipoMessaggio = tipo;
            if (tipoMessaggio == null) {
                this.logDebug("Ricerco tipo messaggio...");
                FilterSearch filtro = new FilterSearch();
                filtro.setIdMessaggio(idMessaggio);
                List<Messaggio> lista = this.getListaRichiestePendenti(filtro);
                if (lista == null || lista.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                if (lista.get(0).getDettaglio() == null || lista.get(0).getDettaglio().getTipo() == null) {
                    throw new DriverMonitoraggioException("Tipo messaggio non identificato per l'id: " + idMessaggio);
                }
                tipoMessaggio = lista.get(0).getDettaglio().getTipo();
            }
            this.logDebug("Messaggio con id(" + idMessaggio + ") da eliminare possiede tipo: " + tipoMessaggio);
            if ("OUTBOX".equals(tipoMessaggio)) {
                sqlQuery = "UPDATE MESSAGGI SET RISPEDIZIONE=? WHERE ID_MESSAGGIO=?  AND TIPO=?";
                pstmt = con.prepareStatement(sqlQuery);
                pstmt.setTimestamp(1, data);
                pstmt.setString(2, idMessaggio);
                pstmt.setString(3, tipoMessaggio);
                int operation = pstmt.executeUpdate();
                boolean result = false;
                if (operation > 0) {
                    result = true;
                    this.logDebug("Messaggio " + idMessaggio + " aggiornato");
                } else {
                    this.logDebug("Messaggio " + idMessaggio + " non aggiornato");
                }
                pstmt.close();
                boolean bl = result;
                return bl;
            }
            sqlQuery = "UPDATE MSG_SERVIZI_APPLICATIVI SET RISPEDIZIONE=? WHERE ID_MESSAGGIO=?  AND TIPO=?";
            pstmt = con.prepareStatement(sqlQuery);
            pstmt.setTimestamp(1, data);
            pstmt.setString(2, idMessaggio);
            pstmt.setString(3, tipoMessaggio);
            int operation = pstmt.executeUpdate();
            boolean result = false;
            if (operation > 0) {
                result = true;
                this.logDebug("Messaggio " + idMessaggio + " aggiornato");
            } else {
                this.logDebug("Messaggio " + idMessaggio + " non aggiornato");
            }
            pstmt.close();
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            this.logError("deleteMessaggio error", e);
            throw new DriverMonitoraggioException("deleteMessaggio error: " + e.getMessage());
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(con);
        }
    }

    @Override
    public long deleteRichiestePendenti(FilterSearch search) throws DriverMonitoraggioException {
        return this.richiestePendentiEngine(search, true);
    }

    @Override
    public long aggiornaDataRispedizioneRichiestePendenti(FilterSearch search) throws DriverMonitoraggioException {
        return this.richiestePendentiEngine(search, false);
    }

    private long richiestePendentiEngine(FilterSearch search, boolean delete) throws DriverMonitoraggioException {
        long l;
        String nomeMetodo = delete ? "deleteRichiestePendenti" : "aggiornaDataRispedizioneRichiestePendenti";
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Object sqlQueryObject = null;
        try {
            List<BustaSoggetto> filtroSoggetti;
            con = this.getConnection();
            if (con == null) {
                throw new DriverMonitoraggioException("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            Timestamp dataRegistrazioneLimite = null;
            if (search.getSoglia() != -1L) {
                dataRegistrazioneLimite = new Timestamp(DateManager.getTimeMillis() - search.getSoglia() * 1000L * 60L);
            }
            sqlQueryObject = this.newSQLQueryObjectListaRichiestePendenti(search);
            pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
            int paramIndex = 0;
            if (search.getSoglia() != -1L) {
                pstmt.setTimestamp(++paramIndex, dataRegistrazioneLimite);
            }
            if ((filtroSoggetti = search.getSoggettoList()) != null) {
                for (int k = 0; k < filtroSoggetti.size(); ++k) {
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++paramIndex, filtroSoggetti.get(k).getNome());
                }
            }
            rs = pstmt.executeQuery();
            ArrayList<Messaggio> msgs = new ArrayList<Messaggio>();
            this.logDebug("query[" + (ISQLQueryObject)sqlQueryObject + "] listaMessaggi");
            this.logDebug("Soglia [" + search.getSoglia() + "] [" + dataRegistrazioneLimite + "] listaMessaggi");
            while (rs.next()) {
                Messaggio m = new Messaggio();
                m.setIdMessaggio(rs.getString("ID_MESSAGGIO"));
                Dettaglio dettaglio = new Dettaglio();
                dettaglio.setTipo(rs.getString("tipo"));
                m.setDettaglio(dettaglio);
                msgs.add(m);
            }
            rs.close();
            pstmt.close();
            Timestamp now = DateManager.getTimestamp();
            long numeroMsg = 0L;
            while (!msgs.isEmpty()) {
                Messaggio msgForDelete = (Messaggio)msgs.remove(0);
                if (delete) {
                    if (!this.deleteMessaggio(msgForDelete.getIdMessaggio(), msgForDelete.getDettaglio().getTipo())) continue;
                    ++numeroMsg;
                    continue;
                }
                if (!this.aggiornaDataRispedizioneMessaggio(msgForDelete.getIdMessaggio(), msgForDelete.getDettaglio().getTipo(), now)) continue;
                ++numeroMsg;
            }
            if (delete) {
                this.logDebug("eliminati " + numeroMsg + " messaggi");
            } else {
                this.logDebug("aggiornati " + numeroMsg + " messaggi");
            }
            l = numeroMsg;
        }
        catch (Exception e) {
            try {
                if (sqlQueryObject != null) {
                    this.logError(nomeMetodo + " error SQL[" + sqlQueryObject.toString() + "]", e);
                    throw new DriverMonitoraggioException(nomeMetodo + " error SQL[" + sqlQueryObject.toString() + "]: " + e.getMessage(), e);
                }
                this.logError(nomeMetodo + " error", e);
                throw new DriverMonitoraggioException(nomeMetodo + " error: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, pstmt);
                this.releaseConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)pstmt);
        this.releaseConnection(con);
        return l;
    }

    @Override
    public StatoConsegneAsincrone getStatoConsegneAsincrone(FiltroStatoConsegnaAsincrona filtro) throws DriverMonitoraggioException {
        StatoConsegneAsincrone statoConsegneAsincrone;
        String nomeMetodo = "getStatoConsegneAsincrone";
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            con = this.getConnection();
            if (con == null) {
                throw new DriverMonitoraggioException("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            sqlQuery = this.newSQLQueryStatoConsegneAsincrone(filtro);
            pstmt = con.prepareStatement(sqlQuery);
            rs = pstmt.executeQuery();
            StatoConsegneAsincrone stati = new StatoConsegneAsincrone();
            this.logDebug("query[" + sqlQuery + "] getStatoConsegneAsincrone");
            while (rs.next()) {
                StatoConsegnaAsincrona stato = new StatoConsegnaAsincrona();
                stato.setNow(rs.getTimestamp("tempoAttuale"));
                stato.setServizioApplicativo(rs.getString("nomeSA"));
                stato.setInCoda(rs.getLong("inCoda"));
                stato.setVecchioInCoda(rs.getTimestamp("vecchioInCoda"));
                stato.setRecenteInCoda(rs.getTimestamp("recenteInCoda"));
                stato.setInRiconsegna(rs.getLong("inRiconsegna"));
                stato.setVecchioInRiconsegna(rs.getTimestamp("vecchioInRiconsegna"));
                stato.setRecenteInRiconsegna(rs.getTimestamp("recenteInRiconsegna"));
                stato.setInMessageBox(rs.getLong("inMessageBox"));
                stato.setVecchioInMessageBox(rs.getTimestamp("vecchioInMessageBox"));
                stato.setRecenteInMessageBox(rs.getTimestamp("recenteInMessageBox"));
                stati.addStato(stato);
            }
            rs.close();
            pstmt.close();
            this.logDebug("trovati " + stati.size() + " stati");
            statoConsegneAsincrone = stati;
        }
        catch (Exception e) {
            try {
                if (sqlQuery != null) {
                    this.logError(nomeMetodo + " error SQL[" + sqlQuery + "]", e);
                    throw new DriverMonitoraggioException(nomeMetodo + " error SQL[" + sqlQuery + "]: " + e.getMessage(), e);
                }
                this.logError(nomeMetodo + " error", e);
                throw new DriverMonitoraggioException(nomeMetodo + " error: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, pstmt);
                this.releaseConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)pstmt);
        this.releaseConnection(con);
        return statoConsegneAsincrone;
    }

    private ISQLQueryObject newSQLQueryObjectStatoRichiestePendenti(FilterSearch search) throws SQLQueryObjectException {
        return this.newSQLQueryObjectRichiestePendenti(true, search);
    }

    private ISQLQueryObject newSQLQueryObjectListaRichiestePendenti(FilterSearch search) throws SQLQueryObjectException {
        return this.newSQLQueryObjectRichiestePendenti(false, search);
    }

    private ISQLQueryObject newSQLQueryObjectRichiestePendenti(boolean statoRichieste, FilterSearch search) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addFromTable("MESSAGGI");
        if (search.getMessagePattern() != null && !"".equals(search.getMessagePattern())) {
            sqlQueryObject.addFromTable("DEFINIZIONE_MESSAGGI");
        }
        if (search.getBusta() != null) {
            sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
            if (search.getBusta().isAttesaRiscontro()) {
                sqlQueryObject.addFromTable("RISCONTRI_DA_RICEVERE");
            }
        } else if (search.getSoggettoList() != null && !search.getSoggettoList().isEmpty()) {
            sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
        }
        String legameTabelleSQLMsgId = "MESSAGGI.ID_MESSAGGIO=DEFINIZIONE_MESSAGGI.ID_MESSAGGIO";
        String legameTabelleSQLMsgTipo = "MESSAGGI.TIPO=DEFINIZIONE_MESSAGGI.TIPO";
        String legameTabelleSQLBustaId = "MESSAGGI.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO";
        String legameTabelleSQLBustaTipo = "MESSAGGI.TIPO=REPOSITORY_BUSTE.TIPO";
        String legameTabelleSQLRiscontro = "MESSAGGI.ID_MESSAGGIO=RISCONTRI_DA_RICEVERE.ID_MESSAGGIO";
        if (search.getMessagePattern() != null && !"".equals(search.getMessagePattern())) {
            sqlQueryObject.addWhereCondition(true, new String[]{legameTabelleSQLMsgId, legameTabelleSQLMsgTipo});
        }
        if (search.getBusta() != null) {
            sqlQueryObject.addWhereCondition(true, new String[]{legameTabelleSQLBustaId, legameTabelleSQLBustaTipo});
        } else if (search.getSoggettoList() != null && !search.getSoggettoList().isEmpty()) {
            sqlQueryObject.addWhereCondition(true, new String[]{legameTabelleSQLBustaId, legameTabelleSQLBustaTipo});
        }
        if (search.getBusta() != null && search.getBusta().isAttesaRiscontro()) {
            sqlQueryObject.addWhereCondition(legameTabelleSQLRiscontro);
        }
        if (statoRichieste) {
            sqlQueryObject.addSelectCountField("MESSAGGI.ID_MESSAGGIO", "totMessaggi", true);
            sqlQueryObject.addSelectAvgTimestampField("MESSAGGI.ora_registrazione", "ora_registrazione_media");
            sqlQueryObject.addSelectMinTimestampField("MESSAGGI.ora_registrazione", "ora_registrazione_old");
        } else {
            sqlQueryObject.addSelectField("MESSAGGI", "ID_MESSAGGIO");
            sqlQueryObject.addSelectField("MESSAGGI", "TIPO");
            sqlQueryObject.addSelectField("MESSAGGI", "PROPRIETARIO");
            sqlQueryObject.addSelectField("MESSAGGI", "ORA_REGISTRAZIONE");
            sqlQueryObject.addSelectField("MESSAGGI", "ERRORE_PROCESSAMENTO");
            sqlQueryObject.addSelectField("MESSAGGI", "CORRELAZIONE_APPLICATIVA");
            if (this.properties != null) {
                for (int i = 0; i < this.properties.size(); ++i) {
                    String key = this.properties.get(i);
                    sqlQueryObject.addSelectField("MESSAGGI", key);
                }
            }
            if (search.getMessagePattern() != null && !"".equals(search.getMessagePattern())) {
                sqlQueryObject.addSelectField("DEFINIZIONE_MESSAGGI", "MSG_BYTES");
            }
            if (search.getBusta() != null) {
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "TIPO_MITTENTE");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "MITTENTE");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "TIPO_DESTINATARIO");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "DESTINATARIO");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "TIPO_SERVIZIO");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "SERVIZIO");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "AZIONE");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "PROFILO_DI_COLLABORAZIONE");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "RIFERIMENTO_MESSAGGIO");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "COLLABORAZIONE");
            }
            if (search.getBusta() == null || search.getBusta().isAttesaRiscontro()) {
                // empty if block
            }
        }
        sqlQueryObject.setANDLogicOperator(true);
        if (!statoRichieste) {
            sqlQueryObject.addOrderBy("MESSAGGI.ORA_REGISTRAZIONE");
            sqlQueryObject.setSortType(false);
        }
        if (search.getStato() == null || "".equals(search.getStato().getValue()) || !StatoMessaggio.CANCELLATO.equals(search.getStato())) {
            sqlQueryObject.addWhereCondition("MESSAGGI.PROPRIETARIO<>'GestoreMessaggi'");
        }
        if (search.getStato() != null && !"".equals(search.getStato().getValue())) {
            if (StatoMessaggio.CONSEGNA.equals(search.getStato())) {
                sqlQueryObject.addWhereCondition("MESSAGGI.PROPRIETARIO='ConsegnaContenutiApplicativi'");
            } else if (StatoMessaggio.SPEDIZIONE.equals(search.getStato())) {
                sqlQueryObject.addWhereCondition(false, new String[]{"MESSAGGI.PROPRIETARIO='InoltroBuste'", "MESSAGGI.PROPRIETARIO='InoltroRisposte'"});
            } else if (StatoMessaggio.CANCELLATO.equals(search.getStato())) {
                sqlQueryObject.addWhereCondition("MESSAGGI.PROPRIETARIO='GestoreMessaggi'");
            } else if (StatoMessaggio.PROCESSAMENTO.equals(search.getStato())) {
                sqlQueryObject.addWhereCondition(true, new String[]{"MESSAGGI.PROPRIETARIO<>'InoltroBuste'", "MESSAGGI.PROPRIETARIO<>'InoltroRisposte'", "MESSAGGI.PROPRIETARIO<>'ConsegnaContenutiApplicativi'"});
            } else {
                throw new SQLQueryObjectException("Stato per filtro non conosciuto: " + search.getStato());
            }
        }
        if (search.getIdMessaggio() != null && !"".equals(search.getIdMessaggio())) {
            sqlQueryObject.addWhereCondition("MESSAGGI.ID_MESSAGGIO='" + search.getIdMessaggio() + "'");
        }
        if (search.getProprietaList() != null && !search.getProprietaList().isEmpty()) {
            List<Proprieta> proprietaList = search.getProprietaList();
            for (Proprieta proprieta : proprietaList) {
                sqlQueryObject.addWhereCondition("MESSAGGI." + proprieta.getNome() + "='" + proprieta.getValore() + "'");
            }
        }
        if (search.getMessagePattern() != null && !"".equals(search.getMessagePattern())) {
            sqlQueryObject.addWhereLikeCondition("DEFINIZIONE_MESSAGGI.MSG_BYTES", search.getMessagePattern(), true, true);
        }
        if (search.getCorrelazioneApplicativa() != null && !"".equals(search.getCorrelazioneApplicativa())) {
            sqlQueryObject.addWhereCondition("MESSAGGI.CORRELAZIONE_APPLICATIVA='" + search.getCorrelazioneApplicativa() + "'");
        }
        if (search.getSoglia() != -1L) {
            sqlQueryObject.addWhereCondition("MESSAGGI.ora_registrazione<=?");
        }
        if (!statoRichieste) {
            if (search.getLimit() != -1L) {
                sqlQueryObject.setLimit((int)search.getLimit());
            }
            if (search.getOffset() != -1L) {
                sqlQueryObject.setOffset((int)search.getOffset());
            }
        }
        if (search.getBusta() != null) {
            if (search.getBusta().getMittente() != null) {
                if (search.getBusta().getMittente().getTipo() != null && !"".equals(search.getBusta().getMittente().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_MITTENTE='" + search.getBusta().getMittente().getTipo() + "'");
                }
                if (search.getBusta().getMittente().getNome() != null && !"".equals(search.getBusta().getMittente().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.MITTENTE='" + search.getBusta().getMittente().getNome() + "'");
                }
            }
            if (search.getBusta().getDestinatario() != null) {
                if (search.getBusta().getDestinatario().getTipo() != null && !"".equals(search.getBusta().getDestinatario().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_DESTINATARIO='" + search.getBusta().getDestinatario().getTipo() + "'");
                }
                if (search.getBusta().getDestinatario().getNome() != null && !"".equals(search.getBusta().getDestinatario().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.DESTINATARIO='" + search.getBusta().getDestinatario().getNome() + "'");
                }
            }
            if (search.getBusta().getServizio() != null) {
                if (search.getBusta().getServizio().getTipo() != null && !"".equals(search.getBusta().getServizio().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_SERVIZIO='" + search.getBusta().getServizio().getTipo() + "'");
                }
                if (search.getBusta().getServizio().getNome() != null && !"".equals(search.getBusta().getServizio().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.SERVIZIO='" + search.getBusta().getServizio().getNome() + "'");
                }
                if (search.getBusta().getServizio().getVersione() != null && search.getBusta().getServizio().getVersione() > 0) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.VERSIONE_SERVIZIO='" + search.getBusta().getServizio().getVersione() + "'");
                }
            }
            if (search.getBusta().getAzione() != null && !"".equals(search.getBusta().getAzione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.AZIONE='" + search.getBusta().getAzione() + "'");
            }
            if (search.getBusta().getProfiloCollaborazione() != null && !"".equals(search.getBusta().getProfiloCollaborazione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.PROFILO_DI_COLLABORAZIONE='" + search.getBusta().getProfiloCollaborazione() + "'");
            }
            if (search.getBusta().getRiferimentoMessaggio() != null && !"".equals(search.getBusta().getRiferimentoMessaggio())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.RIFERIMENTO_MESSAGGIO='" + search.getBusta().getRiferimentoMessaggio() + "'");
            }
            if (search.getBusta().getCollaborazione() != null && !"".equals(search.getBusta().getCollaborazione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.COLLABORAZIONE='" + search.getBusta().getCollaborazione() + "'");
            }
        }
        if (search.getSoggettoList() != null && !search.getSoggettoList().isEmpty()) {
            List<BustaSoggetto> filtroSoggetti = search.getSoggettoList();
            StringBuilder query = new StringBuilder();
            for (int k = 0; k < filtroSoggetti.size(); ++k) {
                if (k > 0) {
                    query.append(" OR ");
                }
                query.append("( ");
                query.append("(REPOSITORY_BUSTE.TIPO_MITTENTE = ? AND REPOSITORY_BUSTE.MITTENTE = ?)");
                query.append(" OR ");
                query.append("(REPOSITORY_BUSTE.TIPO_DESTINATARIO = ? AND REPOSITORY_BUSTE.DESTINATARIO = ?)");
                query.append(" )");
            }
            sqlQueryObject.addWhereCondition(query.toString());
        }
        return sqlQueryObject;
    }

    private ISQLQueryObject newSQLQueryPacchettiDuplicati(FilterSearch search) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
        sqlQueryObject.addSelectField("sum(DUPLICATI) as numduplicati");
        sqlQueryObject.setANDLogicOperator(true);
        if (search.getIdMessaggio() != null && !"".equals(search.getIdMessaggio())) {
            sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.ID_MESSAGGIO='" + search.getIdMessaggio() + "'");
        }
        if (search.getSoglia() != -1L) {
            sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.ora_registrazione<=?");
        }
        if (search.getBusta() != null) {
            if (search.getBusta().getMittente() != null) {
                if (search.getBusta().getMittente().getTipo() != null && !"".equals(search.getBusta().getMittente().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_MITTENTE='" + search.getBusta().getMittente().getTipo() + "'");
                }
                if (search.getBusta().getMittente().getNome() != null && !"".equals(search.getBusta().getMittente().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.MITTENTE='" + search.getBusta().getMittente().getNome() + "'");
                }
            }
            if (search.getBusta().getDestinatario() != null) {
                if (search.getBusta().getDestinatario().getTipo() != null && !"".equals(search.getBusta().getDestinatario().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_DESTINATARIO='" + search.getBusta().getDestinatario().getTipo() + "'");
                }
                if (search.getBusta().getDestinatario().getNome() != null && !"".equals(search.getBusta().getDestinatario().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.DESTINATARIO='" + search.getBusta().getDestinatario().getNome() + "'");
                }
            }
            if (search.getBusta().getServizio() != null) {
                if (search.getBusta().getServizio().getTipo() != null && !"".equals(search.getBusta().getServizio().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_SERVIZIO='" + search.getBusta().getServizio().getTipo() + "'");
                }
                if (search.getBusta().getServizio().getNome() != null && !"".equals(search.getBusta().getServizio().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.SERVIZIO='" + search.getBusta().getServizio().getNome() + "'");
                }
                if (search.getBusta().getServizio().getVersione() != null && search.getBusta().getServizio().getVersione() > 0) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.VERSIONE_SERVIZIO='" + search.getBusta().getServizio().getVersione() + "'");
                }
            }
            if (search.getBusta().getAzione() != null && !"".equals(search.getBusta().getAzione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.AZIONE='" + search.getBusta().getAzione() + "'");
            }
            if (search.getBusta().getProfiloCollaborazione() != null && !"".equals(search.getBusta().getProfiloCollaborazione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.PROFILO_DI_COLLABORAZIONE='" + search.getBusta().getProfiloCollaborazione() + "'");
            }
            if (search.getBusta().getRiferimentoMessaggio() != null && !"".equals(search.getBusta().getRiferimentoMessaggio())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.RIFERIMENTO_MESSAGGIO='" + search.getBusta().getRiferimentoMessaggio() + "'");
            }
            if (search.getBusta().getCollaborazione() != null && !"".equals(search.getBusta().getCollaborazione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.COLLABORAZIONE='" + search.getBusta().getCollaborazione() + "'");
            }
        }
        return sqlQueryObject;
    }

    private String newSQLQueryStatoConsegneAsincrone(FiltroStatoConsegnaAsincrona filtro) throws SQLQueryObjectException {
        String aliasTableServiziApplicativi = "sa";
        String aliasTableMessaggi = "m";
        ISQLQueryObject sqlQueryObjectCoda = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObjectCoda.addFromTable("MSG_SERVIZI_APPLICATIVI", aliasTableServiziApplicativi);
        sqlQueryObjectCoda.addFromTable("MESSAGGI", aliasTableMessaggi);
        sqlQueryObjectCoda.addSelectAliasField(this.getIntZeroValue(), "inRiconsegna");
        sqlQueryObjectCoda.addSelectCountField("inCoda");
        sqlQueryObjectCoda.addSelectAliasField(this.getNullTimestampValue(), "vecchioInRiconsegna");
        sqlQueryObjectCoda.addSelectAliasField(this.getNullTimestampValue(), "recenteInRiconsegna");
        sqlQueryObjectCoda.addSelectMinField(aliasTableServiziApplicativi, "ORA_REGISTRAZIONE", "vecchioInCoda");
        sqlQueryObjectCoda.addSelectMaxField(aliasTableServiziApplicativi, "ORA_REGISTRAZIONE", "recenteInCoda");
        sqlQueryObjectCoda.addSelectAliasField(this.getIntZeroValue(), "inMessageBox");
        sqlQueryObjectCoda.addSelectAliasField(this.getNullTimestampValue(), "vecchioInMessageBox");
        sqlQueryObjectCoda.addSelectAliasField(this.getNullTimestampValue(), "recenteInMessageBox");
        sqlQueryObjectCoda.addSelectAliasField("SERVIZIO_APPLICATIVO", "nomeSA");
        sqlQueryObjectCoda.setANDLogicOperator(true);
        sqlQueryObjectCoda.addWhereCondition(aliasTableServiziApplicativi + ".ATTESA_ESITO=0");
        sqlQueryObjectCoda.addWhereCondition(aliasTableServiziApplicativi + ".ERRORE_PROCESSAMENTO_COMPACT='TimerConsegnaContenutiApplicativi'");
        sqlQueryObjectCoda.addWhereCondition(aliasTableServiziApplicativi + ".TIPO_CONSEGNA='Connettore'");
        sqlQueryObjectCoda.addWhereCondition(aliasTableMessaggi + ".ID_MESSAGGIO=" + aliasTableServiziApplicativi + ".ID_MESSAGGIO");
        sqlQueryObjectCoda.addWhereCondition(aliasTableMessaggi + ".PROPRIETARIO<>'GestoreMessaggi'");
        sqlQueryObjectCoda.addGroupBy("nomeSA");
        ISQLQueryObject sqlQueryObjectRiconsegna = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObjectRiconsegna.addFromTable("MSG_SERVIZI_APPLICATIVI", aliasTableServiziApplicativi);
        sqlQueryObjectRiconsegna.addFromTable("MESSAGGI", aliasTableMessaggi);
        sqlQueryObjectRiconsegna.addSelectCountField("inRiconsegna");
        sqlQueryObjectRiconsegna.addSelectAliasField(this.getIntZeroValue(), "inCoda");
        sqlQueryObjectRiconsegna.addSelectMinField(aliasTableServiziApplicativi, "ORA_REGISTRAZIONE", "vecchioInRiconsegna");
        sqlQueryObjectRiconsegna.addSelectMaxField(aliasTableServiziApplicativi, "ORA_REGISTRAZIONE", "recenteInRiconsegna");
        sqlQueryObjectRiconsegna.addSelectAliasField(this.getNullTimestampValue(), "vecchioInCoda");
        sqlQueryObjectRiconsegna.addSelectAliasField(this.getNullTimestampValue(), "recenteInCoda");
        sqlQueryObjectRiconsegna.addSelectAliasField(this.getIntZeroValue(), "inMessageBox");
        sqlQueryObjectRiconsegna.addSelectAliasField(this.getNullTimestampValue(), "vecchioInMessageBox");
        sqlQueryObjectRiconsegna.addSelectAliasField(this.getNullTimestampValue(), "recenteInMessageBox");
        sqlQueryObjectRiconsegna.addSelectAliasField("SERVIZIO_APPLICATIVO", "nomeSA");
        sqlQueryObjectRiconsegna.setANDLogicOperator(true);
        sqlQueryObjectRiconsegna.addWhereCondition(aliasTableServiziApplicativi + ".ATTESA_ESITO=0");
        sqlQueryObjectRiconsegna.addWhereCondition(aliasTableServiziApplicativi + ".ERRORE_PROCESSAMENTO_COMPACT<>'TimerConsegnaContenutiApplicativi'");
        sqlQueryObjectRiconsegna.addWhereCondition(aliasTableServiziApplicativi + ".TIPO_CONSEGNA='Connettore'");
        sqlQueryObjectRiconsegna.addWhereCondition(aliasTableMessaggi + ".ID_MESSAGGIO=" + aliasTableServiziApplicativi + ".ID_MESSAGGIO");
        sqlQueryObjectRiconsegna.addWhereCondition(aliasTableMessaggi + ".PROPRIETARIO<>'GestoreMessaggi'");
        sqlQueryObjectRiconsegna.addGroupBy("nomeSA");
        ISQLQueryObject sqlQueryObjectMessageBox = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObjectMessageBox.addFromTable("MSG_SERVIZI_APPLICATIVI", aliasTableServiziApplicativi);
        sqlQueryObjectMessageBox.addFromTable("MESSAGGI", aliasTableMessaggi);
        sqlQueryObjectMessageBox.addSelectAliasField(this.getIntZeroValue(), "inRiconsegna");
        sqlQueryObjectMessageBox.addSelectAliasField(this.getIntZeroValue(), "inCoda");
        sqlQueryObjectMessageBox.addSelectAliasField(this.getNullTimestampValue(), "vecchioInRiconsegna");
        sqlQueryObjectMessageBox.addSelectAliasField(this.getNullTimestampValue(), "recenteInRiconsegna");
        sqlQueryObjectMessageBox.addSelectAliasField(this.getNullTimestampValue(), "vecchioInCoda");
        sqlQueryObjectMessageBox.addSelectAliasField(this.getNullTimestampValue(), "recenteInCoda");
        sqlQueryObjectMessageBox.addSelectCountField("inMessageBox");
        sqlQueryObjectMessageBox.addSelectMinField(aliasTableServiziApplicativi, "ORA_REGISTRAZIONE", "vecchioInMessageBox");
        sqlQueryObjectMessageBox.addSelectMaxField(aliasTableServiziApplicativi, "ORA_REGISTRAZIONE", "recenteInMessageBox");
        sqlQueryObjectMessageBox.addSelectAliasField("SERVIZIO_APPLICATIVO", "nomeSA");
        sqlQueryObjectMessageBox.setANDLogicOperator(true);
        sqlQueryObjectMessageBox.addWhereCondition(aliasTableServiziApplicativi + ".TIPO_CONSEGNA='IntegrationManager'");
        sqlQueryObjectMessageBox.addWhereCondition(aliasTableMessaggi + ".ID_MESSAGGIO=" + aliasTableServiziApplicativi + ".ID_MESSAGGIO");
        sqlQueryObjectMessageBox.addWhereCondition(aliasTableMessaggi + ".PROPRIETARIO<>'GestoreMessaggi'");
        sqlQueryObjectMessageBox.addGroupBy("nomeSA");
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addSelectAliasField("CURRENT_TIMESTAMP", "tempoAttuale");
        sqlQueryObject.addSelectMaxField("inRiconsegna", "inRiconsegna");
        sqlQueryObject.addSelectMaxField("inCoda", "inCoda");
        sqlQueryObject.addSelectMinField("vecchioInRiconsegna", "vecchioInRiconsegna");
        sqlQueryObject.addSelectMaxField("recenteInRiconsegna", "recenteInRiconsegna");
        sqlQueryObject.addSelectMinField("vecchioInCoda", "vecchioInCoda");
        sqlQueryObject.addSelectMaxField("recenteInCoda", "recenteInCoda");
        sqlQueryObject.addSelectMaxField("inMessageBox", "inMessageBox");
        sqlQueryObject.addSelectMinField("vecchioInMessageBox", "vecchioInMessageBox");
        sqlQueryObject.addSelectMaxField("recenteInMessageBox", "recenteInMessageBox");
        sqlQueryObject.addSelectAliasField("nomeSA", "nomeSA");
        sqlQueryObject.addGroupBy("nomeSA");
        if (filtro != null) {
            if (filtro.isOrderByInCoda()) {
                sqlQueryObject.addOrderBy("inCoda", false);
            }
            if (filtro.isOrderByInRiconsegna()) {
                sqlQueryObject.addOrderBy("inRiconsegna", false);
            }
            if (filtro.isOrderByInMessageBox()) {
                sqlQueryObject.addOrderBy("inMessageBox", false);
            }
        }
        sqlQueryObject.addOrderBy("nomeSA", true);
        return sqlQueryObject.createSQLUnion(true, new ISQLQueryObject[]{sqlQueryObjectRiconsegna, sqlQueryObjectCoda, sqlQueryObjectMessageBox});
    }

    private String getNullTimestampValue() {
        if (TipiDatabase.POSTGRESQL.equals(this.tipoDatabase)) {
            return "null::timestamp";
        }
        return "null";
    }

    private String getIntZeroValue() {
        return "0";
    }
}

