/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.monitor.utils.serializer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBElement;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.pdd.monitor.Busta;
import org.openspcoop2.pdd.monitor.BustaServizio;
import org.openspcoop2.pdd.monitor.BustaSoggetto;
import org.openspcoop2.pdd.monitor.Dettaglio;
import org.openspcoop2.pdd.monitor.Filtro;
import org.openspcoop2.pdd.monitor.Messaggio;
import org.openspcoop2.pdd.monitor.Openspcoop2;
import org.openspcoop2.pdd.monitor.Proprieta;
import org.openspcoop2.pdd.monitor.ServizioApplicativoConsegna;
import org.openspcoop2.pdd.monitor.StatoPdd;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, BustaSoggetto bustaSoggetto) throws SerializerException {
        this.objToXml(fileName, BustaSoggetto.class, (Object)bustaSoggetto, false);
    }

    public void write(String fileName, BustaSoggetto bustaSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, BustaSoggetto.class, (Object)bustaSoggetto, prettyPrint);
    }

    public void write(File file, BustaSoggetto bustaSoggetto) throws SerializerException {
        this.objToXml(file, BustaSoggetto.class, (Object)bustaSoggetto, false);
    }

    public void write(File file, BustaSoggetto bustaSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, BustaSoggetto.class, (Object)bustaSoggetto, prettyPrint);
    }

    public void write(OutputStream out, BustaSoggetto bustaSoggetto) throws SerializerException {
        this.objToXml(out, BustaSoggetto.class, (Object)bustaSoggetto, false);
    }

    public void write(OutputStream out, BustaSoggetto bustaSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, BustaSoggetto.class, (Object)bustaSoggetto, prettyPrint);
    }

    public byte[] toByteArray(BustaSoggetto bustaSoggetto) throws SerializerException {
        return this.objToXml(BustaSoggetto.class, bustaSoggetto, false).toByteArray();
    }

    public byte[] toByteArray(BustaSoggetto bustaSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(BustaSoggetto.class, bustaSoggetto, prettyPrint).toByteArray();
    }

    public String toString(BustaSoggetto bustaSoggetto) throws SerializerException {
        return this.objToXml(BustaSoggetto.class, bustaSoggetto, false).toString();
    }

    public String toString(BustaSoggetto bustaSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(BustaSoggetto.class, bustaSoggetto, prettyPrint).toString();
    }

    public void write(String fileName, Busta busta) throws SerializerException {
        this.objToXml(fileName, Busta.class, (Object)busta, false);
    }

    public void write(String fileName, Busta busta, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Busta.class, (Object)busta, prettyPrint);
    }

    public void write(File file, Busta busta) throws SerializerException {
        this.objToXml(file, Busta.class, (Object)busta, false);
    }

    public void write(File file, Busta busta, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Busta.class, (Object)busta, prettyPrint);
    }

    public void write(OutputStream out, Busta busta) throws SerializerException {
        this.objToXml(out, Busta.class, (Object)busta, false);
    }

    public void write(OutputStream out, Busta busta, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Busta.class, (Object)busta, prettyPrint);
    }

    public byte[] toByteArray(Busta busta) throws SerializerException {
        return this.objToXml(Busta.class, busta, false).toByteArray();
    }

    public byte[] toByteArray(Busta busta, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Busta.class, busta, prettyPrint).toByteArray();
    }

    public String toString(Busta busta) throws SerializerException {
        return this.objToXml(Busta.class, busta, false).toString();
    }

    public String toString(Busta busta, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Busta.class, busta, prettyPrint).toString();
    }

    public void write(String fileName, BustaServizio bustaServizio) throws SerializerException {
        this.objToXml(fileName, BustaServizio.class, (Object)bustaServizio, false);
    }

    public void write(String fileName, BustaServizio bustaServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, BustaServizio.class, (Object)bustaServizio, prettyPrint);
    }

    public void write(File file, BustaServizio bustaServizio) throws SerializerException {
        this.objToXml(file, BustaServizio.class, (Object)bustaServizio, false);
    }

    public void write(File file, BustaServizio bustaServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, BustaServizio.class, (Object)bustaServizio, prettyPrint);
    }

    public void write(OutputStream out, BustaServizio bustaServizio) throws SerializerException {
        this.objToXml(out, BustaServizio.class, (Object)bustaServizio, false);
    }

    public void write(OutputStream out, BustaServizio bustaServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, BustaServizio.class, (Object)bustaServizio, prettyPrint);
    }

    public byte[] toByteArray(BustaServizio bustaServizio) throws SerializerException {
        return this.objToXml(BustaServizio.class, bustaServizio, false).toByteArray();
    }

    public byte[] toByteArray(BustaServizio bustaServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(BustaServizio.class, bustaServizio, prettyPrint).toByteArray();
    }

    public String toString(BustaServizio bustaServizio) throws SerializerException {
        return this.objToXml(BustaServizio.class, bustaServizio, false).toString();
    }

    public String toString(BustaServizio bustaServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(BustaServizio.class, bustaServizio, prettyPrint).toString();
    }

    public void write(String fileName, StatoPdd statoPdd) throws SerializerException {
        this.objToXml(fileName, StatoPdd.class, (Object)statoPdd, false);
    }

    public void write(String fileName, StatoPdd statoPdd, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, StatoPdd.class, (Object)statoPdd, prettyPrint);
    }

    public void write(File file, StatoPdd statoPdd) throws SerializerException {
        this.objToXml(file, StatoPdd.class, (Object)statoPdd, false);
    }

    public void write(File file, StatoPdd statoPdd, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, StatoPdd.class, (Object)statoPdd, prettyPrint);
    }

    public void write(OutputStream out, StatoPdd statoPdd) throws SerializerException {
        this.objToXml(out, StatoPdd.class, (Object)statoPdd, false);
    }

    public void write(OutputStream out, StatoPdd statoPdd, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, StatoPdd.class, (Object)statoPdd, prettyPrint);
    }

    public byte[] toByteArray(StatoPdd statoPdd) throws SerializerException {
        return this.objToXml(StatoPdd.class, statoPdd, false).toByteArray();
    }

    public byte[] toByteArray(StatoPdd statoPdd, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatoPdd.class, statoPdd, prettyPrint).toByteArray();
    }

    public String toString(StatoPdd statoPdd) throws SerializerException {
        return this.objToXml(StatoPdd.class, statoPdd, false).toString();
    }

    public String toString(StatoPdd statoPdd, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatoPdd.class, statoPdd, prettyPrint).toString();
    }

    public void write(String fileName, Openspcoop2 openspcoop2) throws SerializerException {
        this.objToXml(fileName, Openspcoop2.class, (Object)openspcoop2, false);
    }

    public void write(String fileName, Openspcoop2 openspcoop2, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Openspcoop2.class, (Object)openspcoop2, prettyPrint);
    }

    public void write(File file, Openspcoop2 openspcoop2) throws SerializerException {
        this.objToXml(file, Openspcoop2.class, (Object)openspcoop2, false);
    }

    public void write(File file, Openspcoop2 openspcoop2, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Openspcoop2.class, (Object)openspcoop2, prettyPrint);
    }

    public void write(OutputStream out, Openspcoop2 openspcoop2) throws SerializerException {
        this.objToXml(out, Openspcoop2.class, (Object)openspcoop2, false);
    }

    public void write(OutputStream out, Openspcoop2 openspcoop2, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Openspcoop2.class, (Object)openspcoop2, prettyPrint);
    }

    public byte[] toByteArray(Openspcoop2 openspcoop2) throws SerializerException {
        return this.objToXml(Openspcoop2.class, openspcoop2, false).toByteArray();
    }

    public byte[] toByteArray(Openspcoop2 openspcoop2, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Openspcoop2.class, openspcoop2, prettyPrint).toByteArray();
    }

    public String toString(Openspcoop2 openspcoop2) throws SerializerException {
        return this.objToXml(Openspcoop2.class, openspcoop2, false).toString();
    }

    public String toString(Openspcoop2 openspcoop2, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Openspcoop2.class, openspcoop2, prettyPrint).toString();
    }

    public void write(String fileName, Messaggio messaggio) throws SerializerException {
        this.objToXml(fileName, Messaggio.class, (Object)messaggio, false);
    }

    public void write(String fileName, Messaggio messaggio, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Messaggio.class, (Object)messaggio, prettyPrint);
    }

    public void write(File file, Messaggio messaggio) throws SerializerException {
        this.objToXml(file, Messaggio.class, (Object)messaggio, false);
    }

    public void write(File file, Messaggio messaggio, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Messaggio.class, (Object)messaggio, prettyPrint);
    }

    public void write(OutputStream out, Messaggio messaggio) throws SerializerException {
        this.objToXml(out, Messaggio.class, (Object)messaggio, false);
    }

    public void write(OutputStream out, Messaggio messaggio, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Messaggio.class, (Object)messaggio, prettyPrint);
    }

    public byte[] toByteArray(Messaggio messaggio) throws SerializerException {
        return this.objToXml(Messaggio.class, messaggio, false).toByteArray();
    }

    public byte[] toByteArray(Messaggio messaggio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Messaggio.class, messaggio, prettyPrint).toByteArray();
    }

    public String toString(Messaggio messaggio) throws SerializerException {
        return this.objToXml(Messaggio.class, messaggio, false).toString();
    }

    public String toString(Messaggio messaggio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Messaggio.class, messaggio, prettyPrint).toString();
    }

    public void write(String fileName, ServizioApplicativoConsegna servizioApplicativoConsegna) throws SerializerException {
        this.objToXml(fileName, ServizioApplicativoConsegna.class, (Object)servizioApplicativoConsegna, false);
    }

    public void write(String fileName, ServizioApplicativoConsegna servizioApplicativoConsegna, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ServizioApplicativoConsegna.class, (Object)servizioApplicativoConsegna, prettyPrint);
    }

    public void write(File file, ServizioApplicativoConsegna servizioApplicativoConsegna) throws SerializerException {
        this.objToXml(file, ServizioApplicativoConsegna.class, (Object)servizioApplicativoConsegna, false);
    }

    public void write(File file, ServizioApplicativoConsegna servizioApplicativoConsegna, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ServizioApplicativoConsegna.class, (Object)servizioApplicativoConsegna, prettyPrint);
    }

    public void write(OutputStream out, ServizioApplicativoConsegna servizioApplicativoConsegna) throws SerializerException {
        this.objToXml(out, ServizioApplicativoConsegna.class, (Object)servizioApplicativoConsegna, false);
    }

    public void write(OutputStream out, ServizioApplicativoConsegna servizioApplicativoConsegna, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ServizioApplicativoConsegna.class, (Object)servizioApplicativoConsegna, prettyPrint);
    }

    public byte[] toByteArray(ServizioApplicativoConsegna servizioApplicativoConsegna) throws SerializerException {
        return this.objToXml(ServizioApplicativoConsegna.class, servizioApplicativoConsegna, false).toByteArray();
    }

    public byte[] toByteArray(ServizioApplicativoConsegna servizioApplicativoConsegna, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ServizioApplicativoConsegna.class, servizioApplicativoConsegna, prettyPrint).toByteArray();
    }

    public String toString(ServizioApplicativoConsegna servizioApplicativoConsegna) throws SerializerException {
        return this.objToXml(ServizioApplicativoConsegna.class, servizioApplicativoConsegna, false).toString();
    }

    public String toString(ServizioApplicativoConsegna servizioApplicativoConsegna, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ServizioApplicativoConsegna.class, servizioApplicativoConsegna, prettyPrint).toString();
    }

    public void write(String fileName, Dettaglio dettaglio) throws SerializerException {
        this.objToXml(fileName, Dettaglio.class, (Object)dettaglio, false);
    }

    public void write(String fileName, Dettaglio dettaglio, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Dettaglio.class, (Object)dettaglio, prettyPrint);
    }

    public void write(File file, Dettaglio dettaglio) throws SerializerException {
        this.objToXml(file, Dettaglio.class, (Object)dettaglio, false);
    }

    public void write(File file, Dettaglio dettaglio, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Dettaglio.class, (Object)dettaglio, prettyPrint);
    }

    public void write(OutputStream out, Dettaglio dettaglio) throws SerializerException {
        this.objToXml(out, Dettaglio.class, (Object)dettaglio, false);
    }

    public void write(OutputStream out, Dettaglio dettaglio, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Dettaglio.class, (Object)dettaglio, prettyPrint);
    }

    public byte[] toByteArray(Dettaglio dettaglio) throws SerializerException {
        return this.objToXml(Dettaglio.class, dettaglio, false).toByteArray();
    }

    public byte[] toByteArray(Dettaglio dettaglio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Dettaglio.class, dettaglio, prettyPrint).toByteArray();
    }

    public String toString(Dettaglio dettaglio) throws SerializerException {
        return this.objToXml(Dettaglio.class, dettaglio, false).toString();
    }

    public String toString(Dettaglio dettaglio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Dettaglio.class, dettaglio, prettyPrint).toString();
    }

    public void write(String fileName, Filtro filtro) throws SerializerException {
        this.objToXml(fileName, Filtro.class, (Object)filtro, false);
    }

    public void write(String fileName, Filtro filtro, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Filtro.class, (Object)filtro, prettyPrint);
    }

    public void write(File file, Filtro filtro) throws SerializerException {
        this.objToXml(file, Filtro.class, (Object)filtro, false);
    }

    public void write(File file, Filtro filtro, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Filtro.class, (Object)filtro, prettyPrint);
    }

    public void write(OutputStream out, Filtro filtro) throws SerializerException {
        this.objToXml(out, Filtro.class, (Object)filtro, false);
    }

    public void write(OutputStream out, Filtro filtro, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Filtro.class, (Object)filtro, prettyPrint);
    }

    public byte[] toByteArray(Filtro filtro) throws SerializerException {
        return this.objToXml(Filtro.class, filtro, false).toByteArray();
    }

    public byte[] toByteArray(Filtro filtro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Filtro.class, filtro, prettyPrint).toByteArray();
    }

    public String toString(Filtro filtro) throws SerializerException {
        return this.objToXml(Filtro.class, filtro, false).toString();
    }

    public String toString(Filtro filtro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Filtro.class, filtro, prettyPrint).toString();
    }

    public void write(String fileName, Proprieta proprieta) throws SerializerException {
        this.objToXml(fileName, Proprieta.class, (Object)proprieta, false);
    }

    public void write(String fileName, Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Proprieta.class, (Object)proprieta, prettyPrint);
    }

    public void write(File file, Proprieta proprieta) throws SerializerException {
        this.objToXml(file, Proprieta.class, (Object)proprieta, false);
    }

    public void write(File file, Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Proprieta.class, (Object)proprieta, prettyPrint);
    }

    public void write(OutputStream out, Proprieta proprieta) throws SerializerException {
        this.objToXml(out, Proprieta.class, (Object)proprieta, false);
    }

    public void write(OutputStream out, Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Proprieta.class, (Object)proprieta, prettyPrint);
    }

    public byte[] toByteArray(Proprieta proprieta) throws SerializerException {
        return this.objToXml(Proprieta.class, proprieta, false).toByteArray();
    }

    public byte[] toByteArray(Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Proprieta.class, proprieta, prettyPrint).toByteArray();
    }

    public String toString(Proprieta proprieta) throws SerializerException {
        return this.objToXml(Proprieta.class, proprieta, false).toString();
    }

    public String toString(Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Proprieta.class, proprieta, prettyPrint).toString();
    }
}

