/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.connector.CheckStatoPdDHealthCheckStats;
import org.openspcoop2.pdd.services.connector.CheckStatoPdDHealthCheckStatsUtils;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerThresholdThread;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpServletCredential;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class CheckStatoPdD
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    private static void sendError(HttpServletResponse res, Logger log, String msg, int code) {
        CheckStatoPdD.sendError(res, log, msg, code, msg, null);
    }

    private static void sendError(HttpServletResponse res, Logger log, String msg, int code, Throwable e) {
        CheckStatoPdD.sendError(res, log, msg, code, msg, e);
    }

    private static void sendError(HttpServletResponse res, Logger log, String msg, int code, String logMsg) {
        CheckStatoPdD.sendError(res, log, msg, code, logMsg, null);
    }

    private static void sendError(HttpServletResponse res, Logger log, String msg, int code, String logMsg, Throwable e) {
        String prefix = "[GovWayCheck] ";
        String msgLog = prefix + logMsg;
        if (e != null) {
            log.error(msgLog, e);
        } else {
            log.error(msgLog);
        }
        res.setStatus(code);
        res.setContentType("text/plain");
        try {
            res.getOutputStream().write(msg.getBytes());
        }
        catch (Exception t) {
            log.error("[CheckStato] SendError failed: " + t.getMessage(), (Throwable)t);
        }
    }

    private String getPrefixLetturaRisorsa(String resourceName) {
        return "Lettura risorsa [" + resourceName + "] ";
    }

    private String getMsgRisorsaNonAutorizzata(String resourceName) {
        return this.getPrefixLetturaRisorsa(resourceName) + "non autorizzata";
    }

    private String getMsgDellaRisorsaNonRiuscita(String resourceName) {
        return "della risorsa [" + resourceName + "] non riuscita";
    }

    public static void serializeNotInitializedResponse(HttpServletResponse res, Logger log) {
        String msg = "API Gateway GovWay non inzializzato";
        CheckStatoPdD.sendError(res, log, msg, 503);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String msg;
        List values;
        StringBuilder sb;
        HttpResponse response;
        HttpRequest request;
        String endpoint;
        Object msg2;
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (log == null) {
            log = LoggerWrapperFactory.getLogger(CheckStatoPdD.class);
        }
        if (!OpenSPCoop2Startup.initialize) {
            CheckStatoPdD.serializeNotInitializedResponse(res, log);
            return;
        }
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        boolean richiestaRisorsaJmx = false;
        String resourceName = req.getParameter("resourceName");
        if (resourceName != null && !"".equals(resourceName)) {
            boolean checkReadEnabled = false;
            if (properties != null && properties.isCheckReadJMXResourcesEnabled()) {
                checkReadEnabled = true;
            }
            if (!checkReadEnabled) {
                String msg3 = "Servizio non abilitato";
                CheckStatoPdD.sendError(res, log, msg3, 500);
                return;
            }
            String username = properties.getCheckReadJMXResourcesUsername();
            String password = properties.getCheckReadJMXResourcesPassword();
            if (username != null && password != null) {
                HttpServletCredential identity = new HttpServletCredential(req, log);
                if (!username.equals(identity.getUsername())) {
                    String msg4 = this.getMsgRisorsaNonAutorizzata(resourceName);
                    String logMsg = msg4 + ". Richiesta effettuata da username [" + identity.getUsername() + "] sconosciuto";
                    CheckStatoPdD.sendError(res, log, msg4, 500, logMsg);
                    return;
                }
                if (!password.equals(identity.getPassword())) {
                    String msg5 = this.getMsgRisorsaNonAutorizzata(resourceName);
                    String logMsg = msg5 + ". Richiesta effettuata da username [" + identity.getUsername() + "] (password errata)";
                    CheckStatoPdD.sendError(res, log, msg5, 500, logMsg);
                    return;
                }
            }
            String attributeName = req.getParameter("attributeName");
            String attributeValue = req.getParameter("attributeValue");
            String attributeBooleanValue = req.getParameter("attributeBooleanValue");
            String methodName = req.getParameter("methodName");
            if (attributeName != null) {
                if (attributeValue != null || attributeBooleanValue != null) {
                    try {
                        Object v = attributeValue;
                        if (attributeBooleanValue != null) {
                            v = Boolean.parseBoolean(attributeBooleanValue);
                        }
                        OpenSPCoop2Startup.gestoreRisorseJMX_staticInstance.setAttribute(resourceName, attributeName, v);
                        richiestaRisorsaJmx = true;
                    }
                    catch (Exception e) {
                        String msg6 = "Aggiornamento attributo [" + attributeName + "] " + this.getMsgDellaRisorsaNonRiuscita(resourceName) + " (valore:" + attributeValue + "): " + e.getMessage();
                        CheckStatoPdD.sendError(res, log, msg6, 500, e);
                        return;
                    }
                } else {
                    try {
                        Object value = OpenSPCoop2Startup.gestoreRisorseJMX_staticInstance.getAttribute(resourceName, attributeName);
                        res.setContentType("text/plain");
                        res.getOutputStream().write(value.toString().getBytes());
                        richiestaRisorsaJmx = true;
                    }
                    catch (Exception e) {
                        String msg7 = "Lettura attributo [" + attributeName + "] " + this.getMsgDellaRisorsaNonRiuscita(resourceName) + ": " + e.getMessage();
                        CheckStatoPdD.sendError(res, log, msg7, 500, e);
                        return;
                    }
                }
            } else {
                if (attributeValue != null) {
                    String msg8 = this.getPrefixLetturaRisorsa(resourceName) + "non effettuata, fornito un valore di attributo senza aver indicato il nome";
                    CheckStatoPdD.sendError(res, log, msg8, 500);
                    return;
                }
                if (methodName != null) {
                    Object[] params = null;
                    String[] signatures = null;
                    try {
                        ArrayList<Object> paramsL = new ArrayList<Object>();
                        ArrayList<String> signaturesL = new ArrayList<String>();
                        this.addParameter(paramsL, signaturesL, req);
                        if (!paramsL.isEmpty() && !signaturesL.isEmpty()) {
                            params = paramsL.toArray(new Object[1]);
                            signatures = signaturesL.toArray(new String[1]);
                        }
                    }
                    catch (Exception e) {
                        String msg9 = "Invocazione metodo [" + methodName + "] " + this.getMsgDellaRisorsaNonRiuscita(resourceName) + ": " + e.getMessage();
                        CheckStatoPdD.sendError(res, log, msg9, 500, e);
                        return;
                    }
                    try {
                        Object value = OpenSPCoop2Startup.gestoreRisorseJMX_staticInstance.invoke(resourceName, methodName, params, signatures);
                        res.setContentType("text/plain");
                        res.getOutputStream().write(value.toString().getBytes());
                        richiestaRisorsaJmx = true;
                    }
                    catch (Exception e) {
                        String msg10 = "Invocazione metodo [" + methodName + "] " + this.getMsgDellaRisorsaNonRiuscita(resourceName) + ": " + e.getMessage();
                        CheckStatoPdD.sendError(res, log, msg10, 500, e);
                        return;
                    }
                }
                String msg11 = this.getPrefixLetturaRisorsa(resourceName) + "non effettuata, nessun attributo o metodo richiesto";
                CheckStatoPdD.sendError(res, log, msg11, 500);
                return;
            }
        }
        if (richiestaRisorsaJmx) {
            return;
        }
        CheckStatoPdDHealthCheckStats check = this.readHealthCheckStats(req, properties);
        if (check != null) {
            try {
                CheckStatoPdDHealthCheckStatsUtils.verificaInformazioniStatistiche(log, properties, check);
                return;
            }
            catch (Exception t) {
                msg2 = "Statistics HealthCheck failed\n" + t.getMessage();
                CheckStatoPdD.sendError(res, log, (String)msg2, 500, t);
                return;
            }
        }
        boolean checkEnabled = false;
        if (properties != null && properties.isCheckEnabled()) {
            checkEnabled = true;
        }
        if (!checkEnabled) {
            msg2 = "Servizio non abilitato";
            CheckStatoPdD.sendError(res, log, (String)msg2, 500);
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            CheckStatoPdD.serializeNotInitializedResponse(res, log);
            return;
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            msg2 = "Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage();
            CheckStatoPdD.sendError(res, log, (String)msg2, 500, TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            return;
        }
        if (!TimerThresholdThread.freeSpace) {
            msg2 = "Non sono disponibili abbastanza risorse per la gestione della richiesta";
            CheckStatoPdD.sendError(res, log, (String)msg2, 500);
            return;
        }
        if (!Tracciamento.tracciamentoDisponibile) {
            msg2 = "Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage();
            CheckStatoPdD.sendError(res, log, (String)msg2, 500, Tracciamento.motivoMalfunzionamentoTracciamento);
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            msg2 = "Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage();
            CheckStatoPdD.sendError(res, log, (String)msg2, 500, MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        if (!Dump.isSistemaDumpDisponibile()) {
            msg2 = "Sistema di dump dei contenuti applicativi non disponibile: " + Dump.getMotivoMalfunzionamentoDump().getMessage();
            CheckStatoPdD.sendError(res, log, (String)msg2, 500, Dump.getMotivoMalfunzionamentoDump());
            return;
        }
        if (properties.isCheckHealthCheckStatsEnabled()) {
            try {
                CheckStatoPdDHealthCheckStatsUtils.verificaInformazioniStatistiche(log, properties);
            }
            catch (Exception t) {
                String msg12 = "Statistics HealthCheck failed\n" + t.getMessage();
                CheckStatoPdD.sendError(res, log, msg12, 500, t);
                return;
            }
        }
        if (properties.isCheckHealthCheckApiRestEnabled()) {
            endpoint = properties.getCheckHealthCheckApiRestEndpoint();
            request = new HttpRequest();
            if (endpoint.toLowerCase().startsWith("https")) {
                request.setHostnameVerifier(false);
                request.setTrustAllCerts(true);
            }
            request.setMethod(HttpRequestMethod.GET);
            request.setUrl(endpoint);
            try {
                response = HttpUtilities.httpInvoke((HttpRequest)request);
                if (response.getResultHTTPOperation() != 200) {
                    sb = new StringBuilder();
                    if (response.getHeadersValues() != null && !response.getHeadersValues().isEmpty()) {
                        for (String hdrName : response.getHeadersValues().keySet()) {
                            if ("ReturnCode".equals(hdrName) || (values = response.getHeaderValues(hdrName)) == null || values.isEmpty()) continue;
                            for (String v : values) {
                                sb.append("\n").append(hdrName).append(":").append(v);
                            }
                        }
                    } else if (response.getContentType() != null) {
                        sb.append("\n").append("Content-Type").append(":").append(response.getContentType());
                    }
                    if (response.getContent() != null) {
                        sb.append("\n\n").append(new String(response.getContent()));
                    }
                    throw new CoreException("HTTP Result:" + response.getResultHTTPOperation() + sb.toString());
                }
            }
            catch (Exception t) {
                msg = "API REST HealthCheck failed (" + endpoint + ")\n" + t.getMessage();
                CheckStatoPdD.sendError(res, log, msg, 500, t);
                return;
            }
        }
        if (properties.isCheckHealthCheckApiSoapEnabled()) {
            endpoint = properties.getCheckHealthCheckApiSoapEndpoint();
            request = new HttpRequest();
            if (endpoint.toLowerCase().startsWith("https")) {
                request.setHostnameVerifier(false);
                request.setTrustAllCerts(true);
            }
            request.setContentType("text/xml");
            request.addHeader("SOAPAction", "echo");
            request.setMethod(HttpRequestMethod.POST);
            request.setUrl(endpoint);
            request.setContent("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"><soapenv:Body><ns1:getStatus xmlns:ns1=\"https://govway.org/apiStatus\"/></soapenv:Body></soapenv:Envelope>".getBytes());
            try {
                response = HttpUtilities.httpInvoke((HttpRequest)request);
                if (response.getResultHTTPOperation() != 200) {
                    sb = new StringBuilder();
                    if (response.getHeadersValues() != null && !response.getHeadersValues().isEmpty()) {
                        for (String hdrName : response.getHeadersValues().keySet()) {
                            if ("ReturnCode".equals(hdrName) || (values = response.getHeaderValues(hdrName)) == null || values.isEmpty()) continue;
                            for (String v : values) {
                                sb.append("\n").append(hdrName).append(":").append(v);
                            }
                        }
                    } else if (response.getContentType() != null) {
                        sb.append("\n").append("Content-Type").append(":").append(response.getContentType());
                    }
                    if (response.getContent() != null) {
                        sb.append("\n\n").append(new String(response.getContent()));
                    }
                    throw new ServletException("HTTP Result:" + response.getResultHTTPOperation() + sb.toString());
                }
            }
            catch (Exception t) {
                msg = "API SOAP HealthCheck failed (" + endpoint + ")\n" + t.getMessage();
                CheckStatoPdD.sendError(res, log, msg, 500, t);
            }
        }
    }

    private BooleanNullable readBooleanParam(HttpServletRequest req, String paramName) {
        String p = req.getParameter(paramName);
        if ("true".equalsIgnoreCase(p)) {
            return BooleanNullable.TRUE();
        }
        if ("false".equalsIgnoreCase(p)) {
            return BooleanNullable.FALSE();
        }
        return BooleanNullable.NULL();
    }

    private Integer readIntegerParam(HttpServletRequest req, String paramName) {
        String p = req.getParameter(paramName);
        if (p != null && StringUtils.isNotEmpty((String)p)) {
            return Integer.valueOf(p);
        }
        return null;
    }

    private CheckStatoPdDHealthCheckStats readHealthCheckStats(HttpServletRequest req, OpenSPCoop2Properties properties) {
        Integer p;
        BooleanNullable healthCheckStats = this.readBooleanParam(req, "executeHealthCheckStats");
        BooleanNullable hourlyHealthCheckStats = this.readBooleanParam(req, "executeHourlyHealthCheckStats");
        BooleanNullable dailyHealthCheckStats = this.readBooleanParam(req, "executeDailyHealthCheckStats");
        BooleanNullable weeklyHealthCheckStats = this.readBooleanParam(req, "executeWeeklyHealthCheckStats");
        BooleanNullable monthlyHealthCheckStats = this.readBooleanParam(req, "executeMonthlyHealthCheckStats");
        CheckStatoPdDHealthCheckStats check = null;
        if (hourlyHealthCheckStats != null && hourlyHealthCheckStats.getValue() != null) {
            check = new CheckStatoPdDHealthCheckStats();
            check.setVerificaStatisticaOraria(hourlyHealthCheckStats.getValue());
            p = this.readIntegerParam(req, "hourlyHealthCheckStatsThreshold");
            if (p != null && p >= 0) {
                check.setVerificaStatisticaOrariaSoglia(p);
            } else {
                check.setVerificaStatisticaOrariaSoglia(properties.getCheckHealthCheckStatsHourlyThreshold());
            }
        }
        if (dailyHealthCheckStats != null && dailyHealthCheckStats.getValue() != null) {
            if (check == null) {
                check = new CheckStatoPdDHealthCheckStats();
            }
            check.setVerificaStatisticaGiornaliera(dailyHealthCheckStats.getValue());
            p = this.readIntegerParam(req, "dailyHealthCheckStatsThreshold");
            if (p != null && p >= 0) {
                check.setVerificaStatisticaGiornalieraSoglia(p);
            } else {
                check.setVerificaStatisticaGiornalieraSoglia(properties.getCheckHealthCheckStatsDailyThreshold());
            }
        }
        if (weeklyHealthCheckStats != null && weeklyHealthCheckStats.getValue() != null) {
            if (check == null) {
                check = new CheckStatoPdDHealthCheckStats();
            }
            check.setVerificaStatisticaSettimanale(weeklyHealthCheckStats.getValue());
            p = this.readIntegerParam(req, "weeklyHealthCheckStatsThreshold");
            if (p != null && p >= 0) {
                check.setVerificaStatisticaSettimanaleSoglia(p);
            } else {
                check.setVerificaStatisticaSettimanaleSoglia(properties.getCheckHealthCheckStatsWeeklyThreshold());
            }
        }
        if (monthlyHealthCheckStats != null && monthlyHealthCheckStats.getValue() != null) {
            if (check == null) {
                check = new CheckStatoPdDHealthCheckStats();
            }
            check.setVerificaStatisticaMensile(monthlyHealthCheckStats.getValue());
            p = this.readIntegerParam(req, "monthlyHealthCheckStatsThreshold");
            if (p != null && p >= 0) {
                check.setVerificaStatisticaMensileSoglia(p);
            } else {
                check.setVerificaStatisticaMensileSoglia(properties.getCheckHealthCheckStatsMonthlyThreshold());
            }
        }
        if (check == null && healthCheckStats != null && healthCheckStats.getValue() != null && healthCheckStats.getValue().booleanValue()) {
            check = CheckStatoPdDHealthCheckStats.readProprietaVerificaInformazioniStatistiche(properties);
        }
        return check;
    }

    private void addParameter(List<Object> params, List<String> signatures, HttpServletRequest req) throws CoreException {
        boolean add = this.addParameter(params, signatures, req, "paramValue", "paramIntegerValue", "paramLongValue", "paramBooleanValue");
        if (!add) {
            return;
        }
        add = this.addParameter(params, signatures, req, "paramValue2", "paramIntegerValue2", "paramLongValue2", "paramBooleanValue2");
        if (!add) {
            return;
        }
        add = this.addParameter(params, signatures, req, "paramValue3", "paramIntegerValue3", "paramLongValue3", "paramBooleanValue3");
        if (!add) {
            return;
        }
        this.addParameter(params, signatures, req, "paramValue4", "paramIntegerValue4", "paramLongValue4", "paramBooleanValue4");
    }

    private boolean addParameter(List<Object> params, List<String> signatures, HttpServletRequest req, String stringNameParameter, String intNameParameter, String longNameParameter, String booleanNameParameter) throws CoreException {
        String paramBooleanValue;
        boolean paramBooleanDefined;
        String paramLongValue;
        boolean paramLongDefined;
        String paramIntValue;
        boolean paramIntDefined;
        boolean paramStringDefined;
        int count = 0;
        ArrayList<String> pFound = new ArrayList<String>();
        String paramStringValue = req.getParameter(stringNameParameter);
        boolean bl = paramStringDefined = paramStringValue != null && !"".equals(paramStringValue);
        if (paramStringDefined) {
            ++count;
            pFound.add(stringNameParameter);
        }
        boolean bl2 = paramIntDefined = (paramIntValue = req.getParameter(intNameParameter)) != null && !"".equals(paramIntValue);
        if (paramIntDefined) {
            ++count;
            pFound.add(intNameParameter);
        }
        boolean bl3 = paramLongDefined = (paramLongValue = req.getParameter(longNameParameter)) != null && !"".equals(paramLongValue);
        if (paramLongDefined) {
            ++count;
            pFound.add(longNameParameter);
        }
        boolean bl4 = paramBooleanDefined = (paramBooleanValue = req.getParameter(booleanNameParameter)) != null && !"".equals(paramBooleanValue);
        if (paramBooleanDefined) {
            ++count;
            pFound.add(booleanNameParameter);
        }
        if (count == 0) {
            return false;
        }
        if (count > 1) {
            throw new CoreException("\u00c8 stato fornito pi\u00f9 di un tipo di parametro per la stessa posizione: " + pFound);
        }
        if (paramStringDefined) {
            params.add(paramStringValue);
            signatures.add(String.class.getName());
        } else if (paramIntDefined) {
            params.add(Integer.valueOf(paramIntValue));
            signatures.add(Integer.class.getName());
        } else if (paramLongDefined) {
            params.add(Long.valueOf(paramLongValue));
            signatures.add(Long.class.getName());
        } else {
            params.add(Boolean.valueOf(paramBooleanValue));
            signatures.add(Boolean.class.getName());
        }
        return true;
    }
}

