/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.internet.ContentType;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.openspcoop2.pdd.services.connector.FormUrlEncodedServletInputStream;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.WrappedHttpServletRequest;
import org.springframework.web.util.UriUtils;

public class FormUrlEncodedHttpServletRequest
extends WrappedHttpServletRequest {
    private static final String CONTENT_TYPE_FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    private byte[] content;
    private Map<String, List<String>> properties;

    public static boolean isFormUrlEncodedRequest(HttpServletRequest httpServletRequest) {
        String ct = httpServletRequest.getContentType();
        try {
            String baseType = FormUrlEncodedHttpServletRequest.readBaseType(ct);
            if (CONTENT_TYPE_FORM_URL_ENCODED.equalsIgnoreCase(baseType)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static HttpServletRequest convert(HttpServletRequest httpServletRequest) {
        String ct = httpServletRequest.getContentType();
        try {
            String baseType = FormUrlEncodedHttpServletRequest.readBaseType(ct);
            if (CONTENT_TYPE_FORM_URL_ENCODED.equalsIgnoreCase(baseType)) {
                return new FormUrlEncodedHttpServletRequest(httpServletRequest);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return httpServletRequest;
    }

    private static String readBaseType(String ct) throws UtilsException {
        if (ct == null || "".equals(ct)) {
            throw new UtilsException("Content-Type not defined");
        }
        String baseType = null;
        try {
            ContentType ctObject = new ContentType(ct);
            baseType = ctObject.getBaseType();
        }
        catch (Exception e) {
            throw new UtilsException("Content-Type [" + ct + "] (parsing error): " + e.getMessage(), (Throwable)e);
        }
        return baseType;
    }

    public FormUrlEncodedHttpServletRequest(HttpServletRequest httpServletRequest) throws UtilsException {
        super(httpServletRequest);
        String ct = httpServletRequest.getContentType();
        String baseType = null;
        try {
            baseType = FormUrlEncodedHttpServletRequest.readBaseType(ct);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!CONTENT_TYPE_FORM_URL_ENCODED.equalsIgnoreCase(baseType)) {
            throw new UtilsException("Content-Type [" + ct + "] non supportato");
        }
        try {
            ServletInputStream is = httpServletRequest.getInputStream();
            if (is != null) {
                this.content = Utilities.getAsByteArray((InputStream)is);
            }
        }
        catch (Exception e) {
            throw new UtilsException("Content-Type [" + ct + "] read stream error: " + e.getMessage(), (Throwable)e);
        }
        Enumeration en = httpServletRequest.getParameterNames();
        this.properties = new HashMap<String, List<String>>();
        while (en.hasMoreElements()) {
            String nomeProperty = (String)en.nextElement();
            String[] s = httpServletRequest.getParameterValues(nomeProperty);
            ArrayList<String> values = new ArrayList<String>();
            if (s != null && s.length > 0) {
                for (int i = 0; i < s.length; ++i) {
                    String value = s[i];
                    values.add(value);
                }
            } else {
                values.add(httpServletRequest.getParameter(nomeProperty));
            }
            this.properties.put(nomeProperty, values);
        }
        if (this.properties.isEmpty() && this.content != null && this.content.length > 0) {
            String contentUrlEncoding = new String(this.content);
            if (contentUrlEncoding.contains("&")) {
                String[] tmp = contentUrlEncoding.split("&");
                if (tmp != null && tmp.length > 0) {
                    for (String pUrlEncoding : tmp) {
                        String contentUrlDecoding = UriUtils.decode((String)pUrlEncoding, (String)Charset.UTF_8.getValue());
                        this.addParameter(contentUrlDecoding);
                    }
                }
            } else {
                String contentUrlDecoding = UriUtils.decode((String)contentUrlEncoding, (String)Charset.UTF_8.getValue());
                this.addParameter(contentUrlDecoding);
            }
        }
    }

    private void addParameter(String line) {
        int indexOf;
        if (line != null && line.contains("=") && (indexOf = line.indexOf("=")) > 0 && indexOf < line.length() - 1) {
            String key = line.substring(0, indexOf);
            String value = line.substring(indexOf + 1);
            TransportUtils.addParameter(this.properties, (String)key, (String)value);
        }
    }

    public int getContentLength() {
        if (this.content != null) {
            return this.content.length;
        }
        return 0;
    }

    public String getContentType() {
        return this.httpServletRequest.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.content != null) {
            try {
                return new FormUrlEncodedServletInputStream(new ByteArrayInputStream(this.content));
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return null;
    }

    public BufferedReader getReader() throws IOException {
        if (this.content != null) {
            return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.content), this.httpServletRequest.getCharacterEncoding()));
        }
        return null;
    }

    public String getParameter(String key) {
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return new HashMap<String, String[]>();
    }

    public Enumeration<String> getParameterNames() {
        return Collections.emptyEnumeration();
    }

    public String[] getParameterValues(String arg0) {
        return null;
    }

    @Deprecated
    public String getFormUrlEncodedParameter(String key) {
        return this.getFormUrlEncodedParameter_compactMultipleValues(key);
    }

    public String getFormUrlEncodedParameter_compactMultipleValues(String key) {
        return TransportUtils.getObjectAsString(this.properties, (String)key);
    }

    public List<String> getFormUrlEncodedParameterValues(String key) {
        return (List)TransportUtils.getRawObject(this.properties, (String)key);
    }

    public String getFormUrlEncodedParameterFirstValue(String key) {
        List l = (List)TransportUtils.getRawObject(this.properties, (String)key);
        if (l != null && !l.isEmpty()) {
            return (String)l.get(0);
        }
        return null;
    }

    public Iterator<String> getFormUrlEncodedParameterNames() {
        return this.properties.keySet().iterator();
    }

    public Map<String, List<String>> getFormUrlEncodedParametersValues() {
        return this.properties;
    }
}

