/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherUtils;
import org.openspcoop2.pdd.services.connector.ConnectorUtils;
import org.openspcoop2.pdd.services.connector.messages.HttpServletConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.HttpServletConnectorOutMessage;
import org.openspcoop2.pdd.services.error.RicezioneContenutiApplicativiInternalErrorGenerator;
import org.openspcoop2.pdd.services.service.RicezioneContenutiApplicativiHTTPtoSOAPService;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public class RicezioneContenutiApplicativiHTTPtoSOAPConnector {
    public static final IDService ID_SERVICE = IDService.PORTA_DELEGATA_XML_TO_SOAP;
    public static final String ID_MODULO = ID_SERVICE.getValue();

    public void doEngine(RequestInfo requestInfo, HttpServletRequest req, HttpServletResponse res, HttpRequestMethod method) throws ServletException, IOException {
        Date dataAccettazioneRichiesta = DateManager.getDate();
        if (!HttpRequestMethod.POST.equals((Object)method)) {
            ConnectorDispatcherUtils.doMethodNotSupported(req, res, method, ID_SERVICE);
            return;
        }
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore = null;
        try {
            generatoreErrore = new RicezioneContenutiApplicativiInternalErrorGenerator(logCore, ID_MODULO, requestInfo);
            RicezioneContenutiApplicativiHTTPtoSOAPService.forceXmlResponse(generatoreErrore);
        }
        catch (Exception e) {
            String msg = "Inizializzazione Generatore Errore fallita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
            logCore.error(msg, (Throwable)e);
            ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, (Throwable)e, res, logCore);
            return;
        }
        RicezioneContenutiApplicativiHTTPtoSOAPService ricezioneContenutiApplicativi = new RicezioneContenutiApplicativiHTTPtoSOAPService(generatoreErrore);
        HttpServletConnectorInMessage httpIn = null;
        try {
            httpIn = new HttpServletConnectorInMessage(requestInfo, req, ID_SERVICE, ID_MODULO);
        }
        catch (Exception e) {
            this.doError("HttpServletConnectorInMessage init error", e);
        }
        IProtocolFactory<?> protocolFactory = null;
        try {
            protocolFactory = httpIn.getProtocolFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HttpServletConnectorOutMessage httpOut = null;
        try {
            httpOut = new HttpServletConnectorOutMessage(requestInfo, protocolFactory, res, ID_SERVICE, ID_MODULO);
        }
        catch (Exception e) {
            this.doError("HttpServletConnectorOutMessage init error", e);
        }
        try {
            ricezioneContenutiApplicativi.process(httpIn, httpOut, dataAccettazioneRichiesta);
        }
        catch (Exception e) {
            this.doError("RicezioneContenutiApplicativiXMLtoSOAP.process error", e);
        }
    }

    private void doError(String msg, Exception e) throws ServletException {
        String msgError = msg + ": " + e.getMessage();
        ConnectorUtils.getErrorLog().error(msgError, (Throwable)e);
        throw new ServletException(e.getMessage(), (Throwable)e);
    }
}

