/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector.messages;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageProperties;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.messages.ConnectorOutMessage;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.transport.http.RFC2047Encoding;
import org.openspcoop2.utils.transport.http.RFC2047Utilities;

public class HttpServletConnectorOutMessage
implements ConnectorOutMessage {
    protected HttpServletResponse res;
    protected OutputStream outNullable;
    protected IProtocolFactory<?> protocolFactory;
    protected RequestInfo requestInfo;
    protected String idModulo;
    protected IDService idModuloAsIDService;
    protected OpenSPCoop2Properties openspcoopProperties;
    private int status = -1;

    public HttpServletConnectorOutMessage(RequestInfo requestInfo, IProtocolFactory<?> protocolFactory, HttpServletResponse res, IDService idModuloAsIDService, String idModulo) throws ConnectorException {
        try {
            this.res = res;
            this.protocolFactory = protocolFactory;
            this.requestInfo = requestInfo;
            this.idModuloAsIDService = idModuloAsIDService;
            this.idModulo = idModulo;
            this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    private void sendHeadersEngine(OpenSPCoop2Message msg) throws ConnectorException, MessageException {
        if (msg == null) {
            throw new ConnectorException("Message is null");
        }
        OpenSPCoop2MessageProperties forwardHeader = null;
        forwardHeader = ServiceBinding.REST.equals((Object)msg.getServiceBinding()) ? msg.getForwardTransportHeader(this.openspcoopProperties.getRESTServicesHeadersForwardConfig(false)) : msg.getForwardTransportHeader(this.openspcoopProperties.getSOAPServicesHeadersForwardConfig(false));
        if (forwardHeader != null && forwardHeader.size() > 0) {
            Iterator keys = forwardHeader.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                List values = forwardHeader.getPropertyValues(key);
                if (values == null || values.isEmpty()) continue;
                for (String value : values) {
                    this.addHeader(key, value);
                }
            }
        }
    }

    @Override
    public void sendResponse(OpenSPCoop2Message msg, boolean consume) throws ConnectorException {
        try {
            if (msg == null) {
                throw new ConnectorException("Message is null");
            }
            this.sendHeadersEngine(msg);
            boolean hasContent = false;
            if (ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                hasContent = true;
                OpenSPCoop2SoapMessage soap = msg.castAsSoap();
                if (soap.hasSOAPFault()) {
                    soap.saveChanges();
                }
            }
            if (ServiceBinding.REST.equals((Object)msg.getServiceBinding())) {
                OpenSPCoop2RestMessage rest = msg.castAsRest();
                hasContent = rest.hasContent();
            }
            if (hasContent) {
                this.outNullable = this.res.getOutputStream();
                msg.writeTo(this.outNullable, consume);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void sendResponse(DumpByteArrayOutputStream message) throws ConnectorException {
        block8: {
            try {
                if (message == null || message.size() <= 0) break block8;
                this.outNullable = this.res.getOutputStream();
                if (message.isSerializedOnFileSystem()) {
                    try (FileInputStream fin = new FileInputStream(message.getSerializedFile());){
                        Utilities.copy((InputStream)fin, (OutputStream)this.outNullable);
                        break block8;
                    }
                }
                this.outNullable.write(message.toByteArray());
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void sendResponseHeaders(OpenSPCoop2Message message) throws ConnectorException {
        try {
            this.sendHeadersEngine(message);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void setHeader(String key, String value) throws ConnectorException {
        this.putHeaderEngine(key, value, false);
    }

    @Override
    public void addHeader(String key, String value) throws ConnectorException {
        this.putHeaderEngine(key, value, true);
    }

    private void putHeaderEngine(String key, String value, boolean add) throws ConnectorException {
        try {
            if (value == null) {
                return;
            }
            boolean encodingRFC2047 = false;
            Charset charsetRFC2047 = null;
            RFC2047Encoding encodingAlgorithmRFC2047 = null;
            boolean validazioneHeaderRFC2047 = false;
            List<Proprieta> listProprieta = null;
            if (this.idModuloAsIDService != null) {
                switch (this.idModuloAsIDService) {
                    case PORTA_DELEGATA: 
                    case PORTA_DELEGATA_INTEGRATION_MANAGER: 
                    case PORTA_DELEGATA_XML_TO_SOAP: {
                        encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValueRicezioneContenutiApplicativi();
                        charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValueRicezioneContenutiApplicativi();
                        encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValueRicezioneContenutiApplicativi();
                        validazioneHeaderRFC2047 = this.openspcoopProperties.isEnabledValidazioneRFC2047HeaderNameValueRicezioneContenutiApplicativi();
                        listProprieta = this.readProprietaPortaDelegata();
                        break;
                    }
                    case PORTA_APPLICATIVA: {
                        encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValueRicezioneBuste();
                        charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValueRicezioneBuste();
                        encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValueRicezioneBuste();
                        validazioneHeaderRFC2047 = this.openspcoopProperties.isEnabledValidazioneRFC2047HeaderNameValueRicezioneBuste();
                        listProprieta = this.readProprietaPortaApplicativa();
                        break;
                    }
                }
            }
            encodingRFC2047 = CostantiProprieta.isConnettoriHeaderValueEncodingRFC2047ResponseEnabled(listProprieta, encodingRFC2047);
            charsetRFC2047 = CostantiProprieta.getConnettoriHeaderValueEncodingRFC2047ResponseCharset(listProprieta, charsetRFC2047);
            encodingAlgorithmRFC2047 = CostantiProprieta.getConnettoriHeaderValueEncodingRFC2047ResponseType(listProprieta, encodingAlgorithmRFC2047);
            validazioneHeaderRFC2047 = CostantiProprieta.isConnettoriHeaderValidationResponseEnabled(listProprieta, validazioneHeaderRFC2047);
            if (encodingRFC2047) {
                if (!RFC2047Utilities.isAllCharactersInCharset((String)value, (Charset)charsetRFC2047)) {
                    String encoded = RFC2047Utilities.encode((String)value, (Charset)charsetRFC2047, (RFC2047Encoding)encodingAlgorithmRFC2047);
                    this.putResponseHeader(validazioneHeaderRFC2047, key, encoded, add);
                } else {
                    this.putResponseHeader(validazioneHeaderRFC2047, key, value, add);
                }
            } else {
                this.putResponseHeader(validazioneHeaderRFC2047, key, value, add);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    private List<Proprieta> readProprietaPortaApplicativa() {
        block4: {
            if (this.requestInfo != null && this.requestInfo.getProtocolContext() != null && this.requestInfo.getProtocolContext().getInterfaceName() != null && StringUtils.isNotEmpty((String)this.requestInfo.getProtocolContext().getInterfaceName())) {
                IDPortaApplicativa idPA = new IDPortaApplicativa();
                idPA.setNome(this.requestInfo.getProtocolContext().getInterfaceName());
                try {
                    PortaApplicativa pa = ConfigurazionePdDManager.getInstance().getPortaApplicativaSafeMethod(idPA, this.requestInfo);
                    if (pa != null && pa.sizeProprieta() > 0) {
                        return pa.getProprieta();
                    }
                }
                catch (Exception e) {
                    if (this.protocolFactory == null || this.protocolFactory.getLogger() == null) break block4;
                    this.protocolFactory.getLogger().error("Accesso porta applicativa [" + this.requestInfo.getProtocolContext().getInterfaceName() + "] fallito: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private List<Proprieta> readProprietaPortaDelegata() {
        block4: {
            if (this.requestInfo != null && this.requestInfo.getProtocolContext() != null && this.requestInfo.getProtocolContext().getInterfaceName() != null && StringUtils.isNotEmpty((String)this.requestInfo.getProtocolContext().getInterfaceName())) {
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setNome(this.requestInfo.getProtocolContext().getInterfaceName());
                try {
                    PortaDelegata pd = ConfigurazionePdDManager.getInstance().getPortaDelegataSafeMethod(idPD, this.requestInfo);
                    if (pd != null && pd.sizeProprieta() > 0) {
                        return pd.getProprieta();
                    }
                }
                catch (Exception e) {
                    if (this.protocolFactory == null || this.protocolFactory.getLogger() == null) break block4;
                    this.protocolFactory.getLogger().error("Accesso porta applicativa [" + this.requestInfo.getProtocolContext().getInterfaceName() + "] fallito: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private void putResponseHeader(boolean validazioneHeaderRFC2047, String key, String value, boolean add) {
        block8: {
            if (validazioneHeaderRFC2047) {
                try {
                    RFC2047Utilities.validHeader((String)key, (String)value);
                    if (add) {
                        this.res.addHeader(key, value);
                        break block8;
                    }
                    this.res.setHeader(key, value);
                }
                catch (UtilsException e) {
                    if (this.protocolFactory != null && this.protocolFactory.getLogger() != null) {
                        this.protocolFactory.getLogger().error(e.getMessage(), (Throwable)e);
                        break block8;
                    }
                    LoggerWrapperFactory.getLogger(HttpServletConnectorOutMessage.class).error(e.getMessage(), (Throwable)e);
                }
            } else if (add) {
                this.res.addHeader(key, value);
            } else {
                this.res.setHeader(key, value);
            }
        }
    }

    @Override
    public void setContentLength(int length) throws ConnectorException {
        try {
            this.res.setContentLength(length);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void setContentType(String type) throws ConnectorException {
        try {
            this.res.setContentType(type);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void setStatus(int status) throws ConnectorException {
        try {
            this.res.setStatus(status);
            this.status = status;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public int getResponseStatus() throws ConnectorException {
        return this.status;
    }

    @Override
    public void flush(boolean throwException) throws ConnectorException {
        block9: {
            try {
                block8: {
                    if (this.res != null) {
                        try {
                            this.res.flushBuffer();
                        }
                        catch (Exception e) {
                            if (!throwException) break block8;
                            throw e;
                        }
                    }
                }
                if (this.outNullable == null) break block9;
                try {
                    this.outNullable.flush();
                }
                catch (Exception e) {
                    if (throwException) {
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void close(boolean throwException) throws ConnectorException {
        block5: {
            try {
                if (this.outNullable == null) break block5;
                try {
                    this.outNullable.close();
                    this.outNullable = null;
                }
                catch (Exception e) {
                    if (throwException) {
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
    }
}

