/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector.proxy;

import java.util.Date;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.config.DynamicClusterManager;
import org.openspcoop2.pdd.services.connector.proxy.IProxyOperationService;
import org.openspcoop2.pdd.services.connector.proxy.ProxyOperation;
import org.slf4j.Logger;

public class DBProxyOperationService
implements IProxyOperationService {
    private Logger log;
    private DynamicClusterManager dynamicClusterManager;

    @Override
    public void init(Logger log) throws CoreException {
        this.log = log;
        this.dynamicClusterManager = DynamicClusterManager.getInstance();
    }

    @Override
    public void save(ProxyOperation operation) throws CoreException {
        this.dynamicClusterManager.registerOperation(this.log, operation.getDescription(), operation.getCommand());
    }

    @Override
    public List<ProxyOperation> next(Date recTimeGreaterThan, Date now, int offset, int limit) throws CoreException {
        return this.dynamicClusterManager.findRemoteOperations(recTimeGreaterThan, now, offset, limit);
    }

    @Override
    public int clear(Date olderThan) throws CoreException {
        return this.dynamicClusterManager.deleteRemoteOperations(olderThan);
    }
}

