/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.dynamic.PddPluginLoader;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.MTOMProcessor;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.ProtocolContext;
import org.openspcoop2.pdd.core.autorizzazione.container.AutorizzazioneHttpServletRequest;
import org.openspcoop2.pdd.core.autorizzazione.container.IAutorizzazioneSecurityContainer;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.credenziali.IGestoreCredenziali;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InRequestContext;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneBusta;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePA;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePASoap;
import org.openspcoop2.pdd.core.integrazione.OutResponsePAMessage;
import org.openspcoop2.pdd.core.node.INodeReceiver;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.node.NodeTimeoutException;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.ImbustamentoRisposte;
import org.openspcoop2.pdd.mdb.InoltroRisposte;
import org.openspcoop2.pdd.mdb.Sbustamento;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.services.core.RicezioneBusteContext;
import org.openspcoop2.pdd.services.core.RicezioneBusteGestioneRisposta;
import org.openspcoop2.pdd.services.core.RicezioneBusteMessage;
import org.openspcoop2.pdd.services.error.AbstractErrorGenerator;
import org.openspcoop2.pdd.services.error.RicezioneBusteExternalErrorGenerator;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerThresholdThread;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.validator.Validatore;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.dump.DumpException;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.protocol.sdk.tracciamento.EsitoElaborazioneMessaggioTracciato;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.engine.WSSUtilities;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class RicezioneBuste {
    public static final String ID_MODULO = "RicezioneBuste";
    public static boolean initializeService = false;
    public static String[] defaultGestoriIntegrazionePA = null;
    public static ConcurrentHashMap<String, String[]> defaultPerProtocolloGestoreIntegrazionePA = null;
    private static String[] tipiGestoriCredenziali = null;
    private RicezioneBusteExternalErrorGenerator generatoreErrore;
    private RicezioneBusteContext msgContext;

    private static void logDebug(Logger logCore, String msg) {
        logCore.debug(msg);
    }

    private static void logDebug(Logger logCore, String msg, Throwable e) {
        logCore.debug(msg, e);
    }

    private static void logInfo(Logger logCore, String msg) {
        logCore.info(msg);
    }

    private static void logError(Logger logCore, String msg) {
        logCore.error(msg);
    }

    private static void logError(Logger logCore, String msg, Throwable e) {
        logCore.error(msg, e);
    }

    public static synchronized void initializeService(ConfigurazionePdDManager configReader, ClassNameProperties className, OpenSPCoop2Properties propertiesReader, Logger logCore) throws Exception {
        if (initializeService) {
            return;
        }
        Loader loader = Loader.getInstance();
        PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
        String classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
        try {
            INodeSender nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
            nodeSender.toString();
            RicezioneBuste.logInfo(logCore, "Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + " effettuata.");
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
        String classType = className.getNodeReceiver(propertiesReader.getNodeReceiver());
        try {
            INodeReceiver nodeReceiver = (INodeReceiver)loader.newInstance(classType);
            nodeReceiver.toString();
            RicezioneBuste.logInfo(logCore, "Inizializzazione gestore NodeReceiver di tipo " + classType + " effettuata.");
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
        }
        String[] tipiIntegrazioneDefault = propertiesReader.getTipoIntegrazionePA();
        ArrayList<String> s = new ArrayList<String>();
        for (int i = 0; i < tipiIntegrazioneDefault.length; ++i) {
            try {
                IGestoreIntegrazionePA gestore = pluginLoader.newIntegrazionePortaApplicativa(tipiIntegrazioneDefault[i]);
                gestore.toString();
                s.add(tipiIntegrazioneDefault[i]);
                logCore.info("Inizializzazione gestore dati di integrazione per le erogazioni di tipo " + tipiIntegrazioneDefault[i] + " effettuata.");
                continue;
            }
            catch (Exception e) {
                throw new Exception(e.getMessage(), e);
            }
        }
        if (s.size() > 0) {
            defaultGestoriIntegrazionePA = s.toArray(new String[1]);
        }
        defaultPerProtocolloGestoreIntegrazionePA = new ConcurrentHashMap();
        Enumeration enumProtocols = ProtocolFactoryManager.getInstance().getProtocolNames();
        while (enumProtocols.hasMoreElements()) {
            String protocol = (String)enumProtocols.nextElement();
            String[] tipiIntegrazionePA = propertiesReader.getTipoIntegrazionePA(protocol);
            if (tipiIntegrazionePA == null || tipiIntegrazionePA.length <= 0) continue;
            ArrayList<String> tipiIntegrazionePerProtocollo = new ArrayList<String>();
            for (int i = 0; i < tipiIntegrazionePA.length; ++i) {
                try {
                    IGestoreIntegrazionePA gestore = pluginLoader.newIntegrazionePortaApplicativa(tipiIntegrazionePA[i]);
                    gestore.toString();
                    tipiIntegrazionePerProtocollo.add(tipiIntegrazionePA[i]);
                    logCore.info("Inizializzazione gestore dati di integrazione (protocollo: " + protocol + ") per le erogazioni di tipo " + tipiIntegrazionePA[i] + " effettuata.");
                    continue;
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
            if (tipiIntegrazionePerProtocollo.size() <= 0) continue;
            defaultPerProtocolloGestoreIntegrazionePA.put(protocol, tipiIntegrazionePerProtocollo.toArray(new String[1]));
        }
        tipiGestoriCredenziali = propertiesReader.getTipoGestoreCredenzialiPA();
        if (tipiGestoriCredenziali != null) {
            for (int i = 0; i < tipiGestoriCredenziali.length; ++i) {
                classType = className.getGestoreCredenziali(tipiGestoriCredenziali[i]);
                try {
                    IGestoreCredenziali gestore = (IGestoreCredenziali)loader.newInstance(classType);
                    gestore.toString();
                    logCore.info("Inizializzazione gestore credenziali di tipo " + tipiGestoriCredenziali[i] + " effettuata.");
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione delle credenziali di tipo [" + tipiGestoriCredenziali[i] + "]: " + e.getMessage());
                }
            }
        }
        initializeService = true;
    }

    public RicezioneBuste(RicezioneBusteContext context, RicezioneBusteExternalErrorGenerator generatoreErrore) {
        this.msgContext = context;
        this.generatoreErrore = generatoreErrore;
    }

    public void process(Object ... params) {
        String tipo;
        OpenSPCoop2Properties properties;
        PdDContext context = this.msgContext.getPddContext();
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = LoggerWrapperFactory.getLogger((String)ID_MODULO);
        }
        MsgDiagnostico msgDiag = this.msgContext.getMsgDiagnostico();
        OpenSPCoop2Message requestMessage = this.msgContext.getMessageRequest();
        if (requestMessage == null) {
            this.setSOAPFault_processamento(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, logCore, msgDiag, new Exception("Request message is null"), "LetturaMessaggioRichiesta");
        }
        IProtocolFactory protocolFactory = null;
        try {
            if (context == null) {
                throw new Exception("Context is null");
            }
            protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)context.getObject(Costanti.PROTOCOL_NAME));
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, logCore, msgDiag, e, "ProtocolFactoryInstance");
            return;
        }
        InRequestContext inRequestContext = new InRequestContext(logCore, protocolFactory, null);
        inRequestContext.setTipoPorta(TipoPdD.APPLICATIVA);
        inRequestContext.setIdModulo(this.msgContext.getIdModulo());
        InfoConnettoreIngresso connettore = new InfoConnettoreIngresso();
        connettore.setCredenziali(this.msgContext.getCredenziali());
        if (this.msgContext.getUrlProtocolContext() != null && this.msgContext.getUrlProtocolContext().getHttpServletRequest() != null && (properties = OpenSPCoop2Properties.getInstance()) != null && (tipo = properties.getRealContainerCustom()) != null) {
            try {
                ClassNameProperties className = ClassNameProperties.getInstance();
                Loader loader = Loader.getInstance();
                String tipoClass = className.getRealmContainerCustom(tipo);
                IAutorizzazioneSecurityContainer authEngine = (IAutorizzazioneSecurityContainer)loader.newInstance(tipoClass);
                authEngine.init(this.msgContext.getUrlProtocolContext().getHttpServletRequest(), context, protocolFactory);
                AutorizzazioneHttpServletRequest httpServletRequestAuth = new AutorizzazioneHttpServletRequest(this.msgContext.getUrlProtocolContext().getHttpServletRequest(), authEngine);
                this.msgContext.getUrlProtocolContext().updateHttpServletRequest((HttpServletRequest)httpServletRequestAuth);
            }
            catch (Exception e) {
                this.setSOAPFault_processamento(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, logCore, msgDiag, e, "AutorizzazioneSecurityContainerInstance");
                return;
            }
        }
        connettore.setUrlProtocolContext(this.msgContext.getUrlProtocolContext());
        if (requestMessage != null && ServiceBinding.SOAP.equals((Object)requestMessage.getServiceBinding())) {
            try {
                connettore.setSoapAction(requestMessage.castAsSoap().getSoapAction());
            }
            catch (Exception e) {
                this.setSOAPFault_processamento(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, logCore, msgDiag, e, "LetturaSoapAction");
                return;
            }
        }
        connettore.setFromLocation(this.msgContext.getSourceLocation());
        inRequestContext.setConnettore(connettore);
        inRequestContext.setDataAccettazioneRichiesta(this.msgContext.getDataAccettazioneRichiesta());
        inRequestContext.setDataElaborazioneMessaggio(this.msgContext.getDataIngressoRichiesta());
        inRequestContext.setPddContext(context);
        inRequestContext.setMessaggio(requestMessage);
        try {
            GestoreHandlers.inRequest(inRequestContext, msgDiag, logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFault_processamento(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, logCore, msgDiag, e, "InvocazioneInRequestHandler");
            return;
        }
        HashMap<String, Object> internalObjects = new HashMap<String, Object>();
        try {
            this.process_engine(inRequestContext, internalObjects, params);
        }
        catch (TracciamentoException tracciamentoException) {
            this.setSOAPFault_processamento(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, (Exception)((Object)tracciamentoException), "TracciamentoNonRiuscito");
            return;
        }
        catch (DumpException e) {
            this.setSOAPFault_processamento(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, (Exception)((Object)e), "DumpNonRiuscito");
            return;
        }
        catch (ProtocolException protocolException) {
            this.setSOAPFault_processamento(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, (Exception)((Object)protocolException), "ProtocolFactoryNonInstanziata");
            return;
        }
        try {
            if (context != null && this.msgContext.getIntegrazione() != null) {
                if (context.containsKey(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RICHIESTA)) {
                    this.msgContext.getIntegrazione().setTipoProcessamentoMtomXopRichiesta((String)context.getObject(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RICHIESTA));
                }
                if (context.containsKey(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RISPOSTA)) {
                    this.msgContext.getIntegrazione().setTipoProcessamentoMtomXopRisposta((String)context.getObject(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RISPOSTA));
                }
                if (context.containsKey(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RICHIESTA)) {
                    this.msgContext.getIntegrazione().setTipoMessageSecurityRichiesta((String)context.getObject(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RICHIESTA));
                }
                if (context.containsKey(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RISPOSTA)) {
                    this.msgContext.getIntegrazione().setTipoMessageSecurityRisposta((String)context.getObject(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RISPOSTA));
                }
            }
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, e, "FinalizeIntegrationContextRicezioneBuste");
            return;
        }
        if (!internalObjects.containsKey("DumpRichiestaEffettuato") && Dump.isSistemaDumpDisponibile()) {
            try {
                OpenSPCoop2Message msgRichiesta;
                URLProtocolContext urlProtocolContext;
                ConfigurazionePdDManager configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                if (!internalObjects.containsKey("DumpConfig") && (urlProtocolContext = this.msgContext.getUrlProtocolContext()) != null && urlProtocolContext.getInterfaceName() != null) {
                    IDPortaApplicativa identificativoPortaApplicativa = new IDPortaApplicativa();
                    identificativoPortaApplicativa.setNome(urlProtocolContext.getInterfaceName());
                    PortaApplicativa portaApplicativa = configurazionePdDReader.getPortaApplicativaSafeMethod(identificativoPortaApplicativa, this.msgContext.getRequestInfo());
                    if (portaApplicativa != null) {
                        DumpConfigurazione dumpConfig = configurazionePdDReader.getDumpConfigurazione(portaApplicativa);
                        internalObjects.put("DumpConfig", dumpConfig);
                    }
                }
                if ((msgRichiesta = inRequestContext.getMessaggio()) != null) {
                    Dump dumpApplicativo = this.getDump(configurazionePdDReader, protocolFactory, internalObjects, msgDiag.getPorta());
                    dumpApplicativo.dumpRichiestaIngresso(msgRichiesta, inRequestContext.getConnettore().getUrlProtocolContext());
                }
            }
            catch (DumpException dumpException) {
                this.setSOAPFault_processamento(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, (Exception)((Object)dumpException), "DumpNonRiuscito");
                return;
            }
            catch (Exception dumpException) {
                // empty catch block
            }
        }
        OutResponseContext outResponseContext = new OutResponseContext(logCore, protocolFactory, null);
        outResponseContext.setTipoPorta(this.msgContext.getTipoPorta());
        outResponseContext.setIdModulo(this.msgContext.getIdModulo());
        outResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
        outResponseContext.setPddContext(inRequestContext.getPddContext());
        outResponseContext.setProtocollo(this.msgContext.getProtocol());
        outResponseContext.setIntegrazione(this.msgContext.getIntegrazione());
        outResponseContext.setResponseHeaders(this.msgContext.getResponseHeaders());
        OpenSPCoop2Message msgResponse = this.msgContext.getMessageResponse();
        outResponseContext.setMessaggio(msgResponse);
        try {
            GestoreHandlers.outResponse(outResponseContext, msgDiag, logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFault_processamento(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, e, "InvocazioneOutResponseHandler");
            return;
        }
        OpenSPCoop2Message msgRisposta = null;
        try {
            msgRisposta = outResponseContext.getMessaggio();
            boolean rispostaPresente = true;
            OpenSPCoop2Properties properties2 = OpenSPCoop2Properties.getInstance();
            if (properties2 != null) {
                rispostaPresente = ServicesUtils.verificaRispostaRelazioneCodiceTrasporto202(protocolFactory, OpenSPCoop2Properties.getInstance(), msgRisposta, true);
            }
            if (rispostaPresente) {
                this.msgContext.setMessageResponse(msgRisposta);
            } else {
                this.msgContext.setMessageResponse(null);
                msgRisposta = null;
            }
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, e, "FineGestioneRicezioneBuste");
            return;
        }
        if (Dump.isSistemaDumpDisponibile()) {
            try {
                ConfigurazionePdDManager configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                if (msgRisposta != null) {
                    Dump dumpApplicativo = this.getDump(configurazionePdDReader, protocolFactory, internalObjects, msgDiag.getPorta());
                    if (outResponseContext.getResponseHeaders() == null) {
                        outResponseContext.setResponseHeaders(new HashMap<String, List<String>>());
                    }
                    Map<String, List<String>> propertiesTrasporto = outResponseContext.getResponseHeaders();
                    ServiceBinding sb = requestMessage != null ? requestMessage.getServiceBinding() : this.msgContext.getRequestInfo().getProtocolServiceBinding();
                    ServicesUtils.setGovWayHeaderResponse(sb, msgRisposta, OpenSPCoop2Properties.getInstance(), propertiesTrasporto, logCore, false, outResponseContext.getPddContext(), this.msgContext.getRequestInfo());
                    dumpApplicativo.dumpRispostaUscita(msgRisposta, inRequestContext.getConnettore().getUrlProtocolContext(), outResponseContext.getResponseHeaders());
                }
            }
            catch (DumpException dumpException) {
                this.setSOAPFault_processamento(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, (Exception)((Object)dumpException), "DumpNonRiuscito");
            }
            catch (Exception e) {
                RicezioneBuste.logError(logCore, e.getMessage(), e);
            }
        }
    }

    private Dump getDump(ConfigurazionePdDManager configurazionePdDReader, IProtocolFactory<?> protocolFactory, HashMap<String, Object> internalObjects, String nomePorta) throws DumpException, DriverRegistroServiziException {
        DumpConfigurazione dumpConfig = null;
        dumpConfig = internalObjects.containsKey("DumpConfig") ? (DumpConfigurazione)internalObjects.get("DumpConfig") : configurazionePdDReader.getDumpConfigurazionePortaApplicativa();
        ProtocolContext protocolContext = this.msgContext.getProtocol();
        URLProtocolContext urlProtocolContext = this.msgContext.getUrlProtocolContext();
        IDSoggetto soggettoErogatore = null;
        IDServizio idServizio = null;
        IDSoggetto fruitore = null;
        IDSoggetto dominio = null;
        String idRichiesta = null;
        if (protocolContext != null) {
            if (protocolContext.getTipoServizio() != null && protocolContext.getServizio() != null && protocolContext.getVersioneServizio() != null && protocolContext.getErogatore() != null && protocolContext.getErogatore().getTipo() != null && protocolContext.getErogatore().getNome() != null) {
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(protocolContext.getTipoServizio(), protocolContext.getServizio(), protocolContext.getErogatore(), protocolContext.getVersioneServizio().intValue());
            }
            dominio = protocolContext.getDominio();
            idRichiesta = protocolContext.getIdRichiesta();
            if (protocolContext.getFruitore() != null && protocolContext.getFruitore().getTipo() != null && protocolContext.getFruitore().getNome() != null) {
                fruitore = protocolContext.getFruitore();
            }
        }
        if ((dominio == null || fruitore == null || idServizio == null) && urlProtocolContext != null && urlProtocolContext.getInterfaceName() != null) {
            IDPortaApplicativa identificativoPortaApplicativa = new IDPortaApplicativa();
            identificativoPortaApplicativa.setNome(urlProtocolContext.getInterfaceName());
            PortaApplicativa portaApplicativa = null;
            try {
                portaApplicativa = configurazionePdDReader.getPortaApplicativaSafeMethod(identificativoPortaApplicativa, this.msgContext.getRequestInfo());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (portaApplicativa != null) {
                soggettoErogatore = new IDSoggetto(portaApplicativa.getTipoSoggettoProprietario(), portaApplicativa.getNomeSoggettoProprietario());
                if (portaApplicativa.getServizio() != null) {
                    idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaApplicativa.getServizio().getTipo(), portaApplicativa.getServizio().getNome(), soggettoErogatore, portaApplicativa.getServizio().getVersione().intValue());
                }
                dominio = new IDSoggetto(portaApplicativa.getTipoSoggettoProprietario(), portaApplicativa.getNomeSoggettoProprietario());
                try {
                    dominio.setCodicePorta(RegistroServiziManager.getInstance().getDominio(dominio, null, protocolFactory, this.msgContext.getRequestInfo()));
                }
                catch (Exception e) {
                    dominio = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocolFactory.getProtocol(), this.msgContext.getRequestInfo());
                }
            }
        }
        if (idServizio != null) {
            if (protocolContext != null && protocolContext.getAzione() != null) {
                idServizio.setAzione(protocolContext.getAzione());
            } else if (this.msgContext.getRequestInfo() != null && this.msgContext.getRequestInfo().getIdServizio() != null && this.msgContext.getRequestInfo().getIdServizio().getAzione() != null) {
                idServizio.setAzione(this.msgContext.getRequestInfo().getIdServizio().getAzione());
            }
        }
        if (dominio == null) {
            dominio = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocolFactory.getProtocol(), this.msgContext.getRequestInfo());
        }
        Dump dumpApplicativo = null;
        dumpApplicativo = protocolContext != null ? new Dump(dominio, this.msgContext.getIdModulo(), idRichiesta, fruitore, idServizio, this.msgContext.getTipoPorta(), nomePorta, this.msgContext.getPddContext(), null, null, dumpConfig) : new Dump(dominio, this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), nomePorta, this.msgContext.getPddContext(), null, null, dumpConfig);
        return dumpApplicativo;
    }

    private void setSOAPFault_processamento(IntegrationFunctionError integrationFunctionError, ErroreIntegrazione erroreIntegrazione) {
        this.setSOAPFault_engine(integrationFunctionError, null, null, null, null, erroreIntegrazione, null, false);
    }

    private void setSOAPFault_processamento(IntegrationFunctionError integrationFunctionError, ErroreIntegrazione erroreIntegrazione, Exception e) {
        this.setSOAPFault_engine(integrationFunctionError, null, null, e, null, erroreIntegrazione, null, false);
    }

    private void setSOAPFault_processamento(IntegrationFunctionError integrationFunctionError, Logger logCore, MsgDiagnostico msgDiag, Exception e, String posizione) {
        this.setSOAPFault_engine(integrationFunctionError, logCore, msgDiag, e, null, null, posizione, false);
    }

    private void setSOAPFault_processamento(IntegrationFunctionError integrationFunctionError, Logger logCore, MsgDiagnostico msgDiag, ErroreIntegrazione erroreIntegrazione, Exception e, String posizione) {
        this.setSOAPFault_engine(integrationFunctionError, logCore, msgDiag, e, null, erroreIntegrazione, posizione, false);
    }

    private void setSOAPFault_intestazione(IntegrationFunctionError integrationFunctionError, ErroreCooperazione erroreCooperazione) {
        this.setSOAPFault_engine(integrationFunctionError, null, null, null, erroreCooperazione, null, null, true);
    }

    private void setSOAPFault_intestazione(IntegrationFunctionError integrationFunctionError, ErroreIntegrazione erroreIntegrazione) {
        this.setSOAPFault_engine(integrationFunctionError, null, null, null, null, erroreIntegrazione, null, true);
    }

    private void setSOAPFault_engine(IntegrationFunctionError integrationFunctionError, Logger logCore, MsgDiagnostico msgDiag, Exception e, ErroreCooperazione erroreCooperazione, ErroreIntegrazione erroreIntegrazione, String posizioneErrore, boolean validazione) {
        HandlerException he = null;
        if (e != null && e instanceof HandlerException) {
            he = (HandlerException)e;
        }
        PdDContext context = this.msgContext.getPddContext();
        if (msgDiag != null) {
            if (he != null) {
                if (he.isEmettiDiagnostico()) {
                    msgDiag.logErroreGenerico(e, posizioneErrore);
                }
            } else {
                String descrizioneErrore = null;
                if (erroreCooperazione != null) {
                    try {
                        descrizioneErrore = erroreCooperazione.getDescrizione(this.generatoreErrore.getProtocolFactory());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (descrizioneErrore == null && erroreIntegrazione != null) {
                    try {
                        descrizioneErrore = erroreIntegrazione.getDescrizione(this.generatoreErrore.getProtocolFactory());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (descrizioneErrore == null) {
                    descrizioneErrore = posizioneErrore;
                }
                msgDiag.logErroreGenerico(descrizioneErrore, posizioneErrore);
                if (logCore != null) {
                    if (e != null) {
                        RicezioneBuste.logError(logCore, descrizioneErrore + ": " + e.getMessage(), e);
                    } else {
                        RicezioneBuste.logError(logCore, descrizioneErrore);
                    }
                }
            }
        } else if (logCore != null) {
            if (e != null) {
                RicezioneBuste.logError(logCore, posizioneErrore + ": " + e.getMessage(), e);
            } else {
                RicezioneBuste.logError(logCore, posizioneErrore);
            }
        }
        if (this.msgContext.isGestioneRisposta()) {
            OpenSPCoop2Message messageFault = null;
            if (validazione) {
                if (erroreCooperazione != null) {
                    String descrizioneErrore = null;
                    try {
                        descrizioneErrore = erroreCooperazione.getDescrizione(this.generatoreErrore.getProtocolFactory());
                        messageFault = this.generatoreErrore.buildErroreIntestazione(context, integrationFunctionError, erroreCooperazione.getCodiceErrore(), descrizioneErrore);
                    }
                    catch (Exception eP) {
                        messageFault = this.generatoreErrore.buildFault(eP, (Context)context);
                    }
                } else {
                    messageFault = this.generatoreErrore.buildErroreIntestazione(context, integrationFunctionError, erroreIntegrazione);
                }
            } else if (erroreIntegrazione != null) {
                messageFault = this.generatoreErrore.buildErroreProcessamento(context, integrationFunctionError, erroreIntegrazione, e);
            } else if (e != null) {
                IntegrationFunctionError ifError = integrationFunctionError;
                ErroreIntegrazione erroreIntegrazioneGenerato = null;
                if (he != null) {
                    erroreIntegrazioneGenerato = he.convertToErroreIntegrazione();
                    if (he.getIntegrationFunctionError() != null) {
                        ifError = he.getIntegrationFunctionError();
                    }
                }
                if (erroreIntegrazioneGenerato == null) {
                    erroreIntegrazioneGenerato = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(posizioneErrore);
                }
                messageFault = this.generatoreErrore.buildErroreProcessamento(context, ifError, erroreIntegrazioneGenerato, e);
                if (he != null) {
                    he.customized(messageFault);
                }
            } else {
                messageFault = this.generatoreErrore.buildErroreProcessamento((Context)context, integrationFunctionError, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(posizioneErrore));
            }
            this.msgContext.setMessageResponse(messageFault);
        }
    }

    private boolean checkInizializzazione(Logger logCore, ConfigurazionePdDManager configurazionePdDReader, RegistroServiziManager registroServiziReader) {
        if (!OpenSPCoop2Startup.initialize) {
            String msgErrore = "Inizializzazione di GovWay non correttamente effettuata";
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "InizializzazioneGovWay");
                }
            }
            catch (Throwable t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            this.setSOAPFault_processamento(IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA));
            return false;
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            String msgErrore = "Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage();
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore, TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "InizializzazioneRisorseGovWay");
                }
            }
            catch (Throwable t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            this.setSOAPFault_processamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_532_RISORSE_NON_DISPONIBILI));
            return false;
        }
        if (!TimerThresholdThread.freeSpace) {
            String msgErrore = "Non sono disponibili abbastanza risorse per la gestione della richiesta";
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "DisponibilitaRisorseGovWay");
                }
            }
            catch (Throwable t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            this.setSOAPFault_processamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_533_RISORSE_DISPONIBILI_LIVELLO_CRITICO));
            return false;
        }
        if (!Tracciamento.tracciamentoDisponibile) {
            String msgErrore = "Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage();
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore, Tracciamento.motivoMalfunzionamentoTracciamento);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "Tracciamento");
                }
            }
            catch (Throwable t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            this.setSOAPFault_processamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_545_TRACCIATURA_NON_FUNZIONANTE));
            return false;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            String msgErrore = "Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage();
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore, MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "Diagnostica");
                }
            }
            catch (Throwable t) {
                RicezioneBuste.logDebug(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            this.setSOAPFault_processamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_546_DIAGNOSTICA_NON_FUNZIONANTE));
            return false;
        }
        if (!Dump.isSistemaDumpDisponibile()) {
            String msgErrore = "Sistema di dump dei contenuti applicativi non disponibile: " + Dump.getMotivoMalfunzionamentoDump().getMessage();
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore, Dump.getMotivoMalfunzionamentoDump());
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "Dump");
                }
            }
            catch (Throwable t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            this.setSOAPFault_processamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_547_DUMP_CONTENUTI_APPLICATIVI_NON_FUNZIONANTE));
            return false;
        }
        try {
            configurazionePdDReader.verificaConsistenzaConfigurazione();
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato errore durante la verifica della consistenza della configurazione";
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore, e);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "CheckConfigurazioneGovWay");
                }
            }
            catch (Throwable t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            this.setSOAPFault_processamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e);
            return false;
        }
        try {
            registroServiziReader.verificaConsistenzaRegistroServizi();
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato errore durante la verifica del registro dei servizi";
            RicezioneBuste.logError(logCore, "[RicezioneBuste]  " + msgErrore, e);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "CheckRegistroServizi");
                }
            }
            catch (Throwable t) {
                RicezioneBuste.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            this.setSOAPFault_processamento(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErrore, CodiceErroreIntegrazione.CODICE_534_REGISTRO_DEI_SERVIZI_NON_DISPONIBILE), e);
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private void process_engine(InRequestContext inRequestContext, HashMap<String, Object> internalObjects, Object ... params) throws TracciamentoException, DumpException, ProtocolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [368[CATCHBLOCK]], but top level block is 58[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setCredenziali(Credenziali credenziali, MsgDiagnostico msgDiag) {
        String credenzialiFornite = "";
        if (credenziali != null) {
            credenzialiFornite = credenziali.toString();
        }
        msgDiag.addKeyword("@CREDENZIALI@", credenzialiFornite);
    }

    /*
     * Unable to fully structure code
     */
    private void gestioneRisposta(RicezioneBusteGestioneRisposta parametriGestioneRisposta) throws Exception {
        openspcoopstate = parametriGestioneRisposta.getOpenspcoopstate();
        msgDiag = parametriGestioneRisposta.getMsgDiag();
        tracciamento = parametriGestioneRisposta.getTracciamento();
        logCore = parametriGestioneRisposta.getLogCore();
        propertiesReader = parametriGestioneRisposta.getPropertiesReader();
        identitaPdD = parametriGestioneRisposta.getIdentitaPdD();
        idMessageRequest = parametriGestioneRisposta.getIdMessageRequest();
        mittenteAnonimo = parametriGestioneRisposta.isMittenteAnonimo();
        implementazionePdDMittente = parametriGestioneRisposta.getImplementazionePdDMittente();
        msgRequest = parametriGestioneRisposta.getMsgRequest();
        repositoryBuste = parametriGestioneRisposta.getRepositoryBuste();
        requestMessage = parametriGestioneRisposta.getRequestMessage();
        portaStateless = parametriGestioneRisposta.isPortaStateless();
        oneWayStateless = parametriGestioneRisposta.isOneWayStateless();
        oneWayVersione11 = parametriGestioneRisposta.isOneWayVers11();
        sincronoStateless = parametriGestioneRisposta.isSincronoStateless();
        asincronoStateless = parametriGestioneRisposta.isAsincronoStateless();
        routingStateless = parametriGestioneRisposta.isRoutingStateless();
        richiestaRispostaProtocollo = parametriGestioneRisposta.isRichiestaRispostaProtocollo();
        tipoPorta = parametriGestioneRisposta.getTipoPorta();
        functionAsRouter = parametriGestioneRisposta.isFunctionAsRouter();
        pddContext = parametriGestioneRisposta.getPddContext();
        idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, pddContext);
        requestInfo = (RequestInfo)pddContext.getObject(Costanti.REQUEST_INFO);
        infoIntegrazione = parametriGestioneRisposta.getInfoIntegrazione();
        transaction = parametriGestioneRisposta.getTransaction();
        protocolFactory = parametriGestioneRisposta.getProtocolFactory();
        traduttore = parametriGestioneRisposta.getTraduttore();
        moduleManager = parametriGestioneRisposta.getModuleManager();
        bustaRichiesta = parametriGestioneRisposta.getBustaRichiesta();
        erroriValidazione = parametriGestioneRisposta.getErroriValidazione();
        versioneProtocollo = parametriGestioneRisposta.getVersioneProtocollo();
        ruoloBustaRicevuta = parametriGestioneRisposta.getRuoloBustaRicevuta();
        readQualifiedAttribute = parametriGestioneRisposta.isReadQualifiedAttribute();
        proprietaManifestAttachments = parametriGestioneRisposta.getProprietaManifestAttachments();
        pa = parametriGestioneRisposta.getPortaApplicativa();
        pd = parametriGestioneRisposta.getPortaDelegata();
        soggettoFruitore = parametriGestioneRisposta.getSoggettoMittente();
        idServizio = parametriGestioneRisposta.getIdServizio();
        correlazioneApplicativa = parametriGestioneRisposta.getCorrelazioneApplicativa();
        messageSecurityContext = parametriGestioneRisposta.getMessageSecurityContext();
        flowPropertiesResponse = parametriGestioneRisposta.getFlowPropertiesResponse();
        parametriGenerazioneBustaErrore = parametriGestioneRisposta.getParametriGenerazioneBustaErrore();
        parametriInvioBustaErrore = parametriGestioneRisposta.getParametriInvioBustaErrore();
        ricezioneBusteGeneratoreBustaErrore = parametriGestioneRisposta.getRicezioneBusteGeneratoreBustaErrore();
        registroServiziReader = parametriGestioneRisposta.getRegistroServiziReader();
        configurazionePdDReader = parametriGestioneRisposta.getConfigurazionePdDReader();
        loader = Loader.getInstance();
        pluginLoader = PddPluginLoader.getInstance();
        msgResponse = null;
        responseMessage = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)requestMessage.getFactory(), (MessageType)requestMessage.getMessageType(), (MessageRole)MessageRole.RESPONSE);
        bustaRisposta = null;
        idMessaggioSblocco = null;
        contenutoRispostaPresente = false;
        ricezioneBusteMSG = null;
        idCorrelazioneApplicativaRisposta = null;
        try {
            msgDiag.mediumDebug("Attesa/lettura risposta...");
            if (!portaStateless && !routingStateless) {
                classType = null;
                nodeReceiver = null;
                try {
                    classType = ClassNameProperties.getInstance().getNodeReceiver(propertiesReader.getNodeReceiver());
                    nodeReceiver = (INodeReceiver)loader.newInstance(classType);
                    AbstractCore.init(nodeReceiver, pddContext, protocolFactory, new Object[0]);
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
                }
                ricezioneBusteMSG = (RicezioneBusteMessage)nodeReceiver.receive(msgDiag, identitaPdD, this.msgContext.getIdModulo(), idMessageRequest, propertiesReader.getNodeReceiverTimeoutRicezioneBuste(), propertiesReader.getNodeReceiverCheckInterval());
                pddContext = ricezioneBusteMSG.getPddContext();
                if (pddContext != null && (enumPddContext = pddContext.keys()) != null && !enumPddContext.isEmpty()) {
                    for (MapKey key : enumPddContext) {
                        this.msgContext.getPddContext().addObject(key, pddContext.getObject(key));
                    }
                }
            } else {
                ricezioneBusteMSG = (RicezioneBusteMessage)openspcoopstate.getMessageLib();
            }
            v0 = contenutoRispostaPresente = ricezioneBusteMSG.getBustaRisposta() != null;
            if (richiestaRispostaProtocollo && !contenutoRispostaPresente) {
                throw new Exception("Risposta attesa e non ritornata: ErroreInterno");
            }
            if (contenutoRispostaPresente) {
                bustaRisposta = ricezioneBusteMSG.getBustaRisposta();
                this.msgContext.getProtocol().setIdRisposta(bustaRisposta.getID());
                this.msgContext.getProtocol().setCollaborazione(bustaRisposta.getCollaborazione());
            } else {
                idMessaggioSblocco = ricezioneBusteMSG.getIdMessaggioSblocco();
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "GestioneRisposta(" + this.msgContext.getIdModulo() + ")");
            RicezioneBuste.logError(logCore, "Gestione risposta (" + this.msgContext.getIdModulo() + ") con errore", e);
            if (!portaStateless && !routingStateless) {
                try {
                    msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                    openspcoopstate.updateResource(idTransazione);
                }
                catch (Exception eDB) {
                    this.setSOAPFault_processamento(IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, logCore, msgDiag, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), eDB, "openspcoopstate.updateDatabaseResource");
                    return;
                }
            }
            if (e instanceof NodeTimeoutException) {
                try {
                    msgDiag.logPersonalizzato("timeoutRicezioneRisposta");
                    msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    openspcoopstate.commit();
                }
                catch (Exception eDel) {
                    msgDiag.logErroreGenerico(eDel.getMessage(), "EliminazioneMessaggioScadutoTimeoutRicezioneRisposta");
                }
            }
            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
            parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_513_RECEIVE));
            errorOpenSPCoopMsg = ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
            parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
            ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(parametriInvioBustaErrore);
            openspcoopstate.releaseResource();
            return;
        }
        if (contenutoRispostaPresente) {
            msgDiag.setIdMessaggioRisposta(bustaRisposta.getID());
            msgDiag.addKeywords(bustaRisposta, false);
        } else {
            msgDiag.setIdMessaggioRisposta(idMessaggioSblocco);
        }
        parametriGenerazioneBustaErrore.setMsgDiag(msgDiag);
        parametriInvioBustaErrore.setMsgDiag(msgDiag);
        if (!portaStateless && !routingStateless) {
            try {
                msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                openspcoopstate.updateResource(idTransazione);
            }
            catch (Exception e) {
                this.setSOAPFault_processamento(IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, logCore, msgDiag, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), e, "openspcoopstate.updateDatabaseResource");
                return;
            }
            msgResponse = contenutoRispostaPresente != false ? new GestoreMessaggi(openspcoopstate, false, bustaRisposta.getID(), "OUTBOX", msgDiag, pddContext) : new GestoreMessaggi(openspcoopstate, false, idMessaggioSblocco, "OUTBOX", msgDiag, pddContext);
            if (contenutoRispostaPresente || functionAsRouter) {
                msgDiag.mediumDebug("Lettura messaggio di risposta...");
                try {
                    responseMessage = msgResponse.getMessage();
                    if (responseMessage != null && this.msgContext.getPddContext() != null) {
                        o = responseMessage.getContextProperty(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO);
                        if (o != null && o instanceof Boolean) {
                            this.msgContext.getPddContext().addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                        }
                        if ((o = responseMessage.getContextProperty(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) != null && o instanceof ParseException) {
                            this.msgContext.getPddContext().addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, o);
                        }
                        if ((o = responseMessage.getContextProperty(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO)) != null && o instanceof Boolean) {
                            this.msgContext.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, true);
                        }
                        if ((o = responseMessage.getContextProperty(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) != null && o instanceof ParseException) {
                            this.msgContext.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, o);
                        }
                    }
                    idCorrelazioneApplicativaRisposta = msgResponse.getIDCorrelazioneApplicativaRisposta();
                }
                catch (Exception e) {
                    if (functionAsRouter && !contenutoRispostaPresente) ** GOTO lbl167
                    msgDiag.logErroreGenerico(e, "msgResponse.getMessage()");
                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_511_READ_RESPONSE_MSG));
                    errorOpenSPCoopMsg = ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                    parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                    ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(parametriInvioBustaErrore);
                    openspcoopstate.releaseResource();
                    return;
                }
            }
        } else {
            responseMessage = ((OpenSPCoopStateless)openspcoopstate).getRispostaMsg();
            idCorrelazioneApplicativaRisposta = ((OpenSPCoopStateless)openspcoopstate).getIDCorrelazioneApplicativaRisposta();
            if (responseMessage != null) {
                parametriGenerazioneBustaErrore.setParseException(responseMessage.getParseException());
            }
        }
lbl167:
        // 6 sources

        parametriGenerazioneBustaErrore.setCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
        parametriInvioBustaErrore.setCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
        msgDiag.setIdCorrelazioneRisposta(idCorrelazioneApplicativaRisposta);
        if (this.msgContext.getIntegrazione() != null) {
            this.msgContext.getIntegrazione().setIdCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
        }
        if (contenutoRispostaPresente) {
            tras = null;
            if (propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente)) {
                msgDiag.mediumDebug("Impostazione trasmissione nella busta di risposta...");
                tras = new Trasmissione();
                tras.setOrigine(identitaPdD.getNome());
                tras.setTipoOrigine(identitaPdD.getTipo());
                tras.setIdentificativoPortaOrigine(identitaPdD.getCodicePorta());
                for (i = 0; i < bustaRichiesta.sizeListaTrasmissioni(); ++i) {
                    if (!identitaPdD.getTipo().equals(bustaRichiesta.getTrasmissione(i).getTipoDestinazione()) || !identitaPdD.getNome().equals(bustaRichiesta.getTrasmissione(i).getDestinazione())) continue;
                    tipoOrigineValido = true;
                    try {
                        traduttore.toProtocolOrganizationType(bustaRichiesta.getTrasmissione(i).getTipoOrigine());
                    }
                    catch (Exception e) {
                        tipoOrigineValido = false;
                    }
                    if (!tipoOrigineValido) continue;
                    tras.setDestinazione(bustaRichiesta.getTrasmissione(i).getOrigine());
                    tras.setTipoDestinazione(bustaRichiesta.getTrasmissione(i).getTipoOrigine());
                }
                if (tras.getDestinazione() == null || tras.getTipoDestinazione() == null) {
                    tras.setDestinazione(bustaRisposta.getDestinatario());
                    tras.setTipoDestinazione(bustaRisposta.getTipoDestinatario());
                }
                try {
                    dominio = registroServiziReader.getDominio(new IDSoggetto(tras.getTipoDestinazione(), tras.getDestinazione()), null, protocolFactory, requestInfo);
                    tras.setIdentificativoPortaDestinazione(dominio);
                }
                catch (Exception dominio) {
                    // empty catch block
                }
                tras.setOraRegistrazione(bustaRisposta.getOraRegistrazione());
                tras.setTempo(propertiesReader.getTipoTempoBusta(implementazionePdDMittente));
                bustaRisposta.addTrasmissione(tras);
            }
            scartaBody = false;
            if (!functionAsRouter) {
                allegaBody = configurazionePdDReader.isAllegaBody(pa);
                scartaBody = allegaBody != false ? true : configurazionePdDReader.isScartaBody(pa);
            }
            if (!functionAsRouter && bustaRisposta.sizeListaEccezioni() == 0 && moduleManager.isIgnoraEccezioniLivelloNonGrave()) {
                for (i = 0; i < erroriValidazione.size(); ++i) {
                    ec = erroriValidazione.get(i);
                    if (!LivelloRilevanza.INFO.equals((Object)ec.getRilevanza())) continue;
                    bustaRisposta.addEccezione(ec);
                }
            }
            msgDiag.mediumDebug("Imbustamento della risposta...");
            headerBustaRisposta = null;
            gestioneManifestRisposta = false;
            imbustatore = null;
            try {
                gestioneManifestRisposta = functionAsRouter != false ? configurazionePdDReader.isGestioneManifestAttachments() : (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) != false && RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString()) != false && pd != null ? configurazionePdDReader.isGestioneManifestAttachments(pd, protocolFactory) : configurazionePdDReader.isGestioneManifestAttachments(pa, protocolFactory));
                imbustatore = new Imbustamento(logCore, protocolFactory, openspcoopstate.getStatoRichiesta());
                if (!(!functionAsRouter || identitaPdD.getTipo().equals(bustaRisposta.getTipoMittente()) && identitaPdD.getNome().equals(bustaRisposta.getMittente()))) {
                    if (propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente)) {
                        msgDiag.highDebug("Tipo Messaggio Risposta prima dell'imbustamento [" + responseMessage.getClass().getName() + "]");
                        protocolMessage = imbustatore.addTrasmissione(responseMessage, tras, readQualifiedAttribute, FaseImbustamento.PRIMA_SICUREZZA_MESSAGGIO);
                        if (protocolMessage != null && !protocolMessage.isPhaseUnsupported()) {
                            headerBustaRisposta = protocolMessage.getBustaRawContent();
                            responseMessage = protocolMessage.getMessage();
                        }
                        msgDiag.highDebug("Tipo Messaggio Risposta dopo l'imbustamento [" + responseMessage.getClass().getName() + "]");
                    } else {
                        v = new Validatore(responseMessage, (Context)pddContext, openspcoopstate.getStatoRichiesta(), logCore, protocolFactory);
                        headerBustaRisposta = v.getHeaderProtocollo_senzaControlli();
                    }
                } else {
                    msgDiag.highDebug("Tipo Messaggio Risposta prima dell'imbustamento [" + responseMessage.getClass().getName() + "]");
                    protocolMessage = imbustatore.imbustamentoRisposta(responseMessage, (Context)pddContext, bustaRisposta, bustaRichiesta, infoIntegrazione, gestioneManifestRisposta, scartaBody, proprietaManifestAttachments, FaseImbustamento.PRIMA_SICUREZZA_MESSAGGIO);
                    if (protocolMessage != null && !protocolMessage.isPhaseUnsupported()) {
                        headerBustaRisposta = protocolMessage.getBustaRawContent();
                        responseMessage = protocolMessage.getMessage();
                    }
                    msgDiag.highDebug("Tipo Messaggio Risposta dopo l'imbustamento [" + responseMessage.getClass().getName() + "]");
                }
            }
            catch (Exception e) {
                if (msgResponse != null && !portaStateless && !routingStateless) {
                    try {
                        msgDiag.mediumDebug("Aggiornamento proprietario messaggio risposta ...");
                        msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    }
                    catch (Throwable var64_85) {
                        // empty catch block
                    }
                }
                if (!(!functionAsRouter || identitaPdD.getTipo().equals(bustaRisposta.getTipoMittente()) && identitaPdD.getNome().equals(bustaRisposta.getMittente()))) {
                    msgDiag.logErroreGenerico(e, "imbustatore.pre-security.addTrasmissione(risposta)");
                } else {
                    msgDiag.logErroreGenerico(e, "imbustatore.pre-security-imbustamento(risposta)");
                }
                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_526_GESTIONE_IMBUSTAMENTO));
                parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.INTEROPERABILITY_PROFILE_ENVELOPING_RESPONSE_FAILED);
                errorOpenSPCoopMsg = ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                if (responseMessage != null && responseMessage.getParseException() != null) {
                    errorOpenSPCoopMsg.setParseException(responseMessage.getParseException());
                }
                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(parametriInvioBustaErrore);
                openspcoopstate.releaseResource();
                return;
            }
            mtomProcessor = null;
            if (!functionAsRouter && flowPropertiesResponse != null) {
                msgDiag.mediumDebug("init MTOM Processor ...");
                mtomProcessor = new MTOMProcessor(flowPropertiesResponse.mtom, flowPropertiesResponse.messageSecurity, tipoPorta, msgDiag, logCore, pddContext);
            }
            if (mtomProcessor != null) {
                try {
                    mtomProcessor.mtomBeforeSecurity(responseMessage, RuoloMessaggio.RISPOSTA);
                }
                catch (Exception e) {
                    if (msgResponse != null && !portaStateless && !routingStateless) {
                        try {
                            msgDiag.mediumDebug("Aggiornamento proprietario messaggio risposta ...");
                            msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                        }
                        catch (Throwable var65_93) {
                            // empty catch block
                        }
                    }
                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR));
                    parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.ATTACHMENTS_PROCESSING_RESPONSE_FAILED);
                    errorOpenSPCoopMsg = ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                    parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                    ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(parametriInvioBustaErrore);
                    openspcoopstate.releaseResource();
                    return;
                }
            }
            if (!functionAsRouter) {
                if (flowPropertiesResponse != null && flowPropertiesResponse.messageSecurity != null && flowPropertiesResponse.messageSecurity.getFlowParameters() != null && flowPropertiesResponse.messageSecurity.getFlowParameters().size() > 0) {
                    try {
                        configurazionePdDReader.updateMessageSecurityForSender(flowPropertiesResponse.messageSecurity, logCore, responseMessage, bustaRichiesta, requestInfo, pddContext, flowPropertiesResponse.messageSecurityRequest);
                        messageSecurityContext.setFunctionAsClient(true);
                        messageSecurityContext.setOutgoingProperties(flowPropertiesResponse.messageSecurity.getFlowParameters());
                        tipoSicurezza = SecurityConstants.convertActionToString((Map)messageSecurityContext.getOutgoingProperties());
                        msgDiag.addKeyword("@TIPO_SICUREZZA_MESSAGGIO_RISPOSTA@", tipoSicurezza);
                        pddContext.addObject(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RISPOSTA, tipoSicurezza);
                        msgDiag.logPersonalizzato("messageSecurity.processamentoRispostaInCorso");
                        if (WSSUtilities.isNormalizeToSaajImpl((MessageSecurityContext)messageSecurityContext)) {
                            msgDiag.mediumDebug("Normalize to saajImpl");
                            responseMessage = responseMessage.normalizeToSaajImpl();
                        }
                        DynamicMapBuilderUtils.injectDynamicMap(bustaRichiesta, requestInfo, (org.openspcoop2.utils.Map<Object>)pddContext, logCore);
                        if (!messageSecurityContext.processOutgoing(responseMessage, (org.openspcoop2.utils.Map)pddContext, transaction != null ? transaction.getTempiElaborazione() : null)) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", messageSecurityContext.getMsgErrore());
                            msgDiag.logPersonalizzato("messageSecurity.processamentoRispostaInErrore");
                            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                            parametriGenerazioneBustaErrore.setErroreCooperazione(ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(messageSecurityContext.getMsgErrore(), messageSecurityContext.getCodiceErrore()));
                            parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.MESSAGE_SECURITY_RESPONSE_FAILED);
                            errorOpenSPCoopMsg = ricezioneBusteGeneratoreBustaErrore.generaBustaErroreValidazione(parametriGenerazioneBustaErrore);
                            parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                            ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            openspcoopstate.releaseResource();
                            return;
                        }
                        msgDiag.logPersonalizzato("messageSecurity.processamentoRispostaEffettuato");
                    }
                    catch (Exception e) {
                        if (msgResponse != null && !portaStateless && !routingStateless) {
                            try {
                                msgDiag.mediumDebug("Aggiornamento proprietario messaggio risposta ...");
                                msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                            }
                            catch (Throwable errorOpenSPCoopMsg) {
                                // empty catch block
                            }
                        }
                        msgDiag.addKeywordErroreProcessamento(e);
                        msgDiag.logPersonalizzato("messageSecurity.processamentoRispostaInErrore");
                        RicezioneBuste.logError(logCore, "[MessageSecurityResponse]" + e.getMessage(), e);
                        parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                        parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                        errorOpenSPCoopMsg = ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                        parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                        ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(parametriInvioBustaErrore);
                        openspcoopstate.releaseResource();
                        return;
                    }
                }
                msgDiag.logPersonalizzato("messageSecurity.processamentoRispostaDisabilitato");
            }
            if (mtomProcessor != null) {
                try {
                    mtomProcessor.mtomAfterSecurity(responseMessage, RuoloMessaggio.RISPOSTA);
                }
                catch (Exception e) {
                    if (msgResponse != null && !portaStateless && !routingStateless) {
                        try {
                            msgDiag.mediumDebug("Aggiornamento proprietario messaggio risposta ...");
                            msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                        }
                        catch (Throwable errorOpenSPCoopMsg) {
                            // empty catch block
                        }
                    }
                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR));
                    parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.ATTACHMENTS_PROCESSING_RESPONSE_FAILED);
                    errorOpenSPCoopMsg = ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                    parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                    ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(parametriInvioBustaErrore);
                    openspcoopstate.releaseResource();
                    return;
                }
            }
            msgDiag.mediumDebug("Imbustamento della risposta dopo la sicurezza...");
            try {
                if (!(!functionAsRouter || identitaPdD.getTipo().equals(bustaRisposta.getTipoMittente()) && identitaPdD.getNome().equals(bustaRisposta.getMittente()))) {
                    if (propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente)) {
                        msgDiag.highDebug("Tipo Messaggio Risposta prima dell'imbustamento (after-security) [" + responseMessage.getClass().getName() + "]");
                        protocolMessage = imbustatore.addTrasmissione(responseMessage, tras, readQualifiedAttribute, FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO);
                        if (protocolMessage != null && !protocolMessage.isPhaseUnsupported()) {
                            headerBustaRisposta = protocolMessage.getBustaRawContent();
                            responseMessage = protocolMessage.getMessage();
                        }
                        msgDiag.highDebug("Tipo Messaggio Risposta dopo l'imbustamento (after-security) [" + responseMessage.getClass().getName() + "]");
                    }
                } else {
                    msgDiag.highDebug("Tipo Messaggio Risposta prima dell'imbustamento (after-security) [" + responseMessage.getClass().getName() + "]");
                    protocolMessage = imbustatore.imbustamentoRisposta(responseMessage, (Context)pddContext, bustaRisposta, bustaRichiesta, infoIntegrazione, gestioneManifestRisposta, scartaBody, proprietaManifestAttachments, FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO);
                    if (protocolMessage != null && !protocolMessage.isPhaseUnsupported()) {
                        headerBustaRisposta = protocolMessage.getBustaRawContent();
                        responseMessage = protocolMessage.getMessage();
                    }
                    msgDiag.highDebug("Tipo Messaggio Risposta dopo l'imbustamento (after-security) [" + responseMessage.getClass().getName() + "]");
                }
            }
            catch (Exception e) {
                if (msgResponse != null && !portaStateless && !routingStateless) {
                    try {
                        msgDiag.mediumDebug("Aggiornamento proprietario messaggio risposta ...");
                        msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    }
                    catch (Throwable errorOpenSPCoopMsg) {
                        // empty catch block
                    }
                }
                if (!(!functionAsRouter || identitaPdD.getTipo().equals(bustaRisposta.getTipoMittente()) && identitaPdD.getNome().equals(bustaRisposta.getMittente()))) {
                    msgDiag.logErroreGenerico(e, "imbustatore.after-security.addTrasmissione(risposta)");
                } else {
                    msgDiag.logErroreGenerico(e, "imbustatore.after-security-imbustamento(risposta)");
                }
                errorOpenSPCoopMsg = null;
                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                parametriGenerazioneBustaErrore.setIntegrationFunctionError(IntegrationFunctionError.INTEROPERABILITY_PROFILE_ENVELOPING_RESPONSE_FAILED);
                if (e != null && e instanceof ProtocolException && ((ProtocolException)e).isInteroperabilityError()) {
                    parametriGenerazioneBustaErrore.setErroreCooperazione(ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(e.getMessage()));
                    errorOpenSPCoopMsg = ricezioneBusteGeneratoreBustaErrore.generaBustaErroreValidazione(parametriGenerazioneBustaErrore);
                } else {
                    parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_526_GESTIONE_IMBUSTAMENTO));
                    errorOpenSPCoopMsg = ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                }
                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(parametriInvioBustaErrore);
                openspcoopstate.releaseResource();
                return;
            }
            msgDiag.mediumDebug("Tracciamento busta di risposta...");
            if (this.msgContext.isTracciamentoAbilitato()) {
                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioInviato();
                securityInfoResponse = null;
                if (!functionAsRouter && messageSecurityContext != null && messageSecurityContext.getDigestReader(responseMessage.getFactory()) != null) {
                    validazioneSemantica = protocolFactory.createValidazioneSemantica(openspcoopstate.getStatoRichiesta());
                    securityInfoResponse = validazioneSemantica.readSecurityInformation(messageSecurityContext.getDigestReader(responseMessage.getFactory()), responseMessage);
                }
                tracciamento.registraRisposta(responseMessage, securityInfoResponse, headerBustaRisposta, bustaRisposta, esitoTraccia, Tracciamento.createLocationString(false, this.msgContext.getSourceLocation()), correlazioneApplicativa, idCorrelazioneApplicativaRisposta);
            }
            validatoreErrori = protocolFactory.createValidatoreErrori(openspcoopstate.getStatoRichiesta());
            protocolManager = protocolFactory.createProtocolManager();
            pValidazioneErrori = new ProprietaValidazioneErrori();
            pValidazioneErrori.setIgnoraEccezioniNonGravi(protocolManager.isIgnoraEccezioniNonGravi());
            pValidazioneErrori.setVersioneProtocollo(versioneProtocollo);
            if (validatoreErrori.isBustaErrore(bustaRisposta, responseMessage, pValidazioneErrori)) {
                if (mittenteAnonimo) {
                    msgDiag.logPersonalizzato("generazioneMessaggioErroreRisposta.mittenteAnonimo");
                } else {
                    msgDiag.logPersonalizzato("generazioneMessaggioErroreRisposta");
                }
            } else if (mittenteAnonimo) {
                msgDiag.logPersonalizzato("generazioneMessaggioRisposta.mittenteAnonimo");
            } else {
                msgDiag.logPersonalizzato("generazioneMessaggioRisposta");
            }
            msgDiag.mediumDebug("Eliminazione accesso da PdD...");
            repositoryBuste.eliminaUtilizzoPdDFromOutBox(bustaRisposta.getID());
        }
        if (pa != null) {
            msgDiag.mediumDebug("Gestione header di integrazione messaggio di risposta...");
            headerIntegrazioneRisposta = new HeaderIntegrazione(idTransazione);
            headerIntegrazioneRisposta.setBusta(new HeaderIntegrazioneBusta());
            headerIntegrazioneRisposta.getBusta().setTipoMittente(bustaRichiesta.getTipoMittente());
            headerIntegrazioneRisposta.getBusta().setMittente(bustaRichiesta.getMittente());
            headerIntegrazioneRisposta.getBusta().setTipoDestinatario(bustaRichiesta.getTipoDestinatario());
            headerIntegrazioneRisposta.getBusta().setDestinatario(bustaRichiesta.getDestinatario());
            headerIntegrazioneRisposta.getBusta().setTipoServizio(bustaRichiesta.getTipoServizio());
            headerIntegrazioneRisposta.getBusta().setServizio(bustaRichiesta.getServizio());
            headerIntegrazioneRisposta.getBusta().setVersioneServizio(bustaRichiesta.getVersioneServizio());
            headerIntegrazioneRisposta.getBusta().setAzione(bustaRichiesta.getAzione());
            if (bustaRichiesta.getCollaborazione() != null) {
                headerIntegrazioneRisposta.getBusta().setIdCollaborazione(bustaRichiesta.getCollaborazione());
            } else if (bustaRisposta != null && bustaRisposta.getCollaborazione() != null) {
                headerIntegrazioneRisposta.getBusta().setIdCollaborazione(bustaRisposta.getCollaborazione());
            }
            headerIntegrazioneRisposta.getBusta().setID(bustaRichiesta.getID());
            headerIntegrazioneRisposta.getBusta().setProfiloDiCollaborazione(bustaRichiesta.getProfiloDiCollaborazione());
            headerIntegrazioneRisposta.setIdApplicativo(correlazioneApplicativa);
            tipiIntegrazionePA_response = null;
            msgDiag.mediumDebug("Header integrazione...");
            if (functionAsRouter) {
                msgDiag.highDebug("Header integrazione (Default gestori integrazione Router)");
                tipiIntegrazionePA_response = RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.containsKey(protocolFactory.getProtocol()) ? RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.get(protocolFactory.getProtocol()) : RicezioneBuste.defaultGestoriIntegrazionePA;
            } else {
                msgDiag.highDebug("Header integrazione (Gestori integrazione...)");
                if (pa != null && this.msgContext.isTracciamentoAbilitato()) {
                    msgDiag.mediumDebug("Lettura header di integrazione...");
                    try {
                        tipiIntegrazionePA_response = configurazionePdDReader.getTipiIntegrazione(pa);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "configurazionePdDReader.getTipiIntegrazione(pa)");
                        parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                        parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                        errorOpenSPCoopMsg = ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                        parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                        ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(parametriInvioBustaErrore);
                        openspcoopstate.releaseResource();
                        return;
                    }
                    msgDiag.highDebug("Header integrazione (Gestori integrazione terminato)");
                    if (tipiIntegrazionePA_response == null) {
                        tipiIntegrazionePA_response = RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.containsKey(protocolFactory.getProtocol()) != false ? RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.get(protocolFactory.getProtocol()) : RicezioneBuste.defaultGestoriIntegrazionePA;
                    }
                }
            }
            outResponsePAMessage = new OutResponsePAMessage();
            outResponsePAMessage.setBustaRichiesta(bustaRichiesta);
            outResponsePAMessage.setMessage(responseMessage);
            propertiesIntegrazioneRisposta = new HashMap<String, List<String>>();
            outResponsePAMessage.setHeaders(propertiesIntegrazioneRisposta);
            outResponsePAMessage.setPortaDelegata(pd);
            outResponsePAMessage.setPortaApplicativa(pa);
            outResponsePAMessage.setSoggettoMittente(soggettoFruitore);
            outResponsePAMessage.setServizio(idServizio);
            if (tipiIntegrazionePA_response != null) {
                for (i = 0; i < tipiIntegrazionePA_response.length; ++i) {
                    try {
                        gestore = null;
                        gestore = pluginLoader.newIntegrazionePortaApplicativa(tipiIntegrazionePA_response[i]);
                        if (gestore != null) {
                            classType = null;
                            try {
                                classType = gestore.getClass().getName();
                                AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                            }
                            catch (Exception e) {
                                throw new Exception("Riscontrato errore durante l'inizializzazione della classe [" + classType + "] da utilizzare per la gestione dell'integrazione delle erogazioni (Risposta Update/Delete) di tipo [" + tipiIntegrazionePA_response[i] + "]: " + e.getMessage());
                            }
                            if (gestore instanceof IGestoreIntegrazionePASoap) {
                                if (propertiesReader.deleteHeaderIntegrazioneResponsePA()) {
                                    if (responseMessage == null) {
                                        responseMessage = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)requestMessage.getFactory(), (MessageType)requestMessage.getMessageType(), (MessageRole)MessageRole.RESPONSE);
                                        outResponsePAMessage.setMessage(responseMessage);
                                    }
                                    gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePAMessage);
                                }
                                continue;
                            }
                            if (responseMessage == null) {
                                responseMessage = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)requestMessage.getFactory(), (MessageType)requestMessage.getMessageType(), (MessageRole)MessageRole.RESPONSE);
                                outResponsePAMessage.setMessage(responseMessage);
                            }
                            gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePAMessage);
                            continue;
                        }
                        throw new Exception("Gestore non inizializzato");
                    }
                    catch (Exception e) {
                        msgDiag.addKeyword("@TIPO_HEADER_INTEGRAZIONE@", tipiIntegrazionePA_response[i]);
                        msgDiag.addKeywordErroreProcessamento(e);
                        msgDiag.logPersonalizzato("headerIntegrazione.creazioneFallita");
                        RicezioneBuste.logError(logCore, msgDiag.getMessaggio_replaceKeywords("headerIntegrazione.creazioneFallita"), e);
                    }
                }
            }
            this.msgContext.setResponseHeaders(propertiesIntegrazioneRisposta);
        }
        if (oneWayStateless || sincronoStateless || asincronoStateless) {
            msgDiag.mediumDebug("Aggiorno proprietario messaggio richiesta ...");
            try {
                openspcoopstate.commit();
            }
            catch (Exception e) {
                RicezioneBuste.logError(logCore, "Riscontrato errore durante l'aggiornamento proprietario messaggio", e);
                msgDiag.logErroreGenerico(e, "openspcoopstate.commit(stateless risposta)");
                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
                errorOpenSPCoopMsg = ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(parametriInvioBustaErrore);
                openspcoopstate.releaseResource();
                return;
            }
        }
        if (oneWayVersione11) {
            msgDiag.mediumDebug("Commit della gestione oneWay stateful/stateless ibrido ...");
            try {
                openspcoopstate.commit();
            }
            catch (Exception e) {
                RicezioneBuste.logError(logCore, "Riscontrato errore durante il commit della gestione oneWay stateful/stateless ibrido", e);
                msgDiag.logErroreGenerico(e, "openspcoopstate.commit(oneway1.1 risposta)");
                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
                errorOpenSPCoopMsg = ricezioneBusteGeneratoreBustaErrore.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                ricezioneBusteGeneratoreBustaErrore.sendRispostaBustaErrore(parametriInvioBustaErrore);
                openspcoopstate.releaseResource();
                return;
            }
        }
        if (!portaStateless && !routingStateless) {
            msgDiag.mediumDebug("Aggiornamento proprietario messaggio...");
            if (msgResponse != null) {
                msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
            }
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della risposta...");
            openspcoopstate.commit();
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable("RicezioneBuste", "risposta");
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable("RicezioneBuste", "risposta", idMessageRequest, functionAsRouter);
            }
        }
        msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta effettuato, rilascio della connessione...");
        openspcoopstate.releaseResource();
        msgDiag.mediumDebug("Imposto risposta nel context...");
        this.msgContext.setMessageResponse(responseMessage);
        msgDiag.mediumDebug("Lavoro Terminato.");
    }

    private boolean gestioneRispostaAsincrona_checkPresenzaRichiesta(long scadenzaControllo, int checkInterval, Busta bustaRichiesta, IOpenSPCoopState openspcoopstate, MsgDiagnostico msgDiag, boolean newConnectionForResponse, PdDContext pddContext) throws Exception {
        boolean attendiTerminazioneRichiesta = false;
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME));
        boolean isRicevutaRichiesta = false;
        boolean isRicevutaRisposta = false;
        if (newConnectionForResponse && (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) && bustaRichiesta.getRiferimentoMessaggio() != null) {
            org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta(), protocolFactory);
            isRicevutaRichiesta = profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRichiesta.getRiferimentoMessaggio());
            isRicevutaRisposta = profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRichiesta.getRiferimentoMessaggio());
        }
        while (DateManager.getTimeMillis() < scadenzaControllo) {
            GestoreMessaggi checkRichiesta;
            String idRichiesta;
            msgDiag.mediumDebug("RICHIESTA  NOW[" + DateManager.getTimeMillis() + "] < SCADENZA[" + scadenzaControllo + "]");
            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRichiesta == null) {
                    idRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRichiesta = (checkRichiesta = new GestoreMessaggi(openspcoopstate, false, idRichiesta, "OUTBOX", msgDiag, pddContext)).existsMessageInProcessamento())) {
                    break;
                }
            } else {
                if (!ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRichiesta == null) {
                    idRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRichiesta = (checkRichiesta = new GestoreMessaggi(openspcoopstate, false, idRichiesta, "INBOX", msgDiag, pddContext)).existsMessageInProcessamento())) break;
            }
            if (bustaRichiesta.getProfiloDiCollaborazione() != null) {
                msgDiag.mediumDebug("Busta di risposta con profilo [" + bustaRichiesta.getProfiloDiCollaborazione().getEngineValue() + "] non gestibile, si attende il completamento della gestione della richiesta");
            } else {
                msgDiag.mediumDebug("Busta di risposta con profilo null?? non gestibile, si attende il completamento della gestione della richiesta");
            }
            Utilities.sleep((long)checkInterval);
        }
        return attendiTerminazioneRichiesta;
    }

    private boolean gestioneRispostaAsincrona_checkPresenzaRicevutaRichiesta(long scadenzaControllo, int checkInterval, Busta bustaRichiesta, IOpenSPCoopState openspcoopstate, MsgDiagnostico msgDiag, boolean newConnectionForResponse, PdDContext pddContext) throws Exception {
        boolean attendiTerminazioneRicevutaRichiesta = false;
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME));
        boolean isRicevutaRichiesta = false;
        boolean isRicevutaRisposta = false;
        if (newConnectionForResponse && (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) && bustaRichiesta.getRiferimentoMessaggio() != null) {
            org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta(), protocolFactory);
            isRicevutaRichiesta = profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRichiesta.getRiferimentoMessaggio());
            isRicevutaRisposta = profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRichiesta.getRiferimentoMessaggio());
        }
        while (DateManager.getTimeMillis() < scadenzaControllo) {
            GestoreMessaggi checkRicevutaRichiesta;
            String idRicevutaRichiesta;
            msgDiag.mediumDebug("RICEVUTA RICHIESTA  NOW[" + DateManager.getTimeMillis() + "] < SCADENZA[" + scadenzaControllo + "]");
            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRicevutaRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRicevutaRichiesta == null) {
                    idRicevutaRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRicevutaRichiesta = (checkRicevutaRichiesta = new GestoreMessaggi(openspcoopstate, false, idRicevutaRichiesta, "INBOX", msgDiag, pddContext)).existsMessageInProcessamentoByReference())) {
                    break;
                }
            } else {
                if (!ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRicevutaRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRicevutaRichiesta == null) {
                    idRicevutaRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRicevutaRichiesta = (checkRicevutaRichiesta = new GestoreMessaggi(openspcoopstate, false, idRicevutaRichiesta, "OUTBOX", msgDiag, pddContext)).existsMessageInProcessamentoByReference())) break;
            }
            if (bustaRichiesta.getProfiloDiCollaborazione() != null) {
                msgDiag.mediumDebug("Busta di risposta con profilo [" + bustaRichiesta.getProfiloDiCollaborazione().getEngineValue() + "] non gestibile, si attende il completamento della gestione della ricevuta alla richiesta");
            } else {
                msgDiag.mediumDebug("Busta di risposta con profilo null??? non gestibile, si attende il completamento della gestione della ricevuta alla richiesta");
            }
            Utilities.sleep((long)checkInterval);
        }
        return attendiTerminazioneRicevutaRichiesta;
    }

    private EsitoLib chiamaLibreria(OpenSPCoopStateless openspcoopstate, Logger log) throws OpenSPCoopStateException, GenericLibException {
        if (openspcoopstate.getDestinatarioRequestMsgLib().startsWith("Sbustamento")) {
            Sbustamento lib = new Sbustamento(log);
            return lib.onMessage(openspcoopstate);
        }
        if (openspcoopstate.getDestinatarioRequestMsgLib().startsWith("ConsegnaContenutiApplicativi")) {
            ConsegnaContenutiApplicativi lib = new ConsegnaContenutiApplicativi(log);
            EsitoLib result = lib.onMessage(openspcoopstate);
            if (result.getStatoInvocazione() == 1) {
                openspcoopstate.setDestinatarioRequestMsgLib("");
            }
            return result;
        }
        if (openspcoopstate.getDestinatarioResponseMsgLib().startsWith("ImbustamentoRisposte")) {
            ImbustamentoRisposte lib = new ImbustamentoRisposte(log);
            return lib.onMessage(openspcoopstate);
        }
        if (openspcoopstate.getDestinatarioResponseMsgLib().startsWith("InoltroRisposte")) {
            InoltroRisposte lib = new InoltroRisposte(log);
            return lib.onMessage(openspcoopstate);
        }
        throw new OpenSPCoopStateException("RicezioneBuste.chiamaLibreria: nome libreria non valido");
    }

    private IDServizio getIdServizioPerAutorizzazione(IDServizio idServizio, IDSoggetto soggettoFruitore, boolean functionAsRouter, Busta bustaRichiesta, RuoloBusta ruoloBustaRicevuta) throws Exception {
        IDSoggetto soggettoDestinatarioPerAutorizzazione = null;
        if (functionAsRouter) {
            soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
        } else if (ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
            soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
        } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
            if (ruoloBustaRicevuta == null) {
                soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
            } else if (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
            } else {
                if (soggettoFruitore == null) {
                    throw new Exception("Soggetto fruitore non identificato");
                }
                soggettoDestinatarioPerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
            }
        } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
            if (ruoloBustaRicevuta == null) {
                soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
            } else if (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
            } else {
                if (soggettoFruitore == null) {
                    throw new Exception("Soggetto fruitore non identificato");
                }
                soggettoDestinatarioPerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
            }
        } else {
            soggettoDestinatarioPerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
        }
        IDServizio idServizioPerAutorizzazione = IDServizioFactory.getInstance().getIDServizioFromValues(idServizio.getTipo(), idServizio.getNome(), soggettoDestinatarioPerAutorizzazione, idServizio.getVersione().intValue());
        idServizioPerAutorizzazione.setUriAccordoServizioParteComune(idServizio.getUriAccordoServizioParteComune());
        idServizioPerAutorizzazione.setAzione(idServizio.getAzione());
        idServizioPerAutorizzazione.setTipologia(idServizio.getTipologia());
        return idServizioPerAutorizzazione;
    }

    private IDSoggetto getIDSoggettoMittentePerAutorizzazione(IDServizio idServizio, IDSoggetto soggettoFruitore, boolean functionAsRouter, Busta bustaRichiesta, RuoloBusta ruoloBustaRicevuta, boolean supportatoAutenticazioneSoggetti) throws Exception {
        IDSoggetto soggettoMittentePerAutorizzazione = null;
        if (functionAsRouter) {
            if (soggettoFruitore == null) {
                throw new Exception("Soggetto fruitore non identificato");
            }
            soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
        } else if (ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
            if (soggettoFruitore == null) {
                if (supportatoAutenticazioneSoggetti) {
                    return null;
                }
                throw new Exception("Soggetto fruitore non identificato");
            }
            soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
        } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
            if (ruoloBustaRicevuta == null) {
                if (soggettoFruitore == null) {
                    if (supportatoAutenticazioneSoggetti) {
                        return null;
                    }
                    throw new Exception("Soggetto fruitore non identificato");
                }
                soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
            } else if (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                if (soggettoFruitore == null) {
                    if (supportatoAutenticazioneSoggetti) {
                        return null;
                    }
                    throw new Exception("Soggetto fruitore non identificato");
                }
                soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
            } else {
                soggettoMittentePerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
            }
        } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
            if (ruoloBustaRicevuta == null) {
                if (soggettoFruitore == null) {
                    if (supportatoAutenticazioneSoggetti) {
                        return null;
                    }
                    throw new Exception("Soggetto fruitore non identificato");
                }
                soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
            } else if (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                if (soggettoFruitore == null) {
                    if (supportatoAutenticazioneSoggetti) {
                        return null;
                    }
                    throw new Exception("Soggetto fruitore non identificato");
                }
                soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
            } else {
                soggettoMittentePerAutorizzazione = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta());
            }
        } else {
            if (soggettoFruitore == null) {
                if (supportatoAutenticazioneSoggetti) {
                    return null;
                }
                throw new Exception("Soggetto fruitore non identificato");
            }
            soggettoMittentePerAutorizzazione = new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta());
        }
        return soggettoMittentePerAutorizzazione;
    }

    private void overwriteIdSoggetto(IDServizio idServizio, IDSoggetto idSoggetto) {
        idServizio.setSoggettoErogatore(idSoggetto);
    }

    private void cleanDatiServizio(IDServizio idServizio) {
        idServizio.setVersione(null);
        idServizio.setNome(null);
        idServizio.setTipo(null);
    }
}

