/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.EJBUtils;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.Sbustamento;
import org.openspcoop2.pdd.services.core.RicezioneBusteContext;
import org.openspcoop2.pdd.services.core.RicezioneBusteParametriGenerazioneBustaErrore;
import org.openspcoop2.pdd.services.core.RicezioneBusteParametriInvioBustaErrore;
import org.openspcoop2.pdd.services.error.AbstractErrorGenerator;
import org.openspcoop2.pdd.services.error.RicezioneBusteExternalErrorGenerator;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.driver.History;
import org.openspcoop2.protocol.engine.driver.IFiltroDuplicati;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.validator.Validatore;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.SecurityInfo;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.tracciamento.EsitoElaborazioneMessaggioTracciato;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSemantica;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class RicezioneBusteGeneratoreBustaErrore {
    private RicezioneBusteContext msgContext;
    private RicezioneBusteExternalErrorGenerator generatoreErrore;

    public RicezioneBusteGeneratoreBustaErrore(RicezioneBusteContext msgContext, RicezioneBusteExternalErrorGenerator generatoreErrore) {
        this.msgContext = msgContext;
        this.generatoreErrore = generatoreErrore;
    }

    public OpenSPCoop2Message generaBustaErroreProcessamento(RicezioneBusteParametriGenerazioneBustaErrore parametriGenerazioneBustaErrore, Exception e) {
        parametriGenerazioneBustaErrore.setErroreProcessamento(true);
        parametriGenerazioneBustaErrore.setEccezioneProcessamento(e);
        return this.generaBustaErrore(parametriGenerazioneBustaErrore, false);
    }

    public OpenSPCoop2Message generaBustaErroreValidazione(RicezioneBusteParametriGenerazioneBustaErrore parametriGenerazioneBustaErrore) {
        parametriGenerazioneBustaErrore.setErroreProcessamento(false);
        return this.generaBustaErrore(parametriGenerazioneBustaErrore, true);
    }

    public OpenSPCoop2Message generaBustaErrore(RicezioneBusteParametriGenerazioneBustaErrore parametriGenerazioneBustaErrore, boolean erroreValidazione) {
        PdDContext pddContext = this.msgContext.getPddContext();
        String idTransazione = (String)pddContext.getObject(Costanti.ID_TRANSAZIONE);
        try {
            IntegrationFunctionError integrationFunctionError = parametriGenerazioneBustaErrore.getIntegrationFunctionError(pddContext, erroreValidazione);
            OpenSPCoop2Message responseErrorMessage = null;
            ErroreCooperazione erroreCooperazione = parametriGenerazioneBustaErrore.getErroreCooperazione();
            ErroreIntegrazione erroreIntegrazione = parametriGenerazioneBustaErrore.getErroreIntegrazione();
            List<Eccezione> error = parametriGenerazioneBustaErrore.getError();
            Map<String, Object> securityPropertiesResponse = null;
            if (parametriGenerazioneBustaErrore.getFlowPropertiesResponse() != null && parametriGenerazioneBustaErrore.getFlowPropertiesResponse().messageSecurity != null) {
                securityPropertiesResponse = parametriGenerazioneBustaErrore.getFlowPropertiesResponse().messageSecurity.getFlowParameters();
            }
            MessageSecurityContext messageSecurityContext = parametriGenerazioneBustaErrore.getMessageSecurityContext();
            OpenSPCoop2Properties propertiesReader = parametriGenerazioneBustaErrore.getPropertiesReader();
            String profiloGestione = parametriGenerazioneBustaErrore.getProfiloGestione();
            String implementazionePdDMittente = parametriGenerazioneBustaErrore.getImplementazionePdDMittente();
            Tracciamento tracciamento = parametriGenerazioneBustaErrore.getTracciamento();
            MsgDiagnostico msgDiag = parametriGenerazioneBustaErrore.getMsgDiag();
            Integrazione integrazione = parametriGenerazioneBustaErrore.getIntegrazione();
            if (integrazione == null) {
                integrazione = new Integrazione();
                integrazione.setIdModuloInAttesa(this.msgContext.getIdModulo());
            }
            IOpenSPCoopState openspcoopState = parametriGenerazioneBustaErrore.getOpenspcoop();
            this.generatoreErrore.updateState(openspcoopState.getStatoRichiesta());
            if (parametriGenerazioneBustaErrore.isErroreProcessamento()) {
                responseErrorMessage = erroreCooperazione != null ? this.generatoreErrore.buildErroreProtocollo_Processamento(integrationFunctionError, parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, erroreCooperazione, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDBAttesaAttiva(), propertiesReader.getGestioneSerializableDBCheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), parametriGenerazioneBustaErrore.getEccezioneProcessamento(), this.msgContext.getPddContext()) : (erroreIntegrazione != null ? this.generatoreErrore.buildErroreProtocollo_Processamento(integrationFunctionError, parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, erroreIntegrazione, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDBAttesaAttiva(), propertiesReader.getGestioneSerializableDBCheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), parametriGenerazioneBustaErrore.getEccezioneProcessamento(), this.msgContext.getPddContext()) : this.generatoreErrore.buildErroreProtocollo_Processamento(integrationFunctionError, parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, error, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDBAttesaAttiva(), propertiesReader.getGestioneSerializableDBCheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), parametriGenerazioneBustaErrore.getEccezioneProcessamento(), this.msgContext.getPddContext()));
            } else if (erroreCooperazione != null) {
                responseErrorMessage = this.generatoreErrore.buildErroreProtocollo_Intestazione(integrationFunctionError, parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, erroreCooperazione, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDBAttesaAttiva(), propertiesReader.getGestioneSerializableDBCheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), this.msgContext.getPddContext());
            } else {
                if (erroreIntegrazione != null) {
                    throw new CoreException("Method 'generaBustaErroreValidazione' not supported for MessaggioErroreIntegrazione");
                }
                responseErrorMessage = this.generatoreErrore.buildErroreProtocollo_Intestazione(integrationFunctionError, parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, error, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDBAttesaAttiva(), propertiesReader.getGestioneSerializableDBCheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), this.msgContext.getPddContext());
            }
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject(Costanti.PROTOCOL_NAME));
            if (this.msgContext.isTracciamentoAbilitato()) {
                EsitoElaborazioneMessaggioTracciato esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioInviato();
                SecurityInfo securityInfoResponse = null;
                boolean functionAsRouter = false;
                if (functionAsRouter && messageSecurityContext != null && messageSecurityContext.getDigestReader(responseErrorMessage.getFactory()) != null) {
                    IValidazioneSemantica validazioneSemantica = protocolFactory.createValidazioneSemantica(openspcoopState.getStatoRichiesta());
                    securityInfoResponse = validazioneSemantica.readSecurityInformation(messageSecurityContext.getDigestReader(responseErrorMessage.getFactory()), responseErrorMessage);
                }
                Validatore v = new Validatore(responseErrorMessage, (Context)this.msgContext.getPddContext(), openspcoopState.getStatoRichiesta(), parametriGenerazioneBustaErrore.getLogCore(), protocolFactory);
                tracciamento.registraRisposta(responseErrorMessage, securityInfoResponse, v.getHeaderProtocollo_senzaControlli(), parametriGenerazioneBustaErrore.getBusta(), esitoTraccia, Tracciamento.createLocationString(false, this.msgContext.getSourceLocation()), parametriGenerazioneBustaErrore.getCorrelazioneApplicativa(), parametriGenerazioneBustaErrore.getCorrelazioneApplicativaRisposta());
            }
            msgDiag.addKeywords(parametriGenerazioneBustaErrore.getBusta(), false);
            IProtocolManager protocolManager = protocolFactory.createProtocolManager();
            if (!protocolManager.getKeywordMittenteSconosciuto().equals(parametriGenerazioneBustaErrore.getBusta().getDestinatario()) && !protocolManager.getKeywordTipoMittenteSconosciuto().equals(parametriGenerazioneBustaErrore.getBusta().getTipoDestinatario())) {
                if (parametriGenerazioneBustaErrore.getBusta().getDestinatario() == null && parametriGenerazioneBustaErrore.getBusta().getTipoDestinatario() == null) {
                    msgDiag.logPersonalizzato("generazioneMessaggioErroreRisposta.mittenteAnonimo");
                } else {
                    msgDiag.logPersonalizzato("generazioneMessaggioErroreRisposta");
                }
            } else {
                msgDiag.logPersonalizzato("generazioneMessaggioErroreRisposta.destinatarioSconosciuto");
            }
            msgDiag.setIdMessaggioRisposta(parametriGenerazioneBustaErrore.getBusta().getID());
            this.msgContext.getProtocol().setIdRisposta(parametriGenerazioneBustaErrore.getBusta().getID());
            if (parametriGenerazioneBustaErrore.getParseException() != null) {
                responseErrorMessage.setParseException(parametriGenerazioneBustaErrore.getParseException());
            }
            return responseErrorMessage;
        }
        catch (Exception e) {
            return this.generatoreErrore.buildFault(e, (Context)pddContext);
        }
    }

    public void sendRispostaBustaErrore(RicezioneBusteParametriInvioBustaErrore parametriInvioBustaErrore) {
        this.sendRispostaBustaErrore(parametriInvioBustaErrore, true);
    }

    public void sendRispostaBustaErrore(RicezioneBusteParametriInvioBustaErrore parametriInvioBustaErrore, boolean eliminaMessaggioRicevuto) {
        GestoreMessaggi msgResponse = null;
        RepositoryBuste repositoryBuste = null;
        boolean httpReply = true;
        IOpenSPCoopState openspcoop = parametriInvioBustaErrore.getOpenspcoop();
        Busta bustaRisposta = parametriInvioBustaErrore.getBusta();
        MsgDiagnostico msgDiag = parametriInvioBustaErrore.getMsgDiag();
        Logger logCore = parametriInvioBustaErrore.getLogCore();
        PdDContext pddContext = parametriInvioBustaErrore.getPddContext();
        RequestInfo requestInfo = (RequestInfo)pddContext.getObject(Costanti.REQUEST_INFO);
        try {
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME));
            if (eliminaMessaggioRicevuto && parametriInvioBustaErrore.isOnewayVersione11()) {
                GestoreMessaggi msgRichiesta = new GestoreMessaggi(openspcoop, true, bustaRisposta.getRiferimentoMessaggio(), "INBOX", logCore, msgDiag, pddContext);
                msgRichiesta.setReadyForDrop(true);
                msgRichiesta.aggiornaProprietarioMessaggio("GestoreMessaggi");
                RepositoryBuste repositoryBustaRichiesta = new RepositoryBuste(openspcoop.getStatoRichiesta(), true, protocolFactory);
                repositoryBustaRichiesta.eliminaBustaStatelessFromInBox(bustaRisposta.getRiferimentoMessaggio());
            }
            if (parametriInvioBustaErrore.isNewConnectionForResponse()) {
                httpReply = false;
            }
            if (bustaRisposta.getIndirizzoDestinatario() != null && parametriInvioBustaErrore.isUtilizzoIndirizzoTelematico()) {
                httpReply = false;
            }
            if (!httpReply) {
                repositoryBuste = new RepositoryBuste(openspcoop.getStatoRisposta(), false, protocolFactory);
                repositoryBuste.registraBustaIntoOutBox(bustaRisposta, parametriInvioBustaErrore.getPropertiesReader().getRepositoryIntervalloScadenzaMessaggi());
                Integrazione infoIntegrazione = new Integrazione();
                repositoryBuste.aggiornaInfoIntegrazioneIntoOutBox(bustaRisposta.getID(), infoIntegrazione);
                msgResponse = new GestoreMessaggi(openspcoop, true, bustaRisposta.getID(), "OUTBOX", msgDiag, pddContext);
                msgResponse.setOneWayVersione11(parametriInvioBustaErrore.isOnewayVersione11());
                msgResponse.registraMessaggio(parametriInvioBustaErrore.getOpenspcoopMsg(), parametriInvioBustaErrore.getCorrelazioneApplicativa(), parametriInvioBustaErrore.getCorrelazioneApplicativaRisposta());
                msgResponse.aggiornaRiferimentoMessaggio(bustaRisposta.getRiferimentoMessaggio());
                msgResponse.aggiornaProprietarioMessaggio("InoltroRisposte");
                EJBUtils ejb = new EJBUtils(parametriInvioBustaErrore.getIdentitaPdD(), this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), bustaRisposta.getRiferimentoMessaggio(), bustaRisposta.getID(), "OUTBOX", openspcoop, msgDiag, parametriInvioBustaErrore.isFunctionAsRouter(), parametriInvioBustaErrore.getImplementazionePdDMittente(), parametriInvioBustaErrore.getImplementazionePdDDestinatario(), parametriInvioBustaErrore.getProfiloGestione(), parametriInvioBustaErrore.getPddContext());
                ejb.sendToInoltroRisposte(bustaRisposta, false, null, msgResponse, parametriInvioBustaErrore.getCorrelazioneApplicativa(), parametriInvioBustaErrore.getCorrelazioneApplicativaRisposta(), parametriInvioBustaErrore.getServizioApplicativoFruitore(), false);
                OpenSPCoop2Message soapBodyEmpty = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getProtocolRequestMessageType(), (MessageRole)MessageRole.RESPONSE);
                this.msgContext.setMessageResponse(soapBodyEmpty);
            } else {
                OpenSPCoop2Message risposta = parametriInvioBustaErrore.getOpenspcoopMsg();
                this.msgContext.setMessageResponse(risposta);
            }
            openspcoop.commit();
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable("RicezioneBuste", "risposta verso nuova connessione");
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable("RicezioneBuste", "risposta verso nuova connessione", bustaRisposta.getRiferimentoMessaggio(), parametriInvioBustaErrore.isFunctionAsRouter());
            }
        }
        catch (Exception e) {
            IntegrationFunctionError integrationFunctionError = AbstractErrorGenerator.getIntegrationInternalError(pddContext);
            msgDiag.logErroreGenerico(e, "sendRispostaBustaErrore");
            this.msgContext.setMessageResponse(this.generatoreErrore.buildErroreProcessamento(pddContext, integrationFunctionError, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
        }
    }

    public OpenSPCoop2Message generaRispostaMsgGiaRicevuto(boolean printMsg, Busta bustaRichiesta, Integrazione integrazione, MsgDiagnostico msgDiag, OpenSPCoopState openspcoopstate, Logger log, OpenSPCoop2Properties properties, String profiloGestione, RuoloBusta ruoloBustaRicevuta, String implementazionePdDMittente, IProtocolFactory<?> protocolFactory, IDSoggetto identitaPdD, String idTransazione, Loader loader, boolean oneWayVersione11, String implementazionePdDSoggettoMittente, Tracciamento tracciamento, String idCorrelazioneApplicativa, PdDContext pddContext, IntegrationFunctionError integrationFunctionError) throws ProtocolException, TracciamentoException {
        ArrayList<Eccezione> v;
        RepositoryBuste repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRichiesta(), true, protocolFactory);
        History historyBuste = new History(openspcoopstate.getStatoRichiesta(), log);
        Busta bustaHTTPReply = null;
        IProtocolVersionManager protocolManager = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject(Costanti.PROTOCOL_NAME)).createProtocolVersionManager(profiloGestione);
        RequestInfo requestInfo = (RequestInfo)this.msgContext.getPddContext().getObject(Costanti.REQUEST_INFO);
        boolean consegnaAffidabile = false;
        switch (protocolManager.getConsegnaAffidabile(bustaRichiesta)) {
            case ABILITATA: {
                consegnaAffidabile = true;
                break;
            }
            case DISABILITATA: {
                consegnaAffidabile = false;
                break;
            }
            default: {
                consegnaAffidabile = properties.isGestioneRiscontri(implementazionePdDMittente) && bustaRichiesta.isConfermaRicezione();
            }
        }
        try {
            IFiltroDuplicati gestoreFiltroDuplicati = Sbustamento.getGestoreFiltroDuplicati(properties, loader, openspcoopstate, this.msgContext.getPddContext(), historyBuste, repositoryBuste, oneWayVersione11);
            boolean oldGestioneConnessione = false;
            boolean rinegozia = false;
            if (gestoreFiltroDuplicati.releaseRuntimeResourceBeforeCheck() && !openspcoopstate.resourceReleased()) {
                rinegozia = true;
                msgDiag.mediumDebug("Rilascio connessione al database prima di verificare se la richiesta \u00e8 duplicata ...");
                oldGestioneConnessione = openspcoopstate.isUseConnection();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.commit();
                openspcoopstate.releaseResource();
            }
            gestoreFiltroDuplicati.isDuplicata(protocolFactory, bustaRichiesta.getID());
            if (printMsg) {
                msgDiag.logPersonalizzato("sbustamentoBusta.", "ricezioneBustaDuplicata.count");
            }
            gestoreFiltroDuplicati.incrementaNumeroDuplicati(protocolFactory, bustaRichiesta.getID());
            if (gestoreFiltroDuplicati.releaseRuntimeResourceBeforeCheck() && rinegozia) {
                msgDiag.mediumDebug("Rinegozio connessione dopo la verifica di richiesta duplicata ...");
                this.rinegoziazioneConnessione(openspcoopstate, idTransazione, oldGestioneConnessione);
            }
            openspcoopstate.commit();
        }
        catch (Exception e) {
            log.error("Aggiornamento numero duplicati per busta [" + bustaRichiesta.getID() + "] non riuscito: " + e.getMessage(), (Throwable)e);
        }
        if (printMsg) {
            msgDiag.logPersonalizzato("sbustamentoBusta.", "ricezioneBustaDuplicata");
        }
        Imbustamento imbustatore = new Imbustamento(log, protocolFactory, openspcoopstate.getStatoRichiesta());
        boolean http200 = true;
        if (ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) && consegnaAffidabile) {
            msgDiag.logPersonalizzato("generazioneRiscontro");
            TipoOraRegistrazione tipoOraRegistrazione = properties.getTipoTempoBusta(implementazionePdDMittente);
            bustaHTTPReply = bustaRichiesta.invertiBusta(tipoOraRegistrazione, protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
            String idBustaRisposta = imbustatore.buildID(identitaPdD, idTransazione, properties.getGestioneSerializableDBAttesaAttiva(), properties.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
            bustaHTTPReply.setID(idBustaRisposta);
            Riscontro r = new Riscontro();
            r.setID(bustaRichiesta.getID());
            r.setOraRegistrazione(DateManager.getDate());
            r.setTipoOraRegistrazione(properties.getTipoTempoBusta(implementazionePdDMittente));
            bustaHTTPReply.addRiscontro(r);
        } else if (!(!ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || properties.isGestioneRiscontri(implementazionePdDMittente) && bustaRichiesta.isConfermaRicezione() || !protocolManager.isGenerazioneErroreMessaggioOnewayDuplicato() && !properties.isGenerazioneErroreProtocolloFiltroDuplicati(implementazionePdDMittente))) {
            http200 = false;
            String idBustaRisposta = imbustatore.buildID(identitaPdD, idTransazione, properties.getGestioneSerializableDBAttesaAttiva(), properties.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
            v = new ArrayList<Eccezione>();
            v.add(Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), protocolFactory));
            bustaHTTPReply = this.generatoreErrore.getImbustamentoErrore().buildMessaggioErroreProtocollo_Validazione(v, bustaRichiesta, idBustaRisposta, properties.getTipoTempoBusta(implementazionePdDSoggettoMittente));
            if (!identitaPdD.getNome().equals(bustaHTTPReply.getMittente()) || !identitaPdD.getTipo().equals(bustaHTTPReply.getTipoMittente())) {
                bustaHTTPReply.setMittente(identitaPdD.getNome());
                bustaHTTPReply.setTipoMittente(identitaPdD.getTipo());
                bustaHTTPReply.setIdentificativoPortaMittente(identitaPdD.getCodicePorta());
                bustaHTTPReply.setIndirizzoMittente(null);
            }
        } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
            String ricevuta = null;
            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    ricevuta = "ricevuta di una richiesta asincrona simmetrica";
                } else if (ruoloBustaRicevuta != null && RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    ricevuta = "ricevuta di una risposta asincrona simmetrica";
                }
            } else if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                ricevuta = "ricevuta di una richiesta asincrona asimmetrica";
            } else if (ruoloBustaRicevuta != null && RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                ricevuta = "ricevuta di una risposta asincrona asimmetrica";
            }
            if (ricevuta != null) {
                msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", ricevuta);
                msgDiag.logPersonalizzato("generazioneRicevutaAsincrona");
                TipoOraRegistrazione tipoOraRegistrazione = properties.getTipoTempoBusta(implementazionePdDMittente);
                bustaHTTPReply = bustaRichiesta.invertiBusta(tipoOraRegistrazione, protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                bustaHTTPReply.setVersioneServizio(bustaRichiesta.getVersioneServizio());
                bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                bustaHTTPReply.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                if (properties.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                    bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                }
                String idBustaRisposta = imbustatore.buildID(identitaPdD, idTransazione, properties.getGestioneSerializableDBAttesaAttiva(), properties.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
                bustaHTTPReply.setID(idBustaRisposta);
            }
        } else if (protocolManager.isGenerazioneErroreMessaggioOnewayDuplicato() || properties.isGenerazioneErroreProtocolloFiltroDuplicati(implementazionePdDMittente)) {
            http200 = false;
            String idBustaRisposta = imbustatore.buildID(identitaPdD, idTransazione, properties.getGestioneSerializableDBAttesaAttiva(), properties.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
            v = new ArrayList();
            v.add(Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), protocolFactory));
            bustaHTTPReply = this.generatoreErrore.getImbustamentoErrore().buildMessaggioErroreProtocollo_Validazione(v, bustaRichiesta, idBustaRisposta, properties.getTipoTempoBusta(implementazionePdDSoggettoMittente));
            if (!identitaPdD.getNome().equals(bustaHTTPReply.getMittente()) || !identitaPdD.getTipo().equals(bustaHTTPReply.getTipoMittente())) {
                bustaHTTPReply.setMittente(identitaPdD.getNome());
                bustaHTTPReply.setTipoMittente(identitaPdD.getTipo());
                bustaHTTPReply.setIdentificativoPortaMittente(identitaPdD.getCodicePorta());
                bustaHTTPReply.setIndirizzoMittente(null);
            }
        }
        if (bustaHTTPReply == null) {
            return MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getProtocolRequestMessageType(), (MessageRole)MessageRole.RESPONSE);
        }
        OpenSPCoop2Message msg = null;
        msg = http200 ? MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getProtocolRequestMessageType(), (MessageRole)MessageRole.RESPONSE) : this.generatoreErrore.buildErroreIntestazione(pddContext, integrationFunctionError);
        ProtocolMessage protocolMessage = imbustatore.imbustamentoRisposta(msg, (Context)pddContext, bustaHTTPReply, bustaRichiesta, integrazione, false, false, null, FaseImbustamento.PRIMA_SICUREZZA_MESSAGGIO);
        if (protocolMessage != null && !protocolMessage.isPhaseUnsupported()) {
            msg = protocolMessage.getMessage();
        }
        if ((protocolMessage = imbustatore.imbustamentoRisposta(msg, (Context)pddContext, bustaHTTPReply, bustaRichiesta, integrazione, false, false, null, FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO)) != null && !protocolMessage.isPhaseUnsupported()) {
            msg = protocolMessage.getMessage();
        }
        if (this.msgContext.isTracciamentoAbilitato()) {
            EsitoElaborazioneMessaggioTracciato esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioInviato();
            SecurityInfo securityInfoResponse = null;
            Validatore v2 = new Validatore(msg, (Context)this.msgContext.getPddContext(), openspcoopstate.getStatoRichiesta(), log, protocolFactory);
            tracciamento.registraRisposta(msg, securityInfoResponse, v2.getHeaderProtocollo_senzaControlli(), bustaHTTPReply, esitoTraccia, Tracciamento.createLocationString(false, this.msgContext.getSourceLocation()), idCorrelazioneApplicativa, null);
        }
        return msg;
    }

    private void rinegoziazioneConnessione(OpenSPCoopState openspcoopstate, String idTransazione, boolean oldGestioneConnessione) throws ProtocolException {
        try {
            openspcoopstate.updateResource(idTransazione);
            openspcoopstate.setUseConnection(oldGestioneConnessione);
        }
        catch (Exception e) {
            throw new ProtocolException("Rinegoziazione connessione dopo la verifica di richiesta duplicata fallita: " + e.getMessage(), (Throwable)e);
        }
    }
}

