/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.dynamic.PddPluginLoader;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.GestoreMessaggiException;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.ProtocolContext;
import org.openspcoop2.pdd.core.autorizzazione.container.AutorizzazioneHttpServletRequest;
import org.openspcoop2.pdd.core.autorizzazione.container.IAutorizzazioneSecurityContainer;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.credenziali.IGestoreCredenziali;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InRequestContext;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePD;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePDSoap;
import org.openspcoop2.pdd.core.integrazione.OutResponsePDMessage;
import org.openspcoop2.pdd.core.node.INodeReceiver;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.node.NodeTimeoutException;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.Imbustamento;
import org.openspcoop2.pdd.mdb.ImbustamentoMessage;
import org.openspcoop2.pdd.mdb.InoltroBuste;
import org.openspcoop2.pdd.mdb.SbustamentoRisposte;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.services.core.RicezioneContenutiApplicativiContext;
import org.openspcoop2.pdd.services.core.RicezioneContenutiApplicativiGestioneRisposta;
import org.openspcoop2.pdd.services.core.RicezioneContenutiApplicativiMessage;
import org.openspcoop2.pdd.services.error.AbstractErrorGenerator;
import org.openspcoop2.pdd.services.error.RicezioneContenutiApplicativiInternalErrorGenerator;
import org.openspcoop2.pdd.services.skeleton.IntegrationManager;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerThresholdThread;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.dump.DumpException;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class RicezioneContenutiApplicativi {
    public static final String ID_MODULO = "RicezioneContenutiApplicativi";
    public static boolean initializeService = false;
    private static String[] defaultGestoriIntegrazionePD = null;
    private static ConcurrentHashMap<String, String[]> defaultPerProtocolloGestoreIntegrazionePD = null;
    private static String[] tipiGestoriCredenziali = null;
    private RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore;
    private RicezioneContenutiApplicativiContext msgContext;

    private static void logDebug(Logger logCore, String msg) {
        logCore.debug(msg);
    }

    private static void logDebug(Logger logCore, String msg, Throwable e) {
        logCore.debug(msg, e);
    }

    private static void logInfo(Logger logCore, String msg) {
        logCore.info(msg);
    }

    private static void logError(Logger logCore, String msg) {
        logCore.error(msg);
    }

    private static void logError(Logger logCore, String msg, Throwable e) {
        logCore.error(msg, e);
    }

    public static synchronized void initializeService(ConfigurazionePdDManager configReader, ClassNameProperties className, OpenSPCoop2Properties propertiesReader, Logger logCore) throws Exception {
        if (initializeService) {
            return;
        }
        Loader loader = Loader.getInstance();
        PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
        String classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
        try {
            INodeSender nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
            nodeSender.toString();
            RicezioneContenutiApplicativi.logInfo(logCore, "Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + " effettuata.");
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
        String classType = className.getNodeReceiver(propertiesReader.getNodeReceiver());
        try {
            INodeReceiver nodeReceiver = (INodeReceiver)loader.newInstance(classType);
            nodeReceiver.toString();
            RicezioneContenutiApplicativi.logInfo(logCore, "Inizializzazione gestore NodeReceiver di tipo " + classType + " effettuata.");
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
        }
        defaultGestoriIntegrazionePD = propertiesReader.getTipoIntegrazionePD();
        for (int i = 0; i < defaultGestoriIntegrazionePD.length; ++i) {
            try {
                IGestoreIntegrazionePD gestore = pluginLoader.newIntegrazionePortaDelegata(defaultGestoriIntegrazionePD[i]);
                gestore.toString();
                RicezioneContenutiApplicativi.logInfo(logCore, "Inizializzazione gestore dati di integrazione per le fruizioni di tipo " + defaultGestoriIntegrazionePD[i] + " effettuata.");
                continue;
            }
            catch (Exception e) {
                throw new Exception(e.getMessage(), e);
            }
        }
        defaultPerProtocolloGestoreIntegrazionePD = new ConcurrentHashMap();
        Enumeration enumProtocols = ProtocolFactoryManager.getInstance().getProtocolNames();
        while (enumProtocols.hasMoreElements()) {
            String protocol = (String)enumProtocols.nextElement();
            String[] tipiIntegrazionePD = propertiesReader.getTipoIntegrazionePD(protocol);
            if (tipiIntegrazionePD == null || tipiIntegrazionePD.length <= 0) continue;
            ArrayList<String> tipiIntegrazionePerProtocollo = new ArrayList<String>();
            for (int i = 0; i < tipiIntegrazionePD.length; ++i) {
                try {
                    IGestoreIntegrazionePD gestore = pluginLoader.newIntegrazionePortaDelegata(tipiIntegrazionePD[i]);
                    gestore.toString();
                    tipiIntegrazionePerProtocollo.add(tipiIntegrazionePD[i]);
                    logCore.info("Inizializzazione gestore dati di integrazione (protocollo: " + protocol + ") per le fruizioni di tipo " + tipiIntegrazionePD[i] + " effettuata.");
                    continue;
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
            if (tipiIntegrazionePerProtocollo.size() <= 0) continue;
            defaultPerProtocolloGestoreIntegrazionePD.put(protocol, tipiIntegrazionePerProtocollo.toArray(new String[1]));
        }
        tipiGestoriCredenziali = propertiesReader.getTipoGestoreCredenzialiPD();
        if (tipiGestoriCredenziali != null) {
            for (int i = 0; i < tipiGestoriCredenziali.length; ++i) {
                classType = className.getGestoreCredenziali(tipiGestoriCredenziali[i]);
                try {
                    IGestoreCredenziali gestore = (IGestoreCredenziali)loader.newInstance(classType);
                    gestore.toString();
                    logCore.info("Inizializzazione gestore credenziali di tipo " + tipiGestoriCredenziali[i] + " effettuata.");
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione delle credenziali di tipo [" + tipiGestoriCredenziali[i] + "]: " + e.getMessage());
                }
            }
        }
        initializeService = true;
    }

    public RicezioneContenutiApplicativi(RicezioneContenutiApplicativiContext context, RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore) {
        this.msgContext = context;
        this.generatoreErrore = generatoreErrore;
    }

    public void process(Object ... params) {
        String tipo;
        OpenSPCoop2Properties properties;
        PdDContext context = this.msgContext.getPddContext();
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = LoggerWrapperFactory.getLogger((String)ID_MODULO);
        }
        MsgDiagnostico msgDiag = this.msgContext.getMsgDiagnostico();
        OpenSPCoop2Message requestMessage = this.msgContext.getMessageRequest();
        if (requestMessage == null) {
            this.setSOAPFault(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, logCore, msgDiag, new Exception("Request message is null"), "LetturaMessaggioRichiesta");
            return;
        }
        IProtocolFactory protocolFactory = null;
        try {
            if (context == null) {
                throw new Exception("Context is null");
            }
            protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)context.getObject(Costanti.PROTOCOL_NAME));
        }
        catch (Exception e) {
            this.setSOAPFault(IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, logCore, msgDiag, e, "ProtocolFactoryInstance");
            return;
        }
        InRequestContext inRequestContext = new InRequestContext(logCore, protocolFactory, null);
        inRequestContext.setTipoPorta(TipoPdD.DELEGATA);
        inRequestContext.setIdModulo(this.msgContext.getIdModulo());
        InfoConnettoreIngresso connettore = new InfoConnettoreIngresso();
        connettore.setCredenziali(this.msgContext.getCredenziali());
        if (this.msgContext.getUrlProtocolContext() != null && this.msgContext.getUrlProtocolContext().getHttpServletRequest() != null && (properties = OpenSPCoop2Properties.getInstance()) != null && (tipo = properties.getRealContainerCustom()) != null) {
            try {
                ClassNameProperties className = ClassNameProperties.getInstance();
                Loader loader = Loader.getInstance();
                String tipoClass = className.getRealmContainerCustom(tipo);
                IAutorizzazioneSecurityContainer authEngine = (IAutorizzazioneSecurityContainer)loader.newInstance(tipoClass);
                authEngine.init(this.msgContext.getUrlProtocolContext().getHttpServletRequest(), context, protocolFactory);
                AutorizzazioneHttpServletRequest httpServletRequestAuth = new AutorizzazioneHttpServletRequest(this.msgContext.getUrlProtocolContext().getHttpServletRequest(), authEngine);
                this.msgContext.getUrlProtocolContext().updateHttpServletRequest((HttpServletRequest)httpServletRequestAuth);
            }
            catch (Exception e) {
                this.setSOAPFault(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, logCore, msgDiag, e, "AutorizzazioneSecurityContainerInstance");
                return;
            }
        }
        connettore.setUrlProtocolContext(this.msgContext.getUrlProtocolContext());
        if (ServiceBinding.SOAP.equals((Object)requestMessage.getServiceBinding())) {
            try {
                connettore.setSoapAction(requestMessage.castAsSoap().getSoapAction());
            }
            catch (Exception e) {
                this.setSOAPFault(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, logCore, msgDiag, e, "LetturaSoapAction");
                return;
            }
        }
        connettore.setFromLocation(this.msgContext.getSourceLocation());
        inRequestContext.setConnettore(connettore);
        inRequestContext.setDataAccettazioneRichiesta(this.msgContext.getDataAccettazioneRichiesta());
        inRequestContext.setDataElaborazioneMessaggio(this.msgContext.getDataIngressoRichiesta());
        inRequestContext.setPddContext(context);
        inRequestContext.setMessaggio(requestMessage);
        try {
            GestoreHandlers.inRequest(inRequestContext, msgDiag, logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFault(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, logCore, msgDiag, e, "InvocazioneInRequestHandler");
            return;
        }
        HashMap<String, Object> internalObjects = new HashMap<String, Object>();
        try {
            this.process_engine(inRequestContext, internalObjects, params);
        }
        catch (TracciamentoException e) {
            this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, (Exception)((Object)e), "TracciamentoNonRiuscito");
            return;
        }
        catch (DumpException e) {
            this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, (Exception)((Object)e), "DumpNonRiuscito");
            return;
        }
        catch (ProtocolException e) {
            this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, (Exception)((Object)e), "InstanziazioneProtocolFactoryNonRiuscita");
            return;
        }
        try {
            if (context != null && this.msgContext.getIntegrazione() != null) {
                if (context.containsKey(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RICHIESTA)) {
                    this.msgContext.getIntegrazione().setTipoProcessamentoMtomXopRichiesta((String)context.getObject(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RICHIESTA));
                }
                if (context.containsKey(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RISPOSTA)) {
                    this.msgContext.getIntegrazione().setTipoProcessamentoMtomXopRisposta((String)context.getObject(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RISPOSTA));
                }
                if (context.containsKey(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RICHIESTA)) {
                    this.msgContext.getIntegrazione().setTipoMessageSecurityRichiesta((String)context.getObject(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RICHIESTA));
                }
                if (context.containsKey(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RISPOSTA)) {
                    this.msgContext.getIntegrazione().setTipoMessageSecurityRisposta((String)context.getObject(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RISPOSTA));
                }
            }
        }
        catch (Exception e) {
            this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, e, "FinalizeIntegrationContextRicezioneContenutiApplicativi");
            return;
        }
        if (!internalObjects.containsKey("DumpRichiestaEffettuato") && Dump.isSistemaDumpDisponibile()) {
            try {
                OpenSPCoop2Message msgRichiesta;
                URLProtocolContext urlProtocolContext;
                ConfigurazionePdDManager configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                if (!internalObjects.containsKey("DumpConfig") && (urlProtocolContext = this.msgContext.getUrlProtocolContext()) != null && urlProtocolContext.getInterfaceName() != null) {
                    IDPortaDelegata identificativoPortaDelegata = new IDPortaDelegata();
                    identificativoPortaDelegata.setNome(urlProtocolContext.getInterfaceName());
                    PortaDelegata portaDelegata = configurazionePdDReader.getPortaDelegataSafeMethod(identificativoPortaDelegata, this.msgContext.getRequestInfo());
                    if (portaDelegata != null) {
                        DumpConfigurazione dumpConfig = configurazionePdDReader.getDumpConfigurazione(portaDelegata);
                        internalObjects.put("DumpConfig", dumpConfig);
                    }
                }
                if ((msgRichiesta = inRequestContext.getMessaggio()) != null) {
                    Dump dumpApplicativo = this.getDump(configurazionePdDReader, protocolFactory, internalObjects, msgDiag.getPorta());
                    dumpApplicativo.dumpRichiestaIngresso(msgRichiesta, inRequestContext.getConnettore().getUrlProtocolContext());
                }
            }
            catch (DumpException e) {
                this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, (Exception)((Object)e), "DumpNonRiuscito");
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        OutResponseContext outResponseContext = new OutResponseContext(logCore, protocolFactory, null);
        outResponseContext.setTipoPorta(this.msgContext.getTipoPorta());
        outResponseContext.setIdModulo(this.msgContext.getIdModulo());
        outResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
        outResponseContext.setPddContext(inRequestContext.getPddContext());
        outResponseContext.setProtocollo(this.msgContext.getProtocol());
        outResponseContext.setIntegrazione(this.msgContext.getIntegrazione());
        outResponseContext.setResponseHeaders(this.msgContext.getResponseHeaders());
        OpenSPCoop2Message msgResponse = this.msgContext.getMessageResponse();
        outResponseContext.setMessaggio(msgResponse);
        try {
            GestoreHandlers.outResponse(outResponseContext, msgDiag, logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, e, "InvocazioneOutResponseHandler");
            return;
        }
        OpenSPCoop2Message msgRisposta = null;
        try {
            msgRisposta = outResponseContext.getMessaggio();
            boolean rispostaPresente = true;
            OpenSPCoop2Properties properties2 = OpenSPCoop2Properties.getInstance();
            if (properties2 != null) {
                rispostaPresente = ServicesUtils.verificaRispostaRelazioneCodiceTrasporto202(protocolFactory, OpenSPCoop2Properties.getInstance(), msgRisposta, true);
            }
            if (rispostaPresente) {
                this.msgContext.setMessageResponse(msgRisposta);
            } else {
                this.msgContext.setMessageResponse(null);
                msgRisposta = null;
            }
        }
        catch (Exception e) {
            this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, e, "FineGestioneRicezioneContenutiApplicativi");
            return;
        }
        if (Dump.isSistemaDumpDisponibile()) {
            try {
                ConfigurazionePdDManager configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                if (msgRisposta != null) {
                    Dump dumpApplicativo = this.getDump(configurazionePdDReader, protocolFactory, internalObjects, msgDiag.getPorta());
                    if (outResponseContext.getResponseHeaders() == null) {
                        outResponseContext.setResponseHeaders(new HashMap<String, List<String>>());
                    }
                    Map<String, List<String>> propertiesTrasporto = outResponseContext.getResponseHeaders();
                    ServicesUtils.setGovWayHeaderResponse(requestMessage.getServiceBinding(), msgRisposta, OpenSPCoop2Properties.getInstance(), propertiesTrasporto, logCore, true, outResponseContext.getPddContext(), this.msgContext.getRequestInfo());
                    dumpApplicativo.dumpRispostaUscita(msgRisposta, inRequestContext.getConnettore().getUrlProtocolContext(), outResponseContext.getResponseHeaders());
                }
            }
            catch (DumpException e) {
                this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(context), logCore, msgDiag, (Exception)((Object)e), "DumpNonRiuscito");
            }
            catch (Exception e) {
                RicezioneContenutiApplicativi.logError(logCore, e.getMessage(), e);
            }
        }
    }

    private Dump getDump(ConfigurazionePdDManager configurazionePdDReader, IProtocolFactory<?> protocolFactory, HashMap<String, Object> internalObjects, String nomePorta) throws DumpException, DriverRegistroServiziException {
        DumpConfigurazione dumpConfig = null;
        dumpConfig = internalObjects.containsKey("DumpConfig") ? (DumpConfigurazione)internalObjects.get("DumpConfig") : configurazionePdDReader.getDumpConfigurazionePortaDelegata();
        ProtocolContext protocolContext = this.msgContext.getProtocol();
        URLProtocolContext urlProtocolContext = this.msgContext.getUrlProtocolContext();
        IDSoggetto soggettoErogatore = null;
        IDServizio idServizio = null;
        IDSoggetto fruitore = null;
        IDSoggetto dominio = null;
        String idRichiesta = null;
        if (protocolContext != null) {
            if (protocolContext.getTipoServizio() != null && protocolContext.getServizio() != null && protocolContext.getVersioneServizio() != null && protocolContext.getErogatore() != null && protocolContext.getErogatore().getTipo() != null && protocolContext.getErogatore().getNome() != null) {
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(protocolContext.getTipoServizio(), protocolContext.getServizio(), protocolContext.getErogatore(), protocolContext.getVersioneServizio().intValue());
            }
            dominio = protocolContext.getDominio();
            idRichiesta = protocolContext.getIdRichiesta();
            if (protocolContext.getFruitore() != null && protocolContext.getFruitore().getTipo() != null && protocolContext.getFruitore().getNome() != null) {
                fruitore = protocolContext.getFruitore();
            }
        }
        if ((dominio == null || fruitore == null || idServizio == null) && urlProtocolContext != null && urlProtocolContext.getInterfaceName() != null) {
            IDPortaDelegata identificativoPortaDelegata = new IDPortaDelegata();
            identificativoPortaDelegata.setNome(urlProtocolContext.getInterfaceName());
            PortaDelegata portaDelegata = null;
            try {
                portaDelegata = configurazionePdDReader.getPortaDelegataSafeMethod(identificativoPortaDelegata, this.msgContext.getRequestInfo());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (portaDelegata != null) {
                soggettoErogatore = new IDSoggetto(portaDelegata.getSoggettoErogatore().getTipo(), portaDelegata.getSoggettoErogatore().getNome());
                if (portaDelegata.getServizio() != null) {
                    idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaDelegata.getServizio().getTipo(), portaDelegata.getServizio().getNome(), soggettoErogatore, portaDelegata.getServizio().getVersione().intValue());
                }
                dominio = new IDSoggetto(portaDelegata.getTipoSoggettoProprietario(), portaDelegata.getNomeSoggettoProprietario());
                fruitore = new IDSoggetto(portaDelegata.getTipoSoggettoProprietario(), portaDelegata.getNomeSoggettoProprietario());
                try {
                    dominio.setCodicePorta(RegistroServiziManager.getInstance().getDominio(dominio, null, protocolFactory, this.msgContext.getRequestInfo()));
                }
                catch (Exception e) {
                    dominio = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocolFactory.getProtocol(), this.msgContext.getRequestInfo());
                }
            }
        }
        if (idServizio != null) {
            if (protocolContext != null && protocolContext.getAzione() != null) {
                idServizio.setAzione(protocolContext.getAzione());
            } else if (this.msgContext.getRequestInfo() != null && this.msgContext.getRequestInfo().getIdServizio() != null && this.msgContext.getRequestInfo().getIdServizio().getAzione() != null) {
                idServizio.setAzione(this.msgContext.getRequestInfo().getIdServizio().getAzione());
            }
        }
        if (dominio == null) {
            dominio = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocolFactory.getProtocol(), this.msgContext.getRequestInfo());
        }
        Dump dumpApplicativo = null;
        dumpApplicativo = idServizio != null ? new Dump(dominio, this.msgContext.getIdModulo(), idRichiesta, fruitore, idServizio, this.msgContext.getTipoPorta(), nomePorta, this.msgContext.getPddContext(), null, null, dumpConfig) : new Dump(dominio, this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), nomePorta, this.msgContext.getPddContext(), null, null, dumpConfig);
        return dumpApplicativo;
    }

    private void setSOAPFault(IntegrationFunctionError integrationFunctionError, Logger logCore, MsgDiagnostico msgDiag, Exception e, String posizione) {
        HandlerException he = null;
        if (e != null && e instanceof HandlerException) {
            he = (HandlerException)e;
        }
        if (msgDiag != null) {
            if (he != null) {
                if (he.isEmettiDiagnostico()) {
                    msgDiag.logErroreGenerico(e, posizione);
                }
            } else {
                msgDiag.logErroreGenerico(e, posizione);
            }
        } else if (e != null) {
            RicezioneContenutiApplicativi.logError(logCore, posizione + ": " + e.getMessage(), e);
        } else {
            RicezioneContenutiApplicativi.logError(logCore, posizione);
        }
        IntegrationFunctionError ifError = integrationFunctionError;
        if (he != null && he.getIntegrationFunctionError() != null) {
            ifError = he.getIntegrationFunctionError();
        }
        ErroreIntegrazione erroreIntegrazioneGenerato = null;
        if (he != null) {
            erroreIntegrazioneGenerato = he.convertToErroreIntegrazione();
        }
        if (this.msgContext.isGestioneRisposta()) {
            Object posizioneFault = null;
            posizioneFault = e != null ? posizione + ": " + e.getMessage() : posizione;
            if (erroreIntegrazioneGenerato == null) {
                erroreIntegrazioneGenerato = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((String)posizioneFault);
            }
            OpenSPCoop2Message messageFault = this.generatoreErrore.build((Context)this.msgContext.getPddContext(), ifError, erroreIntegrazioneGenerato, e, null);
            this.msgContext.setMessageResponse(messageFault);
        }
    }

    private boolean checkInizializzazione(Logger logCore, ConfigurazionePdDManager configurazionePdDReader, RegistroServiziManager registroServiziReader, PdDContext pddContext) {
        if (!OpenSPCoop2Startup.initialize) {
            String msgErrore = "Inizializzazione di GovWay non correttamente effettuata";
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "InizializzazioneGovWay");
                }
            }
            catch (Throwable t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), null, null));
            }
            return false;
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            String msgErrore = "Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage();
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore, TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "InizializzazioneRisorseGovWay");
                }
            }
            catch (Throwable t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_532_RISORSE_NON_DISPONIBILI), null, null));
            }
            return false;
        }
        if (!TimerThresholdThread.freeSpace) {
            String msgErrore = "Non sono disponibili abbastanza risorse per la gestione della richiesta";
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "DisponibilitaRisorseGovWay");
                }
            }
            catch (Throwable t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_533_RISORSE_DISPONIBILI_LIVELLO_CRITICO), null, null));
            }
            return false;
        }
        if (!Tracciamento.tracciamentoDisponibile) {
            String msgErrore = "Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage();
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore, Tracciamento.motivoMalfunzionamentoTracciamento);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "Tracciamento");
                }
            }
            catch (Throwable t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_545_TRACCIATURA_NON_FUNZIONANTE), null, null));
            }
            return false;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            String msgErrore = "Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage();
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore, MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "Diagnostica");
                }
            }
            catch (Throwable t) {
                RicezioneContenutiApplicativi.logDebug(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_546_DIAGNOSTICA_NON_FUNZIONANTE), null, null));
            }
            return false;
        }
        if (!Dump.isSistemaDumpDisponibile()) {
            String msgErrore = "Sistema di dump dei contenuti applicativi non disponibile: " + Dump.getMotivoMalfunzionamentoDump().getMessage();
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore, Dump.getMotivoMalfunzionamentoDump());
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "Dump");
                }
            }
            catch (Throwable t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_547_DUMP_CONTENUTI_APPLICATIVI_NON_FUNZIONANTE), null, null));
            }
            return false;
        }
        try {
            configurazionePdDReader.verificaConsistenzaConfigurazione();
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato errore durante la verifica della consistenza della configurazione";
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore, e);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "CheckConfigurazioneGovWay");
                }
            }
            catch (Throwable t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), null, null));
            }
            return false;
        }
        try {
            registroServiziReader.verificaConsistenzaRegistroServizi();
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato errore durante la verifica del registro dei servizi";
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore, e);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "CheckRegistroServizi");
                }
            }
            catch (Throwable t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita: " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_534_REGISTRO_DEI_SERVIZI_NON_DISPONIBILE), null, null));
            }
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private void process_engine(InRequestContext inRequestContext, HashMap<String, Object> internalObjects, Object ... params) throws TracciamentoException, DumpException, ProtocolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [323[CATCHBLOCK]], but top level block is 29[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setCredenziali(Credenziali credenziali, MsgDiagnostico msgDiag) {
        if (credenziali != null) {
            if (credenziali.getUsername() != null) {
                msgDiag.setServizioApplicativo("username(" + credenziali.getUsername() + ")");
            } else if (credenziali.getSubject() != null) {
                msgDiag.setServizioApplicativo("subject(" + credenziali.getSubject() + ")");
            } else if (credenziali.getPrincipal() != null) {
                msgDiag.setServizioApplicativo("principal(" + credenziali.getPrincipal() + ")");
            } else {
                msgDiag.setServizioApplicativo(null);
            }
        }
        String credenzialiFornite = "";
        if (credenziali != null) {
            credenzialiFornite = credenziali.toString();
        }
        msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean comportamentoStateless(RicezioneContenutiApplicativiGestioneRisposta parametriGestioneRisposta, ImbustamentoMessage imbustamentoMSG) {
        OpenSPCoopStateless openspcoopstate = (OpenSPCoopStateless)parametriGestioneRisposta.getOpenspcoopstate();
        ConfigurazionePdDManager configurazionePdDReader = parametriGestioneRisposta.getConfigurazionePdDReader();
        RegistroServiziManager registroServiziReader = parametriGestioneRisposta.getRegistroServiziReader();
        MsgDiagnostico msgDiag = parametriGestioneRisposta.getMsgDiag();
        Logger logCore = parametriGestioneRisposta.getLogCore();
        OpenSPCoop2Properties propertiesReader = parametriGestioneRisposta.getPropertiesReader();
        String idMessageRequest = parametriGestioneRisposta.getIdMessageRequest();
        GestoreMessaggi msgRequest = parametriGestioneRisposta.getMsgRequest();
        parametriGestioneRisposta.setPortaStateless(true);
        boolean rinegoziamentoConnessione = propertiesReader.isRinegoziamentoConnessione(this.msgContext.getProtocol().getProfiloCollaborazione()) && !parametriGestioneRisposta.isOneWayVers11();
        boolean localForward = parametriGestioneRisposta.isLocalForward();
        String idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, imbustamentoMSG.getPddContext());
        PdDContext pddContext = parametriGestioneRisposta.getPddContext();
        if (localForward) {
            if ("ConsegnaContenutiApplicativi".equals(openspcoopstate.getDestinatarioRequestMsgLib()) && openspcoopstate.getDestinatarioResponseMsgLib() == null) {
                EsitoLib esito;
                if (rinegoziamentoConnessione) {
                    msgDiag.highDebug("ConsegnaContenutiApplicativi stateless (commit) ...");
                    openspcoopstate.setUseConnection(true);
                    try {
                        openspcoopstate.commit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    openspcoopstate.releaseResource();
                    openspcoopstate.setUseConnection(false);
                }
                ConsegnaContenutiApplicativi consegnaContenutiLib = null;
                try {
                    consegnaContenutiLib = new ConsegnaContenutiApplicativi(logCore);
                    esito = consegnaContenutiLib.onMessage(openspcoopstate);
                    if (esito.getStatoInvocazione() == 3) {
                        if (esito.getErroreNonGestito() != null) {
                            throw esito.getErroreNonGestito();
                        }
                        throw new Exception("Errore non gestito");
                    }
                }
                catch (Throwable e) {
                    msgDiag.logErroreGenerico(e, "Stateless.ConsegnaContenutiApplicativi");
                    RicezioneContenutiApplicativi.logError(logCore, "Errore Generale durante la gestione stateless: " + e.getMessage(), e);
                    msgRequest.deleteMessageFromFileSystem();
                    openspcoopstate.setUseConnection(true);
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, null));
                    }
                    return false;
                }
                if (esito.getStatoInvocazione() != 1) {
                    openspcoopstate.setUseConnection(true);
                    this.gestioneRisposta(parametriGestioneRisposta);
                    return false;
                }
            }
        } else {
            EsitoLib esito;
            msgDiag.highDebug("Imbustamento stateless ...");
            Imbustamento imbustamentoLib = null;
            openspcoopstate.setMessageLib(imbustamentoMSG);
            openspcoopstate.setIDMessaggioSessione(idMessageRequest);
            try {
                imbustamentoLib = new Imbustamento(logCore);
                msgDiag.highDebug("Imbustamento stateless (invoco) ...");
                esito = imbustamentoLib.onMessage(openspcoopstate);
                msgDiag.highDebug("Imbustamento stateless (analizzo esito) ...");
                if (esito.getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new Exception("Errore non gestito");
                }
            }
            catch (Throwable e) {
                msgDiag.logErroreGenerico(e, "Stateless.Imbustamento");
                RicezioneContenutiApplicativi.logError(logCore, "Errore Generale durante la gestione stateless: " + e.getMessage(), e);
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, null));
                }
                return false;
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstate.setUseConnection(true);
                this.gestioneRisposta(parametriGestioneRisposta);
                msgDiag.highDebug("Imbustamento stateless (terminato:false)");
                return false;
            }
            if (openspcoopstate.getDestinatarioResponseMsgLib() != null && openspcoopstate.getDestinatarioResponseMsgLib().startsWith(ID_MODULO) && propertiesReader.isGestioneOnewayStateful_1_1()) {
                msgDiag.highDebug("Imbustamento stateless (terminato:true)");
                return true;
            }
            if (rinegoziamentoConnessione) {
                msgDiag.highDebug("Imbustamento stateless (commit) ...");
                openspcoopstate.setUseConnection(true);
                try {
                    openspcoopstate.commit();
                }
                catch (Exception e) {
                    // empty catch block
                }
                openspcoopstate.releaseResource();
                openspcoopstate.setUseConnection(false);
            }
            msgDiag.highDebug("Imbustamento stateless terminato");
            msgDiag.highDebug("InoltroBuste stateless ...");
            InoltroBuste inoltroBusteLib = null;
            try {
                inoltroBusteLib = new InoltroBuste(logCore);
                msgDiag.highDebug("InoltroBuste stateless (invoco) ...");
                esito = inoltroBusteLib.onMessage(openspcoopstate);
                msgDiag.highDebug("InoltroBuste stateless (analizzo esito) ...");
                if (esito.getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new Exception("Errore non gestito");
                }
            }
            catch (Throwable e) {
                msgDiag.logErroreGenerico(e, "Stateless.InoltroBuste");
                RicezioneContenutiApplicativi.logError(logCore, "Errore Generale durante la gestione stateless: " + e.getMessage(), e);
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, null));
                }
                return false;
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstate.setUseConnection(true);
                this.gestioneRisposta(parametriGestioneRisposta);
                msgDiag.highDebug("InoltroBuste stateless (terminato:false)");
                return false;
            }
            if (openspcoopstate.getDestinatarioResponseMsgLib() != null && openspcoopstate.getDestinatarioResponseMsgLib().startsWith(ID_MODULO)) {
                msgDiag.highDebug("InoltroBuste stateless (terminato:true)");
                return true;
            }
            msgDiag.highDebug("InoltroBuste stateless terminato");
            msgDiag.highDebug("SbustamentoRisposte stateless ...");
            SbustamentoRisposte sbustamentoRisposteLib = null;
            boolean erroreSbustamentoRisposta = false;
            try {
                sbustamentoRisposteLib = new SbustamentoRisposte(logCore);
                if (rinegoziamentoConnessione && openspcoopstate.resourceReleased()) {
                    registroServiziReader = registroServiziReader.refreshState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
                    configurazionePdDReader = configurazionePdDReader.refreshState(registroServiziReader);
                    msgDiag.updateState(configurazionePdDReader);
                }
                msgDiag.highDebug("SbustamentoRisposte stateless (invoco) ...");
                esito = sbustamentoRisposteLib.onMessage(openspcoopstate);
                msgDiag.highDebug("SbustamentoRisposte stateless (analizzo esito) ...");
                if (esito.getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new Exception("Errore non gestito");
                }
            }
            catch (Throwable e) {
                erroreSbustamentoRisposta = true;
                msgDiag.logErroreGenerico(e, "Stateless.SbustamentoRisposte");
                RicezioneContenutiApplicativi.logError(logCore, "Errore Generale durante la gestione stateless: " + e.getMessage(), e);
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, null));
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (rinegoziamentoConnessione && !erroreSbustamentoRisposta) {
                    msgDiag.highDebug("SbustamentoRisposte stateless (commit) ...");
                    openspcoopstate.setUseConnection(true);
                    try {
                        openspcoopstate.commit();
                    }
                    catch (Exception exception) {}
                    openspcoopstate.releaseResource();
                    openspcoopstate.setUseConnection(false);
                }
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstate.setUseConnection(true);
                this.gestioneRisposta(parametriGestioneRisposta);
                msgDiag.highDebug("SbustamentoRisposte stateless (terminato:false)");
                return false;
            }
            msgDiag.highDebug("SbustamentoRisposte stateless terminato");
        }
        return true;
    }

    private void gestioneRisposta(RicezioneContenutiApplicativiGestioneRisposta parametriGestioneRisposta) {
        HashMap<String, List<String>> propertiesIntegrazioneRisposta;
        OutResponsePDMessage outResponsePDMessage;
        OpenSPCoop2Message responseMessage;
        ProfiloDiCollaborazione profiloCollaborazione;
        String idMessageResponse;
        boolean errorOccurs_setResponse;
        PddPluginLoader pluginLoader;
        IProtocolFactory<?> protocolFactory;
        RequestInfo requestInfo;
        String idTransazione;
        PdDContext pddContext;
        boolean richiestaAsincronaSimmetricaStateless;
        boolean oneWayVers11;
        boolean portaStateless;
        GestoreMessaggi msgRequest;
        String[] tipiIntegrazionePD;
        HeaderIntegrazione headerIntegrazioneRisposta;
        HeaderIntegrazione headerIntegrazioneRichiesta;
        String servizioApplicativo;
        String idMessageRequest;
        OpenSPCoop2Properties propertiesReader;
        Logger logCore;
        MsgDiagnostico msgDiag;
        IOpenSPCoopState openspcoopstate;
        block80: {
            String idCorrelazioneApplicativaRisposta;
            String profiloCollaborazioneValue;
            String idCollaborazioneResponse;
            Busta bustaRichiesta;
            block79: {
                openspcoopstate = parametriGestioneRisposta.getOpenspcoopstate();
                msgDiag = parametriGestioneRisposta.getMsgDiag();
                logCore = parametriGestioneRisposta.getLogCore();
                propertiesReader = parametriGestioneRisposta.getPropertiesReader();
                IDSoggetto identitaPdD = parametriGestioneRisposta.getIdentitaPdD();
                idMessageRequest = parametriGestioneRisposta.getIdMessageRequest();
                servizioApplicativo = parametriGestioneRisposta.getServizioApplicativo();
                headerIntegrazioneRichiesta = parametriGestioneRisposta.getHeaderIntegrazioneRichiesta();
                headerIntegrazioneRisposta = parametriGestioneRisposta.getHeaderIntegrazioneRisposta();
                tipiIntegrazionePD = parametriGestioneRisposta.getTipiIntegrazionePD();
                msgRequest = parametriGestioneRisposta.getMsgRequest();
                portaStateless = parametriGestioneRisposta.isPortaStateless();
                oneWayVers11 = parametriGestioneRisposta.isOneWayVers11();
                richiestaAsincronaSimmetricaStateless = parametriGestioneRisposta.isRichiestaAsincronaSimmetricaStateless();
                pddContext = parametriGestioneRisposta.getPddContext();
                idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, pddContext);
                requestInfo = (RequestInfo)pddContext.getObject(Costanti.REQUEST_INFO);
                protocolFactory = parametriGestioneRisposta.getProtocolFactory();
                bustaRichiesta = parametriGestioneRisposta.getBustaRichiesta();
                Loader loader = Loader.getInstance();
                pluginLoader = PddPluginLoader.getInstance();
                errorOccurs_setResponse = false;
                idMessageResponse = null;
                idCollaborazioneResponse = null;
                profiloCollaborazione = null;
                profiloCollaborazioneValue = null;
                responseMessage = null;
                idCorrelazioneApplicativaRisposta = null;
                try {
                    if (portaStateless || oneWayVers11) {
                        RicezioneContenutiApplicativiMessage ricezioneContenutiApplicativiMSG = (RicezioneContenutiApplicativiMessage)((OpenSPCoopStateless)openspcoopstate).getMessageLib();
                        idMessageResponse = ricezioneContenutiApplicativiMSG.getIdBustaRisposta();
                        idCollaborazioneResponse = ricezioneContenutiApplicativiMSG.getIdCollaborazione();
                        profiloCollaborazione = ricezioneContenutiApplicativiMSG.getProfiloCollaborazione();
                        profiloCollaborazioneValue = ricezioneContenutiApplicativiMSG.getProfiloCollaborazioneValue();
                        responseMessage = ((OpenSPCoopStateless)openspcoopstate).getRispostaMsg();
                        idCorrelazioneApplicativaRisposta = ((OpenSPCoopStateless)openspcoopstate).getIDCorrelazioneApplicativaRisposta();
                        if (!ProfiloDiCollaborazione.ONEWAY.equals((Object)profiloCollaborazione)) {
                            this.msgContext.getProtocol().setIdRisposta(idMessageResponse);
                        }
                        this.msgContext.getProtocol().setCollaborazione(idCollaborazioneResponse);
                        msgDiag.setIdMessaggioRisposta(idMessageResponse);
                        msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", idMessageResponse);
                        break block79;
                    }
                    try {
                        List enumPddContext;
                        responseMessage = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getIntegrationRequestMessageType(), (MessageRole)MessageRole.RESPONSE);
                        String classType = null;
                        INodeReceiver nodeReceiver = null;
                        try {
                            classType = ClassNameProperties.getInstance().getNodeReceiver(propertiesReader.getNodeReceiver());
                            nodeReceiver = (INodeReceiver)loader.newInstance(classType);
                        }
                        catch (Exception e) {
                            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
                        }
                        msgDiag.mediumDebug("Attesa/lettura risposta...");
                        RicezioneContenutiApplicativiMessage ricezioneContenutiApplicativiMSG = (RicezioneContenutiApplicativiMessage)nodeReceiver.receive(msgDiag, identitaPdD, this.msgContext.getIdModulo(), idMessageRequest, propertiesReader.getNodeReceiverTimeoutRicezioneContenutiApplicativi(), propertiesReader.getNodeReceiverCheckInterval());
                        idMessageResponse = ricezioneContenutiApplicativiMSG.getIdBustaRisposta();
                        idCollaborazioneResponse = ricezioneContenutiApplicativiMSG.getIdCollaborazione();
                        profiloCollaborazione = ricezioneContenutiApplicativiMSG.getProfiloCollaborazione();
                        profiloCollaborazioneValue = ricezioneContenutiApplicativiMSG.getProfiloCollaborazioneValue();
                        pddContext = ricezioneContenutiApplicativiMSG.getPddContext();
                        if (pddContext != null && (enumPddContext = pddContext.keys()) != null && !enumPddContext.isEmpty()) {
                            for (MapKey key : enumPddContext) {
                                this.msgContext.getPddContext().addObject(key, pddContext.getObject(key));
                            }
                        }
                        if (!ProfiloDiCollaborazione.ONEWAY.equals((Object)profiloCollaborazione)) {
                            this.msgContext.getProtocol().setIdRisposta(idMessageResponse);
                        }
                        this.msgContext.getProtocol().setCollaborazione(idCollaborazioneResponse);
                    }
                    catch (Exception e) {
                        RicezioneContenutiApplicativi.logError(logCore, "Gestione risposta (" + this.msgContext.getIdModulo() + ") con errore", e);
                        msgDiag.logErroreGenerico(e, "GestioneRispostaErroreGenerale");
                        if (e instanceof NodeTimeoutException) {
                            try {
                                openspcoopstate.updateResource(idTransazione);
                            }
                            catch (Exception eDB) {
                                msgDiag.logErroreGenerico(e, "openspcoopstate.updateResource()");
                                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), eDB, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                                return;
                            }
                            try {
                                msgDiag.logPersonalizzato("timeoutRicezioneRisposta");
                                msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                                openspcoopstate.commit();
                            }
                            catch (Exception eDel) {
                                msgDiag.logErroreGenerico(eDel, "EliminazioneMessaggioScadutoTimeoutRicezioneRisposta");
                            }
                            openspcoopstate.releaseResource();
                        }
                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_513_RECEIVE), e, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                        return;
                    }
                    msgDiag.setIdMessaggioRisposta(idMessageResponse);
                    msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", idMessageResponse);
                    msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                    try {
                        openspcoopstate.updateResource(idTransazione);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "openspcoopstate.updateResource()");
                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), e, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                        return;
                    }
                    msgRequest.updateOpenSPCoopState(openspcoopstate);
                    msgDiag.mediumDebug("Lettura messaggio di risposta...");
                    GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idMessageResponse, "INBOX", msgDiag, this.msgContext.pddContext);
                    try {
                        responseMessage = msgResponse.getMessage();
                        if (responseMessage != null && this.msgContext.getPddContext() != null) {
                            Object o = responseMessage.getContextProperty(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO);
                            if (o != null && o instanceof Boolean) {
                                this.msgContext.getPddContext().addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                            }
                            if ((o = responseMessage.getContextProperty(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) != null && o instanceof ParseException) {
                                this.msgContext.getPddContext().addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, o);
                            }
                            if ((o = responseMessage.getContextProperty(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO)) != null && o instanceof Boolean) {
                                this.msgContext.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, true);
                            }
                            if ((o = responseMessage.getContextProperty(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) != null && o instanceof ParseException) {
                                this.msgContext.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, o);
                            }
                        }
                        idCorrelazioneApplicativaRisposta = msgResponse.getIDCorrelazioneApplicativaRisposta();
                    }
                    catch (GestoreMessaggiException e) {
                        msgDiag.logErroreGenerico(e, "msgResponse.getMessage()");
                        openspcoopstate.releaseResource();
                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_511_READ_RESPONSE_MSG), e, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                        return;
                    }
                }
                catch (Exception e) {
                    RicezioneContenutiApplicativi.logError(logCore, "ErroreGenerale", e);
                    msgDiag.logErroreGenerico(e, "ErroreGenerale");
                    openspcoopstate.releaseResource();
                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                    errorOccurs_setResponse = true;
                }
            }
            msgDiag.setIdCorrelazioneRisposta(idCorrelazioneApplicativaRisposta);
            if (this.msgContext.getProtocol() != null) {
                this.msgContext.getProtocol().setProfiloCollaborazione(profiloCollaborazione, profiloCollaborazioneValue);
            }
            if (this.msgContext.getIntegrazione() != null) {
                this.msgContext.getIntegrazione().setIdCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
            }
            msgDiag.mediumDebug("Gestione header di integrazione messaggio di risposta...");
            headerIntegrazioneRisposta.getBusta().setIdCollaborazione(idCollaborazioneResponse);
            headerIntegrazioneRisposta.getBusta().setProfiloDiCollaborazione(profiloCollaborazione);
            String jtiIdModIRequest = null;
            Object bustaRispostaObject = null;
            if (pddContext != null) {
                if (pddContext.containsKey(Costanti.MODI_JTI_REQUEST_ID)) {
                    jtiIdModIRequest = (String)pddContext.get(Costanti.MODI_JTI_REQUEST_ID);
                }
                if (pddContext.containsKey(CostantiPdD.BUSTA_RISPOSTA)) {
                    bustaRispostaObject = pddContext.getObject(CostantiPdD.BUSTA_RISPOSTA);
                }
            }
            if (jtiIdModIRequest != null && StringUtils.isNotEmpty(jtiIdModIRequest) && !jtiIdModIRequest.equals(idMessageRequest)) {
                headerIntegrazioneRisposta.getBusta().setID(jtiIdModIRequest);
            } else {
                headerIntegrazioneRisposta.getBusta().setID(idMessageRequest);
            }
            outResponsePDMessage = new OutResponsePDMessage();
            outResponsePDMessage.setBustaRichiesta(bustaRichiesta);
            Busta bustaRisposta = null;
            if (bustaRispostaObject instanceof Busta) {
                bustaRisposta = (Busta)bustaRispostaObject;
            } else if (bustaRispostaObject == null && "sdi".equalsIgnoreCase(protocolFactory.getProtocol()) && pddContext != null) {
                Object idSdiObject;
                Object nomeFileSDIObject;
                if (pddContext.containsKey(CostantiPdD.BUSTA_RICHIESTA_SDI_NOME_FILE) && (nomeFileSDIObject = pddContext.getObject(CostantiPdD.BUSTA_RICHIESTA_SDI_NOME_FILE)) instanceof String) {
                    outResponsePDMessage.getBustaRichiesta().addProperty("NomeFile", (String)nomeFileSDIObject);
                }
                if (pddContext.containsKey(CostantiPdD.BUSTA_RICHIESTA_SDI_IDENTIFICATIVO_SDI) && (idSdiObject = pddContext.getObject(CostantiPdD.BUSTA_RICHIESTA_SDI_IDENTIFICATIVO_SDI)) instanceof String) {
                    outResponsePDMessage.getBustaRichiesta().addProperty("IdentificativoSdI", (String)idSdiObject);
                }
            }
            if (bustaRisposta != null && bustaRisposta.sizeProperties() > 0) {
                String[] propertyNames = bustaRisposta.getPropertiesNames();
                for (int i = 0; i < propertyNames.length; ++i) {
                    outResponsePDMessage.getBustaRichiesta().addProperty(propertyNames[i], bustaRisposta.getProperty(propertyNames[i]));
                }
            }
            outResponsePDMessage.setMessage(responseMessage);
            outResponsePDMessage.setPortaDelegata(parametriGestioneRisposta.getPortaDelegata());
            propertiesIntegrazioneRisposta = new HashMap<String, List<String>>();
            outResponsePDMessage.setHeaders(propertiesIntegrazioneRisposta);
            outResponsePDMessage.setServizio(parametriGestioneRisposta.getIdServizio());
            outResponsePDMessage.setSoggettoMittente(parametriGestioneRisposta.getSoggettoMittente());
            if (this.msgContext.getIdModulo().startsWith(ID_MODULO + IntegrationManager.ID_MODULO)) {
                try {
                    IGestoreIntegrazionePD gestore = null;
                    gestore = pluginLoader.newIntegrazionePortaDelegata("trasporto");
                    if (gestore == null) break block80;
                    String classType = null;
                    try {
                        classType = gestore.getClass().getName();
                        AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante l'inizializzazione della classe [" + classType + "] da utilizzare per la gestione dell'integrazione delle fruizioni (Risposta IM) di tipo [trasporto]: " + e.getMessage());
                    }
                    gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePDMessage);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "setHeaderIntegrazioneRisposta");
                }
            }
        }
        for (int i = 0; i < tipiIntegrazionePD.length; ++i) {
            try {
                IGestoreIntegrazionePD gestore = null;
                gestore = pluginLoader.newIntegrazionePortaDelegata(tipiIntegrazionePD[i]);
                if (gestore != null) {
                    String classType = null;
                    try {
                        classType = gestore.getClass().getName();
                        AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante l'inizializzazione della classe [" + classType + "] da utilizzare per la gestione dell'integrazione delle fruizioni (Risposta) di tipo [" + tipiIntegrazionePD[i] + "]: " + e.getMessage());
                    }
                    if (gestore instanceof IGestoreIntegrazionePDSoap) {
                        if (propertiesReader.processHeaderIntegrazionePDResponse(false)) {
                            if (propertiesReader.deleteHeaderIntegrazioneResponsePD()) {
                                if (responseMessage == null) {
                                    responseMessage = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getIntegrationRequestMessageType(), (MessageRole)MessageRole.RESPONSE);
                                    outResponsePDMessage.setMessage(responseMessage);
                                }
                                gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePDMessage);
                            }
                            continue;
                        }
                        if (responseMessage == null) {
                            responseMessage = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getIntegrationRequestMessageType(), (MessageRole)MessageRole.RESPONSE);
                            outResponsePDMessage.setMessage(responseMessage);
                        }
                        gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePDMessage);
                        continue;
                    }
                    gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePDMessage);
                    continue;
                }
                throw new Exception("Gestore non inizializzato");
            }
            catch (Exception e) {
                msgDiag.addKeyword("@TIPO_HEADER_INTEGRAZIONE@", tipiIntegrazionePD[i]);
                msgDiag.addKeywordErroreProcessamento(e);
                msgDiag.logPersonalizzato("headerIntegrazione.creazioneFallita");
                RicezioneContenutiApplicativi.logError(logCore, msgDiag.getMessaggio_replaceKeywords("headerIntegrazione.creazioneFallita"), e);
            }
        }
        this.msgContext.setResponseHeaders(propertiesIntegrazioneRisposta);
        if (!portaStateless) {
            this.eliminaSIL((OpenSPCoopStateful)openspcoopstate, msgDiag, idMessageRequest, idMessageResponse, servizioApplicativo);
        }
        if (portaStateless && !oneWayVers11) {
            msgDiag.mediumDebug("Aggiorno proprietario messaggio richiesta ...");
            try {
                if (richiestaAsincronaSimmetricaStateless) {
                    boolean resourceReleased = openspcoopstate.resourceReleased();
                    if (resourceReleased) {
                        ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                        openspcoopstate.updateResource(idTransazione);
                    }
                    GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idMessageResponse, "INBOX", msgDiag, this.msgContext.pddContext);
                    msgResponse.setReadyForDrop(true);
                    msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    msgResponse.setReadyForDrop(false);
                    msgRequest.updateOpenSPCoopState(openspcoopstate);
                    msgRequest.setReadyForDrop(true);
                    msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    msgRequest.setReadyForDrop(false);
                }
                openspcoopstate.commit();
            }
            catch (Exception e) {
                RicezioneContenutiApplicativi.logError(logCore, "Errore durante l'aggiornamento del proprietario al GestoreMessaggi (Stateless)", e);
                msgDiag.logErroreGenerico(e, "openspcoopstate.commit(stateless risposta)");
                openspcoopstate.releaseResource();
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                errorOccurs_setResponse = true;
            }
        }
        if (oneWayVers11) {
            msgDiag.mediumDebug("Commit della gestione oneWay stateful/stateless...");
            try {
                openspcoopstate.commit();
            }
            catch (Exception e) {
                RicezioneContenutiApplicativi.logError(logCore, "Riscontrato errore durante il commit della gestione oneWay stateful/stateless", e);
                msgDiag.logErroreGenerico(e, "openspcoopstate.commit(oneway1.1 risposta)");
                openspcoopstate.releaseResource();
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                errorOccurs_setResponse = true;
            }
        }
        msgDiag.mediumDebug("Rilascio connessione al database...");
        openspcoopstate.releaseResource();
        if (profiloCollaborazione != null) {
            if (profiloCollaborazione.equals((Object)ProfiloDiCollaborazione.SINCRONO)) {
                msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "risposta sincrona");
                msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            } else if (profiloCollaborazione.equals((Object)ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO)) {
                if (headerIntegrazioneRichiesta != null && headerIntegrazioneRichiesta.getBusta() != null && headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona simmetrica");
                } else {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona simmetrica");
                }
                msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            } else if (profiloCollaborazione.equals((Object)ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO)) {
                if (headerIntegrazioneRichiesta != null && headerIntegrazioneRichiesta.getBusta() != null && headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona asimmetrica");
                } else {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona asimmetrica");
                }
                msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            }
        }
        msgDiag.mediumDebug("Imposto risposta nel context...");
        if (!errorOccurs_setResponse) {
            this.msgContext.setMessageResponse(responseMessage);
        }
    }

    private void eliminaSIL(OpenSPCoopStateful openspcoopstate, MsgDiagnostico msgDiag, String idMessageRequest, String idMessageResponse, String servizioApplicativo) {
        msgDiag.mediumDebug("Eliminazione SIL destinatario del messaggio nella tabelle MSG_SERVIZI_APPLICATIVI...");
        if (openspcoopstate.getConnectionDB() != null) {
            try {
                GestoreMessaggi gestoreEliminazioneDestinatario = new GestoreMessaggi(openspcoopstate, false, idMessageResponse, "INBOX", msgDiag, this.msgContext.pddContext);
                gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(servizioApplicativo, idMessageRequest);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(" + servizioApplicativo + ")");
            }
        } else {
            msgDiag.logErroreGenerico("Connessione non disponibile", "gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(" + servizioApplicativo + ")");
        }
    }
}

