/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.error;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.config.ConfigurationRFC7807;
import org.openspcoop2.message.config.FaultBuilderConfig;
import org.openspcoop2.message.config.IntegrationErrorCollection;
import org.openspcoop2.message.config.IntegrationErrorConfiguration;
import org.openspcoop2.message.config.IntegrationErrorReturnConfiguration;
import org.openspcoop2.message.constants.IntegrationError;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.error.RicezioneContenutiApplicativiInternalErrorGenerator;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.ErroriProperties;
import org.openspcoop2.utils.transport.http.HttpServletTransportRequestContext;
import org.slf4j.Logger;

public abstract class AbstractErrorGenerator {
    protected boolean internalErrorConfiguration;
    protected Logger log;
    protected IProtocolFactory<?> protocolFactory;
    protected String idModulo;
    protected IDSoggetto identitaPdD;
    protected IDSoggetto mittente;
    protected IDServizio idServizio;
    protected String servizioApplicativo;
    protected OpenSPCoop2Properties openspcoopProperties;
    protected RequestInfo requestInfo;
    protected MessageType requestMessageType;
    protected ServiceBinding serviceBinding;
    protected TipoPdD tipoPdD;
    protected MessageType forceMessageTypeResponse;

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public void updateTipoPdD(TipoPdD tipoPdD) {
        this.tipoPdD = tipoPdD;
    }

    public void setForceMessageTypeResponse(MessageType forceMessageTypeResponse) {
        this.forceMessageTypeResponse = forceMessageTypeResponse;
    }

    protected AbstractErrorGenerator(Logger log, String idModulo, RequestInfo requestInfo, TipoPdD tipoPdD, boolean internalErrorConfiguration) throws ProtocolException {
        this.log = log;
        this.protocolFactory = requestInfo.getProtocolFactory();
        this.idModulo = idModulo;
        this.identitaPdD = requestInfo.getIdentitaPdD();
        this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        this.requestInfo = requestInfo;
        this.tipoPdD = tipoPdD;
        this.internalErrorConfiguration = internalErrorConfiguration;
        if (TipoPdD.APPLICATIVA.equals((Object)tipoPdD)) {
            this.requestMessageType = requestInfo.getProtocolRequestMessageType();
            this.serviceBinding = requestInfo.getProtocolServiceBinding();
        } else {
            this.requestMessageType = requestInfo.getIntegrationRequestMessageType();
            this.serviceBinding = requestInfo.getIntegrationServiceBinding();
        }
    }

    protected String getInterfaceName() {
        String nomePorta = null;
        if (this.requestInfo != null && this.requestInfo.getProtocolContext() != null) {
            nomePorta = this.requestInfo.getProtocolContext().getInterfaceName();
        }
        return nomePorta;
    }

    public void updateRequestMessageType(MessageType requestMessageType) {
        this.requestMessageType = requestMessageType;
    }

    public void updateServiceBinding(ServiceBinding serviceBinding) {
        this.serviceBinding = serviceBinding;
    }

    public void updateDominio(IDSoggetto identitaPdD) {
        this.identitaPdD = identitaPdD;
    }

    public void updateInformazioniCooperazione(IDSoggetto mittente, IDServizio idServizio) {
        this.mittente = mittente;
        this.idServizio = idServizio;
    }

    public void updateInformazioniCooperazione(String servizioApplicativo) {
        this.servizioApplicativo = servizioApplicativo;
    }

    protected IntegrationErrorConfiguration getConfigurationForError(IntegrationError integrationError) {
        IntegrationErrorCollection errorCollection = null;
        errorCollection = this.internalErrorConfiguration ? this.requestInfo.getBindingConfig().getInternalIntegrationErrorConfiguration(this.serviceBinding) : this.requestInfo.getBindingConfig().getExternalIntegrationErrorConfiguration(this.serviceBinding);
        IntegrationErrorConfiguration config = errorCollection.getIntegrationError(integrationError);
        if (config == null) {
            config = errorCollection.getIntegrationError(IntegrationError.DEFAULT);
        }
        return config;
    }

    protected MessageType getMessageTypeForError(IntegrationError integrationError) {
        IntegrationErrorConfiguration config = this.getConfigurationForError(integrationError);
        return config.getMessageType((HttpServletTransportRequestContext)this.requestInfo.getProtocolContext(), this.serviceBinding, this.requestMessageType);
    }

    protected IntegrationErrorReturnConfiguration getReturnConfigForError(IntegrationError integrationError) {
        IntegrationErrorConfiguration config = this.getConfigurationForError(integrationError);
        IntegrationErrorReturnConfiguration configR = config.getErrorReturnConfig();
        boolean portaDelegata = this instanceof RicezioneContenutiApplicativiInternalErrorGenerator;
        if (portaDelegata) {
            configR.setRetryAfterSeconds(this.openspcoopProperties.getServiceUnavailableRetryAfterSecondsPD().intValue());
            configR.setRetryRandomBackoffSeconds(this.openspcoopProperties.getServiceUnavailableRetryAfterSecondsRandomBackoffPD().intValue());
        } else {
            configR.setRetryAfterSeconds(this.openspcoopProperties.getServiceUnavailableRetryAfterSecondsPA().intValue());
            configR.setRetryRandomBackoffSeconds(this.openspcoopProperties.getServiceUnavailableRetryAfterSecondsRandomBackoffPA().intValue());
        }
        return configR;
    }

    protected boolean isUseInternalFault(IntegrationError integrationError) {
        IntegrationErrorConfiguration config = this.getConfigurationForError(integrationError);
        return config.isUseInternalFault();
    }

    protected ConfigurationRFC7807 getRfc7807ForError(IntegrationError integrationError) {
        IntegrationErrorConfiguration config = this.getConfigurationForError(integrationError);
        return config.getRfc7807();
    }

    protected MessageType getMessageTypeForErrorSafeMode(IntegrationError integrationError) {
        MessageType msgTypeErrorResponse = null;
        try {
            msgTypeErrorResponse = this.requestMessageType;
            msgTypeErrorResponse = this.forceMessageTypeResponse != null ? this.forceMessageTypeResponse : this.getMessageTypeForError(integrationError);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msgTypeErrorResponse;
    }

    protected ConfigurationRFC7807 getRfc7807ForErrorSafeMode(IntegrationError integrationError) {
        ConfigurationRFC7807 rfc7807 = null;
        try {
            rfc7807 = this.getRfc7807ForError(integrationError);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rfc7807;
    }

    public static IntegrationFunctionError getIntegrationInternalError(Context context) {
        String s;
        Object o;
        IntegrationFunctionError integrationError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
        if (context != null && context.containsKey(Costanti.RICHIESTA_INOLTRATA_BACKEND) && (o = context.getObject(Costanti.RICHIESTA_INOLTRATA_BACKEND)) != null && o instanceof String && "true".equals(s = (String)o)) {
            integrationError = IntegrationFunctionError.INTERNAL_RESPONSE_ERROR;
        }
        return integrationError;
    }

    private FaultBuilderConfig getFaultBuilderConfig(ErroriProperties erroriProperties, IntegrationFunctionError integrationFunctionError, MessageType msgTypeErrorResponse, boolean useProblemRFC7807, String errore) {
        try {
            boolean genericDetails;
            FaultBuilderConfig config = new FaultBuilderConfig();
            IntegrationError integrationError = erroriProperties.getIntegrationError(integrationFunctionError);
            IntegrationErrorReturnConfiguration returnConfig = this.getReturnConfigForError(integrationError);
            config.setHttpReturnCode(Integer.valueOf(returnConfig.getHttpReturnCode()));
            config.setGovwayReturnCode(Integer.valueOf(returnConfig.getGovwayReturnCode()));
            config.setRfc7807Type(erroriProperties.isTypeEnabled());
            config.setRfc7807WebSite(erroriProperties.getWebSite(integrationFunctionError));
            if (MessageType.SOAP_11.equals((Object)msgTypeErrorResponse) || MessageType.SOAP_12.equals((Object)msgTypeErrorResponse) || !useProblemRFC7807) {
                config.setActor(this.openspcoopProperties.getProprietaGestioneErrorePD(this.protocolFactory.createProtocolManager()).getFaultActor());
            }
            Object codiceEccezioneGW = org.openspcoop2.protocol.basic.Costanti.getTransactionSoapFaultCode((int)returnConfig.getGovwayReturnCode(), (String)erroriProperties.getErrorType(integrationFunctionError));
            if (MessageType.SOAP_11.equals((Object)msgTypeErrorResponse) || MessageType.SOAP_12.equals((Object)msgTypeErrorResponse)) {
                if (MessageType.SOAP_11.equals((Object)msgTypeErrorResponse)) {
                    String code11 = "Server";
                    if (returnConfig.getGovwayReturnCode() <= 499) {
                        code11 = "Client";
                    }
                    codiceEccezioneGW = code11 + "." + (String)codiceEccezioneGW;
                }
                QName eccezioneNameGovway = null;
                if (MessageType.SOAP_11.equals((Object)msgTypeErrorResponse)) {
                    String prefix = "SOAP-ENV";
                    eccezioneNameGovway = new QName("http://schemas.xmlsoap.org/soap/envelope/", (String)codiceEccezioneGW, prefix);
                    config.setPrefixSoap(prefix);
                } else {
                    eccezioneNameGovway = this.getProtocolFactory().createErroreApplicativoBuilder().getQNameEccezioneIntegrazione(this.openspcoopProperties.getProprietaGestioneErrorePD(this.protocolFactory.createProtocolManager()).getDefaultFaultCodeIntegrationNamespace(), (String)codiceEccezioneGW);
                }
                config.setErrorCode(eccezioneNameGovway);
            }
            if (!(genericDetails = returnConfig.isGenericDetails()) && erroriProperties.isForceGenericDetails(integrationFunctionError).booleanValue()) {
                genericDetails = true;
            }
            if (org.openspcoop2.protocol.basic.Costanti.isTRANSACTION_FORCE_SPECIFIC_ERROR_DETAILS()) {
                genericDetails = false;
            }
            if (errore != null && !"null".equals(errore) && !genericDetails) {
                config.setDetails(errore);
            } else {
                config.setDetails(erroriProperties.getGenericDetails(integrationFunctionError));
            }
            String govwayType = erroriProperties.getErrorType(integrationFunctionError);
            config.setHeaderErrorTypeName(this.openspcoopProperties.getErroriHttpHeaderGovWayType());
            config.setHeaderErrorTypeValue(govwayType);
            if (org.openspcoop2.protocol.basic.Costanti.isPROBLEM_RFC7807_ENRICH_TITLE_AS_GOVWAY_TYPE().booleanValue()) {
                if (org.openspcoop2.protocol.basic.Costanti.isPROBLEM_RFC7807_ENRICH_TITLE_AS_GOVWAY_TYPE_CAMEL_CASE_DECODE().booleanValue()) {
                    config.setRfc7807Title(StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)govwayType), (char)' '));
                } else {
                    config.setRfc7807Title(govwayType);
                }
                if (org.openspcoop2.protocol.basic.Costanti.isPROBLEM_RFC7807_ENRICH_TITLE_AS_GOVWAY_TYPE_CUSTOM_CLAIM().booleanValue()) {
                    config.setRfc7807GovWayTypeHeaderErrorTypeName(org.openspcoop2.protocol.basic.Costanti.getPROBLEM_RFC7807_GOVWAY_TYPE());
                    config.setRfc7807GovWayTypeHeaderErrorTypeValue(govwayType);
                }
            } else {
                config.setRfc7807GovWayTypeHeaderErrorTypeName(org.openspcoop2.protocol.basic.Costanti.getPROBLEM_RFC7807_GOVWAY_TYPE());
                config.setRfc7807GovWayTypeHeaderErrorTypeValue(govwayType);
            }
            return config;
        }
        catch (Throwable t) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("FaultBuilderConfig non costruibile: " + t.getMessage(), t);
            return null;
        }
    }

    protected IntegrationError convertToIntegrationError(IntegrationFunctionError integrationFunctionError) {
        ErroriProperties erroriProperties = null;
        IntegrationError integrationError = null;
        try {
            erroriProperties = ErroriProperties.getInstance((Logger)this.log);
            integrationError = erroriProperties.getIntegrationError(integrationFunctionError);
        }
        catch (Throwable t) {
            integrationError = IntegrationError.INTERNAL_REQUEST_ERROR;
        }
        return integrationError;
    }

    public OpenSPCoop2Message buildFault(Throwable e, Context context) {
        IntegrationFunctionError integrationFunctionError = AbstractErrorGenerator.getIntegrationInternalError(context);
        return this._buildFault(e, context, integrationFunctionError);
    }

    public OpenSPCoop2Message buildFault(Throwable e, Context context, IntegrationFunctionError integrationFunctionError) {
        return this._buildFault(e, context, integrationFunctionError);
    }

    public OpenSPCoop2Message _buildFault(Throwable e, Context context, IntegrationFunctionError integrationFunctionError) {
        ErroriProperties erroriProperties = null;
        IntegrationError integrationError = null;
        try {
            erroriProperties = ErroriProperties.getInstance((Logger)this.log);
            integrationError = erroriProperties.getIntegrationError(integrationFunctionError);
        }
        catch (Throwable t) {
            integrationError = IntegrationError.INTERNAL_REQUEST_ERROR;
        }
        boolean useProblemRFC7807 = this.getRfc7807ForErrorSafeMode(integrationError) != null;
        MessageType msgTypeErrorResponse = this.getMessageTypeForErrorSafeMode(integrationError);
        FaultBuilderConfig config = null;
        if (erroriProperties != null) {
            config = this.getFaultBuilderConfig(erroriProperties, integrationFunctionError, msgTypeErrorResponse, useProblemRFC7807, e != null ? e.getMessage() : null);
        }
        OpenSPCoop2Message msgFault = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createFaultMessage(msgTypeErrorResponse, useProblemRFC7807, config, e);
        return msgFault;
    }

    public OpenSPCoop2Message buildFault(String errore, Context context) {
        IntegrationFunctionError integrationFunctionError = AbstractErrorGenerator.getIntegrationInternalError(context);
        return this._buildFault(errore, context, integrationFunctionError);
    }

    public OpenSPCoop2Message buildFault(String errore, Context context, IntegrationFunctionError integrationFunctionError) {
        return this._buildFault(errore, context, integrationFunctionError);
    }

    private OpenSPCoop2Message _buildFault(String errore, Context context, IntegrationFunctionError integrationFunctionError) {
        ErroriProperties erroriProperties = null;
        IntegrationError integrationError = null;
        try {
            erroriProperties = ErroriProperties.getInstance((Logger)this.log);
            integrationError = erroriProperties.getIntegrationError(integrationFunctionError);
        }
        catch (Throwable t) {
            integrationError = IntegrationError.INTERNAL_REQUEST_ERROR;
            integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
        }
        boolean useProblemRFC7807 = this.getRfc7807ForErrorSafeMode(integrationError) != null;
        MessageType msgTypeErrorResponse = this.getMessageTypeForErrorSafeMode(integrationError);
        FaultBuilderConfig config = null;
        if (erroriProperties != null) {
            config = this.getFaultBuilderConfig(erroriProperties, integrationFunctionError, msgTypeErrorResponse, useProblemRFC7807, errore);
        }
        OpenSPCoop2Message msgFault = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createFaultMessage(msgTypeErrorResponse, useProblemRFC7807, config, errore);
        return msgFault;
    }
}

