/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.skeleton;

import javax.servlet.http.HttpServletRequest;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.pdd.services.skeleton.IntegrationManagerException;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.sdk.AbstractEccezioneBuilderParameter;
import org.openspcoop2.protocol.sdk.EccezioneIntegrazioneBuilderParameters;
import org.openspcoop2.protocol.sdk.EccezioneProtocolloBuilderParameters;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.utils.ErroriProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class IntegrationManagerUtility {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void readAndSetProtocol(HttpServletRequest req, String pathinfo) throws IntegrationManagerException {
        String protocol = (String)req.getAttribute((String)((Object)Costanti.PROTOCOL_NAME.getValue()));
        if (protocol != null) {
            try {
                ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
                return;
            }
            catch (ProtocolException e) {
                boolean ok = false;
                try {
                    Openspcoop2 manifest = ProtocolFactoryManager.getInstance().getProtocolManifest(protocol);
                    req.setAttribute((String)((Object)Costanti.PROTOCOL_NAME.getValue()), (Object)manifest.getProtocol().getName());
                    return;
                }
                catch (ProtocolException manifest) {
                    // empty catch block
                }
                if (ok) return;
                throw new RuntimeException(e);
            }
        }
        String protocolName = pathinfo = pathinfo.substring(pathinfo.indexOf("/", 1) + 1);
        if (pathinfo.indexOf("/") != -1) {
            try {
                String servletPath = pathinfo.substring(0, pathinfo.indexOf("/"));
                if (servletPath.equals("PA") || servletPath.equals("PD") || servletPath.equals("PDtoSOAP") || servletPath.equals("IntegrationManager")) {
                    servletPath = "@EMPTY@";
                }
                Openspcoop2 manifest = ProtocolFactoryManager.getInstance().getProtocolManifest(servletPath);
                protocolName = manifest.getProtocol().getName();
            }
            catch (ProtocolException e) {
                throw new RuntimeException(e);
            }
        }
        req.setAttribute((String)((Object)Costanti.PROTOCOL_NAME.getValue()), (Object)protocolName);
    }

    public static IntegrationManagerException mapXMLIntoProtocolException(IProtocolFactory<?> protocolFactory, String xml, String prefixCodiceErroreApplicativoIntegrazione, IntegrationFunctionError functionError, ErroriProperties erroriProperties) throws Exception {
        MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
        Document document = xmlUtils.newDocument(xml.getBytes());
        return IntegrationManagerUtility.mapXMLIntoProtocolException(protocolFactory, document.getFirstChild(), prefixCodiceErroreApplicativoIntegrazione, functionError, erroriProperties);
    }

    public static IntegrationManagerException mapXMLIntoProtocolException(IProtocolFactory<?> protocolFactory, Node xml, String prefixCodiceErroreApplicativoIntegrazione, IntegrationFunctionError functionError, ErroriProperties erroriProperties) throws Exception {
        AbstractEccezioneBuilderParameter eccezione = protocolFactory.createErroreApplicativoBuilder().readErroreApplicativo(xml, prefixCodiceErroreApplicativoIntegrazione);
        IntegrationManagerException exc = null;
        if (eccezione instanceof EccezioneProtocolloBuilderParameters) {
            EccezioneProtocolloBuilderParameters eccBusta = (EccezioneProtocolloBuilderParameters)eccezione;
            exc = new IntegrationManagerException(protocolFactory, eccBusta.getEccezioneProtocollo(), functionError, erroriProperties);
        } else {
            EccezioneIntegrazioneBuilderParameters eccIntegrazione = (EccezioneIntegrazioneBuilderParameters)eccezione;
            exc = new IntegrationManagerException(protocolFactory, eccIntegrazione.getErroreIntegrazione(), functionError, erroriProperties);
        }
        exc.setOraRegistrazione(protocolFactory.createTraduttore().getDate_protocolFormat(eccezione.getOraRegistrazione()));
        exc.setIdentificativoFunzione(eccezione.getIdFunzione());
        exc.setIdentificativoPorta(eccezione.getDominioPorta().getCodicePorta());
        return exc;
    }

    public static IntegrationManagerException mapMessageIntoProtocolException(OpenSPCoop2SoapMessage message, String faultCode, String faultString, IDSoggetto identitaPdD, String identificativoFunzione) throws Exception {
        Object govwayPrefixCodeInContextProperty = message.getContextProperty(org.openspcoop2.message.constants.Costanti.ERRORE_GOVWAY_PREFIX_CODE);
        Object govwayCodeInContextProperty = message.getContextProperty(org.openspcoop2.message.constants.Costanti.ERRORE_GOVWAY_CODE);
        if (govwayPrefixCodeInContextProperty != null && govwayCodeInContextProperty != null) {
            return new IntegrationManagerException(message, faultCode, faultString, identitaPdD, identificativoFunzione);
        }
        return null;
    }
}

