/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.driver.IPolicyGroupByActiveThreadsInMemory;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyShutdownException;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.GestorePolicyAttiveInMemory;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.PolicyGroupByActiveThreads;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.PolicyGroupByActiveThreadsDistributedLocalCache;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerClusteredRateLimitingLocalCache
extends BaseThread {
    private final GestorePolicyAttiveInMemory gestorePolicy;
    private Logger log = null;

    public TimerClusteredRateLimitingLocalCache(Logger log, GestorePolicyAttiveInMemory gestorePolicy) {
        this.log = log;
        this.gestorePolicy = gestorePolicy;
    }

    protected void process() {
        try {
            this.log.info("Sync RateLimiting policy counters ...");
            this.updateLocalCacheMap();
            this.log.info("Sync RateLimiting policy counters finished");
        }
        catch (PolicyException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (PolicyShutdownException e) {
            this.setStop(true);
        }
    }

    private void updateLocalCacheMap() throws PolicyShutdownException, PolicyException {
        Set<Map.Entry<String, IPolicyGroupByActiveThreadsInMemory>> activeThreadsPolicies = this.gestorePolicy.entrySet();
        for (Map.Entry<String, IPolicyGroupByActiveThreadsInMemory> policy : activeThreadsPolicies) {
            this.log.debug("[" + policy.getKey() + "] update ...");
            PolicyGroupByActiveThreadsDistributedLocalCache distributedPolicy = (PolicyGroupByActiveThreadsDistributedLocalCache)policy.getValue();
            HashMap<IDUnivocoGroupByPolicy, DatiCollezionati> mapActiveThreads = new HashMap<IDUnivocoGroupByPolicy, DatiCollezionati>();
            for (Map.Entry entry : distributedPolicy.getDistributedMapActiveThreads().entrySet()) {
                mapActiveThreads.put((IDUnivocoGroupByPolicy)entry.getKey(), (DatiCollezionati)entry.getValue());
            }
            PolicyGroupByActiveThreads localPolicy = distributedPolicy.getLocalPolicy();
            localPolicy.setMapActiveThreads(mapActiveThreads);
            this.log.debug("[" + policy.getKey() + "] update ok");
        }
    }
}

